<?php
/**
 *
 * Show the product details page
 *
 * @package	VirtueMart
 * @subpackage
 * @author Max Milbers, Valerie Isaksen

 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version $Id: default_relatedproducts.php 6431 2012-09-12 12:31:31Z alatak $
 */

// Check to ensure this file is included in Joomla!
defined ( '_JEXEC' ) or die ( 'Restricted access' );
	if (!defined('DS')) define('DS', DIRECTORY_SEPARATOR);

if (!class_exists( 'CurrencyDisplay' )) require(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_virtuemart'.DS.'helpers'.DS.'currencydisplay.php');
?>
<div class="product-related layout module_new">

<h3 class="module-title"><?php  echo JText::_('COM_VIRTUEMART_RELATED_PRODUCTS'); ?></h3>
 <div class="product-related-products vmgroup_new">
    <?php
		$product_model = VmModel::getModel('product');
		$ratingModel = VmModel::getModel('ratings');
		$mainframe = Jfactory::getApplication();
		$virtuemart_currency_id = $mainframe->getUserStateFromRequest( "virtuemart_currency_id", 'virtuemart_currency_id',JRequest::getInt('virtuemart_currency_id',0) );

	$releted = array();
	//var_dump ($this->product->customfieldsSorted['related_products']);
    foreach ($this->product->customfieldsSorted['related_products'] as $field) {
		//print_r($this);
		$releted[] = $field->customfield_value;
		//var_dump($releted);
	 } 
	 $prods_releted = $product_model->getProducts($releted);

		//var_dump ($releted);
		$product_model->addImages($prods_releted); 
		$currency = CurrencyDisplay::getInstance( );
	 ?>
			<div class="list_carousel responsive">
					
                
                <ul id="slider" class="vmproduct">
                <?php            
			 foreach($prods_releted as $product) { 
			 $this->product2 = $product;
			 if (isset($this->product2->step_order_level))
						$step=$this->product2->step_order_level;
					else
						$step=1;
					if($step==0)
						$step=1;
					$alert=JText::sprintf ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED', $step);
					$discont = $this->product2->prices['discountAmount'];
					$discont = abs($discont);
					$show_price = $currency->createPriceDiv('salesPrice', '', $this->product2->prices,true);
					//print_r ($show_price);

			 	if (!empty($this->product2->product_name)) {
			 ?>
 <li>
       <input type="hidden" class="quick_ids" name="virtuemart_product_id" value="<?php echo $product->virtuemart_product_id ?>"/>

  <div class="prod-row">
  <?php if (($this->product2->prices['override'] == -1 || $this->product2->prices['override'] == 1) &&  ($this->product2->prices['product_price_publish_down'] > 0)){
						 $data = $this->product2->prices['product_price_publish_down'];
						$data = explode(' ', $data);
						$time = explode(':', $data[1]);
						$data = explode('-', $data[0]);
						//var_dump($data);
						 $year = $data[0];
						 $month = $data[1];
						 $data = $data[2];
						//var_dump($time);
							?>
							<div class="count_holder_small">
							<div class="count_info"><?php echo JText::_('DR_LIMITED')?></div>
							<div id="CountSmallFeatured<?php echo $this->product2->virtuemart_product_id ?>" class="count_border">
							 <script type="text/javascript">
							jQuery(function () {    
								jQuery('#CountSmallFeatured<?php echo $this->product2->virtuemart_product_id ?>').countdown({
									until: new Date(<?php echo $year; ?>, <?php echo $month; ?> - 1, <?php echo $data; ?>), 
									labels: ['Years', 'Months', 'Weeks', '<?php echo JText::_('DR_DAYS')?>', '<?php echo JText::_('DR_HOURS')?>', '<?php echo JText::_('DR_MINUTES')?>', '<?php echo JText::_('DR_SECONDS')?>'],
									compact: false});
							});
							 </script>
							 </div>
							 </div>
						  <?php } ?>
 <div class="product-box front_w spacer <?php if ($discont>0) { echo 'disc';} ?> ">
    <div class="browseImage ">
     <?php
		$stockhandle = VmConfig::get ('stockhandle', 'none');
		if (($stockhandle == 'disableit' or $stockhandle == 'disableadd') and (($this->product2->product_in_stock - $this->product2->product_ordered) < 1) || 
				(($this->product2->product_in_stock - $this->product2->product_ordered) < $this->product2->min_order_level ))  { ?>
				<div class="discount sold"><?php echo JText::_('DR_SOLD');?></div>
		 <?php } ?>  
     <?php if (($this->product2->prices['override'] == -1 || $this->product2->prices['override'] == 1) &&  ($this->product2->prices['product_price_publish_down'] > 0)){ ?>
        <div class="discount limited"><?php echo JText::_('DR_LIMITED_OFFER');?></div>
          <?php } elseif($discont >0 && $this->product2->product_sales < 5 ) { ?>
     <div class="discount"><?php echo JText::_('DR_SALE');?></div>
		<?php } elseif ($this->product2->product_sales > 0) {?>
          <div class="hit"><?php echo JText::_('DR_HOT');?></div>
          <?php } ?>
         <?php
			if (!empty($this->product2->images[0]) ){
					$image = $this->product2->images[0]->displayMediaThumb('class="browseProductImage featuredProductImage" id="Img_to_Js_'.$this->product2->virtuemart_product_id.'" border="0"',false) ;}
				else {$image = '';}
					echo JHTML::_('link', JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='.$this->product2->virtuemart_product_id.'&virtuemart_category_id='.$this->product2->virtuemart_category_id),$image,array('class' => 'noSwipe'));
			?>
			
    
	</div>
		
        
            <div class="Title">
            <?php echo JHTML::link(JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='.$this->product2->virtuemart_product_id.'&virtuemart_category_id='.$this->product2->virtuemart_category_id), shopFunctionsF::limitStringByWord($this->product2->product_name,'40','...'), array('title' => $this->product2->product_name)); ?>
        	</div>
    <?php if (( !empty($this->product2->prices['salesPrice'])) && !$this->product2->images[0]->file_is_downloadable) { ?>
        <div class="Price" id="productPrice<?php echo $this->product2->virtuemart_product_id ?>">
			<?php if ($this->product2->prices['basePriceWithTax']>0 && $discont>0)
                echo '<span class="WithoutTax">'.$currency->createPriceDiv('basePriceWithTax', '', $this->product2->prices,true).'</span>';
            ?>
            <?php if ($this->product2->prices['salesPrice']>0)
                echo '<span class="sales">' .$currency->createPriceDiv('salesPrice', '', $this->product2->prices,true).'</span>';
            ?>
            <?php if ($discont>0)
                echo '<span class="discount">' .$currency->createPriceDiv('discountAmount', '', $this->product2->prices,true).'</span>';
            ?>
            
         </div>
         <?php  } else {
									if ($product->prices['salesPrice']<=0 and VmConfig::get ('askprice', 1) ) { ?>
									<div class="call-a-question">
                                     	<a class="call modal"  rel="{handler: 'iframe', size: {x: 460, y: 550}}" href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id='.$product->virtuemart_product_id.'&virtuemart_category_id='.$product->virtuemart_category_id.'&tmpl=component'); ?>" ><?php echo JText::_('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?></a>
                                    </div>
									<?php } } ?>
    </div>
    <div class="product-box hover back_w spacer <?php if ($discont>0) { echo 'disc';} ?> ">
            <div class="browseImage ">
             <?php
		$stockhandle = VmConfig::get ('stockhandle', 'none');
		if (($stockhandle == 'disableit' or $stockhandle == 'disableadd') and (($this->product2->product_in_stock - $this->product2->product_ordered) < 1) || 
				(($this->product2->product_in_stock - $this->product2->product_ordered) < $this->product2->min_order_level ))  { ?>
				<div class="discount sold"><?php echo JText::_('DR_SOLD');?></div>
		 <?php } ?> 
     <?php if (($this->product2->prices['override'] == -1 || $this->product2->prices['override'] == 1) &&  ($this->product2->prices['product_price_publish_down'] > 0)){?>
        <div class="discount limited"><?php echo JText::_('DR_LIMITED_OFFER');?></div>
          <?php } elseif($discont >0 && $this->product2->product_sales < 5 ) { ?>
     <div class="discount"><?php echo JText::_('DR_SALE');?></div>
		<?php } elseif ($this->product2->product_sales > 0) {?>
          <div class="hit"><?php echo JText::_('DR_HOT');?></div>
			<?php } ?>
            <?php
			if (!empty($this->product2->images[1]) ){
					$image = $this->product2->images[1]->displayMediaThumb('class="browseProductImage featuredProductImage" border="0"',false) ;
			}else {$image =  $this->product2->images[0]->displayMediaThumb('class="browseProductImage featuredProductImage" border="0"',false) ;}
					echo JHTML::_('link', JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='.$this->product2->virtuemart_product_id.'&virtuemart_category_id='.$this->product2->virtuemart_category_id),$image,array('class' => 'noSwipe'));
			?>
    
    
	</div>
    <div class="slide-hover">
    	<div class="wrapper">
                    <div class="Title">
                    <?php echo JHTML::link(JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='.$this->product2->virtuemart_product_id.'&virtuemart_category_id='.$this->product2->virtuemart_category_id), shopFunctionsF::limitStringByWord($this->product2->product_name,'40','...'), array('title' => $this->product2->product_name)); ?>
                    </div>
				 <?php
				  $showRating = $ratingModel->showRating($this->product2->virtuemart_product_id);
				 if ($showRating=='true'){
                $rating = $ratingModel->getRatingByProduct($this->product2->virtuemart_product_id);
                if( !empty($rating)) {
                    $r = $rating->rating;
                } else {
                    $r = 0;
                }
                $maxrating = VmConfig::get('vm_maximum_rating_scale',5);
								$ratingwidth = ( $r * 100 ) / $maxrating;//I don't use round as percetntage with works perfect, as for me
					?>
                                                
                        <span class="vote">
                            <span title="" class="vmicon ratingbox" style="display:inline-block;">
                                <span class="stars-orange" style="width:<?php echo $ratingwidth;?>%">
                                </span>
                            </span>
                        </span>
                        <?php } ?>
                         <?php if (( !empty($this->product2->prices['salesPrice'])) && !$this->product2->images[0]->file_is_downloadable) { ?>
        <div class="Price" id="productPrice<?php echo $this->product2->virtuemart_product_id ;?>">
				<?php if ($this->product2->prices['basePriceWithTax']>0 && $discont>0)
                    echo '<span class="WithoutTax">'.$currency->createPriceDiv('basePriceWithTax', '', $this->product2->prices,true).'</span>';
                ?>
                <?php if ($this->product2->prices['salesPrice']>0)
                    echo '<span class="sales">' .$currency->createPriceDiv('salesPrice', '', $this->product2->prices,true).'</span>';
                ?>
                <?php if ($discont>0)
                    echo '<span class="discount">' .$currency->createPriceDiv('discountAmount', '', $this->product2->prices,true).'</span>';
                ?>
             </div>
		</div>
        <?php  } else {
									if ($product->prices['salesPrice']<=0 and VmConfig::get ('askprice', 1) ) { ?>
									<div class="call-a-question">
                                     	<a class="call modal"  rel="{handler: 'iframe', size: {x: 460, y: 550}}" href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id='.$product->virtuemart_product_id.'&virtuemart_category_id='.$product->virtuemart_category_id.'&tmpl=component'); ?>" ><?php echo JText::_('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?></a>
                                    </div>
									<?php } } ?>
           <div class="wrapper-slide">
         <?php  if (!empty($show_price)){

			if (((!VmConfig::get('use_as_catalog', 0) and !empty($product->prices['basePrice'])) && !$product->images[0]->file_is_downloadable )) { ?>

                <div class="addtocart-area2">
						<?php if ($this->product2->product_in_stock < 1) { ?>
                            <a class="addtocart-button hasTooltips" href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=productdetails&layout=notify&virtuemart_product_id='.$this->product2->virtuemart_product_id); ?>" title="<?php echo JText::_('COM_VIRTUEMART_CART_NOTIFY') ?>"><?php echo JText::_('COM_VIRTUEMART_CART_NOTIFY') ?><span>&nbsp;</span></a>
                        <?php } else { ?>
                        <form method="post" class="product" action="index.php" id="addtocartproduct<?php echo $this->product2->virtuemart_product_id ?>">
                        <input name="quantity" type="hidden" value="<?php echo $step ?>" />
                        <div class="addtocart-bar2">
                         <script type="text/javascript">
													function check(obj) {
													// use the modulus operator '%' to see if there is a remainder
													remainder=obj.value % <?php echo $step?>;
													quantity=obj.value;
													if (remainder  != 0) {
														alert('<?php echo $alert?>!');
														obj.value = quantity-remainder;
														return false;
														}
													return true;
													}
											</script> 
                            <?php // Display the quantity box 
											 if (!empty($this->product2->customfields)) {
													foreach ($this->product2->customfields as $this->k => $this->custom) {
														if (!empty($this->custom->layout_pos)) {
															$this->product2->customfieldsSorted[$this->custom->layout_pos][] = $this->custom;
															unset($this->product2->customfields[$this->k]);
														}
													}
													$this->product2->customfieldsSorted['normal'] = $this->product2->customfields;
													unset($this->product2->customfields);
												}
											$this->position = 'addtocart';
											if (!empty($this->product2->customfieldsSorted[$this->position])) { ?>
                            <span class="attributes"><b>*</b> Product has attributes</span>
                            <div class="addtocart_button2">
                            <?php echo JHTML::link($this->product2->link, JText::_('COM_VIRTUEMART_CART_ADD_TO').'<span>&nbsp;</span>', array('title' =>JText::_('DR_VIRTUEMART_SELECT_OPTION'),'class' => 'addtocart-button hasTooltips')); ?>
                          </div>
                        
                        <?php } else { ?>
                        <span class="quantity-box">
                           <input type="text" class="quantity-input js-recalculate" name="quantity[]" onblur="check(this);" value="<?php if (isset($this->product2->step_order_level) && (int)$this->product2->step_order_level > 0) {
			echo $this->product2->step_order_level;
		} else if(!empty($this->product2->min_order_level)){
			echo $this->product2->min_order_level;
		}else {
			echo '1';
		} ?>"/>
                        </span>
                        <span class="quantity-controls">
                            <input type="button" class="quantity-controls quantity-plus" />
                            <input type="button" class="quantity-controls quantity-minus" />
                        </span>
                        <?php // Add the button
                            $button_lbl = JText::_('COM_VIRTUEMART_CART_ADD_TO');
                            $button_cls = 'addtocart-button cart-click hasTooltips'; //$button_cls = 'addtocart_button';
                        ?>
                            <?php // Display the add to cart button ?>
                            <div class="clear"></div>
                            <span class="addtocart_button2">
                                <button type="submit" value="<?php echo $button_lbl ?>" title="<?php echo JText::_('COM_VIRTUEMART_CART_ADD_TO');?>" class="hasTooltip <?php echo $button_cls ?>"><?php echo $button_lbl ?><span>&nbsp;</span></button>
                            </span>
                            
                        <input type="hidden" class="pname" value="<?php echo $this->product2->product_name ?>"/>
                        <input type="hidden" name="option" value="com_virtuemart" />
                        <input type="hidden" name="view" value="cart" />
                        <noscript><input type="hidden" name="task" value="add" /></noscript>
                       <input type="hidden" class="item_id" name="virtuemart_product_id[]" value="<?php echo $this->product2->virtuemart_product_id ?>"/>
                        <input type="hidden" name="virtuemart_category_id[]" value="<?php echo $this->product2->virtuemart_category_id ?>" />	
                        <?php }?>
                    </div>
                    </form>
                    <?php }  ?>
                    </div>
                                    
        <?php }} ?>
        <?php if(is_file(JPATH_BASE.DS."components/com_wishlists/template/wishlists.tpl2.php")){  ?>
             <div class="wishlist list_wishlists<?php echo $this->product2->virtuemart_product_id;?>">
                <?php require(JPATH_BASE.DS."components/com_wishlists/template/wishlists.tpl2.php"); ?>
             </div>
           <?php } ?>       
             <?php if(is_file(JPATH_BASE.DS."components/com_comparelist/template/comparelist.tpl2.php")){  ?>
             <div class="jClever compare_cat list_compare<?php echo $this->product2->virtuemart_product_id;?>">
                <?php require(JPATH_BASE.DS."components/com_comparelist/template/comparelist.tpl2.php"); ?>
             </div>
           <?php } ?>       
            
			</div>
    	</div>
    	</div>
        </div>
	</li>
					
		<?php } 
			 }
		?>

</ul>
                
                <div class="clearfix"></div>
                    <a id="prev_2" class="list_prev" href="#"><span>&lt;</span></a>
                    <a id="next_2" class="list_next" href="#"><span>&gt;</span></a>
              </div>
<script type="text/javascript">
 jQuery(document).ready(function($) {

	 $(function() {

    	$('.product-related div.prod-row').each(function() {        
        var tip = $(this).find('div.count_holder_small');

        $(this).hover(
            function() { tip.appendTo('body'); },
            function() { tip.appendTo(this); }
        ).mousemove(function(e) {
            var x = e.pageX + 60,
                y = e.pageY - 50,
                w = tip.width(),
                h = tip.height(),
                dx = $(window).width() - (x + w),
                dy = $(window).height() - (y + h);

            if ( dx < 50 ) x = e.pageX - w - 60;
            if ( dy < 50 ) y = e.pageY - h + 130;

            tip.css({ left: x, top: y });
        	});         
    	});

		});
});
</script>
</div>
</div>