﻿<!DOCTYPE html>
<html lang="en">
<head>
    <title id='Description'>This example shows how to implement Master-Details binding scenario with two Grids.</title>
    <link rel="stylesheet" href="jqwidgets/styles/jqx.base.css" type="text/css" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta name="viewport" content="width=device-width, initial-scale=1 maximum-scale=1 minimum-scale=1" />
    <script type="text/javascript" src="scripts/jquery-1.11.1.min.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxcore.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxbuttons.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxscrollbar.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxmenu.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.selection.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.columnsresize.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.pager.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxlistbox.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxdropdownlist.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxdata.js"></script>
    <script type="text/javascript" src="scripts/demos.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            // prepare the data
            var source =
            {
                datafields: [
                    { name: 'CustomerID' },
                    { name: 'CompanyName' },
                    { name: 'ContactName' },
                    { name: 'ContactTitle' },
                    { name: 'Address' },
                    { name: 'City' },
                    { name: 'Country' }
                ],
                localdata: [{ "CustomerID": "ALFKI", "CompanyName": "Alfreds Futterkiste", "ContactName": "Maria Anders", "ContactTitle": "Sales Representative", "Address": "Obere Str. 57", "City": "Berlin", "Region": null, "PostalCode": 12209, "Country": "Germany", "Phone": "030-0074321", "Fax": "030-0076545" }, { "CustomerID": "ANATR", "CompanyName": "Ana Trujillo Emparedados y helados", "ContactName": "Ana Trujillo", "ContactTitle": "Owner", "Address": "Avda. de la Constitucin 2222", "City": "Mxico D.F.", "Region": null, "PostalCode": 05021, "Country": "Mexico", "Phone": "(5) 555-4729", "Fax": "(5) 555-3745" }, { "CustomerID": "ANTON", "CompanyName": "Antonio Moreno Taquera", "ContactName": "Antonio Moreno", "ContactTitle": "Owner", "Address": "Mataderos  2312", "City": "Mxico D.F.", "Region": null, "PostalCode": 05023, "Country": "Mexico", "Phone": "(5) 555-3932", "Fax": null }, { "CustomerID": "AROUT", "CompanyName": "Around the Horn", "ContactName": "Thomas Hardy", "ContactTitle": "Sales Representative", "Address": "120 Hanover Sq.", "City": "London", "Region": null, "PostalCode": "WA1 1DP", "Country": "UK", "Phone": "(171) 555-7788", "Fax": "(171) 555-6750" }, { "CustomerID": "BERGS", "CompanyName": "Berglunds snabbkp", "ContactName": "Christina Berglund", "ContactTitle": "Order Administrator", "Address": "Berguvsvgen  8", "City": "Lule", "Region": null, "PostalCode": "S-958 22", "Country": "Sweden", "Phone": "0921-12 34 65", "Fax": "0921-12 34 67" }, { "CustomerID": "BLAUS", "CompanyName": "Blauer See Delikatessen", "ContactName": "Hanna Moos", "ContactTitle": "Sales Representative", "Address": "Forsterstr. 57", "City": "Mannheim", "Region": null, "PostalCode": 68306, "Country": "Germany", "Phone": "0621-08460", "Fax": "0621-08924" }, { "CustomerID": "BLONP", "CompanyName": "Blondesddsl pre et fils", "ContactName": "Frdrique Citeaux", "ContactTitle": "Marketing Manager", "Address": "24, place Klber", "City": "Strasbourg", "Region": null, "PostalCode": 67000, "Country": "France", "Phone": "88.60.15.31", "Fax": "88.60.15.32" }, { "CustomerID": "BOLID", "CompanyName": "Blido Comidas preparadas", "ContactName": "Martn Sommer", "ContactTitle": "Owner", "Address": "C/ Araquil, 67", "City": "Madrid", "Region": null, "PostalCode": 28023, "Country": "Spain", "Phone": "(91) 555 22 82", "Fax": "(91) 555 91 99" }, { "CustomerID": "BONAP", "CompanyName": "Bon app\'", "ContactName": "Laurence Lebihan", "ContactTitle": "Owner", "Address": "12, rue des Bouchers", "City": "Marseille", "Region": null, "PostalCode": 13008, "Country": "France", "Phone": "91.24.45.40", "Fax": "91.24.45.41" }, { "CustomerID": "BOTTM", "CompanyName": "Bottom-Dollar Markets", "ContactName": "Elizabeth Lincoln", "ContactTitle": "Accounting Manager", "Address": "23 Tsawassen Blvd.", "City": "Tsawassen", "Region": "BC", "PostalCode": "T2F 8M4", "Country": "Canada", "Phone": "(604) 555-4729", "Fax": "(604) 555-3745" }, { "CustomerID": "BSBEV", "CompanyName": "B\'s Beverages", "ContactName": "Victoria Ashworth", "ContactTitle": "Sales Representative", "Address": "Fauntleroy Circus", "City": "London", "Region": null, "PostalCode": "EC2 5NT", "Country": "UK", "Phone": "(171) 555-1212", "Fax": null }, { "CustomerID": "CACTU", "CompanyName": "Cactus Comidas para llevar", "ContactName": "Patricio Simpson", "ContactTitle": "Sales Agent", "Address": "Cerrito 333", "City": "Buenos Aires", "Region": null, "PostalCode": 1010, "Country": "Argentina", "Phone": "(1) 135-5555", "Fax": "(1) 135-4892" }, { "CustomerID": "CENTC", "CompanyName": "Centro comercial Moctezuma", "ContactName": "Francisco Chang", "ContactTitle": "Marketing Manager", "Address": "Sierras de Granada 9993", "City": "Mxico D.F.", "Region": null, "PostalCode": 05022, "Country": "Mexico", "Phone": "(5) 555-3392", "Fax": "(5) 555-7293" }, { "CustomerID": "CHOPS", "CompanyName": "Chop-suey Chinese", "ContactName": "Yang Wang", "ContactTitle": "Owner", "Address": "Hauptstr. 29", "City": "Bern", "Region": null, "PostalCode": 3012, "Country": "Switzerland", "Phone": "0452-076545", "Fax": null }, { "CustomerID": "COMMI", "CompanyName": "Comrcio Mineiro", "ContactName": "Pedro Afonso", "ContactTitle": "Sales Associate", "Address": "Av. dos Lusadas, 23", "City": "Sao Paulo", "Region": "SP", "PostalCode": "05432-043", "Country": "Brazil", "Phone": "(11) 555-7647", "Fax": null }, { "CustomerID": "CONSH", "CompanyName": "Consolidated Holdings", "ContactName": "Elizabeth Brown", "ContactTitle": "Sales Representative", "Address": "Berkeley Gardens 12  Brewery", "City": "London", "Region": null, "PostalCode": "WX1 6LT", "Country": "UK", "Phone": "(171) 555-2282", "Fax": "(171) 555-9199" }, { "CustomerID": "DRACD", "CompanyName": "Drachenblut Delikatessen", "ContactName": "Sven Ottlieb", "ContactTitle": "Order Administrator", "Address": "Walserweg 21", "City": "Aachen", "Region": null, "PostalCode": 52066, "Country": "Germany", "Phone": "0241-039123", "Fax": "0241-059428" }, { "CustomerID": "DUMON", "CompanyName": "Du monde entier", "ContactName": "Janine Labrune", "ContactTitle": "Owner", "Address": "67, rue des Cinquante Otages", "City": "Nantes", "Region": null, "PostalCode": 44000, "Country": "France", "Phone": "40.67.88.88", "Fax": "40.67.89.89" }, { "CustomerID": "EASTC", "CompanyName": "Eastern Connection", "ContactName": "Ann Devon", "ContactTitle": "Sales Agent", "Address": "35 King George", "City": "London", "Region": null, "PostalCode": "WX3 6FW", "Country": "UK", "Phone": "(171) 555-0297", "Fax": "(171) 555-3373" }, { "CustomerID": "ERNSH", "CompanyName": "Ernst Handel", "ContactName": "Roland Mendel", "ContactTitle": "Sales Manager", "Address": "Kirchgasse 6", "City": "Graz", "Region": null, "PostalCode": 8010, "Country": "Austria", "Phone": "7675-3425", "Fax": "7675-3426" }, { "CustomerID": "FAMIA", "CompanyName": "Familia Arquibaldo", "ContactName": "Aria Cruz", "ContactTitle": "Marketing Assistant", "Address": "Rua Ors, 92", "City": "Sao Paulo", "Region": "SP", "PostalCode": "05442-030", "Country": "Brazil", "Phone": "(11) 555-9857", "Fax": null }, { "CustomerID": "FISSA", "CompanyName": "FISSA Fabrica Inter. Salchichas S.A.", "ContactName": "Diego Roel", "ContactTitle": "Accounting Manager", "Address": "C/ Moralzarzal, 86", "City": "Madrid", "Region": null, "PostalCode": 28034, "Country": "Spain", "Phone": "(91) 555 94 44", "Fax": "(91) 555 55 93" }, { "CustomerID": "FOLIG", "CompanyName": "Folies gourmandes", "ContactName": "Martine Ranc", "ContactTitle": "Assistant Sales Agent", "Address": "184, chausse de Tournai", "City": "Lille", "Region": null, "PostalCode": 59000, "Country": "France", "Phone": "20.16.10.16", "Fax": "20.16.10.17" }, { "CustomerID": "FOLKO", "CompanyName": "Folk och f HB", "ContactName": "Maria Larsson", "ContactTitle": "Owner", "Address": "kergatan 24", "City": "Brcke", "Region": null, "PostalCode": "S-844 67", "Country": "Sweden", "Phone": "0695-34 67 21", "Fax": null }, { "CustomerID": "FRANK", "CompanyName": "Frankenversand", "ContactName": "Peter Franken", "ContactTitle": "Marketing Manager", "Address": "Berliner Platz 43", "City": "Mnchen", "Region": null, "PostalCode": 80805, "Country": "Germany", "Phone": "089-0877310", "Fax": "089-0877451" }, { "CustomerID": "FRANR", "CompanyName": "France restauration", "ContactName": "Carine Schmitt", "ContactTitle": "Marketing Manager", "Address": "54, rue Royale", "City": "Nantes", "Region": null, "PostalCode": 44000, "Country": "France", "Phone": "40.32.21.21", "Fax": "40.32.21.20" }, { "CustomerID": "FRANS", "CompanyName": "Franchi S.p.A.", "ContactName": "Paolo Accorti", "ContactTitle": "Sales Representative", "Address": "Via Monte Bianco 34", "City": "Torino", "Region": null, "PostalCode": 10100, "Country": "Italy", "Phone": "011-4988260", "Fax": "011-4988261" }, { "CustomerID": "FURIB", "CompanyName": "Furia Bacalhau e Frutos do Mar", "ContactName": "Lino Rodriguez", "ContactTitle": "Sales Manager", "Address": "Jardim das rosas n. 32", "City": "Lisboa", "Region": null, "PostalCode": 1675, "Country": "Portugal", "Phone": "(1) 354-2534", "Fax": "(1) 354-2535" }, { "CustomerID": "GALED", "CompanyName": "Galera del gastrnomo", "ContactName": "Eduardo Saavedra", "ContactTitle": "Marketing Manager", "Address": "Rambla de Catalua, 23", "City": "Barcelona", "Region": null, "PostalCode": 08022, "Country": "Spain", "Phone": "(93) 203 4560", "Fax": "(93) 203 4561" }, { "CustomerID": "GODOS", "CompanyName": "Godos Cocina Tpica", "ContactName": "Jos Pedro Freyre", "ContactTitle": "Sales Manager", "Address": "C/ Romero, 33", "City": "Sevilla", "Region": null, "PostalCode": 41101, "Country": "Spain", "Phone": "(95) 555 82 82", "Fax": null }, { "CustomerID": "GOURL", "CompanyName": "Gourmet Lanchonetes", "ContactName": "Andr Fonseca", "ContactTitle": "Sales Associate", "Address": "Av. Brasil, 442", "City": "Campinas", "Region": "SP", "PostalCode": "04876-786", "Country": "Brazil", "Phone": "(11) 555-9482", "Fax": null }, { "CustomerID": "GREAL", "CompanyName": "Great Lakes Food Market", "ContactName": "Howard Snyder", "ContactTitle": "Marketing Manager", "Address": "2732 Baker Blvd.", "City": "Eugene", "Region": "OR", "PostalCode": 97403, "Country": "USA", "Phone": "(503) 555-7555", "Fax": null }, { "CustomerID": "GROSR", "CompanyName": "GROSELLA-Restaurante", "ContactName": "Manuel Pereira", "ContactTitle": "Owner", "Address": "5 Ave. Los Palos Grandes", "City": "Caracas", "Region": "DF", "PostalCode": 1081, "Country": "Venezuela", "Phone": "(2) 283-2951", "Fax": "(2) 283-3397" }, { "CustomerID": "HANAR", "CompanyName": "Hanari Carnes", "ContactName": "Mario Pontes", "ContactTitle": "Accounting Manager", "Address": "Rua do Pao, 67", "City": "Rio de Janeiro", "Region": "RJ", "PostalCode": "05454-876", "Country": "Brazil", "Phone": "(21) 555-0091", "Fax": "(21) 555-8765" }, { "CustomerID": "HILAA", "CompanyName": "HILARION-Abastos", "ContactName": "Carlos Hernndez", "ContactTitle": "Sales Representative", "Address": "Carrera 22 con Ave. Carlos Soublette #8-35", "City": "San Cristbal", "Region": "Tchira", "PostalCode": 5022, "Country": "Venezuela", "Phone": "(5) 555-1340", "Fax": "(5) 555-1948" }, { "CustomerID": "HUNGC", "CompanyName": "Hungry Coyote Import Store", "ContactName": "Yoshi Latimer", "ContactTitle": "Sales Representative", "Address": "City Center Plaza 516 Main St.", "City": "Elgin", "Region": "OR", "PostalCode": 97827, "Country": "USA", "Phone": "(503) 555-6874", "Fax": "(503) 555-2376" }, { "CustomerID": "HUNGO", "CompanyName": "Hungry Owl All-Night Grocers", "ContactName": "Patricia McKenna", "ContactTitle": "Sales Associate", "Address": "8 Johnstown Road", "City": "Cork", "Region": "Co. Cork", "PostalCode": null, "Country": "Ireland", "Phone": "2967 542", "Fax": "2967 3333" }, { "CustomerID": "ISLAT", "CompanyName": "Island Trading", "ContactName": "Helen Bennett", "ContactTitle": "Marketing Manager", "Address": "Garden House Crowther Way", "City": "Cowes", "Region": "Isle of Wight", "PostalCode": "PO31 7PJ", "Country": "UK", "Phone": "(198) 555-8888", "Fax": null }, { "CustomerID": "KOENE", "CompanyName": "Kniglich Essen", "ContactName": "Philip Cramer", "ContactTitle": "Sales Associate", "Address": "Maubelstr. 90", "City": "Brandenburg", "Region": null, "PostalCode": 14776, "Country": "Germany", "Phone": "0555-09876", "Fax": null }, { "CustomerID": "LACOR", "CompanyName": "La corne d\'abondance", "ContactName": "Daniel Tonini", "ContactTitle": "Sales Representative", "Address": "67, avenue de l\'Europe", "City": "Versailles", "Region": null, "PostalCode": 78000, "Country": "France", "Phone": "30.59.84.10", "Fax": "30.59.85.11" }, { "CustomerID": "LAMAI", "CompanyName": "La maison d\'Asie", "ContactName": "Annette Roulet", "ContactTitle": "Sales Manager", "Address": "1 rue Alsace-Lorraine", "City": "Toulouse", "Region": null, "PostalCode": 31000, "Country": "France", "Phone": "61.77.61.10", "Fax": "61.77.61.11" }, { "CustomerID": "LAUGB", "CompanyName": "Laughing Bacchus Wine Cellars", "ContactName": "Yoshi Tannamuri", "ContactTitle": "Marketing Assistant", "Address": "1900 Oak St.", "City": "Vancouver", "Region": "BC", "PostalCode": "V3F 2K1", "Country": "Canada", "Phone": "(604) 555-3392", "Fax": "(604) 555-7293" }, { "CustomerID": "LAZYK", "CompanyName": "Lazy K Kountry Store", "ContactName": "John Steel", "ContactTitle": "Marketing Manager", "Address": "12 Orchestra Terrace", "City": "Walla Walla", "Region": "WA", "PostalCode": 99362, "Country": "USA", "Phone": "(509) 555-7969", "Fax": "(509) 555-6221" }, { "CustomerID": "LEHMS", "CompanyName": "Lehmanns Marktstand", "ContactName": "Renate Messner", "ContactTitle": "Sales Representative", "Address": "Magazinweg 7", "City": "Frankfurt a.M.", "Region": null, "PostalCode": 60528, "Country": "Germany", "Phone": "069-0245984", "Fax": "069-0245874" }, { "CustomerID": "LETSS", "CompanyName": "Let\'s Stop N Shop", "ContactName": "Jaime Yorres", "ContactTitle": "Owner", "Address": "87 Polk St. Suite 5", "City": "San Francisco", "Region": "CA", "PostalCode": 94117, "Country": "USA", "Phone": "(415) 555-5938", "Fax": null }, { "CustomerID": "LILAS", "CompanyName": "LILA-Supermercado", "ContactName": "Carlos Gonzlez", "ContactTitle": "Accounting Manager", "Address": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "City": "Barquisimeto", "Region": "Lara", "PostalCode": 3508, "Country": "Venezuela", "Phone": "(9) 331-6954", "Fax": "(9) 331-7256" }, { "CustomerID": "LINOD", "CompanyName": "LINO-Delicateses", "ContactName": "Felipe Izquierdo", "ContactTitle": "Owner", "Address": "Ave. 5 de Mayo Porlamar", "City": "I. de Margarita", "Region": "Nueva Esparta", "PostalCode": 4980, "Country": "Venezuela", "Phone": "(8) 34-56-12", "Fax": "(8) 34-93-93" }, { "CustomerID": "LONEP", "CompanyName": "Lonesome Pine Restaurant", "ContactName": "Fran Wilson", "ContactTitle": "Sales Manager", "Address": "89 Chiaroscuro Rd.", "City": "Portland", "Region": "OR", "PostalCode": 97219, "Country": "USA", "Phone": "(503) 555-9573", "Fax": "(503) 555-9646" }, { "CustomerID": "MAGAA", "CompanyName": "Magazzini Alimentari Riuniti", "ContactName": "Giovanni Rovelli", "ContactTitle": "Marketing Manager", "Address": "Via Ludovico il Moro 22", "City": "Bergamo", "Region": null, "PostalCode": 24100, "Country": "Italy", "Phone": "035-640230", "Fax": "035-640231" }, { "CustomerID": "MAISD", "CompanyName": "Maison Dewey", "ContactName": "Catherine Dewey", "ContactTitle": "Sales Agent", "Address": "Rue Joseph-Bens 532", "City": "Bruxelles", "Region": null, "PostalCode": "B-1180", "Country": "Belgium", "Phone": "(02) 201 24 67", "Fax": "(02) 201 24 68" }, { "CustomerID": "MEREP", "CompanyName": "Mre Paillarde", "ContactName": "Jean Fresnire", "ContactTitle": "Marketing Assistant", "Address": "43 rue St. Laurent", "City": "Montral", "Region": "Qubec", "PostalCode": "H1J 1C3", "Country": "Canada", "Phone": "(514) 555-8054", "Fax": "(514) 555-8055" }, { "CustomerID": "MORGK", "CompanyName": "Morgenstern Gesundkost", "ContactName": "Alexander Feuer", "ContactTitle": "Marketing Assistant", "Address": "Heerstr. 22", "City": "Leipzig", "Region": null, "PostalCode": 04179, "Country": "Germany", "Phone": "0342-023176", "Fax": null }, { "CustomerID": "NORTS", "CompanyName": "North/South", "ContactName": "Simon Crowther", "ContactTitle": "Sales Associate", "Address": "South House 300 Queensbridge", "City": "London", "Region": null, "PostalCode": "SW7 1RZ", "Country": "UK", "Phone": "(171) 555-7733", "Fax": "(171) 555-2530" }, { "CustomerID": "OCEAN", "CompanyName": "Ocano Atlntico Ltda.", "ContactName": "Yvonne Moncada", "ContactTitle": "Sales Agent", "Address": "Ing. Gustavo Moncada 8585 Piso 20-A", "City": "Buenos Aires", "Region": null, "PostalCode": 1010, "Country": "Argentina", "Phone": "(1) 135-5333", "Fax": "(1) 135-5535" }, { "CustomerID": "OLDWO", "CompanyName": "Old World Delicatessen", "ContactName": "Rene Phillips", "ContactTitle": "Sales Representative", "Address": "2743 Bering St.", "City": "Anchorage", "Region": "AK", "PostalCode": 99508, "Country": "USA", "Phone": "(907) 555-7584", "Fax": "(907) 555-2880" }, { "CustomerID": "OTTIK", "CompanyName": "Ottilies Kseladen", "ContactName": "Henriette Pfalzheim", "ContactTitle": "Owner", "Address": "Mehrheimerstr. 369", "City": "Kln", "Region": null, "PostalCode": 50739, "Country": "Germany", "Phone": "0221-0644327", "Fax": "0221-0765721" }, { "CustomerID": "PARIS", "CompanyName": "Paris spcialits", "ContactName": "Marie Bertrand", "ContactTitle": "Owner", "Address": "265, boulevard Charonne", "City": "Paris", "Region": null, "PostalCode": 75012, "Country": "France", "Phone": "(1) 42.34.22.66", "Fax": "(1) 42.34.22.77" }, { "CustomerID": "PERIC", "CompanyName": "Pericles Comidas clsicas", "ContactName": "Guillermo Fernndez", "ContactTitle": "Sales Representative", "Address": "Calle Dr. Jorge Cash 321", "City": "Mxico D.F.", "Region": null, "PostalCode": 05033, "Country": "Mexico", "Phone": "(5) 552-3745", "Fax": "(5) 545-3745" }, { "CustomerID": "PICCO", "CompanyName": "Piccolo und mehr", "ContactName": "Georg Pipps", "ContactTitle": "Sales Manager", "Address": "Geislweg 14", "City": "Salzburg", "Region": null, "PostalCode": 5020, "Country": "Austria", "Phone": "6562-9722", "Fax": "6562-9723" }, { "CustomerID": "PRINI", "CompanyName": "Princesa Isabel Vinhos", "ContactName": "Isabel de Castro", "ContactTitle": "Sales Representative", "Address": "Estrada da sade n. 58", "City": "Lisboa", "Region": null, "PostalCode": 1756, "Country": "Portugal", "Phone": "(1) 356-5634", "Fax": null }, { "CustomerID": "QUEDE", "CompanyName": "Que Delcia", "ContactName": "Bernardo Batista", "ContactTitle": "Accounting Manager", "Address": "Rua da Panificadora, 12", "City": "Rio de Janeiro", "Region": "RJ", "PostalCode": "02389-673", "Country": "Brazil", "Phone": "(21) 555-4252", "Fax": "(21) 555-4545" }, { "CustomerID": "QUEEN", "CompanyName": "Queen Cozinha", "ContactName": "Lcia Carvalho", "ContactTitle": "Marketing Assistant", "Address": "Alameda dos Canrios, 891", "City": "Sao Paulo", "Region": "SP", "PostalCode": "05487-020", "Country": "Brazil", "Phone": "(11) 555-1189", "Fax": null }, { "CustomerID": "QUICK", "CompanyName": "QUICK-Stop", "ContactName": "Horst Kloss", "ContactTitle": "Accounting Manager", "Address": "Taucherstrae 10", "City": "Cunewalde", "Region": null, "PostalCode": 01307, "Country": "Germany", "Phone": "0372-035188", "Fax": null }, { "CustomerID": "RANCH", "CompanyName": "Rancho grande", "ContactName": "Sergio Gutirrez", "ContactTitle": "Sales Representative", "Address": "Av. del Libertador 900", "City": "Buenos Aires", "Region": null, "PostalCode": 1010, "Country": "Argentina", "Phone": "(1) 123-5555", "Fax": "(1) 123-5556" }, { "CustomerID": "RATTC", "CompanyName": "Rattlesnake Canyon Grocery", "ContactName": "Paula Wilson", "ContactTitle": "Assistant Sales Representative", "Address": "2817 Milton Dr.", "City": "Albuquerque", "Region": "NM", "PostalCode": 87110, "Country": "USA", "Phone": "(505) 555-5939", "Fax": "(505) 555-3620" }, { "CustomerID": "REGGC", "CompanyName": "Reggiani Caseifici", "ContactName": "Maurizio Moroni", "ContactTitle": "Sales Associate", "Address": "Strada Provinciale 124", "City": "Reggio Emilia", "Region": null, "PostalCode": 42100, "Country": "Italy", "Phone": "0522-556721", "Fax": "0522-556722" }, { "CustomerID": "RICAR", "CompanyName": "Ricardo Adocicados", "ContactName": "Janete Limeira", "ContactTitle": "Assistant Sales Agent", "Address": "Av. Copacabana, 267", "City": "Rio de Janeiro", "Region": "RJ", "PostalCode": "02389-890", "Country": "Brazil", "Phone": "(21) 555-3412", "Fax": null }, { "CustomerID": "RICSU", "CompanyName": "Richter Supermarkt", "ContactName": "Michael Holz", "ContactTitle": "Sales Manager", "Address": "Grenzacherweg 237", "City": "Genve", "Region": null, "PostalCode": 1203, "Country": "Switzerland", "Phone": "0897-034214", "Fax": null }, { "CustomerID": "ROMEY", "CompanyName": "Romero y tomillo", "ContactName": "Alejandra Camino", "ContactTitle": "Accounting Manager", "Address": "Gran Va, 1", "City": "Madrid", "Region": null, "PostalCode": 28001, "Country": "Spain", "Phone": "(91) 745 6200", "Fax": "(91) 745 6210" }, { "CustomerID": "SANTG", "CompanyName": "Sant Gourmet", "ContactName": "Jonas Bergulfsen", "ContactTitle": "Owner", "Address": "Erling Skakkes gate 78", "City": "Stavern", "Region": null, "PostalCode": 4110, "Country": "Norway", "Phone": "07-98 92 35", "Fax": "07-98 92 47" }, { "CustomerID": "SAVEA", "CompanyName": "Save-a-lot Markets", "ContactName": "Jose Pavarotti", "ContactTitle": "Sales Representative", "Address": "187 Suffolk Ln.", "City": "Boise", "Region": "ID", "PostalCode": 83720, "Country": "USA", "Phone": "(208) 555-8097", "Fax": null }, { "CustomerID": "SEVES", "CompanyName": "Seven Seas Imports", "ContactName": "Hari Kumar", "ContactTitle": "Sales Manager", "Address": "90 Wadhurst Rd.", "City": "London", "Region": null, "PostalCode": "OX15 4NB", "Country": "UK", "Phone": "(171) 555-1717", "Fax": "(171) 555-5646" }, { "CustomerID": "SIMOB", "CompanyName": "Simons bistro", "ContactName": "Jytte Petersen", "ContactTitle": "Owner", "Address": "Vinbltet 34", "City": "Kobenhavn", "Region": null, "PostalCode": 1734, "Country": "Denmark", "Phone": "31 12 34 56", "Fax": "31 13 35 57" }, { "CustomerID": "SPECD", "CompanyName": "Spcialits du monde", "ContactName": "Dominique Perrier", "ContactTitle": "Marketing Manager", "Address": "25, rue Lauriston", "City": "Paris", "Region": null, "PostalCode": 75016, "Country": "France", "Phone": "(1) 47.55.60.10", "Fax": "(1) 47.55.60.20" }, { "CustomerID": "SPLIR", "CompanyName": "Split Rail Beer & Ale", "ContactName": "Art Braunschweiger", "ContactTitle": "Sales Manager", "Address": "P.O. Box 555", "City": "Lander", "Region": "WY", "PostalCode": 82520, "Country": "USA", "Phone": "(307) 555-4680", "Fax": "(307) 555-6525" }, { "CustomerID": "SUPRD", "CompanyName": "Suprmes dlices", "ContactName": "Pascale Cartrain", "ContactTitle": "Accounting Manager", "Address": "Boulevard Tirou, 255", "City": "Charleroi", "Region": null, "PostalCode": "B-6000", "Country": "Belgium", "Phone": "(071) 23 67 22 20", "Fax": "(071) 23 67 22 21" }, { "CustomerID": "THEBI", "CompanyName": "The Big Cheese", "ContactName": "Liz Nixon", "ContactTitle": "Marketing Manager", "Address": "89 Jefferson Way Suite 2", "City": "Portland", "Region": "OR", "PostalCode": 97201, "Country": "USA", "Phone": "(503) 555-3612", "Fax": null }, { "CustomerID": "THECR", "CompanyName": "The Cracker Box", "ContactName": "Liu Wong", "ContactTitle": "Marketing Assistant", "Address": "55 Grizzly Peak Rd.", "City": "Butte", "Region": "MT", "PostalCode": 59801, "Country": "USA", "Phone": "(406) 555-5834", "Fax": "(406) 555-8083" }, { "CustomerID": "TOMSP", "CompanyName": "Toms Spezialitten", "ContactName": "Karin Josephs", "ContactTitle": "Marketing Manager", "Address": "Luisenstr. 48", "City": "Mnster", "Region": null, "PostalCode": 44087, "Country": "Germany", "Phone": "0251-031259", "Fax": "0251-035695" }, { "CustomerID": "TORTU", "CompanyName": "Tortuga Restaurante", "ContactName": "Miguel Angel Paolino", "ContactTitle": "Owner", "Address": "Avda. Azteca 123", "City": "Mxico D.F.", "Region": null, "PostalCode": 05033, "Country": "Mexico", "Phone": "(5) 555-2933", "Fax": null }, { "CustomerID": "TRADH", "CompanyName": "Tradio Hipermercados", "ContactName": "Anabela Domingues", "ContactTitle": "Sales Representative", "Address": "Av. Ins de Castro, 414", "City": "Sao Paulo", "Region": "SP", "PostalCode": "05634-030", "Country": "Brazil", "Phone": "(11) 555-2167", "Fax": "(11) 555-2168" }, { "CustomerID": "TRAIH", "CompanyName": "Trail\'s Head Gourmet Provisioners", "ContactName": "Helvetius Nagy", "ContactTitle": "Sales Associate", "Address": "722 DaVinci Blvd.", "City": "Kirkland", "Region": "WA", "PostalCode": 98034, "Country": "USA", "Phone": "(206) 555-8257", "Fax": "(206) 555-2174" }, { "CustomerID": "VAFFE", "CompanyName": "Vaffeljernet", "ContactName": "Palle Ibsen", "ContactTitle": "Sales Manager", "Address": "Smagsloget 45", "City": "rhus", "Region": null, "PostalCode": 8200, "Country": "Denmark", "Phone": "86 21 32 43", "Fax": "86 22 33 44" }, { "CustomerID": "VICTE", "CompanyName": "Victuailles en stock", "ContactName": "Mary Saveley", "ContactTitle": "Sales Agent", "Address": "2, rue du Commerce", "City": "Lyon", "Region": null, "PostalCode": 69004, "Country": "France", "Phone": "78.32.54.86", "Fax": "78.32.54.87" }, { "CustomerID": "VINET", "CompanyName": "Vins et alcools Chevalier", "ContactName": "Paul Henriot", "ContactTitle": "Accounting Manager", "Address": "59 rue de l\'Abbaye", "City": "Reims", "Region": null, "PostalCode": 51100, "Country": "France", "Phone": "26.47.15.10", "Fax": "26.47.15.11" }, { "CustomerID": "WANDK", "CompanyName": "Die Wandernde Kuh", "ContactName": "Rita Mller", "ContactTitle": "Sales Representative", "Address": "Adenauerallee 900", "City": "Stuttgart", "Region": null, "PostalCode": 70563, "Country": "Germany", "Phone": "0711-020361", "Fax": "0711-035428" }, { "CustomerID": "WARTH", "CompanyName": "Wartian Herkku", "ContactName": "Pirkko Koskitalo", "ContactTitle": "Accounting Manager", "Address": "Torikatu 38", "City": "Oulu", "Region": null, "PostalCode": 90110, "Country": "Finland", "Phone": "981-443655", "Fax": "981-443655" }, { "CustomerID": "WELLI", "CompanyName": "Wellington Importadora", "ContactName": "Paula Parente", "ContactTitle": "Sales Manager", "Address": "Rua do Mercado, 12", "City": "Resende", "Region": "SP", "PostalCode": "08737-363", "Country": "Brazil", "Phone": "(14) 555-8122", "Fax": null }, { "CustomerID": "WHITC", "CompanyName": "White Clover Markets", "ContactName": "Karl Jablonski", "ContactTitle": "Owner", "Address": "305 - 14th Ave. S. Suite 3B", "City": "Seattle", "Region": "WA", "PostalCode": 98128, "Country": "USA", "Phone": "(206) 555-4112", "Fax": "(206) 555-4115" }, { "CustomerID": "WILMK", "CompanyName": "Wilman Kala", "ContactName": "Matti Karttunen", "ContactTitle": "Owner/Marketing Assistant", "Address": "Keskuskatu 45", "City": "Helsinki", "Region": null, "PostalCode": 21240, "Country": "Finland", "Phone": "90-224 8858", "Fax": "90-224 8858" }, { "CustomerID": "WOLZA", "CompanyName": "Wolski  Zajazd", "ContactName": "Zbyszek Piestrzeniewicz", "ContactTitle": "Owner", "Address": "ul. Filtrowa 68", "City": "Warszawa", "Region": null, "PostalCode": "01-012", "Country": "Poland", "Phone": "(26) 642-7012", "Fax": "(26) 642-7012"}]
            };
            var dataAdapter = new $.jqx.dataAdapter(source);
            $("#customersGrid").jqxGrid(
            {
                width: getWidth('Grid'),
                height: 250,
                source: dataAdapter,
                
                keyboardnavigation: false,
                columns: [
                    { text: 'Company Name', datafield: 'CompanyName', width: 250 },
                    { text: 'Contact Name', datafield: 'ContactName', width: 150 },
                    { text: 'Contact Title', datafield: 'ContactTitle', width: 180 },
                    { text: 'City', datafield: 'City', width: 120 },
                    { text: 'Country', datafield: 'Country'}
                ]
            });
            // Orders Grid
            // prepare the data
            var dataFields = [
                        { name: 'CustomerID' },
                        { name: 'OrderID' },
                        { name: 'OrderDate', type: 'date' },
                        { name: 'ShippedDate', type: 'date' },
                        { name: 'ShipName' },
                        { name: 'ShipCountry' }
                    ];
            var source =
            {
                datafields: dataFields,
                localdata: [{ "OrderID": 10248, "CustomerID": "VINET", "EmployeeID": 5, "OrderDate": "1996-07-04 00:00:00", "RequiredDate": "1996-08-01 00:00:00", "ShippedDate": "1996-07-16 00:00:00", "ShipVia": 3, "Freight": 32.3800, "ShipName": "Vins et alcools Chevalier", "ShipAddress": "59 rue de l-Abbaye", "ShipCity": "Reims", "ShipRegion": null, "ShipPostalCode": 51100, "ShipCountry": "France" }, { "OrderID": 10249, "CustomerID": "TOMSP", "EmployeeID": 6, "OrderDate": "1996-07-05 00:00:00", "RequiredDate": "1996-08-16 00:00:00", "ShippedDate": "1996-07-10 00:00:00", "ShipVia": 1, "Freight": 11.6100, "ShipName": "Toms Spezialitten", "ShipAddress": "Luisenstr. 48", "ShipCity": "Mnster", "ShipRegion": null, "ShipPostalCode": 44087, "ShipCountry": "Germany" }, { "OrderID": 10250, "CustomerID": "HANAR", "EmployeeID": 4, "OrderDate": "1996-07-08 00:00:00", "RequiredDate": "1996-08-05 00:00:00", "ShippedDate": "1996-07-12 00:00:00", "ShipVia": 2, "Freight": 65.8300, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10251, "CustomerID": "VICTE", "EmployeeID": 3, "OrderDate": "1996-07-08 00:00:00", "RequiredDate": "1996-08-05 00:00:00", "ShippedDate": "1996-07-15 00:00:00", "ShipVia": 1, "Freight": 41.3400, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10252, "CustomerID": "SUPRD", "EmployeeID": 4, "OrderDate": "1996-07-09 00:00:00", "RequiredDate": "1996-08-06 00:00:00", "ShippedDate": "1996-07-11 00:00:00", "ShipVia": 2, "Freight": 51.3000, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10253, "CustomerID": "HANAR", "EmployeeID": 3, "OrderDate": "1996-07-10 00:00:00", "RequiredDate": "1996-07-24 00:00:00", "ShippedDate": "1996-07-16 00:00:00", "ShipVia": 2, "Freight": 58.1700, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10254, "CustomerID": "CHOPS", "EmployeeID": 5, "OrderDate": "1996-07-11 00:00:00", "RequiredDate": "1996-08-08 00:00:00", "ShippedDate": "1996-07-23 00:00:00", "ShipVia": 2, "Freight": 22.9800, "ShipName": "Chop-suey Chinese", "ShipAddress": "Hauptstr. 31", "ShipCity": "Bern", "ShipRegion": null, "ShipPostalCode": 3012, "ShipCountry": "Switzerland" }, { "OrderID": 10255, "CustomerID": "RICSU", "EmployeeID": 9, "OrderDate": "1996-07-12 00:00:00", "RequiredDate": "1996-08-09 00:00:00", "ShippedDate": "1996-07-15 00:00:00", "ShipVia": 3, "Freight": 148.3300, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 10256, "CustomerID": "WELLI", "EmployeeID": 3, "OrderDate": "1996-07-15 00:00:00", "RequiredDate": "1996-08-12 00:00:00", "ShippedDate": "1996-07-17 00:00:00", "ShipVia": 2, "Freight": 13.9700, "ShipName": "Wellington Importadora", "ShipAddress": "Rua do Mercado, 12", "ShipCity": "Resende", "ShipRegion": "SP", "ShipPostalCode": "08737-363", "ShipCountry": "Brazil" }, { "OrderID": 10257, "CustomerID": "HILAA", "EmployeeID": 4, "OrderDate": "1996-07-16 00:00:00", "RequiredDate": "1996-08-13 00:00:00", "ShippedDate": "1996-07-22 00:00:00", "ShipVia": 3, "Freight": 81.9100, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10258, "CustomerID": "ERNSH", "EmployeeID": 1, "OrderDate": "1996-07-17 00:00:00", "RequiredDate": "1996-08-14 00:00:00", "ShippedDate": "1996-07-23 00:00:00", "ShipVia": 1, "Freight": 140.5100, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10259, "CustomerID": "CENTC", "EmployeeID": 4, "OrderDate": "1996-07-18 00:00:00", "RequiredDate": "1996-08-15 00:00:00", "ShippedDate": "1996-07-25 00:00:00", "ShipVia": 3, "Freight": 3.2500, "ShipName": "Centro comercial Moctezuma", "ShipAddress": "Sierras de Granada 9993", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5022, "ShipCountry": "Mexico" }, { "OrderID": 10260, "CustomerID": "OTTIK", "EmployeeID": 4, "OrderDate": "1996-07-19 00:00:00", "RequiredDate": "1996-08-16 00:00:00", "ShippedDate": "1996-07-29 00:00:00", "ShipVia": 1, "Freight": 55.0900, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 10261, "CustomerID": "QUEDE", "EmployeeID": 4, "OrderDate": "1996-07-19 00:00:00", "RequiredDate": "1996-08-16 00:00:00", "ShippedDate": "1996-07-30 00:00:00", "ShipVia": 2, "Freight": 3.0500, "ShipName": "Que Delcia", "ShipAddress": "Rua da Panificadora, 12", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-673", "ShipCountry": "Brazil" }, { "OrderID": 10262, "CustomerID": "RATTC", "EmployeeID": 8, "OrderDate": "1996-07-22 00:00:00", "RequiredDate": "1996-08-19 00:00:00", "ShippedDate": "1996-07-25 00:00:00", "ShipVia": 3, "Freight": 48.2900, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10263, "CustomerID": "ERNSH", "EmployeeID": 9, "OrderDate": "1996-07-23 00:00:00", "RequiredDate": "1996-08-20 00:00:00", "ShippedDate": "1996-07-31 00:00:00", "ShipVia": 3, "Freight": 146.0600, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10264, "CustomerID": "FOLKO", "EmployeeID": 6, "OrderDate": "1996-07-24 00:00:00", "RequiredDate": "1996-08-21 00:00:00", "ShippedDate": "1996-08-23 00:00:00", "ShipVia": 3, "Freight": 3.6700, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10265, "CustomerID": "BLONP", "EmployeeID": 2, "OrderDate": "1996-07-25 00:00:00", "RequiredDate": "1996-08-22 00:00:00", "ShippedDate": "1996-08-12 00:00:00", "ShipVia": 1, "Freight": 55.2800, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10266, "CustomerID": "WARTH", "EmployeeID": 3, "OrderDate": "1996-07-26 00:00:00", "RequiredDate": "1996-09-06 00:00:00", "ShippedDate": "1996-07-31 00:00:00", "ShipVia": 3, "Freight": 25.7300, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10267, "CustomerID": "FRANK", "EmployeeID": 4, "OrderDate": "1996-07-29 00:00:00", "RequiredDate": "1996-08-26 00:00:00", "ShippedDate": "1996-08-06 00:00:00", "ShipVia": 1, "Freight": 208.5800, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10268, "CustomerID": "GROSR", "EmployeeID": 8, "OrderDate": "1996-07-30 00:00:00", "RequiredDate": "1996-08-27 00:00:00", "ShippedDate": "1996-08-02 00:00:00", "ShipVia": 3, "Freight": 66.2900, "ShipName": "GROSELLA-Restaurante", "ShipAddress": "5 Ave. Los Palos Grandes", "ShipCity": "Caracas", "ShipRegion": "DF", "ShipPostalCode": 1081, "ShipCountry": "Venezuela" }, { "OrderID": 10269, "CustomerID": "WHITC", "EmployeeID": 5, "OrderDate": "1996-07-31 00:00:00", "RequiredDate": "1996-08-14 00:00:00", "ShippedDate": "1996-08-09 00:00:00", "ShipVia": 1, "Freight": 4.5600, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10270, "CustomerID": "WARTH", "EmployeeID": 1, "OrderDate": "1996-08-01 00:00:00", "RequiredDate": "1996-08-29 00:00:00", "ShippedDate": "1996-08-02 00:00:00", "ShipVia": 1, "Freight": 136.5400, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10271, "CustomerID": "SPLIR", "EmployeeID": 6, "OrderDate": "1996-08-01 00:00:00", "RequiredDate": "1996-08-29 00:00:00", "ShippedDate": "1996-08-30 00:00:00", "ShipVia": 2, "Freight": 4.5400, "ShipName": "Split Rail Beer & Ale", "ShipAddress": "P.O. Box 555", "ShipCity": "Lander", "ShipRegion": "WY", "ShipPostalCode": 82520, "ShipCountry": "USA" }, { "OrderID": 10272, "CustomerID": "RATTC", "EmployeeID": 6, "OrderDate": "1996-08-02 00:00:00", "RequiredDate": "1996-08-30 00:00:00", "ShippedDate": "1996-08-06 00:00:00", "ShipVia": 2, "Freight": 98.0300, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10273, "CustomerID": "QUICK", "EmployeeID": 3, "OrderDate": "1996-08-05 00:00:00", "RequiredDate": "1996-09-02 00:00:00", "ShippedDate": "1996-08-12 00:00:00", "ShipVia": 3, "Freight": 76.0700, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10274, "CustomerID": "VINET", "EmployeeID": 6, "OrderDate": "1996-08-06 00:00:00", "RequiredDate": "1996-09-03 00:00:00", "ShippedDate": "1996-08-16 00:00:00", "ShipVia": 1, "Freight": 6.0100, "ShipName": "Vins et alcools Chevalier", "ShipAddress": "59 rue de l-Abbaye", "ShipCity": "Reims", "ShipRegion": null, "ShipPostalCode": 51100, "ShipCountry": "France" }, { "OrderID": 10275, "CustomerID": "MAGAA", "EmployeeID": 1, "OrderDate": "1996-08-07 00:00:00", "RequiredDate": "1996-09-04 00:00:00", "ShippedDate": "1996-08-09 00:00:00", "ShipVia": 1, "Freight": 26.9300, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10276, "CustomerID": "TORTU", "EmployeeID": 8, "OrderDate": "1996-08-08 00:00:00", "RequiredDate": "1996-08-22 00:00:00", "ShippedDate": "1996-08-14 00:00:00", "ShipVia": 3, "Freight": 13.8400, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10277, "CustomerID": "MORGK", "EmployeeID": 2, "OrderDate": "1996-08-09 00:00:00", "RequiredDate": "1996-09-06 00:00:00", "ShippedDate": "1996-08-13 00:00:00", "ShipVia": 3, "Freight": 125.7700, "ShipName": "Morgenstern Gesundkost", "ShipAddress": "Heerstr. 22", "ShipCity": "Leipzig", "ShipRegion": null, "ShipPostalCode": 4179, "ShipCountry": "Germany" }, { "OrderID": 10278, "CustomerID": "BERGS", "EmployeeID": 8, "OrderDate": "1996-08-12 00:00:00", "RequiredDate": "1996-09-09 00:00:00", "ShippedDate": "1996-08-16 00:00:00", "ShipVia": 2, "Freight": 92.6900, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10279, "CustomerID": "LEHMS", "EmployeeID": 8, "OrderDate": "1996-08-13 00:00:00", "RequiredDate": "1996-09-10 00:00:00", "ShippedDate": "1996-08-16 00:00:00", "ShipVia": 2, "Freight": 25.8300, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10280, "CustomerID": "BERGS", "EmployeeID": 2, "OrderDate": "1996-08-14 00:00:00", "RequiredDate": "1996-09-11 00:00:00", "ShippedDate": "1996-09-12 00:00:00", "ShipVia": 1, "Freight": 8.9800, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10281, "CustomerID": "ROMEY", "EmployeeID": 4, "OrderDate": "1996-08-14 00:00:00", "RequiredDate": "1996-08-28 00:00:00", "ShippedDate": "1996-08-21 00:00:00", "ShipVia": 1, "Freight": 2.9400, "ShipName": "Romero y tomillo", "ShipAddress": "Gran Va, 1", "ShipCity": "Madrid", "ShipRegion": null, "ShipPostalCode": 28001, "ShipCountry": "Spain" }, { "OrderID": 10282, "CustomerID": "ROMEY", "EmployeeID": 4, "OrderDate": "1996-08-15 00:00:00", "RequiredDate": "1996-09-12 00:00:00", "ShippedDate": "1996-08-21 00:00:00", "ShipVia": 1, "Freight": 12.6900, "ShipName": "Romero y tomillo", "ShipAddress": "Gran Va, 1", "ShipCity": "Madrid", "ShipRegion": null, "ShipPostalCode": 28001, "ShipCountry": "Spain" }, { "OrderID": 10283, "CustomerID": "LILAS", "EmployeeID": 3, "OrderDate": "1996-08-16 00:00:00", "RequiredDate": "1996-09-13 00:00:00", "ShippedDate": "1996-08-23 00:00:00", "ShipVia": 3, "Freight": 84.8100, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10284, "CustomerID": "LEHMS", "EmployeeID": 4, "OrderDate": "1996-08-19 00:00:00", "RequiredDate": "1996-09-16 00:00:00", "ShippedDate": "1996-08-27 00:00:00", "ShipVia": 1, "Freight": 76.5600, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10285, "CustomerID": "QUICK", "EmployeeID": 1, "OrderDate": "1996-08-20 00:00:00", "RequiredDate": "1996-09-17 00:00:00", "ShippedDate": "1996-08-26 00:00:00", "ShipVia": 2, "Freight": 76.8300, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10286, "CustomerID": "QUICK", "EmployeeID": 8, "OrderDate": "1996-08-21 00:00:00", "RequiredDate": "1996-09-18 00:00:00", "ShippedDate": "1996-08-30 00:00:00", "ShipVia": 3, "Freight": 229.2400, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10287, "CustomerID": "RICAR", "EmployeeID": 8, "OrderDate": "1996-08-22 00:00:00", "RequiredDate": "1996-09-19 00:00:00", "ShippedDate": "1996-08-28 00:00:00", "ShipVia": 3, "Freight": 12.7600, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10288, "CustomerID": "REGGC", "EmployeeID": 4, "OrderDate": "1996-08-23 00:00:00", "RequiredDate": "1996-09-20 00:00:00", "ShippedDate": "1996-09-03 00:00:00", "ShipVia": 1, "Freight": 7.4500, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10289, "CustomerID": "BSBEV", "EmployeeID": 7, "OrderDate": "1996-08-26 00:00:00", "RequiredDate": "1996-09-23 00:00:00", "ShippedDate": "1996-08-28 00:00:00", "ShipVia": 3, "Freight": 22.7700, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 10290, "CustomerID": "COMMI", "EmployeeID": 8, "OrderDate": "1996-08-27 00:00:00", "RequiredDate": "1996-09-24 00:00:00", "ShippedDate": "1996-09-03 00:00:00", "ShipVia": 1, "Freight": 79.7000, "ShipName": "Comrcio Mineiro", "ShipAddress": "Av. dos Lusadas, 23", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05432-043", "ShipCountry": "Brazil" }, { "OrderID": 10291, "CustomerID": "QUEDE", "EmployeeID": 6, "OrderDate": "1996-08-27 00:00:00", "RequiredDate": "1996-09-24 00:00:00", "ShippedDate": "1996-09-04 00:00:00", "ShipVia": 2, "Freight": 6.4000, "ShipName": "Que Delcia", "ShipAddress": "Rua da Panificadora, 12", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-673", "ShipCountry": "Brazil" }, { "OrderID": 10292, "CustomerID": "TRADH", "EmployeeID": 1, "OrderDate": "1996-08-28 00:00:00", "RequiredDate": "1996-09-25 00:00:00", "ShippedDate": "1996-09-02 00:00:00", "ShipVia": 2, "Freight": 1.3500, "ShipName": "Tradiao Hipermercados", "ShipAddress": "Av. Ins de Castro, 414", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05634-030", "ShipCountry": "Brazil" }, { "OrderID": 10293, "CustomerID": "TORTU", "EmployeeID": 1, "OrderDate": "1996-08-29 00:00:00", "RequiredDate": "1996-09-26 00:00:00", "ShippedDate": "1996-09-11 00:00:00", "ShipVia": 3, "Freight": 21.1800, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10294, "CustomerID": "RATTC", "EmployeeID": 4, "OrderDate": "1996-08-30 00:00:00", "RequiredDate": "1996-09-27 00:00:00", "ShippedDate": "1996-09-05 00:00:00", "ShipVia": 2, "Freight": 147.2600, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10295, "CustomerID": "VINET", "EmployeeID": 2, "OrderDate": "1996-09-02 00:00:00", "RequiredDate": "1996-09-30 00:00:00", "ShippedDate": "1996-09-10 00:00:00", "ShipVia": 2, "Freight": 1.1500, "ShipName": "Vins et alcools Chevalier", "ShipAddress": "59 rue de l-Abbaye", "ShipCity": "Reims", "ShipRegion": null, "ShipPostalCode": 51100, "ShipCountry": "France" }, { "OrderID": 10296, "CustomerID": "LILAS", "EmployeeID": 6, "OrderDate": "1996-09-03 00:00:00", "RequiredDate": "1996-10-01 00:00:00", "ShippedDate": "1996-09-11 00:00:00", "ShipVia": 1, "Freight": 0.1200, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10297, "CustomerID": "BLONP", "EmployeeID": 5, "OrderDate": "1996-09-04 00:00:00", "RequiredDate": "1996-10-16 00:00:00", "ShippedDate": "1996-09-10 00:00:00", "ShipVia": 2, "Freight": 5.7400, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10298, "CustomerID": "HUNGO", "EmployeeID": 6, "OrderDate": "1996-09-05 00:00:00", "RequiredDate": "1996-10-03 00:00:00", "ShippedDate": "1996-09-11 00:00:00", "ShipVia": 2, "Freight": 168.2200, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10299, "CustomerID": "RICAR", "EmployeeID": 4, "OrderDate": "1996-09-06 00:00:00", "RequiredDate": "1996-10-04 00:00:00", "ShippedDate": "1996-09-13 00:00:00", "ShipVia": 2, "Freight": 29.7600, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10300, "CustomerID": "MAGAA", "EmployeeID": 2, "OrderDate": "1996-09-09 00:00:00", "RequiredDate": "1996-10-07 00:00:00", "ShippedDate": "1996-09-18 00:00:00", "ShipVia": 2, "Freight": 17.6800, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10301, "CustomerID": "WANDK", "EmployeeID": 8, "OrderDate": "1996-09-09 00:00:00", "RequiredDate": "1996-10-07 00:00:00", "ShippedDate": "1996-09-17 00:00:00", "ShipVia": 2, "Freight": 45.0800, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 10302, "CustomerID": "SUPRD", "EmployeeID": 4, "OrderDate": "1996-09-10 00:00:00", "RequiredDate": "1996-10-08 00:00:00", "ShippedDate": "1996-10-09 00:00:00", "ShipVia": 2, "Freight": 6.2700, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10303, "CustomerID": "GODOS", "EmployeeID": 7, "OrderDate": "1996-09-11 00:00:00", "RequiredDate": "1996-10-09 00:00:00", "ShippedDate": "1996-09-18 00:00:00", "ShipVia": 2, "Freight": 107.8300, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 10304, "CustomerID": "TORTU", "EmployeeID": 1, "OrderDate": "1996-09-12 00:00:00", "RequiredDate": "1996-10-10 00:00:00", "ShippedDate": "1996-09-17 00:00:00", "ShipVia": 2, "Freight": 63.7900, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10305, "CustomerID": "OLDWO", "EmployeeID": 8, "OrderDate": "1996-09-13 00:00:00", "RequiredDate": "1996-10-11 00:00:00", "ShippedDate": "1996-10-09 00:00:00", "ShipVia": 3, "Freight": 257.6200, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 10306, "CustomerID": "ROMEY", "EmployeeID": 1, "OrderDate": "1996-09-16 00:00:00", "RequiredDate": "1996-10-14 00:00:00", "ShippedDate": "1996-09-23 00:00:00", "ShipVia": 3, "Freight": 7.5600, "ShipName": "Romero y tomillo", "ShipAddress": "Gran Va, 1", "ShipCity": "Madrid", "ShipRegion": null, "ShipPostalCode": 28001, "ShipCountry": "Spain" }, { "OrderID": 10307, "CustomerID": "LONEP", "EmployeeID": 2, "OrderDate": "1996-09-17 00:00:00", "RequiredDate": "1996-10-15 00:00:00", "ShippedDate": "1996-09-25 00:00:00", "ShipVia": 2, "Freight": 0.5600, "ShipName": "Lonesome Pine Restaurant", "ShipAddress": "89 Chiaroscuro Rd.", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97219, "ShipCountry": "USA" }, { "OrderID": 10308, "CustomerID": "ANATR", "EmployeeID": 7, "OrderDate": "1996-09-18 00:00:00", "RequiredDate": "1996-10-16 00:00:00", "ShippedDate": "1996-09-24 00:00:00", "ShipVia": 3, "Freight": 1.6100, "ShipName": "Ana Trujillo Emparedados y helados", "ShipAddress": "Avda. de la Constitucin 2222", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5021, "ShipCountry": "Mexico" }, { "OrderID": 10309, "CustomerID": "HUNGO", "EmployeeID": 3, "OrderDate": "1996-09-19 00:00:00", "RequiredDate": "1996-10-17 00:00:00", "ShippedDate": "1996-10-23 00:00:00", "ShipVia": 1, "Freight": 47.3000, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10310, "CustomerID": "THEBI", "EmployeeID": 8, "OrderDate": "1996-09-20 00:00:00", "RequiredDate": "1996-10-18 00:00:00", "ShippedDate": "1996-09-27 00:00:00", "ShipVia": 2, "Freight": 17.5200, "ShipName": "The Big Cheese", "ShipAddress": "89 Jefferson Way Suite 2", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97201, "ShipCountry": "USA" }, { "OrderID": 10311, "CustomerID": "DUMON", "EmployeeID": 1, "OrderDate": "1996-09-20 00:00:00", "RequiredDate": "1996-10-04 00:00:00", "ShippedDate": "1996-09-26 00:00:00", "ShipVia": 3, "Freight": 24.6900, "ShipName": "Du monde entier", "ShipAddress": "67, rue des Cinquante Otages", "ShipCity": "Nantes", "ShipRegion": null, "ShipPostalCode": 44000, "ShipCountry": "France" }, { "OrderID": 10312, "CustomerID": "WANDK", "EmployeeID": 2, "OrderDate": "1996-09-23 00:00:00", "RequiredDate": "1996-10-21 00:00:00", "ShippedDate": "1996-10-03 00:00:00", "ShipVia": 2, "Freight": 40.2600, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 10313, "CustomerID": "QUICK", "EmployeeID": 2, "OrderDate": "1996-09-24 00:00:00", "RequiredDate": "1996-10-22 00:00:00", "ShippedDate": "1996-10-04 00:00:00", "ShipVia": 2, "Freight": 1.9600, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10314, "CustomerID": "RATTC", "EmployeeID": 1, "OrderDate": "1996-09-25 00:00:00", "RequiredDate": "1996-10-23 00:00:00", "ShippedDate": "1996-10-04 00:00:00", "ShipVia": 2, "Freight": 74.1600, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10315, "CustomerID": "ISLAT", "EmployeeID": 4, "OrderDate": "1996-09-26 00:00:00", "RequiredDate": "1996-10-24 00:00:00", "ShippedDate": "1996-10-03 00:00:00", "ShipVia": 2, "Freight": 41.7600, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10316, "CustomerID": "RATTC", "EmployeeID": 1, "OrderDate": "1996-09-27 00:00:00", "RequiredDate": "1996-10-25 00:00:00", "ShippedDate": "1996-10-08 00:00:00", "ShipVia": 3, "Freight": 150.1500, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10317, "CustomerID": "LONEP", "EmployeeID": 6, "OrderDate": "1996-09-30 00:00:00", "RequiredDate": "1996-10-28 00:00:00", "ShippedDate": "1996-10-10 00:00:00", "ShipVia": 1, "Freight": 12.6900, "ShipName": "Lonesome Pine Restaurant", "ShipAddress": "89 Chiaroscuro Rd.", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97219, "ShipCountry": "USA" }, { "OrderID": 10318, "CustomerID": "ISLAT", "EmployeeID": 8, "OrderDate": "1996-10-01 00:00:00", "RequiredDate": "1996-10-29 00:00:00", "ShippedDate": "1996-10-04 00:00:00", "ShipVia": 2, "Freight": 4.7300, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10319, "CustomerID": "TORTU", "EmployeeID": 7, "OrderDate": "1996-10-02 00:00:00", "RequiredDate": "1996-10-30 00:00:00", "ShippedDate": "1996-10-11 00:00:00", "ShipVia": 3, "Freight": 64.5000, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10320, "CustomerID": "WARTH", "EmployeeID": 5, "OrderDate": "1996-10-03 00:00:00", "RequiredDate": "1996-10-17 00:00:00", "ShippedDate": "1996-10-18 00:00:00", "ShipVia": 3, "Freight": 34.5700, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10321, "CustomerID": "ISLAT", "EmployeeID": 3, "OrderDate": "1996-10-03 00:00:00", "RequiredDate": "1996-10-31 00:00:00", "ShippedDate": "1996-10-11 00:00:00", "ShipVia": 2, "Freight": 3.4300, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10322, "CustomerID": "PERIC", "EmployeeID": 7, "OrderDate": "1996-10-04 00:00:00", "RequiredDate": "1996-11-01 00:00:00", "ShippedDate": "1996-10-23 00:00:00", "ShipVia": 3, "Freight": 0.4000, "ShipName": "Pericles Comidas clsicas", "ShipAddress": "Calle Dr. Jorge Cash 321", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10323, "CustomerID": "KOENE", "EmployeeID": 4, "OrderDate": "1996-10-07 00:00:00", "RequiredDate": "1996-11-04 00:00:00", "ShippedDate": "1996-10-14 00:00:00", "ShipVia": 1, "Freight": 4.8800, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10324, "CustomerID": "SAVEA", "EmployeeID": 9, "OrderDate": "1996-10-08 00:00:00", "RequiredDate": "1996-11-05 00:00:00", "ShippedDate": "1996-10-10 00:00:00", "ShipVia": 1, "Freight": 214.2700, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10325, "CustomerID": "KOENE", "EmployeeID": 1, "OrderDate": "1996-10-09 00:00:00", "RequiredDate": "1996-10-23 00:00:00", "ShippedDate": "1996-10-14 00:00:00", "ShipVia": 3, "Freight": 64.8600, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10326, "CustomerID": "BOLID", "EmployeeID": 4, "OrderDate": "1996-10-10 00:00:00", "RequiredDate": "1996-11-07 00:00:00", "ShippedDate": "1996-10-14 00:00:00", "ShipVia": 2, "Freight": 77.9200, "ShipName": "Blido Comidas preparadas", "ShipAddress": "C/ Araquil, 67", "ShipCity": "Madrid", "ShipRegion": null, "ShipPostalCode": 28023, "ShipCountry": "Spain" }, { "OrderID": 10327, "CustomerID": "FOLKO", "EmployeeID": 2, "OrderDate": "1996-10-11 00:00:00", "RequiredDate": "1996-11-08 00:00:00", "ShippedDate": "1996-10-14 00:00:00", "ShipVia": 1, "Freight": 63.3600, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10328, "CustomerID": "FURIB", "EmployeeID": 4, "OrderDate": "1996-10-14 00:00:00", "RequiredDate": "1996-11-11 00:00:00", "ShippedDate": "1996-10-17 00:00:00", "ShipVia": 3, "Freight": 87.0300, "ShipName": "Furia Bacalhau e Frutos do Mar", "ShipAddress": "Jardim das rosas n. 32", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1675, "ShipCountry": "Portugal" }, { "OrderID": 10329, "CustomerID": "SPLIR", "EmployeeID": 4, "OrderDate": "1996-10-15 00:00:00", "RequiredDate": "1996-11-26 00:00:00", "ShippedDate": "1996-10-23 00:00:00", "ShipVia": 2, "Freight": 191.6700, "ShipName": "Split Rail Beer & Ale", "ShipAddress": "P.O. Box 555", "ShipCity": "Lander", "ShipRegion": "WY", "ShipPostalCode": 82520, "ShipCountry": "USA" }, { "OrderID": 10330, "CustomerID": "LILAS", "EmployeeID": 3, "OrderDate": "1996-10-16 00:00:00", "RequiredDate": "1996-11-13 00:00:00", "ShippedDate": "1996-10-28 00:00:00", "ShipVia": 1, "Freight": 12.7500, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10331, "CustomerID": "BONAP", "EmployeeID": 9, "OrderDate": "1996-10-16 00:00:00", "RequiredDate": "1996-11-27 00:00:00", "ShippedDate": "1996-10-21 00:00:00", "ShipVia": 1, "Freight": 10.1900, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10332, "CustomerID": "MEREP", "EmployeeID": 3, "OrderDate": "1996-10-17 00:00:00", "RequiredDate": "1996-11-28 00:00:00", "ShippedDate": "1996-10-21 00:00:00", "ShipVia": 2, "Freight": 52.8400, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10333, "CustomerID": "WARTH", "EmployeeID": 5, "OrderDate": "1996-10-18 00:00:00", "RequiredDate": "1996-11-15 00:00:00", "ShippedDate": "1996-10-25 00:00:00", "ShipVia": 3, "Freight": 0.5900, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10334, "CustomerID": "VICTE", "EmployeeID": 8, "OrderDate": "1996-10-21 00:00:00", "RequiredDate": "1996-11-18 00:00:00", "ShippedDate": "1996-10-28 00:00:00", "ShipVia": 2, "Freight": 8.5600, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10335, "CustomerID": "HUNGO", "EmployeeID": 7, "OrderDate": "1996-10-22 00:00:00", "RequiredDate": "1996-11-19 00:00:00", "ShippedDate": "1996-10-24 00:00:00", "ShipVia": 2, "Freight": 42.1100, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10336, "CustomerID": "PRINI", "EmployeeID": 7, "OrderDate": "1996-10-23 00:00:00", "RequiredDate": "1996-11-20 00:00:00", "ShippedDate": "1996-10-25 00:00:00", "ShipVia": 2, "Freight": 15.5100, "ShipName": "Princesa Isabel Vinhos", "ShipAddress": "Estrada da sade n. 58", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1756, "ShipCountry": "Portugal" }, { "OrderID": 10337, "CustomerID": "FRANK", "EmployeeID": 4, "OrderDate": "1996-10-24 00:00:00", "RequiredDate": "1996-11-21 00:00:00", "ShippedDate": "1996-10-29 00:00:00", "ShipVia": 3, "Freight": 108.2600, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10338, "CustomerID": "OLDWO", "EmployeeID": 4, "OrderDate": "1996-10-25 00:00:00", "RequiredDate": "1996-11-22 00:00:00", "ShippedDate": "1996-10-29 00:00:00", "ShipVia": 3, "Freight": 84.2100, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 10339, "CustomerID": "MEREP", "EmployeeID": 2, "OrderDate": "1996-10-28 00:00:00", "RequiredDate": "1996-11-25 00:00:00", "ShippedDate": "1996-11-04 00:00:00", "ShipVia": 2, "Freight": 15.6600, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10340, "CustomerID": "BONAP", "EmployeeID": 1, "OrderDate": "1996-10-29 00:00:00", "RequiredDate": "1996-11-26 00:00:00", "ShippedDate": "1996-11-08 00:00:00", "ShipVia": 3, "Freight": 166.3100, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10341, "CustomerID": "SIMOB", "EmployeeID": 7, "OrderDate": "1996-10-29 00:00:00", "RequiredDate": "1996-11-26 00:00:00", "ShippedDate": "1996-11-05 00:00:00", "ShipVia": 3, "Freight": 26.7800, "ShipName": "Simons bistro", "ShipAddress": "Vinbltet 34", "ShipCity": "Kobenhavn", "ShipRegion": null, "ShipPostalCode": 1734, "ShipCountry": "Denmark" }, { "OrderID": 10342, "CustomerID": "FRANK", "EmployeeID": 4, "OrderDate": "1996-10-30 00:00:00", "RequiredDate": "1996-11-13 00:00:00", "ShippedDate": "1996-11-04 00:00:00", "ShipVia": 2, "Freight": 54.8300, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10343, "CustomerID": "LEHMS", "EmployeeID": 4, "OrderDate": "1996-10-31 00:00:00", "RequiredDate": "1996-11-28 00:00:00", "ShippedDate": "1996-11-06 00:00:00", "ShipVia": 1, "Freight": 110.3700, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10344, "CustomerID": "WHITC", "EmployeeID": 4, "OrderDate": "1996-11-01 00:00:00", "RequiredDate": "1996-11-29 00:00:00", "ShippedDate": "1996-11-05 00:00:00", "ShipVia": 2, "Freight": 23.2900, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10345, "CustomerID": "QUICK", "EmployeeID": 2, "OrderDate": "1996-11-04 00:00:00", "RequiredDate": "1996-12-02 00:00:00", "ShippedDate": "1996-11-11 00:00:00", "ShipVia": 2, "Freight": 249.0600, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10346, "CustomerID": "RATTC", "EmployeeID": 3, "OrderDate": "1996-11-05 00:00:00", "RequiredDate": "1996-12-17 00:00:00", "ShippedDate": "1996-11-08 00:00:00", "ShipVia": 3, "Freight": 142.0800, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10347, "CustomerID": "FAMIA", "EmployeeID": 4, "OrderDate": "1996-11-06 00:00:00", "RequiredDate": "1996-12-04 00:00:00", "ShippedDate": "1996-11-08 00:00:00", "ShipVia": 3, "Freight": 3.1000, "ShipName": "Familia Arquibaldo", "ShipAddress": "Rua Ors, 92", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05442-030", "ShipCountry": "Brazil" }, { "OrderID": 10348, "CustomerID": "WANDK", "EmployeeID": 4, "OrderDate": "1996-11-07 00:00:00", "RequiredDate": "1996-12-05 00:00:00", "ShippedDate": "1996-11-15 00:00:00", "ShipVia": 2, "Freight": 0.7800, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 10349, "CustomerID": "SPLIR", "EmployeeID": 7, "OrderDate": "1996-11-08 00:00:00", "RequiredDate": "1996-12-06 00:00:00", "ShippedDate": "1996-11-15 00:00:00", "ShipVia": 1, "Freight": 8.6300, "ShipName": "Split Rail Beer & Ale", "ShipAddress": "P.O. Box 555", "ShipCity": "Lander", "ShipRegion": "WY", "ShipPostalCode": 82520, "ShipCountry": "USA" }, { "OrderID": 10350, "CustomerID": "LAMAI", "EmployeeID": 6, "OrderDate": "1996-11-11 00:00:00", "RequiredDate": "1996-12-09 00:00:00", "ShippedDate": "1996-12-03 00:00:00", "ShipVia": 2, "Freight": 64.1900, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10351, "CustomerID": "ERNSH", "EmployeeID": 1, "OrderDate": "1996-11-11 00:00:00", "RequiredDate": "1996-12-09 00:00:00", "ShippedDate": "1996-11-20 00:00:00", "ShipVia": 1, "Freight": 162.3300, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10352, "CustomerID": "FURIB", "EmployeeID": 3, "OrderDate": "1996-11-12 00:00:00", "RequiredDate": "1996-11-26 00:00:00", "ShippedDate": "1996-11-18 00:00:00", "ShipVia": 3, "Freight": 1.3000, "ShipName": "Furia Bacalhau e Frutos do Mar", "ShipAddress": "Jardim das rosas n. 32", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1675, "ShipCountry": "Portugal" }, { "OrderID": 10353, "CustomerID": "PICCO", "EmployeeID": 7, "OrderDate": "1996-11-13 00:00:00", "RequiredDate": "1996-12-11 00:00:00", "ShippedDate": "1996-11-25 00:00:00", "ShipVia": 3, "Freight": 360.6300, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 10354, "CustomerID": "PERIC", "EmployeeID": 8, "OrderDate": "1996-11-14 00:00:00", "RequiredDate": "1996-12-12 00:00:00", "ShippedDate": "1996-11-20 00:00:00", "ShipVia": 3, "Freight": 53.8000, "ShipName": "Pericles Comidas clsicas", "ShipAddress": "Calle Dr. Jorge Cash 321", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10355, "CustomerID": "AROUT", "EmployeeID": 6, "OrderDate": "1996-11-15 00:00:00", "RequiredDate": "1996-12-13 00:00:00", "ShippedDate": "1996-11-20 00:00:00", "ShipVia": 1, "Freight": 41.9500, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10356, "CustomerID": "WANDK", "EmployeeID": 6, "OrderDate": "1996-11-18 00:00:00", "RequiredDate": "1996-12-16 00:00:00", "ShippedDate": "1996-11-27 00:00:00", "ShipVia": 2, "Freight": 36.7100, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 10357, "CustomerID": "LILAS", "EmployeeID": 1, "OrderDate": "1996-11-19 00:00:00", "RequiredDate": "1996-12-17 00:00:00", "ShippedDate": "1996-12-02 00:00:00", "ShipVia": 3, "Freight": 34.8800, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10358, "CustomerID": "LAMAI", "EmployeeID": 5, "OrderDate": "1996-11-20 00:00:00", "RequiredDate": "1996-12-18 00:00:00", "ShippedDate": "1996-11-27 00:00:00", "ShipVia": 1, "Freight": 19.6400, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10359, "CustomerID": "SEVES", "EmployeeID": 5, "OrderDate": "1996-11-21 00:00:00", "RequiredDate": "1996-12-19 00:00:00", "ShippedDate": "1996-11-26 00:00:00", "ShipVia": 3, "Freight": 288.4300, "ShipName": "Seven Seas Imports", "ShipAddress": "90 Wadhurst Rd.", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "OX15 4NB", "ShipCountry": "UK" }, { "OrderID": 10360, "CustomerID": "BLONP", "EmployeeID": 4, "OrderDate": "1996-11-22 00:00:00", "RequiredDate": "1996-12-20 00:00:00", "ShippedDate": "1996-12-02 00:00:00", "ShipVia": 3, "Freight": 131.7000, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10361, "CustomerID": "QUICK", "EmployeeID": 1, "OrderDate": "1996-11-22 00:00:00", "RequiredDate": "1996-12-20 00:00:00", "ShippedDate": "1996-12-03 00:00:00", "ShipVia": 2, "Freight": 183.1700, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10362, "CustomerID": "BONAP", "EmployeeID": 3, "OrderDate": "1996-11-25 00:00:00", "RequiredDate": "1996-12-23 00:00:00", "ShippedDate": "1996-11-28 00:00:00", "ShipVia": 1, "Freight": 96.0400, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10363, "CustomerID": "DRACD", "EmployeeID": 4, "OrderDate": "1996-11-26 00:00:00", "RequiredDate": "1996-12-24 00:00:00", "ShippedDate": "1996-12-04 00:00:00", "ShipVia": 3, "Freight": 30.5400, "ShipName": "Drachenblut Delikatessen", "ShipAddress": "Walserweg 21", "ShipCity": "Aachen", "ShipRegion": null, "ShipPostalCode": 52066, "ShipCountry": "Germany" }, { "OrderID": 10364, "CustomerID": "EASTC", "EmployeeID": 1, "OrderDate": "1996-11-26 00:00:00", "RequiredDate": "1997-01-07 00:00:00", "ShippedDate": "1996-12-04 00:00:00", "ShipVia": 1, "Freight": 71.9700, "ShipName": "Eastern Connection", "ShipAddress": "35 King George", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX3 6FW", "ShipCountry": "UK" }, { "OrderID": 10365, "CustomerID": "ANTON", "EmployeeID": 3, "OrderDate": "1996-11-27 00:00:00", "RequiredDate": "1996-12-25 00:00:00", "ShippedDate": "1996-12-02 00:00:00", "ShipVia": 2, "Freight": 22.0000, "ShipName": "Antonio Moreno Taquera", "ShipAddress": "Mataderos 2312", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5023, "ShipCountry": "Mexico" }, { "OrderID": 10366, "CustomerID": "GALED", "EmployeeID": 8, "OrderDate": "1996-11-28 00:00:00", "RequiredDate": "1997-01-09 00:00:00", "ShippedDate": "1996-12-30 00:00:00", "ShipVia": 2, "Freight": 10.1400, "ShipName": "Galera del gastronmo", "ShipAddress": "Rambla de Catalua, 23", "ShipCity": "Barcelona", "ShipRegion": null, "ShipPostalCode": 8022, "ShipCountry": "Spain" }, { "OrderID": 10367, "CustomerID": "VAFFE", "EmployeeID": 7, "OrderDate": "1996-11-28 00:00:00", "RequiredDate": "1996-12-26 00:00:00", "ShippedDate": "1996-12-02 00:00:00", "ShipVia": 3, "Freight": 13.5500, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10368, "CustomerID": "ERNSH", "EmployeeID": 2, "OrderDate": "1996-11-29 00:00:00", "RequiredDate": "1996-12-27 00:00:00", "ShippedDate": "1996-12-02 00:00:00", "ShipVia": 2, "Freight": 101.9500, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10369, "CustomerID": "SPLIR", "EmployeeID": 8, "OrderDate": "1996-12-02 00:00:00", "RequiredDate": "1996-12-30 00:00:00", "ShippedDate": "1996-12-09 00:00:00", "ShipVia": 2, "Freight": 195.6800, "ShipName": "Split Rail Beer & Ale", "ShipAddress": "P.O. Box 555", "ShipCity": "Lander", "ShipRegion": "WY", "ShipPostalCode": 82520, "ShipCountry": "USA" }, { "OrderID": 10370, "CustomerID": "CHOPS", "EmployeeID": 6, "OrderDate": "1996-12-03 00:00:00", "RequiredDate": "1996-12-31 00:00:00", "ShippedDate": "1996-12-27 00:00:00", "ShipVia": 2, "Freight": 1.1700, "ShipName": "Chop-suey Chinese", "ShipAddress": "Hauptstr. 31", "ShipCity": "Bern", "ShipRegion": null, "ShipPostalCode": 3012, "ShipCountry": "Switzerland" }, { "OrderID": 10371, "CustomerID": "LAMAI", "EmployeeID": 1, "OrderDate": "1996-12-03 00:00:00", "RequiredDate": "1996-12-31 00:00:00", "ShippedDate": "1996-12-24 00:00:00", "ShipVia": 1, "Freight": 0.4500, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10372, "CustomerID": "QUEEN", "EmployeeID": 5, "OrderDate": "1996-12-04 00:00:00", "RequiredDate": "1997-01-01 00:00:00", "ShippedDate": "1996-12-09 00:00:00", "ShipVia": 2, "Freight": 890.7800, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10373, "CustomerID": "HUNGO", "EmployeeID": 4, "OrderDate": "1996-12-05 00:00:00", "RequiredDate": "1997-01-02 00:00:00", "ShippedDate": "1996-12-11 00:00:00", "ShipVia": 3, "Freight": 124.1200, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10374, "CustomerID": "WOLZA", "EmployeeID": 1, "OrderDate": "1996-12-05 00:00:00", "RequiredDate": "1997-01-02 00:00:00", "ShippedDate": "1996-12-09 00:00:00", "ShipVia": 3, "Freight": 3.9400, "ShipName": "Wolski Zajazd", "ShipAddress": "ul. Filtrowa 68", "ShipCity": "Warszawa", "ShipRegion": null, "ShipPostalCode": "01-012", "ShipCountry": "Poland" }, { "OrderID": 10375, "CustomerID": "HUNGC", "EmployeeID": 3, "OrderDate": "1996-12-06 00:00:00", "RequiredDate": "1997-01-03 00:00:00", "ShippedDate": "1996-12-09 00:00:00", "ShipVia": 2, "Freight": 20.1200, "ShipName": "Hungry Coyote Import Store", "ShipAddress": "City Center Plaza 516 Main St.", "ShipCity": "Elgin", "ShipRegion": "OR", "ShipPostalCode": 97827, "ShipCountry": "USA" }, { "OrderID": 10376, "CustomerID": "MEREP", "EmployeeID": 1, "OrderDate": "1996-12-09 00:00:00", "RequiredDate": "1997-01-06 00:00:00", "ShippedDate": "1996-12-13 00:00:00", "ShipVia": 2, "Freight": 20.3900, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10377, "CustomerID": "SEVES", "EmployeeID": 1, "OrderDate": "1996-12-09 00:00:00", "RequiredDate": "1997-01-06 00:00:00", "ShippedDate": "1996-12-13 00:00:00", "ShipVia": 3, "Freight": 22.2100, "ShipName": "Seven Seas Imports", "ShipAddress": "90 Wadhurst Rd.", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "OX15 4NB", "ShipCountry": "UK" }, { "OrderID": 10378, "CustomerID": "FOLKO", "EmployeeID": 5, "OrderDate": "1996-12-10 00:00:00", "RequiredDate": "1997-01-07 00:00:00", "ShippedDate": "1996-12-19 00:00:00", "ShipVia": 3, "Freight": 5.4400, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10379, "CustomerID": "QUEDE", "EmployeeID": 2, "OrderDate": "1996-12-11 00:00:00", "RequiredDate": "1997-01-08 00:00:00", "ShippedDate": "1996-12-13 00:00:00", "ShipVia": 1, "Freight": 45.0300, "ShipName": "Que Delcia", "ShipAddress": "Rua da Panificadora, 12", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-673", "ShipCountry": "Brazil" }, { "OrderID": 10380, "CustomerID": "HUNGO", "EmployeeID": 8, "OrderDate": "1996-12-12 00:00:00", "RequiredDate": "1997-01-09 00:00:00", "ShippedDate": "1997-01-16 00:00:00", "ShipVia": 3, "Freight": 35.0300, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10381, "CustomerID": "LILAS", "EmployeeID": 3, "OrderDate": "1996-12-12 00:00:00", "RequiredDate": "1997-01-09 00:00:00", "ShippedDate": "1996-12-13 00:00:00", "ShipVia": 3, "Freight": 7.9900, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10382, "CustomerID": "ERNSH", "EmployeeID": 4, "OrderDate": "1996-12-13 00:00:00", "RequiredDate": "1997-01-10 00:00:00", "ShippedDate": "1996-12-16 00:00:00", "ShipVia": 1, "Freight": 94.7700, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10383, "CustomerID": "AROUT", "EmployeeID": 8, "OrderDate": "1996-12-16 00:00:00", "RequiredDate": "1997-01-13 00:00:00", "ShippedDate": "1996-12-18 00:00:00", "ShipVia": 3, "Freight": 34.2400, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10384, "CustomerID": "BERGS", "EmployeeID": 3, "OrderDate": "1996-12-16 00:00:00", "RequiredDate": "1997-01-13 00:00:00", "ShippedDate": "1996-12-20 00:00:00", "ShipVia": 3, "Freight": 168.6400, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10385, "CustomerID": "SPLIR", "EmployeeID": 1, "OrderDate": "1996-12-17 00:00:00", "RequiredDate": "1997-01-14 00:00:00", "ShippedDate": "1996-12-23 00:00:00", "ShipVia": 2, "Freight": 30.9600, "ShipName": "Split Rail Beer & Ale", "ShipAddress": "P.O. Box 555", "ShipCity": "Lander", "ShipRegion": "WY", "ShipPostalCode": 82520, "ShipCountry": "USA" }, { "OrderID": 10386, "CustomerID": "FAMIA", "EmployeeID": 9, "OrderDate": "1996-12-18 00:00:00", "RequiredDate": "1997-01-01 00:00:00", "ShippedDate": "1996-12-25 00:00:00", "ShipVia": 3, "Freight": 13.9900, "ShipName": "Familia Arquibaldo", "ShipAddress": "Rua Ors, 92", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05442-030", "ShipCountry": "Brazil" }, { "OrderID": 10387, "CustomerID": "SANTG", "EmployeeID": 1, "OrderDate": "1996-12-18 00:00:00", "RequiredDate": "1997-01-15 00:00:00", "ShippedDate": "1996-12-20 00:00:00", "ShipVia": 2, "Freight": 93.6300, "ShipName": "Sant Gourmet", "ShipAddress": "Erling Skakkes gate 78", "ShipCity": "Stavern", "ShipRegion": null, "ShipPostalCode": 4110, "ShipCountry": "Norway" }, { "OrderID": 10388, "CustomerID": "SEVES", "EmployeeID": 2, "OrderDate": "1996-12-19 00:00:00", "RequiredDate": "1997-01-16 00:00:00", "ShippedDate": "1996-12-20 00:00:00", "ShipVia": 1, "Freight": 34.8600, "ShipName": "Seven Seas Imports", "ShipAddress": "90 Wadhurst Rd.", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "OX15 4NB", "ShipCountry": "UK" }, { "OrderID": 10389, "CustomerID": "BOTTM", "EmployeeID": 4, "OrderDate": "1996-12-20 00:00:00", "RequiredDate": "1997-01-17 00:00:00", "ShippedDate": "1996-12-24 00:00:00", "ShipVia": 2, "Freight": 47.4200, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10390, "CustomerID": "ERNSH", "EmployeeID": 6, "OrderDate": "1996-12-23 00:00:00", "RequiredDate": "1997-01-20 00:00:00", "ShippedDate": "1996-12-26 00:00:00", "ShipVia": 1, "Freight": 126.3800, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10391, "CustomerID": "DRACD", "EmployeeID": 3, "OrderDate": "1996-12-23 00:00:00", "RequiredDate": "1997-01-20 00:00:00", "ShippedDate": "1996-12-31 00:00:00", "ShipVia": 3, "Freight": 5.4500, "ShipName": "Drachenblut Delikatessen", "ShipAddress": "Walserweg 21", "ShipCity": "Aachen", "ShipRegion": null, "ShipPostalCode": 52066, "ShipCountry": "Germany" }, { "OrderID": 10392, "CustomerID": "PICCO", "EmployeeID": 2, "OrderDate": "1996-12-24 00:00:00", "RequiredDate": "1997-01-21 00:00:00", "ShippedDate": "1997-01-01 00:00:00", "ShipVia": 3, "Freight": 122.4600, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 10393, "CustomerID": "SAVEA", "EmployeeID": 1, "OrderDate": "1996-12-25 00:00:00", "RequiredDate": "1997-01-22 00:00:00", "ShippedDate": "1997-01-03 00:00:00", "ShipVia": 3, "Freight": 126.5600, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10394, "CustomerID": "HUNGC", "EmployeeID": 1, "OrderDate": "1996-12-25 00:00:00", "RequiredDate": "1997-01-22 00:00:00", "ShippedDate": "1997-01-03 00:00:00", "ShipVia": 3, "Freight": 30.3400, "ShipName": "Hungry Coyote Import Store", "ShipAddress": "City Center Plaza 516 Main St.", "ShipCity": "Elgin", "ShipRegion": "OR", "ShipPostalCode": 97827, "ShipCountry": "USA" }, { "OrderID": 10395, "CustomerID": "HILAA", "EmployeeID": 6, "OrderDate": "1996-12-26 00:00:00", "RequiredDate": "1997-01-23 00:00:00", "ShippedDate": "1997-01-03 00:00:00", "ShipVia": 1, "Freight": 184.4100, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10396, "CustomerID": "FRANK", "EmployeeID": 1, "OrderDate": "1996-12-27 00:00:00", "RequiredDate": "1997-01-10 00:00:00", "ShippedDate": "1997-01-06 00:00:00", "ShipVia": 3, "Freight": 135.3500, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10397, "CustomerID": "PRINI", "EmployeeID": 5, "OrderDate": "1996-12-27 00:00:00", "RequiredDate": "1997-01-24 00:00:00", "ShippedDate": "1997-01-02 00:00:00", "ShipVia": 1, "Freight": 60.2600, "ShipName": "Princesa Isabel Vinhos", "ShipAddress": "Estrada da sade n. 58", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1756, "ShipCountry": "Portugal" }, { "OrderID": 10398, "CustomerID": "SAVEA", "EmployeeID": 2, "OrderDate": "1996-12-30 00:00:00", "RequiredDate": "1997-01-27 00:00:00", "ShippedDate": "1997-01-09 00:00:00", "ShipVia": 3, "Freight": 89.1600, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10399, "CustomerID": "VAFFE", "EmployeeID": 8, "OrderDate": "1996-12-31 00:00:00", "RequiredDate": "1997-01-14 00:00:00", "ShippedDate": "1997-01-08 00:00:00", "ShipVia": 3, "Freight": 27.3600, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10400, "CustomerID": "EASTC", "EmployeeID": 1, "OrderDate": "1997-01-01 00:00:00", "RequiredDate": "1997-01-29 00:00:00", "ShippedDate": "1997-01-16 00:00:00", "ShipVia": 3, "Freight": 83.9300, "ShipName": "Eastern Connection", "ShipAddress": "35 King George", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX3 6FW", "ShipCountry": "UK" }, { "OrderID": 10401, "CustomerID": "RATTC", "EmployeeID": 1, "OrderDate": "1997-01-01 00:00:00", "RequiredDate": "1997-01-29 00:00:00", "ShippedDate": "1997-01-10 00:00:00", "ShipVia": 1, "Freight": 12.5100, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10402, "CustomerID": "ERNSH", "EmployeeID": 8, "OrderDate": "1997-01-02 00:00:00", "RequiredDate": "1997-02-13 00:00:00", "ShippedDate": "1997-01-10 00:00:00", "ShipVia": 2, "Freight": 67.8800, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10403, "CustomerID": "ERNSH", "EmployeeID": 4, "OrderDate": "1997-01-03 00:00:00", "RequiredDate": "1997-01-31 00:00:00", "ShippedDate": "1997-01-09 00:00:00", "ShipVia": 3, "Freight": 73.7900, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10404, "CustomerID": "MAGAA", "EmployeeID": 2, "OrderDate": "1997-01-03 00:00:00", "RequiredDate": "1997-01-31 00:00:00", "ShippedDate": "1997-01-08 00:00:00", "ShipVia": 1, "Freight": 155.9700, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10405, "CustomerID": "LINOD", "EmployeeID": 1, "OrderDate": "1997-01-06 00:00:00", "RequiredDate": "1997-02-03 00:00:00", "ShippedDate": "1997-01-22 00:00:00", "ShipVia": 1, "Freight": 34.8200, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10406, "CustomerID": "QUEEN", "EmployeeID": 7, "OrderDate": "1997-01-07 00:00:00", "RequiredDate": "1997-02-18 00:00:00", "ShippedDate": "1997-01-13 00:00:00", "ShipVia": 1, "Freight": 108.0400, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10407, "CustomerID": "OTTIK", "EmployeeID": 2, "OrderDate": "1997-01-07 00:00:00", "RequiredDate": "1997-02-04 00:00:00", "ShippedDate": "1997-01-30 00:00:00", "ShipVia": 2, "Freight": 91.4800, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 10408, "CustomerID": "FOLIG", "EmployeeID": 8, "OrderDate": "1997-01-08 00:00:00", "RequiredDate": "1997-02-05 00:00:00", "ShippedDate": "1997-01-14 00:00:00", "ShipVia": 1, "Freight": 11.2600, "ShipName": "Folies gourmandes", "ShipAddress": "184, chausse de Tournai", "ShipCity": "Lille", "ShipRegion": null, "ShipPostalCode": 59000, "ShipCountry": "France" }, { "OrderID": 10409, "CustomerID": "OCEAN", "EmployeeID": 3, "OrderDate": "1997-01-09 00:00:00", "RequiredDate": "1997-02-06 00:00:00", "ShippedDate": "1997-01-14 00:00:00", "ShipVia": 1, "Freight": 29.8300, "ShipName": "Ocano Atlntico Ltda.", "ShipAddress": "Ing. Gustavo Moncada 8585 Piso 20-A", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10410, "CustomerID": "BOTTM", "EmployeeID": 3, "OrderDate": "1997-01-10 00:00:00", "RequiredDate": "1997-02-07 00:00:00", "ShippedDate": "1997-01-15 00:00:00", "ShipVia": 3, "Freight": 2.4000, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10411, "CustomerID": "BOTTM", "EmployeeID": 9, "OrderDate": "1997-01-10 00:00:00", "RequiredDate": "1997-02-07 00:00:00", "ShippedDate": "1997-01-21 00:00:00", "ShipVia": 3, "Freight": 23.6500, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10412, "CustomerID": "WARTH", "EmployeeID": 8, "OrderDate": "1997-01-13 00:00:00", "RequiredDate": "1997-02-10 00:00:00", "ShippedDate": "1997-01-15 00:00:00", "ShipVia": 2, "Freight": 3.7700, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10413, "CustomerID": "LAMAI", "EmployeeID": 3, "OrderDate": "1997-01-14 00:00:00", "RequiredDate": "1997-02-11 00:00:00", "ShippedDate": "1997-01-16 00:00:00", "ShipVia": 2, "Freight": 95.6600, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10414, "CustomerID": "FAMIA", "EmployeeID": 2, "OrderDate": "1997-01-14 00:00:00", "RequiredDate": "1997-02-11 00:00:00", "ShippedDate": "1997-01-17 00:00:00", "ShipVia": 3, "Freight": 21.4800, "ShipName": "Familia Arquibaldo", "ShipAddress": "Rua Ors, 92", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05442-030", "ShipCountry": "Brazil" }, { "OrderID": 10415, "CustomerID": "HUNGC", "EmployeeID": 3, "OrderDate": "1997-01-15 00:00:00", "RequiredDate": "1997-02-12 00:00:00", "ShippedDate": "1997-01-24 00:00:00", "ShipVia": 1, "Freight": 0.2000, "ShipName": "Hungry Coyote Import Store", "ShipAddress": "City Center Plaza 516 Main St.", "ShipCity": "Elgin", "ShipRegion": "OR", "ShipPostalCode": 97827, "ShipCountry": "USA" }, { "OrderID": 10416, "CustomerID": "WARTH", "EmployeeID": 8, "OrderDate": "1997-01-16 00:00:00", "RequiredDate": "1997-02-13 00:00:00", "ShippedDate": "1997-01-27 00:00:00", "ShipVia": 3, "Freight": 22.7200, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10417, "CustomerID": "SIMOB", "EmployeeID": 4, "OrderDate": "1997-01-16 00:00:00", "RequiredDate": "1997-02-13 00:00:00", "ShippedDate": "1997-01-28 00:00:00", "ShipVia": 3, "Freight": 70.2900, "ShipName": "Simons bistro", "ShipAddress": "Vinbltet 34", "ShipCity": "Kobenhavn", "ShipRegion": null, "ShipPostalCode": 1734, "ShipCountry": "Denmark" }, { "OrderID": 10418, "CustomerID": "QUICK", "EmployeeID": 4, "OrderDate": "1997-01-17 00:00:00", "RequiredDate": "1997-02-14 00:00:00", "ShippedDate": "1997-01-24 00:00:00", "ShipVia": 1, "Freight": 17.5500, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10419, "CustomerID": "RICSU", "EmployeeID": 4, "OrderDate": "1997-01-20 00:00:00", "RequiredDate": "1997-02-17 00:00:00", "ShippedDate": "1997-01-30 00:00:00", "ShipVia": 2, "Freight": 137.3500, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 10420, "CustomerID": "WELLI", "EmployeeID": 3, "OrderDate": "1997-01-21 00:00:00", "RequiredDate": "1997-02-18 00:00:00", "ShippedDate": "1997-01-27 00:00:00", "ShipVia": 1, "Freight": 44.1200, "ShipName": "Wellington Importadora", "ShipAddress": "Rua do Mercado, 12", "ShipCity": "Resende", "ShipRegion": "SP", "ShipPostalCode": "08737-363", "ShipCountry": "Brazil" }, { "OrderID": 10421, "CustomerID": "QUEDE", "EmployeeID": 8, "OrderDate": "1997-01-21 00:00:00", "RequiredDate": "1997-03-04 00:00:00", "ShippedDate": "1997-01-27 00:00:00", "ShipVia": 1, "Freight": 99.2300, "ShipName": "Que Delcia", "ShipAddress": "Rua da Panificadora, 12", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-673", "ShipCountry": "Brazil" }, { "OrderID": 10422, "CustomerID": "FRANS", "EmployeeID": 2, "OrderDate": "1997-01-22 00:00:00", "RequiredDate": "1997-02-19 00:00:00", "ShippedDate": "1997-01-31 00:00:00", "ShipVia": 1, "Freight": 3.0200, "ShipName": "Franchi S.p.A.", "ShipAddress": "Via Monte Bianco 34", "ShipCity": "Torino", "ShipRegion": null, "ShipPostalCode": 10100, "ShipCountry": "Italy" }, { "OrderID": 10423, "CustomerID": "GOURL", "EmployeeID": 6, "OrderDate": "1997-01-23 00:00:00", "RequiredDate": "1997-02-06 00:00:00", "ShippedDate": "1997-02-24 00:00:00", "ShipVia": 3, "Freight": 24.5000, "ShipName": "Gourmet Lanchonetes", "ShipAddress": "Av. Brasil, 442", "ShipCity": "Campinas", "ShipRegion": "SP", "ShipPostalCode": "04876-786", "ShipCountry": "Brazil" }, { "OrderID": 10424, "CustomerID": "MEREP", "EmployeeID": 7, "OrderDate": "1997-01-23 00:00:00", "RequiredDate": "1997-02-20 00:00:00", "ShippedDate": "1997-01-27 00:00:00", "ShipVia": 2, "Freight": 370.6100, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10425, "CustomerID": "LAMAI", "EmployeeID": 6, "OrderDate": "1997-01-24 00:00:00", "RequiredDate": "1997-02-21 00:00:00", "ShippedDate": "1997-02-14 00:00:00", "ShipVia": 2, "Freight": 7.9300, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10426, "CustomerID": "GALED", "EmployeeID": 4, "OrderDate": "1997-01-27 00:00:00", "RequiredDate": "1997-02-24 00:00:00", "ShippedDate": "1997-02-06 00:00:00", "ShipVia": 1, "Freight": 18.6900, "ShipName": "Galera del gastronmo", "ShipAddress": "Rambla de Catalua, 23", "ShipCity": "Barcelona", "ShipRegion": null, "ShipPostalCode": 8022, "ShipCountry": "Spain" }, { "OrderID": 10427, "CustomerID": "PICCO", "EmployeeID": 4, "OrderDate": "1997-01-27 00:00:00", "RequiredDate": "1997-02-24 00:00:00", "ShippedDate": "1997-03-03 00:00:00", "ShipVia": 2, "Freight": 31.2900, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 10428, "CustomerID": "REGGC", "EmployeeID": 7, "OrderDate": "1997-01-28 00:00:00", "RequiredDate": "1997-02-25 00:00:00", "ShippedDate": "1997-02-04 00:00:00", "ShipVia": 1, "Freight": 11.0900, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10429, "CustomerID": "HUNGO", "EmployeeID": 3, "OrderDate": "1997-01-29 00:00:00", "RequiredDate": "1997-03-12 00:00:00", "ShippedDate": "1997-02-07 00:00:00", "ShipVia": 2, "Freight": 56.6300, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10430, "CustomerID": "ERNSH", "EmployeeID": 4, "OrderDate": "1997-01-30 00:00:00", "RequiredDate": "1997-02-13 00:00:00", "ShippedDate": "1997-02-03 00:00:00", "ShipVia": 1, "Freight": 458.7800, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10431, "CustomerID": "BOTTM", "EmployeeID": 4, "OrderDate": "1997-01-30 00:00:00", "RequiredDate": "1997-02-13 00:00:00", "ShippedDate": "1997-02-07 00:00:00", "ShipVia": 2, "Freight": 44.1700, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10432, "CustomerID": "SPLIR", "EmployeeID": 3, "OrderDate": "1997-01-31 00:00:00", "RequiredDate": "1997-02-14 00:00:00", "ShippedDate": "1997-02-07 00:00:00", "ShipVia": 2, "Freight": 4.3400, "ShipName": "Split Rail Beer & Ale", "ShipAddress": "P.O. Box 555", "ShipCity": "Lander", "ShipRegion": "WY", "ShipPostalCode": 82520, "ShipCountry": "USA" }, { "OrderID": 10433, "CustomerID": "PRINI", "EmployeeID": 3, "OrderDate": "1997-02-03 00:00:00", "RequiredDate": "1997-03-03 00:00:00", "ShippedDate": "1997-03-04 00:00:00", "ShipVia": 3, "Freight": 73.8300, "ShipName": "Princesa Isabel Vinhos", "ShipAddress": "Estrada da sade n. 58", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1756, "ShipCountry": "Portugal" }, { "OrderID": 10434, "CustomerID": "FOLKO", "EmployeeID": 3, "OrderDate": "1997-02-03 00:00:00", "RequiredDate": "1997-03-03 00:00:00", "ShippedDate": "1997-02-13 00:00:00", "ShipVia": 2, "Freight": 17.9200, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10435, "CustomerID": "CONSH", "EmployeeID": 8, "OrderDate": "1997-02-04 00:00:00", "RequiredDate": "1997-03-18 00:00:00", "ShippedDate": "1997-02-07 00:00:00", "ShipVia": 2, "Freight": 9.2100, "ShipName": "Consolidated Holdings", "ShipAddress": "Berkeley Gardens 12 Brewery", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX1 6LT", "ShipCountry": "UK" }, { "OrderID": 10436, "CustomerID": "BLONP", "EmployeeID": 3, "OrderDate": "1997-02-05 00:00:00", "RequiredDate": "1997-03-05 00:00:00", "ShippedDate": "1997-02-11 00:00:00", "ShipVia": 2, "Freight": 156.6600, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10437, "CustomerID": "WARTH", "EmployeeID": 8, "OrderDate": "1997-02-05 00:00:00", "RequiredDate": "1997-03-05 00:00:00", "ShippedDate": "1997-02-12 00:00:00", "ShipVia": 1, "Freight": 19.9700, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10438, "CustomerID": "TOMSP", "EmployeeID": 3, "OrderDate": "1997-02-06 00:00:00", "RequiredDate": "1997-03-06 00:00:00", "ShippedDate": "1997-02-14 00:00:00", "ShipVia": 2, "Freight": 8.2400, "ShipName": "Toms Spezialitten", "ShipAddress": "Luisenstr. 48", "ShipCity": "Mnster", "ShipRegion": null, "ShipPostalCode": 44087, "ShipCountry": "Germany" }, { "OrderID": 10439, "CustomerID": "MEREP", "EmployeeID": 6, "OrderDate": "1997-02-07 00:00:00", "RequiredDate": "1997-03-07 00:00:00", "ShippedDate": "1997-02-10 00:00:00", "ShipVia": 3, "Freight": 4.0700, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10440, "CustomerID": "SAVEA", "EmployeeID": 4, "OrderDate": "1997-02-10 00:00:00", "RequiredDate": "1997-03-10 00:00:00", "ShippedDate": "1997-02-28 00:00:00", "ShipVia": 2, "Freight": 86.5300, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10441, "CustomerID": "OLDWO", "EmployeeID": 3, "OrderDate": "1997-02-10 00:00:00", "RequiredDate": "1997-03-24 00:00:00", "ShippedDate": "1997-03-14 00:00:00", "ShipVia": 2, "Freight": 73.0200, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 10442, "CustomerID": "ERNSH", "EmployeeID": 3, "OrderDate": "1997-02-11 00:00:00", "RequiredDate": "1997-03-11 00:00:00", "ShippedDate": "1997-02-18 00:00:00", "ShipVia": 2, "Freight": 47.9400, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10443, "CustomerID": "REGGC", "EmployeeID": 8, "OrderDate": "1997-02-12 00:00:00", "RequiredDate": "1997-03-12 00:00:00", "ShippedDate": "1997-02-14 00:00:00", "ShipVia": 1, "Freight": 13.9500, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10444, "CustomerID": "BERGS", "EmployeeID": 3, "OrderDate": "1997-02-12 00:00:00", "RequiredDate": "1997-03-12 00:00:00", "ShippedDate": "1997-02-21 00:00:00", "ShipVia": 3, "Freight": 3.5000, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10445, "CustomerID": "BERGS", "EmployeeID": 3, "OrderDate": "1997-02-13 00:00:00", "RequiredDate": "1997-03-13 00:00:00", "ShippedDate": "1997-02-20 00:00:00", "ShipVia": 1, "Freight": 9.3000, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10446, "CustomerID": "TOMSP", "EmployeeID": 6, "OrderDate": "1997-02-14 00:00:00", "RequiredDate": "1997-03-14 00:00:00", "ShippedDate": "1997-02-19 00:00:00", "ShipVia": 1, "Freight": 14.6800, "ShipName": "Toms Spezialitten", "ShipAddress": "Luisenstr. 48", "ShipCity": "Mnster", "ShipRegion": null, "ShipPostalCode": 44087, "ShipCountry": "Germany" }, { "OrderID": 10447, "CustomerID": "RICAR", "EmployeeID": 4, "OrderDate": "1997-02-14 00:00:00", "RequiredDate": "1997-03-14 00:00:00", "ShippedDate": "1997-03-07 00:00:00", "ShipVia": 2, "Freight": 68.6600, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10448, "CustomerID": "RANCH", "EmployeeID": 4, "OrderDate": "1997-02-17 00:00:00", "RequiredDate": "1997-03-17 00:00:00", "ShippedDate": "1997-02-24 00:00:00", "ShipVia": 2, "Freight": 38.8200, "ShipName": "Rancho grande", "ShipAddress": "Av. del Libertador 900", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10449, "CustomerID": "BLONP", "EmployeeID": 3, "OrderDate": "1997-02-18 00:00:00", "RequiredDate": "1997-03-18 00:00:00", "ShippedDate": "1997-02-27 00:00:00", "ShipVia": 2, "Freight": 53.3000, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10450, "CustomerID": "VICTE", "EmployeeID": 8, "OrderDate": "1997-02-19 00:00:00", "RequiredDate": "1997-03-19 00:00:00", "ShippedDate": "1997-03-11 00:00:00", "ShipVia": 2, "Freight": 7.2300, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10451, "CustomerID": "QUICK", "EmployeeID": 4, "OrderDate": "1997-02-19 00:00:00", "RequiredDate": "1997-03-05 00:00:00", "ShippedDate": "1997-03-12 00:00:00", "ShipVia": 3, "Freight": 189.0900, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10452, "CustomerID": "SAVEA", "EmployeeID": 8, "OrderDate": "1997-02-20 00:00:00", "RequiredDate": "1997-03-20 00:00:00", "ShippedDate": "1997-02-26 00:00:00", "ShipVia": 1, "Freight": 140.2600, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10453, "CustomerID": "AROUT", "EmployeeID": 1, "OrderDate": "1997-02-21 00:00:00", "RequiredDate": "1997-03-21 00:00:00", "ShippedDate": "1997-02-26 00:00:00", "ShipVia": 2, "Freight": 25.3600, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10454, "CustomerID": "LAMAI", "EmployeeID": 4, "OrderDate": "1997-02-21 00:00:00", "RequiredDate": "1997-03-21 00:00:00", "ShippedDate": "1997-02-25 00:00:00", "ShipVia": 3, "Freight": 2.7400, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10455, "CustomerID": "WARTH", "EmployeeID": 8, "OrderDate": "1997-02-24 00:00:00", "RequiredDate": "1997-04-07 00:00:00", "ShippedDate": "1997-03-03 00:00:00", "ShipVia": 2, "Freight": 180.4500, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10456, "CustomerID": "KOENE", "EmployeeID": 8, "OrderDate": "1997-02-25 00:00:00", "RequiredDate": "1997-04-08 00:00:00", "ShippedDate": "1997-02-28 00:00:00", "ShipVia": 2, "Freight": 8.1200, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10457, "CustomerID": "KOENE", "EmployeeID": 2, "OrderDate": "1997-02-25 00:00:00", "RequiredDate": "1997-03-25 00:00:00", "ShippedDate": "1997-03-03 00:00:00", "ShipVia": 1, "Freight": 11.5700, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10458, "CustomerID": "SUPRD", "EmployeeID": 7, "OrderDate": "1997-02-26 00:00:00", "RequiredDate": "1997-03-26 00:00:00", "ShippedDate": "1997-03-04 00:00:00", "ShipVia": 3, "Freight": 147.0600, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10459, "CustomerID": "VICTE", "EmployeeID": 4, "OrderDate": "1997-02-27 00:00:00", "RequiredDate": "1997-03-27 00:00:00", "ShippedDate": "1997-02-28 00:00:00", "ShipVia": 2, "Freight": 25.0900, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10460, "CustomerID": "FOLKO", "EmployeeID": 8, "OrderDate": "1997-02-28 00:00:00", "RequiredDate": "1997-03-28 00:00:00", "ShippedDate": "1997-03-03 00:00:00", "ShipVia": 1, "Freight": 16.2700, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10461, "CustomerID": "LILAS", "EmployeeID": 1, "OrderDate": "1997-02-28 00:00:00", "RequiredDate": "1997-03-28 00:00:00", "ShippedDate": "1997-03-05 00:00:00", "ShipVia": 3, "Freight": 148.6100, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10462, "CustomerID": "CONSH", "EmployeeID": 2, "OrderDate": "1997-03-03 00:00:00", "RequiredDate": "1997-03-31 00:00:00", "ShippedDate": "1997-03-18 00:00:00", "ShipVia": 1, "Freight": 6.1700, "ShipName": "Consolidated Holdings", "ShipAddress": "Berkeley Gardens 12 Brewery", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX1 6LT", "ShipCountry": "UK" }, { "OrderID": 10463, "CustomerID": "SUPRD", "EmployeeID": 5, "OrderDate": "1997-03-04 00:00:00", "RequiredDate": "1997-04-01 00:00:00", "ShippedDate": "1997-03-06 00:00:00", "ShipVia": 3, "Freight": 14.7800, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10464, "CustomerID": "FURIB", "EmployeeID": 4, "OrderDate": "1997-03-04 00:00:00", "RequiredDate": "1997-04-01 00:00:00", "ShippedDate": "1997-03-14 00:00:00", "ShipVia": 2, "Freight": 89.0000, "ShipName": "Furia Bacalhau e Frutos do Mar", "ShipAddress": "Jardim das rosas n. 32", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1675, "ShipCountry": "Portugal" }, { "OrderID": 10465, "CustomerID": "VAFFE", "EmployeeID": 1, "OrderDate": "1997-03-05 00:00:00", "RequiredDate": "1997-04-02 00:00:00", "ShippedDate": "1997-03-14 00:00:00", "ShipVia": 3, "Freight": 145.0400, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10466, "CustomerID": "COMMI", "EmployeeID": 4, "OrderDate": "1997-03-06 00:00:00", "RequiredDate": "1997-04-03 00:00:00", "ShippedDate": "1997-03-13 00:00:00", "ShipVia": 1, "Freight": 11.9300, "ShipName": "Comrcio Mineiro", "ShipAddress": "Av. dos Lusadas, 23", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05432-043", "ShipCountry": "Brazil" }, { "OrderID": 10467, "CustomerID": "MAGAA", "EmployeeID": 8, "OrderDate": "1997-03-06 00:00:00", "RequiredDate": "1997-04-03 00:00:00", "ShippedDate": "1997-03-11 00:00:00", "ShipVia": 2, "Freight": 4.9300, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10468, "CustomerID": "KOENE", "EmployeeID": 3, "OrderDate": "1997-03-07 00:00:00", "RequiredDate": "1997-04-04 00:00:00", "ShippedDate": "1997-03-12 00:00:00", "ShipVia": 3, "Freight": 44.1200, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10469, "CustomerID": "WHITC", "EmployeeID": 1, "OrderDate": "1997-03-10 00:00:00", "RequiredDate": "1997-04-07 00:00:00", "ShippedDate": "1997-03-14 00:00:00", "ShipVia": 1, "Freight": 60.1800, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10470, "CustomerID": "BONAP", "EmployeeID": 4, "OrderDate": "1997-03-11 00:00:00", "RequiredDate": "1997-04-08 00:00:00", "ShippedDate": "1997-03-14 00:00:00", "ShipVia": 2, "Freight": 64.5600, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10471, "CustomerID": "BSBEV", "EmployeeID": 2, "OrderDate": "1997-03-11 00:00:00", "RequiredDate": "1997-04-08 00:00:00", "ShippedDate": "1997-03-18 00:00:00", "ShipVia": 3, "Freight": 45.5900, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 10472, "CustomerID": "SEVES", "EmployeeID": 8, "OrderDate": "1997-03-12 00:00:00", "RequiredDate": "1997-04-09 00:00:00", "ShippedDate": "1997-03-19 00:00:00", "ShipVia": 1, "Freight": 4.2000, "ShipName": "Seven Seas Imports", "ShipAddress": "90 Wadhurst Rd.", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "OX15 4NB", "ShipCountry": "UK" }, { "OrderID": 10473, "CustomerID": "ISLAT", "EmployeeID": 1, "OrderDate": "1997-03-13 00:00:00", "RequiredDate": "1997-03-27 00:00:00", "ShippedDate": "1997-03-21 00:00:00", "ShipVia": 3, "Freight": 16.3700, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10474, "CustomerID": "PERIC", "EmployeeID": 5, "OrderDate": "1997-03-13 00:00:00", "RequiredDate": "1997-04-10 00:00:00", "ShippedDate": "1997-03-21 00:00:00", "ShipVia": 2, "Freight": 83.4900, "ShipName": "Pericles Comidas clsicas", "ShipAddress": "Calle Dr. Jorge Cash 321", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10475, "CustomerID": "SUPRD", "EmployeeID": 9, "OrderDate": "1997-03-14 00:00:00", "RequiredDate": "1997-04-11 00:00:00", "ShippedDate": "1997-04-04 00:00:00", "ShipVia": 1, "Freight": 68.5200, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10476, "CustomerID": "HILAA", "EmployeeID": 8, "OrderDate": "1997-03-17 00:00:00", "RequiredDate": "1997-04-14 00:00:00", "ShippedDate": "1997-03-24 00:00:00", "ShipVia": 3, "Freight": 4.4100, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10477, "CustomerID": "PRINI", "EmployeeID": 5, "OrderDate": "1997-03-17 00:00:00", "RequiredDate": "1997-04-14 00:00:00", "ShippedDate": "1997-03-25 00:00:00", "ShipVia": 2, "Freight": 13.0200, "ShipName": "Princesa Isabel Vinhos", "ShipAddress": "Estrada da sade n. 58", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1756, "ShipCountry": "Portugal" }, { "OrderID": 10478, "CustomerID": "VICTE", "EmployeeID": 2, "OrderDate": "1997-03-18 00:00:00", "RequiredDate": "1997-04-01 00:00:00", "ShippedDate": "1997-03-26 00:00:00", "ShipVia": 3, "Freight": 4.8100, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10479, "CustomerID": "RATTC", "EmployeeID": 3, "OrderDate": "1997-03-19 00:00:00", "RequiredDate": "1997-04-16 00:00:00", "ShippedDate": "1997-03-21 00:00:00", "ShipVia": 3, "Freight": 708.9500, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10480, "CustomerID": "FOLIG", "EmployeeID": 6, "OrderDate": "1997-03-20 00:00:00", "RequiredDate": "1997-04-17 00:00:00", "ShippedDate": "1997-03-24 00:00:00", "ShipVia": 2, "Freight": 1.3500, "ShipName": "Folies gourmandes", "ShipAddress": "184, chausse de Tournai", "ShipCity": "Lille", "ShipRegion": null, "ShipPostalCode": 59000, "ShipCountry": "France" }, { "OrderID": 10481, "CustomerID": "RICAR", "EmployeeID": 8, "OrderDate": "1997-03-20 00:00:00", "RequiredDate": "1997-04-17 00:00:00", "ShippedDate": "1997-03-25 00:00:00", "ShipVia": 2, "Freight": 64.3300, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10482, "CustomerID": "LAZYK", "EmployeeID": 1, "OrderDate": "1997-03-21 00:00:00", "RequiredDate": "1997-04-18 00:00:00", "ShippedDate": "1997-04-10 00:00:00", "ShipVia": 3, "Freight": 7.4800, "ShipName": "Lazy K Kountry Store", "ShipAddress": "12 Orchestra Terrace", "ShipCity": "Walla Walla", "ShipRegion": "WA", "ShipPostalCode": 99362, "ShipCountry": "USA" }, { "OrderID": 10483, "CustomerID": "WHITC", "EmployeeID": 7, "OrderDate": "1997-03-24 00:00:00", "RequiredDate": "1997-04-21 00:00:00", "ShippedDate": "1997-04-25 00:00:00", "ShipVia": 2, "Freight": 15.2800, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10484, "CustomerID": "BSBEV", "EmployeeID": 3, "OrderDate": "1997-03-24 00:00:00", "RequiredDate": "1997-04-21 00:00:00", "ShippedDate": "1997-04-01 00:00:00", "ShipVia": 3, "Freight": 6.8800, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 10485, "CustomerID": "LINOD", "EmployeeID": 4, "OrderDate": "1997-03-25 00:00:00", "RequiredDate": "1997-04-08 00:00:00", "ShippedDate": "1997-03-31 00:00:00", "ShipVia": 2, "Freight": 64.4500, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10486, "CustomerID": "HILAA", "EmployeeID": 1, "OrderDate": "1997-03-26 00:00:00", "RequiredDate": "1997-04-23 00:00:00", "ShippedDate": "1997-04-02 00:00:00", "ShipVia": 2, "Freight": 30.5300, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10487, "CustomerID": "QUEEN", "EmployeeID": 2, "OrderDate": "1997-03-26 00:00:00", "RequiredDate": "1997-04-23 00:00:00", "ShippedDate": "1997-03-28 00:00:00", "ShipVia": 2, "Freight": 71.0700, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10488, "CustomerID": "FRANK", "EmployeeID": 8, "OrderDate": "1997-03-27 00:00:00", "RequiredDate": "1997-04-24 00:00:00", "ShippedDate": "1997-04-02 00:00:00", "ShipVia": 2, "Freight": 4.9300, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10489, "CustomerID": "PICCO", "EmployeeID": 6, "OrderDate": "1997-03-28 00:00:00", "RequiredDate": "1997-04-25 00:00:00", "ShippedDate": "1997-04-09 00:00:00", "ShipVia": 2, "Freight": 5.2900, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 10490, "CustomerID": "HILAA", "EmployeeID": 7, "OrderDate": "1997-03-31 00:00:00", "RequiredDate": "1997-04-28 00:00:00", "ShippedDate": "1997-04-03 00:00:00", "ShipVia": 2, "Freight": 210.1900, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10491, "CustomerID": "FURIB", "EmployeeID": 8, "OrderDate": "1997-03-31 00:00:00", "RequiredDate": "1997-04-28 00:00:00", "ShippedDate": "1997-04-08 00:00:00", "ShipVia": 3, "Freight": 16.9600, "ShipName": "Furia Bacalhau e Frutos do Mar", "ShipAddress": "Jardim das rosas n. 32", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1675, "ShipCountry": "Portugal" }, { "OrderID": 10492, "CustomerID": "BOTTM", "EmployeeID": 3, "OrderDate": "1997-04-01 00:00:00", "RequiredDate": "1997-04-29 00:00:00", "ShippedDate": "1997-04-11 00:00:00", "ShipVia": 1, "Freight": 62.8900, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10493, "CustomerID": "LAMAI", "EmployeeID": 4, "OrderDate": "1997-04-02 00:00:00", "RequiredDate": "1997-04-30 00:00:00", "ShippedDate": "1997-04-10 00:00:00", "ShipVia": 3, "Freight": 10.6400, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10494, "CustomerID": "COMMI", "EmployeeID": 4, "OrderDate": "1997-04-02 00:00:00", "RequiredDate": "1997-04-30 00:00:00", "ShippedDate": "1997-04-09 00:00:00", "ShipVia": 2, "Freight": 65.9900, "ShipName": "Comrcio Mineiro", "ShipAddress": "Av. dos Lusadas, 23", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05432-043", "ShipCountry": "Brazil" }, { "OrderID": 10495, "CustomerID": "LAUGB", "EmployeeID": 3, "OrderDate": "1997-04-03 00:00:00", "RequiredDate": "1997-05-01 00:00:00", "ShippedDate": "1997-04-11 00:00:00", "ShipVia": 3, "Freight": 4.6500, "ShipName": "Laughing Bacchus Wine Cellars", "ShipAddress": "2319 Elm St.", "ShipCity": "Vancouver", "ShipRegion": "BC", "ShipPostalCode": "V3F 2K1", "ShipCountry": "Canada" }, { "OrderID": 10496, "CustomerID": "TRADH", "EmployeeID": 7, "OrderDate": "1997-04-04 00:00:00", "RequiredDate": "1997-05-02 00:00:00", "ShippedDate": "1997-04-07 00:00:00", "ShipVia": 2, "Freight": 46.7700, "ShipName": "Tradiao Hipermercados", "ShipAddress": "Av. Ins de Castro, 414", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05634-030", "ShipCountry": "Brazil" }, { "OrderID": 10497, "CustomerID": "LEHMS", "EmployeeID": 7, "OrderDate": "1997-04-04 00:00:00", "RequiredDate": "1997-05-02 00:00:00", "ShippedDate": "1997-04-07 00:00:00", "ShipVia": 1, "Freight": 36.2100, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10498, "CustomerID": "HILAA", "EmployeeID": 8, "OrderDate": "1997-04-07 00:00:00", "RequiredDate": "1997-05-05 00:00:00", "ShippedDate": "1997-04-11 00:00:00", "ShipVia": 2, "Freight": 29.7500, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10499, "CustomerID": "LILAS", "EmployeeID": 4, "OrderDate": "1997-04-08 00:00:00", "RequiredDate": "1997-05-06 00:00:00", "ShippedDate": "1997-04-16 00:00:00", "ShipVia": 2, "Freight": 102.0200, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10500, "CustomerID": "LAMAI", "EmployeeID": 6, "OrderDate": "1997-04-09 00:00:00", "RequiredDate": "1997-05-07 00:00:00", "ShippedDate": "1997-04-17 00:00:00", "ShipVia": 1, "Freight": 42.6800, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10501, "CustomerID": "BLAUS", "EmployeeID": 9, "OrderDate": "1997-04-09 00:00:00", "RequiredDate": "1997-05-07 00:00:00", "ShippedDate": "1997-04-16 00:00:00", "ShipVia": 3, "Freight": 8.8500, "ShipName": "Blauer See Delikatessen", "ShipAddress": "Forsterstr. 57", "ShipCity": "Mannheim", "ShipRegion": null, "ShipPostalCode": 68306, "ShipCountry": "Germany" }, { "OrderID": 10502, "CustomerID": "PERIC", "EmployeeID": 2, "OrderDate": "1997-04-10 00:00:00", "RequiredDate": "1997-05-08 00:00:00", "ShippedDate": "1997-04-29 00:00:00", "ShipVia": 1, "Freight": 69.3200, "ShipName": "Pericles Comidas clsicas", "ShipAddress": "Calle Dr. Jorge Cash 321", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10503, "CustomerID": "HUNGO", "EmployeeID": 6, "OrderDate": "1997-04-11 00:00:00", "RequiredDate": "1997-05-09 00:00:00", "ShippedDate": "1997-04-16 00:00:00", "ShipVia": 2, "Freight": 16.7400, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10504, "CustomerID": "WHITC", "EmployeeID": 4, "OrderDate": "1997-04-11 00:00:00", "RequiredDate": "1997-05-09 00:00:00", "ShippedDate": "1997-04-18 00:00:00", "ShipVia": 3, "Freight": 59.1300, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10505, "CustomerID": "MEREP", "EmployeeID": 3, "OrderDate": "1997-04-14 00:00:00", "RequiredDate": "1997-05-12 00:00:00", "ShippedDate": "1997-04-21 00:00:00", "ShipVia": 3, "Freight": 7.1300, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10506, "CustomerID": "KOENE", "EmployeeID": 9, "OrderDate": "1997-04-15 00:00:00", "RequiredDate": "1997-05-13 00:00:00", "ShippedDate": "1997-05-02 00:00:00", "ShipVia": 2, "Freight": 21.1900, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10507, "CustomerID": "ANTON", "EmployeeID": 7, "OrderDate": "1997-04-15 00:00:00", "RequiredDate": "1997-05-13 00:00:00", "ShippedDate": "1997-04-22 00:00:00", "ShipVia": 1, "Freight": 47.4500, "ShipName": "Antonio Moreno Taquera", "ShipAddress": "Mataderos 2312", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5023, "ShipCountry": "Mexico" }, { "OrderID": 10508, "CustomerID": "OTTIK", "EmployeeID": 1, "OrderDate": "1997-04-16 00:00:00", "RequiredDate": "1997-05-14 00:00:00", "ShippedDate": "1997-05-13 00:00:00", "ShipVia": 2, "Freight": 4.9900, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 10509, "CustomerID": "BLAUS", "EmployeeID": 4, "OrderDate": "1997-04-17 00:00:00", "RequiredDate": "1997-05-15 00:00:00", "ShippedDate": "1997-04-29 00:00:00", "ShipVia": 1, "Freight": 0.1500, "ShipName": "Blauer See Delikatessen", "ShipAddress": "Forsterstr. 57", "ShipCity": "Mannheim", "ShipRegion": null, "ShipPostalCode": 68306, "ShipCountry": "Germany" }, { "OrderID": 10510, "CustomerID": "SAVEA", "EmployeeID": 6, "OrderDate": "1997-04-18 00:00:00", "RequiredDate": "1997-05-16 00:00:00", "ShippedDate": "1997-04-28 00:00:00", "ShipVia": 3, "Freight": 367.6300, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10511, "CustomerID": "BONAP", "EmployeeID": 4, "OrderDate": "1997-04-18 00:00:00", "RequiredDate": "1997-05-16 00:00:00", "ShippedDate": "1997-04-21 00:00:00", "ShipVia": 3, "Freight": 350.6400, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10512, "CustomerID": "FAMIA", "EmployeeID": 7, "OrderDate": "1997-04-21 00:00:00", "RequiredDate": "1997-05-19 00:00:00", "ShippedDate": "1997-04-24 00:00:00", "ShipVia": 2, "Freight": 3.5300, "ShipName": "Familia Arquibaldo", "ShipAddress": "Rua Ors, 92", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05442-030", "ShipCountry": "Brazil" }, { "OrderID": 10513, "CustomerID": "WANDK", "EmployeeID": 7, "OrderDate": "1997-04-22 00:00:00", "RequiredDate": "1997-06-03 00:00:00", "ShippedDate": "1997-04-28 00:00:00", "ShipVia": 1, "Freight": 105.6500, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 10514, "CustomerID": "ERNSH", "EmployeeID": 3, "OrderDate": "1997-04-22 00:00:00", "RequiredDate": "1997-05-20 00:00:00", "ShippedDate": "1997-05-16 00:00:00", "ShipVia": 2, "Freight": 789.9500, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10515, "CustomerID": "QUICK", "EmployeeID": 2, "OrderDate": "1997-04-23 00:00:00", "RequiredDate": "1997-05-07 00:00:00", "ShippedDate": "1997-05-23 00:00:00", "ShipVia": 1, "Freight": 204.4700, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10516, "CustomerID": "HUNGO", "EmployeeID": 2, "OrderDate": "1997-04-24 00:00:00", "RequiredDate": "1997-05-22 00:00:00", "ShippedDate": "1997-05-01 00:00:00", "ShipVia": 3, "Freight": 62.7800, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10517, "CustomerID": "NORTS", "EmployeeID": 3, "OrderDate": "1997-04-24 00:00:00", "RequiredDate": "1997-05-22 00:00:00", "ShippedDate": "1997-04-29 00:00:00", "ShipVia": 3, "Freight": 32.0700, "ShipName": "North/South", "ShipAddress": "South House 300 Queensbridge", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "SW7 1RZ", "ShipCountry": "UK" }, { "OrderID": 10518, "CustomerID": "TORTU", "EmployeeID": 4, "OrderDate": "1997-04-25 00:00:00", "RequiredDate": "1997-05-09 00:00:00", "ShippedDate": "1997-05-05 00:00:00", "ShipVia": 2, "Freight": 218.1500, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10519, "CustomerID": "CHOPS", "EmployeeID": 6, "OrderDate": "1997-04-28 00:00:00", "RequiredDate": "1997-05-26 00:00:00", "ShippedDate": "1997-05-01 00:00:00", "ShipVia": 3, "Freight": 91.7600, "ShipName": "Chop-suey Chinese", "ShipAddress": "Hauptstr. 31", "ShipCity": "Bern", "ShipRegion": null, "ShipPostalCode": 3012, "ShipCountry": "Switzerland" }, { "OrderID": 10520, "CustomerID": "SANTG", "EmployeeID": 7, "OrderDate": "1997-04-29 00:00:00", "RequiredDate": "1997-05-27 00:00:00", "ShippedDate": "1997-05-01 00:00:00", "ShipVia": 1, "Freight": 13.3700, "ShipName": "Sant Gourmet", "ShipAddress": "Erling Skakkes gate 78", "ShipCity": "Stavern", "ShipRegion": null, "ShipPostalCode": 4110, "ShipCountry": "Norway" }, { "OrderID": 10521, "CustomerID": "CACTU", "EmployeeID": 8, "OrderDate": "1997-04-29 00:00:00", "RequiredDate": "1997-05-27 00:00:00", "ShippedDate": "1997-05-02 00:00:00", "ShipVia": 2, "Freight": 17.2200, "ShipName": "Cactus Comidas para llevar", "ShipAddress": "Cerrito 333", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10522, "CustomerID": "LEHMS", "EmployeeID": 4, "OrderDate": "1997-04-30 00:00:00", "RequiredDate": "1997-05-28 00:00:00", "ShippedDate": "1997-05-06 00:00:00", "ShipVia": 1, "Freight": 45.3300, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10523, "CustomerID": "SEVES", "EmployeeID": 7, "OrderDate": "1997-05-01 00:00:00", "RequiredDate": "1997-05-29 00:00:00", "ShippedDate": "1997-05-30 00:00:00", "ShipVia": 2, "Freight": 77.6300, "ShipName": "Seven Seas Imports", "ShipAddress": "90 Wadhurst Rd.", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "OX15 4NB", "ShipCountry": "UK" }, { "OrderID": 10524, "CustomerID": "BERGS", "EmployeeID": 1, "OrderDate": "1997-05-01 00:00:00", "RequiredDate": "1997-05-29 00:00:00", "ShippedDate": "1997-05-07 00:00:00", "ShipVia": 2, "Freight": 244.7900, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10525, "CustomerID": "BONAP", "EmployeeID": 1, "OrderDate": "1997-05-02 00:00:00", "RequiredDate": "1997-05-30 00:00:00", "ShippedDate": "1997-05-23 00:00:00", "ShipVia": 2, "Freight": 11.0600, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10526, "CustomerID": "WARTH", "EmployeeID": 4, "OrderDate": "1997-05-05 00:00:00", "RequiredDate": "1997-06-02 00:00:00", "ShippedDate": "1997-05-15 00:00:00", "ShipVia": 2, "Freight": 58.5900, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10527, "CustomerID": "QUICK", "EmployeeID": 7, "OrderDate": "1997-05-05 00:00:00", "RequiredDate": "1997-06-02 00:00:00", "ShippedDate": "1997-05-07 00:00:00", "ShipVia": 1, "Freight": 41.9000, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10528, "CustomerID": "GREAL", "EmployeeID": 6, "OrderDate": "1997-05-06 00:00:00", "RequiredDate": "1997-05-20 00:00:00", "ShippedDate": "1997-05-09 00:00:00", "ShipVia": 2, "Freight": 3.3500, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 10529, "CustomerID": "MAISD", "EmployeeID": 5, "OrderDate": "1997-05-07 00:00:00", "RequiredDate": "1997-06-04 00:00:00", "ShippedDate": "1997-05-09 00:00:00", "ShipVia": 2, "Freight": 66.6900, "ShipName": "Maison Dewey", "ShipAddress": "Rue Joseph-Bens 532", "ShipCity": "Bruxelles", "ShipRegion": null, "ShipPostalCode": "B-1180", "ShipCountry": "Belgium" }, { "OrderID": 10530, "CustomerID": "PICCO", "EmployeeID": 3, "OrderDate": "1997-05-08 00:00:00", "RequiredDate": "1997-06-05 00:00:00", "ShippedDate": "1997-05-12 00:00:00", "ShipVia": 2, "Freight": 339.2200, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 10531, "CustomerID": "OCEAN", "EmployeeID": 7, "OrderDate": "1997-05-08 00:00:00", "RequiredDate": "1997-06-05 00:00:00", "ShippedDate": "1997-05-19 00:00:00", "ShipVia": 1, "Freight": 8.1200, "ShipName": "Ocano Atlntico Ltda.", "ShipAddress": "Ing. Gustavo Moncada 8585 Piso 20-A", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10532, "CustomerID": "EASTC", "EmployeeID": 7, "OrderDate": "1997-05-09 00:00:00", "RequiredDate": "1997-06-06 00:00:00", "ShippedDate": "1997-05-12 00:00:00", "ShipVia": 3, "Freight": 74.4600, "ShipName": "Eastern Connection", "ShipAddress": "35 King George", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX3 6FW", "ShipCountry": "UK" }, { "OrderID": 10533, "CustomerID": "FOLKO", "EmployeeID": 8, "OrderDate": "1997-05-12 00:00:00", "RequiredDate": "1997-06-09 00:00:00", "ShippedDate": "1997-05-22 00:00:00", "ShipVia": 1, "Freight": 188.0400, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10534, "CustomerID": "LEHMS", "EmployeeID": 8, "OrderDate": "1997-05-12 00:00:00", "RequiredDate": "1997-06-09 00:00:00", "ShippedDate": "1997-05-14 00:00:00", "ShipVia": 2, "Freight": 27.9400, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10535, "CustomerID": "ANTON", "EmployeeID": 4, "OrderDate": "1997-05-13 00:00:00", "RequiredDate": "1997-06-10 00:00:00", "ShippedDate": "1997-05-21 00:00:00", "ShipVia": 1, "Freight": 15.6400, "ShipName": "Antonio Moreno Taquera", "ShipAddress": "Mataderos 2312", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5023, "ShipCountry": "Mexico" }, { "OrderID": 10536, "CustomerID": "LEHMS", "EmployeeID": 3, "OrderDate": "1997-05-14 00:00:00", "RequiredDate": "1997-06-11 00:00:00", "ShippedDate": "1997-06-06 00:00:00", "ShipVia": 2, "Freight": 58.8800, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10537, "CustomerID": "RICSU", "EmployeeID": 1, "OrderDate": "1997-05-14 00:00:00", "RequiredDate": "1997-05-28 00:00:00", "ShippedDate": "1997-05-19 00:00:00", "ShipVia": 1, "Freight": 78.8500, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 10538, "CustomerID": "BSBEV", "EmployeeID": 9, "OrderDate": "1997-05-15 00:00:00", "RequiredDate": "1997-06-12 00:00:00", "ShippedDate": "1997-05-16 00:00:00", "ShipVia": 3, "Freight": 4.8700, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 10539, "CustomerID": "BSBEV", "EmployeeID": 6, "OrderDate": "1997-05-16 00:00:00", "RequiredDate": "1997-06-13 00:00:00", "ShippedDate": "1997-05-23 00:00:00", "ShipVia": 3, "Freight": 12.3600, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 10540, "CustomerID": "QUICK", "EmployeeID": 3, "OrderDate": "1997-05-19 00:00:00", "RequiredDate": "1997-06-16 00:00:00", "ShippedDate": "1997-06-13 00:00:00", "ShipVia": 3, "Freight": 1007.6400, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10541, "CustomerID": "HANAR", "EmployeeID": 2, "OrderDate": "1997-05-19 00:00:00", "RequiredDate": "1997-06-16 00:00:00", "ShippedDate": "1997-05-29 00:00:00", "ShipVia": 1, "Freight": 68.6500, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10542, "CustomerID": "KOENE", "EmployeeID": 1, "OrderDate": "1997-05-20 00:00:00", "RequiredDate": "1997-06-17 00:00:00", "ShippedDate": "1997-05-26 00:00:00", "ShipVia": 3, "Freight": 10.9500, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10543, "CustomerID": "LILAS", "EmployeeID": 8, "OrderDate": "1997-05-21 00:00:00", "RequiredDate": "1997-06-18 00:00:00", "ShippedDate": "1997-05-23 00:00:00", "ShipVia": 2, "Freight": 48.1700, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10544, "CustomerID": "LONEP", "EmployeeID": 4, "OrderDate": "1997-05-21 00:00:00", "RequiredDate": "1997-06-18 00:00:00", "ShippedDate": "1997-05-30 00:00:00", "ShipVia": 1, "Freight": 24.9100, "ShipName": "Lonesome Pine Restaurant", "ShipAddress": "89 Chiaroscuro Rd.", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97219, "ShipCountry": "USA" }, { "OrderID": 10545, "CustomerID": "LAZYK", "EmployeeID": 8, "OrderDate": "1997-05-22 00:00:00", "RequiredDate": "1997-06-19 00:00:00", "ShippedDate": "1997-06-26 00:00:00", "ShipVia": 2, "Freight": 11.9200, "ShipName": "Lazy K Kountry Store", "ShipAddress": "12 Orchestra Terrace", "ShipCity": "Walla Walla", "ShipRegion": "WA", "ShipPostalCode": 99362, "ShipCountry": "USA" }, { "OrderID": 10546, "CustomerID": "VICTE", "EmployeeID": 1, "OrderDate": "1997-05-23 00:00:00", "RequiredDate": "1997-06-20 00:00:00", "ShippedDate": "1997-05-27 00:00:00", "ShipVia": 3, "Freight": 194.7200, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10547, "CustomerID": "SEVES", "EmployeeID": 3, "OrderDate": "1997-05-23 00:00:00", "RequiredDate": "1997-06-20 00:00:00", "ShippedDate": "1997-06-02 00:00:00", "ShipVia": 2, "Freight": 178.4300, "ShipName": "Seven Seas Imports", "ShipAddress": "90 Wadhurst Rd.", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "OX15 4NB", "ShipCountry": "UK" }, { "OrderID": 10548, "CustomerID": "TOMSP", "EmployeeID": 3, "OrderDate": "1997-05-26 00:00:00", "RequiredDate": "1997-06-23 00:00:00", "ShippedDate": "1997-06-02 00:00:00", "ShipVia": 2, "Freight": 1.4300, "ShipName": "Toms Spezialitten", "ShipAddress": "Luisenstr. 48", "ShipCity": "Mnster", "ShipRegion": null, "ShipPostalCode": 44087, "ShipCountry": "Germany" }, { "OrderID": 10549, "CustomerID": "QUICK", "EmployeeID": 5, "OrderDate": "1997-05-27 00:00:00", "RequiredDate": "1997-06-10 00:00:00", "ShippedDate": "1997-05-30 00:00:00", "ShipVia": 1, "Freight": 171.2400, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10550, "CustomerID": "GODOS", "EmployeeID": 7, "OrderDate": "1997-05-28 00:00:00", "RequiredDate": "1997-06-25 00:00:00", "ShippedDate": "1997-06-06 00:00:00", "ShipVia": 3, "Freight": 4.3200, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 10551, "CustomerID": "FURIB", "EmployeeID": 4, "OrderDate": "1997-05-28 00:00:00", "RequiredDate": "1997-07-09 00:00:00", "ShippedDate": "1997-06-06 00:00:00", "ShipVia": 3, "Freight": 72.9500, "ShipName": "Furia Bacalhau e Frutos do Mar", "ShipAddress": "Jardim das rosas n. 32", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1675, "ShipCountry": "Portugal" }, { "OrderID": 10552, "CustomerID": "HILAA", "EmployeeID": 2, "OrderDate": "1997-05-29 00:00:00", "RequiredDate": "1997-06-26 00:00:00", "ShippedDate": "1997-06-05 00:00:00", "ShipVia": 1, "Freight": 83.2200, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10553, "CustomerID": "WARTH", "EmployeeID": 2, "OrderDate": "1997-05-30 00:00:00", "RequiredDate": "1997-06-27 00:00:00", "ShippedDate": "1997-06-03 00:00:00", "ShipVia": 2, "Freight": 149.4900, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10554, "CustomerID": "OTTIK", "EmployeeID": 4, "OrderDate": "1997-05-30 00:00:00", "RequiredDate": "1997-06-27 00:00:00", "ShippedDate": "1997-06-05 00:00:00", "ShipVia": 3, "Freight": 120.9700, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 10555, "CustomerID": "SAVEA", "EmployeeID": 6, "OrderDate": "1997-06-02 00:00:00", "RequiredDate": "1997-06-30 00:00:00", "ShippedDate": "1997-06-04 00:00:00", "ShipVia": 3, "Freight": 252.4900, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10556, "CustomerID": "SIMOB", "EmployeeID": 2, "OrderDate": "1997-06-03 00:00:00", "RequiredDate": "1997-07-15 00:00:00", "ShippedDate": "1997-06-13 00:00:00", "ShipVia": 1, "Freight": 9.8000, "ShipName": "Simons bistro", "ShipAddress": "Vinbltet 34", "ShipCity": "Kobenhavn", "ShipRegion": null, "ShipPostalCode": 1734, "ShipCountry": "Denmark" }, { "OrderID": 10557, "CustomerID": "LEHMS", "EmployeeID": 9, "OrderDate": "1997-06-03 00:00:00", "RequiredDate": "1997-06-17 00:00:00", "ShippedDate": "1997-06-06 00:00:00", "ShipVia": 2, "Freight": 96.7200, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10558, "CustomerID": "AROUT", "EmployeeID": 1, "OrderDate": "1997-06-04 00:00:00", "RequiredDate": "1997-07-02 00:00:00", "ShippedDate": "1997-06-10 00:00:00", "ShipVia": 2, "Freight": 72.9700, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10559, "CustomerID": "BLONP", "EmployeeID": 6, "OrderDate": "1997-06-05 00:00:00", "RequiredDate": "1997-07-03 00:00:00", "ShippedDate": "1997-06-13 00:00:00", "ShipVia": 1, "Freight": 8.0500, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10560, "CustomerID": "FRANK", "EmployeeID": 8, "OrderDate": "1997-06-06 00:00:00", "RequiredDate": "1997-07-04 00:00:00", "ShippedDate": "1997-06-09 00:00:00", "ShipVia": 1, "Freight": 36.6500, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10561, "CustomerID": "FOLKO", "EmployeeID": 2, "OrderDate": "1997-06-06 00:00:00", "RequiredDate": "1997-07-04 00:00:00", "ShippedDate": "1997-06-09 00:00:00", "ShipVia": 2, "Freight": 242.2100, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10562, "CustomerID": "REGGC", "EmployeeID": 1, "OrderDate": "1997-06-09 00:00:00", "RequiredDate": "1997-07-07 00:00:00", "ShippedDate": "1997-06-12 00:00:00", "ShipVia": 1, "Freight": 22.9500, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10563, "CustomerID": "RICAR", "EmployeeID": 2, "OrderDate": "1997-06-10 00:00:00", "RequiredDate": "1997-07-22 00:00:00", "ShippedDate": "1997-06-24 00:00:00", "ShipVia": 2, "Freight": 60.4300, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10564, "CustomerID": "RATTC", "EmployeeID": 4, "OrderDate": "1997-06-10 00:00:00", "RequiredDate": "1997-07-08 00:00:00", "ShippedDate": "1997-06-16 00:00:00", "ShipVia": 3, "Freight": 13.7500, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10565, "CustomerID": "MEREP", "EmployeeID": 8, "OrderDate": "1997-06-11 00:00:00", "RequiredDate": "1997-07-09 00:00:00", "ShippedDate": "1997-06-18 00:00:00", "ShipVia": 2, "Freight": 7.1500, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10566, "CustomerID": "BLONP", "EmployeeID": 9, "OrderDate": "1997-06-12 00:00:00", "RequiredDate": "1997-07-10 00:00:00", "ShippedDate": "1997-06-18 00:00:00", "ShipVia": 1, "Freight": 88.4000, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10567, "CustomerID": "HUNGO", "EmployeeID": 1, "OrderDate": "1997-06-12 00:00:00", "RequiredDate": "1997-07-10 00:00:00", "ShippedDate": "1997-06-17 00:00:00", "ShipVia": 1, "Freight": 33.9700, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10568, "CustomerID": "GALED", "EmployeeID": 3, "OrderDate": "1997-06-13 00:00:00", "RequiredDate": "1997-07-11 00:00:00", "ShippedDate": "1997-07-09 00:00:00", "ShipVia": 3, "Freight": 6.5400, "ShipName": "Galera del gastronmo", "ShipAddress": "Rambla de Catalua, 23", "ShipCity": "Barcelona", "ShipRegion": null, "ShipPostalCode": 8022, "ShipCountry": "Spain" }, { "OrderID": 10569, "CustomerID": "RATTC", "EmployeeID": 5, "OrderDate": "1997-06-16 00:00:00", "RequiredDate": "1997-07-14 00:00:00", "ShippedDate": "1997-07-11 00:00:00", "ShipVia": 1, "Freight": 58.9800, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10570, "CustomerID": "MEREP", "EmployeeID": 3, "OrderDate": "1997-06-17 00:00:00", "RequiredDate": "1997-07-15 00:00:00", "ShippedDate": "1997-06-19 00:00:00", "ShipVia": 3, "Freight": 188.9900, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10571, "CustomerID": "ERNSH", "EmployeeID": 8, "OrderDate": "1997-06-17 00:00:00", "RequiredDate": "1997-07-29 00:00:00", "ShippedDate": "1997-07-04 00:00:00", "ShipVia": 3, "Freight": 26.0600, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10572, "CustomerID": "BERGS", "EmployeeID": 3, "OrderDate": "1997-06-18 00:00:00", "RequiredDate": "1997-07-16 00:00:00", "ShippedDate": "1997-06-25 00:00:00", "ShipVia": 2, "Freight": 116.4300, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10573, "CustomerID": "ANTON", "EmployeeID": 7, "OrderDate": "1997-06-19 00:00:00", "RequiredDate": "1997-07-17 00:00:00", "ShippedDate": "1997-06-20 00:00:00", "ShipVia": 3, "Freight": 84.8400, "ShipName": "Antonio Moreno Taquera", "ShipAddress": "Mataderos 2312", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5023, "ShipCountry": "Mexico" }, { "OrderID": 10574, "CustomerID": "TRAIH", "EmployeeID": 4, "OrderDate": "1997-06-19 00:00:00", "RequiredDate": "1997-07-17 00:00:00", "ShippedDate": "1997-06-30 00:00:00", "ShipVia": 2, "Freight": 37.6000, "ShipName": "Trail-s Head Gourmet Provisioners", "ShipAddress": "722 DaVinci Blvd.", "ShipCity": "Kirkland", "ShipRegion": "WA", "ShipPostalCode": 98034, "ShipCountry": "USA" }, { "OrderID": 10575, "CustomerID": "MORGK", "EmployeeID": 5, "OrderDate": "1997-06-20 00:00:00", "RequiredDate": "1997-07-04 00:00:00", "ShippedDate": "1997-06-30 00:00:00", "ShipVia": 1, "Freight": 127.3400, "ShipName": "Morgenstern Gesundkost", "ShipAddress": "Heerstr. 22", "ShipCity": "Leipzig", "ShipRegion": null, "ShipPostalCode": 4179, "ShipCountry": "Germany" }, { "OrderID": 10576, "CustomerID": "TORTU", "EmployeeID": 3, "OrderDate": "1997-06-23 00:00:00", "RequiredDate": "1997-07-07 00:00:00", "ShippedDate": "1997-06-30 00:00:00", "ShipVia": 3, "Freight": 18.5600, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10577, "CustomerID": "TRAIH", "EmployeeID": 9, "OrderDate": "1997-06-23 00:00:00", "RequiredDate": "1997-08-04 00:00:00", "ShippedDate": "1997-06-30 00:00:00", "ShipVia": 2, "Freight": 25.4100, "ShipName": "Trail-s Head Gourmet Provisioners", "ShipAddress": "722 DaVinci Blvd.", "ShipCity": "Kirkland", "ShipRegion": "WA", "ShipPostalCode": 98034, "ShipCountry": "USA" }, { "OrderID": 10578, "CustomerID": "BSBEV", "EmployeeID": 4, "OrderDate": "1997-06-24 00:00:00", "RequiredDate": "1997-07-22 00:00:00", "ShippedDate": "1997-07-25 00:00:00", "ShipVia": 3, "Freight": 29.6000, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 10579, "CustomerID": "LETSS", "EmployeeID": 1, "OrderDate": "1997-06-25 00:00:00", "RequiredDate": "1997-07-23 00:00:00", "ShippedDate": "1997-07-04 00:00:00", "ShipVia": 2, "Freight": 13.7300, "ShipName": "Let-s Stop N Shop", "ShipAddress": "87 Polk St. Suite 5", "ShipCity": "San Francisco", "ShipRegion": "CA", "ShipPostalCode": 94117, "ShipCountry": "USA" }, { "OrderID": 10580, "CustomerID": "OTTIK", "EmployeeID": 4, "OrderDate": "1997-06-26 00:00:00", "RequiredDate": "1997-07-24 00:00:00", "ShippedDate": "1997-07-01 00:00:00", "ShipVia": 3, "Freight": 75.8900, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 10581, "CustomerID": "FAMIA", "EmployeeID": 3, "OrderDate": "1997-06-26 00:00:00", "RequiredDate": "1997-07-24 00:00:00", "ShippedDate": "1997-07-02 00:00:00", "ShipVia": 1, "Freight": 3.0100, "ShipName": "Familia Arquibaldo", "ShipAddress": "Rua Ors, 92", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05442-030", "ShipCountry": "Brazil" }, { "OrderID": 10582, "CustomerID": "BLAUS", "EmployeeID": 3, "OrderDate": "1997-06-27 00:00:00", "RequiredDate": "1997-07-25 00:00:00", "ShippedDate": "1997-07-14 00:00:00", "ShipVia": 2, "Freight": 27.7100, "ShipName": "Blauer See Delikatessen", "ShipAddress": "Forsterstr. 57", "ShipCity": "Mannheim", "ShipRegion": null, "ShipPostalCode": 68306, "ShipCountry": "Germany" }, { "OrderID": 10583, "CustomerID": "WARTH", "EmployeeID": 2, "OrderDate": "1997-06-30 00:00:00", "RequiredDate": "1997-07-28 00:00:00", "ShippedDate": "1997-07-04 00:00:00", "ShipVia": 2, "Freight": 7.2800, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10584, "CustomerID": "BLONP", "EmployeeID": 4, "OrderDate": "1997-06-30 00:00:00", "RequiredDate": "1997-07-28 00:00:00", "ShippedDate": "1997-07-04 00:00:00", "ShipVia": 1, "Freight": 59.1400, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10585, "CustomerID": "WELLI", "EmployeeID": 7, "OrderDate": "1997-07-01 00:00:00", "RequiredDate": "1997-07-29 00:00:00", "ShippedDate": "1997-07-10 00:00:00", "ShipVia": 1, "Freight": 13.4100, "ShipName": "Wellington Importadora", "ShipAddress": "Rua do Mercado, 12", "ShipCity": "Resende", "ShipRegion": "SP", "ShipPostalCode": "08737-363", "ShipCountry": "Brazil" }, { "OrderID": 10586, "CustomerID": "REGGC", "EmployeeID": 9, "OrderDate": "1997-07-02 00:00:00", "RequiredDate": "1997-07-30 00:00:00", "ShippedDate": "1997-07-09 00:00:00", "ShipVia": 1, "Freight": 0.4800, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10587, "CustomerID": "QUEDE", "EmployeeID": 1, "OrderDate": "1997-07-02 00:00:00", "RequiredDate": "1997-07-30 00:00:00", "ShippedDate": "1997-07-09 00:00:00", "ShipVia": 1, "Freight": 62.5200, "ShipName": "Que Delcia", "ShipAddress": "Rua da Panificadora, 12", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-673", "ShipCountry": "Brazil" }, { "OrderID": 10588, "CustomerID": "QUICK", "EmployeeID": 2, "OrderDate": "1997-07-03 00:00:00", "RequiredDate": "1997-07-31 00:00:00", "ShippedDate": "1997-07-10 00:00:00", "ShipVia": 3, "Freight": 194.6700, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10589, "CustomerID": "GREAL", "EmployeeID": 8, "OrderDate": "1997-07-04 00:00:00", "RequiredDate": "1997-08-01 00:00:00", "ShippedDate": "1997-07-14 00:00:00", "ShipVia": 2, "Freight": 4.4200, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 10590, "CustomerID": "MEREP", "EmployeeID": 4, "OrderDate": "1997-07-07 00:00:00", "RequiredDate": "1997-08-04 00:00:00", "ShippedDate": "1997-07-14 00:00:00", "ShipVia": 3, "Freight": 44.7700, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10591, "CustomerID": "VAFFE", "EmployeeID": 1, "OrderDate": "1997-07-07 00:00:00", "RequiredDate": "1997-07-21 00:00:00", "ShippedDate": "1997-07-16 00:00:00", "ShipVia": 1, "Freight": 55.9200, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10592, "CustomerID": "LEHMS", "EmployeeID": 3, "OrderDate": "1997-07-08 00:00:00", "RequiredDate": "1997-08-05 00:00:00", "ShippedDate": "1997-07-16 00:00:00", "ShipVia": 1, "Freight": 32.1000, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10593, "CustomerID": "LEHMS", "EmployeeID": 7, "OrderDate": "1997-07-09 00:00:00", "RequiredDate": "1997-08-06 00:00:00", "ShippedDate": "1997-08-13 00:00:00", "ShipVia": 2, "Freight": 174.2000, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10594, "CustomerID": "OLDWO", "EmployeeID": 3, "OrderDate": "1997-07-09 00:00:00", "RequiredDate": "1997-08-06 00:00:00", "ShippedDate": "1997-07-16 00:00:00", "ShipVia": 2, "Freight": 5.2400, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 10595, "CustomerID": "ERNSH", "EmployeeID": 2, "OrderDate": "1997-07-10 00:00:00", "RequiredDate": "1997-08-07 00:00:00", "ShippedDate": "1997-07-14 00:00:00", "ShipVia": 1, "Freight": 96.7800, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10596, "CustomerID": "WHITC", "EmployeeID": 8, "OrderDate": "1997-07-11 00:00:00", "RequiredDate": "1997-08-08 00:00:00", "ShippedDate": "1997-08-12 00:00:00", "ShipVia": 1, "Freight": 16.3400, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10597, "CustomerID": "PICCO", "EmployeeID": 7, "OrderDate": "1997-07-11 00:00:00", "RequiredDate": "1997-08-08 00:00:00", "ShippedDate": "1997-07-18 00:00:00", "ShipVia": 3, "Freight": 35.1200, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 10598, "CustomerID": "RATTC", "EmployeeID": 1, "OrderDate": "1997-07-14 00:00:00", "RequiredDate": "1997-08-11 00:00:00", "ShippedDate": "1997-07-18 00:00:00", "ShipVia": 3, "Freight": 44.4200, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10599, "CustomerID": "BSBEV", "EmployeeID": 6, "OrderDate": "1997-07-15 00:00:00", "RequiredDate": "1997-08-26 00:00:00", "ShippedDate": "1997-07-21 00:00:00", "ShipVia": 3, "Freight": 29.9800, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 10600, "CustomerID": "HUNGC", "EmployeeID": 4, "OrderDate": "1997-07-16 00:00:00", "RequiredDate": "1997-08-13 00:00:00", "ShippedDate": "1997-07-21 00:00:00", "ShipVia": 1, "Freight": 45.1300, "ShipName": "Hungry Coyote Import Store", "ShipAddress": "City Center Plaza 516 Main St.", "ShipCity": "Elgin", "ShipRegion": "OR", "ShipPostalCode": 97827, "ShipCountry": "USA" }, { "OrderID": 10601, "CustomerID": "HILAA", "EmployeeID": 7, "OrderDate": "1997-07-16 00:00:00", "RequiredDate": "1997-08-27 00:00:00", "ShippedDate": "1997-07-22 00:00:00", "ShipVia": 1, "Freight": 58.3000, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10602, "CustomerID": "VAFFE", "EmployeeID": 8, "OrderDate": "1997-07-17 00:00:00", "RequiredDate": "1997-08-14 00:00:00", "ShippedDate": "1997-07-22 00:00:00", "ShipVia": 2, "Freight": 2.9200, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10603, "CustomerID": "SAVEA", "EmployeeID": 8, "OrderDate": "1997-07-18 00:00:00", "RequiredDate": "1997-08-15 00:00:00", "ShippedDate": "1997-08-08 00:00:00", "ShipVia": 2, "Freight": 48.7700, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10604, "CustomerID": "FURIB", "EmployeeID": 1, "OrderDate": "1997-07-18 00:00:00", "RequiredDate": "1997-08-15 00:00:00", "ShippedDate": "1997-07-29 00:00:00", "ShipVia": 1, "Freight": 7.4600, "ShipName": "Furia Bacalhau e Frutos do Mar", "ShipAddress": "Jardim das rosas n. 32", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1675, "ShipCountry": "Portugal" }, { "OrderID": 10605, "CustomerID": "MEREP", "EmployeeID": 1, "OrderDate": "1997-07-21 00:00:00", "RequiredDate": "1997-08-18 00:00:00", "ShippedDate": "1997-07-29 00:00:00", "ShipVia": 2, "Freight": 379.1300, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10606, "CustomerID": "TRADH", "EmployeeID": 4, "OrderDate": "1997-07-22 00:00:00", "RequiredDate": "1997-08-19 00:00:00", "ShippedDate": "1997-07-31 00:00:00", "ShipVia": 3, "Freight": 79.4000, "ShipName": "Tradiao Hipermercados", "ShipAddress": "Av. Ins de Castro, 414", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05634-030", "ShipCountry": "Brazil" }, { "OrderID": 10607, "CustomerID": "SAVEA", "EmployeeID": 5, "OrderDate": "1997-07-22 00:00:00", "RequiredDate": "1997-08-19 00:00:00", "ShippedDate": "1997-07-25 00:00:00", "ShipVia": 1, "Freight": 200.2400, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10608, "CustomerID": "TOMSP", "EmployeeID": 4, "OrderDate": "1997-07-23 00:00:00", "RequiredDate": "1997-08-20 00:00:00", "ShippedDate": "1997-08-01 00:00:00", "ShipVia": 2, "Freight": 27.7900, "ShipName": "Toms Spezialitten", "ShipAddress": "Luisenstr. 48", "ShipCity": "Mnster", "ShipRegion": null, "ShipPostalCode": 44087, "ShipCountry": "Germany" }, { "OrderID": 10609, "CustomerID": "DUMON", "EmployeeID": 7, "OrderDate": "1997-07-24 00:00:00", "RequiredDate": "1997-08-21 00:00:00", "ShippedDate": "1997-07-30 00:00:00", "ShipVia": 2, "Freight": 1.8500, "ShipName": "Du monde entier", "ShipAddress": "67, rue des Cinquante Otages", "ShipCity": "Nantes", "ShipRegion": null, "ShipPostalCode": 44000, "ShipCountry": "France" }, { "OrderID": 10610, "CustomerID": "LAMAI", "EmployeeID": 8, "OrderDate": "1997-07-25 00:00:00", "RequiredDate": "1997-08-22 00:00:00", "ShippedDate": "1997-08-06 00:00:00", "ShipVia": 1, "Freight": 26.7800, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10611, "CustomerID": "WOLZA", "EmployeeID": 6, "OrderDate": "1997-07-25 00:00:00", "RequiredDate": "1997-08-22 00:00:00", "ShippedDate": "1997-08-01 00:00:00", "ShipVia": 2, "Freight": 80.6500, "ShipName": "Wolski Zajazd", "ShipAddress": "ul. Filtrowa 68", "ShipCity": "Warszawa", "ShipRegion": null, "ShipPostalCode": "01-012", "ShipCountry": "Poland" }, { "OrderID": 10612, "CustomerID": "SAVEA", "EmployeeID": 1, "OrderDate": "1997-07-28 00:00:00", "RequiredDate": "1997-08-25 00:00:00", "ShippedDate": "1997-08-01 00:00:00", "ShipVia": 2, "Freight": 544.0800, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10613, "CustomerID": "HILAA", "EmployeeID": 4, "OrderDate": "1997-07-29 00:00:00", "RequiredDate": "1997-08-26 00:00:00", "ShippedDate": "1997-08-01 00:00:00", "ShipVia": 2, "Freight": 8.1100, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10614, "CustomerID": "BLAUS", "EmployeeID": 8, "OrderDate": "1997-07-29 00:00:00", "RequiredDate": "1997-08-26 00:00:00", "ShippedDate": "1997-08-01 00:00:00", "ShipVia": 3, "Freight": 1.9300, "ShipName": "Blauer See Delikatessen", "ShipAddress": "Forsterstr. 57", "ShipCity": "Mannheim", "ShipRegion": null, "ShipPostalCode": 68306, "ShipCountry": "Germany" }, { "OrderID": 10615, "CustomerID": "WILMK", "EmployeeID": 2, "OrderDate": "1997-07-30 00:00:00", "RequiredDate": "1997-08-27 00:00:00", "ShippedDate": "1997-08-06 00:00:00", "ShipVia": 3, "Freight": 0.7500, "ShipName": "Wilman Kala", "ShipAddress": "Keskuskatu 45", "ShipCity": "Helsinki", "ShipRegion": null, "ShipPostalCode": 21240, "ShipCountry": "Finland" }, { "OrderID": 10616, "CustomerID": "GREAL", "EmployeeID": 1, "OrderDate": "1997-07-31 00:00:00", "RequiredDate": "1997-08-28 00:00:00", "ShippedDate": "1997-08-05 00:00:00", "ShipVia": 2, "Freight": 116.5300, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 10617, "CustomerID": "GREAL", "EmployeeID": 4, "OrderDate": "1997-07-31 00:00:00", "RequiredDate": "1997-08-28 00:00:00", "ShippedDate": "1997-08-04 00:00:00", "ShipVia": 2, "Freight": 18.5300, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 10618, "CustomerID": "MEREP", "EmployeeID": 1, "OrderDate": "1997-08-01 00:00:00", "RequiredDate": "1997-09-12 00:00:00", "ShippedDate": "1997-08-08 00:00:00", "ShipVia": 1, "Freight": 154.6800, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10619, "CustomerID": "MEREP", "EmployeeID": 3, "OrderDate": "1997-08-04 00:00:00", "RequiredDate": "1997-09-01 00:00:00", "ShippedDate": "1997-08-07 00:00:00", "ShipVia": 3, "Freight": 91.0500, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10620, "CustomerID": "LAUGB", "EmployeeID": 2, "OrderDate": "1997-08-05 00:00:00", "RequiredDate": "1997-09-02 00:00:00", "ShippedDate": "1997-08-14 00:00:00", "ShipVia": 3, "Freight": 0.9400, "ShipName": "Laughing Bacchus Wine Cellars", "ShipAddress": "2319 Elm St.", "ShipCity": "Vancouver", "ShipRegion": "BC", "ShipPostalCode": "V3F 2K1", "ShipCountry": "Canada" }, { "OrderID": 10621, "CustomerID": "ISLAT", "EmployeeID": 4, "OrderDate": "1997-08-05 00:00:00", "RequiredDate": "1997-09-02 00:00:00", "ShippedDate": "1997-08-11 00:00:00", "ShipVia": 2, "Freight": 23.7300, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10622, "CustomerID": "RICAR", "EmployeeID": 4, "OrderDate": "1997-08-06 00:00:00", "RequiredDate": "1997-09-03 00:00:00", "ShippedDate": "1997-08-11 00:00:00", "ShipVia": 3, "Freight": 50.9700, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10623, "CustomerID": "FRANK", "EmployeeID": 8, "OrderDate": "1997-08-07 00:00:00", "RequiredDate": "1997-09-04 00:00:00", "ShippedDate": "1997-08-12 00:00:00", "ShipVia": 2, "Freight": 97.1800, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10624, "CustomerID": "THECR", "EmployeeID": 4, "OrderDate": "1997-08-07 00:00:00", "RequiredDate": "1997-09-04 00:00:00", "ShippedDate": "1997-08-19 00:00:00", "ShipVia": 2, "Freight": 94.8000, "ShipName": "The Cracker Box", "ShipAddress": "55 Grizzly Peak Rd.", "ShipCity": "Butte", "ShipRegion": "MT", "ShipPostalCode": 59801, "ShipCountry": "USA" }, { "OrderID": 10625, "CustomerID": "ANATR", "EmployeeID": 3, "OrderDate": "1997-08-08 00:00:00", "RequiredDate": "1997-09-05 00:00:00", "ShippedDate": "1997-08-14 00:00:00", "ShipVia": 1, "Freight": 43.9000, "ShipName": "Ana Trujillo Emparedados y helados", "ShipAddress": "Avda. de la Constitucin 2222", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5021, "ShipCountry": "Mexico" }, { "OrderID": 10626, "CustomerID": "BERGS", "EmployeeID": 1, "OrderDate": "1997-08-11 00:00:00", "RequiredDate": "1997-09-08 00:00:00", "ShippedDate": "1997-08-20 00:00:00", "ShipVia": 2, "Freight": 138.6900, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10627, "CustomerID": "SAVEA", "EmployeeID": 8, "OrderDate": "1997-08-11 00:00:00", "RequiredDate": "1997-09-22 00:00:00", "ShippedDate": "1997-08-21 00:00:00", "ShipVia": 3, "Freight": 107.4600, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10628, "CustomerID": "BLONP", "EmployeeID": 4, "OrderDate": "1997-08-12 00:00:00", "RequiredDate": "1997-09-09 00:00:00", "ShippedDate": "1997-08-20 00:00:00", "ShipVia": 3, "Freight": 30.3600, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10629, "CustomerID": "GODOS", "EmployeeID": 4, "OrderDate": "1997-08-12 00:00:00", "RequiredDate": "1997-09-09 00:00:00", "ShippedDate": "1997-08-20 00:00:00", "ShipVia": 3, "Freight": 85.4600, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 10630, "CustomerID": "KOENE", "EmployeeID": 1, "OrderDate": "1997-08-13 00:00:00", "RequiredDate": "1997-09-10 00:00:00", "ShippedDate": "1997-08-19 00:00:00", "ShipVia": 2, "Freight": 32.3500, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10631, "CustomerID": "LAMAI", "EmployeeID": 8, "OrderDate": "1997-08-14 00:00:00", "RequiredDate": "1997-09-11 00:00:00", "ShippedDate": "1997-08-15 00:00:00", "ShipVia": 1, "Freight": 0.8700, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10632, "CustomerID": "WANDK", "EmployeeID": 8, "OrderDate": "1997-08-14 00:00:00", "RequiredDate": "1997-09-11 00:00:00", "ShippedDate": "1997-08-19 00:00:00", "ShipVia": 1, "Freight": 41.3800, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 10633, "CustomerID": "ERNSH", "EmployeeID": 7, "OrderDate": "1997-08-15 00:00:00", "RequiredDate": "1997-09-12 00:00:00", "ShippedDate": "1997-08-18 00:00:00", "ShipVia": 3, "Freight": 477.9000, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10634, "CustomerID": "FOLIG", "EmployeeID": 4, "OrderDate": "1997-08-15 00:00:00", "RequiredDate": "1997-09-12 00:00:00", "ShippedDate": "1997-08-21 00:00:00", "ShipVia": 3, "Freight": 487.3800, "ShipName": "Folies gourmandes", "ShipAddress": "184, chausse de Tournai", "ShipCity": "Lille", "ShipRegion": null, "ShipPostalCode": 59000, "ShipCountry": "France" }, { "OrderID": 10635, "CustomerID": "MAGAA", "EmployeeID": 8, "OrderDate": "1997-08-18 00:00:00", "RequiredDate": "1997-09-15 00:00:00", "ShippedDate": "1997-08-21 00:00:00", "ShipVia": 3, "Freight": 47.4600, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10636, "CustomerID": "WARTH", "EmployeeID": 4, "OrderDate": "1997-08-19 00:00:00", "RequiredDate": "1997-09-16 00:00:00", "ShippedDate": "1997-08-26 00:00:00", "ShipVia": 1, "Freight": 1.1500, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10637, "CustomerID": "QUEEN", "EmployeeID": 6, "OrderDate": "1997-08-19 00:00:00", "RequiredDate": "1997-09-16 00:00:00", "ShippedDate": "1997-08-26 00:00:00", "ShipVia": 1, "Freight": 201.2900, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10638, "CustomerID": "LINOD", "EmployeeID": 3, "OrderDate": "1997-08-20 00:00:00", "RequiredDate": "1997-09-17 00:00:00", "ShippedDate": "1997-09-01 00:00:00", "ShipVia": 1, "Freight": 158.4400, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10639, "CustomerID": "SANTG", "EmployeeID": 7, "OrderDate": "1997-08-20 00:00:00", "RequiredDate": "1997-09-17 00:00:00", "ShippedDate": "1997-08-27 00:00:00", "ShipVia": 3, "Freight": 38.6400, "ShipName": "Sant Gourmet", "ShipAddress": "Erling Skakkes gate 78", "ShipCity": "Stavern", "ShipRegion": null, "ShipPostalCode": 4110, "ShipCountry": "Norway" }, { "OrderID": 10640, "CustomerID": "WANDK", "EmployeeID": 4, "OrderDate": "1997-08-21 00:00:00", "RequiredDate": "1997-09-18 00:00:00", "ShippedDate": "1997-08-28 00:00:00", "ShipVia": 1, "Freight": 23.5500, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 10641, "CustomerID": "HILAA", "EmployeeID": 4, "OrderDate": "1997-08-22 00:00:00", "RequiredDate": "1997-09-19 00:00:00", "ShippedDate": "1997-08-26 00:00:00", "ShipVia": 2, "Freight": 179.6100, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10642, "CustomerID": "SIMOB", "EmployeeID": 7, "OrderDate": "1997-08-22 00:00:00", "RequiredDate": "1997-09-19 00:00:00", "ShippedDate": "1997-09-05 00:00:00", "ShipVia": 3, "Freight": 41.8900, "ShipName": "Simons bistro", "ShipAddress": "Vinbltet 34", "ShipCity": "Kobenhavn", "ShipRegion": null, "ShipPostalCode": 1734, "ShipCountry": "Denmark" }, { "OrderID": 10643, "CustomerID": "ALFKI", "EmployeeID": 6, "OrderDate": "1997-08-25 00:00:00", "RequiredDate": "1997-09-22 00:00:00", "ShippedDate": "1997-09-02 00:00:00", "ShipVia": 1, "Freight": 29.4600, "ShipName": "Alfreds Futterkiste", "ShipAddress": "Obere Str. 57", "ShipCity": "Berlin", "ShipRegion": null, "ShipPostalCode": 12209, "ShipCountry": "Germany" }, { "OrderID": 10644, "CustomerID": "WELLI", "EmployeeID": 3, "OrderDate": "1997-08-25 00:00:00", "RequiredDate": "1997-09-22 00:00:00", "ShippedDate": "1997-09-01 00:00:00", "ShipVia": 2, "Freight": 0.1400, "ShipName": "Wellington Importadora", "ShipAddress": "Rua do Mercado, 12", "ShipCity": "Resende", "ShipRegion": "SP", "ShipPostalCode": "08737-363", "ShipCountry": "Brazil" }, { "OrderID": 10645, "CustomerID": "HANAR", "EmployeeID": 4, "OrderDate": "1997-08-26 00:00:00", "RequiredDate": "1997-09-23 00:00:00", "ShippedDate": "1997-09-02 00:00:00", "ShipVia": 1, "Freight": 12.4100, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10646, "CustomerID": "HUNGO", "EmployeeID": 9, "OrderDate": "1997-08-27 00:00:00", "RequiredDate": "1997-10-08 00:00:00", "ShippedDate": "1997-09-03 00:00:00", "ShipVia": 3, "Freight": 142.3300, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10647, "CustomerID": "QUEDE", "EmployeeID": 4, "OrderDate": "1997-08-27 00:00:00", "RequiredDate": "1997-09-10 00:00:00", "ShippedDate": "1997-09-03 00:00:00", "ShipVia": 2, "Freight": 45.5400, "ShipName": "Que Delcia", "ShipAddress": "Rua da Panificadora, 12", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-673", "ShipCountry": "Brazil" }, { "OrderID": 10648, "CustomerID": "RICAR", "EmployeeID": 5, "OrderDate": "1997-08-28 00:00:00", "RequiredDate": "1997-10-09 00:00:00", "ShippedDate": "1997-09-09 00:00:00", "ShipVia": 2, "Freight": 14.2500, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10649, "CustomerID": "MAISD", "EmployeeID": 5, "OrderDate": "1997-08-28 00:00:00", "RequiredDate": "1997-09-25 00:00:00", "ShippedDate": "1997-08-29 00:00:00", "ShipVia": 3, "Freight": 6.2000, "ShipName": "Maison Dewey", "ShipAddress": "Rue Joseph-Bens 532", "ShipCity": "Bruxelles", "ShipRegion": null, "ShipPostalCode": "B-1180", "ShipCountry": "Belgium" }, { "OrderID": 10650, "CustomerID": "FAMIA", "EmployeeID": 5, "OrderDate": "1997-08-29 00:00:00", "RequiredDate": "1997-09-26 00:00:00", "ShippedDate": "1997-09-03 00:00:00", "ShipVia": 3, "Freight": 176.8100, "ShipName": "Familia Arquibaldo", "ShipAddress": "Rua Ors, 92", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05442-030", "ShipCountry": "Brazil" }, { "OrderID": 10651, "CustomerID": "WANDK", "EmployeeID": 8, "OrderDate": "1997-09-01 00:00:00", "RequiredDate": "1997-09-29 00:00:00", "ShippedDate": "1997-09-11 00:00:00", "ShipVia": 2, "Freight": 20.6000, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 10652, "CustomerID": "GOURL", "EmployeeID": 4, "OrderDate": "1997-09-01 00:00:00", "RequiredDate": "1997-09-29 00:00:00", "ShippedDate": "1997-09-08 00:00:00", "ShipVia": 2, "Freight": 7.1400, "ShipName": "Gourmet Lanchonetes", "ShipAddress": "Av. Brasil, 442", "ShipCity": "Campinas", "ShipRegion": "SP", "ShipPostalCode": "04876-786", "ShipCountry": "Brazil" }, { "OrderID": 10653, "CustomerID": "FRANK", "EmployeeID": 1, "OrderDate": "1997-09-02 00:00:00", "RequiredDate": "1997-09-30 00:00:00", "ShippedDate": "1997-09-19 00:00:00", "ShipVia": 1, "Freight": 93.2500, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10654, "CustomerID": "BERGS", "EmployeeID": 5, "OrderDate": "1997-09-02 00:00:00", "RequiredDate": "1997-09-30 00:00:00", "ShippedDate": "1997-09-11 00:00:00", "ShipVia": 1, "Freight": 55.2600, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10655, "CustomerID": "REGGC", "EmployeeID": 1, "OrderDate": "1997-09-03 00:00:00", "RequiredDate": "1997-10-01 00:00:00", "ShippedDate": "1997-09-11 00:00:00", "ShipVia": 2, "Freight": 4.4100, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10656, "CustomerID": "GREAL", "EmployeeID": 6, "OrderDate": "1997-09-04 00:00:00", "RequiredDate": "1997-10-02 00:00:00", "ShippedDate": "1997-09-10 00:00:00", "ShipVia": 1, "Freight": 57.1500, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 10657, "CustomerID": "SAVEA", "EmployeeID": 2, "OrderDate": "1997-09-04 00:00:00", "RequiredDate": "1997-10-02 00:00:00", "ShippedDate": "1997-09-15 00:00:00", "ShipVia": 2, "Freight": 352.6900, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10658, "CustomerID": "QUICK", "EmployeeID": 4, "OrderDate": "1997-09-05 00:00:00", "RequiredDate": "1997-10-03 00:00:00", "ShippedDate": "1997-09-08 00:00:00", "ShipVia": 1, "Freight": 364.1500, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10659, "CustomerID": "QUEEN", "EmployeeID": 7, "OrderDate": "1997-09-05 00:00:00", "RequiredDate": "1997-10-03 00:00:00", "ShippedDate": "1997-09-10 00:00:00", "ShipVia": 2, "Freight": 105.8100, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10660, "CustomerID": "HUNGC", "EmployeeID": 8, "OrderDate": "1997-09-08 00:00:00", "RequiredDate": "1997-10-06 00:00:00", "ShippedDate": "1997-10-15 00:00:00", "ShipVia": 1, "Freight": 111.2900, "ShipName": "Hungry Coyote Import Store", "ShipAddress": "City Center Plaza 516 Main St.", "ShipCity": "Elgin", "ShipRegion": "OR", "ShipPostalCode": 97827, "ShipCountry": "USA" }, { "OrderID": 10661, "CustomerID": "HUNGO", "EmployeeID": 7, "OrderDate": "1997-09-09 00:00:00", "RequiredDate": "1997-10-07 00:00:00", "ShippedDate": "1997-09-15 00:00:00", "ShipVia": 3, "Freight": 17.5500, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10662, "CustomerID": "LONEP", "EmployeeID": 3, "OrderDate": "1997-09-09 00:00:00", "RequiredDate": "1997-10-07 00:00:00", "ShippedDate": "1997-09-18 00:00:00", "ShipVia": 2, "Freight": 1.2800, "ShipName": "Lonesome Pine Restaurant", "ShipAddress": "89 Chiaroscuro Rd.", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97219, "ShipCountry": "USA" }, { "OrderID": 10663, "CustomerID": "BONAP", "EmployeeID": 2, "OrderDate": "1997-09-10 00:00:00", "RequiredDate": "1997-09-24 00:00:00", "ShippedDate": "1997-10-03 00:00:00", "ShipVia": 2, "Freight": 113.1500, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10664, "CustomerID": "FURIB", "EmployeeID": 1, "OrderDate": "1997-09-10 00:00:00", "RequiredDate": "1997-10-08 00:00:00", "ShippedDate": "1997-09-19 00:00:00", "ShipVia": 3, "Freight": 1.2700, "ShipName": "Furia Bacalhau e Frutos do Mar", "ShipAddress": "Jardim das rosas n. 32", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1675, "ShipCountry": "Portugal" }, { "OrderID": 10665, "CustomerID": "LONEP", "EmployeeID": 1, "OrderDate": "1997-09-11 00:00:00", "RequiredDate": "1997-10-09 00:00:00", "ShippedDate": "1997-09-17 00:00:00", "ShipVia": 2, "Freight": 26.3100, "ShipName": "Lonesome Pine Restaurant", "ShipAddress": "89 Chiaroscuro Rd.", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97219, "ShipCountry": "USA" }, { "OrderID": 10666, "CustomerID": "RICSU", "EmployeeID": 7, "OrderDate": "1997-09-12 00:00:00", "RequiredDate": "1997-10-10 00:00:00", "ShippedDate": "1997-09-22 00:00:00", "ShipVia": 2, "Freight": 232.4200, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 10667, "CustomerID": "ERNSH", "EmployeeID": 7, "OrderDate": "1997-09-12 00:00:00", "RequiredDate": "1997-10-10 00:00:00", "ShippedDate": "1997-09-19 00:00:00", "ShipVia": 1, "Freight": 78.0900, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10668, "CustomerID": "WANDK", "EmployeeID": 1, "OrderDate": "1997-09-15 00:00:00", "RequiredDate": "1997-10-13 00:00:00", "ShippedDate": "1997-09-23 00:00:00", "ShipVia": 2, "Freight": 47.2200, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 10669, "CustomerID": "SIMOB", "EmployeeID": 2, "OrderDate": "1997-09-15 00:00:00", "RequiredDate": "1997-10-13 00:00:00", "ShippedDate": "1997-09-22 00:00:00", "ShipVia": 1, "Freight": 24.3900, "ShipName": "Simons bistro", "ShipAddress": "Vinbltet 34", "ShipCity": "Kobenhavn", "ShipRegion": null, "ShipPostalCode": 1734, "ShipCountry": "Denmark" }, { "OrderID": 10670, "CustomerID": "FRANK", "EmployeeID": 4, "OrderDate": "1997-09-16 00:00:00", "RequiredDate": "1997-10-14 00:00:00", "ShippedDate": "1997-09-18 00:00:00", "ShipVia": 1, "Freight": 203.4800, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10671, "CustomerID": "FRANR", "EmployeeID": 1, "OrderDate": "1997-09-17 00:00:00", "RequiredDate": "1997-10-15 00:00:00", "ShippedDate": "1997-09-24 00:00:00", "ShipVia": 1, "Freight": 30.3400, "ShipName": "France restauration", "ShipAddress": "54, rue Royale", "ShipCity": "Nantes", "ShipRegion": null, "ShipPostalCode": 44000, "ShipCountry": "France" }, { "OrderID": 10672, "CustomerID": "BERGS", "EmployeeID": 9, "OrderDate": "1997-09-17 00:00:00", "RequiredDate": "1997-10-01 00:00:00", "ShippedDate": "1997-09-26 00:00:00", "ShipVia": 2, "Freight": 95.7500, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10673, "CustomerID": "WILMK", "EmployeeID": 2, "OrderDate": "1997-09-18 00:00:00", "RequiredDate": "1997-10-16 00:00:00", "ShippedDate": "1997-09-19 00:00:00", "ShipVia": 1, "Freight": 22.7600, "ShipName": "Wilman Kala", "ShipAddress": "Keskuskatu 45", "ShipCity": "Helsinki", "ShipRegion": null, "ShipPostalCode": 21240, "ShipCountry": "Finland" }, { "OrderID": 10674, "CustomerID": "ISLAT", "EmployeeID": 4, "OrderDate": "1997-09-18 00:00:00", "RequiredDate": "1997-10-16 00:00:00", "ShippedDate": "1997-09-30 00:00:00", "ShipVia": 2, "Freight": 0.9000, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10675, "CustomerID": "FRANK", "EmployeeID": 5, "OrderDate": "1997-09-19 00:00:00", "RequiredDate": "1997-10-17 00:00:00", "ShippedDate": "1997-09-23 00:00:00", "ShipVia": 2, "Freight": 31.8500, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10676, "CustomerID": "TORTU", "EmployeeID": 2, "OrderDate": "1997-09-22 00:00:00", "RequiredDate": "1997-10-20 00:00:00", "ShippedDate": "1997-09-29 00:00:00", "ShipVia": 2, "Freight": 2.0100, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10677, "CustomerID": "ANTON", "EmployeeID": 1, "OrderDate": "1997-09-22 00:00:00", "RequiredDate": "1997-10-20 00:00:00", "ShippedDate": "1997-09-26 00:00:00", "ShipVia": 3, "Freight": 4.0300, "ShipName": "Antonio Moreno Taquera", "ShipAddress": "Mataderos 2312", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5023, "ShipCountry": "Mexico" }, { "OrderID": 10678, "CustomerID": "SAVEA", "EmployeeID": 7, "OrderDate": "1997-09-23 00:00:00", "RequiredDate": "1997-10-21 00:00:00", "ShippedDate": "1997-10-16 00:00:00", "ShipVia": 3, "Freight": 388.9800, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10679, "CustomerID": "BLONP", "EmployeeID": 8, "OrderDate": "1997-09-23 00:00:00", "RequiredDate": "1997-10-21 00:00:00", "ShippedDate": "1997-09-30 00:00:00", "ShipVia": 3, "Freight": 27.9400, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10680, "CustomerID": "OLDWO", "EmployeeID": 1, "OrderDate": "1997-09-24 00:00:00", "RequiredDate": "1997-10-22 00:00:00", "ShippedDate": "1997-09-26 00:00:00", "ShipVia": 1, "Freight": 26.6100, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 10681, "CustomerID": "GREAL", "EmployeeID": 3, "OrderDate": "1997-09-25 00:00:00", "RequiredDate": "1997-10-23 00:00:00", "ShippedDate": "1997-09-30 00:00:00", "ShipVia": 3, "Freight": 76.1300, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 10682, "CustomerID": "ANTON", "EmployeeID": 3, "OrderDate": "1997-09-25 00:00:00", "RequiredDate": "1997-10-23 00:00:00", "ShippedDate": "1997-10-01 00:00:00", "ShipVia": 2, "Freight": 36.1300, "ShipName": "Antonio Moreno Taquera", "ShipAddress": "Mataderos 2312", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5023, "ShipCountry": "Mexico" }, { "OrderID": 10683, "CustomerID": "DUMON", "EmployeeID": 2, "OrderDate": "1997-09-26 00:00:00", "RequiredDate": "1997-10-24 00:00:00", "ShippedDate": "1997-10-01 00:00:00", "ShipVia": 1, "Freight": 4.4000, "ShipName": "Du monde entier", "ShipAddress": "67, rue des Cinquante Otages", "ShipCity": "Nantes", "ShipRegion": null, "ShipPostalCode": 44000, "ShipCountry": "France" }, { "OrderID": 10684, "CustomerID": "OTTIK", "EmployeeID": 3, "OrderDate": "1997-09-26 00:00:00", "RequiredDate": "1997-10-24 00:00:00", "ShippedDate": "1997-09-30 00:00:00", "ShipVia": 1, "Freight": 145.6300, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 10685, "CustomerID": "GOURL", "EmployeeID": 4, "OrderDate": "1997-09-29 00:00:00", "RequiredDate": "1997-10-13 00:00:00", "ShippedDate": "1997-10-03 00:00:00", "ShipVia": 2, "Freight": 33.7500, "ShipName": "Gourmet Lanchonetes", "ShipAddress": "Av. Brasil, 442", "ShipCity": "Campinas", "ShipRegion": "SP", "ShipPostalCode": "04876-786", "ShipCountry": "Brazil" }, { "OrderID": 10686, "CustomerID": "PICCO", "EmployeeID": 2, "OrderDate": "1997-09-30 00:00:00", "RequiredDate": "1997-10-28 00:00:00", "ShippedDate": "1997-10-08 00:00:00", "ShipVia": 1, "Freight": 96.5000, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 10687, "CustomerID": "HUNGO", "EmployeeID": 9, "OrderDate": "1997-09-30 00:00:00", "RequiredDate": "1997-10-28 00:00:00", "ShippedDate": "1997-10-30 00:00:00", "ShipVia": 2, "Freight": 296.4300, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10688, "CustomerID": "VAFFE", "EmployeeID": 4, "OrderDate": "1997-10-01 00:00:00", "RequiredDate": "1997-10-15 00:00:00", "ShippedDate": "1997-10-07 00:00:00", "ShipVia": 2, "Freight": 299.0900, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10689, "CustomerID": "BERGS", "EmployeeID": 1, "OrderDate": "1997-10-01 00:00:00", "RequiredDate": "1997-10-29 00:00:00", "ShippedDate": "1997-10-07 00:00:00", "ShipVia": 2, "Freight": 13.4200, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10690, "CustomerID": "HANAR", "EmployeeID": 1, "OrderDate": "1997-10-02 00:00:00", "RequiredDate": "1997-10-30 00:00:00", "ShippedDate": "1997-10-03 00:00:00", "ShipVia": 1, "Freight": 15.8000, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10691, "CustomerID": "QUICK", "EmployeeID": 2, "OrderDate": "1997-10-03 00:00:00", "RequiredDate": "1997-11-14 00:00:00", "ShippedDate": "1997-10-22 00:00:00", "ShipVia": 2, "Freight": 810.0500, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10692, "CustomerID": "ALFKI", "EmployeeID": 4, "OrderDate": "1997-10-03 00:00:00", "RequiredDate": "1997-10-31 00:00:00", "ShippedDate": "1997-10-13 00:00:00", "ShipVia": 2, "Freight": 61.0200, "ShipName": "Alfred-s Futterkiste", "ShipAddress": "Obere Str. 57", "ShipCity": "Berlin", "ShipRegion": null, "ShipPostalCode": 12209, "ShipCountry": "Germany" }, { "OrderID": 10693, "CustomerID": "WHITC", "EmployeeID": 3, "OrderDate": "1997-10-06 00:00:00", "RequiredDate": "1997-10-20 00:00:00", "ShippedDate": "1997-10-10 00:00:00", "ShipVia": 3, "Freight": 139.3400, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10694, "CustomerID": "QUICK", "EmployeeID": 8, "OrderDate": "1997-10-06 00:00:00", "RequiredDate": "1997-11-03 00:00:00", "ShippedDate": "1997-10-09 00:00:00", "ShipVia": 3, "Freight": 398.3600, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10695, "CustomerID": "WILMK", "EmployeeID": 7, "OrderDate": "1997-10-07 00:00:00", "RequiredDate": "1997-11-18 00:00:00", "ShippedDate": "1997-10-14 00:00:00", "ShipVia": 1, "Freight": 16.7200, "ShipName": "Wilman Kala", "ShipAddress": "Keskuskatu 45", "ShipCity": "Helsinki", "ShipRegion": null, "ShipPostalCode": 21240, "ShipCountry": "Finland" }, { "OrderID": 10696, "CustomerID": "WHITC", "EmployeeID": 8, "OrderDate": "1997-10-08 00:00:00", "RequiredDate": "1997-11-19 00:00:00", "ShippedDate": "1997-10-14 00:00:00", "ShipVia": 3, "Freight": 102.5500, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10697, "CustomerID": "LINOD", "EmployeeID": 3, "OrderDate": "1997-10-08 00:00:00", "RequiredDate": "1997-11-05 00:00:00", "ShippedDate": "1997-10-14 00:00:00", "ShipVia": 1, "Freight": 45.5200, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10698, "CustomerID": "ERNSH", "EmployeeID": 4, "OrderDate": "1997-10-09 00:00:00", "RequiredDate": "1997-11-06 00:00:00", "ShippedDate": "1997-10-17 00:00:00", "ShipVia": 1, "Freight": 272.4700, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10699, "CustomerID": "MORGK", "EmployeeID": 3, "OrderDate": "1997-10-09 00:00:00", "RequiredDate": "1997-11-06 00:00:00", "ShippedDate": "1997-10-13 00:00:00", "ShipVia": 3, "Freight": 0.5800, "ShipName": "Morgenstern Gesundkost", "ShipAddress": "Heerstr. 22", "ShipCity": "Leipzig", "ShipRegion": null, "ShipPostalCode": 4179, "ShipCountry": "Germany" }, { "OrderID": 10700, "CustomerID": "SAVEA", "EmployeeID": 3, "OrderDate": "1997-10-10 00:00:00", "RequiredDate": "1997-11-07 00:00:00", "ShippedDate": "1997-10-16 00:00:00", "ShipVia": 1, "Freight": 65.1000, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10701, "CustomerID": "HUNGO", "EmployeeID": 6, "OrderDate": "1997-10-13 00:00:00", "RequiredDate": "1997-10-27 00:00:00", "ShippedDate": "1997-10-15 00:00:00", "ShipVia": 3, "Freight": 220.3100, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10702, "CustomerID": "ALFKI", "EmployeeID": 4, "OrderDate": "1997-10-13 00:00:00", "RequiredDate": "1997-11-24 00:00:00", "ShippedDate": "1997-10-21 00:00:00", "ShipVia": 1, "Freight": 23.9400, "ShipName": "Alfred-s Futterkiste", "ShipAddress": "Obere Str. 57", "ShipCity": "Berlin", "ShipRegion": null, "ShipPostalCode": 12209, "ShipCountry": "Germany" }, { "OrderID": 10703, "CustomerID": "FOLKO", "EmployeeID": 6, "OrderDate": "1997-10-14 00:00:00", "RequiredDate": "1997-11-11 00:00:00", "ShippedDate": "1997-10-20 00:00:00", "ShipVia": 2, "Freight": 152.3000, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10704, "CustomerID": "QUEEN", "EmployeeID": 6, "OrderDate": "1997-10-14 00:00:00", "RequiredDate": "1997-11-11 00:00:00", "ShippedDate": "1997-11-07 00:00:00", "ShipVia": 1, "Freight": 4.7800, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10705, "CustomerID": "HILAA", "EmployeeID": 9, "OrderDate": "1997-10-15 00:00:00", "RequiredDate": "1997-11-12 00:00:00", "ShippedDate": "1997-11-18 00:00:00", "ShipVia": 2, "Freight": 3.5200, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10706, "CustomerID": "OLDWO", "EmployeeID": 8, "OrderDate": "1997-10-16 00:00:00", "RequiredDate": "1997-11-13 00:00:00", "ShippedDate": "1997-10-21 00:00:00", "ShipVia": 3, "Freight": 135.6300, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 10707, "CustomerID": "AROUT", "EmployeeID": 4, "OrderDate": "1997-10-16 00:00:00", "RequiredDate": "1997-10-30 00:00:00", "ShippedDate": "1997-10-23 00:00:00", "ShipVia": 3, "Freight": 21.7400, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10708, "CustomerID": "THEBI", "EmployeeID": 6, "OrderDate": "1997-10-17 00:00:00", "RequiredDate": "1997-11-28 00:00:00", "ShippedDate": "1997-11-05 00:00:00", "ShipVia": 2, "Freight": 2.9600, "ShipName": "The Big Cheese", "ShipAddress": "89 Jefferson Way Suite 2", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97201, "ShipCountry": "USA" }, { "OrderID": 10709, "CustomerID": "GOURL", "EmployeeID": 1, "OrderDate": "1997-10-17 00:00:00", "RequiredDate": "1997-11-14 00:00:00", "ShippedDate": "1997-11-20 00:00:00", "ShipVia": 3, "Freight": 210.8000, "ShipName": "Gourmet Lanchonetes", "ShipAddress": "Av. Brasil, 442", "ShipCity": "Campinas", "ShipRegion": "SP", "ShipPostalCode": "04876-786", "ShipCountry": "Brazil" }, { "OrderID": 10710, "CustomerID": "FRANS", "EmployeeID": 1, "OrderDate": "1997-10-20 00:00:00", "RequiredDate": "1997-11-17 00:00:00", "ShippedDate": "1997-10-23 00:00:00", "ShipVia": 1, "Freight": 4.9800, "ShipName": "Franchi S.p.A.", "ShipAddress": "Via Monte Bianco 34", "ShipCity": "Torino", "ShipRegion": null, "ShipPostalCode": 10100, "ShipCountry": "Italy" }, { "OrderID": 10711, "CustomerID": "SAVEA", "EmployeeID": 5, "OrderDate": "1997-10-21 00:00:00", "RequiredDate": "1997-12-02 00:00:00", "ShippedDate": "1997-10-29 00:00:00", "ShipVia": 2, "Freight": 52.4100, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10712, "CustomerID": "HUNGO", "EmployeeID": 3, "OrderDate": "1997-10-21 00:00:00", "RequiredDate": "1997-11-18 00:00:00", "ShippedDate": "1997-10-31 00:00:00", "ShipVia": 1, "Freight": 89.9300, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10713, "CustomerID": "SAVEA", "EmployeeID": 1, "OrderDate": "1997-10-22 00:00:00", "RequiredDate": "1997-11-19 00:00:00", "ShippedDate": "1997-10-24 00:00:00", "ShipVia": 1, "Freight": 167.0500, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10714, "CustomerID": "SAVEA", "EmployeeID": 5, "OrderDate": "1997-10-22 00:00:00", "RequiredDate": "1997-11-19 00:00:00", "ShippedDate": "1997-10-27 00:00:00", "ShipVia": 3, "Freight": 24.4900, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10715, "CustomerID": "BONAP", "EmployeeID": 3, "OrderDate": "1997-10-23 00:00:00", "RequiredDate": "1997-11-06 00:00:00", "ShippedDate": "1997-10-29 00:00:00", "ShipVia": 1, "Freight": 63.2000, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10716, "CustomerID": "RANCH", "EmployeeID": 4, "OrderDate": "1997-10-24 00:00:00", "RequiredDate": "1997-11-21 00:00:00", "ShippedDate": "1997-10-27 00:00:00", "ShipVia": 2, "Freight": 22.5700, "ShipName": "Rancho grande", "ShipAddress": "Av. del Libertador 900", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10717, "CustomerID": "FRANK", "EmployeeID": 1, "OrderDate": "1997-10-24 00:00:00", "RequiredDate": "1997-11-21 00:00:00", "ShippedDate": "1997-10-29 00:00:00", "ShipVia": 2, "Freight": 59.2500, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10718, "CustomerID": "KOENE", "EmployeeID": 1, "OrderDate": "1997-10-27 00:00:00", "RequiredDate": "1997-11-24 00:00:00", "ShippedDate": "1997-10-29 00:00:00", "ShipVia": 3, "Freight": 170.8800, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10719, "CustomerID": "LETSS", "EmployeeID": 8, "OrderDate": "1997-10-27 00:00:00", "RequiredDate": "1997-11-24 00:00:00", "ShippedDate": "1997-11-05 00:00:00", "ShipVia": 2, "Freight": 51.4400, "ShipName": "Let-s Stop N Shop", "ShipAddress": "87 Polk St. Suite 5", "ShipCity": "San Francisco", "ShipRegion": "CA", "ShipPostalCode": 94117, "ShipCountry": "USA" }, { "OrderID": 10720, "CustomerID": "QUEDE", "EmployeeID": 8, "OrderDate": "1997-10-28 00:00:00", "RequiredDate": "1997-11-11 00:00:00", "ShippedDate": "1997-11-05 00:00:00", "ShipVia": 2, "Freight": 9.5300, "ShipName": "Que Delcia", "ShipAddress": "Rua da Panificadora, 12", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-673", "ShipCountry": "Brazil" }, { "OrderID": 10721, "CustomerID": "QUICK", "EmployeeID": 5, "OrderDate": "1997-10-29 00:00:00", "RequiredDate": "1997-11-26 00:00:00", "ShippedDate": "1997-10-31 00:00:00", "ShipVia": 3, "Freight": 48.9200, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10722, "CustomerID": "SAVEA", "EmployeeID": 8, "OrderDate": "1997-10-29 00:00:00", "RequiredDate": "1997-12-10 00:00:00", "ShippedDate": "1997-11-04 00:00:00", "ShipVia": 1, "Freight": 74.5800, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10723, "CustomerID": "WHITC", "EmployeeID": 3, "OrderDate": "1997-10-30 00:00:00", "RequiredDate": "1997-11-27 00:00:00", "ShippedDate": "1997-11-25 00:00:00", "ShipVia": 1, "Freight": 21.7200, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10724, "CustomerID": "MEREP", "EmployeeID": 8, "OrderDate": "1997-10-30 00:00:00", "RequiredDate": "1997-12-11 00:00:00", "ShippedDate": "1997-11-05 00:00:00", "ShipVia": 2, "Freight": 57.7500, "ShipName": "Mre Paillarde", "ShipAddress": "43 rue St. Laurent", "ShipCity": "Montral", "ShipRegion": "Qubec", "ShipPostalCode": "H1J 1C3", "ShipCountry": "Canada" }, { "OrderID": 10725, "CustomerID": "FAMIA", "EmployeeID": 4, "OrderDate": "1997-10-31 00:00:00", "RequiredDate": "1997-11-28 00:00:00", "ShippedDate": "1997-11-05 00:00:00", "ShipVia": 3, "Freight": 10.8300, "ShipName": "Familia Arquibaldo", "ShipAddress": "Rua Ors, 92", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05442-030", "ShipCountry": "Brazil" }, { "OrderID": 10726, "CustomerID": "EASTC", "EmployeeID": 4, "OrderDate": "1997-11-03 00:00:00", "RequiredDate": "1997-11-17 00:00:00", "ShippedDate": "1997-12-05 00:00:00", "ShipVia": 1, "Freight": 16.5600, "ShipName": "Eastern Connection", "ShipAddress": "35 King George", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX3 6FW", "ShipCountry": "UK" }, { "OrderID": 10727, "CustomerID": "REGGC", "EmployeeID": 2, "OrderDate": "1997-11-03 00:00:00", "RequiredDate": "1997-12-01 00:00:00", "ShippedDate": "1997-12-05 00:00:00", "ShipVia": 1, "Freight": 89.9000, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10728, "CustomerID": "QUEEN", "EmployeeID": 4, "OrderDate": "1997-11-04 00:00:00", "RequiredDate": "1997-12-02 00:00:00", "ShippedDate": "1997-11-11 00:00:00", "ShipVia": 2, "Freight": 58.3300, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10729, "CustomerID": "LINOD", "EmployeeID": 8, "OrderDate": "1997-11-04 00:00:00", "RequiredDate": "1997-12-16 00:00:00", "ShippedDate": "1997-11-14 00:00:00", "ShipVia": 3, "Freight": 141.0600, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10730, "CustomerID": "BONAP", "EmployeeID": 5, "OrderDate": "1997-11-05 00:00:00", "RequiredDate": "1997-12-03 00:00:00", "ShippedDate": "1997-11-14 00:00:00", "ShipVia": 1, "Freight": 20.1200, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10731, "CustomerID": "CHOPS", "EmployeeID": 7, "OrderDate": "1997-11-06 00:00:00", "RequiredDate": "1997-12-04 00:00:00", "ShippedDate": "1997-11-14 00:00:00", "ShipVia": 1, "Freight": 96.6500, "ShipName": "Chop-suey Chinese", "ShipAddress": "Hauptstr. 31", "ShipCity": "Bern", "ShipRegion": null, "ShipPostalCode": 3012, "ShipCountry": "Switzerland" }, { "OrderID": 10732, "CustomerID": "BONAP", "EmployeeID": 3, "OrderDate": "1997-11-06 00:00:00", "RequiredDate": "1997-12-04 00:00:00", "ShippedDate": "1997-11-07 00:00:00", "ShipVia": 1, "Freight": 16.9700, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10733, "CustomerID": "BERGS", "EmployeeID": 1, "OrderDate": "1997-11-07 00:00:00", "RequiredDate": "1997-12-05 00:00:00", "ShippedDate": "1997-11-10 00:00:00", "ShipVia": 3, "Freight": 110.1100, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10734, "CustomerID": "GOURL", "EmployeeID": 2, "OrderDate": "1997-11-07 00:00:00", "RequiredDate": "1997-12-05 00:00:00", "ShippedDate": "1997-11-12 00:00:00", "ShipVia": 3, "Freight": 1.6300, "ShipName": "Gourmet Lanchonetes", "ShipAddress": "Av. Brasil, 442", "ShipCity": "Campinas", "ShipRegion": "SP", "ShipPostalCode": "04876-786", "ShipCountry": "Brazil" }, { "OrderID": 10735, "CustomerID": "LETSS", "EmployeeID": 6, "OrderDate": "1997-11-10 00:00:00", "RequiredDate": "1997-12-08 00:00:00", "ShippedDate": "1997-11-21 00:00:00", "ShipVia": 2, "Freight": 45.9700, "ShipName": "Let-s Stop N Shop", "ShipAddress": "87 Polk St. Suite 5", "ShipCity": "San Francisco", "ShipRegion": "CA", "ShipPostalCode": 94117, "ShipCountry": "USA" }, { "OrderID": 10736, "CustomerID": "HUNGO", "EmployeeID": 9, "OrderDate": "1997-11-11 00:00:00", "RequiredDate": "1997-12-09 00:00:00", "ShippedDate": "1997-11-21 00:00:00", "ShipVia": 2, "Freight": 44.1000, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10737, "CustomerID": "VINET", "EmployeeID": 2, "OrderDate": "1997-11-11 00:00:00", "RequiredDate": "1997-12-09 00:00:00", "ShippedDate": "1997-11-18 00:00:00", "ShipVia": 2, "Freight": 7.7900, "ShipName": "Vins et alcools Chevalier", "ShipAddress": "59 rue de l-Abbaye", "ShipCity": "Reims", "ShipRegion": null, "ShipPostalCode": 51100, "ShipCountry": "France" }, { "OrderID": 10738, "CustomerID": "SPECD", "EmployeeID": 2, "OrderDate": "1997-11-12 00:00:00", "RequiredDate": "1997-12-10 00:00:00", "ShippedDate": "1997-11-18 00:00:00", "ShipVia": 1, "Freight": 2.9100, "ShipName": "Spcialits du monde", "ShipAddress": "25, rue Lauriston", "ShipCity": "Paris", "ShipRegion": null, "ShipPostalCode": 75016, "ShipCountry": "France" }, { "OrderID": 10739, "CustomerID": "VINET", "EmployeeID": 3, "OrderDate": "1997-11-12 00:00:00", "RequiredDate": "1997-12-10 00:00:00", "ShippedDate": "1997-11-17 00:00:00", "ShipVia": 3, "Freight": 11.0800, "ShipName": "Vins et alcools Chevalier", "ShipAddress": "59 rue de l-Abbaye", "ShipCity": "Reims", "ShipRegion": null, "ShipPostalCode": 51100, "ShipCountry": "France" }, { "OrderID": 10740, "CustomerID": "WHITC", "EmployeeID": 4, "OrderDate": "1997-11-13 00:00:00", "RequiredDate": "1997-12-11 00:00:00", "ShippedDate": "1997-11-25 00:00:00", "ShipVia": 2, "Freight": 81.8800, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10741, "CustomerID": "AROUT", "EmployeeID": 4, "OrderDate": "1997-11-14 00:00:00", "RequiredDate": "1997-11-28 00:00:00", "ShippedDate": "1997-11-18 00:00:00", "ShipVia": 3, "Freight": 10.9600, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10742, "CustomerID": "BOTTM", "EmployeeID": 3, "OrderDate": "1997-11-14 00:00:00", "RequiredDate": "1997-12-12 00:00:00", "ShippedDate": "1997-11-18 00:00:00", "ShipVia": 3, "Freight": 243.7300, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10743, "CustomerID": "AROUT", "EmployeeID": 1, "OrderDate": "1997-11-17 00:00:00", "RequiredDate": "1997-12-15 00:00:00", "ShippedDate": "1997-11-21 00:00:00", "ShipVia": 2, "Freight": 23.7200, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10744, "CustomerID": "VAFFE", "EmployeeID": 6, "OrderDate": "1997-11-17 00:00:00", "RequiredDate": "1997-12-15 00:00:00", "ShippedDate": "1997-11-24 00:00:00", "ShipVia": 1, "Freight": 69.1900, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10745, "CustomerID": "QUICK", "EmployeeID": 9, "OrderDate": "1997-11-18 00:00:00", "RequiredDate": "1997-12-16 00:00:00", "ShippedDate": "1997-11-27 00:00:00", "ShipVia": 1, "Freight": 3.5200, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10746, "CustomerID": "CHOPS", "EmployeeID": 1, "OrderDate": "1997-11-19 00:00:00", "RequiredDate": "1997-12-17 00:00:00", "ShippedDate": "1997-11-21 00:00:00", "ShipVia": 3, "Freight": 31.4300, "ShipName": "Chop-suey Chinese", "ShipAddress": "Hauptstr. 31", "ShipCity": "Bern", "ShipRegion": null, "ShipPostalCode": 3012, "ShipCountry": "Switzerland" }, { "OrderID": 10747, "CustomerID": "PICCO", "EmployeeID": 6, "OrderDate": "1997-11-19 00:00:00", "RequiredDate": "1997-12-17 00:00:00", "ShippedDate": "1997-11-26 00:00:00", "ShipVia": 1, "Freight": 117.3300, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 10748, "CustomerID": "SAVEA", "EmployeeID": 3, "OrderDate": "1997-11-20 00:00:00", "RequiredDate": "1997-12-18 00:00:00", "ShippedDate": "1997-11-28 00:00:00", "ShipVia": 1, "Freight": 232.5500, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10749, "CustomerID": "ISLAT", "EmployeeID": 4, "OrderDate": "1997-11-20 00:00:00", "RequiredDate": "1997-12-18 00:00:00", "ShippedDate": "1997-12-19 00:00:00", "ShipVia": 2, "Freight": 61.5300, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10750, "CustomerID": "WARTH", "EmployeeID": 9, "OrderDate": "1997-11-21 00:00:00", "RequiredDate": "1997-12-19 00:00:00", "ShippedDate": "1997-11-24 00:00:00", "ShipVia": 1, "Freight": 79.3000, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10751, "CustomerID": "RICSU", "EmployeeID": 3, "OrderDate": "1997-11-24 00:00:00", "RequiredDate": "1997-12-22 00:00:00", "ShippedDate": "1997-12-03 00:00:00", "ShipVia": 3, "Freight": 130.7900, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 10752, "CustomerID": "NORTS", "EmployeeID": 2, "OrderDate": "1997-11-24 00:00:00", "RequiredDate": "1997-12-22 00:00:00", "ShippedDate": "1997-11-28 00:00:00", "ShipVia": 3, "Freight": 1.3900, "ShipName": "North/South", "ShipAddress": "South House 300 Queensbridge", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "SW7 1RZ", "ShipCountry": "UK" }, { "OrderID": 10753, "CustomerID": "FRANS", "EmployeeID": 3, "OrderDate": "1997-11-25 00:00:00", "RequiredDate": "1997-12-23 00:00:00", "ShippedDate": "1997-11-27 00:00:00", "ShipVia": 1, "Freight": 7.7000, "ShipName": "Franchi S.p.A.", "ShipAddress": "Via Monte Bianco 34", "ShipCity": "Torino", "ShipRegion": null, "ShipPostalCode": 10100, "ShipCountry": "Italy" }, { "OrderID": 10754, "CustomerID": "MAGAA", "EmployeeID": 6, "OrderDate": "1997-11-25 00:00:00", "RequiredDate": "1997-12-23 00:00:00", "ShippedDate": "1997-11-27 00:00:00", "ShipVia": 3, "Freight": 2.3800, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10755, "CustomerID": "BONAP", "EmployeeID": 4, "OrderDate": "1997-11-26 00:00:00", "RequiredDate": "1997-12-24 00:00:00", "ShippedDate": "1997-11-28 00:00:00", "ShipVia": 2, "Freight": 16.7100, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10756, "CustomerID": "SPLIR", "EmployeeID": 8, "OrderDate": "1997-11-27 00:00:00", "RequiredDate": "1997-12-25 00:00:00", "ShippedDate": "1997-12-02 00:00:00", "ShipVia": 2, "Freight": 73.2100, "ShipName": "Split Rail Beer & Ale", "ShipAddress": "P.O. Box 555", "ShipCity": "Lander", "ShipRegion": "WY", "ShipPostalCode": 82520, "ShipCountry": "USA" }, { "OrderID": 10757, "CustomerID": "SAVEA", "EmployeeID": 6, "OrderDate": "1997-11-27 00:00:00", "RequiredDate": "1997-12-25 00:00:00", "ShippedDate": "1997-12-15 00:00:00", "ShipVia": 1, "Freight": 8.1900, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10758, "CustomerID": "RICSU", "EmployeeID": 3, "OrderDate": "1997-11-28 00:00:00", "RequiredDate": "1997-12-26 00:00:00", "ShippedDate": "1997-12-04 00:00:00", "ShipVia": 3, "Freight": 138.1700, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 10759, "CustomerID": "ANATR", "EmployeeID": 3, "OrderDate": "1997-11-28 00:00:00", "RequiredDate": "1997-12-26 00:00:00", "ShippedDate": "1997-12-12 00:00:00", "ShipVia": 3, "Freight": 11.9900, "ShipName": "Ana Trujillo Emparedados y helados", "ShipAddress": "Avda. de la Constitucin 2222", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5021, "ShipCountry": "Mexico" }, { "OrderID": 10760, "CustomerID": "MAISD", "EmployeeID": 4, "OrderDate": "1997-12-01 00:00:00", "RequiredDate": "1997-12-29 00:00:00", "ShippedDate": "1997-12-10 00:00:00", "ShipVia": 1, "Freight": 155.6400, "ShipName": "Maison Dewey", "ShipAddress": "Rue Joseph-Bens 532", "ShipCity": "Bruxelles", "ShipRegion": null, "ShipPostalCode": "B-1180", "ShipCountry": "Belgium" }, { "OrderID": 10761, "CustomerID": "RATTC", "EmployeeID": 5, "OrderDate": "1997-12-02 00:00:00", "RequiredDate": "1997-12-30 00:00:00", "ShippedDate": "1997-12-08 00:00:00", "ShipVia": 2, "Freight": 18.6600, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10762, "CustomerID": "FOLKO", "EmployeeID": 3, "OrderDate": "1997-12-02 00:00:00", "RequiredDate": "1997-12-30 00:00:00", "ShippedDate": "1997-12-09 00:00:00", "ShipVia": 1, "Freight": 328.7400, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10763, "CustomerID": "FOLIG", "EmployeeID": 3, "OrderDate": "1997-12-03 00:00:00", "RequiredDate": "1997-12-31 00:00:00", "ShippedDate": "1997-12-08 00:00:00", "ShipVia": 3, "Freight": 37.3500, "ShipName": "Folies gourmandes", "ShipAddress": "184, chausse de Tournai", "ShipCity": "Lille", "ShipRegion": null, "ShipPostalCode": 59000, "ShipCountry": "France" }, { "OrderID": 10764, "CustomerID": "ERNSH", "EmployeeID": 6, "OrderDate": "1997-12-03 00:00:00", "RequiredDate": "1997-12-31 00:00:00", "ShippedDate": "1997-12-08 00:00:00", "ShipVia": 3, "Freight": 145.4500, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10765, "CustomerID": "QUICK", "EmployeeID": 3, "OrderDate": "1997-12-04 00:00:00", "RequiredDate": "1998-01-01 00:00:00", "ShippedDate": "1997-12-09 00:00:00", "ShipVia": 3, "Freight": 42.7400, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10766, "CustomerID": "OTTIK", "EmployeeID": 4, "OrderDate": "1997-12-05 00:00:00", "RequiredDate": "1998-01-02 00:00:00", "ShippedDate": "1997-12-09 00:00:00", "ShipVia": 1, "Freight": 157.5500, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 10767, "CustomerID": "SUPRD", "EmployeeID": 4, "OrderDate": "1997-12-05 00:00:00", "RequiredDate": "1998-01-02 00:00:00", "ShippedDate": "1997-12-15 00:00:00", "ShipVia": 3, "Freight": 1.5900, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10768, "CustomerID": "AROUT", "EmployeeID": 3, "OrderDate": "1997-12-08 00:00:00", "RequiredDate": "1998-01-05 00:00:00", "ShippedDate": "1997-12-15 00:00:00", "ShipVia": 2, "Freight": 146.3200, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10769, "CustomerID": "VAFFE", "EmployeeID": 3, "OrderDate": "1997-12-08 00:00:00", "RequiredDate": "1998-01-05 00:00:00", "ShippedDate": "1997-12-12 00:00:00", "ShipVia": 1, "Freight": 65.0600, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10770, "CustomerID": "HANAR", "EmployeeID": 8, "OrderDate": "1997-12-09 00:00:00", "RequiredDate": "1998-01-06 00:00:00", "ShippedDate": "1997-12-17 00:00:00", "ShipVia": 3, "Freight": 5.3200, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10771, "CustomerID": "ERNSH", "EmployeeID": 9, "OrderDate": "1997-12-10 00:00:00", "RequiredDate": "1998-01-07 00:00:00", "ShippedDate": "1998-01-02 00:00:00", "ShipVia": 2, "Freight": 11.1900, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10772, "CustomerID": "LEHMS", "EmployeeID": 3, "OrderDate": "1997-12-10 00:00:00", "RequiredDate": "1998-01-07 00:00:00", "ShippedDate": "1997-12-19 00:00:00", "ShipVia": 2, "Freight": 91.2800, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10773, "CustomerID": "ERNSH", "EmployeeID": 1, "OrderDate": "1997-12-11 00:00:00", "RequiredDate": "1998-01-08 00:00:00", "ShippedDate": "1997-12-16 00:00:00", "ShipVia": 3, "Freight": 96.4300, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10774, "CustomerID": "FOLKO", "EmployeeID": 4, "OrderDate": "1997-12-11 00:00:00", "RequiredDate": "1997-12-25 00:00:00", "ShippedDate": "1997-12-12 00:00:00", "ShipVia": 1, "Freight": 48.2000, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10775, "CustomerID": "THECR", "EmployeeID": 7, "OrderDate": "1997-12-12 00:00:00", "RequiredDate": "1998-01-09 00:00:00", "ShippedDate": "1997-12-26 00:00:00", "ShipVia": 1, "Freight": 20.2500, "ShipName": "The Cracker Box", "ShipAddress": "55 Grizzly Peak Rd.", "ShipCity": "Butte", "ShipRegion": "MT", "ShipPostalCode": 59801, "ShipCountry": "USA" }, { "OrderID": 10776, "CustomerID": "ERNSH", "EmployeeID": 1, "OrderDate": "1997-12-15 00:00:00", "RequiredDate": "1998-01-12 00:00:00", "ShippedDate": "1997-12-18 00:00:00", "ShipVia": 3, "Freight": 351.5300, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10777, "CustomerID": "GOURL", "EmployeeID": 7, "OrderDate": "1997-12-15 00:00:00", "RequiredDate": "1997-12-29 00:00:00", "ShippedDate": "1998-01-21 00:00:00", "ShipVia": 2, "Freight": 3.0100, "ShipName": "Gourmet Lanchonetes", "ShipAddress": "Av. Brasil, 442", "ShipCity": "Campinas", "ShipRegion": "SP", "ShipPostalCode": "04876-786", "ShipCountry": "Brazil" }, { "OrderID": 10778, "CustomerID": "BERGS", "EmployeeID": 3, "OrderDate": "1997-12-16 00:00:00", "RequiredDate": "1998-01-13 00:00:00", "ShippedDate": "1997-12-24 00:00:00", "ShipVia": 1, "Freight": 6.7900, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10779, "CustomerID": "MORGK", "EmployeeID": 3, "OrderDate": "1997-12-16 00:00:00", "RequiredDate": "1998-01-13 00:00:00", "ShippedDate": "1998-01-14 00:00:00", "ShipVia": 2, "Freight": 58.1300, "ShipName": "Morgenstern Gesundkost", "ShipAddress": "Heerstr. 22", "ShipCity": "Leipzig", "ShipRegion": null, "ShipPostalCode": 4179, "ShipCountry": "Germany" }, { "OrderID": 10780, "CustomerID": "LILAS", "EmployeeID": 2, "OrderDate": "1997-12-16 00:00:00", "RequiredDate": "1997-12-30 00:00:00", "ShippedDate": "1997-12-25 00:00:00", "ShipVia": 1, "Freight": 42.1300, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10781, "CustomerID": "WARTH", "EmployeeID": 2, "OrderDate": "1997-12-17 00:00:00", "RequiredDate": "1998-01-14 00:00:00", "ShippedDate": "1997-12-19 00:00:00", "ShipVia": 3, "Freight": 73.1600, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 10782, "CustomerID": "CACTU", "EmployeeID": 9, "OrderDate": "1997-12-17 00:00:00", "RequiredDate": "1998-01-14 00:00:00", "ShippedDate": "1997-12-22 00:00:00", "ShipVia": 3, "Freight": 1.1000, "ShipName": "Cactus Comidas para llevar", "ShipAddress": "Cerrito 333", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10783, "CustomerID": "HANAR", "EmployeeID": 4, "OrderDate": "1997-12-18 00:00:00", "RequiredDate": "1998-01-15 00:00:00", "ShippedDate": "1997-12-19 00:00:00", "ShipVia": 2, "Freight": 124.9800, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10784, "CustomerID": "MAGAA", "EmployeeID": 4, "OrderDate": "1997-12-18 00:00:00", "RequiredDate": "1998-01-15 00:00:00", "ShippedDate": "1997-12-22 00:00:00", "ShipVia": 3, "Freight": 70.0900, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10785, "CustomerID": "GROSR", "EmployeeID": 1, "OrderDate": "1997-12-18 00:00:00", "RequiredDate": "1998-01-15 00:00:00", "ShippedDate": "1997-12-24 00:00:00", "ShipVia": 3, "Freight": 1.5100, "ShipName": "GROSELLA-Restaurante", "ShipAddress": "5 Ave. Los Palos Grandes", "ShipCity": "Caracas", "ShipRegion": "DF", "ShipPostalCode": 1081, "ShipCountry": "Venezuela" }, { "OrderID": 10786, "CustomerID": "QUEEN", "EmployeeID": 8, "OrderDate": "1997-12-19 00:00:00", "RequiredDate": "1998-01-16 00:00:00", "ShippedDate": "1997-12-23 00:00:00", "ShipVia": 1, "Freight": 110.8700, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10787, "CustomerID": "LAMAI", "EmployeeID": 2, "OrderDate": "1997-12-19 00:00:00", "RequiredDate": "1998-01-02 00:00:00", "ShippedDate": "1997-12-26 00:00:00", "ShipVia": 1, "Freight": 249.9300, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10788, "CustomerID": "QUICK", "EmployeeID": 1, "OrderDate": "1997-12-22 00:00:00", "RequiredDate": "1998-01-19 00:00:00", "ShippedDate": "1998-01-19 00:00:00", "ShipVia": 2, "Freight": 42.7000, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10789, "CustomerID": "FOLIG", "EmployeeID": 1, "OrderDate": "1997-12-22 00:00:00", "RequiredDate": "1998-01-19 00:00:00", "ShippedDate": "1997-12-31 00:00:00", "ShipVia": 2, "Freight": 100.6000, "ShipName": "Folies gourmandes", "ShipAddress": "184, chausse de Tournai", "ShipCity": "Lille", "ShipRegion": null, "ShipPostalCode": 59000, "ShipCountry": "France" }, { "OrderID": 10790, "CustomerID": "GOURL", "EmployeeID": 6, "OrderDate": "1997-12-22 00:00:00", "RequiredDate": "1998-01-19 00:00:00", "ShippedDate": "1997-12-26 00:00:00", "ShipVia": 1, "Freight": 28.2300, "ShipName": "Gourmet Lanchonetes", "ShipAddress": "Av. Brasil, 442", "ShipCity": "Campinas", "ShipRegion": "SP", "ShipPostalCode": "04876-786", "ShipCountry": "Brazil" }, { "OrderID": 10791, "CustomerID": "FRANK", "EmployeeID": 6, "OrderDate": "1997-12-23 00:00:00", "RequiredDate": "1998-01-20 00:00:00", "ShippedDate": "1998-01-01 00:00:00", "ShipVia": 2, "Freight": 16.8500, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10792, "CustomerID": "WOLZA", "EmployeeID": 1, "OrderDate": "1997-12-23 00:00:00", "RequiredDate": "1998-01-20 00:00:00", "ShippedDate": "1997-12-31 00:00:00", "ShipVia": 3, "Freight": 23.7900, "ShipName": "Wolski Zajazd", "ShipAddress": "ul. Filtrowa 68", "ShipCity": "Warszawa", "ShipRegion": null, "ShipPostalCode": "01-012", "ShipCountry": "Poland" }, { "OrderID": 10793, "CustomerID": "AROUT", "EmployeeID": 3, "OrderDate": "1997-12-24 00:00:00", "RequiredDate": "1998-01-21 00:00:00", "ShippedDate": "1998-01-08 00:00:00", "ShipVia": 3, "Freight": 4.5200, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10794, "CustomerID": "QUEDE", "EmployeeID": 6, "OrderDate": "1997-12-24 00:00:00", "RequiredDate": "1998-01-21 00:00:00", "ShippedDate": "1998-01-02 00:00:00", "ShipVia": 1, "Freight": 21.4900, "ShipName": "Que Delcia", "ShipAddress": "Rua da Panificadora, 12", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-673", "ShipCountry": "Brazil" }, { "OrderID": 10795, "CustomerID": "ERNSH", "EmployeeID": 8, "OrderDate": "1997-12-24 00:00:00", "RequiredDate": "1998-01-21 00:00:00", "ShippedDate": "1998-01-20 00:00:00", "ShipVia": 2, "Freight": 126.6600, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10796, "CustomerID": "HILAA", "EmployeeID": 3, "OrderDate": "1997-12-25 00:00:00", "RequiredDate": "1998-01-22 00:00:00", "ShippedDate": "1998-01-14 00:00:00", "ShipVia": 1, "Freight": 26.5200, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10797, "CustomerID": "DRACD", "EmployeeID": 7, "OrderDate": "1997-12-25 00:00:00", "RequiredDate": "1998-01-22 00:00:00", "ShippedDate": "1998-01-05 00:00:00", "ShipVia": 2, "Freight": 33.3500, "ShipName": "Drachenblut Delikatessen", "ShipAddress": "Walserweg 21", "ShipCity": "Aachen", "ShipRegion": null, "ShipPostalCode": 52066, "ShipCountry": "Germany" }, { "OrderID": 10798, "CustomerID": "ISLAT", "EmployeeID": 2, "OrderDate": "1997-12-26 00:00:00", "RequiredDate": "1998-01-23 00:00:00", "ShippedDate": "1998-01-05 00:00:00", "ShipVia": 1, "Freight": 2.3300, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10799, "CustomerID": "KOENE", "EmployeeID": 9, "OrderDate": "1997-12-26 00:00:00", "RequiredDate": "1998-02-06 00:00:00", "ShippedDate": "1998-01-05 00:00:00", "ShipVia": 3, "Freight": 30.7600, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10800, "CustomerID": "SEVES", "EmployeeID": 1, "OrderDate": "1997-12-26 00:00:00", "RequiredDate": "1998-01-23 00:00:00", "ShippedDate": "1998-01-05 00:00:00", "ShipVia": 3, "Freight": 137.4400, "ShipName": "Seven Seas Imports", "ShipAddress": "90 Wadhurst Rd.", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "OX15 4NB", "ShipCountry": "UK" }, { "OrderID": 10801, "CustomerID": "BOLID", "EmployeeID": 4, "OrderDate": "1997-12-29 00:00:00", "RequiredDate": "1998-01-26 00:00:00", "ShippedDate": "1997-12-31 00:00:00", "ShipVia": 2, "Freight": 97.0900, "ShipName": "Blido Comidas preparadas", "ShipAddress": "C/ Araquil, 67", "ShipCity": "Madrid", "ShipRegion": null, "ShipPostalCode": 28023, "ShipCountry": "Spain" }, { "OrderID": 10802, "CustomerID": "SIMOB", "EmployeeID": 4, "OrderDate": "1997-12-29 00:00:00", "RequiredDate": "1998-01-26 00:00:00", "ShippedDate": "1998-01-02 00:00:00", "ShipVia": 2, "Freight": 257.2600, "ShipName": "Simons bistro", "ShipAddress": "Vinbltet 34", "ShipCity": "Kobenhavn", "ShipRegion": null, "ShipPostalCode": 1734, "ShipCountry": "Denmark" }, { "OrderID": 10803, "CustomerID": "WELLI", "EmployeeID": 4, "OrderDate": "1997-12-30 00:00:00", "RequiredDate": "1998-01-27 00:00:00", "ShippedDate": "1998-01-06 00:00:00", "ShipVia": 1, "Freight": 55.2300, "ShipName": "Wellington Importadora", "ShipAddress": "Rua do Mercado, 12", "ShipCity": "Resende", "ShipRegion": "SP", "ShipPostalCode": "08737-363", "ShipCountry": "Brazil" }, { "OrderID": 10804, "CustomerID": "SEVES", "EmployeeID": 6, "OrderDate": "1997-12-30 00:00:00", "RequiredDate": "1998-01-27 00:00:00", "ShippedDate": "1998-01-07 00:00:00", "ShipVia": 2, "Freight": 27.3300, "ShipName": "Seven Seas Imports", "ShipAddress": "90 Wadhurst Rd.", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "OX15 4NB", "ShipCountry": "UK" }, { "OrderID": 10805, "CustomerID": "THEBI", "EmployeeID": 2, "OrderDate": "1997-12-30 00:00:00", "RequiredDate": "1998-01-27 00:00:00", "ShippedDate": "1998-01-09 00:00:00", "ShipVia": 3, "Freight": 237.3400, "ShipName": "The Big Cheese", "ShipAddress": "89 Jefferson Way Suite 2", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97201, "ShipCountry": "USA" }, { "OrderID": 10806, "CustomerID": "VICTE", "EmployeeID": 3, "OrderDate": "1997-12-31 00:00:00", "RequiredDate": "1998-01-28 00:00:00", "ShippedDate": "1998-01-05 00:00:00", "ShipVia": 2, "Freight": 22.1100, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10807, "CustomerID": "FRANS", "EmployeeID": 4, "OrderDate": "1997-12-31 00:00:00", "RequiredDate": "1998-01-28 00:00:00", "ShippedDate": "1998-01-30 00:00:00", "ShipVia": 1, "Freight": 1.3600, "ShipName": "Franchi S.p.A.", "ShipAddress": "Via Monte Bianco 34", "ShipCity": "Torino", "ShipRegion": null, "ShipPostalCode": 10100, "ShipCountry": "Italy" }, { "OrderID": 10808, "CustomerID": "OLDWO", "EmployeeID": 2, "OrderDate": "1998-01-01 00:00:00", "RequiredDate": "1998-01-29 00:00:00", "ShippedDate": "1998-01-09 00:00:00", "ShipVia": 3, "Freight": 45.5300, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 10809, "CustomerID": "WELLI", "EmployeeID": 7, "OrderDate": "1998-01-01 00:00:00", "RequiredDate": "1998-01-29 00:00:00", "ShippedDate": "1998-01-07 00:00:00", "ShipVia": 1, "Freight": 4.8700, "ShipName": "Wellington Importadora", "ShipAddress": "Rua do Mercado, 12", "ShipCity": "Resende", "ShipRegion": "SP", "ShipPostalCode": "08737-363", "ShipCountry": "Brazil" }, { "OrderID": 10810, "CustomerID": "LAUGB", "EmployeeID": 2, "OrderDate": "1998-01-01 00:00:00", "RequiredDate": "1998-01-29 00:00:00", "ShippedDate": "1998-01-07 00:00:00", "ShipVia": 3, "Freight": 4.3300, "ShipName": "Laughing Bacchus Wine Cellars", "ShipAddress": "2319 Elm St.", "ShipCity": "Vancouver", "ShipRegion": "BC", "ShipPostalCode": "V3F 2K1", "ShipCountry": "Canada" }, { "OrderID": 10811, "CustomerID": "LINOD", "EmployeeID": 8, "OrderDate": "1998-01-02 00:00:00", "RequiredDate": "1998-01-30 00:00:00", "ShippedDate": "1998-01-08 00:00:00", "ShipVia": 1, "Freight": 31.2200, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10812, "CustomerID": "REGGC", "EmployeeID": 5, "OrderDate": "1998-01-02 00:00:00", "RequiredDate": "1998-01-30 00:00:00", "ShippedDate": "1998-01-12 00:00:00", "ShipVia": 1, "Freight": 59.7800, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10813, "CustomerID": "RICAR", "EmployeeID": 1, "OrderDate": "1998-01-05 00:00:00", "RequiredDate": "1998-02-02 00:00:00", "ShippedDate": "1998-01-09 00:00:00", "ShipVia": 1, "Freight": 47.3800, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10814, "CustomerID": "VICTE", "EmployeeID": 3, "OrderDate": "1998-01-05 00:00:00", "RequiredDate": "1998-02-02 00:00:00", "ShippedDate": "1998-01-14 00:00:00", "ShipVia": 3, "Freight": 130.9400, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10815, "CustomerID": "SAVEA", "EmployeeID": 2, "OrderDate": "1998-01-05 00:00:00", "RequiredDate": "1998-02-02 00:00:00", "ShippedDate": "1998-01-14 00:00:00", "ShipVia": 3, "Freight": 14.6200, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10816, "CustomerID": "GREAL", "EmployeeID": 4, "OrderDate": "1998-01-06 00:00:00", "RequiredDate": "1998-02-03 00:00:00", "ShippedDate": "1998-02-04 00:00:00", "ShipVia": 2, "Freight": 719.7800, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 10817, "CustomerID": "KOENE", "EmployeeID": 3, "OrderDate": "1998-01-06 00:00:00", "RequiredDate": "1998-01-20 00:00:00", "ShippedDate": "1998-01-13 00:00:00", "ShipVia": 2, "Freight": 306.0700, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10818, "CustomerID": "MAGAA", "EmployeeID": 7, "OrderDate": "1998-01-07 00:00:00", "RequiredDate": "1998-02-04 00:00:00", "ShippedDate": "1998-01-12 00:00:00", "ShipVia": 3, "Freight": 65.4800, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10819, "CustomerID": "CACTU", "EmployeeID": 2, "OrderDate": "1998-01-07 00:00:00", "RequiredDate": "1998-02-04 00:00:00", "ShippedDate": "1998-01-16 00:00:00", "ShipVia": 3, "Freight": 19.7600, "ShipName": "Cactus Comidas para llevar", "ShipAddress": "Cerrito 333", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10820, "CustomerID": "RATTC", "EmployeeID": 3, "OrderDate": "1998-01-07 00:00:00", "RequiredDate": "1998-02-04 00:00:00", "ShippedDate": "1998-01-13 00:00:00", "ShipVia": 2, "Freight": 37.5200, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10821, "CustomerID": "SPLIR", "EmployeeID": 1, "OrderDate": "1998-01-08 00:00:00", "RequiredDate": "1998-02-05 00:00:00", "ShippedDate": "1998-01-15 00:00:00", "ShipVia": 1, "Freight": 36.6800, "ShipName": "Split Rail Beer & Ale", "ShipAddress": "P.O. Box 555", "ShipCity": "Lander", "ShipRegion": "WY", "ShipPostalCode": 82520, "ShipCountry": "USA" }, { "OrderID": 10822, "CustomerID": "TRAIH", "EmployeeID": 6, "OrderDate": "1998-01-08 00:00:00", "RequiredDate": "1998-02-05 00:00:00", "ShippedDate": "1998-01-16 00:00:00", "ShipVia": 3, "Freight": 7.0000, "ShipName": "Trail-s Head Gourmet Provisioners", "ShipAddress": "722 DaVinci Blvd.", "ShipCity": "Kirkland", "ShipRegion": "WA", "ShipPostalCode": 98034, "ShipCountry": "USA" }, { "OrderID": 10823, "CustomerID": "LILAS", "EmployeeID": 5, "OrderDate": "1998-01-09 00:00:00", "RequiredDate": "1998-02-06 00:00:00", "ShippedDate": "1998-01-13 00:00:00", "ShipVia": 2, "Freight": 163.9700, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10824, "CustomerID": "FOLKO", "EmployeeID": 8, "OrderDate": "1998-01-09 00:00:00", "RequiredDate": "1998-02-06 00:00:00", "ShippedDate": "1998-01-30 00:00:00", "ShipVia": 1, "Freight": 1.2300, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10825, "CustomerID": "DRACD", "EmployeeID": 1, "OrderDate": "1998-01-09 00:00:00", "RequiredDate": "1998-02-06 00:00:00", "ShippedDate": "1998-01-14 00:00:00", "ShipVia": 1, "Freight": 79.2500, "ShipName": "Drachenblut Delikatessen", "ShipAddress": "Walserweg 21", "ShipCity": "Aachen", "ShipRegion": null, "ShipPostalCode": 52066, "ShipCountry": "Germany" }, { "OrderID": 10826, "CustomerID": "BLONP", "EmployeeID": 6, "OrderDate": "1998-01-12 00:00:00", "RequiredDate": "1998-02-09 00:00:00", "ShippedDate": "1998-02-06 00:00:00", "ShipVia": 1, "Freight": 7.0900, "ShipName": "Blondel pre et fils", "ShipAddress": "24, place Klber", "ShipCity": "Strasbourg", "ShipRegion": null, "ShipPostalCode": 67000, "ShipCountry": "France" }, { "OrderID": 10827, "CustomerID": "BONAP", "EmployeeID": 1, "OrderDate": "1998-01-12 00:00:00", "RequiredDate": "1998-01-26 00:00:00", "ShippedDate": "1998-02-06 00:00:00", "ShipVia": 2, "Freight": 63.5400, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10828, "CustomerID": "RANCH", "EmployeeID": 9, "OrderDate": "1998-01-13 00:00:00", "RequiredDate": "1998-01-27 00:00:00", "ShippedDate": "1998-02-04 00:00:00", "ShipVia": 1, "Freight": 90.8500, "ShipName": "Rancho grande", "ShipAddress": "Av. del Libertador 900", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10829, "CustomerID": "ISLAT", "EmployeeID": 9, "OrderDate": "1998-01-13 00:00:00", "RequiredDate": "1998-02-10 00:00:00", "ShippedDate": "1998-01-23 00:00:00", "ShipVia": 1, "Freight": 154.7200, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10830, "CustomerID": "TRADH", "EmployeeID": 4, "OrderDate": "1998-01-13 00:00:00", "RequiredDate": "1998-02-24 00:00:00", "ShippedDate": "1998-01-21 00:00:00", "ShipVia": 2, "Freight": 81.8300, "ShipName": "Tradiao Hipermercados", "ShipAddress": "Av. Ins de Castro, 414", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05634-030", "ShipCountry": "Brazil" }, { "OrderID": 10831, "CustomerID": "SANTG", "EmployeeID": 3, "OrderDate": "1998-01-14 00:00:00", "RequiredDate": "1998-02-11 00:00:00", "ShippedDate": "1998-01-23 00:00:00", "ShipVia": 2, "Freight": 72.1900, "ShipName": "Sant Gourmet", "ShipAddress": "Erling Skakkes gate 78", "ShipCity": "Stavern", "ShipRegion": null, "ShipPostalCode": 4110, "ShipCountry": "Norway" }, { "OrderID": 10832, "CustomerID": "LAMAI", "EmployeeID": 2, "OrderDate": "1998-01-14 00:00:00", "RequiredDate": "1998-02-11 00:00:00", "ShippedDate": "1998-01-19 00:00:00", "ShipVia": 2, "Freight": 43.2600, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10833, "CustomerID": "OTTIK", "EmployeeID": 6, "OrderDate": "1998-01-15 00:00:00", "RequiredDate": "1998-02-12 00:00:00", "ShippedDate": "1998-01-23 00:00:00", "ShipVia": 2, "Freight": 71.4900, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 10834, "CustomerID": "TRADH", "EmployeeID": 1, "OrderDate": "1998-01-15 00:00:00", "RequiredDate": "1998-02-12 00:00:00", "ShippedDate": "1998-01-19 00:00:00", "ShipVia": 3, "Freight": 29.7800, "ShipName": "Tradiao Hipermercados", "ShipAddress": "Av. Ins de Castro, 414", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05634-030", "ShipCountry": "Brazil" }, { "OrderID": 10835, "CustomerID": "ALFKI", "EmployeeID": 1, "OrderDate": "1998-01-15 00:00:00", "RequiredDate": "1998-02-12 00:00:00", "ShippedDate": "1998-01-21 00:00:00", "ShipVia": 3, "Freight": 69.5300, "ShipName": "Alfred-s Futterkiste", "ShipAddress": "Obere Str. 57", "ShipCity": "Berlin", "ShipRegion": null, "ShipPostalCode": 12209, "ShipCountry": "Germany" }, { "OrderID": 10836, "CustomerID": "ERNSH", "EmployeeID": 7, "OrderDate": "1998-01-16 00:00:00", "RequiredDate": "1998-02-13 00:00:00", "ShippedDate": "1998-01-21 00:00:00", "ShipVia": 1, "Freight": 411.8800, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10837, "CustomerID": "BERGS", "EmployeeID": 9, "OrderDate": "1998-01-16 00:00:00", "RequiredDate": "1998-02-13 00:00:00", "ShippedDate": "1998-01-23 00:00:00", "ShipVia": 3, "Freight": 13.3200, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10838, "CustomerID": "LINOD", "EmployeeID": 3, "OrderDate": "1998-01-19 00:00:00", "RequiredDate": "1998-02-16 00:00:00", "ShippedDate": "1998-01-23 00:00:00", "ShipVia": 3, "Freight": 59.2800, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10839, "CustomerID": "TRADH", "EmployeeID": 3, "OrderDate": "1998-01-19 00:00:00", "RequiredDate": "1998-02-16 00:00:00", "ShippedDate": "1998-01-22 00:00:00", "ShipVia": 3, "Freight": 35.4300, "ShipName": "Tradiao Hipermercados", "ShipAddress": "Av. Ins de Castro, 414", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05634-030", "ShipCountry": "Brazil" }, { "OrderID": 10840, "CustomerID": "LINOD", "EmployeeID": 4, "OrderDate": "1998-01-19 00:00:00", "RequiredDate": "1998-03-02 00:00:00", "ShippedDate": "1998-02-16 00:00:00", "ShipVia": 2, "Freight": 2.7100, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10841, "CustomerID": "SUPRD", "EmployeeID": 5, "OrderDate": "1998-01-20 00:00:00", "RequiredDate": "1998-02-17 00:00:00", "ShippedDate": "1998-01-29 00:00:00", "ShipVia": 2, "Freight": 424.3000, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10842, "CustomerID": "TORTU", "EmployeeID": 1, "OrderDate": "1998-01-20 00:00:00", "RequiredDate": "1998-02-17 00:00:00", "ShippedDate": "1998-01-29 00:00:00", "ShipVia": 3, "Freight": 54.4200, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10843, "CustomerID": "VICTE", "EmployeeID": 4, "OrderDate": "1998-01-21 00:00:00", "RequiredDate": "1998-02-18 00:00:00", "ShippedDate": "1998-01-26 00:00:00", "ShipVia": 2, "Freight": 9.2600, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10844, "CustomerID": "PICCO", "EmployeeID": 8, "OrderDate": "1998-01-21 00:00:00", "RequiredDate": "1998-02-18 00:00:00", "ShippedDate": "1998-01-26 00:00:00", "ShipVia": 2, "Freight": 25.2200, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 10845, "CustomerID": "QUICK", "EmployeeID": 8, "OrderDate": "1998-01-21 00:00:00", "RequiredDate": "1998-02-04 00:00:00", "ShippedDate": "1998-01-30 00:00:00", "ShipVia": 1, "Freight": 212.9800, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10846, "CustomerID": "SUPRD", "EmployeeID": 2, "OrderDate": "1998-01-22 00:00:00", "RequiredDate": "1998-03-05 00:00:00", "ShippedDate": "1998-01-23 00:00:00", "ShipVia": 3, "Freight": 56.4600, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10847, "CustomerID": "SAVEA", "EmployeeID": 4, "OrderDate": "1998-01-22 00:00:00", "RequiredDate": "1998-02-05 00:00:00", "ShippedDate": "1998-02-10 00:00:00", "ShipVia": 3, "Freight": 487.5700, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10848, "CustomerID": "CONSH", "EmployeeID": 7, "OrderDate": "1998-01-23 00:00:00", "RequiredDate": "1998-02-20 00:00:00", "ShippedDate": "1998-01-29 00:00:00", "ShipVia": 2, "Freight": 38.2400, "ShipName": "Consolidated Holdings", "ShipAddress": "Berkeley Gardens 12 Brewery", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX1 6LT", "ShipCountry": "UK" }, { "OrderID": 10849, "CustomerID": "KOENE", "EmployeeID": 9, "OrderDate": "1998-01-23 00:00:00", "RequiredDate": "1998-02-20 00:00:00", "ShippedDate": "1998-01-30 00:00:00", "ShipVia": 2, "Freight": 0.5600, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10850, "CustomerID": "VICTE", "EmployeeID": 1, "OrderDate": "1998-01-23 00:00:00", "RequiredDate": "1998-03-06 00:00:00", "ShippedDate": "1998-01-30 00:00:00", "ShipVia": 1, "Freight": 49.1900, "ShipName": "Victuailles en stock", "ShipAddress": "2, rue du Commerce", "ShipCity": "Lyon", "ShipRegion": null, "ShipPostalCode": 69004, "ShipCountry": "France" }, { "OrderID": 10851, "CustomerID": "RICAR", "EmployeeID": 5, "OrderDate": "1998-01-26 00:00:00", "RequiredDate": "1998-02-23 00:00:00", "ShippedDate": "1998-02-02 00:00:00", "ShipVia": 1, "Freight": 160.5500, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10852, "CustomerID": "RATTC", "EmployeeID": 8, "OrderDate": "1998-01-26 00:00:00", "RequiredDate": "1998-02-09 00:00:00", "ShippedDate": "1998-01-30 00:00:00", "ShipVia": 1, "Freight": 174.0500, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10853, "CustomerID": "BLAUS", "EmployeeID": 9, "OrderDate": "1998-01-27 00:00:00", "RequiredDate": "1998-02-24 00:00:00", "ShippedDate": "1998-02-03 00:00:00", "ShipVia": 2, "Freight": 53.8300, "ShipName": "Blauer See Delikatessen", "ShipAddress": "Forsterstr. 57", "ShipCity": "Mannheim", "ShipRegion": null, "ShipPostalCode": 68306, "ShipCountry": "Germany" }, { "OrderID": 10854, "CustomerID": "ERNSH", "EmployeeID": 3, "OrderDate": "1998-01-27 00:00:00", "RequiredDate": "1998-02-24 00:00:00", "ShippedDate": "1998-02-05 00:00:00", "ShipVia": 2, "Freight": 100.2200, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10855, "CustomerID": "OLDWO", "EmployeeID": 3, "OrderDate": "1998-01-27 00:00:00", "RequiredDate": "1998-02-24 00:00:00", "ShippedDate": "1998-02-04 00:00:00", "ShipVia": 1, "Freight": 170.9700, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 10856, "CustomerID": "ANTON", "EmployeeID": 3, "OrderDate": "1998-01-28 00:00:00", "RequiredDate": "1998-02-25 00:00:00", "ShippedDate": "1998-02-10 00:00:00", "ShipVia": 2, "Freight": 58.4300, "ShipName": "Antonio Moreno Taquera", "ShipAddress": "Mataderos 2312", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5023, "ShipCountry": "Mexico" }, { "OrderID": 10857, "CustomerID": "BERGS", "EmployeeID": 8, "OrderDate": "1998-01-28 00:00:00", "RequiredDate": "1998-02-25 00:00:00", "ShippedDate": "1998-02-06 00:00:00", "ShipVia": 2, "Freight": 188.8500, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10858, "CustomerID": "LACOR", "EmployeeID": 2, "OrderDate": "1998-01-29 00:00:00", "RequiredDate": "1998-02-26 00:00:00", "ShippedDate": "1998-02-03 00:00:00", "ShipVia": 1, "Freight": 52.5100, "ShipName": "La corne d-abondance", "ShipAddress": "67, avenue de l-Europe", "ShipCity": "Versailles", "ShipRegion": null, "ShipPostalCode": 78000, "ShipCountry": "France" }, { "OrderID": 10859, "CustomerID": "FRANK", "EmployeeID": 1, "OrderDate": "1998-01-29 00:00:00", "RequiredDate": "1998-02-26 00:00:00", "ShippedDate": "1998-02-02 00:00:00", "ShipVia": 2, "Freight": 76.1000, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10860, "CustomerID": "FRANR", "EmployeeID": 3, "OrderDate": "1998-01-29 00:00:00", "RequiredDate": "1998-02-26 00:00:00", "ShippedDate": "1998-02-04 00:00:00", "ShipVia": 3, "Freight": 19.2600, "ShipName": "France restauration", "ShipAddress": "54, rue Royale", "ShipCity": "Nantes", "ShipRegion": null, "ShipPostalCode": 44000, "ShipCountry": "France" }, { "OrderID": 10861, "CustomerID": "WHITC", "EmployeeID": 4, "OrderDate": "1998-01-30 00:00:00", "RequiredDate": "1998-02-27 00:00:00", "ShippedDate": "1998-02-17 00:00:00", "ShipVia": 2, "Freight": 14.9300, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10862, "CustomerID": "LEHMS", "EmployeeID": 8, "OrderDate": "1998-01-30 00:00:00", "RequiredDate": "1998-03-13 00:00:00", "ShippedDate": "1998-02-02 00:00:00", "ShipVia": 2, "Freight": 53.2300, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10863, "CustomerID": "HILAA", "EmployeeID": 4, "OrderDate": "1998-02-02 00:00:00", "RequiredDate": "1998-03-02 00:00:00", "ShippedDate": "1998-02-17 00:00:00", "ShipVia": 2, "Freight": 30.2600, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10864, "CustomerID": "AROUT", "EmployeeID": 4, "OrderDate": "1998-02-02 00:00:00", "RequiredDate": "1998-03-02 00:00:00", "ShippedDate": "1998-02-09 00:00:00", "ShipVia": 2, "Freight": 3.0400, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10865, "CustomerID": "QUICK", "EmployeeID": 2, "OrderDate": "1998-02-02 00:00:00", "RequiredDate": "1998-02-16 00:00:00", "ShippedDate": "1998-02-12 00:00:00", "ShipVia": 1, "Freight": 348.1400, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10866, "CustomerID": "BERGS", "EmployeeID": 5, "OrderDate": "1998-02-03 00:00:00", "RequiredDate": "1998-03-03 00:00:00", "ShippedDate": "1998-02-12 00:00:00", "ShipVia": 1, "Freight": 109.1100, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10867, "CustomerID": "LONEP", "EmployeeID": 6, "OrderDate": "1998-02-03 00:00:00", "RequiredDate": "1998-03-17 00:00:00", "ShippedDate": "1998-02-11 00:00:00", "ShipVia": 1, "Freight": 1.9300, "ShipName": "Lonesome Pine Restaurant", "ShipAddress": "89 Chiaroscuro Rd.", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97219, "ShipCountry": "USA" }, { "OrderID": 10868, "CustomerID": "QUEEN", "EmployeeID": 7, "OrderDate": "1998-02-04 00:00:00", "RequiredDate": "1998-03-04 00:00:00", "ShippedDate": "1998-02-23 00:00:00", "ShipVia": 2, "Freight": 191.2700, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10869, "CustomerID": "SEVES", "EmployeeID": 5, "OrderDate": "1998-02-04 00:00:00", "RequiredDate": "1998-03-04 00:00:00", "ShippedDate": "1998-02-09 00:00:00", "ShipVia": 1, "Freight": 143.2800, "ShipName": "Seven Seas Imports", "ShipAddress": "90 Wadhurst Rd.", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "OX15 4NB", "ShipCountry": "UK" }, { "OrderID": 10870, "CustomerID": "WOLZA", "EmployeeID": 5, "OrderDate": "1998-02-04 00:00:00", "RequiredDate": "1998-03-04 00:00:00", "ShippedDate": "1998-02-13 00:00:00", "ShipVia": 3, "Freight": 12.0400, "ShipName": "Wolski Zajazd", "ShipAddress": "ul. Filtrowa 68", "ShipCity": "Warszawa", "ShipRegion": null, "ShipPostalCode": "01-012", "ShipCountry": "Poland" }, { "OrderID": 10871, "CustomerID": "BONAP", "EmployeeID": 9, "OrderDate": "1998-02-05 00:00:00", "RequiredDate": "1998-03-05 00:00:00", "ShippedDate": "1998-02-10 00:00:00", "ShipVia": 2, "Freight": 112.2700, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10872, "CustomerID": "GODOS", "EmployeeID": 5, "OrderDate": "1998-02-05 00:00:00", "RequiredDate": "1998-03-05 00:00:00", "ShippedDate": "1998-02-09 00:00:00", "ShipVia": 2, "Freight": 175.3200, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 10873, "CustomerID": "WILMK", "EmployeeID": 4, "OrderDate": "1998-02-06 00:00:00", "RequiredDate": "1998-03-06 00:00:00", "ShippedDate": "1998-02-09 00:00:00", "ShipVia": 1, "Freight": 0.8200, "ShipName": "Wilman Kala", "ShipAddress": "Keskuskatu 45", "ShipCity": "Helsinki", "ShipRegion": null, "ShipPostalCode": 21240, "ShipCountry": "Finland" }, { "OrderID": 10874, "CustomerID": "GODOS", "EmployeeID": 5, "OrderDate": "1998-02-06 00:00:00", "RequiredDate": "1998-03-06 00:00:00", "ShippedDate": "1998-02-11 00:00:00", "ShipVia": 2, "Freight": 19.5800, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 10875, "CustomerID": "BERGS", "EmployeeID": 4, "OrderDate": "1998-02-06 00:00:00", "RequiredDate": "1998-03-06 00:00:00", "ShippedDate": "1998-03-03 00:00:00", "ShipVia": 2, "Freight": 32.3700, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10876, "CustomerID": "BONAP", "EmployeeID": 7, "OrderDate": "1998-02-09 00:00:00", "RequiredDate": "1998-03-09 00:00:00", "ShippedDate": "1998-02-12 00:00:00", "ShipVia": 3, "Freight": 60.4200, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10877, "CustomerID": "RICAR", "EmployeeID": 1, "OrderDate": "1998-02-09 00:00:00", "RequiredDate": "1998-03-09 00:00:00", "ShippedDate": "1998-02-19 00:00:00", "ShipVia": 1, "Freight": 38.0600, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 10878, "CustomerID": "QUICK", "EmployeeID": 4, "OrderDate": "1998-02-10 00:00:00", "RequiredDate": "1998-03-10 00:00:00", "ShippedDate": "1998-02-12 00:00:00", "ShipVia": 1, "Freight": 46.6900, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10879, "CustomerID": "WILMK", "EmployeeID": 3, "OrderDate": "1998-02-10 00:00:00", "RequiredDate": "1998-03-10 00:00:00", "ShippedDate": "1998-02-12 00:00:00", "ShipVia": 3, "Freight": 8.5000, "ShipName": "Wilman Kala", "ShipAddress": "Keskuskatu 45", "ShipCity": "Helsinki", "ShipRegion": null, "ShipPostalCode": 21240, "ShipCountry": "Finland" }, { "OrderID": 10880, "CustomerID": "FOLKO", "EmployeeID": 7, "OrderDate": "1998-02-10 00:00:00", "RequiredDate": "1998-03-24 00:00:00", "ShippedDate": "1998-02-18 00:00:00", "ShipVia": 1, "Freight": 88.0100, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10881, "CustomerID": "CACTU", "EmployeeID": 4, "OrderDate": "1998-02-11 00:00:00", "RequiredDate": "1998-03-11 00:00:00", "ShippedDate": "1998-02-18 00:00:00", "ShipVia": 1, "Freight": 2.8400, "ShipName": "Cactus Comidas para llevar", "ShipAddress": "Cerrito 333", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10882, "CustomerID": "SAVEA", "EmployeeID": 4, "OrderDate": "1998-02-11 00:00:00", "RequiredDate": "1998-03-11 00:00:00", "ShippedDate": "1998-02-20 00:00:00", "ShipVia": 3, "Freight": 23.1000, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10883, "CustomerID": "LONEP", "EmployeeID": 8, "OrderDate": "1998-02-12 00:00:00", "RequiredDate": "1998-03-12 00:00:00", "ShippedDate": "1998-02-20 00:00:00", "ShipVia": 3, "Freight": 0.5300, "ShipName": "Lonesome Pine Restaurant", "ShipAddress": "89 Chiaroscuro Rd.", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97219, "ShipCountry": "USA" }, { "OrderID": 10884, "CustomerID": "LETSS", "EmployeeID": 4, "OrderDate": "1998-02-12 00:00:00", "RequiredDate": "1998-03-12 00:00:00", "ShippedDate": "1998-02-13 00:00:00", "ShipVia": 2, "Freight": 90.9700, "ShipName": "Let-s Stop N Shop", "ShipAddress": "87 Polk St. Suite 5", "ShipCity": "San Francisco", "ShipRegion": "CA", "ShipPostalCode": 94117, "ShipCountry": "USA" }, { "OrderID": 10885, "CustomerID": "SUPRD", "EmployeeID": 6, "OrderDate": "1998-02-12 00:00:00", "RequiredDate": "1998-03-12 00:00:00", "ShippedDate": "1998-02-18 00:00:00", "ShipVia": 3, "Freight": 5.6400, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10886, "CustomerID": "HANAR", "EmployeeID": 1, "OrderDate": "1998-02-13 00:00:00", "RequiredDate": "1998-03-13 00:00:00", "ShippedDate": "1998-03-02 00:00:00", "ShipVia": 1, "Freight": 4.9900, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10887, "CustomerID": "GALED", "EmployeeID": 8, "OrderDate": "1998-02-13 00:00:00", "RequiredDate": "1998-03-13 00:00:00", "ShippedDate": "1998-02-16 00:00:00", "ShipVia": 3, "Freight": 1.2500, "ShipName": "Galera del gastronmo", "ShipAddress": "Rambla de Catalua, 23", "ShipCity": "Barcelona", "ShipRegion": null, "ShipPostalCode": 8022, "ShipCountry": "Spain" }, { "OrderID": 10888, "CustomerID": "GODOS", "EmployeeID": 1, "OrderDate": "1998-02-16 00:00:00", "RequiredDate": "1998-03-16 00:00:00", "ShippedDate": "1998-02-23 00:00:00", "ShipVia": 2, "Freight": 51.8700, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 10889, "CustomerID": "RATTC", "EmployeeID": 9, "OrderDate": "1998-02-16 00:00:00", "RequiredDate": "1998-03-16 00:00:00", "ShippedDate": "1998-02-23 00:00:00", "ShipVia": 3, "Freight": 280.6100, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10890, "CustomerID": "DUMON", "EmployeeID": 7, "OrderDate": "1998-02-16 00:00:00", "RequiredDate": "1998-03-16 00:00:00", "ShippedDate": "1998-02-18 00:00:00", "ShipVia": 1, "Freight": 32.7600, "ShipName": "Du monde entier", "ShipAddress": "67, rue des Cinquante Otages", "ShipCity": "Nantes", "ShipRegion": null, "ShipPostalCode": 44000, "ShipCountry": "France" }, { "OrderID": 10891, "CustomerID": "LEHMS", "EmployeeID": 7, "OrderDate": "1998-02-17 00:00:00", "RequiredDate": "1998-03-17 00:00:00", "ShippedDate": "1998-02-19 00:00:00", "ShipVia": 2, "Freight": 20.3700, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10892, "CustomerID": "MAISD", "EmployeeID": 4, "OrderDate": "1998-02-17 00:00:00", "RequiredDate": "1998-03-17 00:00:00", "ShippedDate": "1998-02-19 00:00:00", "ShipVia": 2, "Freight": 120.2700, "ShipName": "Maison Dewey", "ShipAddress": "Rue Joseph-Bens 532", "ShipCity": "Bruxelles", "ShipRegion": null, "ShipPostalCode": "B-1180", "ShipCountry": "Belgium" }, { "OrderID": 10893, "CustomerID": "KOENE", "EmployeeID": 9, "OrderDate": "1998-02-18 00:00:00", "RequiredDate": "1998-03-18 00:00:00", "ShippedDate": "1998-02-20 00:00:00", "ShipVia": 2, "Freight": 77.7800, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 10894, "CustomerID": "SAVEA", "EmployeeID": 1, "OrderDate": "1998-02-18 00:00:00", "RequiredDate": "1998-03-18 00:00:00", "ShippedDate": "1998-02-20 00:00:00", "ShipVia": 1, "Freight": 116.1300, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10895, "CustomerID": "ERNSH", "EmployeeID": 3, "OrderDate": "1998-02-18 00:00:00", "RequiredDate": "1998-03-18 00:00:00", "ShippedDate": "1998-02-23 00:00:00", "ShipVia": 1, "Freight": 162.7500, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10896, "CustomerID": "MAISD", "EmployeeID": 7, "OrderDate": "1998-02-19 00:00:00", "RequiredDate": "1998-03-19 00:00:00", "ShippedDate": "1998-02-27 00:00:00", "ShipVia": 3, "Freight": 32.4500, "ShipName": "Maison Dewey", "ShipAddress": "Rue Joseph-Bens 532", "ShipCity": "Bruxelles", "ShipRegion": null, "ShipPostalCode": "B-1180", "ShipCountry": "Belgium" }, { "OrderID": 10897, "CustomerID": "HUNGO", "EmployeeID": 3, "OrderDate": "1998-02-19 00:00:00", "RequiredDate": "1998-03-19 00:00:00", "ShippedDate": "1998-02-25 00:00:00", "ShipVia": 2, "Freight": 603.5400, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10898, "CustomerID": "OCEAN", "EmployeeID": 4, "OrderDate": "1998-02-20 00:00:00", "RequiredDate": "1998-03-20 00:00:00", "ShippedDate": "1998-03-06 00:00:00", "ShipVia": 2, "Freight": 1.2700, "ShipName": "Ocano Atlntico Ltda.", "ShipAddress": "Ing. Gustavo Moncada 8585 Piso 20-A", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10899, "CustomerID": "LILAS", "EmployeeID": 5, "OrderDate": "1998-02-20 00:00:00", "RequiredDate": "1998-03-20 00:00:00", "ShippedDate": "1998-02-26 00:00:00", "ShipVia": 3, "Freight": 1.2100, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10900, "CustomerID": "WELLI", "EmployeeID": 1, "OrderDate": "1998-02-20 00:00:00", "RequiredDate": "1998-03-20 00:00:00", "ShippedDate": "1998-03-04 00:00:00", "ShipVia": 2, "Freight": 1.6600, "ShipName": "Wellington Importadora", "ShipAddress": "Rua do Mercado, 12", "ShipCity": "Resende", "ShipRegion": "SP", "ShipPostalCode": "08737-363", "ShipCountry": "Brazil" }, { "OrderID": 10901, "CustomerID": "HILAA", "EmployeeID": 4, "OrderDate": "1998-02-23 00:00:00", "RequiredDate": "1998-03-23 00:00:00", "ShippedDate": "1998-02-26 00:00:00", "ShipVia": 1, "Freight": 62.0900, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10902, "CustomerID": "FOLKO", "EmployeeID": 1, "OrderDate": "1998-02-23 00:00:00", "RequiredDate": "1998-03-23 00:00:00", "ShippedDate": "1998-03-03 00:00:00", "ShipVia": 1, "Freight": 44.1500, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10903, "CustomerID": "HANAR", "EmployeeID": 3, "OrderDate": "1998-02-24 00:00:00", "RequiredDate": "1998-03-24 00:00:00", "ShippedDate": "1998-03-04 00:00:00", "ShipVia": 3, "Freight": 36.7100, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10904, "CustomerID": "WHITC", "EmployeeID": 3, "OrderDate": "1998-02-24 00:00:00", "RequiredDate": "1998-03-24 00:00:00", "ShippedDate": "1998-02-27 00:00:00", "ShipVia": 3, "Freight": 162.9500, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 10905, "CustomerID": "WELLI", "EmployeeID": 9, "OrderDate": "1998-02-24 00:00:00", "RequiredDate": "1998-03-24 00:00:00", "ShippedDate": "1998-03-06 00:00:00", "ShipVia": 2, "Freight": 13.7200, "ShipName": "Wellington Importadora", "ShipAddress": "Rua do Mercado, 12", "ShipCity": "Resende", "ShipRegion": "SP", "ShipPostalCode": "08737-363", "ShipCountry": "Brazil" }, { "OrderID": 10906, "CustomerID": "WOLZA", "EmployeeID": 4, "OrderDate": "1998-02-25 00:00:00", "RequiredDate": "1998-03-11 00:00:00", "ShippedDate": "1998-03-03 00:00:00", "ShipVia": 3, "Freight": 26.2900, "ShipName": "Wolski Zajazd", "ShipAddress": "ul. Filtrowa 68", "ShipCity": "Warszawa", "ShipRegion": null, "ShipPostalCode": "01-012", "ShipCountry": "Poland" }, { "OrderID": 10907, "CustomerID": "SPECD", "EmployeeID": 6, "OrderDate": "1998-02-25 00:00:00", "RequiredDate": "1998-03-25 00:00:00", "ShippedDate": "1998-02-27 00:00:00", "ShipVia": 3, "Freight": 9.1900, "ShipName": "Spcialits du monde", "ShipAddress": "25, rue Lauriston", "ShipCity": "Paris", "ShipRegion": null, "ShipPostalCode": 75016, "ShipCountry": "France" }, { "OrderID": 10908, "CustomerID": "REGGC", "EmployeeID": 4, "OrderDate": "1998-02-26 00:00:00", "RequiredDate": "1998-03-26 00:00:00", "ShippedDate": "1998-03-06 00:00:00", "ShipVia": 2, "Freight": 32.9600, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10909, "CustomerID": "SANTG", "EmployeeID": 1, "OrderDate": "1998-02-26 00:00:00", "RequiredDate": "1998-03-26 00:00:00", "ShippedDate": "1998-03-10 00:00:00", "ShipVia": 2, "Freight": 53.0500, "ShipName": "Sant Gourmet", "ShipAddress": "Erling Skakkes gate 78", "ShipCity": "Stavern", "ShipRegion": null, "ShipPostalCode": 4110, "ShipCountry": "Norway" }, { "OrderID": 10910, "CustomerID": "WILMK", "EmployeeID": 1, "OrderDate": "1998-02-26 00:00:00", "RequiredDate": "1998-03-26 00:00:00", "ShippedDate": "1998-03-04 00:00:00", "ShipVia": 3, "Freight": 38.1100, "ShipName": "Wilman Kala", "ShipAddress": "Keskuskatu 45", "ShipCity": "Helsinki", "ShipRegion": null, "ShipPostalCode": 21240, "ShipCountry": "Finland" }, { "OrderID": 10911, "CustomerID": "GODOS", "EmployeeID": 3, "OrderDate": "1998-02-26 00:00:00", "RequiredDate": "1998-03-26 00:00:00", "ShippedDate": "1998-03-05 00:00:00", "ShipVia": 1, "Freight": 38.1900, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 10912, "CustomerID": "HUNGO", "EmployeeID": 2, "OrderDate": "1998-02-26 00:00:00", "RequiredDate": "1998-03-26 00:00:00", "ShippedDate": "1998-03-18 00:00:00", "ShipVia": 2, "Freight": 580.9100, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10913, "CustomerID": "QUEEN", "EmployeeID": 4, "OrderDate": "1998-02-26 00:00:00", "RequiredDate": "1998-03-26 00:00:00", "ShippedDate": "1998-03-04 00:00:00", "ShipVia": 1, "Freight": 33.0500, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10914, "CustomerID": "QUEEN", "EmployeeID": 6, "OrderDate": "1998-02-27 00:00:00", "RequiredDate": "1998-03-27 00:00:00", "ShippedDate": "1998-03-02 00:00:00", "ShipVia": 1, "Freight": 21.1900, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10915, "CustomerID": "TORTU", "EmployeeID": 2, "OrderDate": "1998-02-27 00:00:00", "RequiredDate": "1998-03-27 00:00:00", "ShippedDate": "1998-03-02 00:00:00", "ShipVia": 2, "Freight": 3.5100, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10916, "CustomerID": "RANCH", "EmployeeID": 1, "OrderDate": "1998-02-27 00:00:00", "RequiredDate": "1998-03-27 00:00:00", "ShippedDate": "1998-03-09 00:00:00", "ShipVia": 2, "Freight": 63.7700, "ShipName": "Rancho grande", "ShipAddress": "Av. del Libertador 900", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10917, "CustomerID": "ROMEY", "EmployeeID": 4, "OrderDate": "1998-03-02 00:00:00", "RequiredDate": "1998-03-30 00:00:00", "ShippedDate": "1998-03-11 00:00:00", "ShipVia": 2, "Freight": 8.2900, "ShipName": "Romero y tomillo", "ShipAddress": "Gran Va, 1", "ShipCity": "Madrid", "ShipRegion": null, "ShipPostalCode": 28001, "ShipCountry": "Spain" }, { "OrderID": 10918, "CustomerID": "BOTTM", "EmployeeID": 3, "OrderDate": "1998-03-02 00:00:00", "RequiredDate": "1998-03-30 00:00:00", "ShippedDate": "1998-03-11 00:00:00", "ShipVia": 3, "Freight": 48.8300, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10919, "CustomerID": "LINOD", "EmployeeID": 2, "OrderDate": "1998-03-02 00:00:00", "RequiredDate": "1998-03-30 00:00:00", "ShippedDate": "1998-03-04 00:00:00", "ShipVia": 2, "Freight": 19.8000, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10920, "CustomerID": "AROUT", "EmployeeID": 4, "OrderDate": "1998-03-03 00:00:00", "RequiredDate": "1998-03-31 00:00:00", "ShippedDate": "1998-03-09 00:00:00", "ShipVia": 2, "Freight": 29.6100, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10921, "CustomerID": "VAFFE", "EmployeeID": 1, "OrderDate": "1998-03-03 00:00:00", "RequiredDate": "1998-04-14 00:00:00", "ShippedDate": "1998-03-09 00:00:00", "ShipVia": 1, "Freight": 176.4800, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10922, "CustomerID": "HANAR", "EmployeeID": 5, "OrderDate": "1998-03-03 00:00:00", "RequiredDate": "1998-03-31 00:00:00", "ShippedDate": "1998-03-05 00:00:00", "ShipVia": 3, "Freight": 62.7400, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10923, "CustomerID": "LAMAI", "EmployeeID": 7, "OrderDate": "1998-03-03 00:00:00", "RequiredDate": "1998-04-14 00:00:00", "ShippedDate": "1998-03-13 00:00:00", "ShipVia": 3, "Freight": 68.2600, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 10924, "CustomerID": "BERGS", "EmployeeID": 3, "OrderDate": "1998-03-04 00:00:00", "RequiredDate": "1998-04-01 00:00:00", "ShippedDate": "1998-04-08 00:00:00", "ShipVia": 2, "Freight": 151.5200, "ShipName": "Berglunds snabbkp", "ShipAddress": "Berguvsvgen 8", "ShipCity": "Lule", "ShipRegion": null, "ShipPostalCode": "S-958 22", "ShipCountry": "Sweden" }, { "OrderID": 10925, "CustomerID": "HANAR", "EmployeeID": 3, "OrderDate": "1998-03-04 00:00:00", "RequiredDate": "1998-04-01 00:00:00", "ShippedDate": "1998-03-13 00:00:00", "ShipVia": 1, "Freight": 2.2700, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10926, "CustomerID": "ANATR", "EmployeeID": 4, "OrderDate": "1998-03-04 00:00:00", "RequiredDate": "1998-04-01 00:00:00", "ShippedDate": "1998-03-11 00:00:00", "ShipVia": 3, "Freight": 39.9200, "ShipName": "Ana Trujillo Emparedados y helados", "ShipAddress": "Avda. de la Constitucin 2222", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5021, "ShipCountry": "Mexico" }, { "OrderID": 10927, "CustomerID": "LACOR", "EmployeeID": 4, "OrderDate": "1998-03-05 00:00:00", "RequiredDate": "1998-04-02 00:00:00", "ShippedDate": "1998-04-08 00:00:00", "ShipVia": 1, "Freight": 19.7900, "ShipName": "La corne d-abondance", "ShipAddress": "67, avenue de l-Europe", "ShipCity": "Versailles", "ShipRegion": null, "ShipPostalCode": 78000, "ShipCountry": "France" }, { "OrderID": 10928, "CustomerID": "GALED", "EmployeeID": 1, "OrderDate": "1998-03-05 00:00:00", "RequiredDate": "1998-04-02 00:00:00", "ShippedDate": "1998-03-18 00:00:00", "ShipVia": 1, "Freight": 1.3600, "ShipName": "Galera del gastronmo", "ShipAddress": "Rambla de Catalua, 23", "ShipCity": "Barcelona", "ShipRegion": null, "ShipPostalCode": 8022, "ShipCountry": "Spain" }, { "OrderID": 10929, "CustomerID": "FRANK", "EmployeeID": 6, "OrderDate": "1998-03-05 00:00:00", "RequiredDate": "1998-04-02 00:00:00", "ShippedDate": "1998-03-12 00:00:00", "ShipVia": 1, "Freight": 33.9300, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 10930, "CustomerID": "SUPRD", "EmployeeID": 4, "OrderDate": "1998-03-06 00:00:00", "RequiredDate": "1998-04-17 00:00:00", "ShippedDate": "1998-03-18 00:00:00", "ShipVia": 3, "Freight": 15.5500, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 10931, "CustomerID": "RICSU", "EmployeeID": 4, "OrderDate": "1998-03-06 00:00:00", "RequiredDate": "1998-03-20 00:00:00", "ShippedDate": "1998-03-19 00:00:00", "ShipVia": 2, "Freight": 13.6000, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 10932, "CustomerID": "BONAP", "EmployeeID": 8, "OrderDate": "1998-03-06 00:00:00", "RequiredDate": "1998-04-03 00:00:00", "ShippedDate": "1998-03-24 00:00:00", "ShipVia": 1, "Freight": 134.6400, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10933, "CustomerID": "ISLAT", "EmployeeID": 6, "OrderDate": "1998-03-06 00:00:00", "RequiredDate": "1998-04-03 00:00:00", "ShippedDate": "1998-03-16 00:00:00", "ShipVia": 3, "Freight": 54.1500, "ShipName": "Island Trading", "ShipAddress": "Garden House Crowther Way", "ShipCity": "Cowes", "ShipRegion": "Isle of Wight", "ShipPostalCode": "PO31 7PJ", "ShipCountry": "UK" }, { "OrderID": 10934, "CustomerID": "LEHMS", "EmployeeID": 3, "OrderDate": "1998-03-09 00:00:00", "RequiredDate": "1998-04-06 00:00:00", "ShippedDate": "1998-03-12 00:00:00", "ShipVia": 3, "Freight": 32.0100, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 10935, "CustomerID": "WELLI", "EmployeeID": 4, "OrderDate": "1998-03-09 00:00:00", "RequiredDate": "1998-04-06 00:00:00", "ShippedDate": "1998-03-18 00:00:00", "ShipVia": 3, "Freight": 47.5900, "ShipName": "Wellington Importadora", "ShipAddress": "Rua do Mercado, 12", "ShipCity": "Resende", "ShipRegion": "SP", "ShipPostalCode": "08737-363", "ShipCountry": "Brazil" }, { "OrderID": 10936, "CustomerID": "GREAL", "EmployeeID": 3, "OrderDate": "1998-03-09 00:00:00", "RequiredDate": "1998-04-06 00:00:00", "ShippedDate": "1998-03-18 00:00:00", "ShipVia": 2, "Freight": 33.6800, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 10937, "CustomerID": "CACTU", "EmployeeID": 7, "OrderDate": "1998-03-10 00:00:00", "RequiredDate": "1998-03-24 00:00:00", "ShippedDate": "1998-03-13 00:00:00", "ShipVia": 3, "Freight": 31.5100, "ShipName": "Cactus Comidas para llevar", "ShipAddress": "Cerrito 333", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10938, "CustomerID": "QUICK", "EmployeeID": 3, "OrderDate": "1998-03-10 00:00:00", "RequiredDate": "1998-04-07 00:00:00", "ShippedDate": "1998-03-16 00:00:00", "ShipVia": 2, "Freight": 31.8900, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10939, "CustomerID": "MAGAA", "EmployeeID": 2, "OrderDate": "1998-03-10 00:00:00", "RequiredDate": "1998-04-07 00:00:00", "ShippedDate": "1998-03-13 00:00:00", "ShipVia": 2, "Freight": 76.3300, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10940, "CustomerID": "BONAP", "EmployeeID": 8, "OrderDate": "1998-03-11 00:00:00", "RequiredDate": "1998-04-08 00:00:00", "ShippedDate": "1998-03-23 00:00:00", "ShipVia": 3, "Freight": 19.7700, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 10941, "CustomerID": "SAVEA", "EmployeeID": 7, "OrderDate": "1998-03-11 00:00:00", "RequiredDate": "1998-04-08 00:00:00", "ShippedDate": "1998-03-20 00:00:00", "ShipVia": 2, "Freight": 400.8100, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10942, "CustomerID": "REGGC", "EmployeeID": 9, "OrderDate": "1998-03-11 00:00:00", "RequiredDate": "1998-04-08 00:00:00", "ShippedDate": "1998-03-18 00:00:00", "ShipVia": 3, "Freight": 17.9500, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 10943, "CustomerID": "BSBEV", "EmployeeID": 4, "OrderDate": "1998-03-11 00:00:00", "RequiredDate": "1998-04-08 00:00:00", "ShippedDate": "1998-03-19 00:00:00", "ShipVia": 2, "Freight": 2.1700, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 10944, "CustomerID": "BOTTM", "EmployeeID": 6, "OrderDate": "1998-03-12 00:00:00", "RequiredDate": "1998-03-26 00:00:00", "ShippedDate": "1998-03-13 00:00:00", "ShipVia": 3, "Freight": 52.9200, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10945, "CustomerID": "MORGK", "EmployeeID": 4, "OrderDate": "1998-03-12 00:00:00", "RequiredDate": "1998-04-09 00:00:00", "ShippedDate": "1998-03-18 00:00:00", "ShipVia": 1, "Freight": 10.2200, "ShipName": "Morgenstern Gesundkost", "ShipAddress": "Heerstr. 22", "ShipCity": "Leipzig", "ShipRegion": null, "ShipPostalCode": 4179, "ShipCountry": "Germany" }, { "OrderID": 10946, "CustomerID": "VAFFE", "EmployeeID": 1, "OrderDate": "1998-03-12 00:00:00", "RequiredDate": "1998-04-09 00:00:00", "ShippedDate": "1998-03-19 00:00:00", "ShipVia": 2, "Freight": 27.2000, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10947, "CustomerID": "BSBEV", "EmployeeID": 3, "OrderDate": "1998-03-13 00:00:00", "RequiredDate": "1998-04-10 00:00:00", "ShippedDate": "1998-03-16 00:00:00", "ShipVia": 2, "Freight": 3.2600, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 10948, "CustomerID": "GODOS", "EmployeeID": 3, "OrderDate": "1998-03-13 00:00:00", "RequiredDate": "1998-04-10 00:00:00", "ShippedDate": "1998-03-19 00:00:00", "ShipVia": 3, "Freight": 23.3900, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 10949, "CustomerID": "BOTTM", "EmployeeID": 2, "OrderDate": "1998-03-13 00:00:00", "RequiredDate": "1998-04-10 00:00:00", "ShippedDate": "1998-03-17 00:00:00", "ShipVia": 3, "Freight": 74.4400, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10950, "CustomerID": "MAGAA", "EmployeeID": 1, "OrderDate": "1998-03-16 00:00:00", "RequiredDate": "1998-04-13 00:00:00", "ShippedDate": "1998-03-23 00:00:00", "ShipVia": 2, "Freight": 2.5000, "ShipName": "Magazzini Alimentari Riuniti", "ShipAddress": "Via Ludovico il Moro 22", "ShipCity": "Bergamo", "ShipRegion": null, "ShipPostalCode": 24100, "ShipCountry": "Italy" }, { "OrderID": 10951, "CustomerID": "RICSU", "EmployeeID": 9, "OrderDate": "1998-03-16 00:00:00", "RequiredDate": "1998-04-27 00:00:00", "ShippedDate": "1998-04-07 00:00:00", "ShipVia": 2, "Freight": 30.8500, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 10952, "CustomerID": "ALFKI", "EmployeeID": 1, "OrderDate": "1998-03-16 00:00:00", "RequiredDate": "1998-04-27 00:00:00", "ShippedDate": "1998-03-24 00:00:00", "ShipVia": 1, "Freight": 40.4200, "ShipName": "Alfred-s Futterkiste", "ShipAddress": "Obere Str. 57", "ShipCity": "Berlin", "ShipRegion": null, "ShipPostalCode": 12209, "ShipCountry": "Germany" }, { "OrderID": 10953, "CustomerID": "AROUT", "EmployeeID": 9, "OrderDate": "1998-03-16 00:00:00", "RequiredDate": "1998-03-30 00:00:00", "ShippedDate": "1998-03-25 00:00:00", "ShipVia": 2, "Freight": 23.7200, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 10954, "CustomerID": "LINOD", "EmployeeID": 5, "OrderDate": "1998-03-17 00:00:00", "RequiredDate": "1998-04-28 00:00:00", "ShippedDate": "1998-03-20 00:00:00", "ShipVia": 1, "Freight": 27.9100, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 10955, "CustomerID": "FOLKO", "EmployeeID": 8, "OrderDate": "1998-03-17 00:00:00", "RequiredDate": "1998-04-14 00:00:00", "ShippedDate": "1998-03-20 00:00:00", "ShipVia": 2, "Freight": 3.2600, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10956, "CustomerID": "BLAUS", "EmployeeID": 6, "OrderDate": "1998-03-17 00:00:00", "RequiredDate": "1998-04-28 00:00:00", "ShippedDate": "1998-03-20 00:00:00", "ShipVia": 2, "Freight": 44.6500, "ShipName": "Blauer See Delikatessen", "ShipAddress": "Forsterstr. 57", "ShipCity": "Mannheim", "ShipRegion": null, "ShipPostalCode": 68306, "ShipCountry": "Germany" }, { "OrderID": 10957, "CustomerID": "HILAA", "EmployeeID": 8, "OrderDate": "1998-03-18 00:00:00", "RequiredDate": "1998-04-15 00:00:00", "ShippedDate": "1998-03-27 00:00:00", "ShipVia": 3, "Freight": 105.3600, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10958, "CustomerID": "OCEAN", "EmployeeID": 7, "OrderDate": "1998-03-18 00:00:00", "RequiredDate": "1998-04-15 00:00:00", "ShippedDate": "1998-03-27 00:00:00", "ShipVia": 2, "Freight": 49.5600, "ShipName": "Ocano Atlntico Ltda.", "ShipAddress": "Ing. Gustavo Moncada 8585 Piso 20-A", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10959, "CustomerID": "GOURL", "EmployeeID": 6, "OrderDate": "1998-03-18 00:00:00", "RequiredDate": "1998-04-29 00:00:00", "ShippedDate": "1998-03-23 00:00:00", "ShipVia": 2, "Freight": 4.9800, "ShipName": "Gourmet Lanchonetes", "ShipAddress": "Av. Brasil, 442", "ShipCity": "Campinas", "ShipRegion": "SP", "ShipPostalCode": "04876-786", "ShipCountry": "Brazil" }, { "OrderID": 10960, "CustomerID": "HILAA", "EmployeeID": 3, "OrderDate": "1998-03-19 00:00:00", "RequiredDate": "1998-04-02 00:00:00", "ShippedDate": "1998-04-08 00:00:00", "ShipVia": 1, "Freight": 2.0800, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10961, "CustomerID": "QUEEN", "EmployeeID": 8, "OrderDate": "1998-03-19 00:00:00", "RequiredDate": "1998-04-16 00:00:00", "ShippedDate": "1998-03-30 00:00:00", "ShipVia": 1, "Freight": 104.4700, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 10962, "CustomerID": "QUICK", "EmployeeID": 8, "OrderDate": "1998-03-19 00:00:00", "RequiredDate": "1998-04-16 00:00:00", "ShippedDate": "1998-03-23 00:00:00", "ShipVia": 2, "Freight": 275.7900, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10963, "CustomerID": "FURIB", "EmployeeID": 9, "OrderDate": "1998-03-19 00:00:00", "RequiredDate": "1998-04-16 00:00:00", "ShippedDate": "1998-03-26 00:00:00", "ShipVia": 3, "Freight": 2.7000, "ShipName": "Furia Bacalhau e Frutos do Mar", "ShipAddress": "Jardim das rosas n. 32", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1675, "ShipCountry": "Portugal" }, { "OrderID": 10964, "CustomerID": "SPECD", "EmployeeID": 3, "OrderDate": "1998-03-20 00:00:00", "RequiredDate": "1998-04-17 00:00:00", "ShippedDate": "1998-03-24 00:00:00", "ShipVia": 2, "Freight": 87.3800, "ShipName": "Spcialits du monde", "ShipAddress": "25, rue Lauriston", "ShipCity": "Paris", "ShipRegion": null, "ShipPostalCode": 75016, "ShipCountry": "France" }, { "OrderID": 10965, "CustomerID": "OLDWO", "EmployeeID": 6, "OrderDate": "1998-03-20 00:00:00", "RequiredDate": "1998-04-17 00:00:00", "ShippedDate": "1998-03-30 00:00:00", "ShipVia": 3, "Freight": 144.3800, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 10966, "CustomerID": "CHOPS", "EmployeeID": 4, "OrderDate": "1998-03-20 00:00:00", "RequiredDate": "1998-04-17 00:00:00", "ShippedDate": "1998-04-08 00:00:00", "ShipVia": 1, "Freight": 27.1900, "ShipName": "Chop-suey Chinese", "ShipAddress": "Hauptstr. 31", "ShipCity": "Bern", "ShipRegion": null, "ShipPostalCode": 3012, "ShipCountry": "Switzerland" }, { "OrderID": 10967, "CustomerID": "TOMSP", "EmployeeID": 2, "OrderDate": "1998-03-23 00:00:00", "RequiredDate": "1998-04-20 00:00:00", "ShippedDate": "1998-04-02 00:00:00", "ShipVia": 2, "Freight": 62.2200, "ShipName": "Toms Spezialitten", "ShipAddress": "Luisenstr. 48", "ShipCity": "Mnster", "ShipRegion": null, "ShipPostalCode": 44087, "ShipCountry": "Germany" }, { "OrderID": 10968, "CustomerID": "ERNSH", "EmployeeID": 1, "OrderDate": "1998-03-23 00:00:00", "RequiredDate": "1998-04-20 00:00:00", "ShippedDate": "1998-04-01 00:00:00", "ShipVia": 3, "Freight": 74.6000, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10969, "CustomerID": "COMMI", "EmployeeID": 1, "OrderDate": "1998-03-23 00:00:00", "RequiredDate": "1998-04-20 00:00:00", "ShippedDate": "1998-03-30 00:00:00", "ShipVia": 2, "Freight": 0.2100, "ShipName": "Comrcio Mineiro", "ShipAddress": "Av. dos Lusadas, 23", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05432-043", "ShipCountry": "Brazil" }, { "OrderID": 10970, "CustomerID": "BOLID", "EmployeeID": 9, "OrderDate": "1998-03-24 00:00:00", "RequiredDate": "1998-04-07 00:00:00", "ShippedDate": "1998-04-24 00:00:00", "ShipVia": 1, "Freight": 16.1600, "ShipName": "Blido Comidas preparadas", "ShipAddress": "C/ Araquil, 67", "ShipCity": "Madrid", "ShipRegion": null, "ShipPostalCode": 28023, "ShipCountry": "Spain" }, { "OrderID": 10971, "CustomerID": "FRANR", "EmployeeID": 2, "OrderDate": "1998-03-24 00:00:00", "RequiredDate": "1998-04-21 00:00:00", "ShippedDate": "1998-04-02 00:00:00", "ShipVia": 2, "Freight": 121.8200, "ShipName": "France restauration", "ShipAddress": "54, rue Royale", "ShipCity": "Nantes", "ShipRegion": null, "ShipPostalCode": 44000, "ShipCountry": "France" }, { "OrderID": 10972, "CustomerID": "LACOR", "EmployeeID": 4, "OrderDate": "1998-03-24 00:00:00", "RequiredDate": "1998-04-21 00:00:00", "ShippedDate": "1998-03-26 00:00:00", "ShipVia": 2, "Freight": 0.0200, "ShipName": "La corne d-abondance", "ShipAddress": "67, avenue de l-Europe", "ShipCity": "Versailles", "ShipRegion": null, "ShipPostalCode": 78000, "ShipCountry": "France" }, { "OrderID": 10973, "CustomerID": "LACOR", "EmployeeID": 6, "OrderDate": "1998-03-24 00:00:00", "RequiredDate": "1998-04-21 00:00:00", "ShippedDate": "1998-03-27 00:00:00", "ShipVia": 2, "Freight": 15.1700, "ShipName": "La corne d-abondance", "ShipAddress": "67, avenue de l-Europe", "ShipCity": "Versailles", "ShipRegion": null, "ShipPostalCode": 78000, "ShipCountry": "France" }, { "OrderID": 10974, "CustomerID": "SPLIR", "EmployeeID": 3, "OrderDate": "1998-03-25 00:00:00", "RequiredDate": "1998-04-08 00:00:00", "ShippedDate": "1998-04-03 00:00:00", "ShipVia": 3, "Freight": 12.9600, "ShipName": "Split Rail Beer & Ale", "ShipAddress": "P.O. Box 555", "ShipCity": "Lander", "ShipRegion": "WY", "ShipPostalCode": 82520, "ShipCountry": "USA" }, { "OrderID": 10975, "CustomerID": "BOTTM", "EmployeeID": 1, "OrderDate": "1998-03-25 00:00:00", "RequiredDate": "1998-04-22 00:00:00", "ShippedDate": "1998-03-27 00:00:00", "ShipVia": 3, "Freight": 32.2700, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10976, "CustomerID": "HILAA", "EmployeeID": 1, "OrderDate": "1998-03-25 00:00:00", "RequiredDate": "1998-05-06 00:00:00", "ShippedDate": "1998-04-03 00:00:00", "ShipVia": 1, "Freight": 37.9700, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 10977, "CustomerID": "FOLKO", "EmployeeID": 8, "OrderDate": "1998-03-26 00:00:00", "RequiredDate": "1998-04-23 00:00:00", "ShippedDate": "1998-04-10 00:00:00", "ShipVia": 3, "Freight": 208.5000, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10978, "CustomerID": "MAISD", "EmployeeID": 9, "OrderDate": "1998-03-26 00:00:00", "RequiredDate": "1998-04-23 00:00:00", "ShippedDate": "1998-04-23 00:00:00", "ShipVia": 2, "Freight": 32.8200, "ShipName": "Maison Dewey", "ShipAddress": "Rue Joseph-Bens 532", "ShipCity": "Bruxelles", "ShipRegion": null, "ShipPostalCode": "B-1180", "ShipCountry": "Belgium" }, { "OrderID": 10979, "CustomerID": "ERNSH", "EmployeeID": 8, "OrderDate": "1998-03-26 00:00:00", "RequiredDate": "1998-04-23 00:00:00", "ShippedDate": "1998-03-31 00:00:00", "ShipVia": 2, "Freight": 353.0700, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10980, "CustomerID": "FOLKO", "EmployeeID": 4, "OrderDate": "1998-03-27 00:00:00", "RequiredDate": "1998-05-08 00:00:00", "ShippedDate": "1998-04-17 00:00:00", "ShipVia": 1, "Freight": 1.2600, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10981, "CustomerID": "HANAR", "EmployeeID": 1, "OrderDate": "1998-03-27 00:00:00", "RequiredDate": "1998-04-24 00:00:00", "ShippedDate": "1998-04-02 00:00:00", "ShipVia": 2, "Freight": 193.3700, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 10982, "CustomerID": "BOTTM", "EmployeeID": 2, "OrderDate": "1998-03-27 00:00:00", "RequiredDate": "1998-04-24 00:00:00", "ShippedDate": "1998-04-08 00:00:00", "ShipVia": 1, "Freight": 14.0100, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 10983, "CustomerID": "SAVEA", "EmployeeID": 2, "OrderDate": "1998-03-27 00:00:00", "RequiredDate": "1998-04-24 00:00:00", "ShippedDate": "1998-04-06 00:00:00", "ShipVia": 2, "Freight": 657.5400, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10984, "CustomerID": "SAVEA", "EmployeeID": 1, "OrderDate": "1998-03-30 00:00:00", "RequiredDate": "1998-04-27 00:00:00", "ShippedDate": "1998-04-03 00:00:00", "ShipVia": 3, "Freight": 211.2200, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 10985, "CustomerID": "HUNGO", "EmployeeID": 2, "OrderDate": "1998-03-30 00:00:00", "RequiredDate": "1998-04-27 00:00:00", "ShippedDate": "1998-04-02 00:00:00", "ShipVia": 1, "Freight": 91.5100, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 10986, "CustomerID": "OCEAN", "EmployeeID": 8, "OrderDate": "1998-03-30 00:00:00", "RequiredDate": "1998-04-27 00:00:00", "ShippedDate": "1998-04-21 00:00:00", "ShipVia": 2, "Freight": 217.8600, "ShipName": "Ocano Atlntico Ltda.", "ShipAddress": "Ing. Gustavo Moncada 8585 Piso 20-A", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 10987, "CustomerID": "EASTC", "EmployeeID": 8, "OrderDate": "1998-03-31 00:00:00", "RequiredDate": "1998-04-28 00:00:00", "ShippedDate": "1998-04-06 00:00:00", "ShipVia": 1, "Freight": 185.4800, "ShipName": "Eastern Connection", "ShipAddress": "35 King George", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX3 6FW", "ShipCountry": "UK" }, { "OrderID": 10988, "CustomerID": "RATTC", "EmployeeID": 3, "OrderDate": "1998-03-31 00:00:00", "RequiredDate": "1998-04-28 00:00:00", "ShippedDate": "1998-04-10 00:00:00", "ShipVia": 2, "Freight": 61.1400, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 10989, "CustomerID": "QUEDE", "EmployeeID": 2, "OrderDate": "1998-03-31 00:00:00", "RequiredDate": "1998-04-28 00:00:00", "ShippedDate": "1998-04-02 00:00:00", "ShipVia": 1, "Freight": 34.7600, "ShipName": "Que Delcia", "ShipAddress": "Rua da Panificadora, 12", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-673", "ShipCountry": "Brazil" }, { "OrderID": 10990, "CustomerID": "ERNSH", "EmployeeID": 2, "OrderDate": "1998-04-01 00:00:00", "RequiredDate": "1998-05-13 00:00:00", "ShippedDate": "1998-04-07 00:00:00", "ShipVia": 3, "Freight": 117.6100, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 10991, "CustomerID": "QUICK", "EmployeeID": 1, "OrderDate": "1998-04-01 00:00:00", "RequiredDate": "1998-04-29 00:00:00", "ShippedDate": "1998-04-07 00:00:00", "ShipVia": 1, "Freight": 38.5100, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10992, "CustomerID": "THEBI", "EmployeeID": 1, "OrderDate": "1998-04-01 00:00:00", "RequiredDate": "1998-04-29 00:00:00", "ShippedDate": "1998-04-03 00:00:00", "ShipVia": 3, "Freight": 4.2700, "ShipName": "The Big Cheese", "ShipAddress": "89 Jefferson Way Suite 2", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97201, "ShipCountry": "USA" }, { "OrderID": 10993, "CustomerID": "FOLKO", "EmployeeID": 7, "OrderDate": "1998-04-01 00:00:00", "RequiredDate": "1998-04-29 00:00:00", "ShippedDate": "1998-04-10 00:00:00", "ShipVia": 3, "Freight": 8.8100, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 10994, "CustomerID": "VAFFE", "EmployeeID": 2, "OrderDate": "1998-04-02 00:00:00", "RequiredDate": "1998-04-16 00:00:00", "ShippedDate": "1998-04-09 00:00:00", "ShipVia": 3, "Freight": 65.5300, "ShipName": "Vaffeljernet", "ShipAddress": "Smagsloget 45", "ShipCity": "rhus", "ShipRegion": null, "ShipPostalCode": 8200, "ShipCountry": "Denmark" }, { "OrderID": 10995, "CustomerID": "PERIC", "EmployeeID": 1, "OrderDate": "1998-04-02 00:00:00", "RequiredDate": "1998-04-30 00:00:00", "ShippedDate": "1998-04-06 00:00:00", "ShipVia": 3, "Freight": 46.0000, "ShipName": "Pericles Comidas clsicas", "ShipAddress": "Calle Dr. Jorge Cash 321", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 10996, "CustomerID": "QUICK", "EmployeeID": 4, "OrderDate": "1998-04-02 00:00:00", "RequiredDate": "1998-04-30 00:00:00", "ShippedDate": "1998-04-10 00:00:00", "ShipVia": 2, "Freight": 1.1200, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 10997, "CustomerID": "LILAS", "EmployeeID": 8, "OrderDate": "1998-04-03 00:00:00", "RequiredDate": "1998-05-15 00:00:00", "ShippedDate": "1998-04-13 00:00:00", "ShipVia": 2, "Freight": 73.9100, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 10998, "CustomerID": "WOLZA", "EmployeeID": 8, "OrderDate": "1998-04-03 00:00:00", "RequiredDate": "1998-04-17 00:00:00", "ShippedDate": "1998-04-17 00:00:00", "ShipVia": 2, "Freight": 20.3100, "ShipName": "Wolski Zajazd", "ShipAddress": "ul. Filtrowa 68", "ShipCity": "Warszawa", "ShipRegion": null, "ShipPostalCode": "01-012", "ShipCountry": "Poland" }, { "OrderID": 10999, "CustomerID": "OTTIK", "EmployeeID": 6, "OrderDate": "1998-04-03 00:00:00", "RequiredDate": "1998-05-01 00:00:00", "ShippedDate": "1998-04-10 00:00:00", "ShipVia": 2, "Freight": 96.3500, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 11000, "CustomerID": "RATTC", "EmployeeID": 2, "OrderDate": "1998-04-06 00:00:00", "RequiredDate": "1998-05-04 00:00:00", "ShippedDate": "1998-04-14 00:00:00", "ShipVia": 3, "Freight": 55.1200, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA" }, { "OrderID": 11001, "CustomerID": "FOLKO", "EmployeeID": 2, "OrderDate": "1998-04-06 00:00:00", "RequiredDate": "1998-05-04 00:00:00", "ShippedDate": "1998-04-14 00:00:00", "ShipVia": 2, "Freight": 197.3000, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 11002, "CustomerID": "SAVEA", "EmployeeID": 4, "OrderDate": "1998-04-06 00:00:00", "RequiredDate": "1998-05-04 00:00:00", "ShippedDate": "1998-04-16 00:00:00", "ShipVia": 1, "Freight": 141.1600, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 11003, "CustomerID": "THECR", "EmployeeID": 3, "OrderDate": "1998-04-06 00:00:00", "RequiredDate": "1998-05-04 00:00:00", "ShippedDate": "1998-04-08 00:00:00", "ShipVia": 3, "Freight": 14.9100, "ShipName": "The Cracker Box", "ShipAddress": "55 Grizzly Peak Rd.", "ShipCity": "Butte", "ShipRegion": "MT", "ShipPostalCode": 59801, "ShipCountry": "USA" }, { "OrderID": 11004, "CustomerID": "MAISD", "EmployeeID": 3, "OrderDate": "1998-04-07 00:00:00", "RequiredDate": "1998-05-05 00:00:00", "ShippedDate": "1998-04-20 00:00:00", "ShipVia": 1, "Freight": 44.8400, "ShipName": "Maison Dewey", "ShipAddress": "Rue Joseph-Bens 532", "ShipCity": "Bruxelles", "ShipRegion": null, "ShipPostalCode": "B-1180", "ShipCountry": "Belgium" }, { "OrderID": 11005, "CustomerID": "WILMK", "EmployeeID": 2, "OrderDate": "1998-04-07 00:00:00", "RequiredDate": "1998-05-05 00:00:00", "ShippedDate": "1998-04-10 00:00:00", "ShipVia": 1, "Freight": 0.7500, "ShipName": "Wilman Kala", "ShipAddress": "Keskuskatu 45", "ShipCity": "Helsinki", "ShipRegion": null, "ShipPostalCode": 21240, "ShipCountry": "Finland" }, { "OrderID": 11006, "CustomerID": "GREAL", "EmployeeID": 3, "OrderDate": "1998-04-07 00:00:00", "RequiredDate": "1998-05-05 00:00:00", "ShippedDate": "1998-04-15 00:00:00", "ShipVia": 2, "Freight": 25.1900, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 11007, "CustomerID": "PRINI", "EmployeeID": 8, "OrderDate": "1998-04-08 00:00:00", "RequiredDate": "1998-05-06 00:00:00", "ShippedDate": "1998-04-13 00:00:00", "ShipVia": 2, "Freight": 202.2400, "ShipName": "Princesa Isabel Vinhos", "ShipAddress": "Estrada da sade n. 58", "ShipCity": "Lisboa", "ShipRegion": null, "ShipPostalCode": 1756, "ShipCountry": "Portugal" }, { "OrderID": 11008, "CustomerID": "ERNSH", "EmployeeID": 7, "OrderDate": "1998-04-08 00:00:00", "RequiredDate": "1998-05-06 00:00:00", "ShippedDate": null, "ShipVia": 3, "Freight": 79.4600, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 11009, "CustomerID": "GODOS", "EmployeeID": 2, "OrderDate": "1998-04-08 00:00:00", "RequiredDate": "1998-05-06 00:00:00", "ShippedDate": "1998-04-10 00:00:00", "ShipVia": 1, "Freight": 59.1100, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 11010, "CustomerID": "REGGC", "EmployeeID": 2, "OrderDate": "1998-04-09 00:00:00", "RequiredDate": "1998-05-07 00:00:00", "ShippedDate": "1998-04-21 00:00:00", "ShipVia": 2, "Freight": 28.7100, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 11011, "CustomerID": "ALFKI", "EmployeeID": 3, "OrderDate": "1998-04-09 00:00:00", "RequiredDate": "1998-05-07 00:00:00", "ShippedDate": "1998-04-13 00:00:00", "ShipVia": 1, "Freight": 1.2100, "ShipName": "Alfred-s Futterkiste", "ShipAddress": "Obere Str. 57", "ShipCity": "Berlin", "ShipRegion": null, "ShipPostalCode": 12209, "ShipCountry": "Germany" }, { "OrderID": 11012, "CustomerID": "FRANK", "EmployeeID": 1, "OrderDate": "1998-04-09 00:00:00", "RequiredDate": "1998-04-23 00:00:00", "ShippedDate": "1998-04-17 00:00:00", "ShipVia": 3, "Freight": 242.9500, "ShipName": "Frankenversand", "ShipAddress": "Berliner Platz 43", "ShipCity": "Mnchen", "ShipRegion": null, "ShipPostalCode": 80805, "ShipCountry": "Germany" }, { "OrderID": 11013, "CustomerID": "ROMEY", "EmployeeID": 2, "OrderDate": "1998-04-09 00:00:00", "RequiredDate": "1998-05-07 00:00:00", "ShippedDate": "1998-04-10 00:00:00", "ShipVia": 1, "Freight": 32.9900, "ShipName": "Romero y tomillo", "ShipAddress": "Gran Va, 1", "ShipCity": "Madrid", "ShipRegion": null, "ShipPostalCode": 28001, "ShipCountry": "Spain" }, { "OrderID": 11014, "CustomerID": "LINOD", "EmployeeID": 2, "OrderDate": "1998-04-10 00:00:00", "RequiredDate": "1998-05-08 00:00:00", "ShippedDate": "1998-04-15 00:00:00", "ShipVia": 3, "Freight": 23.6000, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 11015, "CustomerID": "SANTG", "EmployeeID": 2, "OrderDate": "1998-04-10 00:00:00", "RequiredDate": "1998-04-24 00:00:00", "ShippedDate": "1998-04-20 00:00:00", "ShipVia": 2, "Freight": 4.6200, "ShipName": "Sant Gourmet", "ShipAddress": "Erling Skakkes gate 78", "ShipCity": "Stavern", "ShipRegion": null, "ShipPostalCode": 4110, "ShipCountry": "Norway" }, { "OrderID": 11016, "CustomerID": "AROUT", "EmployeeID": 9, "OrderDate": "1998-04-10 00:00:00", "RequiredDate": "1998-05-08 00:00:00", "ShippedDate": "1998-04-13 00:00:00", "ShipVia": 2, "Freight": 33.8000, "ShipName": "Around the Horn", "ShipAddress": "Brook Farm Stratford St. Mary", "ShipCity": "Colchester", "ShipRegion": "Essex", "ShipPostalCode": "CO7 6JX", "ShipCountry": "UK" }, { "OrderID": 11017, "CustomerID": "ERNSH", "EmployeeID": 9, "OrderDate": "1998-04-13 00:00:00", "RequiredDate": "1998-05-11 00:00:00", "ShippedDate": "1998-04-20 00:00:00", "ShipVia": 2, "Freight": 754.2600, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 11018, "CustomerID": "LONEP", "EmployeeID": 4, "OrderDate": "1998-04-13 00:00:00", "RequiredDate": "1998-05-11 00:00:00", "ShippedDate": "1998-04-16 00:00:00", "ShipVia": 2, "Freight": 11.6500, "ShipName": "Lonesome Pine Restaurant", "ShipAddress": "89 Chiaroscuro Rd.", "ShipCity": "Portland", "ShipRegion": "OR", "ShipPostalCode": 97219, "ShipCountry": "USA" }, { "OrderID": 11019, "CustomerID": "RANCH", "EmployeeID": 6, "OrderDate": "1998-04-13 00:00:00", "RequiredDate": "1998-05-11 00:00:00", "ShippedDate": null, "ShipVia": 3, "Freight": 3.1700, "ShipName": "Rancho grande", "ShipAddress": "Av. del Libertador 900", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 11020, "CustomerID": "OTTIK", "EmployeeID": 2, "OrderDate": "1998-04-14 00:00:00", "RequiredDate": "1998-05-12 00:00:00", "ShippedDate": "1998-04-16 00:00:00", "ShipVia": 2, "Freight": 43.3000, "ShipName": "Ottilies Kseladen", "ShipAddress": "Mehrheimerstr. 369", "ShipCity": "Kln", "ShipRegion": null, "ShipPostalCode": 50739, "ShipCountry": "Germany" }, { "OrderID": 11021, "CustomerID": "QUICK", "EmployeeID": 3, "OrderDate": "1998-04-14 00:00:00", "RequiredDate": "1998-05-12 00:00:00", "ShippedDate": "1998-04-21 00:00:00", "ShipVia": 1, "Freight": 297.1800, "ShipName": "QUICK-Stop", "ShipAddress": "Taucherstrae 10", "ShipCity": "Cunewalde", "ShipRegion": null, "ShipPostalCode": 1307, "ShipCountry": "Germany" }, { "OrderID": 11022, "CustomerID": "HANAR", "EmployeeID": 9, "OrderDate": "1998-04-14 00:00:00", "RequiredDate": "1998-05-12 00:00:00", "ShippedDate": "1998-05-04 00:00:00", "ShipVia": 2, "Freight": 6.2700, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 11023, "CustomerID": "BSBEV", "EmployeeID": 1, "OrderDate": "1998-04-14 00:00:00", "RequiredDate": "1998-04-28 00:00:00", "ShippedDate": "1998-04-24 00:00:00", "ShipVia": 2, "Freight": 123.8300, "ShipName": "B-s Beverages", "ShipAddress": "Fauntleroy Circus", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "EC2 5NT", "ShipCountry": "UK" }, { "OrderID": 11024, "CustomerID": "EASTC", "EmployeeID": 4, "OrderDate": "1998-04-15 00:00:00", "RequiredDate": "1998-05-13 00:00:00", "ShippedDate": "1998-04-20 00:00:00", "ShipVia": 1, "Freight": 74.3600, "ShipName": "Eastern Connection", "ShipAddress": "35 King George", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX3 6FW", "ShipCountry": "UK" }, { "OrderID": 11025, "CustomerID": "WARTH", "EmployeeID": 6, "OrderDate": "1998-04-15 00:00:00", "RequiredDate": "1998-05-13 00:00:00", "ShippedDate": "1998-04-24 00:00:00", "ShipVia": 3, "Freight": 29.1700, "ShipName": "Wartian Herkku", "ShipAddress": "Torikatu 38", "ShipCity": "Oulu", "ShipRegion": null, "ShipPostalCode": 90110, "ShipCountry": "Finland" }, { "OrderID": 11026, "CustomerID": "FRANS", "EmployeeID": 4, "OrderDate": "1998-04-15 00:00:00", "RequiredDate": "1998-05-13 00:00:00", "ShippedDate": "1998-04-28 00:00:00", "ShipVia": 1, "Freight": 47.0900, "ShipName": "Franchi S.p.A.", "ShipAddress": "Via Monte Bianco 34", "ShipCity": "Torino", "ShipRegion": null, "ShipPostalCode": 10100, "ShipCountry": "Italy" }, { "OrderID": 11027, "CustomerID": "BOTTM", "EmployeeID": 1, "OrderDate": "1998-04-16 00:00:00", "RequiredDate": "1998-05-14 00:00:00", "ShippedDate": "1998-04-20 00:00:00", "ShipVia": 1, "Freight": 52.5200, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 11028, "CustomerID": "KOENE", "EmployeeID": 2, "OrderDate": "1998-04-16 00:00:00", "RequiredDate": "1998-05-14 00:00:00", "ShippedDate": "1998-04-22 00:00:00", "ShipVia": 1, "Freight": 29.5900, "ShipName": "Kniglich Essen", "ShipAddress": "Maubelstr. 90", "ShipCity": "Brandenburg", "ShipRegion": null, "ShipPostalCode": 14776, "ShipCountry": "Germany" }, { "OrderID": 11029, "CustomerID": "CHOPS", "EmployeeID": 4, "OrderDate": "1998-04-16 00:00:00", "RequiredDate": "1998-05-14 00:00:00", "ShippedDate": "1998-04-27 00:00:00", "ShipVia": 1, "Freight": 47.8400, "ShipName": "Chop-suey Chinese", "ShipAddress": "Hauptstr. 31", "ShipCity": "Bern", "ShipRegion": null, "ShipPostalCode": 3012, "ShipCountry": "Switzerland" }, { "OrderID": 11030, "CustomerID": "SAVEA", "EmployeeID": 7, "OrderDate": "1998-04-17 00:00:00", "RequiredDate": "1998-05-15 00:00:00", "ShippedDate": "1998-04-27 00:00:00", "ShipVia": 2, "Freight": 830.7500, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 11031, "CustomerID": "SAVEA", "EmployeeID": 6, "OrderDate": "1998-04-17 00:00:00", "RequiredDate": "1998-05-15 00:00:00", "ShippedDate": "1998-04-24 00:00:00", "ShipVia": 2, "Freight": 227.2200, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 11032, "CustomerID": "WHITC", "EmployeeID": 2, "OrderDate": "1998-04-17 00:00:00", "RequiredDate": "1998-05-15 00:00:00", "ShippedDate": "1998-04-23 00:00:00", "ShipVia": 3, "Freight": 606.1900, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 11033, "CustomerID": "RICSU", "EmployeeID": 7, "OrderDate": "1998-04-17 00:00:00", "RequiredDate": "1998-05-15 00:00:00", "ShippedDate": "1998-04-23 00:00:00", "ShipVia": 3, "Freight": 84.7400, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 11034, "CustomerID": "OLDWO", "EmployeeID": 8, "OrderDate": "1998-04-20 00:00:00", "RequiredDate": "1998-06-01 00:00:00", "ShippedDate": "1998-04-27 00:00:00", "ShipVia": 1, "Freight": 40.3200, "ShipName": "Old World Delicatessen", "ShipAddress": "2743 Bering St.", "ShipCity": "Anchorage", "ShipRegion": "AK", "ShipPostalCode": 99508, "ShipCountry": "USA" }, { "OrderID": 11035, "CustomerID": "SUPRD", "EmployeeID": 2, "OrderDate": "1998-04-20 00:00:00", "RequiredDate": "1998-05-18 00:00:00", "ShippedDate": "1998-04-24 00:00:00", "ShipVia": 2, "Freight": 0.1700, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 11036, "CustomerID": "DRACD", "EmployeeID": 8, "OrderDate": "1998-04-20 00:00:00", "RequiredDate": "1998-05-18 00:00:00", "ShippedDate": "1998-04-22 00:00:00", "ShipVia": 3, "Freight": 149.4700, "ShipName": "Drachenblut Delikatessen", "ShipAddress": "Walserweg 21", "ShipCity": "Aachen", "ShipRegion": null, "ShipPostalCode": 52066, "ShipCountry": "Germany" }, { "OrderID": 11037, "CustomerID": "GODOS", "EmployeeID": 7, "OrderDate": "1998-04-21 00:00:00", "RequiredDate": "1998-05-19 00:00:00", "ShippedDate": "1998-04-27 00:00:00", "ShipVia": 1, "Freight": 3.2000, "ShipName": "Godos Cocina Tpica", "ShipAddress": "C/ Romero, 33", "ShipCity": "Sevilla", "ShipRegion": null, "ShipPostalCode": 41101, "ShipCountry": "Spain" }, { "OrderID": 11038, "CustomerID": "SUPRD", "EmployeeID": 1, "OrderDate": "1998-04-21 00:00:00", "RequiredDate": "1998-05-19 00:00:00", "ShippedDate": "1998-04-30 00:00:00", "ShipVia": 2, "Freight": 29.5900, "ShipName": "Suprmes dlices", "ShipAddress": "Boulevard Tirou, 255", "ShipCity": "Charleroi", "ShipRegion": null, "ShipPostalCode": "B-6000", "ShipCountry": "Belgium" }, { "OrderID": 11039, "CustomerID": "LINOD", "EmployeeID": 1, "OrderDate": "1998-04-21 00:00:00", "RequiredDate": "1998-05-19 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 65.0000, "ShipName": "LINO-Delicateses", "ShipAddress": "Ave. 5 de Mayo Porlamar", "ShipCity": "I. de Margarita", "ShipRegion": "Nueva Esparta", "ShipPostalCode": 4980, "ShipCountry": "Venezuela" }, { "OrderID": 11040, "CustomerID": "GREAL", "EmployeeID": 4, "OrderDate": "1998-04-22 00:00:00", "RequiredDate": "1998-05-20 00:00:00", "ShippedDate": null, "ShipVia": 3, "Freight": 18.8400, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 11041, "CustomerID": "CHOPS", "EmployeeID": 3, "OrderDate": "1998-04-22 00:00:00", "RequiredDate": "1998-05-20 00:00:00", "ShippedDate": "1998-04-28 00:00:00", "ShipVia": 2, "Freight": 48.2200, "ShipName": "Chop-suey Chinese", "ShipAddress": "Hauptstr. 31", "ShipCity": "Bern", "ShipRegion": null, "ShipPostalCode": 3012, "ShipCountry": "Switzerland" }, { "OrderID": 11042, "CustomerID": "COMMI", "EmployeeID": 2, "OrderDate": "1998-04-22 00:00:00", "RequiredDate": "1998-05-06 00:00:00", "ShippedDate": "1998-05-01 00:00:00", "ShipVia": 1, "Freight": 29.9900, "ShipName": "Comrcio Mineiro", "ShipAddress": "Av. dos Lusadas, 23", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05432-043", "ShipCountry": "Brazil" }, { "OrderID": 11043, "CustomerID": "SPECD", "EmployeeID": 5, "OrderDate": "1998-04-22 00:00:00", "RequiredDate": "1998-05-20 00:00:00", "ShippedDate": "1998-04-29 00:00:00", "ShipVia": 2, "Freight": 8.8000, "ShipName": "Spcialits du monde", "ShipAddress": "25, rue Lauriston", "ShipCity": "Paris", "ShipRegion": null, "ShipPostalCode": 75016, "ShipCountry": "France" }, { "OrderID": 11044, "CustomerID": "WOLZA", "EmployeeID": 4, "OrderDate": "1998-04-23 00:00:00", "RequiredDate": "1998-05-21 00:00:00", "ShippedDate": "1998-05-01 00:00:00", "ShipVia": 1, "Freight": 8.7200, "ShipName": "Wolski Zajazd", "ShipAddress": "ul. Filtrowa 68", "ShipCity": "Warszawa", "ShipRegion": null, "ShipPostalCode": "01-012", "ShipCountry": "Poland" }, { "OrderID": 11045, "CustomerID": "BOTTM", "EmployeeID": 6, "OrderDate": "1998-04-23 00:00:00", "RequiredDate": "1998-05-21 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 70.5800, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 11046, "CustomerID": "WANDK", "EmployeeID": 8, "OrderDate": "1998-04-23 00:00:00", "RequiredDate": "1998-05-21 00:00:00", "ShippedDate": "1998-04-24 00:00:00", "ShipVia": 2, "Freight": 71.6400, "ShipName": "Die Wandernde Kuh", "ShipAddress": "Adenauerallee 900", "ShipCity": "Stuttgart", "ShipRegion": null, "ShipPostalCode": 70563, "ShipCountry": "Germany" }, { "OrderID": 11047, "CustomerID": "EASTC", "EmployeeID": 7, "OrderDate": "1998-04-24 00:00:00", "RequiredDate": "1998-05-22 00:00:00", "ShippedDate": "1998-05-01 00:00:00", "ShipVia": 3, "Freight": 46.6200, "ShipName": "Eastern Connection", "ShipAddress": "35 King George", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX3 6FW", "ShipCountry": "UK" }, { "OrderID": 11048, "CustomerID": "BOTTM", "EmployeeID": 7, "OrderDate": "1998-04-24 00:00:00", "RequiredDate": "1998-05-22 00:00:00", "ShippedDate": "1998-04-30 00:00:00", "ShipVia": 3, "Freight": 24.1200, "ShipName": "Bottom-Dollar Markets", "ShipAddress": "23 Tsawassen Blvd.", "ShipCity": "Tsawassen", "ShipRegion": "BC", "ShipPostalCode": "T2F 8M4", "ShipCountry": "Canada" }, { "OrderID": 11049, "CustomerID": "GOURL", "EmployeeID": 3, "OrderDate": "1998-04-24 00:00:00", "RequiredDate": "1998-05-22 00:00:00", "ShippedDate": "1998-05-04 00:00:00", "ShipVia": 1, "Freight": 8.3400, "ShipName": "Gourmet Lanchonetes", "ShipAddress": "Av. Brasil, 442", "ShipCity": "Campinas", "ShipRegion": "SP", "ShipPostalCode": "04876-786", "ShipCountry": "Brazil" }, { "OrderID": 11050, "CustomerID": "FOLKO", "EmployeeID": 8, "OrderDate": "1998-04-27 00:00:00", "RequiredDate": "1998-05-25 00:00:00", "ShippedDate": "1998-05-05 00:00:00", "ShipVia": 2, "Freight": 59.4100, "ShipName": "Folk och f HB", "ShipAddress": "kergatan 24", "ShipCity": "Brcke", "ShipRegion": null, "ShipPostalCode": "S-844 67", "ShipCountry": "Sweden" }, { "OrderID": 11051, "CustomerID": "LAMAI", "EmployeeID": 7, "OrderDate": "1998-04-27 00:00:00", "RequiredDate": "1998-05-25 00:00:00", "ShippedDate": null, "ShipVia": 3, "Freight": 2.7900, "ShipName": "La maison d-Asie", "ShipAddress": "1 rue Alsace-Lorraine", "ShipCity": "Toulouse", "ShipRegion": null, "ShipPostalCode": 31000, "ShipCountry": "France" }, { "OrderID": 11052, "CustomerID": "HANAR", "EmployeeID": 3, "OrderDate": "1998-04-27 00:00:00", "RequiredDate": "1998-05-25 00:00:00", "ShippedDate": "1998-05-01 00:00:00", "ShipVia": 1, "Freight": 67.2600, "ShipName": "Hanari Carnes", "ShipAddress": "Rua do Pao, 67", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "05454-876", "ShipCountry": "Brazil" }, { "OrderID": 11053, "CustomerID": "PICCO", "EmployeeID": 2, "OrderDate": "1998-04-27 00:00:00", "RequiredDate": "1998-05-25 00:00:00", "ShippedDate": "1998-04-29 00:00:00", "ShipVia": 2, "Freight": 53.0500, "ShipName": "Piccolo und mehr", "ShipAddress": "Geislweg 14", "ShipCity": "Salzburg", "ShipRegion": null, "ShipPostalCode": 5020, "ShipCountry": "Austria" }, { "OrderID": 11054, "CustomerID": "CACTU", "EmployeeID": 8, "OrderDate": "1998-04-28 00:00:00", "RequiredDate": "1998-05-26 00:00:00", "ShippedDate": null, "ShipVia": 1, "Freight": 0.3300, "ShipName": "Cactus Comidas para llevar", "ShipAddress": "Cerrito 333", "ShipCity": "Buenos Aires", "ShipRegion": null, "ShipPostalCode": 1010, "ShipCountry": "Argentina" }, { "OrderID": 11055, "CustomerID": "HILAA", "EmployeeID": 7, "OrderDate": "1998-04-28 00:00:00", "RequiredDate": "1998-05-26 00:00:00", "ShippedDate": "1998-05-05 00:00:00", "ShipVia": 2, "Freight": 120.9200, "ShipName": "HILARION-Abastos", "ShipAddress": "Carrera 22 con Ave. Carlos Soublette #8-35", "ShipCity": "San Cristbal", "ShipRegion": "Tchira", "ShipPostalCode": 5022, "ShipCountry": "Venezuela" }, { "OrderID": 11056, "CustomerID": "EASTC", "EmployeeID": 8, "OrderDate": "1998-04-28 00:00:00", "RequiredDate": "1998-05-12 00:00:00", "ShippedDate": "1998-05-01 00:00:00", "ShipVia": 2, "Freight": 278.9600, "ShipName": "Eastern Connection", "ShipAddress": "35 King George", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "WX3 6FW", "ShipCountry": "UK" }, { "OrderID": 11057, "CustomerID": "NORTS", "EmployeeID": 3, "OrderDate": "1998-04-29 00:00:00", "RequiredDate": "1998-05-27 00:00:00", "ShippedDate": "1998-05-01 00:00:00", "ShipVia": 3, "Freight": 4.1300, "ShipName": "North/South", "ShipAddress": "South House 300 Queensbridge", "ShipCity": "London", "ShipRegion": null, "ShipPostalCode": "SW7 1RZ", "ShipCountry": "UK" }, { "OrderID": 11058, "CustomerID": "BLAUS", "EmployeeID": 9, "OrderDate": "1998-04-29 00:00:00", "RequiredDate": "1998-05-27 00:00:00", "ShippedDate": null, "ShipVia": 3, "Freight": 31.1400, "ShipName": "Blauer See Delikatessen", "ShipAddress": "Forsterstr. 57", "ShipCity": "Mannheim", "ShipRegion": null, "ShipPostalCode": 68306, "ShipCountry": "Germany" }, { "OrderID": 11059, "CustomerID": "RICAR", "EmployeeID": 2, "OrderDate": "1998-04-29 00:00:00", "RequiredDate": "1998-06-10 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 85.8000, "ShipName": "Ricardo Adocicados", "ShipAddress": "Av. Copacabana, 267", "ShipCity": "Rio de Janeiro", "ShipRegion": "RJ", "ShipPostalCode": "02389-890", "ShipCountry": "Brazil" }, { "OrderID": 11060, "CustomerID": "FRANS", "EmployeeID": 2, "OrderDate": "1998-04-30 00:00:00", "RequiredDate": "1998-05-28 00:00:00", "ShippedDate": "1998-05-04 00:00:00", "ShipVia": 2, "Freight": 10.9800, "ShipName": "Franchi S.p.A.", "ShipAddress": "Via Monte Bianco 34", "ShipCity": "Torino", "ShipRegion": null, "ShipPostalCode": 10100, "ShipCountry": "Italy" }, { "OrderID": 11061, "CustomerID": "GREAL", "EmployeeID": 4, "OrderDate": "1998-04-30 00:00:00", "RequiredDate": "1998-06-11 00:00:00", "ShippedDate": null, "ShipVia": 3, "Freight": 14.0100, "ShipName": "Great Lakes Food Market", "ShipAddress": "2732 Baker Blvd.", "ShipCity": "Eugene", "ShipRegion": "OR", "ShipPostalCode": 97403, "ShipCountry": "USA" }, { "OrderID": 11062, "CustomerID": "REGGC", "EmployeeID": 4, "OrderDate": "1998-04-30 00:00:00", "RequiredDate": "1998-05-28 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 29.9300, "ShipName": "Reggiani Caseifici", "ShipAddress": "Strada Provinciale 124", "ShipCity": "Reggio Emilia", "ShipRegion": null, "ShipPostalCode": 42100, "ShipCountry": "Italy" }, { "OrderID": 11063, "CustomerID": "HUNGO", "EmployeeID": 3, "OrderDate": "1998-04-30 00:00:00", "RequiredDate": "1998-05-28 00:00:00", "ShippedDate": "1998-05-06 00:00:00", "ShipVia": 2, "Freight": 81.7300, "ShipName": "Hungry Owl All-Night Grocers", "ShipAddress": "8 Johnstown Road", "ShipCity": "Cork", "ShipRegion": "Co. Cork", "ShipPostalCode": null, "ShipCountry": "Ireland" }, { "OrderID": 11064, "CustomerID": "SAVEA", "EmployeeID": 1, "OrderDate": "1998-05-01 00:00:00", "RequiredDate": "1998-05-29 00:00:00", "ShippedDate": "1998-05-04 00:00:00", "ShipVia": 1, "Freight": 30.0900, "ShipName": "Save-a-lot Markets", "ShipAddress": "187 Suffolk Ln.", "ShipCity": "Boise", "ShipRegion": "ID", "ShipPostalCode": 83720, "ShipCountry": "USA" }, { "OrderID": 11065, "CustomerID": "LILAS", "EmployeeID": 8, "OrderDate": "1998-05-01 00:00:00", "RequiredDate": "1998-05-29 00:00:00", "ShippedDate": null, "ShipVia": 1, "Freight": 12.9100, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 11066, "CustomerID": "WHITC", "EmployeeID": 7, "OrderDate": "1998-05-01 00:00:00", "RequiredDate": "1998-05-29 00:00:00", "ShippedDate": "1998-05-04 00:00:00", "ShipVia": 2, "Freight": 44.7200, "ShipName": "White Clover Markets", "ShipAddress": "1029 - 12th Ave. S.", "ShipCity": "Seattle", "ShipRegion": "WA", "ShipPostalCode": 98124, "ShipCountry": "USA" }, { "OrderID": 11067, "CustomerID": "DRACD", "EmployeeID": 1, "OrderDate": "1998-05-04 00:00:00", "RequiredDate": "1998-05-18 00:00:00", "ShippedDate": "1998-05-06 00:00:00", "ShipVia": 2, "Freight": 7.9800, "ShipName": "Drachenblut Delikatessen", "ShipAddress": "Walserweg 21", "ShipCity": "Aachen", "ShipRegion": null, "ShipPostalCode": 52066, "ShipCountry": "Germany" }, { "OrderID": 11068, "CustomerID": "QUEEN", "EmployeeID": 8, "OrderDate": "1998-05-04 00:00:00", "RequiredDate": "1998-06-01 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 81.7500, "ShipName": "Queen Cozinha", "ShipAddress": "Alameda dos Canrios, 891", "ShipCity": "Sao Paulo", "ShipRegion": "SP", "ShipPostalCode": "05487-020", "ShipCountry": "Brazil" }, { "OrderID": 11069, "CustomerID": "TORTU", "EmployeeID": 1, "OrderDate": "1998-05-04 00:00:00", "RequiredDate": "1998-06-01 00:00:00", "ShippedDate": "1998-05-06 00:00:00", "ShipVia": 2, "Freight": 15.6700, "ShipName": "Tortuga Restaurante", "ShipAddress": "Avda. Azteca 123", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 11070, "CustomerID": "LEHMS", "EmployeeID": 2, "OrderDate": "1998-05-05 00:00:00", "RequiredDate": "1998-06-02 00:00:00", "ShippedDate": null, "ShipVia": 1, "Freight": 136.0000, "ShipName": "Lehmanns Marktstand", "ShipAddress": "Magazinweg 7", "ShipCity": "Frankfurt a.M.", "ShipRegion": null, "ShipPostalCode": 60528, "ShipCountry": "Germany" }, { "OrderID": 11071, "CustomerID": "LILAS", "EmployeeID": 1, "OrderDate": "1998-05-05 00:00:00", "RequiredDate": "1998-06-02 00:00:00", "ShippedDate": null, "ShipVia": 1, "Freight": 0.9300, "ShipName": "LILA-Supermercado", "ShipAddress": "Carrera 52 con Ave. Bolvar #65-98 Llano Largo", "ShipCity": "Barquisimeto", "ShipRegion": "Lara", "ShipPostalCode": 3508, "ShipCountry": "Venezuela" }, { "OrderID": 11072, "CustomerID": "ERNSH", "EmployeeID": 4, "OrderDate": "1998-05-05 00:00:00", "RequiredDate": "1998-06-02 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 258.6400, "ShipName": "Ernst Handel", "ShipAddress": "Kirchgasse 6", "ShipCity": "Graz", "ShipRegion": null, "ShipPostalCode": 8010, "ShipCountry": "Austria" }, { "OrderID": 11073, "CustomerID": "PERIC", "EmployeeID": 2, "OrderDate": "1998-05-05 00:00:00", "RequiredDate": "1998-06-02 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 24.9500, "ShipName": "Pericles Comidas clsicas", "ShipAddress": "Calle Dr. Jorge Cash 321", "ShipCity": "Mxico D.F.", "ShipRegion": null, "ShipPostalCode": 5033, "ShipCountry": "Mexico" }, { "OrderID": 11074, "CustomerID": "SIMOB", "EmployeeID": 7, "OrderDate": "1998-05-06 00:00:00", "RequiredDate": "1998-06-03 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 18.4400, "ShipName": "Simons bistro", "ShipAddress": "Vinbltet 34", "ShipCity": "Kobenhavn", "ShipRegion": null, "ShipPostalCode": 1734, "ShipCountry": "Denmark" }, { "OrderID": 11075, "CustomerID": "RICSU", "EmployeeID": 8, "OrderDate": "1998-05-06 00:00:00", "RequiredDate": "1998-06-03 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 6.1900, "ShipName": "Richter Supermarkt", "ShipAddress": "Starenweg 5", "ShipCity": "Genve", "ShipRegion": null, "ShipPostalCode": 1204, "ShipCountry": "Switzerland" }, { "OrderID": 11076, "CustomerID": "BONAP", "EmployeeID": 4, "OrderDate": "1998-05-06 00:00:00", "RequiredDate": "1998-06-03 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 38.2800, "ShipName": "Bon app-", "ShipAddress": "12, rue des Bouchers", "ShipCity": "Marseille", "ShipRegion": null, "ShipPostalCode": 13008, "ShipCountry": "France" }, { "OrderID": 11077, "CustomerID": "RATTC", "EmployeeID": 1, "OrderDate": "1998-05-06 00:00:00", "RequiredDate": "1998-06-03 00:00:00", "ShippedDate": null, "ShipVia": 2, "Freight": 8.5300, "ShipName": "Rattlesnake Canyon Grocery", "ShipAddress": "2817 Milton Dr.", "ShipCity": "Albuquerque", "ShipRegion": "NM", "ShipPostalCode": 87110, "ShipCountry": "USA"}]
            };
            var dataAdapter = new $.jqx.dataAdapter(source);
            dataAdapter.dataBind();
            $("#customersGrid").on('rowselect', function (event) {
                var customerID = event.args.row.CustomerID;
                var records = new Array();
                var length = dataAdapter.records.length;
                for (var i = 0; i < length; i++) {
                    var record = dataAdapter.records[i];
                    if (record.CustomerID == customerID) {
                        records[records.length] = record;
                    }
                }
                var dataSource = {
                    datafields: dataFields,
                    localdata: records
                }
                var adapter = new $.jqx.dataAdapter(dataSource);
        
                // update data source.
                $("#ordersGrid").jqxGrid({ source: adapter });
            });
            $("#ordersGrid").jqxGrid(
            {
                width: getWidth('Grid'),
                height: 250,
                keyboardnavigation: false,
                columns: [
                    { text: 'OrderID', datafield: 'OrderID', width: 100 },
                    { text: 'OrderDate', datafield: 'OrderDate', cellsformat: 'd', width: 150 },
                    { text: 'Shipped Date', datafield: 'ShippedDate', cellsformat: 'd', width: 150 },
                    { text: 'Ship Name', datafield: 'ShipName' }
                ]
            });
            $("#customersGrid").jqxGrid('selectrow', 0);
        });
    </script>
</head>
<body class='default'>
    <div id='jqxWidget' style="font-size: 13px; font-family: Verdana; float: left;">
        <h3>
            Customers</h3>
        <div id="customersGrid">
        </div>
        <h3>
            Orders by Customer</h3>
        <div id="ordersGrid">
        </div>
    </div>
</body>
</html>