<?php
require('../fpdf/fpdf.php');
require_once('../../Connections/conexion.php');

class PDF extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
	//Set the array of column widths
	$this->widths=$w;
}

function SetAligns($a)
{
	//Set the array of column alignments
	$this->aligns=$a;
}

function Row($data)
{
	//Calculate the height of the row
	$nb=0;
	for($i=0;$i<count($data);$i++)
		$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
	$h=5*$nb;
	//Issue a page break first if needed
	$this->CheckPageBreak($h);
	//Draw the cells of the row
	for($i=0;$i<count($data);$i++)
	{
		$w=$this->widths[$i];
		$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
		//Save the current position
		$x=$this->GetX();
		$y=$this->GetY();
		//Draw the border
		
		$this->Rect($x,$y,$w,$h);

		$this->MultiCell($w,5,$data[$i],0,$a,'true');
		//Put the position to the right of the cell
		$this->SetXY($x+$w,$y);
	}
	//Go to the next line
	$this->Ln($h);
}

function CheckPageBreak($h)
{
	//If the height h would cause an overflow, add a new page immediately
	if($this->GetY()+$h>$this->PageBreakTrigger)
		$this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
	//Computes the number of lines a MultiCell of width w will take
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 and $s[$nb-1]=="\n")
		$nb--;
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$nl=1;
	while($i<$nb)
	{
		$c=$s[$i];
		if($c=="\n")
		{
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
			continue;
		}
		if($c==' ')
			$sep=$i;
		$l+=$cw[$c];
		if($l>$wmax)
		{
			if($sep==-1)
			{
				if($i==$j)
					$i++;
			}
			else
				$i=$sep+1;
			$sep=-1;
			$j=$i;
			$l=0;
			$nl++;
		}
		else
			$i++;
	}
	return $nl;
}

function Header()
{

	$this->SetFont('Arial','B',8);
	$this->Text(20,14,'ESTADO DE CUENTA - EMPLEADO',0,'C', 0);
	$this->SetFont('Arial','',6);
	$this->Text(200,10,$this->PageNo(),0,'C', 0);
	$this->Ln(5);
}

function Footer()
{
	$this->SetY(-15);
	$this->SetFont('Arial','B',8);
	$this->Cell(100,10,'Kardexemp',0,0,'L');

}

}

	$empleado= $_GET['emp'];
	$desde= $_GET['fdesde'];
	$hasta= $_GET['fhasta'];
	//$con = new DB;
	//$pacientes = $con->conectar();	
	
	mysql_select_db($database_conexion, $conexion);
	//$strConsulta = "SELECT * from pacientes where id_paciente =  '$paciente'";
	$strConsulta = "SELECT * from empleado where emp_codigo=".$empleado ;
	$empleados = mysql_query($strConsulta,$conexion);
	$fila = mysql_fetch_array($empleados);
	

	///////////////////////

			



	////////////////////////


	$pdf=new PDF('P','mm','A4');
	$pdf->Open();
	$pdf->AddPage();
	$pdf->SetMargins(20,20,20);
	$pdf->Ln(1);

    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,6,'Codigo: '.$fila['emp_codigo'],0,1);
	$pdf->Cell(0,6,'Nombre: '.$fila['emp_apellido'].' '.$fila['emp_nombre'],0,1);
	$pdf->Cell(0,6,'Desde: '.$desde,0,1); 
	$pdf->Cell(0,6,'Hasta: '.$hasta,0,1); 	
	$pdf->Cell(0,6,'Saldo Anterior: '.$row_rsSaldo['saldoanterior'],0,1); 	
	
	
	$pdf->Ln(4);
	
	$pdf->SetWidths(array(7, 15, 100, 15, 10,15,15));
	$pdf->SetFont('Arial','B',6);
	$pdf->SetFillColor(104,131,139);
    $pdf->SetTextColor(255);

		for($i=0;$i<1;$i++)
			{
				$pdf->Row(array('TIPO', 'NUMERO', 'CONCEPTO', 'FECHA', 'CARGO', 'DESCARGO','SALDO'));
			}
	
			
		
			
			
			
			mysql_select_db($database_conexion, $conexion);
			$elimina_vista = "DROP VIEW IF EXISTS kardexemp";
			$drop_view = mysql_query($elimina_vista, $conexion) or die(mysql_error());
			
			 
			

			$sql=
				"CREATE VIEW kardexemp AS 
				
				
				SELECT egr_codegr as numero ,egr_codemp as empleado,egr_valor as cargo,0 as descargo,substr(egr_concepto,1,50) as concepto,
				egr_fechadescuento as fecha, egr_cuotas as cuotas,egr_cuotaspagadas as cuotaspagadas ,egr_tipo as tipo, 1 as orden
				from egresosbancos
				where  egr_tipo in(51) and egr_estado<>3 and egr_codemp=".$empleado. " and egr_fechadescuento between '". $desde ."' and '". $hasta ."'
				
				

				
				 union all 

				 

				SELECT egr_codegr as numero,egr_codemp as empleado,egr_valor as cargo, 0 as descargo, substr(egr_concepto,1,70) as concepto,
				egr_fecha as fecha,0 as cuotas,0 as cuotaspagadas,51 as tipo, 1 as orden
				from egresoscaja
				where egr_codemp=".$empleado. " and egr_fecha between '". $desde ."' and '". $hasta ."'

				
				
				
				


 union all
				 
				 SELECT egr_codegr as numero ,egr_codemp as empleado,egr_valor as cargo,0 as descargo,substr(egr_concepto,1,70) as concepto,
				egr_fechadescuento as fecha, egr_cuotas as cuotas,egr_cuotaspagadas as cuotaspagadas ,egr_tipo as tipo, 1 as orden
				from egresosbancos
				where  egr_tipo in(309) and egr_estado<>3 and egr_codemp=".$empleado. " and egr_fechadescuento between '". $desde ."' and '". $hasta ."'

union all
SELECT egr_codegr as numero ,egr_codemp as empleado,0 as cargo,egr_valor as descargo,substr(egr_concepto,1,70) as concepto,
				egr_fechadescuento as fecha, egr_cuotas as cuotas,egr_cuotaspagadas as cuotaspagadas ,egr_tipo as tipo, 2 as orden
				from egresosbancos
				where  egr_tipo in(309) and egr_estado<>3 and egr_codemp=".$empleado. " and egr_fechadescuento between '". $desde ."' and '". $hasta ."'				


" ;





		
			$result = mysql_query($sql,$conexion)or die(mysql_error());	
			//echo $result1;
	
	
	
	mysql_select_db($database_conexion, $conexion);
	$strConsulta = "SELECT tipo,numero,concepto,fecha,cargo,descargo from
	kardexemp where empleado=".$empleado. " ORDER BY fecha,orden,tipo,numero";
	$historial = mysql_query($strConsulta);
	$numfilas = mysql_num_rows($historial);
	
	$saldo=$row_rsSaldo['saldoanterior'];
	
	for ($i=0; $i<$numfilas; $i++)
		{
			
			$fila = mysql_fetch_array($historial);
			$pdf->SetFont('Arial','',6);
			
			//if ($fila['tipo']==51 || $fila['tipo']==52 || $fila['tipo']==53 || $fila['tipo']==54 || $fila['tipo']==0)
			//{
				$saldo=$saldo+$fila['cargo']-$fila['descargo'];
			//}
			//else
			//{
				//$saldo=$saldo-$fila['descargo'];
			//}
			
			if($i%2 == 1)
			{
				$pdf->SetFillColor(230,230,230);
    			$pdf->SetTextColor(0);
				
				$pdf->Row(array($fila['tipo'], $fila['numero'], $fila['concepto'], $fila['fecha'], $fila['cargo'], $fila['descargo'], round($saldo,2)));
			}
			else
			{
				$pdf->SetFillColor(255,255,255);
    			$pdf->SetTextColor(0);
				$pdf->Row(array($fila['tipo'], $fila['numero'], $fila['concepto'], $fila['fecha'], $fila['cargo'], $fila['descargo'], round($saldo,2)));
			}
		}

$pdf->Output();
?>