<?php
/**
*
* Layout for the shopping cart
*
* @package	VirtueMart
* @subpackage Cart
* @author Max Milbers
*
* @link http://www.virtuemart.net
* @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* VirtueMart is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* @version $Id: cart.php 2551 2010-09-30 18:52:40Z milbo $
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');
error_reporting('E_ALL');
if(VmConfig::get('usefancy',0)){
	vmJsApi::js( 'fancybox/jquery.fancybox-1.3.4.pack');
	vmJsApi::css('jquery.fancybox-1.3.4');
	$box = "
//<![CDATA[
	jQuery(document).ready(function($) {
		$('div#full-tos').hide();
		$('span.terms-of-service').click( function(){
			//$.facebox({ span: '#full-tos' });
			$.facebox( { div: '#full-tos' }, 'my-groovy-style terms');
		});
	});

//]]>
";
} else {
JHtml::script('facebox.js', 'components/com_virtuemart/assets/js/', false);
JHtml::stylesheet('facebox.css', 'components/com_virtuemart/assets/css/', false);
	$box = "
//<![CDATA[
	jQuery(document).ready(function($) {
		$('div#full-tos').hide();
		$('span.terms-of-service').click( function(){
			//$.facebox({ span: '#full-tos' });
			$.facebox( { div: '#full-tos' }, 'my-groovy-style terms');
		});
	});

//]]>
";
}

JHtml::_('behavior.formvalidation');
$document = JFactory::getDocument ();
$document->addScriptDeclaration ($box);
$document->addScriptDeclaration ("

//<![CDATA[
	jQuery(document).ready(function($) {
	if ( $('#STsameAsBTjs').is(':checked') ) {
				$('#output-shipto-display').hide();
			} else {
				$('#output-shipto-display').show();
			}
		$('#STsameAsBTjs').click(function(event) {
			if($(this).is(':checked')){
				$('#STsameAsBT').val('1') ;
				$('#output-shipto-display').hide();
			} else {
				$('#STsameAsBT').val('0') ;
				$('#output-shipto-display').show();
			}
		});
	});

//]]>
//<![CDATA[
	jQuery(document).ready(function($) {
	$('#checkoutFormSubmit').click(function(e){

	$(this).attr('disabled', 'true');
	var name = $(this).attr('name');
	$('#checkoutForm').append('<input name=\''+name+'\' value=\'1\' type=\'hidden\'>');
	$(this).fadeIn( 400 );
	$('#checkoutForm').submit();
});
	});

//]]>


");
$document->addStyleDeclaration('#facebox .content {display: block !important;  overflow: auto; width: 560px; }');

//  vmdebug('car7t pricesUnformatted',$this->cart->pricesUnformatted);
//  vmdebug('cart pricesUnformatted',$this->cart->cartData );
?>

<?php if (VmConfig::get('oncheckout_show_steps', 1) && $this->checkout_task==='confirm'){
		vmdebug('checkout_task',$this->checkout_task);
		echo '<h1 class="checkoutStep" id="checkoutStep4">'.JText::_('COM_VIRTUEMART_USER_FORM_CART_STEP4').'</h1>';
	} ?>
<div class="cart-view">
		<h3 class="module-title"><span><span><?php echo JText::_('DR_VIRTUEMART_CART_TITLE'); ?></span></span></h3>
	<div class="login-box">
    <?php // Continue Shopping Button
	if (!empty($this->continue_link_html)) { ?>
    <div class="back-to-category right-link">
    	<a style="display:inline-block;" href="<?php echo $this->continue_link ?>" class="button_back button reset2"><i class="fa fa-reply"></i><?php echo JText::sprintf('DR_CONT_SHOP') ?></a>
	</div>
    <?php } ?>
	<?php echo shopFunctionsF::getLoginForm ($this->cart, FALSE);
	//echo $this->loadTemplate('login');
	$adminID = JFactory::getSession()->get('vmAdminID');
	if ((JFactory::getUser()->authorise('core.admin', 'com_virtuemart') || JFactory::getUser($adminID)->authorise('core.admin', 'com_virtuemart')) && (VmConfig::get ('oncheckout_change_shopper', 0))) { 
		echo $this->loadTemplate ('shopperform');
	}

	$taskRoute = '';
	?>
	</div>
</div>
<form method="post" id="checkoutForm" name="checkoutForm" action="<?php echo JRoute::_ ('index.php?option=com_virtuemart&view=cart' . $taskRoute, $this->useXHTML, $this->useSSL); ?>"><div class="cart-view">
		<h3 class="module-title"><span><span><?php echo JText::_('DR_VIRTUEMART_CART_BILLING'); ?></span></span></h3>
		<div class="billing-box after">
			<div class="billto-shipto">
	<div class="width50 floatleft">
    <div class="text-indent">

		<span class="font"><span class="vmicon vm2-billto-icon"></span>
		<?php echo JText::_('COM_VIRTUEMART_USER_FORM_BILLTO_LBL'); ?></span>
		<?php // Output Bill To Address ?>
		<div class="output-billto">
			<?php
			$cartfieldNames = array();
			foreach( $this->userFieldsCart['fields'] as $fields){
				$cartfieldNames[] = $fields['name'];
			}

			foreach ($this->cart->BTaddress['fields'] as $item) {
				if(in_array($item['name'],$cartfieldNames)) continue;
				if (!empty($item['value'])) {
					if ($item['name'] === 'agreed') {
						$item['value'] = ($item['value'] === 0) ? vmText::_ ('COM_VIRTUEMART_USER_FORM_BILLTO_TOS_NO') : vmText::_ ('COM_VIRTUEMART_USER_FORM_BILLTO_TOS_YES');
					}
					?><!-- span class="titles"><?php echo $item['title'] ?></span -->
					<span class="values vm2<?php echo '-' . $item['name'] ?>"><?php echo $this->escape ($item['value']) ?></span>
					<?php if ($item['name'] != 'title' and $item['name'] != 'first_name' and $item['name'] != 'middle_name' and $item['name'] != 'zip') { ?>
						<br class="clear"/>
						<?php
					}
				}
			} ?>
			<div class="clear"></div>
		</div>

		<a class="button reset2" href="<?php echo JRoute::_ ('index.php?option=com_virtuemart&view=user&task=editaddresscart&addrtype=BT', $this->useXHTML, $this->useSSL) ?>" rel="nofollow">
			<?php echo vmText::_ ('COM_VIRTUEMART_USER_FORM_EDIT_BILLTO_LBL'); ?>
		</a>

		<input type="hidden" name="billto" value="<?php echo $this->cart->lists['billTo']; ?>"/>
        </div>
	</div>

	<div class="width50 floatleft">
		 <div class="text-indent2">
		<span class="font"><span class="vmicon vm2-shipto-icon"></span>
		<?php echo JText::_('COM_VIRTUEMART_USER_FORM_SHIPTO_LBL'); ?></span>
		<?php // Output Bill To Address ?>
		<div class="output-shipto">
			<?php
			if (!class_exists ('VmHtml')) {
				require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'html.php');
			}
			if($this->cart->user->virtuemart_user_id==0){

				echo vmText::_ ('COM_VIRTUEMART_USER_FORM_ST_SAME_AS_BT');
				echo VmHtml::checkbox ('STsameAsBTjs', $this->cart->STsameAsBT) . '<br />';
			} else if(!empty($this->cart->lists['shipTo'])){
				echo $this->cart->lists['shipTo'];
			}

			if(!empty($this->cart->ST) and  !empty($this->cart->STaddress['fields'])){



				?>
				<div id="output-shipto-display">
					<?php
					foreach ($this->cart->STaddress['fields'] as $item) {
						if (!empty($item['value'])) {
							?>
							<!-- <span class="titles"><?php echo $item['title'] ?></span> -->
							<?php
							if ($item['name'] == 'first_name' || $item['name'] == 'middle_name' || $item['name'] == 'zip') {
								?>
								<span class="values<?php echo '-' . $item['name'] ?>"><?php echo $this->escape ($item['value']) ?></span>
								<?php } else { ?>
								<span class="values"><?php echo $this->escape ($item['value']) ?></span>
								<br class="clear"/>
								<?php
							}
						}
					}
					?>
				</div>
				<?php
			}
			?>
			<div class="clear"></div>
		</div>
		<?php if (!isset($this->cart->lists['current_id'])) {
			$this->cart->lists['current_id'] = 0;

		} ?>
		<a class="details button reset2" href="<?php echo JRoute::_ ('index.php?option=com_virtuemart&view=user&task=editaddresscart&addrtype=ST&virtuemart_user_id[]=' . $this->cart->lists['current_id'], $this->useXHTML, $this->useSSL) ?>" rel="nofollow">
			<?php echo vmText::_ ('COM_VIRTUEMART_USER_FORM_ADD_SHIPTO_LBL'); ?>
		</a>
		</div>
	</div>

	<div class="clear"></div>
</div>
</div>
</div>
<div class="cart-view">
	<h3 class="module-title mar_bot"><span><span><?php echo JText::_('DR_VIRTUEMART_CART_ORDER'); ?></span></span></h3>
	<div class="billing-box">
    	<div class="cart_billing-box">
        <?php echo $this->loadTemplate ('pricelist'); ?>
  </div> 
  </div>
  </div>
  <div class="cart-view">
  <div class="billing-box">
  <?php if ( 	VmConfig::get('oncheckout_opc',true) or
	!VmConfig::get('oncheckout_show_steps',false) or
	(!VmConfig::get('oncheckout_opc',true) and VmConfig::get('oncheckout_show_steps',false) and
		!empty($this->cart->virtuemart_shipmentmethod_id) )
) { ?>

    <div class="shipment color">
    <?php if (!$this->cart->automaticSelectedShipment) { ?>
	
	<?php
	if (!empty($this->layoutName) && $this->layoutName == 'default' && !$this->cart->automaticSelectedShipment) {
		if (VmConfig::get('oncheckout_opc', 0)) {
			$previouslayout = $this->setLayout('select');
			echo $this->loadTemplate('shipment');
			$this->setLayout($previouslayout);
		} else {
			echo "<h3 class='module-title'><span>".JText::_('COM_VIRTUEMART_CART_SELECT_SHIPMENT')."</span></h3>";
			echo $this->cart->cartData['shipmentName'].'<br/>';
			echo '<div class="fright">'.JHTML::_('link', JRoute::_('index.php?view=cart&task=edit_shipment', $this->useXHTML, $this->useSSL), '<i class="icon-truck"></i> '.$this->select_shipment_text, 'class=""').'</div>';
		}
	} else {
		echo JText::_ ('COM_VIRTUEMART_CART_SHIPPING');
	}
} else {
	?>
		<?php echo $this->cart->cartData['shipmentName']; ?>
      <?php } ?>
		</div>
	<?php } ?>

<?php if ($this->cart->pricesUnformatted['salesPrice']>0.0 and
	( 	VmConfig::get('oncheckout_opc',true) or
		!VmConfig::get('oncheckout_show_steps',false) or
		( (!VmConfig::get('oncheckout_opc',true) and VmConfig::get('oncheckout_show_steps',false) ) and !empty($this->cart->virtuemart_paymentmethod_id))
	)
) { ?>

<div class="payment color" valign="top">
	<?php if (!$this->cart->automaticSelectedPayment) { ?>
		<?php if (!empty($this->layoutName) && $this->layoutName == 'default') {
			if (VmConfig::get('oncheckout_opc', 0)) {
				$previouslayout = $this->setLayout('select');
				echo $this->loadTemplate('payment');
				$this->setLayout($previouslayout);
			} else {
				echo "<h3 class='module-title'><span>".JText::_('COM_VIRTUEMART_CART_SELECT_PAYMENT')."</span></h3>";
				echo $this->cart->cartData['paymentName'].'<br/>'; 
				echo '<div class="fright automatick">'.JHTML::_('link', JRoute::_('index.php?view=cart&task=editpayment', $this->useXHTML, $this->useSSL), '<i class="icon-money"></i> '.$this->select_payment_text, 'class=""').'</div>';
			}
		} else {
		echo JText::_ ('COM_VIRTUEMART_CART_PAYMENT');
	} ?> 

	<?php } else { ?>
	<?php echo $this->cart->cartData['paymentName']; ?> 
	<?php } ?>
</div>
<?php  } ?>
</div>
    </div>
  <div class="cart-view">
	<div class="billing-box">
    <div class="bot-price">
        <div><span  class='txtTax'><?php echo JText::_('COM_VIRTUEMART_CART_SUBTOTAL_TAX_AMOUNT') ?>:</span><?php echo "<span  class='priceTax'>".$this->currencyDisplay->createPriceDiv ('', '', $this->cart->cartPrices['billTaxAmount'], FALSE)."</span>" ?></div>
        <div><span  class='txtTax'><?php echo JText::_('COM_VIRTUEMART_CART_SUBTOTAL_DISCOUNT_AMOUNT') ?>:</span><?php echo "<span  class='priceDisc'>".$this->currencyDisplay->createPriceDiv ('', '', $this->cart->cartPrices['billDiscountAmount'], FALSE)."</span>" ?></div> 
        <div><span  class='txtTax'><?php echo JText::_('COM_VIRTUEMART_CART_TOTAL') ?>:</span><span class="priceTotal"><?php echo $this->currencyDisplay->createPriceDiv ('', '', $this->cart->cartPrices['billTotal'], FALSE); ?></span></div>
    </div>
    </br>      
	<?php if (!empty($this->checkoutAdvertise)) {
			?> <div id="checkout-advertise-box"> <?php
			foreach ($this->checkoutAdvertise as $checkoutAdvertise) {
				?>
				<div class="checkout-advertise">
					<?php echo $checkoutAdvertise; ?>
				</div>
				<?php
			}
			?></div><?php
		}
		
			echo $this->loadTemplate ('cartfields');

		?> <div class="checkout-button-top"> <?php
			echo $this->checkout_link_html;
		?></div>
       </div>
       </div> 
		<?php // Continue and Checkout Button END ?>
		<input type='hidden' name='order_language' value='<?php echo $this->order_language; ?>'/>
		<input type='hidden' name='task' value='updatecart'/>
		<input type='hidden' name='option' value='com_virtuemart'/>
		<input type='hidden' name='view' value='cart'/>
</form>