SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;


DROP TABLE IF EXISTS `#__action_logs`;
CREATE TABLE IF NOT EXISTS `#__action_logs` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__action_logs_extensions`;
CREATE TABLE IF NOT EXISTS `#__action_logs_extensions` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__action_logs_extensions` (`id`, `extension`) VALUES
(1, 'com_banners'),
(2, 'com_cache'),
(3, 'com_categories'),
(4, 'com_config'),
(5, 'com_contact'),
(6, 'com_content'),
(7, 'com_installer'),
(8, 'com_media'),
(9, 'com_menus'),
(10, 'com_messages'),
(11, 'com_modules'),
(12, 'com_newsfeeds'),
(13, 'com_plugins'),
(14, 'com_redirect'),
(15, 'com_tags'),
(16, 'com_templates'),
(17, 'com_users'),
(18, 'com_checkin');

DROP TABLE IF EXISTS `#__action_logs_users`;
CREATE TABLE IF NOT EXISTS `#__action_logs_users` (
  `user_id` int(11) UNSIGNED NOT NULL,
  `notify` tinyint(1) UNSIGNED NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__action_log_config`;
CREATE TABLE IF NOT EXISTS `#__action_log_config` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `#__action_log_config` (`id`, `type_title`, `type_alias`, `id_holder`, `title_holder`, `table_name`, `text_prefix`) VALUES
(1, 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(2, 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(3, 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
(4, 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
(5, 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(6, 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
(7, 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
(8, 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
(9, 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
(10, 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
(11, 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
(12, 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
(13, 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
(14, 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(15, 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
(16, 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
(17, 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
(18, 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
(19, 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA');

DROP TABLE IF EXISTS `#__acymailing_action`;
CREATE TABLE IF NOT EXISTS `#__acymailing_action` (
  `action_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `frequency` int(10) UNSIGNED NOT NULL,
  `nextdate` int(10) UNSIGNED NOT NULL,
  `server` varchar(255) NOT NULL,
  `port` varchar(50) NOT NULL,
  `connection_method` varchar(10) NOT NULL DEFAULT '0',
  `secure_method` varchar(10) NOT NULL DEFAULT '0',
  `self_signed` tinyint(4) NOT NULL DEFAULT 0,
  `username` varchar(255) NOT NULL,
  `password` varchar(50) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `conditions` text DEFAULT NULL,
  `actions` text DEFAULT NULL,
  `report` text DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `ordering` smallint(5) UNSIGNED DEFAULT 0,
  `delete_wrong_emails` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_config`;
CREATE TABLE IF NOT EXISTS `#__acymailing_config` (
  `namekey` varchar(200) NOT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`namekey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_config` (`namekey`, `value`) VALUES
('level', 'Starter'),
('version', '5.10.4'),
('from_name', 't3_thema1'),
('from_email', 'admin@admin.com'),
('mailer_method', 'phpmail'),
('sendmail_path', '/usr/sbin/sendmail'),
('smtp_secured', ''),
('smtp_auth', '0'),
('smtp_username', ''),
('smtp_password', ''),
('reply_name', 't3_thema1'),
('reply_email', 'admin@admin.com'),
('cron_sendto', 'admin@admin.com'),
('bounce_email', ''),
('add_names', '1'),
('encoding_format', '8bit'),
('charset', 'UTF-8'),
('word_wrapping', '150'),
('hostname', ''),
('embed_images', '0'),
('embed_files', '1'),
('editor', '0'),
('multiple_part', '1'),
('smtp_host', 'localhost'),
('smtp_port', ''),
('queue_nbmail', '40'),
('queue_nbmail_auto', '70'),
('queue_type', 'auto'),
('queue_try', '3'),
('queue_pause', '120'),
('allow_visitor', '1'),
('require_confirmation', '0'),
('priority_newsletter', '3'),
('allowedfiles', 'zip,doc,docx,pdf,xls,txt,gzip,rar,jpg,gif,xlsx,pps,csv,bmp,ico,odg,odp,ods,odt,png,ppt,swf,xcf,mp3,wma'),
('uploadfolder', 'media/com_acymailing/upload'),
('confirm_redirect', ''),
('subscription_message', '1'),
('notification_unsuball', ''),
('cron_next', '1251990901'),
('confirmation_message', '1'),
('welcome_message', '1'),
('unsub_message', '1'),
('cron_last', '0'),
('cron_fromip', ''),
('cron_report', ''),
('cron_frequency', '900'),
('cron_sendreport', '2'),
('cron_fullreport', '1'),
('cron_savereport', '2'),
('cron_savepath', 'media/com_acymailing/logs/report{year}_{month}.log'),
('notification_created', ''),
('notification_accept', ''),
('notification_refuse', ''),
('forward', '0'),
('description_starter', 'Joomla!™ Newsletter System'),
('description_essential', 'Joomla!™ Newsletter System'),
('description_business', 'Joomla!™ Newsletter System'),
('description_enterprise', 'Joomla!™ Mailing Extension'),
('priority_followup', '2'),
('unsub_redirect', ''),
('show_footer', '1'),
('use_sef', '0'),
('itemid', '0'),
('css_module', 'default'),
('css_frontend', 'default'),
('css_backend', ''),
('menu_position', 'above'),
('unsub_reasons', 'a:2:{i:0;s:21:\"UNSUB_SURVEY_FREQUENT\";i:1;s:21:\"UNSUB_SURVEY_RELEVANT\";}'),
('installcomplete', '1'),
('Starter', '0'),
('Essential', '1'),
('Business', '2'),
('Enterprise', '3'),
('website', 'http://localhost/reviver/theme_4_6/'),
('module_redirect', ''),
('trackingsystem', 'acymailing'),
('acl_newsletters_lists', 'all'),
('acl_newsletters_attachments', 'all'),
('acl_newsletters_sender_informations', 'all'),
('acl_newsletters_meta_data', 'all'),
('bootstrap_frontend', '0'),
('acl_newsletters_abtesting', 'all'),
('max_execution_time', '0'),
('security_key', 'CzB2beKaA28aaze0KZNmv3WkyqdG7E'),
('captcha_plugin', 'no'),
('description_sidekick', 'Joomla!® Mailing Extension'),
('Sidekick', '4'),
('latestversion', '5.10.4'),
('expirationdate', '0'),
('lastlicensecheck', '1539445301'),
('export_excelsecurity', '1'),
('pluginNeedUpdate', '[\"10211\"]'),
('gdpr_export', '0'),
('anonymous_tracking', '0'),
('anonymizeold', '1'),
('last_maxexec_check', '1532629855'),
('smtp_keepalive', '1'),
('elasticemail_username', ''),
('elasticemail_password', ''),
('elasticemail_port', 'rest'),
('special_chars', '0'),
('ssl_links', '0'),
('bounce_action_maxtry', 'noaction'),
('bounce_action_lists_maxtry', '1'),
('sendorder', 'subid, ASC'),
('autosub', 'None'),
('allow_modif', 'data'),
('generate_name', '1'),
('notification_unsub', ''),
('notification_contact', ''),
('notification_contact_menu', ''),
('notification_confirm', ''),
('sub_redirect', ''),
('modif_redirect', ''),
('redirect_tags', '0'),
('unsubscription_message', '1'),
('confirm_message', '0'),
('comments_feature', ''),
('disqus_shortname', ''),
('frontend_subject', '1'),
('frontend_print', '0'),
('show_description', '1'),
('show_filter', '1'),
('show_order', '1'),
('show_senddate', '1'),
('open_popup', '1'),
('popup_width', '750'),
('popup_height', '550'),
('indexFollow', '1'),
('unsub_intro', 'UNSUB_INTRO'),
('unsub_dispoptions', '1'),
('unsub_dispothersubs', '0'),
('unsub_survey', '1'),
('acyrss_format', ''),
('acyrss_name', ''),
('acyrss_description', ''),
('acyrss_element', '20'),
('acyrss_order', 'senddate'),
('gdpr_delete', '0'),
('email_checkdomain', '0'),
('email_botscout', '0'),
('email_botscout_key', ''),
('email_stopforumspam', '0'),
('email_iptimecheck', '0'),
('mediafolder', 'media/com_acymailing/upload');

DROP TABLE IF EXISTS `#__acymailing_fields`;
CREATE TABLE IF NOT EXISTS `#__acymailing_fields` (
  `fieldid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `fieldname` varchar(250) NOT NULL,
  `namekey` varchar(50) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `value` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `ordering` smallint(5) UNSIGNED DEFAULT 99,
  `options` text DEFAULT NULL,
  `core` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `required` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `backend` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `frontcomp` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `default` text DEFAULT NULL,
  `listing` tinyint(3) UNSIGNED DEFAULT NULL,
  `frontlisting` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `frontjoomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `frontjoomlaregistration` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `joomlaprofile` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `fieldcat` int(11) NOT NULL DEFAULT 0,
  `listingfilter` tinyint(4) DEFAULT NULL,
  `frontlistingfilter` tinyint(4) DEFAULT NULL,
  `frontform` tinyint(4) DEFAULT 1,
  PRIMARY KEY (`fieldid`),
  UNIQUE KEY `namekey` (`namekey`),
  KEY `orderingindex` (`published`,`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_fields` (`fieldid`, `fieldname`, `namekey`, `type`, `value`, `published`, `ordering`, `options`, `core`, `required`, `backend`, `frontcomp`, `default`, `listing`, `frontlisting`, `frontjoomlaprofile`, `frontjoomlaregistration`, `joomlaprofile`, `access`, `fieldcat`, `listingfilter`, `frontlistingfilter`, `frontform`) VALUES
(1, 'NAMECAPTION', 'name', 'text', '', 1, 1, '', 1, 0, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, NULL, NULL, 1),
(2, 'EMAILCAPTION', 'email', 'text', '', 1, 2, '', 1, 1, 1, 1, '', 1, 1, 0, 0, 0, 'all', 0, NULL, NULL, 1),
(3, 'RECEIVE', 'html', 'radio', '0::JOOMEXT_TEXT\n1::HTML', 1, 3, '', 1, 1, 1, 1, '1', 1, 1, 0, 0, 0, 'all', 0, NULL, NULL, 1);

DROP TABLE IF EXISTS `#__acymailing_filter`;
CREATE TABLE IF NOT EXISTS `#__acymailing_filter` (
  `filid` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `published` tinyint(3) UNSIGNED DEFAULT NULL,
  `lasttime` int(10) UNSIGNED DEFAULT NULL,
  `trigger` text DEFAULT NULL,
  `report` text DEFAULT NULL,
  `action` text DEFAULT NULL,
  `filter` text DEFAULT NULL,
  `daycron` int(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (`filid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_forward`;
CREATE TABLE IF NOT EXISTS `#__acymailing_forward` (
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `nbforwarded` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`subid`,`mailid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_geolocation`;
CREATE TABLE IF NOT EXISTS `#__acymailing_geolocation` (
  `geolocation_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `geolocation_subid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `geolocation_type` varchar(255) NOT NULL DEFAULT 'subscription',
  `geolocation_ip` varchar(255) NOT NULL DEFAULT '',
  `geolocation_created` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `geolocation_latitude` decimal(9,6) NOT NULL DEFAULT 0.000000,
  `geolocation_longitude` decimal(9,6) NOT NULL DEFAULT 0.000000,
  `geolocation_postal_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country` varchar(255) NOT NULL DEFAULT '',
  `geolocation_country_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state` varchar(255) NOT NULL DEFAULT '',
  `geolocation_state_code` varchar(255) NOT NULL DEFAULT '',
  `geolocation_city` varchar(255) NOT NULL DEFAULT '',
  `geolocation_continent` varchar(255) NOT NULL DEFAULT '',
  `geolocation_timezone` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`geolocation_id`),
  KEY `geolocation_type` (`geolocation_subid`,`geolocation_type`),
  KEY `geolocation_ip_created` (`geolocation_ip`,`geolocation_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_history`;
CREATE TABLE IF NOT EXISTS `#__acymailing_history` (
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `action` varchar(50) NOT NULL COMMENT 'different actions: created,modified,confirmed',
  `data` text DEFAULT NULL,
  `source` text DEFAULT NULL,
  `mailid` mediumint(8) UNSIGNED DEFAULT NULL,
  KEY `subid` (`subid`,`date`),
  KEY `dateindex` (`date`),
  KEY `actionindex` (`action`,`mailid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_list`;
CREATE TABLE IF NOT EXISTS `#__acymailing_list` (
  `name` varchar(250) NOT NULL,
  `description` text DEFAULT NULL,
  `ordering` smallint(5) UNSIGNED DEFAULT 0,
  `listid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `published` tinyint(4) DEFAULT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `color` varchar(30) DEFAULT NULL,
  `visible` tinyint(4) NOT NULL DEFAULT 1,
  `welmailid` mediumint(9) DEFAULT NULL,
  `unsubmailid` mediumint(9) DEFAULT NULL,
  `type` enum('list','campaign') NOT NULL DEFAULT 'list',
  `access_sub` varchar(250) DEFAULT 'all',
  `access_manage` varchar(250) NOT NULL DEFAULT 'none',
  `languages` varchar(250) NOT NULL DEFAULT 'all',
  `startrule` varchar(50) NOT NULL DEFAULT '0',
  `category` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`listid`),
  KEY `typeorderingindex` (`type`,`ordering`),
  KEY `useridindex` (`userid`),
  KEY `typeuseridindex` (`type`,`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_list` (`name`, `description`, `ordering`, `listid`, `published`, `userid`, `alias`, `color`, `visible`, `welmailid`, `unsubmailid`, `type`, `access_sub`, `access_manage`, `languages`, `startrule`, `category`) VALUES
('Newsletters', 'Receive our latest news', 1, 1, 1, 0, 'mailing_list', '#3366ff', 1, NULL, NULL, 'list', 'all', 'none', 'all', '0', '');

DROP TABLE IF EXISTS `#__acymailing_listcampaign`;
CREATE TABLE IF NOT EXISTS `#__acymailing_listcampaign` (
  `campaignid` smallint(5) UNSIGNED NOT NULL,
  `listid` smallint(5) UNSIGNED NOT NULL,
  PRIMARY KEY (`campaignid`,`listid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_listmail`;
CREATE TABLE IF NOT EXISTS `#__acymailing_listmail` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  PRIMARY KEY (`listid`,`mailid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_listsub`;
CREATE TABLE IF NOT EXISTS `#__acymailing_listsub` (
  `listid` smallint(5) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `subdate` int(10) UNSIGNED DEFAULT NULL,
  `unsubdate` int(10) UNSIGNED DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  PRIMARY KEY (`listid`,`subid`),
  KEY `subidindex` (`subid`),
  KEY `listidstatusindex` (`listid`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_listsub` (`listid`, `subid`, `subdate`, `unsubdate`, `status`) VALUES
(1, 1, 1364142332, NULL, 1),
(1, 16, 1389520468, NULL, 1);

DROP TABLE IF EXISTS `#__acymailing_mail`;
CREATE TABLE IF NOT EXISTS `#__acymailing_mail` (
  `mailid` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `subject` text DEFAULT NULL,
  `body` longtext NOT NULL,
  `altbody` longtext NOT NULL,
  `published` tinyint(4) DEFAULT 1,
  `senddate` int(10) UNSIGNED DEFAULT NULL,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `type` enum('news','autonews','followup','unsub','welcome','notification','joomlanotification','action','article') NOT NULL DEFAULT 'news',
  `visible` tinyint(4) NOT NULL DEFAULT 1,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  `alias` varchar(250) DEFAULT NULL,
  `attach` text DEFAULT NULL,
  `html` tinyint(4) NOT NULL DEFAULT 1,
  `tempid` smallint(6) NOT NULL DEFAULT 0,
  `key` varchar(200) DEFAULT NULL,
  `frequency` varchar(50) DEFAULT NULL,
  `params` text DEFAULT NULL,
  `sentby` int(10) UNSIGNED DEFAULT NULL,
  `metakey` text DEFAULT NULL,
  `metadesc` text DEFAULT NULL,
  `filter` text DEFAULT NULL,
  `language` varchar(50) NOT NULL DEFAULT '',
  `abtesting` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `summary` text NOT NULL,
  `favicon` text DEFAULT NULL,
  `bccaddresses` varchar(250) DEFAULT NULL,
  `lastupdate` int(10) UNSIGNED DEFAULT NULL,
  `userlastupdate` int(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (`mailid`),
  KEY `senddate` (`senddate`),
  KEY `typemailidindex` (`type`,`mailid`),
  KEY `useridindex` (`userid`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_mail` (`mailid`, `subject`, `body`, `altbody`, `published`, `senddate`, `created`, `fromname`, `fromemail`, `replyname`, `replyemail`, `type`, `visible`, `userid`, `alias`, `attach`, `html`, `tempid`, `key`, `frequency`, `params`, `sentby`, `metakey`, `metadesc`, `filter`, `language`, `abtesting`, `thumb`, `summary`, `favicon`, `bccaddresses`, `lastupdate`, `userlastupdate`) VALUES
(1, 'New Subscriber on your website : {user:email}', '<p>Hello {subtag:name},</p><p>A new user has been created in AcyMailing : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_created', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(2, 'A User unsubscribed from all your lists : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from all your lists</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsuball', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(3, 'A User unsubscribed : {user:email}', '<p>Hello {subtag:name},</p><p>The user {user:name} : {user:email} unsubscribed from your list</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_unsub', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(4, 'A User refuses to receive e-mails from your website : {user:email}', '<p>The User {user:name} : {user:email} refuses to receive any e-mail anymore from your website.</p><p>Subscription : {user:subscription}</p><p>{survey}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_refuse', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(5, '{subtag:name|ucfirst}, {trans:PLEASE_CONFIRM_SUB}', '<div style=\"text-align: center; width: 100%; background-color: #ffffff;\">\r\n			<table style=\"text-align:justify; margin:auto; background-color:#ebebeb; border:1px solid #e7e7e7\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"600\" align=\"center\" bgcolor=\"#ebebeb\">\r\n			<tbody>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"38px\"><img src=\"media/com_acymailing/templates/newsletter-4/images/top.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			<tr>\r\n			<td style=\"text-align:center\" width=\"600\">\r\n			<table style=\"margin:auto;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"520\">\r\n			<tbody>\r\n			<tr>\r\n			<td style=\"background-color: #ffffff; border: 1px solid #dbdbdb; padding: 20px; width: 500px; margin: 15px auto; text-align: left;\">\r\n			<h1>Hello {subtag:name|ucfirst},</h1>\r\n			<p>{trans:CONFIRM_MSG}<br /><br />{trans:CONFIRM_MSG_ACTIVATE}</p>\r\n			<br />\r\n			<p style=\"text-align:center;\"><strong>{confirm}{trans:CONFIRM_SUBSCRIPTION}{/confirm}</strong></p>\r\n			</td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</td>\r\n			</tr>\r\n			<tr style=\"line-height: 0px;\">\r\n			<td style=\"line-height: 0px;\" height=\"40px\"><img src=\"media/com_acymailing/templates/newsletter-4/images/bottom.png\" border=\"0\" alt=\" - - - \" /></td>\r\n			</tr>\r\n			</tbody>\r\n			</table>\r\n			</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'confirmation', NULL, 1, 1, NULL, NULL, 'a:3:{s:6:\"action\";s:7:\"confirm\";s:13:\"actionbtntext\";s:28:\"{trans:CONFIRM_SUBSCRIPTION}\";s:9:\"actionurl\";s:19:\"{confirm}{/confirm}\";}', NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(6, 'AcyMailing Cron Report {mainreport}', '<p>{report}</p><p>{detailreport}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'report', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(7, 'A Newsletter has been generated : \"{subject}\"', '<p>The Newsletter issue {issuenb} has been generated : </p><p>Subject : {subject}</p><p>{body}</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_autonews', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(8, 'Modify your subscription', '<p>Hello {subtag:name}, </p><p>You requested some changes on your subscription,</p><p>Please {modify}click here{/modify} to be identified as the owner of this account and then modify your subscription.</p>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'modif', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(9, 'New contact from your website : {user:email}', '<p>Hello {subtag:name},</p><p>A user has contacted you : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(10, 'A user confirm his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user has confirmed his subscription in AcyMailing : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_confirm', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(11, 'A user subscribed or modified his subscription : {user:email}', '<p>Hello {subtag:name},</p><p>A user submitted the form : </p><blockquote><p>Name : {user:name}</p><p>Email : {user:email}</p><p>IP : {user:ip} </p><p>Subscription : {user:subscription}</p></blockquote>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'notification', 0, NULL, 'notification_contact_menu', NULL, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL),
(12, '{joomlacontent:current| type:title}', '<div style=\"text-align: center; width: 100%; background-color:#ffffff;\">\r\n		<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"text-align: justify; margin: auto; width: 600px;\">\r\n			<tbody>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_2\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #69b4c0;\" valign=\"bottom\" width=\"600\" id=\"zone_3\"><img id=\"zone_29\" alt=\" - - - \" border=\"0\" src=\"http://localhost/reviver/theme_4_2//media/com_acymailing/templates/newsletter-4/images/top.png\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_4\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_5\"></td>\r\n					<td class=\"w520 acyeditor_text\" colspan=\"3\" height=\"80\" style=\"text-align: left; background-color: #ebebeb;\" width=\"520\" id=\"zone_6\"><strong>​</strong>​​​​​​​​<img alt=\"-\" border=\"0\" src=\"http://localhost/reviver/theme_4_2//media/com_acymailing/templates/newsletter-4/images/message_icon.png\" style=\"float: left; margin-right: 10px;\">\r\n						<h3>{joomlacontent:current| type:title}<span style=\"display: none;\">&nbsp;</span></h3>\r\n					</td>\r\n					<td class=\"acyeditor_picture w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_7\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_8\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_9\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_10\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_11\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_12\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_13\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_14\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_15\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_16\"></td>\r\n					<td class=\"w480 pict acyeditor_text\" style=\"background-color: #fff; text-align: left;\" width=\"480\" id=\"zone_17\">{joomlacontent:current| type:intro| format:TOP_LEFT| pict:1| link}</td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_18\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_19\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" id=\"zone_20\">\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_21\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_22\"></td>\r\n					<td class=\"w480\" height=\"20\" style=\"background-color: #fff;\" width=\"480\" id=\"zone_23\"></td>\r\n					<td class=\"w20\" style=\"background-color: #fff;\" width=\"20\" id=\"zone_24\"></td>\r\n					<td class=\"w40\" style=\"background-color: #ebebeb;\" width=\"40\" id=\"zone_25\"></td>\r\n				</tr>\r\n				<tr class=\"acyeditor_delete\" style=\"line-height: 0px;\" id=\"zone_26\">\r\n					<td class=\"w600\" colspan=\"5\" style=\"background-color: #ebebeb;\" width=\"600\" id=\"zone_27\"><img id=\"zone_31\" alt=\" - - - \" border=\"0\" src=\"http://localhost/reviver/theme_4_2//media/com_acymailing/templates/newsletter-4/images/bottom.png\"></td>\r\n				</tr>\r\n			</tbody>\r\n		</table>\r\n		</div>', '', 1, NULL, NULL, NULL, NULL, NULL, NULL, 'article', 0, NULL, 'send-in-article', NULL, 1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', NULL, NULL, NULL, NULL);

DROP TABLE IF EXISTS `#__acymailing_queue`;
CREATE TABLE IF NOT EXISTS `#__acymailing_queue` (
  `senddate` int(10) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `priority` tinyint(3) UNSIGNED DEFAULT 3,
  `try` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `paramqueue` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`subid`,`mailid`),
  KEY `listingindex` (`senddate`,`subid`),
  KEY `mailidindex` (`mailid`),
  KEY `orderingindex` (`priority`,`senddate`,`subid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_rules`;
CREATE TABLE IF NOT EXISTS `#__acymailing_rules` (
  `ruleid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `ordering` smallint(6) DEFAULT NULL,
  `regex` text NOT NULL,
  `executed_on` text NOT NULL,
  `action_message` text NOT NULL,
  `action_user` text NOT NULL,
  `published` tinyint(3) UNSIGNED NOT NULL,
  PRIMARY KEY (`ruleid`),
  KEY `ordering` (`published`,`ordering`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_stats`;
CREATE TABLE IF NOT EXISTS `#__acymailing_stats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `senthtml` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `senttext` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `senddate` int(10) UNSIGNED NOT NULL,
  `openunique` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `opentotal` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `bounceunique` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `fail` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `clicktotal` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `clickunique` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `unsub` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `forward` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `bouncedetails` text DEFAULT NULL,
  PRIMARY KEY (`mailid`),
  KEY `senddateindex` (`senddate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_subscriber`;
CREATE TABLE IF NOT EXISTS `#__acymailing_subscriber` (
  `subid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `email` varchar(200) NOT NULL,
  `userid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `name` varchar(250) NOT NULL,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `confirmed` tinyint(4) NOT NULL DEFAULT 0,
  `enabled` tinyint(4) NOT NULL DEFAULT 1,
  `accept` tinyint(4) NOT NULL DEFAULT 1,
  `ip` varchar(100) DEFAULT NULL,
  `html` tinyint(4) NOT NULL DEFAULT 1,
  `key` varchar(250) DEFAULT NULL,
  `confirmed_date` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `confirmed_ip` varchar(100) DEFAULT NULL,
  `lastopen_date` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lastclick_date` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lastopen_ip` varchar(100) DEFAULT NULL,
  `lastsent_date` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `source` varchar(50) NOT NULL DEFAULT '',
  `filterflags` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`subid`),
  UNIQUE KEY `email` (`email`),
  KEY `userid` (`userid`),
  KEY `queueindex` (`enabled`,`accept`,`confirmed`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_subscriber` (`subid`, `email`, `userid`, `name`, `created`, `confirmed`, `enabled`, `accept`, `ip`, `html`, `key`, `confirmed_date`, `confirmed_ip`, `lastopen_date`, `lastclick_date`, `lastopen_ip`, `lastsent_date`, `source`, `filterflags`) VALUES
(40, 'test@test.com', 372, 'test', 1539456003, 0, 0, 1, '127.0.0.1', 1, '44trPwVOlIdGoO', 0, NULL, 0, 0, NULL, 0, 'joomla', '');

DROP TABLE IF EXISTS `#__acymailing_tag`;
CREATE TABLE IF NOT EXISTS `#__acymailing_tag` (
  `tagid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `userid` int(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY (`tagid`),
  KEY `useridindex` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_tagmail`;
CREATE TABLE IF NOT EXISTS `#__acymailing_tagmail` (
  `tagid` smallint(5) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  PRIMARY KEY (`tagid`,`mailid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_template`;
CREATE TABLE IF NOT EXISTS `#__acymailing_template` (
  `tempid` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `body` longtext DEFAULT NULL,
  `altbody` longtext DEFAULT NULL,
  `created` int(10) UNSIGNED DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `premium` tinyint(4) NOT NULL DEFAULT 0,
  `ordering` smallint(5) UNSIGNED DEFAULT 0,
  `namekey` varchar(50) NOT NULL,
  `styles` text DEFAULT NULL,
  `subject` varchar(250) DEFAULT NULL,
  `stylesheet` text DEFAULT NULL,
  `fromname` varchar(250) DEFAULT NULL,
  `fromemail` varchar(250) DEFAULT NULL,
  `replyname` varchar(250) DEFAULT NULL,
  `replyemail` varchar(250) DEFAULT NULL,
  `thumb` varchar(250) DEFAULT NULL,
  `readmore` varchar(250) DEFAULT NULL,
  `access` varchar(250) NOT NULL DEFAULT 'all',
  `category` varchar(250) NOT NULL DEFAULT '',
  `header` longtext DEFAULT NULL,
  PRIMARY KEY (`tempid`),
  UNIQUE KEY `namekey` (`namekey`),
  KEY `orderingindex` (`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `#__acymailing_template` (`tempid`, `name`, `description`, `body`, `altbody`, `created`, `published`, `premium`, `ordering`, `namekey`, `styles`, `subject`, `stylesheet`, `fromname`, `fromemail`, `replyname`, `replyemail`, `thumb`, `readmore`, `access`, `category`, `header`) VALUES
(1, 'Notification template', '', '<div style=\"text-align:center; width:100%; background-color:#fff;\">\r\n	<div class=\"info acyeditor_delete acyeditor_text\">{readonline}This email contains graphics, so if you don\'t see them,view it in your browser{/readonline}</div>\r\n	<table width=\"600\" bgcolor=\"#ebebeb\" cellpadding=\"0\" cellspacing=\"0\" style=\"text-align:justify; margin:auto; background-color:#ebebeb; border:1px solid #e7e7e7\" align=\"center\">\r\n		<tr>\r\n			<td height=\"38px\" style=\"background-color:#69b4c0\" valign=\"bottom\">\r\n				<img src=\"media/com_acymailing/templates/newsletter-4/top.png\" alt=\" - - - \"/>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td width=\"600\" style=\"text-align:center\">\r\n				<table width=\"600\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"margin:auto;\">\r\n					<tr class=\"acyeditor_delete\">\r\n						<td width=\"40\" style=\"background-color:#ebebeb\"></td>\r\n						<td class=\"acyeditor_text\" width=\"520\" style=\"padding:20px 0px; text-align:left; background-color:#ebebeb\">\r\n									<img src=\"media/com_acymailing/templates/newsletter-4/message_icon.png\" alt=\"-\" style=\"float:left; margin:0px; margin-right:20px;\"/>\r\n							<h3>Topic of your message</h3>\r\n							<h4>Subtitle for your message</h4>\r\n						</td>\r\n						<td width=\"40\" style=\"background-color:#ebebeb\"></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td width=\"40\" style=\"background-color:#ebebeb\"></td>\r\n						<td width=\"520\" class=\"acyeditor_text\" style=\"background-color:#fff; border:1px solid #dbdbdb; padding:20px; width:500px; margin:auto; margin-top:15px; margin-bottom:15px;text-align:left\">\r\n							<h1>Dear {subtag:name},</h1>Your message here...\r\n						</td>\r\n						<td width=\"40\" style=\"background-color:#ebebeb\"></td>\r\n					</tr>\r\n				</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\"40px\" valign=\"bottom\" style=\"background-color:#ebebeb\">\r\n				<img src=\"media/com_acymailing/templates/newsletter-4/bottom.png\" alt=\"---\" />\r\n			</td>\r\n		</tr>\r\n	 </table>\r\n	 <div class=\"info acyeditor_delete acyeditor_text\">Not interested any more? {unsubscribe}Unsubscribe{/unsubscribe}</div>\r\n</div>', '', NULL, 1, 0, 1, 'newsletter-4', 'a:10:{s:6:\"tag_h1\";s:76:\"color:#393939 !important; font-size:14px; font-weight:bold; margin:10px 0px;\";s:6:\"tag_h2\";s:106:\"color: #309fb3 !important; font-size: 14px; font-weight: normal; text-align:left; margin:0px; padding:0px;\";s:6:\"tag_h3\";s:144:\"color: #393939 !important; font-size: 18px; font-weight: bold; text-align:left; margin:0px; padding-bottom:5px; border-bottom:1px solid #bdbdbd;\";s:6:\"tag_h4\";s:117:\"color: #309fb3 !important; font-size: 14px; font-weight: bold; text-align:left; margin:0px; padding: 5px 0px 0px 0px;\";s:5:\"tag_a\";s:71:\"color:#309FB3; text-decoration:none; font-style:italic; cursor:pointer;\";s:19:\"acymailing_readmore\";s:90:\"font-size: 12px; color: #fff; background-color:#309fb3; font-weight:bold; padding:3px 5px;\";s:17:\"acymailing_online\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:16:\"acymailing_unsub\";s:52:\"color:#a3a3a3; text-decoration:none; font-size:11px;\";s:8:\"color_bg\";s:7:\"#ffffff\";s:18:\"acymailing_content\";s:19:\"text-align:justify;\";}', NULL, 'div,table,p, td{font-family: Verdana, Arial, Helvetica, sans-serif; font-size:12px; text-align:justify; color:#8c8c8c; margin:0px}\r\ndiv.info{text-align:center;padding:10px;font-size:11px;color:#a3a3a3;}', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-4/newsletter-4.png', '', 'all', '', NULL),
(2, 'Newspaper', '', '\r\n<div style=\"width:100%; background-color:#454545; padding-bottom:20px; color:#ffffff;\" align=\"center\">\r\n	<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>»view it online.</strong>{/readonline}</div>\r\n\r\n	 <table width=\"600\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"margin:auto; background-color:#ffffff; color:#454545;\">\r\n		<tr>\r\n			<td>\r\n				<table width=\"600\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n					<tr class=\"acyeditor_delete\">\r\n						<td width=\"30\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n						<td class=\"acyeditor_text\" width=\"386\" style=\"font-family:Times New Roman, Times, serif; background-color:#ffffff\"><h1>Your e-mail title</h1> <br/> <h3>Subtitle</h3></td>\r\n						<td class=\"acyeditor_picture\" width=\"184\" style=\"line-height:0px; background-color:#ffffff\"><img src=\"media/com_acymailing/templates/newsletter-5/logo.png\" height=\"96\" width=\"184\" alt=\"logo\" /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td colspan=\"3\" width=\"600\" height=\"31\" valign=\"top\" style=\"line-height:0px; background-color:#e4e4e4\"><img src=\"media/com_acymailing/templates/newsletter-5/header.png\" width=\"600\" height=\"31\" alt=\"---\" /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"acyeditor_picture\" colspan=\"3\" width=\"600\" height=\"31\" valign=\"top\" style=\"line-height:0px; background-color:#ffffff\"><img src=\"media/com_acymailing/templates/newsletter-5/banner.png\" width=\"600\" height=\"217\" alt=\"banner\" /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td colspan=\"3\" width=\"600\" height=\"31\" valign=\"top\" style=\"line-height:0px;\"><img src=\"media/com_acymailing/templates/newsletter-5/separator.png\" height=\"21\" width=\"600\" alt=\"---\" /></td>\r\n					</tr>\r\n				</table>\r\n			</td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td>\r\n				<table width=\"600\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n					<tr>\r\n						<td width=\"30\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n						<td class=\"acyeditor_text\" width=\"540\" style=\"text-align:justify; color:#575757; font-family:Times New Roman, Times, serif; font-size:13px; background-color:#ffffff\">\r\n							<h2>Interviews and reports</h2>\r\n							<span class=\"dark\">Lorem ipsum dolor sit amet, consectLorem ipsum dolor sit amet.</span><br/>\r\n							consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum.ed elementum convallis mi. <a href=\"#\">Vivamus elementum</a>.Lorem ipsum dolor sit amet.<br/> <br/>\r\n							cLorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum. <br /><br />\r\n							<span class=\"acymailing_readmore\">Read More</span>\r\n							<br /><br />\r\n\r\n							<h2>Journalism around the world</h2> <span class=\"dark\">Lorem ipsum dolor sit amet, consectLorem. consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum.</span> consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum.ed elementum convallis mi. <br /><br />Vivamus elementum.<a href=\"#\">Lorem ipsum dolor</a> sit amet.Lorem ipsum dolor sit amet, consectetur adipiscing elit. <br /><br />\r\n							<span class=\"acymailing_readmore\">Read More</span>\r\n						</td>\r\n						<td width=\"30\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n					</tr>\r\n				</table>\r\n			</td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td>\r\n				<table width=\"600\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n					<tr>\r\n						<td width=\"600\" height=\"14\" style=\"background-color:#ffffff\"><img src=\"media/com_acymailing/templates/newsletter-5/footer1.png\" width=\"600\" height=\"14\" alt=\"--\" /></td>\r\n					</tr>\r\n					<tr>\r\n						<td width=\"600\" style=\"text-align:center; background-color:#ebebeb;  color:#454545; font-family:Times New Roman, Times, serif; font-size:13px\" height=\"25\" class=\"acyfooter acyeditor_text\"><a href=\"#\">www.mywebsite.com</a> |  <a href=\"#\">contact</a> | <a href=\"#\">Facebook</a> | <a href=\"#\">Twitter</a></td>\r\n					</tr>\r\n					<tr>\r\n						<td width=\"600\" height=\"7\" style=\"background-color:#454545;\"><img src=\"media/com_acymailing/templates/newsletter-5/footer2.png\" width=\"600\" height=\"7\" alt=\"--\" /></td>\r\n					</tr>\r\n				</table>\r\n			</td>\r\n		</tr>\r\n	</table>\r\n	<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\">{unsubscribe}If you’re not interested any more  <strong>» unsubscribe</strong>{/unsubscribe}</div>\r\n</div>\r\n', '', NULL, 1, 0, 2, 'newsletter-5', 'a:10:{s:6:\"tag_h1\";s:71:\"color:#454545 !important; font-size:24px; font-weight:bold; margin:0px;\";s:6:\"tag_h2\";s:145:\"color:#b20000 !important; font-size:18px; font-weight:bold; margin:0px; margin-bottom:10px; padding-bottom:4px; border-bottom: 1px solid #d6d6d6;\";s:6:\"tag_h3\";s:76:\"color:#b20101 !important; font-weight:bold; font-size:18px; margin:10px 0px;\";s:6:\"tag_h4\";s:67:\"color:#e52323 !important; font-weight:bold; margin:0px; padding:0px\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#9d0000; text-decoration:none; border:none;\";s:19:\"acymailing_readmore\";s:152:\"cursor:pointer; color:#ffffff; background-color:#9d0000; border-top:1px solid #9d0000; border-bottom:1px solid #9d0000; padding:3px 5px; font-size:13px;\";s:17:\"acymailing_online\";s:148:\"color:#dddddd; text-decoration:none; font-size:13px; margin:10px; text-align:center; font-family:Times New Roman, Times, serif; padding-bottom:10px;\";s:8:\"color_bg\";s:7:\"#454545\";s:18:\"acymailing_content\";s:0:\"\";s:16:\"acymailing_unsub\";s:131:\"color:#dddddd; text-decoration:none; font-size:13px; text-align:center; font-family:Times New Roman, Times, serif; padding-top:10px\";}', NULL, '.acyfooter a{\r\n	color:#454545;\r\n}\r\n.dark{\r\n	color:#454545;\r\n	font-weight:bold;\r\n}\r\ndiv,table,p, td{font-family:\"Times New Roman\", Times, serif;font-size:13px;color:#575757;}', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-5/newsletter-5.png', '', 'all', '', NULL),
(3, 'Build Bio', '', '<div style=\"width:100%; background-color:#3c3c3c; padding-bottom:20px; color:#ffffff;\" align=\"center\">\r\n	<div class=\"acymailing_online acyeditor_delete acyeditor_text\">{readonline}This e-mail contains graphics, if you don\'t see them <strong>»view it online.</strong>{/readonline}</div>\r\n	<table width=\"600\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" style=\"margin:auto; background-color:#ffffff; color:#575757;\">\r\n		<tr>\r\n			<td>\r\n				<table width=\"600\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n					<tr class=\"acyeditor_delete\">\r\n						<td colspan=\"3\" width=\"600\" height=\"41\" style=\"line-height:0px; background-color:#eeeeee\" valign=\"bottom\"><img src=\"media/com_acymailing/templates/newsletter-6/header.png\" width=\"600\" height=\"41\" alt=\"mail\"  /></td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td class=\"acyeditor_picture\" width=\"250\" height=\"122\" style=\"line-height:0px; background-color:#ffffff\"><img src=\"media/com_acymailing/templates/newsletter-6/logo.png\" width=\"250\" height=\"122\" alt=\"logo\" /></td>\r\n						<td class=\"acyeditor_picture\" width=\"328\" height=\"122\" style=\"line-height:0px; background-color:#ffffff\"><img src=\"media/com_acymailing/templates/newsletter-6/banner.png\" width=\"328\" height=\"122\" alt=\"banner\" /></td>\r\n						<td width=\"22\" height=\"122\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n					</tr>\r\n					<tr class=\"acyeditor_delete\">\r\n						<td width=\"250\" style=\"background-color:#b9cf00; color:#ffffff;\">&nbsp;</td>\r\n						<td class=\"acyeditor_text\" width=\"328\" height=\"25\" style=\"text-align:right; background-color:#b9cf00; color:#ffffff;\">Newsletter n°{mailid} - {date:3}</td>\r\n						<td width=\"22\" style=\"background-color:#b9cf00; color:#ffffff;\">&nbsp;</td>\r\n					</tr>\r\n					<tr>\r\n						<td colspan=\"3\" width=\"600\" height=\"25\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n					</tr>\r\n				</table>\r\n			</td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td>\r\n				<table width=\"600\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n					<tr>\r\n						<td width=\"30\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n						<td class=\"acyeditor_text\" width=\"540\" style=\"text-align:justify; color:#575757; background-color:#ffffff\"><span class=\"intro\">Hello {subtag:name},</span> <br/><br/>\r\n							Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum Vivamus elementum. sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi.\r\n\r\n							<h2>Day One</h2>\r\n							<strong>Lorem ipsum dolor sit amet, consectLorem ipsum dolor sit amet.</strong><br />\r\n							consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed <a href=\"#\">elementum convallis</a> mi. Vivamus elementum.ed elementum convallis mi. Vivamus elementum.Lorem ipsum dolor sit amet. <br/><br/>\r\n							cLorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum.\r\n							<br/><br/><span class=\"acymailing_readmore\">Read More</span>\r\n\r\n							<h2>How to build a green house</h2> <img src=\"media/com_acymailing/templates/newsletter-6/picture.png\" height=\"160\" width=\"193\" alt=\"picture\" style=\"float:left;\" />\r\n							<strong>Lorem ipsum dolor sit amet, elit.</strong> Aenean sollicitudin orci sit amet . Sed <a href=\"#\">elementum convallis</a> mi. Vivamus elementum.ed elementum convallis mi. Vivamus elementum.Lorem ipsum dolor sit amet. <br/><br/>\r\n							cLorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean sollicitudin orci sit amet urna lla pretium ut. Sed elementum convallis mi. Vivamus elementum.\r\n							<br/><br/><span class=\"acymailing_readmore\">Read More</span>\r\n						</td>\r\n						<td width=\"30\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n					</tr>\r\n				</table>\r\n			</td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td>\r\n				<table width=\"600\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n					<tr>\r\n						<td width=\"18\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n						<td width=\"523\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n						<td width=\"59\" style=\"background-color:#ffffff\">&nbsp;</td>\r\n					</tr>\r\n					<tr>\r\n						<td colspan=\"3\" width=\"600\" valign=\"top\" style=\"line-height:0px; background-color:#efefef;\"><img src=\"media/com_acymailing/templates/newsletter-6/footer1.png\" width=\"600\" height=\"18\" alt=\"--\"/></td>\r\n					</tr>\r\n					<tr>\r\n						<td width=\"18\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\"><img src=\"media/com_acymailing/templates/newsletter-6/footer2.png\" height=\"20\" width=\"18\" alt=\"-\" /></td>\r\n						<td width=\"523\" style=\"text-align:right; background-color:#efefef; color:#575757;\" class=\"acyfooter acyeditor_text\"><a href=\"#\">www.mywebsite.com</a> |  <a href=\"#\">Contac</a>t</td>\r\n						<td width=\"59\" height=\"20\" style=\"line-height:0px; background-color:#efefef;\"><a href=\"#\"><img src=\"media/com_acymailing/templates/newsletter-6/mail.png\" width=\"59\" height=\"20\" alt=\"message\" style=\"border:none;\" /></a></td>\r\n					</tr>\r\n					<tr>\r\n						<td colspan=\"3\" width=\"600\" valign=\"top\" style=\"background-color:#3c3c3c; line-height:0px;\"><img src=\"media/com_acymailing/templates/newsletter-6/footer4.png\" height=\"24\" width=\"600\" alt=\"--\"/></td>\r\n					</tr>\r\n				</table>\r\n			</td>\r\n		</tr>\r\n	</table>\r\n	<div class=\"acymailing_unsub acyeditor_delete acyeditor_text\">\r\n		{unsubscribe}If you’re not interested any more  <strong>» unsubscribe</strong>{/unsubscribe}\r\n	</div>\r\n</div>\r\n', '', NULL, 1, 0, 3, 'newsletter-6', 'a:9:{s:6:\"tag_h1\";s:69:\"font-weight:bold; font-size:14px;color:#3c3c3c !important;margin:0px;\";s:6:\"tag_h2\";s:129:\"color:#b9cf00 !important; font-size:14px; font-weight:bold; margin-top:20px; border-bottom:1px solid #d6d6d6; padding-bottom:4px;\";s:6:\"tag_h3\";s:149:\"color:#7e7e7e !important; font-size:14px; font-weight:bold; margin:20px 0px 0px 0px; border-bottom:1px solid #d6d6d6; padding-bottom:0px 0px 4px 0px;\";s:6:\"tag_h4\";s:84:\"color:#879700 !important; font-size:12px; font-weight:bold; margin:0px; padding:0px;\";s:8:\"color_bg\";s:7:\"#3c3c3c\";s:5:\"tag_a\";s:65:\"cursor:pointer; color:#a2b500; text-decoration:none; border:none;\";s:17:\"acymailing_online\";s:91:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-bottom:10px\";s:16:\"acymailing_unsub\";s:88:\"color:#dddddd; text-decoration:none; font-size:11px; text-align:center; padding-top:10px\";s:19:\"acymailing_readmore\";s:73:\"cursor:pointer; color:#ffffff; background-color:#b9cf00; padding:3px 5px;\";}', NULL, 'table, div, p, td{\r\n	font-family: Verdana, Arial, Helvetica, sans-serif;\r\n	font-size:11px;\r\n	color:#575757;\r\n}\r\n.intro{\r\n	font-weight:bold;\r\n	font-size:12px;}\r\n\r\n.acyfooter a{\r\n	color:#575757;}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/newsletter-6/newsletter-6.png', '', 'all', '', NULL),
(4, 'Technology', '', '<div align=\"center\" style=\"width:100%; background-color:#575757; padding-bottom:20px; color:#999999;\">\r\n<table align=\"center\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"w600\" style=\"background-color:#fff; color:#999999; margin:auto\" width=\"600\">\r\n	<tbody class=\"acyeditor_sortable\">\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_online\">{readonline}If you can\'t see this e-mail properly, <span style=\"text-decoration:underline\">view it online</span>{/readonline}</span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/technology_resp/images/shadowtop.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/technology_resp/images/top.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text links w540\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd; text-align:right; color:#ababab\" width=\"540\"><a href=\"#\"><img alt=\"mail\" src=\"media/com_acymailing/templates/technology_resp/images/mail.jpg\" style=\"float:right; border:none\" /></a> Newsletter {mailid} | {date:%B %Y} |&nbsp; <a href=\"#\">www.acyba.com</a> |</td>\r\n			<td class=\"w30\" height=\"32\" style=\"background-color:#f5f5f5; border-bottom:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540 pict\" width=\"540\"><img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic1.jpg\" style=\"float:right\" />\r\n			<h1>Fresh and technologic news !</h1>\r\n\r\n			<h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris massa quam, eleifend at ornare.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent auctor.</td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" class=\"w540\" src=\"media/com_acymailing/templates/technology_resp/images/separator1.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\">\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540 pict\" style=\"background-color:#fafafa; color:#999999\" width=\"540\">\r\n			<h2>Choose your smartphone</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic2.jpg\" style=\"float:left\" />\r\n			<h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris massa quam, eleifend at ornare.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec<a href=\"#\"> scelerisque quam</a>. Lore uctor posum ipsum dolor sit amesent auctor.<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /><br />\r\n			<br />\r\n			<br />\r\n			&nbsp;\r\n			<h2>Choose your device</h2>\r\n			<img alt=\"picture\" src=\"media/com_acymailing/templates/technology_resp/images/pic3.jpg\" style=\"float:right\" />\r\n			<h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris massa quam, eleifend at ornare.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent auctor.<br />\r\n			<br />\r\n			<img alt=\"buy this product\" src=\"media/com_acymailing/templates/technology_resp/images/buyproduct.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n			<td class=\"acyeditor_picture w540\" style=\"background-color:#fafafa; line-height:0px\" width=\"540\"><img alt=\"---\" class=\"w540\" src=\"media/com_acymailing/templates/technology_resp/images/separator2.jpg\" /></td>\r\n			<td class=\"w30\" style=\"background-color:#fafafa\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text special w540 pict\" style=\"color:#999999\" width=\"540\">\r\n			<h2>Best product of the month</h2>\r\n\r\n			<h3>Lorem ipsum dolor sit amet.</h3>\r\n			Liget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum doLiget, volutpat esvft sem. Praesent auctor posuere orci, sit amet molee. Integer nec scelerisque quam. Lore uctor posum ipsum dolor sit amesent.<br />\r\n			<br />\r\n			<img alt=\"read more\" src=\"media/com_acymailing/templates/technology_resp/images/readmore.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w600\" colspan=\"3\" height=\"16\" width=\"600\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd; text-align:right; color:#ababab\" valign=\"bottom\" width=\"540\">Follow us | <img alt=\"facebook\" src=\"media/com_acymailing/templates/technology_resp/images/facebook.jpg\" style=\"border:none\" /> <img alt=\"twitter\" src=\"media/com_acymailing/templates/technology_resp/images/twitter.jpg\" style=\"border:none\" /> <img alt=\"pinterest\" src=\"media/com_acymailing/templates/technology_resp/images/pinterest.jpg\" style=\"border:none\" /> <img alt=\"rss\" src=\"media/com_acymailing/templates/technology_resp/images/rss.jpg\" style=\"border:none\" /></td>\r\n			<td class=\"w30\" height=\"30\" style=\"background-color:#f5f5f5; border-top:1px solid #ddd\" width=\"30\"></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#f5f5f5\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/technology_resp/images/bottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"acyeditor_picture w600\" colspan=\"3\" style=\"line-height:0px; background-color:#575757\" valign=\"bottom\" width=\"600\"><img alt=\"--\" class=\"w600\" src=\"media/com_acymailing/templates/technology_resp/images/shadowbottom.jpg\" /></td>\r\n		</tr>\r\n		<tr class=\"acyeditor_delete\" >\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n			<td class=\"acyeditor_text w540\" style=\"text-align:right; color:#d2d1d1; background-color:#575757\" width=\"540\"><span class=\"acymailing_unsub\">{unsubscribe}If you don\'t want to receive our news anymore, <span style=\"text-decoration:underline\">unsubscribe</span>{/unsubscribe} </span></td>\r\n			<td class=\"w30\" style=\"background-color:#575757\" width=\"30\"></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n</div>', '', NULL, 1, 0, 5, 'technology_resp', 'a:9:{s:6:\"tag_h1\";s:104:\"font-size:20px; margin:0px; margin-bottom:15px; padding:0px; font-weight:bold; color:#01bbe5 !important;\";s:6:\"tag_h2\";s:165:\"font-size:12px; font-weight:bold; color:#565656 !important; text-transform:uppercase; margin:10px 0px; padding:0px; padding-bottom:5px; border-bottom:1px solid #ddd;\";s:6:\"tag_h3\";s:104:\"color:#565656 !important; font-weight:bold; font-size:12px; margin:0px; margin-bottom:10px; padding:0px;\";s:6:\"tag_h4\";s:0:\"\";s:8:\"color_bg\";s:7:\"#575757\";s:5:\"tag_a\";s:62:\"cursor:pointer;color:#01bbe5;text-decoration:none;border:none;\";s:17:\"acymailing_online\";s:41:\"color:#d2d1d1 !important; cursor:pointer;\";s:16:\"acymailing_unsub\";s:41:\"color:#d2d1d1 !important; cursor:pointer;\";s:19:\"acymailing_readmore\";s:88:\"cursor:pointer; font-weight:bold; color:#fff; background-color:#01bbe5; padding:2px 5px;\";}', NULL, 'table, div, p , td{\r\n	font-family:Arial, Helvetica, sans-serif;\r\n	font-size:12px;\r\n}\r\np{margin:0px; padding:0px}\r\n\r\n.special h2{font-size:18px;\r\n	margin:0px;\r\n	margin-bottom:15px;\r\n	padding:0px;\r\n	font-weight:bold;\r\n	color:#01bbe5 !important;\r\n	text-transform:none;\r\n	border:none}\r\n\r\n.links a{color:#ababab}\r\n\r\n@media (max-width:450px){\r\n	table[class=w600], td[class=w600], table[class=w540], td[class=w540], img[class=\"w600\"], img[class=\"w540\"]{ width:100% !important;}\r\n	td[class=w30] { width:20px !important;}\r\n	.pict img {max-width:260px}\r\n}\r\n\r\n@media (min-width: 450px) and (max-width: 600px){\r\n	table[class=w600], td[class=w600], table[class=w540], td[class=w540], img[class=\"w600\"], img[class=\"w540\"]{ width:100% !important;}\r\n	td[class=w30] { width:20px !important;}\r\n	.pict img {max-width:460px}\r\n}\r\n\r\n@media (min-width:600px){\r\n	body {width:600px !important; margin:auto !important;}\r\n	.pict img {max-width:540px !important;  height:auto !important;}\r\n}\r\n', NULL, NULL, NULL, NULL, 'media/com_acymailing/templates/technology_resp/thumb.jpg', '', 'all', '', NULL);

DROP TABLE IF EXISTS `#__acymailing_url`;
CREATE TABLE IF NOT EXISTS `#__acymailing_url` (
  `urlid` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`urlid`),
  KEY `url` (`url`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_urlclick`;
CREATE TABLE IF NOT EXISTS `#__acymailing_urlclick` (
  `urlid` int(10) UNSIGNED NOT NULL,
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `click` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `subid` int(10) UNSIGNED NOT NULL,
  `date` int(10) UNSIGNED NOT NULL,
  `ip` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`urlid`,`mailid`,`subid`),
  KEY `dateindex` (`date`),
  KEY `mailidindex` (`mailid`),
  KEY `subidindex` (`subid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__acymailing_userstats`;
CREATE TABLE IF NOT EXISTS `#__acymailing_userstats` (
  `mailid` mediumint(8) UNSIGNED NOT NULL,
  `subid` int(10) UNSIGNED NOT NULL,
  `html` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `sent` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `senddate` int(10) UNSIGNED NOT NULL,
  `open` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `opendate` int(11) NOT NULL,
  `bounce` tinyint(4) NOT NULL DEFAULT 0,
  `fail` tinyint(4) NOT NULL DEFAULT 0,
  `ip` varchar(100) DEFAULT NULL,
  `browser` varchar(255) DEFAULT NULL,
  `browser_version` tinyint(3) UNSIGNED DEFAULT NULL,
  `is_mobile` tinyint(3) UNSIGNED DEFAULT NULL,
  `mobile_os` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `bouncerule` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`mailid`,`subid`),
  KEY `senddateindex` (`senddate`),
  KEY `subidindex` (`subid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__akeeba_common`;
CREATE TABLE IF NOT EXISTS `#__akeeba_common` (
  `key` varchar(255) NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__ak_profiles`;
CREATE TABLE IF NOT EXISTS `#__ak_profiles` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `configuration` longtext DEFAULT NULL,
  `filters` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__ak_profiles` (`id`, `description`, `configuration`, `filters`) VALUES
(1, 'Default Backup Profile', '', '');

DROP TABLE IF EXISTS `#__ak_stats`;
CREATE TABLE IF NOT EXISTS `#__ak_stats` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `comment` longtext DEFAULT NULL,
  `backupstart` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `backupend` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` enum('run','fail','complete') NOT NULL DEFAULT 'run',
  `origin` varchar(30) NOT NULL DEFAULT 'backend',
  `type` varchar(30) NOT NULL DEFAULT 'full',
  `profile_id` bigint(20) NOT NULL DEFAULT 1,
  `archivename` longtext DEFAULT NULL,
  `absolute_path` longtext DEFAULT NULL,
  `multipart` int(11) NOT NULL DEFAULT 0,
  `tag` varchar(255) DEFAULT NULL,
  `backupid` varchar(255) DEFAULT NULL,
  `filesexist` tinyint(3) NOT NULL DEFAULT 1,
  `remote_filename` varchar(1000) DEFAULT NULL,
  `total_size` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__ak_storage`;
CREATE TABLE IF NOT EXISTS `#__ak_storage` (
  `tag` varchar(255) NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `level` int(10) UNSIGNED NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 193, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 8, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(4, 1, 9, 10, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 11, 12, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 13, 14, 1, 'com_config', 'com_config', '{}'),
(7, 1, 15, 18, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(8, 1, 19, 32, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(9, 1, 33, 34, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 35, 36, 1, 'com_installer', 'com_installer', '{\"core.admin\":[],\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 37, 38, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(12, 1, 39, 40, 1, 'com_login', 'com_login', '{}'),
(13, 1, 41, 42, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 43, 44, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 45, 46, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 47, 48, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(17, 1, 49, 50, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 51, 118, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(19, 1, 119, 122, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(20, 1, 123, 124, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(21, 1, 125, 126, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}'),
(22, 1, 127, 128, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 129, 130, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(24, 1, 131, 134, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(25, 1, 135, 138, 1, 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}'),
(26, 1, 139, 140, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 20, 21, 2, 'com_content.category.2', 'All', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(29, 7, 16, 17, 2, 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(30, 19, 120, 121, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(31, 25, 136, 137, 2, 'com_weblinks.category.6', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(32, 24, 132, 133, 1, 'com_users.category.7', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(33, 1, 141, 142, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 1, 143, 144, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}'),
(37, 8, 22, 23, 2, 'com_content.category.8', 'English (United Kingdom) ', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(38, 8, 24, 25, 2, 'com_content.category.9', 'French (FR) ', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(39, 8, 26, 27, 2, 'com_content.category.10', 'German (DE) ', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(40, 8, 28, 29, 2, 'com_content.category.11', 'Italian (IT)', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(41, 8, 30, 31, 2, 'com_content.category.12', 'Spanish (ES)', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(46, 1, 147, 148, 1, 'com_jcomments', 'jcomments', '{}'),
(47, 3, 6, 7, 2, 'com_banners.category.13', 'Sidebar_banner', '{\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(49, 1, 149, 150, 1, 'com_k2', 'com_k2', '{\"core.admin\":[],\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}'),
(54, 1, 151, 152, 1, 'com_virtuemart_allinone', 'virtuemart_allinone', '{}'),
(57, 1, 153, 154, 1, 'com_xmap', 'com_xmap', '{}'),
(58, 1, 155, 156, 1, 'com_akeeba', 'akeeba', '{}'),
(60, 1, 157, 158, 1, 'com_comparelist', 'comparelist', '{}'),
(61, 1, 159, 160, 1, 'com_wishlists', 'wishlists', '{}'),
(62, 1, 161, 162, 1, 'com_virtuemart', 'virtuemart', '{}'),
(63, 1, 163, 164, 1, 'com_uniterevolution2', 'com_uniterevolution2', '{\"revolution2.slidersetting\":{\"7\":1},\"revolution2.slideroperations\":{\"7\":1},\"revolution2.slideoperations\":{\"7\":1},\"revolution2.editslide\":{\"7\":1} }'),
(64, 1, 165, 166, 1, 'com_tags', 'com_tags', '{}'),
(65, 1, 167, 168, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(66, 1, 169, 170, 1, 'com_ajax', 'com_ajax', '{}'),
(67, 1, 171, 172, 1, 'com_postinstall', 'com_postinstall', '{}'),
(68, 1, 173, 174, 1, 'com_acymailing', 'acymailing', '{}'),
(69, 18, 52, 53, 2, 'com_modules.module.171', 'Unite Revolution Slider 2', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(70, 1, 175, 176, 1, 'com_jmsmultiupload', 'jmsmultiupload', '{}'),
(72, 18, 54, 55, 2, 'com_modules.module.173', 'Tags Cloud', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(73, 18, 56, 57, 2, 'com_modules.module.154', 'Display our products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(74, 18, 58, 59, 2, 'com_modules.module.174', 'Megamenu Categories', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(75, 18, 60, 61, 2, 'com_modules.module.175', 'Responsive color google map', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(76, 18, 62, 63, 2, 'com_modules.module.143', 'JGMap - A Google Map Module', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(77, 18, 64, 65, 2, 'com_modules.module.176', 'Module Parallax', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(78, 18, 66, 67, 2, 'com_modules.module.177', 'Display All Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(79, 18, 68, 69, 2, 'com_modules.module.178', 'Module Parallax', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(80, 18, 70, 71, 2, 'com_modules.module.179', 'Module Parallax', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}'),
(81, 18, 72, 73, 2, 'com_modules.module.113', 'Random products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(82, 18, 74, 75, 2, 'com_modules.module.180', 'Product Brands', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(83, 18, 76, 77, 2, 'com_modules.module.114', 'Product Brands', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(84, 18, 78, 79, 2, 'com_modules.module.169', 'Newsletter popup', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1}}'),
(85, 18, 80, 81, 2, 'com_modules.module.181', 'Filter', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(86, 18, 82, 83, 2, 'com_modules.module.124', 'Breadcrumbs', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(87, 18, 84, 85, 2, 'com_modules.module.110', 'Banners', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(88, 18, 86, 87, 2, 'com_modules.module.166', 'Compare products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(89, 18, 88, 89, 2, 'com_modules.module.167', 'Wishlist Products', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(90, 18, 90, 91, 2, 'com_modules.module.123', 'Categories', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(91, 18, 92, 93, 2, 'com_modules.module.126', 'Bestsellers', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(92, 18, 94, 95, 2, 'com_modules.module.125', 'Sidebar_banner', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(93, 18, 96, 97, 2, 'com_modules.module.111', 'Best Sales', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(94, 18, 98, 99, 2, 'com_modules.module.112', 'New collection', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(95, 1, 177, 178, 1, 'com_tcpdf', 'tcpdf', '{}'),
(96, 18, 100, 101, 2, 'com_modules.module.182', 'Cooltags Cloud', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(97, 1, 179, 180, 1, 'com_cooltags', 'com_cooltags', '{}'),
(98, 18, 102, 103, 2, 'com_modules.module.118', 'Join Us on Facebook', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(99, 18, 104, 105, 2, 'com_modules.module.164', 'News From Twitter', '{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}'),
(100, 18, 106, 107, 2, 'com_modules.module.153', 'Display All Products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(101, 18, 108, 109, 2, 'com_modules.module.183', 'Google Map', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}'),
(102, 1, 181, 182, 1, 'com_fields', 'com_fields', '{}'),
(103, 1, 183, 184, 1, 'com_associations', 'com_associations', '{}'),
(104, 1, 185, 186, 1, 'com_sppagebuilder', 'SP Page Builder', '{}'),
(105, 18, 110, 111, 2, 'com_modules.module.184', 'SP Page Builder', '{}'),
(106, 18, 112, 113, 2, 'com_modules.module.185', 'SP Page Builder', '{}'),
(107, 18, 114, 115, 2, 'com_modules.module.186', 'SP Page Builder Admin Menu', '{}'),
(108, 18, 116, 117, 2, 'com_modules.module.119', 'Newsletter', '{}'),
(109, 1, 187, 188, 1, 'com_jch_optimize', 'JCH Optimize Pro', '{}'),
(110, 1, 189, 190, 1, 'com_privacy', 'com_privacy', '{}'),
(111, 1, 191, 192, 1, 'com_actionlogs', 'com_actionlogs', '{}');

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__associations` (`id`, `context`, `key`) VALUES
(502, 'com_menus.item', '160657e8cda2cf7b012c010910be6ed4'),
(503, 'com_menus.item', '160657e8cda2cf7b012c010910be6ed4'),
(504, 'com_menus.item', '160657e8cda2cf7b012c010910be6ed4'),
(505, 'com_menus.item', '160657e8cda2cf7b012c010910be6ed4'),
(640, 'com_menus.item', '160657e8cda2cf7b012c010910be6ed4'),
(1060, 'com_menus.item', '160657e8cda2cf7b012c010910be6ed4');

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT 0,
  `impmade` int(11) NOT NULL DEFAULT 0,
  `clicks` int(11) NOT NULL DEFAULT 0,
  `clickurl` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `catid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `description` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8_unicode_ci NOT NULL,
  `sticky` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(400) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `version` int(10) UNSIGNED NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__banners` (`id`, `cid`, `type`, `name`, `alias`, `imptotal`, `impmade`, `clicks`, `clickurl`, `state`, `catid`, `description`, `custombannercode`, `sticky`, `ordering`, `metakey`, `params`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `reset`, `created`, `language`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `version`) VALUES
(1, 0, 0, 'shop1', 'shop1', 0, 5591, 6, 'http://demolink.org', 1, 3, '', '', 0, 1, '', '{\"imageurl\":\"images\\/banners\\/banner1.png\",\"width\":\"\",\"height\":\"\",\"alt\":\"shop1\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2019-08-17 20:01:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(2, 0, 0, 'shop2', 'shop2', 0, 5590, 3, 'http://demolink.org', 1, 3, '', '', 0, 2, '', '{\"imageurl\":\"images\\/banners\\/banner2.png\",\"width\":\"\",\"height\":\"\",\"alt\":\"shop2\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2019-08-17 20:01:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1),
(3, 0, 0, 'shop_3', 'shop-3', 0, 28942, 1, 'http://demolink.org', 1, 13, 'shop_3', '', 0, 1, '', '{\"imageurl\":\"images\\/banners\\/banner3.png\",\"width\":270,\"height\":220,\"alt\":\"shop_3\"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2019-08-17 20:01:05', '*', 0, '', '0000-00-00 00:00:00', 0, 1);

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) UNSIGNED NOT NULL,
  `banner_id` int(10) UNSIGNED NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `path` varchar(400) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `params` text COLLATE utf8_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) UNSIGNED NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 25, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 0, '2019-08-17 20:01:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'all', 'com_content', 'All', 'all', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '2019-08-17 20:01:05', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(6, 31, 1, 9, 10, 1, 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 11, 12, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"target\":\"\",\"image\":\"\"}', '', '', '{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '0000-00-00 00:00:00', 0, '*', 1),
(8, 37, 1, 13, 14, 1, 'english-uk', 'com_content', 'English (United Kingdom) ', 'english-uk', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '2019-08-17 20:01:05', 0, 'en-GB', 1),
(9, 38, 1, 15, 16, 1, 'french-fr', 'com_content', 'French (FR) ', 'french-fr', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '2019-08-17 20:01:05', 0, 'fr-FR', 1),
(10, 39, 1, 17, 18, 1, 'german-de', 'com_content', 'German (DE) ', 'german-de', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '2019-08-17 20:01:05', 0, 'de-DE', 1),
(11, 40, 1, 19, 20, 1, 'italian-it', 'com_content', 'Italian (IT)', 'italian-it', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '2019-08-17 20:01:05', 0, 'it-IT', 1),
(12, 41, 1, 21, 22, 1, 'spanish-es', 'com_content', 'Spanish (ES)', 'spanish-es', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '0000-00-00 00:00:00', 0, 'es-ES', 1),
(13, 47, 1, 23, 24, 1, 'sidebar-banner', 'com_banners', 'Sidebar_banner', 'sidebar-banner', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 0, '2019-08-17 20:01:05', 0, '0000-00-00 00:00:00', 0, '*', 1);

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `suburb` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `catid` int(11) NOT NULL DEFAULT 0,
  `access` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `mobile` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `metakey` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'Set if article is featured.',
  `xreference` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `hits` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Contacts', 'contacts', '', 'Address: 123 Bajron Street\r\nNew York, NY 55555, 123 Bajron Street', '', '', '', '', 'Telephone: 444-223-555-555', 'Fax: 444-213-553-444', '', '', 'mad_caesar@bk.ru', 0, 1, 0, '0000-00-00 00:00:00', 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"plain\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"0\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":null,\"linkb_name\":\"\",\"linkb\":null,\"linkc_name\":\"\",\"linkc\":null,\"linkd_name\":\"\",\"linkd\":null,\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 0, 4, 1, '', 'http://themeforest.net/user/mad_velikorodnov', '', '', '', '*', '2019-08-17 20:01:05', 0, '', '2019-08-17 20:01:05', 0, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 21);

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT 0,
  `catid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `metakey` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `hits` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `metadata` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Maps items from content tables to tags';

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT 0,
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lastip` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
  `type_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8_unicode_ci NOT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=10005 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{\"special\":{\"dbtable\":\"#__weblinks\",\"key\":\"id\",\"type\":\"Weblink\",\"prefix\":\"WeblinksTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"url\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\": {}}', 'WeblinksHelperRoute::getWeblinkRoute', '{\"formFile\":\"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"featured\",\"images\"], \"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(3, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\": {\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\": {\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(5, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\": {}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'WeblinksHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(10, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(10000, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"Banner\",\"prefix\":\"BannersTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(10001, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(10002, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"Client\",\"prefix\":\"BannersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(10003, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"Note\",\"prefix\":\"UsersTable\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(10004, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__dbcache`;
CREATE TABLE IF NOT EXISTS `#__dbcache` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `groupname` varchar(32) NOT NULL DEFAULT '',
  `expire` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `value` mediumblob NOT NULL,
  PRIMARY KEY (`id`,`groupname`),
  KEY `expire` (`expire`,`groupname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT 0,
  `access` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `protected` tinyint(3) NOT NULL DEFAULT 0,
  `manifest_cache` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `system_data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT 0,
  `state` int(11) DEFAULT 0,
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10268 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 0, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mailto\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 0, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 0, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 0, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 0, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 0, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 0, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"show_contact_category\":\"hide\",\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"allow_vcard_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_category_crumb\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 0, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"cachetimeout\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 0, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 0, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 0, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 0, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 0, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 0, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 0, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 0, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"show_date\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 0, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"2\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(21, 0, 'com_weblinks', 'component', 'com_weblinks', '', 1, 1, 1, 0, '{\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"weblinks\"}', '{\"show_comp_description\":\"1\",\"comp_description\":\"\",\"show_link_hits\":\"1\",\"show_link_description\":\"1\",\"show_other_cats\":\"0\",\"show_headings\":\"0\",\"show_numbers\":\"0\",\"show_report\":\"1\",\"count_clicks\":\"1\",\"target\":\"0\",\"link_icons\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 0, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"1\",\"readmore_limit\":\"100\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"1\",\"show_noauth\":\"0\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 0, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 0, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 0, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"1\",\"sendpassword\":\"1\",\"useractivation\":\"1\",\"mail_to_admin\":\"1\",\"captcha\":\"0\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"reset_count\":\"10\",\"reset_time\":\"1\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 0, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"snowball\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 0, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 0, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 1, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(33, 0, 'com_fields', 'component', 'com_fields', '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(34, 0, 'com_associations', 'component', 'com_associations', '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(35, 0, 'com_privacy', 'component', 'com_privacy', '', 1, 1, 1, 1, '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', '', 1, 1, 1, 1, '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 0, 'LIB_PHPUTF8', 'library', 'phputf8', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPUTF8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phputf8\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 0, 'LIB_JOOMLA', 'library', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"LIB_JOOMLA\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"218d631ec11ba31db327bda7951048a0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 0, 'LIB_IDNA', 'library', 'idna_convert', '', 0, 1, 1, 1, '{\"name\":\"LIB_IDNA\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"phlyLabs\",\"copyright\":\"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de\",\"authorEmail\":\"phlymail@phlylabs.de\",\"authorUrl\":\"http:\\/\\/phlylabs.de\",\"version\":\"0.8.0\",\"description\":\"LIB_IDNA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"idna_convert\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 0, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2015-04-22 13:15:32\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2015 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.3\",\"description\":\"LIB_FOF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fof\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 0, 'LIB_PHPASS', 'library', 'phpass', '', 0, 1, 1, 1, '{\"name\":\"LIB_PHPASS\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"http:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 0, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 0, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 0, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 0, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 0, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 0, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 0, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 0, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_weblinks\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 0, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 0, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 0, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 0, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 0, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 0, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 0, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 0, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 0, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 0, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_status\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 0, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 0, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 0, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', '', 1, 1, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', '', 1, 1, 1, 0, '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latestactions\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', '', 0, '1970-01-01 00:00:00', 0, 0),
(400, 0, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gmail\"}', '{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 0, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(405, 0, 'plg_content_geshi', 'plugin', 'geshi', 'content', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"plg_content_geshi\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"qbnz.com\\/highlighter\",\"version\":\"2.5.0\",\"description\":\"PLG_CONTENT_GESHI_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', '', 0, '2011-09-18 15:22:50', 0, 0),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 0, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"http:\\/\\/codemirror.net\\/\",\"version\":\"5.40.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 0, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2019\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"4.5.11\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"mode\":\"1\",\"skin\":\"0\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"en\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"resizing\":\"true\",\"resize_horizontal\":\"false\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 0, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 0, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 0, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 0, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 0, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"weblinks\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '{\"detect_browser\":\"0\",\"automatic_change\":\"0\",\"menu_associations\":\"1\",\"remove_default_prefix\":\"0\",\"lang_cookie\":\"0\",\"alternate_meta\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 29, 0),
(423, 0, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"p3p\"}', '{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}', '', '', 0, '0000-00-00 00:00:00', 30, 0),
(424, 0, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', '', 0, '0000-00-00 00:00:00', 47, 0),
(425, 0, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 32, 0),
(426, 0, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 33, 0),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 34, 0),
(428, 0, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 0, 1, 1, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 36, 0),
(429, 0, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 37, 0),
(430, 0, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 31, 0),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"4\",\"autopublish\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 0, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 38, 0),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"version\":\"2.0\",\"public_key\":\" product->product_s_desc){                  echo \'\' .$this->product->product_s_desc.\'\';                  } ?>\",\"private_key\":\" product->product_s_desc){                  echo \'\' .$this->product->product_s_desc.\'\';                  } ?>\",\"theme\":\"clean\",\"theme2\":\"light\",\"size\":\"normal\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 35, 0),
(441, 0, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 0, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(446, 0, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_weblinks\",\"type\":\"plugin\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_FINDER_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"weblinks\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 0, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 0, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1566224958}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(454, 0, 'plg_system_stats', 'plugin', 'stats', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', '{\"mode\":1,\"lastrun\":1566210913,\"unique_id\":\"322f9fbe956f5b47fe60abfd800e7975b19edbbe\",\"interval\":12}', '', '', 0, '0000-00-00 00:00:00', 21, 0),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(456, 0, 'PLG_INSTALLER_FOLDERINSTALLER', 'plugin', 'folderinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_FOLDERINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(457, 0, 'PLG_INSTALLER_URLINSTALLER', 'plugin', 'urlinstaller', 'installer', 0, 1, 1, 1, '{\"name\":\"PLG_INSTALLER_URLINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', 'quickicon', 0, 1, 1, 1, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(461, 0, 'plg_system_fields', 'plugin', 'fields', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(464, 0, 'plg_fields_color', 'plugin', 'color', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(468, 0, 'plg_fields_list', 'plugin', 'list', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(469, 0, 'plg_fields_media', 'plugin', 'media', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(472, 0, 'plg_fields_text', 'plugin', 'text', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(474, 0, 'plg_fields_url', 'plugin', 'url', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(475, 0, 'plg_fields_user', 'plugin', 'user', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(477, 0, 'plg_content_fields', 'plugin', 'fields', 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', 'sampledata', 0, 0, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}', '', '', '', 0, '0000-00-00 00:00:00', 18, 0),
(481, 0, 'plg_fields_repeatable', 'plugin', 'repeatable', 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_repeatable\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_FIELDS_REPEATABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"repeatable\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"confirmconsent\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(483, 0, 'PLG_SYSTEM_ACTIONLOGS', 'plugin', 'actionlogs', 'system', 0, 0, 1, 0, '{\"name\":\"PLG_SYSTEM_ACTIONLOGS\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(484, 0, 'PLG_ACTIONLOG_JOOMLA', 'plugin', 'joomla', 'actionlog', 0, 1, 1, 0, '{\"name\":\"PLG_ACTIONLOG_JOOMLA\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacyconsent\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(486, 0, 'plg_system_logrotation', 'plugin', 'logrotation', 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}', '{\"lastrun\":1566072077}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(487, 0, 'plg_privacy_user', 'plugin', 'user', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacycheck\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(489, 0, 'plg_user_terms', 'plugin', 'terms', 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"terms\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(491, 0, 'plg_privacy_content', 'plugin', 'content', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(492, 0, 'plg_privacy_message', 'plugin', 'message', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"November 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(500, 0, 'atomic', 'template', 'atomic', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"atomic\",\"type\":\"template\",\"creationDate\":\"10\\/10\\/09\",\"author\":\"Ron Severdia\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"contact@kontentdesign.com\",\"authorUrl\":\"http:\\/\\/www.kontentdesign.com\",\"version\":\"2.5.0\",\"description\":\"TPL_ATOMIC_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(502, 0, 'bluestork', 'template', 'bluestork', '', 1, 1, 1, 0, '{\"legacy\":false,\"name\":\"bluestork\",\"type\":\"template\",\"creationDate\":\"07\\/02\\/09\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"TPL_BLUESTORK_XML_DESCRIPTION\",\"group\":\"\"}', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\",\"textBig\":\"0\",\"highContrast\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 0, 'beez_20', 'template', 'beez_20', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"beez_20\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ2_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 0, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(505, 0, 'beez5', 'template', 'beez5', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"beez5\",\"type\":\"template\",\"creationDate\":\"21 May 2010\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"2.5.0\",\"description\":\"TPL_BEEZ5_XML_DESCRIPTION\",\"group\":\"\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"html5\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 802, 'English (en-GB)', 'language', 'en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"August 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.11\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 802, 'English (en-GB)', 'language', 'en-GB', '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"August 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.11\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 0, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"August 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.11\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(801, 0, 'pkg_weblinks', 'package', 'pkg_weblinks', '', 0, 1, 1, 0, '{\"name\":\"pkg_weblinks\",\"type\":\"package\",\"creationDate\":\"2017-03-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PKG_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pkg_weblinks\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"August 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.11.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10000, 0, 'T3 Framework', 'plugin', 't3', 'system', 0, 1, 1, 0, '{\"name\":\"T3 Framework\",\"type\":\"plugin\",\"creationDate\":\"Feb 19, 2019\",\"author\":\"JoomlArt.com\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"info@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.t3-framework.org\",\"version\":\"2.7.4\",\"description\":\"\\n\\t\\n\\t<div align=\\\"center\\\">\\n\\t\\t<div class=\\\"alert alert-success\\\" style=\\\"background-color:#DFF0D8;border-color:#D6E9C6;color: #468847;padding: 1px 0;\\\">\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/t3-framework.org\\/\\\"><img src=\\\"http:\\/\\/static.joomlart.com\\/images\\/jat3v3-documents\\/message-installation\\/logo.png\\\" alt=\\\"some_text\\\" width=\\\"300\\\" height=\\\"99\\\"><\\/a>\\n\\t\\t\\t\\t<h4><a href=\\\"http:\\/\\/t3-framework.org\\/\\\" title=\\\"\\\">Home<\\/a> | <a href=\\\"http:\\/\\/demo.t3-framework.org\\/\\\" title=\\\"\\\">Demo<\\/a> | <a href=\\\"http:\\/\\/t3-framework.org\\/documentation\\\" title=\\\"\\\">Document<\\/a> | <a href=\\\"https:\\/\\/github.com\\/t3framework\\/t3\\/blob\\/master\\/CHANGELOG.md\\\" title=\\\"\\\">Changelog<\\/a><\\/h4>\\n\\t\\t<p> <\\/p>\\n\\t\\t<p>Copyright 2004 - 2019 <a href=\'http:\\/\\/www.joomlart.com\\/\' title=\'Visit Joomlart.com!\'>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t<\\/div>\\n     <style>table.adminform{width: 100%;}<\\/style>\\n\\t <\\/div>\\n\\t\\t\\n\\t\",\"group\":\"\",\"filename\":\"t3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 24, 0),
(10002, 0, 'ItalianItaly', 'language', 'it-IT', '', 0, 1, 0, 0, '{\"name\":\"Italian (Italy)\",\"type\":\"language\",\"creationDate\":\"30 October 2018\",\"author\":\"Italian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters and Italian Translation team. All rights reserved\",\"authorEmail\":\"stellainformatica@gmail.com\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"3.9.0.1\",\"description\":\"Italian site language pack for Joomla! 3.9\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10003, 0, 'ItalianItaly', 'language', 'it-IT', '', 1, 1, 0, 0, '{\"name\":\"Italian (Italy)\",\"type\":\"language\",\"creationDate\":\"30 October 2018\",\"author\":\"Italian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters and Italian Translation Team. All rights reserved\",\"authorEmail\":\"stellainformatica@gmail.com\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"3.9.0.1\",\"description\":\"Italian administration language pack for Joomla! 3.9\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10004, 0, 'TinyMCE lingua IT', 'file', 'TinyMCE_it-IT', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"TinyMCE lingua IT\",\"type\":\"file\",\"creationDate\":\"20 giugno 2012\",\"author\":\"Italian translation team : joomla.it\",\"copyright\":\"(C) 2005-2012 Italian Translation Team\",\"authorEmail\":\"info@joomla.it\",\"authorUrl\":\"www.joomla.it\",\"version\":\"3.5.2\",\"description\":\"\\t\\t\\n\\t\\t<h3>Installazione del pacchetto lingua per TinyMCE 3.5.2 per  Joomla 2.5 effettuato correttamente<\\/h3>\\n \\u00a0 \\u00a0 \\u00a0 \\u00a0<div style=\\\"font-weight:normal\\\">\\n \\t\\tNon dimenticare di selezionare la lingua IT nella\\n \\t\\t<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong>gestione del plug-in TinyMCE<\\/strong><\\/a><br \\/>\\n<\\/div>\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10005, 0, 'Italian Language Pack', 'package', 'pkg_it-IT', '', 0, 1, 1, 0, '{\"name\":\"Italian Language Pack\",\"type\":\"package\",\"creationDate\":\"30 October 2018\",\"author\":\"Italian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2018 Open Source Matters e Italian Translation Team. Tutti i diritti riservati\",\"authorEmail\":\"stellainformatica@gmail.com\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0.1\",\"description\":\"Joomla! 3.9 Full Italian (it-IT) Language Package - Version 3.9.0v1\",\"group\":\"\",\"filename\":\"pkg_it-IT\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10009, 0, 'falang', 'package', 'pkg_falang', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"FaLang Package\",\"type\":\"package\",\"creationDate\":\"December 2012\",\"author\":\"St\\u00e9phane Bouey\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.2.0\",\"description\":\"FaLang! Installer Package.\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10012, 0, 'Standard', 'plugin', 'standard', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Standard\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"Standard payment plugin\",\"group\":\"\",\"filename\":\"standard\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10013, 0, 'Paypal', 'plugin', 'paypal', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"PayPal\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"PayPal\",\"group\":\"\",\"filename\":\"paypal\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10014, 0, 'PayZen', 'plugin', 'payzen', 'vmpayment', 0, 1, 1, 0, '{\"legacy\":true,\"name\":\"VM - Payment, PayZen\",\"type\":\"plugin\",\"creationDate\":\"July 04 2012\",\"author\":\"Lyra Network\",\"copyright\":\"Copyright Lyra Network.\",\"authorEmail\":\"support@payzen.eu\",\"authorUrl\":\"http:\\/\\/www.lyra-network.com\",\"version\":\"2.0.8c\",\"description\":\"\\n    \\t<a href=\\\"http:\\/\\/www.lyra-network.com\\\" target=\\\"_blank\\\">PayZen<\\/a> is a multi bank payment provider. \\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 100, 0),
(10015, 0, 'SystemPay', 'plugin', 'systempay', 'vmpayment', 0, 1, 1, 0, '{\"legacy\":true,\"name\":\"VM - Payment, Systempay\",\"type\":\"plugin\",\"creationDate\":\"July 04 2012\",\"author\":\"Lyra Network\",\"copyright\":\"Copyright Lyra Network.\",\"authorEmail\":\"supportvad@lyra-network.com\",\"authorUrl\":\"http:\\/\\/www.lyra-network.com\",\"version\":\"2.0.8c\",\"description\":\"\\n    \\t<a href=\\\"http:\\/\\/www.lyra-network.com\\\" target=\\\"_blank\\\">Systempay<\\/a> is a multi bank payment provider. \\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 100, 0),
(10024, 0, 'Authorize.net', 'plugin', 'authorizenet', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Authorize.net AIM\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"Authorize.net AIM\",\"group\":\"\",\"filename\":\"authorizenet\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10025, 0, 'Klarna', 'plugin', 'klarna', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Klarna\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"Klarna VirtueMart Payment Plugin\",\"group\":\"\",\"filename\":\"klarna\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10026, 0, 'Heidelpay', 'plugin', 'heidelpay', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Heidelpay\",\"type\":\"plugin\",\"creationDate\":\"12-Sep-2012\",\"author\":\"Heidelberger Payment GmbH\",\"copyright\":\"Copyright Heidelberger Payment GmbH\",\"authorEmail\":\"info@heidelpay.de\",\"authorUrl\":\"http:\\/\\/www.heidelpay.de\",\"version\":\"16.11.07\",\"description\":\"\\n        <h2>Virtuemart Plugin von:<\\/h2><p><a href=\\\"https:\\/\\/www.Heidelpay.de\\\" target=\\\"_blank\\\"><img src=\\\"https:\\/\\/www.heidelpay.de\\/gfx\\/logo.gif\\\" style=\\\"margin-right:20px;\\\"\\/><\\/a><\\/p> \",\"group\":\"\",\"filename\":\"heidelpay\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10027, 0, 'By weight, ZIP and countries', 'plugin', 'weight_countries', 'vmshipment', 0, 1, 1, 0, '{\"name\":\"By weight, ZIP and countries\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"VMSHIPMENT_WEIGHT_COUNTRIES_PLUGIN_DESC\",\"group\":\"\",\"filename\":\"weight_countries\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10028, 0, 'Customer text input', 'plugin', 'textinput', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"VMCustom - textinput\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"text input plugin for product\",\"group\":\"\",\"filename\":\"textinput\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10029, 0, 'Product specification', 'plugin', 'specification', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"plgvm_specification\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"VMCustom - specification; text input plugin for product\",\"group\":\"\",\"filename\":\"specification\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10031, 0, 'Avalara Tax', 'plugin', 'avalara', 'vmcalculation', 0, 1, 1, 0, '{\"name\":\"VM - Calculation Avalara Tax\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"Max Milbers\",\"copyright\":\"Copyright (C) 2013 iStraxx UG (haftungsbeschr\\u00e4nkt). All rights reserved\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"VM - Calculation Avalara Tax; On demand tax calculation for whole U.S.A.\",\"group\":\"\",\"filename\":\"avalara\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10032, 0, 'plg_search_virtuemart', 'plugin', 'virtuemart', 'search', 0, 1, 1, 0, '{\"name\":\"Search - VirtueMart\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"PLG_SEARCH_VIRTUEMART_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"virtuemart\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10033, 0, 'mod_virtuemart_currencies', 'module', 'mod_virtuemart_currencies', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_currencies\",\"type\":\"module\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"MOD_VIRTUEMART_CURRENCIES_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_currencies\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10034, 0, 'mod_virtuemart_product', 'module', 'mod_virtuemart_product', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_product\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"Displays: Featured, Best Sales, Random, or Latests products.\",\"group\":\"\",\"filename\":\"mod_virtuemart_product\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10035, 0, 'mod_virtuemart_search', 'module', 'mod_virtuemart_search', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_search\",\"type\":\"module\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"MOD_VIRTUEMART_SEARCH_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_search\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10036, 0, 'mod_virtuemart_manufacturer', 'module', 'mod_virtuemart_manufacturer', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_manufacturer\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"MOD_VIRTUEMART_MANUFACTURER_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_manufacturer\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10038, 0, 'mod_virtuemart_category', 'module', 'mod_virtuemart_category', '', 0, 1, 1, 0, '{\"name\":\"mod_virtuemart_category\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"mod virtuemart category\",\"group\":\"\",\"filename\":\"mod_virtuemart_category\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10039, 0, 'COM_K2', 'component', 'com_k2', '', 1, 1, 0, 0, '{\"name\":\"COM_K2\",\"type\":\"component\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"Thank you for installing K2 by JoomlaWorks, the powerful content extension for Joomla\",\"group\":\"\",\"filename\":\"k2\"}', '{\"enable_css\":\"1\",\"jQueryHandling\":\"1.8remote\",\"backendJQueryHandling\":\"remote\",\"userName\":\"1\",\"userImage\":\"1\",\"userDescription\":\"1\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeedLink\":\"0\",\"userFeedIcon\":\"0\",\"userItemCount\":\"10\",\"userItemTitle\":\"1\",\"userItemTitleLinked\":\"0\",\"userItemDateCreated\":\"1\",\"userItemImage\":\"1\",\"userItemIntroText\":\"1\",\"userItemCategory\":\"0\",\"userItemTags\":\"0\",\"userItemCommentsAnchor\":\"0\",\"userItemReadMore\":\"1\",\"userItemK2Plugins\":\"1\",\"tagItemCount\":\"10\",\"tagItemTitle\":\"1\",\"tagItemTitleLinked\":\"1\",\"tagItemDateCreated\":\"1\",\"tagItemImage\":\"1\",\"tagItemIntroText\":\"1\",\"tagItemCategory\":\"1\",\"tagItemReadMore\":\"1\",\"tagItemExtraFields\":\"0\",\"tagOrdering\":\"\",\"tagFeedLink\":\"1\",\"tagFeedIcon\":\"1\",\"genericItemCount\":\"10\",\"genericItemTitle\":\"1\",\"genericItemTitleLinked\":\"1\",\"genericItemDateCreated\":\"1\",\"genericItemImage\":\"1\",\"genericItemIntroText\":\"1\",\"genericItemCategory\":\"1\",\"genericItemReadMore\":\"1\",\"genericItemExtraFields\":\"0\",\"genericFeedLink\":\"1\",\"genericFeedIcon\":\"1\",\"feedLimit\":\"10\",\"feedItemImage\":\"1\",\"feedImgSize\":\"S\",\"feedItemIntroText\":\"1\",\"feedTextWordLimit\":\"\",\"feedItemFullText\":\"1\",\"feedItemTags\":\"0\",\"feedItemVideo\":\"0\",\"feedItemGallery\":\"0\",\"feedItemAttachments\":\"0\",\"feedBogusEmail\":\"\",\"introTextCleanup\":\"0\",\"introTextCleanupExcludeTags\":\"\",\"introTextCleanupTagAttr\":\"\",\"fullTextCleanup\":\"0\",\"fullTextCleanupExcludeTags\":\"\",\"fullTextCleanupTagAttr\":\"\",\"xssFiltering\":\"0\",\"linkPopupWidth\":\"900\",\"linkPopupHeight\":\"600\",\"imagesQuality\":\"100\",\"itemImageXS\":\"100\",\"itemImageS\":\"248\",\"itemImageM\":\"400\",\"itemImageL\":\"600\",\"itemImageXL\":\"900\",\"itemImageGeneric\":\"900\",\"catImageWidth\":\"100\",\"catImageDefault\":\"1\",\"userImageWidth\":\"100\",\"userImageDefault\":\"1\",\"commenterImgWidth\":\"48\",\"onlineImageEditor\":\"splashup\",\"imageTimestamp\":\"0\",\"imageMemoryLimit\":\"\",\"socialButtonCode\":\"\",\"twitterUsername\":\"\",\"facebookImage\":\"XSmall\",\"comments\":\"1\",\"commentsOrdering\":\"DESC\",\"commentsLimit\":\"10\",\"commentsFormPosition\":\"below\",\"commentsPublishing\":\"1\",\"commentsReporting\":\"2\",\"commentsReportRecipient\":\"\",\"inlineCommentsModeration\":\"0\",\"gravatar\":\"0\",\"antispam\":\"0\",\"recaptchaForRegistered\":\"1\",\"akismetForRegistered\":\"1\",\"commentsFormNotes\":\"1\",\"commentsFormNotesText\":\"\",\"frontendEditing\":\"1\",\"showImageTab\":\"1\",\"showImageGalleryTab\":\"1\",\"showVideoTab\":\"1\",\"showExtraFieldsTab\":\"1\",\"showAttachmentsTab\":\"1\",\"showK2Plugins\":\"1\",\"sideBarDisplayFrontend\":\"0\",\"mergeEditors\":\"1\",\"sideBarDisplay\":\"1\",\"attachmentsFolder\":\"\",\"hideImportButton\":\"0\",\"googleSearch\":\"0\",\"googleSearchContainer\":\"k2GoogleSearchContainer\",\"K2UserProfile\":\"1\",\"K2UserGroup\":\"1\",\"redirect\":\"505\",\"adminSearch\":\"simple\",\"cookieDomain\":\"\",\"taggingSystem\":\"1\",\"lockTags\":\"0\",\"showTagFilter\":\"0\",\"k2TagNorm\":\"0\",\"k2TagNormCase\":\"lower\",\"k2TagNormAdditionalReplacements\":\"\",\"recaptcha_public_key\":\"\",\"recaptcha_private_key\":\"\",\"recaptcha_theme\":\"clean\",\"recaptchaOnRegistration\":\"0\",\"akismetApiKey\":\"\",\"stopForumSpam\":\"0\",\"stopForumSpamApiKey\":\"\",\"showItemsCounterAdmin\":\"1\",\"showChildCatItems\":\"1\",\"disableCompactOrdering\":\"0\",\"metaDescLimit\":\"150\",\"enforceSEFReplacements\":\"0\",\"SEFReplacements\":\"\\u00c0|A, \\u00c1|A, \\u00c2|A, \\u00c3|A, \\u00c4|A, \\u00c5|A, \\u00e0|a, \\u00e1|a, \\u00e2|a, \\u00e3|a, \\u00e4|a, \\u00e5|a, \\u0100|A, \\u0101|a, \\u0102|A, \\u0103|a, \\u0104|A, \\u0105|a, \\u00c7|C, \\u00e7|c, \\u0106|C, \\u0107|c, \\u0108|C, \\u0109|c, \\u010a|C, \\u010b|c, \\u010c|C, \\u010d|c, \\u00d0|D, \\u00f0|d, \\u010e|D, \\u010f|d, \\u0110|D, \\u0111|d, \\u00c8|E, \\u00c9|E, \\u00ca|E, \\u00cb|E, \\u00e8|e, \\u00e9|e, \\u00ea|e, \\u00eb|e, \\u0112|E, \\u0113|e, \\u0114|E, \\u0115|e, \\u0116|E, \\u0117|e, \\u0118|E, \\u0119|e, \\u011a|E, \\u011b|e, \\u011c|G, \\u011d|g, \\u011e|G, \\u011f|g, \\u0120|G, \\u0121|g, \\u0122|G, \\u0123|g, \\u0124|H, \\u0125|h, \\u0126|H, \\u0127|h, \\u00cc|I, \\u00cd|I, \\u00ce|I, \\u00cf|I, \\u00ec|i, \\u00ed|i, \\u00ee|i, \\u00ef|i, \\u0128|I, \\u0129|i, \\u012a|I, \\u012b|i, \\u012c|I, \\u012d|i, \\u012e|I, \\u012f|i, \\u0130|I, \\u0131|i, \\u0134|J, \\u0135|j, \\u0136|K, \\u0137|k, \\u0138|k, \\u0139|L, \\u013a|l, \\u013b|L, \\u013c|l, \\u013d|L, \\u013e|l, \\u013f|L, \\u0140|l, \\u0141|L, \\u0142|l, \\u00d1|N, \\u00f1|n, \\u0143|N, \\u0144|n, \\u0145|N, \\u0146|n, \\u0147|N, \\u0148|n, \\u0149|n, \\u014a|N, \\u014b|n, \\u00d2|O, \\u00d3|O, \\u00d4|O, \\u00d5|O, \\u00d6|O, \\u00d8|O, \\u00f2|o, \\u00f3|o, \\u00f4|o, \\u00f5|o, \\u00f6|o, \\u00f8|o, \\u014c|O, \\u014d|o, \\u014e|O, \\u014f|o, \\u0150|O, \\u0151|o, \\u0154|R, \\u0155|r, \\u0156|R, \\u0157|r, \\u0158|R, \\u0159|r, \\u015a|S, \\u015b|s, \\u015c|S, \\u015d|s, \\u015e|S, \\u015f|s, \\u0160|S, \\u0161|s, \\u017f|s, \\u0162|T, \\u0163|t, \\u0164|T, \\u0165|t, \\u0166|T, \\u0167|t, \\u00d9|U, \\u00da|U, \\u00db|U, \\u00dc|U, \\u00f9|u, \\u00fa|u, \\u00fb|u, \\u00fc|u, \\u0168|U, \\u0169|u, \\u016a|U, \\u016b|u, \\u016c|U, \\u016d|u, \\u016e|U, \\u016f|u, \\u0170|U, \\u0171|u, \\u0172|U, \\u0173|u, \\u0174|W, \\u0175|w, \\u00dd|Y, \\u00fd|y, \\u00ff|y, \\u0176|Y, \\u0177|y, \\u0178|Y, \\u0179|Z, \\u017a|z, \\u017b|Z, \\u017c|z, \\u017d|Z, \\u017e|z, \\u03b1|a, \\u03b2|b, \\u03b3|g, \\u03b4|d, \\u03b5|e, \\u03b6|z, \\u03b7|h, \\u03b8|th, \\u03b9|i, \\u03ba|k, \\u03bb|l, \\u03bc|m, \\u03bd|n, \\u03be|x, \\u03bf|o, \\u03c0|p, \\u03c1|r, \\u03c3|s, \\u03c4|t, \\u03c5|y, \\u03c6|f, \\u03c7|ch, \\u03c8|ps, \\u03c9|w, \\u0391|A, \\u0392|B, \\u0393|G, \\u0394|D, \\u0395|E, \\u0396|Z, \\u0397|H, \\u0398|Th, \\u0399|I, \\u039a|K, \\u039b|L, \\u039c|M, \\u039e|X, \\u039f|O, \\u03a0|P, \\u03a1|R, \\u03a3|S, \\u03a4|T, \\u03a5|Y, \\u03a6|F, \\u03a7|Ch, \\u03a8|Ps, \\u03a9|W, \\u03ac|a, \\u03ad|e, \\u03ae|h, \\u03af|i, \\u03cc|o, \\u03cd|y, \\u03ce|w, \\u0386|A, \\u0388|E, \\u0389|H, \\u038a|I, \\u038c|O, \\u038e|Y, \\u038f|W, \\u03ca|i, \\u0390|i, \\u03cb|y, \\u03c2|s, \\u0410|A, \\u04d0|A, \\u04d2|A, \\u04d8|E, \\u04da|E, \\u04d4|E, \\u0411|B, \\u0412|V, \\u0413|G, \\u0490|G, \\u0403|G, \\u0492|G, \\u04f6|G, y|Y, \\u0414|D, \\u0415|E, \\u0400|E, \\u0401|YO, \\u04d6|E, \\u04bc|E, \\u04be|E, \\u0404|YE, \\u0416|ZH, \\u04c1|DZH, \\u0496|ZH, \\u04dc|DZH, \\u0417|Z, \\u0498|Z, \\u04de|DZ, \\u04e0|DZ, \\u0405|DZ, \\u0418|I, \\u040d|I, \\u04e4|I, \\u04e2|I, \\u0406|I, \\u0407|JI, \\u04c0|I, \\u0419|Y, \\u048a|Y, \\u0408|J, \\u041a|K, \\u049a|Q, \\u049e|Q, \\u04a0|K, \\u04c3|Q, \\u049c|K, \\u041b|L, \\u04c5|L, \\u0409|L, \\u041c|M, \\u04cd|M, \\u041d|N, \\u04c9|N, \\u04a2|N, \\u04c7|N, \\u04a4|N, \\u040a|N, \\u041e|O, \\u04e6|O, \\u04e8|O, \\u04ea|O, \\u04a8|O, \\u041f|P, \\u04a6|PF, \\u0420|P, \\u048e|P, \\u0421|S, \\u04aa|S, \\u0422|T, \\u04ac|TH, \\u040b|T, \\u040c|K, \\u0423|U, \\u040e|U, \\u04f2|U, \\u04f0|U, \\u04ee|U, \\u04ae|U, \\u04b0|U, \\u0424|F, \\u0425|H, \\u04b2|H, \\u04ba|H, \\u0426|TS, \\u04b4|TS, \\u0427|CH, \\u04f4|CH, \\u04b6|CH, \\u04cb|CH, \\u04b8|CH, \\u040f|DZ, \\u0428|SH, \\u0429|SHT, \\u042a|A, \\u042b|Y, \\u04f8|Y, \\u042c|Y, \\u048c|Y, \\u042d|E, \\u04ec|E, \\u042e|YU, \\u042f|YA, \\u0430|a, \\u04d1|a, \\u04d3|a, \\u04d9|e, \\u04db|e, \\u04d5|e, \\u0431|b, \\u0432|v, \\u0433|g, \\u0491|g, \\u0453|g, \\u0493|g, \\u04f7|g, y|y, \\u0434|d, \\u0435|e, \\u0450|e, \\u0451|yo, \\u04d7|e, \\u04bd|e, \\u04bf|e, \\u0454|ye, \\u0436|zh, \\u04c2|dzh, \\u0497|zh, \\u04dd|dzh, \\u0437|z, \\u0499|z, \\u04df|dz, \\u04e1|dz, \\u0455|dz, \\u0438|i, \\u045d|i, \\u04e5|i, \\u04e3|i, \\u0456|i, \\u0457|ji, \\u04c0|i, \\u0439|y, \\u048b|y, \\u0458|j, \\u043a|k, \\u049b|q, \\u049f|q, \\u04a1|k, \\u04c4|q, \\u049d|k, \\u043b|l, \\u04c6|l, \\u0459|l, \\u043c|m, \\u04ce|m, \\u043d|n, \\u04ca|n, \\u04a3|n, \\u04c8|n, \\u04a5|n, \\u045a|n, \\u043e|o, \\u04e7|o, \\u04e9|o, \\u04eb|o, \\u04a9|o, \\u043f|p, \\u04a7|pf, \\u0440|p, \\u048f|p, \\u0441|s, \\u04ab|s, \\u0442|t, \\u04ad|th, \\u045b|t, \\u045c|k, \\u0443|u, \\u045e|u, \\u04f3|u, \\u04f1|u, \\u04ef|u, \\u04af|u, \\u04b1|u, \\u0444|f, \\u0445|h, \\u04b3|h, \\u04bb|h, \\u0446|ts, \\u04b5|ts, \\u0447|ch, \\u04f5|ch, \\u04b7|ch, \\u04cc|ch, \\u04b9|ch, \\u045f|dz, \\u0448|sh, \\u0449|sht, \\u044a|a, \\u044b|y, \\u04f9|y, \\u044c|y, \\u048d|y, \\u044d|e, \\u04ed|e, \\u044e|yu, \\u044f|ya\",\"k2Sef\":\"0\",\"k2SefLabelCat\":\"content\",\"k2SefLabelTag\":\"tag\",\"k2SefLabelUser\":\"author\",\"k2SefLabelSearch\":\"search\",\"k2SefLabelDate\":\"date\",\"k2SefLabelItem\":\"0\",\"k2SefLabelItemCustomPrefix\":\"\",\"k2SefInsertItemId\":\"1\",\"k2SefItemIdTitleAliasSep\":\"dash\",\"k2SefUseItemTitleAlias\":\"1\",\"k2SefInsertCatId\":\"1\",\"k2SefCatIdTitleAliasSep\":\"dash\",\"k2SefUseCatTitleAlias\":\"1\",\"sh404SefLabelCat\":\"\",\"sh404SefLabelUser\":\"blog\",\"sh404SefLabelItem\":\"2\",\"sh404SefTitleAlias\":\"alias\",\"sh404SefModK2ContentFeedAlias\":\"feed\",\"sh404SefInsertItemId\":\"0\",\"sh404SefInsertUniqueItemId\":\"0\",\"cbIntegration\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10040, 0, 'plg_finder_k2', 'plugin', 'k2', 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_k2\",\"type\":\"plugin\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"PLG_FINDER_K2_DESCRIPTION\",\"group\":\"\",\"filename\":\"k2\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10041, 0, 'Search - K2', 'plugin', 'k2', 'search', 0, 1, 1, 0, '{\"name\":\"Search - K2\",\"type\":\"plugin\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_THIS_PLUGIN_EXTENDS_THE_DEFAULT_JOOMLA_SEARCH_FUNCTIONALITY_TO_K2_CONTENT\",\"group\":\"\",\"filename\":\"k2\"}', '{\"search_limit\":\"50\",\"search_tags\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10042, 0, 'System - K2', 'plugin', 'k2', 'system', 0, 1, 1, 0, '{\"name\":\"System - K2\",\"type\":\"plugin\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_THE_K2_SYSTEM_PLUGIN_IS_USED_TO_ASSIST_THE_PROPER_FUNCTIONALITY_OF_THE_K2_COMPONENT_SITE_WIDE_MAKE_SURE_ITS_ALWAYS_PUBLISHED_WHEN_THE_K2_COMPONENT_IS_INSTALLED\",\"group\":\"\",\"filename\":\"k2\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 26, 0),
(10043, 0, 'User - K2', 'plugin', 'k2', 'user', 0, 1, 1, 0, '{\"name\":\"User - K2\",\"type\":\"plugin\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_A_USER_SYNCHRONIZATION_PLUGIN_FOR_K2\",\"group\":\"\",\"filename\":\"k2\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10044, 0, 'Josetta - K2 Categories', 'plugin', 'k2category', 'josetta_ext', 0, 1, 1, 0, '{\"name\":\"Josetta - K2 Categories\",\"type\":\"plugin\",\"creationDate\":\"December 8th, 2014\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.9\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10045, 0, 'Josetta - K2 Items', 'plugin', 'k2item', 'josetta_ext', 0, 1, 1, 0, '{\"name\":\"Josetta - K2 Items\",\"type\":\"plugin\",\"creationDate\":\"June 7th, 2012\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.6.9\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10046, 0, 'K2 Comments', 'module', 'mod_k2_comments', '', 0, 1, 0, 0, '{\"name\":\"K2 Comments\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"MOD_K2_COMMENTS_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_k2_comments.j25\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"\",\"\":\"K2_TOP_COMMENTERS\",\"catfilter\":\"0\",\"category_id\":\"\",\"comments_limit\":\"5\",\"comments_word_limit\":\"10\",\"commenterName\":\"1\",\"commentAvatar\":\"1\",\"commentAvatarWidthSelect\":\"custom\",\"commentAvatarWidth\":\"50\",\"commentDate\":\"1\",\"commentDateFormat\":\"absolute\",\"commentLink\":\"1\",\"itemTitle\":\"1\",\"itemCategory\":\"1\",\"feed\":\"1\",\"commenters_limit\":\"5\",\"commenterNameOrUsername\":\"1\",\"commenterAvatar\":\"1\",\"commenterAvatarWidthSelect\":\"custom\",\"commenterAvatarWidth\":\"50\",\"commenterLink\":\"1\",\"commenterCommentsCounter\":\"1\",\"commenterLatestComment\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10047, 0, 'K2 Content', 'module', 'mod_k2_content', '', 0, 1, 0, 0, '{\"name\":\"K2 Content\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_MOD_K2_CONTENT_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_k2_content.j25\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"filter\",\"\":\"K2_OTHER_OPTIONS\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"itemCount\":\"5\",\"itemsOrdering\":\"\",\"FeaturedItems\":\"1\",\"popularityRange\":\"\",\"videosOnly\":\"0\",\"item\":\"\",\"items\":\"\",\"itemTitle\":\"1\",\"itemAuthor\":\"1\",\"itemAuthorAvatar\":\"1\",\"itemAuthorAvatarWidthSelect\":\"custom\",\"itemAuthorAvatarWidth\":\"50\",\"userDescription\":\"1\",\"itemIntroText\":\"1\",\"itemIntroTextWordLimit\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"Small\",\"itemVideo\":\"1\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemAttachments\":\"1\",\"itemTags\":\"1\",\"itemCategory\":\"1\",\"itemDateCreated\":\"1\",\"itemHits\":\"1\",\"itemReadMore\":\"1\",\"itemExtraFields\":\"0\",\"itemCommentsCounter\":\"1\",\"feed\":\"1\",\"itemPreText\":\"\",\"itemCustomLink\":\"0\",\"itemCustomLinkTitle\":\"\",\"itemCustomLinkURL\":\"http:\\/\\/\",\"itemCustomLinkMenuItem\":\"\",\"K2Plugins\":\"1\",\"JPlugins\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10048, 0, 'K2 Tools', 'module', 'mod_k2_tools', '', 0, 1, 0, 0, '{\"name\":\"K2 Tools\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_TOOLS\",\"group\":\"\",\"filename\":\"mod_k2_tools.j25\"}', '{\"moduleclass_sfx\":\"\",\"module_usage\":\"0\",\"\":\"K2_CUSTOM_CODE_SETTINGS\",\"archiveItemsCounter\":\"1\",\"archiveCategory\":\"\",\"authors_module_category\":\"\",\"authorItemsCounter\":\"1\",\"authorAvatar\":\"1\",\"authorAvatarWidthSelect\":\"custom\",\"authorAvatarWidth\":\"50\",\"authorLatestItem\":\"1\",\"calendarCategory\":\"\",\"home\":\"\",\"seperator\":\"\",\"root_id\":\"\",\"end_level\":\"\",\"categoriesListOrdering\":\"\",\"categoriesListItemsCounter\":\"1\",\"root_id2\":\"\",\"catfilter\":\"0\",\"category_id\":\"\",\"getChildren\":\"0\",\"liveSearch\":\"\",\"width\":\"20\",\"text\":\"\",\"button\":\"\",\"imagebutton\":\"\",\"button_text\":\"\",\"min_size\":\"75\",\"max_size\":\"300\",\"cloud_limit\":\"30\",\"cloud_category\":\"0\",\"cloud_category_recursive\":\"0\",\"customCode\":\"\",\"parsePhp\":\"0\",\"K2Plugins\":\"0\",\"JPlugins\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10049, 0, 'K2 Users', 'module', 'mod_k2_users', '', 0, 1, 0, 0, '{\"name\":\"K2 Users\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_MOD_K2_USERS_DESCRTIPTION\",\"group\":\"\",\"filename\":\"mod_k2_users.j25\"}', '{\"moduleclass_sfx\":\"\",\"getTemplate\":\"Default\",\"source\":\"0\",\"\":\"K2_DISPLAY_OPTIONS\",\"filter\":\"1\",\"K2UserGroup\":\"\",\"ordering\":\"1\",\"limit\":\"4\",\"userIDs\":\"\",\"userName\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"userDescription\":\"1\",\"userDescriptionWordLimit\":\"\",\"userURL\":\"1\",\"userEmail\":\"0\",\"userFeed\":\"1\",\"userItemCount\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10050, 0, 'K2 User', 'module', 'mod_k2_user', '', 0, 1, 0, 0, '{\"name\":\"K2 User\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_MOD_K2_USER_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_k2_user.j25\"}', '{\"moduleclass_sfx\":\"\",\"pretext\":\"\",\"\":\"K2_LOGIN_LOGOUT_REDIRECTION\",\"name\":\"1\",\"userAvatar\":\"1\",\"userAvatarWidthSelect\":\"custom\",\"userAvatarWidth\":\"50\",\"menu\":\"\",\"login\":\"\",\"logout\":\"\",\"usesecure\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10051, 0, 'K2 Quick Icons (admin)', 'module', 'mod_k2_quickicons', '', 1, 1, 2, 0, '{\"name\":\"K2 Quick Icons (admin)\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_QUICKICONS_FOR_USE_IN_THE_JOOMLA_CONTROL_PANEL_DASHBOARD_PAGE\",\"group\":\"\",\"filename\":\"mod_k2_quickicons.j25\"}', '{\"modCSSStyling\":\"1\",\"modLogo\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10052, 0, 'K2 Stats (admin)', 'module', 'mod_k2_stats', '', 1, 1, 2, 0, '{\"name\":\"K2 Stats (admin)\",\"type\":\"module\",\"creationDate\":\"September 21st, 2018\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2018 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"please-use-the-contact-form@joomlaworks.net\",\"authorUrl\":\"www.joomlaworks.net\",\"version\":\"2.9.0\",\"description\":\"K2_STATS_FOR_USE_IN_THE_K2_DASHBOARD_PAGE\",\"group\":\"\",\"filename\":\"mod_k2_stats.j25\"}', '{\"latestItems\":\"1\",\"popularItems\":\"1\",\"mostCommentedItems\":\"1\",\"latestComments\":\"1\",\"statistics\":\"1\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10069, 0, 'AcyMailing Module', 'module', 'mod_acymailing', '', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10072, 0, 'com_jcomments', 'component', 'com_jcomments', '', 1, 1, 0, 0, '{\"legacy\":false,\"name\":\"JComments\",\"type\":\"component\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"3.0.5\",\"description\":\"JComments lets your users comment on content items.\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10073, 0, 'plg_content_jcomments', 'plugin', 'jcomments', 'content', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_content_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_CONTENT_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10074, 0, 'plg_search_jcomments', 'plugin', 'jcomments', 'search', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_search_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_SEARCH_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10075, 0, 'plg_system_jcomments', 'plugin', 'jcomments', 'system', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"plg_system_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_SYSTEM_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 42, 0),
(10076, 0, 'plg_editors-xtd_jcommentson', 'plugin', 'jcommentson', 'editors-xtd', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_editors-xtd_jcommentson\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_EDITORS-XTD_JCOMMENTSON_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10077, 0, 'plg_editors-xtd_jcommentsoff', 'plugin', 'jcommentsoff', 'editors-xtd', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_editors-xtd_jcommentsoff\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_EDITORS-XTD_JCOMMENTSOFF_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10078, 0, 'plg_user_jcomments', 'plugin', 'jcomments', 'user', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_user_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_USER_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10081, 10084, 'FrenchFR', 'language', 'fr-FR', '', 0, 1, 0, 0, '{\"name\":\"French (FR)\",\"type\":\"language\",\"creationDate\":\"07\\/11\\/2018\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2018 Joomla.fr and Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"http:\\/\\/joomla.fr\",\"version\":\"3.9.0.3\",\"description\":\"fr-FR - Site language\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10082, 10084, 'FrenchFR', 'language', 'fr-FR', '', 1, 1, 0, 0, '{\"name\":\"French (FR)\",\"type\":\"language\",\"creationDate\":\"07\\/11\\/2018\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2018 Joomla.fr and Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"http:\\/\\/joomla.fr\",\"version\":\"3.9.0.3\",\"description\":\"fr-FR - Administration language\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10083, 0, 'TinyMCE langue FR', 'file', 'TinyMCE_fr-FR', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"TinyMCE langue FR\",\"type\":\"file\",\"creationDate\":\"4 feb 2013\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"(C) 2005-2013 French Translation Team\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"www.joomla.fr\",\"version\":\"3.5.4.1\",\"description\":\"\\t\\t\\n\\t\\t<h3>Installation du pack de langue FR de TinyMCE 3.5.4.1 pour Joomla 2.5 effectu\\u00e9e avec succ\\u00e8s<\\/h3>\\n \\u00a0 \\u00a0 \\u00a0 \\u00a0<div style=\\\"font-weight:normal\\\">\\n \\t\\tN\'oubliez pas de s\\u00e9lectionner la langue FR dans la \\n \\t\\t<a href=\\\"index.php?option=com_plugins&view=plugins&filter_search=TinyMCE\\\"><strong>gestion du plug-in TinyMCE<\\/strong><\\/a><br \\/>\\n \\t\\tSi vous utilisez la d\\u00e9tection automatique, veillez \\u00e0 ce que soient install\\u00e9s les diff\\u00e9rents packs de langue de TinyMCE correspondants \\n \\t\\t\\u00e0 ceux install\\u00e9s pour Joomla!<\\/div>\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10084, 0, 'French Language pack', 'package', 'pkg_fr-FR', '', 0, 1, 1, 0, '{\"name\":\"French Language pack\",\"type\":\"package\",\"creationDate\":\"07\\/11\\/2018\",\"author\":\"French translation team : joomla.fr\",\"copyright\":\"Copyright (C) 2005 - 2018 Joomla.fr and Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"traduction@joomla.fr\",\"authorUrl\":\"http:\\/\\/joomla.fr\",\"version\":\"3.9.0.3\",\"description\":\"<div style=\\\"text-align:left;\\\">\\n\\n<h3>Joomla! 3.9.0 Full French (fr-FR) Language Package - Version 3.9.0.3<\\/h3>\\n\\n<h3>Paquet de langue Joomla! 3.9.0 fran\\u00e7ais (fr-FR) complet - Version 3.9.0.3<\\/h3>\\n\\n<\\/div>\",\"group\":\"\",\"filename\":\"pkg_fr-FR\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10085, 0, 'GermanDE', 'language', 'de-DE', '', 0, 1, 0, 0, '{\"name\":\"German (DE)\",\"type\":\"language\",\"creationDate\":\"30.10.2018\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2018 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"https:\\/\\/www.jgerman.de\",\"version\":\"3.9.0.1\",\"description\":\"\\n\\t  <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Frontend (Website)-\\u00dcbersetzung f\\u00fcr Joomla! 3.9.0\\n\\t  <br \\/>\\n\\t  <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Frontend (Website) translation for Joomla! 3.9.0\\n\\t\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10086, 0, 'TinyMCE de-DE', 'file', 'file_tinymce_de-DE', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"TinyMCE de-DE\",\"type\":\"file\",\"creationDate\":\"01.08.2013\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2013 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"http:\\/\\/www.jgerman.de\",\"version\":\"2.5.14.1\",\"description\":\"\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Editor (TinyMCE)-\\u00dcbersetzung f\\u00fcr Joomla! 2.5.14\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Editor (TinyMCE) translation for Joomla! 2.5.14\\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10087, 0, 'GermanDE', 'language', 'de-DE', '', 1, 1, 0, 0, '{\"name\":\"German (DE)\",\"type\":\"language\",\"creationDate\":\"30.10.2018\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2018 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"https:\\/\\/www.jgerman.de\",\"version\":\"3.9.0.1\",\"description\":\"\\n\\t<img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"German (Deutsch)\\\" src=\\\"data:;base64,R0lGODlhEgAMAJEAAP\\/OAAAAAN0AAAAAACH5BAAAAAAALAAAAAASAAwAAAIXjI+py+2vhJy02ouz3hb4D4biSJbmKRYAOw==\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>Deutsche Backend (Administrator)-\\u00dcbersetzung f\\u00fcr Joomla! 3.9.0\\n      <br \\/>\\n      <img style=\\\"margin: 5px; vertical-align: middle;\\\" alt=\\\"English (Englisch)\\\" src=\\\"data:image\\/gif;base64,R0lGODlhEgAMAPcAANQYLe+nr+iPmgElcdQuQtQtQtq\\/zc8UK88TKu2Sm+A4SOucpn2RvxIseCBLmRIpdtIWLAEkctAUK\\/\\/f3g4tguqXodozRcwDHNa8y8fT5h9GlP\\/7+R82fcwIIPOCiRg2fwc0fP\\/6+AEohAwqgffV2QYuhfaTmQApgi1VngAZd9Y0SOmTnaysytIjOPixtbZlgOxVYehUYPbP09FqfWByq\\/XL0BIndO2Fju6AieZ8iQAaed9gcOnm7t28wgEpdImUt2B\\/uOtWYsAPHP\\/o5t5SYdzs98pwd\\/KXn\\/\\/v7tjo9WRyqXBtkgEdbPbu8c0MJHdomvB4gHBglMwGH7Nphm6Zy9Pq6uufqfjh5NUwRM8SKhIqd9c5TNc4TNUxRRIjcxAvg9FpfPCmpiBOjv\\/r6cYgKhIfb\\/\\/i4fSTmdm+zClSnOiMl+dXY1RioK5kgxg5hPOZoNMpPmh\\/tTxalmqFut\\/G0tchLdni765RcOiOmQAgfcHZ7v77+3J4o+6UnfTKz\\/\\/\\/\\/OurtYScx66wzThepMy7vwAeeiJLmumQmv\\/m5QAceN00RmOBqgEnc9zr9+lWY+qWoNY0Rw80eudUYWZ1qytZk+unsAYxiup5g+iSnX6Ww7Vif9EQH\\/Df5dbc6hIqdt3w+\\/\\/q6MwFHfOLkuj6\\/+ylrgAVde+aotPQ3+yMls8VLNbc69+lo+6nr9tHWAAPcLTI480GHssAGf\\/\\/\\/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAASAAwAAAjoAH9wKPOggZYPPepsCiPHRgNPXtzwGVKEwZdShUoYAAArAIpEKSwp0RTDERREjRiMyIOGYwAHIia9kORhApspRC6NsZOJDgRYlQK1WYODxKc5gjJcYeUnxB8ZCKRYQeKihqw9p1goUNRlC6QCBOAcyNICCxcVBApYUBCrrdtYFw6k6vDW7RsBAlYsqJAgBwInO\\/ocwvNoAaYjQPTIkmXKBA9OEkIBGiVrg5oEqqi8aoIqyIwoGjBwJDWIRiczN1rdOQMDzBNDOk5s7JjGFYU4SUCJMrJETIQBPkAQIiNkFaUBjJhEWlQlIAA7\\\" height=\\\"12\\\" width=\\\"18\\\" \\/>German Backend (Administrator) translation for Joomla! 3.9.0\\n\\t\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10088, 0, 'German (Germany) Language Pack', 'package', 'pkg_de-DE', '', 0, 1, 1, 0, '{\"name\":\"German (Germany) Language Pack\",\"type\":\"package\",\"creationDate\":\"30.10.2018\",\"author\":\"J!German\",\"copyright\":\"Copyright (C) 2008 - 2018 J!German. All rights reserved.\",\"authorEmail\":\"team@jgerman.de\",\"authorUrl\":\"https:\\/\\/www.jgerman.de\",\"version\":\"3.9.0.1\",\"description\":\"\\n\\t<div style=\\\"text-align: center;\\\">\\n        <h2>Deutsches \\u201eFull\\u201c-Sprachpaket f\\u00fcr Joomla! 3.9.0 von <a title=\\\"J!German\\\" href=\\\"https:\\/\\/www.jgerman.de\\\" target=\\\"_blank\\\">J!German<\\/a><\\/h2>\\n        <h3><span style=\\\"color: #008000;\\\">\\u00dcbersetzungsversion: 3.9.0.1<\\/span><\\/h3>\\n        <hr \\/>\\n        <table rules=\\\"all\\\" frame=\\\"border\\\" style=\\\"width: 90%; border-color: #000000; border-width: 1px; border-style: solid;\\\" align=\\\"center\\\" border=\\\"1\\\">\\n        <colgroup> <col width=\\\"30%\\\" \\/> <col width=\\\"60\\\" \\/> <\\/colgroup>\\n        <tbody>\\n          <tr>\\n            <td>\\n              <ul>\\n                <li>Frontend (Website)-\\u00dcbersetzung<\\/li>\\n              <\\/ul>\\n            <\\/td>\\n            <td rowspan=\\\"2\\\">\\n              <ul>\\n                <li>\\n                  <span style=\\\"text-decoration: underline;\\\">Neuinstallation:<\\/span>\\n                  <br \\/>\\n                  Legen Sie die deutsche Sprache unter <a title=\\\"Language(s)\\\" href=\\\"index.php?option=com_languages\\\" target=\\\"_blank\\\">\\u201eExtensions\\u201c \\u2192 \\u201eLanguage(s)\\u201c<\\/a> als Standardsprache (\\u201eDefault\\u201c), sowohl f\\u00fcr die Website (\\u201eInstalled - Site\\u201c) als auch f\\u00fcr die Administration (\\u201eInstalled - Administrator\\u201c), fest.\\n                <\\/li>\\n                <br \\/>\\n                <li>\\n                  <span style=\\\"text-decoration: underline;\\\">Aktualisierung:<\\/span>\\n                  <br \\/>\\n                  Es sind keine weiteren Schritte erforderlich.\\n                <\\/li>\\n              <\\/ul>\\n            <\\/td>\\n          <\\/tr>\\n          <tr>\\n            <td>\\n              <ul>\\n                <li>Backend (Administrator)-\\u00dcbersetzung<\\/li>\\n              <\\/ul>\\n            <\\/td>\\n          <\\/tr>\\n        <\\/tbody>\\n        <\\/table>\\n        <br \\/>\\n        <span style=\\\"text-decoration: underline;\\\">Hinweis:<\\/span> Dieses Paket unterst\\u00fctzt die Joomla! eigene <a title=\\\"Joomla!-Aktualisierungsfunktion\\\" href=\\\"index.php?option=com_installer&amp;view=update\\\" target=\\\"_blank\\\">Aktualisierungsfunktion<\\/a>!\\n      <\\/div>\\n\\t\",\"group\":\"\",\"filename\":\"pkg_de-DE\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10090, 0, 'MOD_ITPFBLIKEBOX', 'module', 'mod_itpfblikebox', '', 0, 1, 0, 0, '{\"name\":\"MOD_ITPFBLIKEBOX\",\"type\":\"module\",\"creationDate\":\"18 May, 2015\",\"author\":\"Todor Iliev\",\"copyright\":\"Copyright (C) 2015 Todor Iliev ( ITPrism.com )\",\"authorEmail\":\"todor@itprism.com\",\"authorUrl\":\"http:\\/\\/itprism.com\",\"version\":\"1.11\",\"description\":\"\\n        <p><a href=\'http:\\/\\/itprism.com\\/free-joomla-extensions\\/social-marketing-seo\\/facebook-like-box\' target=\'_blank\'>ITPFacebookLikeBox<\\/a> adds Facebook Page promoting box on your website.<\\/p>\\n        <p><a href=\'http:\\/\\/itprism.com\\/help\\/34-facebook-likebox-documentation-faq\' target=\'_blank\'>Read documentation<\\/a> that will help you to setup the extensions.<\\/p>\\n        <p><a href=\'http:\\/\\/itprism.com\\/\' target=\'_blank\'>Subscribe for the newsletter<\\/a> to receive information about updates and new ITPrism extensions.<\\/p>\\n        <p>Please, vote for this module on <a href=\'http:\\/\\/extensions.joomla.org\\/extensions\\/social-web\\/facebook-display\\/15754\' target=\'_blank\'>Joomla! Extensions Directory!<\\/a><\\/p>\\n    \",\"group\":\"\",\"filename\":\"mod_itpfblikebox\"}', '{\"fbPageLink\":\"\",\"fbRendering\":\"2\",\"fbWidth\":\"250\",\"fbHeight\":\"827\",\"fbColour\":\"light\",\"fbBColour\":\"\",\"fbFaces\":\"1\",\"fbStream\":\"1\",\"fbHeader\":\"1\",\"fbDynamicLocale\":\"1\",\"fbLocale\":\"en_US\",\"facebookLikeAppId\":\"\",\"fbLoadJsLib\":\"1\",\"facebookRootDiv\":\"1\",\"facebookForceWall\":\"0\",\"facebookResponsive\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10091, 0, 'Tabs & Sliders (by JoomlaWorks)', 'module', 'mod_jw_ts', '', 0, 1, 0, 0, '{\"legacy\":true,\"name\":\"Tabs & Sliders (by JoomlaWorks)\",\"type\":\"module\",\"creationDate\":\"January 27th, 2012\",\"author\":\"JoomlaWorks\",\"copyright\":\"Copyright (c) 2006 - 2012 JoomlaWorks Ltd. All rights reserved.\",\"authorEmail\":\"contact@joomlaworks.gr\",\"authorUrl\":\"www.joomlaworks.gr\",\"version\":\"2.0\",\"description\":\"MOD_JW_TS_TABS_AND_SLIDERS_MODULE_BY_JOOMLAWORKS\",\"group\":\"\"}', '{\"moduleclass_sfx\":\"\",\"jwts_position\":\"\",\"jwts_displaytype\":\"tabs\",\"jwts_showmodtitle\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10093, 0, 'Social Media Icon Links', 'module', 'mod_socialmedialinks', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"Social Media Icon Links\",\"type\":\"module\",\"creationDate\":\"January 2011\",\"author\":\"Viper Web Solutions\",\"copyright\":\"Copyright (C) 2008 - 2011 Viper Web Solutions. All rights reserved. Defualt icons provided by http:\\/\\/jwloh.deviantart.com\\/ - jwloh01@gmail.com\",\"authorEmail\":\"Dallas@viperwebsites.com\",\"authorUrl\":\"www.viperwebsites.com\",\"version\":\"1.6.0\",\"description\":\"MOD_SOCIALMEDIALINKS_V1.6\",\"group\":\"\"}', '{\"theme\":\"default\",\"size\":\"size3\",\"align\":\"center\",\"margin\":\"3px\",\"text\":\"Follow us on\",\"rsstext\":\"RSS Feed\",\"target\":\"_blank\",\"robots\":\"1\",\"credits\":\"1\",\"@spacer\":\"\",\"ic1\":\"\",\"url1\":\"\",\"spacer\":\"\",\"ic2\":\"\",\"url2\":\"\",\"ic3\":\"\",\"url3\":\"\",\"ic4\":\"\",\"url4\":\"\",\"ic5\":\"\",\"url5\":\"\",\"ic6\":\"\",\"url6\":\"\",\"ic7\":\"\",\"url7\":\"\",\"ic8\":\"\",\"url8\":\"\",\"ic9\":\"\",\"url9\":\"\",\"ic10\":\"\",\"url10\":\"\",\"ic11\":\"\",\"url11\":\"\",\"ic12\":\"\",\"url12\":\"\",\"ic13\":\"\",\"url13\":\"\",\"ic14\":\"\",\"url14\":\"\",\"ic15\":\"\",\"url15\":\"\",\"ic16\":\"\",\"url16\":\"\",\"ic17\":\"\",\"url17\":\"\",\"ic18\":\"\",\"url18\":\"\",\"ic19\":\"\",\"url19\":\"\",\"ic20\":\"\",\"url20\":\"\",\"ic21\":\"\",\"url21\":\"\",\"ic22\":\"\",\"url22\":\"\",\"ic23\":\"\",\"url23\":\"\",\"ic24\":\"\",\"url24\":\"\",\"ic25\":\"\",\"url25\":\"\",\"ic26\":\"\",\"url26\":\"\",\"ic27\":\"\",\"url27\":\"\",\"ic28\":\"\",\"url28\":\"\",\"ic29\":\"\",\"url29\":\"\",\"ic30\":\"\",\"url30\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10095, 0, 'YJ Pop Login', 'module', 'mod_yj_pop_login', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"YJ Pop Login\",\"type\":\"module\",\"creationDate\":\"12-19-2011\",\"author\":\"Youjoomla\",\"copyright\":\"Youjoomla LLC.\",\"authorEmail\":\"youjoomla@gmail.com\",\"authorUrl\":\"www.youjoomla.com\",\"version\":\"1.0.1\",\"description\":\"\\n\\t\\t<style type=\\\"text\\/css\\\" media=\\\"all\\\">#wrap1 {padding:0px 0px 4px 0px;}h1 {clear:both;font-family: Arial Narrow,sans-serif;font-size:18px;margin:0px 0px 12px 0px;padding:0px 0px 1px 10px;color:#C64934;}.wrap2 {background:#F7F7F7;display:block;overflow:hidden;padding:15px;}<\\/style><div id=\\\"holdthem\\\"><h1>YJ Pop Login Module for Joomla 1.6x and UP<\\/h1><br \\/><div class=\\\"wrap2\\\"><a title=\\\"Visit the official website!\\\" href=\\\"http:\\/\\/www.youjoomla.com\\\"> <img style=\\\"float:left;border:1px solid #CFCFCF;margin:0px 15px 4px 22px;\\\" src=\\\"..\\/modules\\/mod_yj_pop_login\\/images\\/yj_extensions.jpg\\\" border=\\\"0\\\" alt=\\\"Logo\\\" \\/><\\/a>\\n\\t\",\"group\":\"\"}', '{\"cache\":\"1\",\"@spacer\":\"\",\"moduleclass_sfx\":\"\",\"pretext\":\"Welcome,Guest <br \\/> <br \\/><span> Please login or register<\\/span>\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10096, 0, 'PLG_SYSTEM_JQUERYEASY', 'plugin', 'jqueryeasy', 'system', 0, 0, 1, 0, '{\"name\":\"PLG_SYSTEM_JQUERYEASY\",\"type\":\"plugin\",\"creationDate\":\"2012-10-21\",\"author\":\"Olivier Buisard\",\"copyright\":\"Copyright (C) 2011 Simplify Your Web. All rights reserved.\",\"authorEmail\":\"olivier.buisard@simplifyyourweb.com\",\"authorUrl\":\"www.simplifyyourweb.com\",\"version\":\"2.2.3\",\"description\":\"PLG_SYSTEM_JQUERYEASY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"jqueryeasy\"}', '{\"jqueryinfrontend\":\"2\",\"jqueryversionfrontend\":\"1.8\",\"jquerysubversionfrontend\":\"\",\"localversionfrontend\":\"\",\"localpathmigratefrontend\":\"\",\"jqueryuiversionfrontend\":\"1.8\",\"jqueryuisubversionfrontend\":\"\",\"localuiversionfrontend\":\"\",\"jqueryuithemefrontend\":\"none\",\"jqueryuithemecustomfrontend\":\"\",\"whichhttpfrontend\":\"https\",\"compressionfrontend\":\"compressed\",\"templateid\":[\"none\"],\"enableonlyinfrontend\":\"\",\"disableinfrontend\":\"\",\"replacewhenuniquefrontend\":\"1\",\"addwhenmissingfrontend\":\"1\",\"ignorescriptsfrontend\":\"com_virtuemart\\/assets\\/js\\/chosen.jquery.min.js\",\"stripremainingscriptsfrontend\":\"\",\"stripremainingcssfrontend\":\"\",\"removenoconflictfrontend\":\"1\",\"addnoconflictfrontend\":\"2\",\"replacedocumentreadyfrontend\":\"0\",\"disablemootools\":\"0\",\"keepmootoolsin\":\"\",\"disablecaptions\":\"0\",\"removeblanklinesfrontend\":\"0\",\"addjavascriptfrontend\":\"\",\"addjavascriptdeclarationfrontend\":\"\",\"addcssfrontend\":\"\",\"addcssdeclarationfrontend\":\"\",\"jqueryinbackend\":\"0\",\"jqueryversionbackend\":\"1.7\",\"jquerysubversionbackend\":\"\",\"localversionbackend\":\"\",\"localpathmigratebackend\":\"\",\"jqueryuiversionbackend\":\"1.9\",\"jqueryuisubversionbackend\":\"\",\"localuiversionbackend\":\"\",\"jqueryuithemebackend\":\"base\",\"jqueryuithemecustombackend\":\"\",\"whichhttpbackend\":\"https\",\"compressionbackend\":\"compressed\",\"enableonlyinbackend\":\"\",\"disableinbackend\":\"\",\"replacewhenuniquebackend\":\"1\",\"addwhenmissingbackend\":\"1\",\"ignorescriptsbackend\":\"\",\"stripremainingscriptsbackend\":\"\",\"stripremainingcssbackend\":\"\",\"removenoconflictbackend\":\"1\",\"addnoconflictbackend\":\"2\",\"replacedocumentreadybackend\":\"0\",\"removeblanklinesbackend\":\"0\",\"addjavascriptbackend\":\"\",\"addjavascriptdeclarationbackend\":\"\",\"addcssbackend\":\"\",\"addcssdeclarationbackend\":\"\",\"back_compat_paths\":\"1\",\"showreport\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 44, 0),
(10100, 0, 'com_virtuemart_it-IT', 'file', 'com_virtuemart_it-IT', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"com_virtuemart_it-IT\",\"type\":\"file\",\"creationDate\":\"December 21 2012\",\"author\":\"The VirtueMart Development and Translation Team\",\"copyright\":\"Copyright (C) 2004-2012 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"2.0.16\",\"description\":\"This it-IT language pack for VirtueMart has been installed successfully. It includes files for the component.ini, modules, and plugins. Some languages may not have all the files.\\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10103, 0, 'plg_system_vm2_cart', 'plugin', 'vm2_cart', 'system', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_system_vm2_cart\",\"type\":\"plugin\",\"creationDate\":\"March 2012\",\"author\":\"xxx\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.1\",\"description\":\"Plg System VM2Cart\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 40, 0),
(10104, 0, 'System - Virtuemart Slider', 'plugin', 'vmslider', 'system', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"System - Virtuemart Slider\",\"type\":\"plugin\",\"creationDate\":\"July, 2012\",\"author\":\"Lamvt (Lamvt19792003@gmail.com)\",\"copyright\":\"(C) http:\\/\\/joomquery.com All rights reserved.\",\"authorEmail\":\"lamvt19792003@gmail.com\",\"authorUrl\":\"http:\\/\\/joomquery.com\",\"version\":\"2.5.0\",\"description\":\"\\t\\n\\tPlugin Virtuemar slider developed by Lamvt (lamvt19792003@gmail.com) http:\\/\\/joomquery.com, Vinaora team ! <br\\/ >\\n\\t\\t<p><strong>Joomquery.com Free Joomla templates, free Joomla extensions<br \\/>\\n\\t\\t\\tWe provide the best solutions for you to choice great templates - skins for your website.\\n\\nTemplates - Skins are semi-designed websites for you to add your contents - site map so you\'re ready to start website. You can edite - customize your website with any ideas.\\n\\t\\t<\\/strong><\\/p>\\n\\t\\t<br \\/>\\n\\t\\t<br \\/>\\n\\t\\t<strong>Vinaora team products<\\/strong>\\n\\t\\t<br \\/>\\n\\t\\t<ul>\\n\\t\\t\\t<li>\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/joomquery.com\\/en\\/home\\/our-products\\/73-vinaora-nivo-slider-joomla-mudule.html\\\">Vinaora Nivo Slider - joomla mudule<\\/a>\\n\\t\\t\\t<\\/li>\\n\\t\\t\\t<li>\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/joomquery.com\\/en\\/home\\/our-products\\/71-vinaora-slick-slideshow-joomla-module.html\\\">Vinaora Slick Slideshow - joomla module<\\/a>\\n\\t\\t\\t<\\/li>\\n\\t\\t\\t<li>\\t\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/joomquery.com\\/en\\/home\\/our-products\\/68-vinaora-cu3er-3d-slideshow-joomla-module.html\\\">Vinaora Cu3er 3D Slideshow - joomla module<\\/a>\\n\\t\\t\\t<\\/li>\\n\\t\\t\\t<li>\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/joomquery.com\\/en\\/home\\/our-products\\/67-vinaora-visitors-counter-joomla-components-module.html\\\">Vinaora Visitors Counter - joomla components module<\\/a>\\n\\t\\t\\t<\\/li>\\n\\t\\t\\t<li>\\n\\t\\t\\t\\t<a href=\\\"http:\\/\\/joomquery.com\\/en\\/home\\/our-products\\/64-vinaora-world-time-clock-joomla-module.html\\\">Vinaora World Time Clock - joomla module<\\/a>\\n\\t\\t\\t<\\/li>\\n\\t\\t<\\/ul>\\n\\t\\t\\n\\t\\t\\n\\t\",\"group\":\"\"}', '{\"imageWidth\":\"380\",\"imageHeight\":\"auto\",\"thumbimageWidth\":\"78\",\"thumbimageHeight\":\"auto\",\"on_off\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 28, 0),
(10105, 0, 'MOD_JGMAP', 'module', 'mod_JGMap', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"MOD_JGMAP\",\"type\":\"module\",\"creationDate\":\"June 13, 2010\",\"author\":\"Kermode Bear Software - James Hansen\",\"copyright\":\"Copyright 2011 Notice\",\"authorEmail\":\"kermode@kermodesoftware.com\",\"authorUrl\":\"www.kermodesoftware.com\",\"version\":\"1.0.37\",\"description\":\"MOD_JGMAP_XML_DESCRIPTION\",\"group\":\"\"}', '{\"width\":\"200\",\"height\":\"150\",\"smallmap\":\"1\",\"static\":\"0\",\"lat\":\"48.5747\",\"lng\":\"-123\",\"zoom\":\"3\",\"marker_title\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10113, 0, 't3_blank', 'template', 't3_blank', '', 0, 1, 1, 0, '{\"name\":\"t3_blank\",\"type\":\"template\",\"creationDate\":\"02 December 2013\",\"author\":\"JoomlArt.com\",\"copyright\":\"Copyright (C), J.O.O.M Solutions Co., Ltd. All Rights Reserved.\",\"authorEmail\":\"webmaster@joomlart.com\",\"authorUrl\":\"http:\\/\\/www.t3-framework.org\",\"version\":\"2.1.6\",\"description\":\"Reviver joom3.x V1.2\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10114, 0, 'System - KeyCAPTCHA', 'plugin', 'keycaptcha', 'system', 0, 0, 1, 0, '{\"legacy\":true,\"name\":\"System - KeyCAPTCHA\",\"type\":\"plugin\",\"creationDate\":\"2013-04-16\",\"author\":\"Mersane, Ltd\",\"copyright\":\"(C) 2011-2012 Mersane, Ltd\",\"authorEmail\":\"support@keycaptcha.com\",\"authorUrl\":\"https:\\/\\/www.keycaptcha.com\\/\",\"version\":\"5.0.9\",\"description\":\"\\n\\t\\t\\n\\t\\t\\tAdds KeyCAPTCHA anti-spam solution to Joomla.<br \\/><br \\/>\\n\\t\\t\\t<span style=\\\"color:#CC0000; font-weight:bold;\\\">\\n\\t\\t\\t\\tTo enable KeyCAPTCHA plugin please do the following:\\n\\t\\t\\t\\t<ol>\\n\\t\\t\\t\\t\\t<li>\\n\\t\\t\\t\\t\\t\\tFill in \\\"Private key\\\" field on a page with properties of KeyCAPTCHA plugin.<br \\/>\\n\\t\\t\\t\\t\\t\\t&nbsp;&nbsp;&nbsp;&nbsp;To open that page please click on the plugin name (\\\"System - KeyCAPTCHA\\\") in Joomla Plugin Manager.<br \\/>\\n\\t\\t\\t\\t\\t\\t&nbsp;&nbsp;&nbsp;&nbsp;To get the value for \\\"Private key\\\" field please register your site at <a target=\\\"_blank\\\" href=\\\"https:\\/\\/www.keycaptcha.com\\\">www.keycaptcha.com<\\/a>\\n\\t\\t\\t\\t\\t<\\/li>\\n\\t\\t\\t\\t\\t<li>\\n\\t\\t\\t\\t\\t\\tEnable KeyCAPTCHA plugin in Joomla Plugin Manager (<a href=\\\"index.php?option=com_plugins&view=plugins&filter_folder=system\\\">Joomla Plugin Manager<\\/a>)\\n\\t\\t\\t\\t\\t<\\/li>\\n\\t\\t\\t\\t<\\/ol>\\n\\t\\t\\t<\\/span>\\n\\t\\t\\n\\t\",\"group\":\"\"}', '{\"keycaptcha_site_private_key\":\"ncWayWmNAzSJvRbTdyNRzxITvYUvpC057635 \",\"KC_DisableForLogged\":\"Yes\",\"KC_RocketTheme\":\"No\",\"KC_RegistrationForm\":\"Yes\",\"KC_ResetForm\":\"Yes\",\"KC_RemindForm\":\"Yes\",\"KC_ContactUs\":\"Yes\",\"KC_Comments\":\"No\",\"KC_GuestBook\":\"Yes\",\"KC_JoomShopping\":\"No\",\"KC_AppCal\":\"No\",\"KC_VirtueMartRegistration\":\"No\",\"KC_VirtueMartAsk\":\"Yes\",\"KC_ADSManager\":\"No\",\"KC_JobBoard\":\"No\",\"KC_DonationConfirmForm\":\"Yes\",\"KC_DonationForm\":\"Yes\",\"keycaptcha_html\":\"(lt)br(gt)(lt)div id=\'keycaptcha_div\' style=\'height:auto; padding:0; margin:0; display:table; border:none;\'(gt)#keycaptcha#(lt)\\/div(gt)(lt)br(gt)\",\"keycaptcha_custom_task_text\":\"\",\"KC_AllowKCLink\":\"No\"}', '', '', 0, '0000-00-00 00:00:00', 25, 0),
(10115, 0, 'VM - Custom, skip cart', 'plugin', 'vmskipcart', 'system', 0, 0, 1, 0, '{\"legacy\":true,\"name\":\"VM - Custom, skip cart\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Daycounts.com\",\"copyright\":\"Copyright (C) 2011 Daycounts. All rights reserved.\",\"authorEmail\":\"info@daycounts.com\",\"authorUrl\":\"http:\\/\\/www.daycounts.com\",\"version\":\"1.0.0\",\"description\":\"This plugin skips the cart page and redirects directly to checkout page.\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 27, 0),
(10116, 0, 'plg_authentication_emailorusername', 'plugin', 'emailorusername', 'authentication', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_authentication_emailorusername\",\"type\":\"plugin\",\"creationDate\":\"May 2013\",\"author\":\"RuposTel.com\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved. modified by RuposTel.com\",\"authorEmail\":\"admin@rupostel.com\",\"authorUrl\":\"www.rupostel.com\",\"version\":\"2.5.1\",\"description\":\"PLG_AUTH_EMAILORUSERNAME_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10125, 0, 'JComments - Avatar', 'plugin', 'avatar', 'jcomments', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"JComments - Avatar\",\"type\":\"plugin\",\"creationDate\":\"11\\/12\\/2013\",\"author\":\"smart\",\"copyright\":\"(c) 2007-2013 JoomlaTune.ru\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"4.1.3\",\"description\":\"PLG_JCOMMENTS_AVATAR_XML_DESCRIPTION\",\"group\":\"\"}', '{\"avatar_type\":\"k2\",\"avatar_default_avatar\":\"default\",\"avatar_custom_default_avatar\":\"\",\"avatar_link\":\"0\",\"avatar_link_target\":\"_blank\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10126, 0, 'K2 - JComments', 'plugin', 'jcomments', 'k2', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"K2 - JComments\",\"type\":\"plugin\",\"creationDate\":\"04\\/07\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2010-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.3.3\",\"description\":\"PLG_K2_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"autosubscribe\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10127, 0, 'VM - Search autocomplete', 'plugin', 'vm_search_ac', 'system', 0, 0, 1, 0, '{\"name\":\"VM - Search autocomplete\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"Bob\",\"copyright\":\"Copyright (C) 2011 virtuemart. All rights reserved.\",\"authorEmail\":\"info@bob.com\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"VM - Search autocomplete\",\"group\":\"\",\"filename\":\"vm_search_ac\"}', '{\"loadmj\":\"0\",\"minChars\":\"3\",\"delay\":\"400\",\"searchchilds\":\"0\",\"searchsku\":\"1\",\"searchcat\":\"0\",\"searchmanuf\":\"0\",\"max\":\"5\",\"width\":\"298\",\"showimg\":\"1\",\"showsku\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 23, 0),
(10129, 0, 'VirtueMart_allinone', 'component', 'com_virtuemart_allinone', '', 1, 1, 0, 0, '{\"name\":\"VirtueMart_allinone\",\"type\":\"component\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2017 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10130, 0, 'VirtueMart Shopping Cart', 'module', 'mod_virtuemart_cart', '', 0, 1, 0, 0, '{\"name\":\"VirtueMart Shopping Cart\",\"type\":\"module\",\"creationDate\":\"October 07 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.2\",\"description\":\"Mod Virtuemart Cart\",\"group\":\"\",\"filename\":\"mod_virtuemart_cart\"}', '{\"moduleclass_sfx\":\"\",\"show_price\":\"1\",\"show_product_list\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10132, 0, 'Virtuemart2.0.x products', 'module', 'mod_vm2_products', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"Virtuemart2.0.x products\",\"type\":\"module\",\"creationDate\":\"Jyuly 2013\",\"author\":\"SomeBody\",\"copyright\":\"Copyright Info\",\"authorEmail\":\"email@example.org\",\"authorUrl\":\"http:\\/\\/www.joomla-code.ru\",\"version\":\"0.0.1\",\"description\":\"\",\"group\":\"\"}', '{\"feat\":\"1\",\"layout_feat\":\"layout\",\"featTitle\":\"Featured Products\",\"max_items_feat\":\"2\",\"products_per_row_feat\":\"1\",\"stock_feat\":\"0\",\"show_img_feat\":\"1\",\"show_title_feat\":\"1\",\"show_desc_feat\":\"1\",\"row_desc_feat\":\"40\",\"show_cat_feat\":\"1\",\"show_rating_feat\":\"1\",\"show_price_feat\":\"1\",\"show_details_feat\":\"1\",\"show_addcart_feat\":\"1\",\"headerText_feat\":\"\",\"footerText_feat\":\"\",\"featured_source\":\"\",\"featured_outsource\":\"\",\"class_sfx_feat\":\"feat\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10134, 0, 'VirtueMart Countdown', 'module', 'mod_virtuemart_countdown', '', 0, 1, 0, 0, '{\"name\":\"VirtueMart Countdown\",\"type\":\"module\",\"creationDate\":\"10 April 2012\",\"author\":\"Cecil Gupta\",\"copyright\":\"Copyright (C) 20011 Cecil Gupta. All rights reserved. \",\"authorEmail\":\"cecilgupta@gmail.com\",\"authorUrl\":\"http:\\/\\/www.bronzecode.com\",\"version\":\"1.2.0\",\"description\":\"Countdown Timer for VirtueMart Product discounts.\",\"group\":\"\",\"filename\":\"mod_virtuemart_countdown\"}', '{\"sale_text\":\"\",\"product_id\":\"\",\"theme\":\"1\",\"time_format\":\"hours\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"debug_mode\":\"0\",\"cache\":\"0\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10138, 10141, 'Russian', 'language', 'ru-RU', '', 0, 1, 0, 0, '{\"name\":\"Russian\",\"type\":\"language\",\"creationDate\":\"2018-09-13\",\"author\":\"Russian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"smart@joomlaportal.ru\",\"authorUrl\":\"www.joomlaportal.ru\",\"version\":\"3.8.12.1\",\"description\":\"Russian language pack (site) for Joomla! 3.8.12\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10139, 10141, 'ru-RU', 'language', 'ru-RU', '', 1, 1, 0, 0, '{\"name\":\"\\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439 (ru-RU)\",\"type\":\"language\",\"creationDate\":\"2018-09-13\",\"author\":\"Russian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters. All rights reserved.\",\"authorEmail\":\"smart@joomlaportal.ru\",\"authorUrl\":\"www.joomlaportal.ru\",\"version\":\"3.8.12.1\",\"description\":\"Russian language pack (administrator) for Joomla! 3.8.12\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10140, 0, 'TinyMCE ru-RU', 'file', 'tinymce_ru-ru', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"TinyMCE ru-RU\",\"type\":\"file\",\"creationDate\":\"2012-06-19\",\"author\":\"Russian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved\",\"authorEmail\":\"smart@joomlaportal.ru\",\"authorUrl\":\"www.joomlaportal.ru\",\"version\":\"3.5.2.1\",\"description\":\"Russian Language Package for TinyMCE 3.5.2.1 in Joomla 2.5\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10141, 0, 'Russian (ru-RU) Language Pack', 'package', 'pkg_ru-RU', '', 0, 1, 1, 0, '{\"name\":\"Russian (ru-RU) Language Pack\",\"type\":\"package\",\"creationDate\":\"2018-09-13\",\"author\":\"Russian Translation Team\",\"copyright\":\"Copyright (C) 2005 - 2017 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"smart@joomlaportal.ru\",\"authorUrl\":\"www.joomlaportal.ru\",\"version\":\"3.8.12.1\",\"description\":\"Joomla 3.8 Russian Language Package\",\"group\":\"\",\"filename\":\"pkg_ru-RU\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10142, 0, 'com_virtuemart - ru-RU', 'file', 'com_virtuemart-ru-RU', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"com_virtuemart - ru-RU\",\"type\":\"file\",\"creationDate\":\"20.08.2013\",\"author\":\"VirtueMart language team\",\"copyright\":\"\\u00a9 2008-2013 - compojoom-com. All rights reserved!\",\"authorEmail\":\"max@virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"2013-08-20-01-19-20\",\"description\":\"\\n        This package was auto generated with CTransifex(https:\\/\\/compojoom.com). We\'ve grabbed the latest language files for our extension from transifex.com.\\n        Special thanks to OpenTranslators (http:\\/\\/opentranslators.org) for helping us with this translation!\\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10146, 0, 'Netbase Virtuemart Multiupload', 'plugin', 'virtuemart_multiupload', 'system', 0, 0, 1, 0, '{\"legacy\":true,\"name\":\"Netbase Virtuemart Multiupload\",\"type\":\"plugin\",\"creationDate\":\"09-2012\",\"author\":\"netbase.vn\",\"copyright\":\"Copyright (C) 2012\",\"authorEmail\":\"huy@netbase.vn\",\"authorUrl\":\"http:\\/\\/www.cms-extensions.net\",\"version\":\"3.0\",\"description\":\"Plugin multiupload image product for Joomla 2.5.x and Virtuemart 2.0.10\",\"group\":\"\"}', '{\"description\":\"<p>Upload files<\\/p>\",\"max_size\":\"2\",\"load_jquery\":\"1\",\"load_jquery_noconflict\":\"1\",\"load_jquery_ui\":\"1\",\"load_jquery_ui_css\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 41, 0),
(10148, 0, 'PLG_SYSTEM_SCRIPTMERGE', 'plugin', 'scriptmerge', 'system', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"PLG_SYSTEM_SCRIPTMERGE\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Yireo\",\"copyright\":\"Copyright (C) 2013 Yireo.com. All rights reserved.\",\"authorEmail\":\"info@yireo.com\",\"authorUrl\":\"www.yireo.com\",\"version\":\"0.9.12\",\"description\":\"PLG_SYSTEM_SCRIPTMERGE_DESC\",\"group\":\"\"}', '{\"merge_type\":\"md5sum\",\"enable_css\":\"0\",\"enable_js\":\"1\",\"compress_css\":\"0\",\"compress_js\":\"0\",\"skip_compressed\":\"1\",\"exclude_css\":\"\",\"exclude_js\":\"facebox.js,jquery.form.js,vmsite.js,vmprices.js,vmprices2.js,\\/mod_virtuemart_param_filter\\/assets\\/js.js,iview.pack.js,mootools-core.js,core.js,caption.js,jquery.carouFredSel-6.1.0-packed.js,Cookie.js\",\"exclude_components\":\"\",\"frontend\":\"1\",\"backend\":\"0\",\"use_comments\":\"0\",\"compress_html\":\"0\",\"expiration\":\"30\",\"version\":\"1\",\"follow_imports\":\"1\",\"data_uris\":\"0\",\"data_uris_filesize\":\"2000\",\"use_webp\":\"0\",\"cwebp\":\"\",\"use_jsmin\":\"0\",\"jsmin\":\"\",\"async_merged\":\"0\",\"js_position\":\"head_end\",\"css_position\":\"first_tag\",\"force_gzip\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 22, 0),
(10149, 0, 'com_xmap', 'component', 'com_xmap', '', 1, 1, 0, 0, '{\"legacy\":false,\"name\":\"com_xmap\",\"type\":\"component\",\"creationDate\":\"2011-04-10\",\"author\":\"Guillermo Vargas\",\"copyright\":\"This component is released under the GNU\\/GPL License\",\"authorEmail\":\"guille@vargas.co.cr\",\"authorUrl\":\"http:\\/\\/www.jooxmap.com\",\"version\":\"2.3.4\",\"description\":\"Xmap - Sitemap Generator for Joomla!\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10150, 0, 'Xmap - Content Plugin', 'plugin', 'com_content', 'xmap', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"Xmap - Content Plugin\",\"type\":\"plugin\",\"creationDate\":\"01\\/26\\/2011\",\"author\":\"Guillermo Vargas\",\"copyright\":\"GNU GPL\",\"authorEmail\":\"guille@vargas.co.cr\",\"authorUrl\":\"joomla.vargas.co.cr\",\"version\":\"2.0.4\",\"description\":\"XMAP_CONTENT_PLUGIN_DESCRIPTION\",\"group\":\"\"}', '{\"expand_categories\":\"1\",\"expand_featured\":\"1\",\"include_archived\":\"2\",\"show_unauth\":\"0\",\"add_pagebreaks\":\"1\",\"max_art\":\"0\",\"max_art_age\":\"0\",\"add_images\":\"1\",\"cat_priority\":\"-1\",\"cat_changefreq\":\"-1\",\"art_priority\":\"-1\",\"art_changefreq\":\"-1\",\"keywords\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10151, 0, 'Xmap - Kunena Plugin', 'plugin', 'com_kunena', 'xmap', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"Xmap - Kunena Plugin\",\"type\":\"plugin\",\"creationDate\":\"September 2007\",\"author\":\"Guillermo Vargas\",\"copyright\":\"GNU GPL\",\"authorEmail\":\"guille@vargas.co.cr\",\"authorUrl\":\"joomla.vargas.co.cr\",\"version\":\"3.0.0\",\"description\":\"Xmap Plugin for Kunena component\",\"group\":\"\"}', '{\"include_topics\":\"1\",\"max_topics\":\"\",\"max_age\":\"\",\"cat_priority\":\"-1\",\"cat_changefreq\":\"-1\",\"topic_priority\":\"-1\",\"topic_changefreq\":\"-1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10152, 0, 'Xmap - SobiPro Plugin', 'plugin', 'com_sobipro', 'xmap', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"Xmap - SobiPro Plugin\",\"type\":\"plugin\",\"creationDate\":\"07\\/15\\/2011\",\"author\":\"Guillermo Vargas\",\"copyright\":\"GNU GPL\",\"authorEmail\":\"guille@vargas.co.cr\",\"authorUrl\":\"joomla.vargas.co.cr\",\"version\":\"2.0.2\",\"description\":\"Xmap Plugin for SobiPro component\",\"group\":\"\"}', '{\"include_entries\":\"1\",\"max_entries\":\"\",\"max_age\":\"\",\"entries_order\":\"a.ordering\",\"entries_orderdir\":\"DESC\",\"cat_priority\":\"-1\",\"cat_changefreq\":\"weekly\",\"entry_priority\":\"-1\",\"entry_changefreq\":\"weekly\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10153, 0, 'Xmap - Mosets Tree Plugin', 'plugin', 'com_mtree', 'xmap', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"Xmap - Mosets Tree Plugin\",\"type\":\"plugin\",\"creationDate\":\"07\\/20\\/2011\",\"author\":\"Guillermo Vargas\",\"copyright\":\"GNU GPL\",\"authorEmail\":\"guille@vargas.co.cr\",\"authorUrl\":\"joomla.vargas.co.cr\",\"version\":\"2.0.2\",\"description\":\"XMAP_MTREE_PLUGIN_DESCRIPTION\",\"group\":\"\"}', '{\"cats_order\":\"cat_name\",\"cats_orderdir\":\"ASC\",\"include_links\":\"1\",\"links_order\":\"ordering\",\"entries_orderdir\":\"ASC\",\"max_links\":\"\",\"max_age\":\"\",\"cat_priority\":\"0.5\",\"cat_changefreq\":\"weekly\",\"link_priority\":\"0.5\",\"link_changefreq\":\"weekly\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10154, 0, 'Xmap - Virtuemart Plugin', 'plugin', 'com_virtuemart', 'xmap', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"Xmap - Virtuemart Plugin\",\"type\":\"plugin\",\"creationDate\":\"January 2012\",\"author\":\"Guillermo Vargas\",\"copyright\":\"GNU GPL\",\"authorEmail\":\"guille@vargas.co.cr\",\"authorUrl\":\"joomla.vargas.co.cr\",\"version\":\"2.0.3\",\"description\":\"XMAP_VM_PLUGIN_DESCRIPTION\",\"group\":\"\"}', '{\"include_products\":\"1\",\"cat_priority\":\"-1\",\"cat_changefreq\":\"-1\",\"prod_priority\":\"-1\",\"prod_changefreq\":\"-1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10155, 0, 'Xmap - WebLinks Plugin', 'plugin', 'com_weblinks', 'xmap', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"Xmap - WebLinks Plugin\",\"type\":\"plugin\",\"creationDate\":\"Apr 2004\",\"author\":\"Guillermo Vargas\",\"copyright\":\"GNU GPL\",\"authorEmail\":\"guille@vargas.co.cr\",\"authorUrl\":\"joomla.vargas.co.cr\",\"version\":\"2.0.1\",\"description\":\"XMAP_WL_PLUGIN_DESCRIPTION\",\"group\":\"\"}', '{\"include_links\":\"1\",\"max_links\":\"\",\"cat_priority\":\"-1\",\"cat_changefreq\":\"-1\",\"link_priority\":\"-1\",\"link_changefreq\":\"-1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10156, 0, 'XMAP_PLUGIN_K2', 'plugin', 'com_k2', 'xmap', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"XMAP_PLUGIN_K2\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Mohammad Hasani Eghtedar\",\"copyright\":\"GNU GPL\",\"authorEmail\":\"m.h.eghtedar@gmail.com\",\"authorUrl\":\"https:\\/\\/github.com\\/mhehm\\/Xmap\",\"version\":\"1.3\",\"description\":\"XMAP_PLUGIN_K2_DESC\",\"group\":\"\"}', '{\"subcategories\":\"no\",\"showk2items\":\"always\",\"suppressdups\":\"no\",\"priority\":\"0.5\",\"changefreq\":\"weekly\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10157, 0, 'xmap', 'package', 'pkg_xmap', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"Xmap Package\",\"type\":\"package\",\"creationDate\":\"Unknown\",\"author\":\"Unknown\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.3.3\",\"description\":\"The Site Map generator for Joomla!\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10158, 0, 'Sofort Banking', 'plugin', 'sofort', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Sofort\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"<a href=\\\"http:\\/www.sofort.com\\\" target=\\\"_blank\\\">Sofort<\\/a> is a popular\\n\\tpayment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"sofort\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10159, 0, 'akeeba', 'component', 'com_akeeba', '', 1, 1, 0, 0, '{\"name\":\"Akeeba\",\"type\":\"component\",\"creationDate\":\"2014-09-30\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2014 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"http:\\/\\/www.akeebabackup.com\",\"version\":\"4.0.5\",\"description\":\"Akeeba Backup Core - Full Joomla! site backup solution, Core Edition.\",\"group\":\"\"}', '{\"siteurl\":\"http:\\/\\/localhost\\/T3Fremework_ver_1_7\\/\",\"jlibrariesdir\":\"D:\\/wamp\\/www\\/T3Fremework_ver_1_7\\/libraries\",\"jversion\":\"1.6\",\"liveupdate\":\"stuck=0\\nlastcheck=1379254343\\nupdatedata=\\\"Tzo4OiJzdGRDbGFzcyI6ODp7czo5OiJzdXBwb3J0ZWQiO2I6MTtzOjU6InN0dWNrIjtiOjA7czo3OiJ2ZXJzaW9uIjtzOjU6IjMuOC4xIjtzOjQ6ImRhdGUiO3M6MTA6IjIwMTMtMDktMTAiO3M6OToic3RhYmlsaXR5IjtzOjY6InN0YWJsZSI7czoxMToiZG93bmxvYWRVUkwiO3M6ODI6Imh0dHA6Ly9jZG4uYWtlZWJhYmFja3VwLmNvbS9kb3dubG9hZHMvYWtlZWJhYmFja3VwLzMuOC4xL2NvbV9ha2VlYmEtMy44LjEtY29yZS56aXAiO3M6NzoiaW5mb1VSTCI7czo2MzoiaHR0cHM6Ly93d3cuYWtlZWJhYmFja3VwLmNvbS9kb3dubG9hZHMvYWtlZWJhLWJhY2t1cC8zLTgtMS5odG1sIjtzOjEyOiJyZWxlYXNlbm90ZXMiO3M6MTA2NjoiPGgzPkdlbmVyYWwgaW5mb3JtYXRpb248L2gzPjxwPiBJZiB5b3UgaGF2ZSBhIHByb2JsZW0gYWZ0ZXIgb3IgYmVmb3JlIGluc3RhbGxpbmcgdGhlIGNvbXBvbmVudCBwbGVhc2UgcmVhZCBvdXIgPGEgaHJlZj0iaHR0cHM6Ly93d3cuYWtlZWJhYmFja3VwLmNvbS9ob21lL25ld3MvNTUtZ2VuZXJhbC8xNTAyLXRyb3VibGVzaG9vdGluZy1pbnN0cnVjdGlvbnMtZm9yLWZlYi0yMDEzLXJlbGVhc2VzLmh0bWwiPiB0cm91Ymxlc2hvb3RpbmcgcGFnZTwvYT4uIFRoZXNlIGlzc3VlcyBhcmUgbW9yZSBsaWtlbHkgdG8gb2NjdXIgaWYgeW91IHRyeSB0byB1cGdyYWRlIHRoaXMgY29tcG9uZW50IHdoaWxlIHlvdSBoYXZlIGFuIG9sZGVyIHZlcnNpb24gb2YgYW5vdGhlciBjb21wb25lbnQgb2Ygb3VycyBzdGlsbCBpbnN0YWxsZWQgb24geW91ciBzaXRlLjwvcD48aDM+UmVsZWFzZSBoaWdobGlnaHRzPC9oMz48cD4gPGI+TWljcm9zb2Z0IFNRTCBTZXJ2ZXIgYW5kIFBvc3RncmVTUUwgY29tcGF0aWJpbGl0eSAoQkVUQSk8L2I+LiBUaGlzIHZlcnNpb24gaW50cm9kdWNlcyBsaW1pdGVkIGNvbXBhdGliaWxpdHkgd2l0aCBNaWNyb3NvZnQgU1FMIFNlcnZlciwgTWljcm9zb2Z0IFdpbmRvd3MgQXp1cmUgU1FMIGFuZCBQb3N0Z3JlU1FMIGRhdGFiYXNlcy48L3A+PHA+IE1pY3Jvc29mdCBTUUwgU2VydmVyIGFuZCBNaWNyb3NvZnQgV2luZG93cyBBenVyZSBTUUwgZGF0YWJhc2VzIGFyZSBvbmx5IHN1cHBvcnRlZCBvbiBXaW5kb3dzIGhvc3RzIHdpdGggdGhlIHByb3ByaWV0YXJ5IHNxbHNlcnZlciBQSFAgZXh0ZW5zaW9uIGZyb20gTWljcm9zb2Z0LiBQb3N0Z3JlU1FMIGlzIHN1cHBvcnRlZCBvbiBXaW5kb3dzLCBMaW51eCBhbmQgTWFjIE9TIFguPC9wPjxwPiBZb3UgY2FuIGluc3RhbGwgQWtlZWJhIEJhY2t1cCBvbiBzZXJ2ZXJzIHVzaW5nIG9uZSBvZiB0aG9zZSBkYXRhYmFzZXMuIFBsZWFzZSByZW1lbWJlciB0byBnbyB0byB0aGUgQ29uZmlndXJhdGlvbiBwYWdlIGFuZCBjaGFuZ2UgdGhlIGRhdGFiYXNlIGR1bXAgZW5naW5lIG9wdGlvbiB0byAiUmV2ZXJzZSBlbmdpbmVlcmluZyI7fQ==\\\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10160, 0, 'FOF', 'library', 'lib_fof', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2013-09-06\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2013 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"revC1A6D5A-1378494129\",\"description\":\"Framework-on-Framework (FOF) - A rapid component development framework for Joomla!\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10161, 0, 'AkeebaStrapper', 'file', 'files_strapper', '', 0, 1, 0, 0, '{\"name\":\"AkeebaStrapper\",\"type\":\"file\",\"creationDate\":\"2014-09-11 16:58:22\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"(C) 2012-2013 Akeeba Ltd.\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"rev844F136-1410443902\",\"description\":\"Namespaced jQuery, jQuery UI and Bootstrap for Akeeba products.\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10162, 0, 'JMod TweetDisplay', 'module', 'mod_jmod_tweetdisplay', '', 0, 1, 0, 0, '{\"name\":\"JMod TweetDisplay\",\"type\":\"module\",\"creationDate\":\"July 2013\",\"author\":\"Sean Casco\",\"copyright\":\"Copyright (C) 2013. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.0\",\"description\":\" <h1 style=\\\"color: red\\\">To use this module follow this guide: <a href=\\\"http:\\/\\/jmodules.com\\/tutorials\\/jmod-tweetdisplay-documentation\\\" target=\\\"_blank\\\">How to Setup<\\/a><\\/h1>\\n\\t\",\"group\":\"\",\"filename\":\"mod_jmod_tweetdisplay\"}', '{\"consumer_key\":\"\",\"consumer_secret\":\"\",\"access_token\":\"\",\"access_secret\":\"\",\"type\":\"1\",\"username\":\"twitter\",\"query\":\"\",\"title\":\"\",\"link_title\":\"1\",\"count\":\"5\",\"width\":\"\",\"height\":\"\",\"header\":\"1\",\"twitter_icon\":\"1\",\"bgd_color\":\"#ffffff\",\"link_color\":\"#0084B4\",\"border_color\":\"#cccccc\",\"text_color\":\"#333333\",\"header_link_color\":\"#333333\",\"header_sub_color\":\"#999999\",\"header_sub_hover_color\":\"#666666\",\"search_title_color\":\"#333333\",\"display_name\":\"1\",\"avatars\":\"0\",\"timestamps\":\"1\",\"reply\":\"1\",\"retweet\":\"1\",\"favorite\":\"1\",\"show_link\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10163, 0, 'Sofort iDeal', 'plugin', 'sofort_ideal', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Sofort Ideal\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"<a href=\\\"http:\\/www.sofort.com\\\" target=\\\"_blank\\\">Sofort<\\/a> is a popular\\n\\tpayment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"sofort\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10167, 0, 'KlarnaCheckout', 'plugin', 'klarnacheckout', 'vmpayment', 0, 1, 1, 0, '{\"name\":\"Klarna Checkout\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"klarnacheckout\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10168, 0, 'comparelist', 'component', 'com_comparelist', '', 1, 1, 0, 0, '{\"legacy\":false,\"name\":\"Comparelist\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2011 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\",\"version\":\"1.0.0\",\"description\":\"Component Compare products\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10169, 0, 'mod_comparelist', 'module', 'mod_comparelist', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"mod_comparelist\",\"type\":\"module\",\"creationDate\":\"November 2010\",\"author\":\"SomeBody\",\"copyright\":\"Copyright Info\",\"authorEmail\":\"email@example.org\",\"authorUrl\":\"http:\\/\\/www.joomla-code.ru\",\"version\":\"0.0.1\",\"description\":\"mod_comparelist\",\"group\":\"\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10170, 0, 'wishlists', 'component', 'com_wishlists', '', 1, 1, 0, 0, '{\"legacy\":false,\"name\":\"Wishlists\",\"type\":\"component\",\"creationDate\":\"2007-02-22\",\"author\":\"John Doe\",\"copyright\":\"Copyright Info\",\"authorEmail\":\"john.doe@example.org\",\"authorUrl\":\"http:\\/\\/www.example.org\",\"version\":\"0.01\",\"description\":\"Description of the Wishlists ...\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10171, 0, 'mod_wishlist', 'module', 'mod_wishlist', '', 0, 1, 0, 0, '{\"legacy\":false,\"name\":\"mod_wishlist\",\"type\":\"module\",\"creationDate\":\"November 2010\",\"author\":\"SomeBody\",\"copyright\":\"Copyright Info\",\"authorEmail\":\"email@example.org\",\"authorUrl\":\"http:\\/\\/www.joomla-code.ru\",\"version\":\"0.0.1\",\"description\":\"mod_wishlist\",\"group\":\"\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10174, 0, 'quick', 'plugin', 'quick', 'system', 0, 1, 1, 0, '{\"name\":\"quick\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"Unknown\",\"copyright\":\"\\u00a9 2014. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_QUICK_DESC\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(10177, 0, 'wishlists', 'plugin', 'wishlists', 'system', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"wishlists\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"olejenya\",\"copyright\":\"\",\"authorEmail\":\"oleg@oleg.com\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_WISHLISTS_DESC\",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 13, 0),
(10178, 0, 'plg_quickicon_jcomments', 'plugin', 'jcomments', 'quickicon', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_quickicon_jcomments\",\"type\":\"plugin\",\"creationDate\":\"01\\/08\\/2014\",\"author\":\"smart\",\"copyright\":\"Copyright 2006-2014 JoomlaTune.ru All rights reserved!\",\"authorEmail\":\"smart@joomlatune.ru\",\"authorUrl\":\"http:\\/\\/www.joomlatune.ru\",\"version\":\"1.0\",\"description\":\"PLG_QUICKICON_JCOMMENTS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"context\":\"mod_quickicon\",\"displayedtext\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10179, 0, 'scriptmerge', 'package', 'pkg_scriptmerge', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"ScriptMerge\",\"type\":\"package\",\"creationDate\":\"February 2013\",\"author\":\"Yireo\",\"copyright\":\"Copyright 2013 Yireo.com\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0.0\",\"description\":\"\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10181, 0, 'VIRTUEMART', 'component', 'com_virtuemart', '', 1, 1, 0, 0, '{\"name\":\"VIRTUEMART\",\"type\":\"component\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"virtuemart\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10182, 0, 'plg_system_ajax_scroll', 'plugin', 'ajax_scroll', 'system', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"plg_system_ajax_scroll\",\"type\":\"plugin\",\"creationDate\":\"27.01.2014\",\"author\":\"Unknown\",\"copyright\":\"\\u00a9 2014. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"PLG_AJAX_SCROLL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"container\":\".loadmore #slider\",\"item\":\".item\",\"pagination\":\".pagination.vm\",\"next\":\".pagination.vm .next a\",\"triggerPageThreshold\":\"99999\"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10184, 0, 'JS Cookie Alert', 'module', 'mod_js_cookie_alert', '', 0, 1, 0, 0, '{\"legacy\":true,\"name\":\"JS Cookie Alert\",\"type\":\"module\",\"creationDate\":\"Unknown\",\"author\":\"Jakub Skowro\\u0144ski\",\"copyright\":\" All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"\",\"group\":\"\"}', '{\"js_alert_jquery\":\"1\",\"js_cwbuttoncolor\":\"blue\",\"js_cwmessage\":\"Please note this website requires cookies in order to function correctly, they do not store any specific information about you personally.\",\"js_cwbubbletitle\":\"Cookie Laws within the EU\",\"js_cwbubblemessage\":\"On 26th May 2012, new laws came into force in the EU that affect most web sites. If cookies are used in a site, the Privacy and Electronic Communications (EC Directive) (Amendment) Regulations 2011 (UK Government Regulations) asks that the website user must give consent to the use and placing of the cookies.\",\"js_cwagree\":\"Accept Cookies\",\"js_cwmoreinfo\":\"Read more...\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10185, 0, 'Unite Slider 2', 'module', 'mod_unite_revolution2', '', 0, 1, 0, 0, '{\"name\":\"Unite Slider 2\",\"type\":\"module\",\"creationDate\":\"October 2012\",\"author\":\"Unite CMS\",\"copyright\":\"Copyright (C) 2012 UniteCMS.net, All rights reserved.\",\"authorEmail\":\"support@unitecms.net\",\"authorUrl\":\"http:\\/\\/unitecms.net\",\"version\":\"4.7\",\"description\":\"\\n\\t\\t\\t<div style=\\\"font-weight:normal;\\\">\\n\\t\\t\\t<p><strong>Unite Slider (new edition)<\\/strong> module. Put the slider on any page. All the slider configuration located in Component.<\\/p>\\n\\t\\t\\t<p>\\n\\t\\t\\t\\tFor support please turn to <a href=\\\"http:\\/\\/unitecms.net\\/joomla-extensions\\/unite-revolution-slider-responsive\\\" target=\\\"_blank\\\">Unite Slider Page<\\/a>\\n\\t\\t\\t<\\/p>\\n\\t\\t\\t<small style=\\\"float:right\\\">ver. 4.7<\\/small>\\n\\t\\t\\t<\\/div>\\n     \\n\\t \",\"group\":\"\",\"filename\":\"mod_unite_revolution2\"}', '{\"include_jquery\":\"true\",\"js_load_type\":\"head\",\"no_conflict_mode\":\"false\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10186, 0, 'com_uniterevolution2', 'component', 'com_uniterevolution2', '', 1, 1, 0, 0, '{\"name\":\"com_uniterevolution2\",\"type\":\"component\",\"creationDate\":\"August 2012\",\"author\":\"Unite CMS \\/ Valiano\",\"copyright\":\"Copyright (C) 2012 UniteCMS.net, All rights reserved.\",\"authorEmail\":\"support@unitecms.net\",\"authorUrl\":\"http:\\/\\/www.unitecms.net\",\"version\":\"5.0.8\",\"description\":\"\\n\\t\\tRevolution Slider extension and module installation success!\\n\\t\",\"group\":\"\",\"filename\":\"manifest\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10187, 0, 'mod_vmmenu', 'module', 'mod_vmmenu', '', 1, 1, 3, 0, '{\"name\":\"VirtueMart Administrator Menu\",\"type\":\"module\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"MOD_VMMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_vmmenu\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10188, 0, 'plg_system_overrides', 'plugin', 'overrides', 'system', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"plg_system_overrides\",\"type\":\"plugin\",\"creationDate\":\"Aug 2013\",\"author\":\"Neo Hoang\",\"copyright\":\"(C) 2012 Neo Hoang. All rights reserved.\",\"authorEmail\":\"neohoang@estoresmart.net\",\"authorUrl\":\"www.electriceasel.com\",\"version\":\"1.0.0\",\"description\":\"This plugin will override classes contained in the included config file.\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 12, 0),
(10189, 0, 'plg_system_jquery', 'plugin', 'jquery', 'system', 0, 0, 1, 0, '{\"legacy\":false,\"name\":\"plg_system_jquery\",\"type\":\"plugin\",\"creationDate\":\"April 2013\",\"author\":\"Neo Hoang\",\"copyright\":\"Copyright (C) 2005 - 2013 Cmsmart.net. All rights reserved.\",\"authorEmail\":\"thaiht@cmsmart.net\",\"authorUrl\":\"www.cmsmart.net\",\"version\":\"2.0.0\",\"description\":\"PLG_JQUERY_XML_DESCRIPTION\",\"group\":\"\"}', '{\"load_mootools\":\"1\",\"load_jquery_ui\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 16, 0),
(10191, 0, 'pkg_onestepcheckout', 'package', 'pkg_pkg_onestepcheckout', '', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"Overrides and jQuery ,Onestepcheckout plugins in package\",\"type\":\"package\",\"creationDate\":\"09-13-2013\",\"author\":\"Neo Hoang\",\"copyright\":\"(C) 2012 Cmsmart Team. All rights reserved.\",\"authorEmail\":\"info@cmsmart.net\",\"authorUrl\":\"http:\\/\\/cmsmart.net\",\"version\":\"1.0.0\",\"description\":\"Package installer for OVERRIDES and jQuery system plugins\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10193, 0, 'VM Payment - Paybox', 'plugin', 'paybox', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - Paybox\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"<a href=\\\"http:\\/\\/paybox.com\\\" target=\\\"_blank\\\">Paybox<\\/a> \\n    \",\"group\":\"\",\"filename\":\"paybox\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10196, 0, 'VM Payment - Realex HPP & API', 'plugin', 'realex_hpp_api', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"realex_hpp_api\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"Realex HPP and API\",\"group\":\"\",\"filename\":\"realex_hpp_api\"}', '', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10197, 0, 'VM Userfield - Realex HPP & API', 'plugin', 'realex_hpp_api', 'vmuserfield', 0, 0, 1, 0, '{\"name\":\"Realex_hpp_api\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"Card storage plugin for Realex\",\"group\":\"\",\"filename\":\"realex_hpp_api\"}', '', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10199, 0, 'VM Payment - Skrill', 'plugin', 'skrill', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"Skrill\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"Skrill Holdings Limited\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.skrill.com\",\"version\":\"3.5.0\",\"description\":\"<a href=\\\"http:\\/\\/www.skrill.com\\\" target=\\\"_blank\\\">skrill<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    \",\"group\":\"\",\"filename\":\"skrill\"}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(10200, 0, 'PLG_JSCSSCONTROL', 'plugin', 'jscsscontrol', 'system', 0, 1, 1, 0, '{\"legacy\":false,\"name\":\"PLG_JSCSSCONTROL\",\"type\":\"plugin\",\"creationDate\":\"08-Jan-2013\",\"author\":\"Viktor Vogel\",\"copyright\":\"Copyright 2013 Viktor Vogel. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/joomla-extensions.kubik-rubik.de\",\"version\":\"3-1\",\"description\":\"PLG_JSCSSCONTROL_XML_DESCRIPTION\",\"group\":\"\"}', '{\"js\":\"https:\\/\\/cdnjs.cloudflare.com\\/ajax\\/libs\\/jquery-mousewheel\\/3.0.6\\/jquery.mousewheel.min.js\",\"css\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 43, 0),
(10201, 0, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10202, 0, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10203, 0, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10204, 0, 'AcyMailing', 'component', 'com_acymailing', '', 1, 1, 0, 0, '{\"name\":\"AcyMailing\",\"type\":\"component\",\"creationDate\":\"August 2018\",\"author\":\"Acyba\",\"copyright\":\"Copyright (C) 2009-2018 ACYBA SAS - All rights reserved.\",\"authorEmail\":\"dev@acyba.com\",\"authorUrl\":\"http:\\/\\/www.acyba.com\",\"version\":\"5.10.4\",\"description\":\"Manage your Mailing lists, Newsletters, e-mail marketing campaigns\",\"group\":\"\",\"filename\":\"acymailing_j3\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10205, 0, 'AcyMailing : trigger Joomla Content plugins', 'plugin', 'contentplugin', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"November 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 15, 0),
(10206, 0, 'AcyMailing Manage text', 'plugin', 'managetext', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"October 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10207, 0, 'AcyMailing Tag : Website links', 'plugin', 'online', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10208, 0, 'AcyMailing : share on social networks', 'plugin', 'share', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"August 2010\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10209, 0, 'AcyMailing : Statistics Plugin', 'plugin', 'stats', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 50, 0),
(10210, 0, 'AcyMailing table of contents generator', 'plugin', 'tablecontents', 'acymailing', 0, 1, 1, 0, '{\"version\":\"1.0.0\",\"author\":\"Acyba\",\"creationDate\":\"January 2011\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10211, 0, 'AcyMailing Tag : CB User information', 'plugin', 'tagcbuser', 'acymailing', 0, 0, 1, 0, '{\"version\":\"3.7.1\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10212, 0, 'AcyMailing Tag : content insertion', 'plugin', 'tagcontent', 'acymailing', 0, 1, 1, 0, '{\"version\":\"3.7.0\",\"author\":\"Acyba\",\"creationDate\":\"September 2009\"}', '', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10213, 0, 'AcyMailing Tag : Subscriber information', 'plugin', 'tagsubscriber', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.2.0\",\"author\":\"Acyba\",\"creationDate\":\"f\\u00e9vrier 2016\"}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10214, 0, 'AcyMailing Tag : Manage the Subscription', 'plugin', 'tagsubscription', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.2.0\",\"author\":\"Acyba\",\"creationDate\":\"f\\u00e9vrier 2016\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10215, 0, 'AcyMailing Tag : Date / Time', 'plugin', 'tagtime', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.2.0\",\"author\":\"Acyba\",\"creationDate\":\"f\\u00e9vrier 2016\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10216, 0, 'AcyMailing Tag : Joomla User Information', 'plugin', 'taguser', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.2.0\",\"author\":\"Acyba\",\"creationDate\":\"f\\u00e9vrier 2016\"}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10217, 0, 'AcyMailing Template Class Replacer', 'plugin', 'template', 'acymailing', 0, 1, 1, 0, '{\"version\":\"5.2.0\",\"author\":\"Acyba\",\"creationDate\":\"f\\u00e9vrier 2016\"}', '', '', '', 0, '0000-00-00 00:00:00', 52, 0),
(10218, 0, 'AcyMailing Editor', 'plugin', 'acyeditor', 'editors', 0, 0, 1, 0, '{\"version\":\"5.2.0\",\"author\":\"Acyba\",\"creationDate\":\"f\\u00e9vrier 2016\"}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10219, 0, 'AcyMailing : (auto)Subscribe during Joomla registration', 'plugin', 'regacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"5.2.0\",\"author\":\"Acyba\",\"creationDate\":\"f\\u00e9vrier 2016\"}', '', '', '', 0, '0000-00-00 00:00:00', 17, 0),
(10220, 0, 'F0F (NEW) DO NOT REMOVE', 'library', 'lib_f0f', '', 0, 1, 1, 0, '{\"name\":\"F0F (NEW) DO NOT REMOVE\",\"type\":\"library\",\"creationDate\":\"2014-09-11 16:58:22\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2014 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"rev844F136-1410443902\",\"description\":\"Framework-on-Framework (FOF) newer version - DO NOT REMOVE - The rapid component development framework for Joomla!. This package is the newer version of FOF, not the one shipped with Joomla! as the official Joomla! RAD Layer. The Joomla! RAD Layer has ceased development in March 2014. DO NOT UNINSTALL THIS PACKAGE, IT IS *** N O T *** A DUPLICATE OF THE \'FOF\' PACKAGE. REMOVING EITHER FOF PACKAGE WILL BREAK YOUR SITE.\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10221, 0, 'jmsmultiupload', 'component', 'com_jmsmultiupload', '', 1, 1, 0, 0, '{\"name\":\"jmsmultiupload\",\"type\":\"component\",\"creationDate\":\"29 July 2013\",\"author\":\"Joommasters Team\",\"copyright\":\"Joommasters.com\",\"authorEmail\":\"Joommasters@gmail.com\",\"authorUrl\":\"www.Joommasters.com\",\"version\":\"2.5\",\"description\":\"JMS Multi Images Upload Component\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10222, 0, 'System - JMS Multi Upload For Virtuemart', 'plugin', 'jmsmultiupload', 'system', 0, 1, 1, 0, '{\"name\":\"System - JMS Multi Upload For Virtuemart\",\"type\":\"plugin\",\"creationDate\":\"16-Jan-2012\",\"author\":\"JoomMasterS\",\"copyright\":\"http:\\/\\/www.joommasters.com\",\"authorEmail\":\"joommasters@gmail.com\",\"authorUrl\":\"http:\\/\\/www.joommasters.com\",\"version\":\"1.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"jmsmultiupload\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 14, 0),
(10226, 0, 'YOUTUBE', 'plugin', 'youtube', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"YOUTUBE\",\"type\":\"plugin\",\"creationDate\":\"June 2013\",\"author\":\"HexSys Team\",\"copyright\":\"Copyright (C) 2013 hexsystechnologies.com. All Rights Reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.hexsystechnologies.com\",\"version\":\"1.0.0\",\"description\":\"VMCUSTOM_YOUTUBE_DESCR\",\"group\":\"\"}', '{}', '', '', 0, '2014-10-13 21:11:27', 0, 0),
(10227, 0, 'mod_jux_vm_megamenu', 'module', 'mod_jux_vm_megamenu', '', 0, 1, 0, 0, '{\"name\":\"mod_jux_vm_megamenu\",\"type\":\"module\",\"creationDate\":\"July 2013\",\"author\":\"JoomlaUX\",\"copyright\":\"Copyright (C) 2008 - 2013 JoomlaUX. All rights reserved.\",\"authorEmail\":\"admin@joomlaux.com\",\"authorUrl\":\"http:\\/\\/joomlaux.com\",\"version\":\"1.1.1\",\"description\":\"MOD_JUX_VM_MEGAMENU_DESCRIPTION\",\"group\":\"\"}', '{\"hozorver\":\"horizontal\",\"horizontal_submenu_direction\":\"down\",\"vertical_submenu_direction\":\"lefttoright\",\"navigation_animation\":\"\",\"n_navigation_animation\":\"\",\"animation_duration\":\"400\",\"animation_delay\":\"\",\"show_num_items\":\"1\",\"show_items\":\"0\",\"load_font_awesome\":\"0\",\"nav_style\":\"flat\",\"fl_color\":\"#FFFFFF\",\"gradient\":\"\",\"gradient_type\":\"linear\",\"gs_color_1\":\"#484848\",\"gs_color_2\":\"#393939\",\"ge_color_1\":\"#212121\",\"ge_color_2\":\"#131313\",\"nav_border\":\"\",\"nav_padding\":\"0\",\"nav_margin\":\"0\",\"nav_corner\":\"\",\"dd_bacground_color\":\"#fffff\",\"dd_border\":\"\",\"dd_padding\":\"0\",\"dd_margin\":\"0\",\"dd_corner\":\"\",\"dd_shadow\":\"0\",\"titem_hover_bacground_color\":\"#fffff\",\"titem_border\":\"\",\"titem_padding\":\"0\",\"titem_margin\":\"0\",\"titem_text_color\":\"#333333\",\"titem_text_hover_color\":\"#0088CC\",\"ditem_hover_bacground_color\":\"#fffff\",\"ditem_border\":\"\",\"ditem_padding\":\"0\",\"ditem_margin\":\"0\",\"ditem_text_color\":\"#333333\",\"ditem_text_hover_color\":\"#0088CC\",\"custom_css\":\"\",\"cache\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10228, 0, 'Responsive color google map', 'module', 'mod_profil_responsive_map', '', 0, 1, 0, 0, '{\"name\":\"Responsive color google map\",\"type\":\"module\",\"creationDate\":\"January 22th, 2014\",\"author\":\"David Hoffmann\",\"copyright\":\"Copyright (c) 2014 Profil PR & Werbeagentur All rights reserved.\",\"authorEmail\":\"web@profilpr.de\",\"authorUrl\":\"Profilpr\",\"version\":\"1.0\",\"description\":\"MOD_PROFIL_RESPONSIVE_MAP_DESCRIPTION\",\"group\":\"\"}', '{\"profilResponsiveMapTemplates\":\"default\",\"profilResponsiveMapColor\":\"#123456\",\"profilResponsiveMapContrast\":\"1.58\",\"profilResponsiveMapSaturation\":\"0\",\"profilResponsiveMapLightness\":\"0\",\"profilResponsiveMapZoom\":\"14\",\"profilResponsivePanControl\":\"1\",\"profilResponsiveZoomControl\":\"1\",\"profilResponsiveMapTypeControl\":\"1\",\"profilResponsiveScaleControl\":\"1\",\"profilResponsiveStreetViewControl\":\"1\",\"profilResponsiveScrollwheel\":\"1\",\"profilResponsiveFullscreen\":\"0\",\"profilResponsiveVisibility\":\"0\",\"profilResponsiveBikemap\":\"0\",\"profilResponsiveWeathermap\":\"0\",\"profilResponsiveWeathermapTemperatureunit\":\"0\",\"profilResponsiveCloudmap\":\"0\",\"profilResponsiveTrafficmap\":\"0\",\"cache_time\":\"900\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10229, 0, 'Module Parallax', 'module', 'mod_parallax', '', 0, 1, 0, 0, '{\"name\":\"Module Parallax\",\"type\":\"module\",\"creationDate\":\"21\\/10\\/2014\",\"author\":\"Test\",\"copyright\":\"Copyright (C) 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"Test\",\"authorUrl\":\"\",\"version\":\"0.0\",\"description\":\"Parallax Module is a Joomla! \",\"group\":\"\"}', '{\"selector\":\"#parallax\",\"backgroundratio\":\"\",\"horizontalOffset\":\"\",\"verticalOffset\":\"\",\"mod_image\":\"\",\"moduleclass_sfx\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10230, 0, 'VM Payment - Klikandpay', 'plugin', 'klikandpay', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - klikandpay\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"<a href=\\\"http:\\/\\/klikandpay.com\\\" target=\\\"_blank\\\">klikandpay<\\/a> \\n    \",\"group\":\"\",\"filename\":\"klikandpay\"}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(10231, 0, 'Virtuemart 3 multiple customfield plugin', 'plugin', 'param', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"Virtuemart 3 multiple customfield plugin\",\"type\":\"plugin\",\"creationDate\":\"2017.07.05\",\"author\":\"Dmitriy Usov\",\"copyright\":\"Copyright (C) 2012-2015 usovdm\",\"authorEmail\":\"usovdm@gmail.com\",\"authorUrl\":\"http:\\/\\/myext.eu\",\"version\":\"3.0.7\",\"description\":\"PLG_VMCUSTOM_PARAM_XML_DESC\",\"group\":\"\",\"filename\":\"param\"}', '{\"mcf_key\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10232, 0, 'Search (filter) module for Virtuemart 3 multiple customfield plugin', 'module', 'mod_virtuemart_param_filter', '', 0, 1, 0, 0, '{\"name\":\"Search (filter) module for Virtuemart 3 multiple customfield plugin\",\"type\":\"module\",\"creationDate\":\"2017.07.05\",\"author\":\"Dmitriy Usov\",\"copyright\":\"Copyright (C) 2012-2017 usovdm\",\"authorEmail\":\"usovdm@gmail.com\",\"authorUrl\":\"http:\\/\\/myext.eu\",\"version\":\"3.0.7\",\"description\":\"mod_vmcustom_param_filter_xml_DESC\",\"group\":\"\",\"filename\":\"mod_virtuemart_param_filter\"}', '{\"layout\":\"default\",\"method\":\"get\",\"limit\":\"10\",\"parent_auto\":\"0\",\"stock\":\"0\",\"children\":\"-1\",\"show_all_count\":\"1\",\"mod_ajax\":\"1\",\"count_show\":\"1\",\"count_zero_show\":\"disable\",\"mod_ajax_div\":\"\",\"loader_img\":\"aload-black_on_white\",\"mcf_mod_uniq_display\":\"1\",\"mcf_mod_uniq_result\":\"0\",\"view_assign\":\"-1\",\"categories_show\":\"1\",\"in_active_category\":\"0\",\"active_category_id\":\"\",\"mcf_subcategories\":\"0\",\"mcf_only_subcategories\":\"0\",\"categories_heading\":\"\",\"categories_select_heading\":\"Choose category\",\"categories_layout\":\"checkbox\",\"manufacturers_show\":\"1\",\"manufacturers_heading\":\"\",\"manufacturers_select_heading\":\"Choose manufacturer\",\"mcf_body\":\"Z3ppbmZsYXRl;dZJra9swFIb\\/ypnwik0Tx4GtbL5kBNrRFQod65etKUaxj2OtsmR08eaW\\/vdJTsYgZF8E5\\/K859WRdlxuKYegNR2fBT1VtCs1UlW1Jat1BkEtKyjg5jOtjFRjmu7QXMrKdihMGLn6MeKamdZoQk\\/OV8flCM7OTkBvCpgv4ROchiAFYTn30\\/iu7KrGO7rjdsfENfIe1WRrnwjJ0FVWG9mRGZmEiLfpoPIJRwf+1FKUNVayxvCv3mGkjuarQ2MGwJrwH1ZAV78Pt1TjxbsSxUTvnmtsODUYEk6\\/Xi5JrO1WG\\/XfNi9Bbkl8c7e+vy6\\/fbm\\/iskViaJolsyWF1FM1vgjmRLRC7wi1\\/gCgel655oqRUe\\/8EaqMGBFkgUsLz668\\/zcNTuvh60f7+4hYI9RNMk8PDqhkw0ZvJ58SU9l+8\\/hIpLXbABtRo7FhjRSmLlmz5h+SN5mG7L6Li20dECgIKRw\\/4UN7tI1DKg0kwJ+taxqoWa653TUYHswEpYJ7CeCQm250TGsDySM0iroZG05QosKU8gptAobN701pk8Xi27E3yZGuyFgqHKfwJXKLafiyRm6Ha+mYr6gq3zhvK9ITDbCHTkTvTVgxt7fpGV1jcJJCNr52D86E8y4zEC59all4oKF46dd+HUpNFYJMMpi9gc=;Y3JlYXRlX2Z1bmN0aW9u\",\"mcf_mod\":\"bxaisiexi6xi4xi_xdieicixoidxe\",\"manufacturers_layout\":\"auto\",\"price_show\":\"1\",\"price_heading\":\"\",\"price_discount\":\"0\",\"price_mcur\":\"0\",\"price_layout\":\"auto\",\"price_select_heading\":\"\",\"customfields_show\":\"1\",\"customfields_select_heading\":\"Choose some options\",\"customfields_layout\":\"auto\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\",\"mcf_jqueryui\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10235, 0, 'VM Payment - Pay with Amazon', 'plugin', 'amazon', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"AMAZON\",\"type\":\"plugin\",\"creationDate\":\"October 29 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.3\",\"description\":\"AMAZON PAY plugin\",\"group\":\"\",\"filename\":\"amazon\"}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10236, 0, 'System - Pay with Amazon', 'plugin', 'amazon', 'system', 0, 0, 1, 0, '{\"name\":\"AMAZON\",\"type\":\"plugin\",\"creationDate\":\"October 29 2018\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2018 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.4.3\",\"description\":\"AMAZON payment SYSTEM plugin\",\"group\":\"\",\"filename\":\"amazon\"}', '', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(10237, 0, 'Joomla Options', 'plugin', 'joomla_options', 'system', 0, 1, 1, 0, '{\"name\":\"Joomla Options\",\"type\":\"plugin\",\"creationDate\":\"Mart 2013\",\"author\":\"Fedor Vlasenko\",\"copyright\":\"Copyright (C) 2013 Fregate Studio.\",\"authorEmail\":\"vlasenkofedor@mail.ru\",\"authorUrl\":\"fregate.org.ua\",\"version\":\"0.0.1\",\"description\":\"\\u0421onfiguration, options in Joomla\",\"group\":\"\"}', '{\"disable_mootools\":\"0\",\"disable_jquery\":\"1\",\"disable_bootstrap\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(10238, 0, 'HebrewIsrael', 'language', 'he-IL', '', 0, 1, 0, 0, '{\"name\":\"Hebrew (Israel)\",\"type\":\"language\",\"creationDate\":\"2013-05-13\",\"author\":\"Joomla! Israel\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"info@joomla.org.il\",\"authorUrl\":\"www.joomla.org.il\",\"version\":\"3.1.1.2\",\"description\":\"Hebrew front-end language package\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10239, 0, 'HebrewIsrael', 'language', 'he-IL', '', 1, 1, 0, 0, '{\"name\":\"Hebrew (Israel)\",\"type\":\"language\",\"creationDate\":\"2013-05-13\",\"author\":\"Joomla! Project (Hebrew)\",\"copyright\":\"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.\",\"authorEmail\":\"info@joomla.org.il\",\"authorUrl\":\"www.joomla.org.il\",\"version\":\"3.1.1.2\",\"description\":\"Hebrew administrator language package\",\"group\":\"\",\"filename\":\"install\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10240, 0, 'Hebrew Language Pack', 'package', 'pkg_he-IL', '', 0, 1, 1, 0, '{\"name\":\"Hebrew Language Pack\",\"type\":\"package\",\"creationDate\":\"2013-05-13\",\"author\":\"Joomla! Project (Hebrew)\",\"copyright\":\"Copyright (C) 2005 - 2013 joomla.org.il Open Source Matters. All rights reserved\",\"authorEmail\":\"info@joomla.org.il\",\"authorUrl\":\"www.joomla.org.il\",\"version\":\"3.1.1.2\",\"description\":\"\\n\\t\\t\\n\\t\\t<h3>\\u05d7\\u05d1\\u05d9\\u05dc\\u05d4 \\u05d4\\u05e9\\u05e4\\u05d4 \\u05d4\\u05e2\\u05d1\\u05e8\\u05d9\\u05ea \\u05d4\\u05de\\u05dc\\u05d0\\u05d4 \\u05e2\\u05d1\\u05d5\\u05e8 \\u05d2\'\\u05d5\\u05de\\u05dc\\u05d4 3.1.1<\\/h3>\\n\\t\\t<h4>\\u05d2\\u05d9\\u05e8\\u05e1\\u05ea \\u05d4\\u05ea\\u05e8\\u05d2\\u05d5\\u05dd \\u05d4\\u05d9\\u05e0\\u05d4 3.1.1v1<\\/h4>\\n\\t\\t<div>\\u05d4\\u05d7\\u05d1\\u05d9\\u05dc\\u05d4 \\u05e0\\u05d0\\u05e8\\u05d6\\u05d4 \\u05e2\\u05dc-\\u05d9\\u05d3\\u05d9 <a href=\\\"http:\\/\\/www.joomla.org.il\\/\\\">joomla.ORG.il<\\/a><\\/div>\\n\\t\\t\",\"group\":\"\",\"filename\":\"pkg_he-IL\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10241, 0, 'tcpdf', 'component', 'com_tcpdf', '', 1, 1, 0, 0, '{\"name\":\"tcpdf\",\"type\":\"component\",\"creationDate\":\"May 2019\",\"author\":\"Nicola Asuni, The VirtueMart Development Team\",\"copyright\":\"Copyright (c) 2001-2018 Nicola Asuni - Tecnick.com LTD - Tutti i diritti riservati - All Rights Reserved. 2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"1.0.8\",\"description\":\"TCPDF 6.2.26 by Nicola Asuni. Joomla Installer by the VirtueMart Team\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10242, 0, 'com_cooltags', 'component', 'com_cooltags', '', 1, 1, 0, 0, '{\"name\":\"com_cooltags\",\"type\":\"component\",\"creationDate\":\"2012-10-03\",\"author\":\"Artem Sidorov\",\"copyright\":\"Copyright (C) 2015. All rights reserved.\",\"authorEmail\":\"dshnda@gmail.com\",\"authorUrl\":\"http:\\/\\/www.artofsites.ru\",\"version\":\"1.0\",\"description\":\"Tagging solution for Virtuemart 3\",\"group\":\"\",\"filename\":\"cooltags\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10243, 0, 'Cooltags Cloud', 'module', 'mod_cooltags_cloud', '', 0, 1, 0, 0, '{\"name\":\"Cooltags Cloud\",\"type\":\"module\",\"creationDate\":\"April 2015\",\"author\":\"Artem Sidorov\",\"copyright\":\"Copyright (C) 2015. All rights reserved.\",\"authorEmail\":\"dshnda@gmail.com\",\"authorUrl\":\"www.artofsites.ru\",\"version\":\"1.0\",\"description\":\"Shows a tag cloud from Virtuemart product tags. This requires com_cooltags component, Virtuemart 3 and Joomla 3.\",\"group\":\"\",\"filename\":\"mod_cooltags_cloud\"}', '{\"min_font\":\"10\",\"max_font\":\"25\",\"limit\":\"50\",\"catfilter\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10244, 0, 'VMCustom - Cooltags', 'plugin', 'cooltags', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"VMCustom - Cooltags\",\"type\":\"plugin\",\"creationDate\":\"April 2015\",\"author\":\"Artem Sidorov\",\"copyright\":\"Copyright (C) 2015. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.artofsites.ru\",\"version\":\"1.0\",\"description\":\"Adds tagging feature to Virtuemart products. This plugin requires the com_cooltags component. It also comes with its fellow (optional) search plugin extending Virtuemart product search to related product tags.\",\"group\":\"\",\"filename\":\"cooltags\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10245, 0, 'plg_search_cooltagsearch', 'plugin', 'cooltagsearch', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_cooltagsearch\",\"type\":\"plugin\",\"creationDate\":\"april 2015\",\"author\":\"Artem Sidorov\",\"copyright\":\"Copyright (C) 2015. All rights reserved.\",\"authorEmail\":\"dshnda@gmail.com\",\"authorUrl\":\"www.artofsites.ru\",\"version\":\"1.0\",\"description\":\"Allows Searching of CoolTags Component with search for product tags.\",\"group\":\"\",\"filename\":\"cooltagsearch\"}', '{\"search_limit\":\"50\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10246, 0, 'VM Payment - 2Checkout', 'plugin', 'tco', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"2Checkout\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Craig Christenson\",\"copyright\":\"Copyright (C) 2004-2015 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"http:\\/\\/www.2checkout.com\",\"version\":\"3.5.0\",\"description\":\"<a href=\\\"https:\\/\\/www.2checkout.com\\/referral?r=virtuemart\\\" target=\\\"_blank\\\">2Checkout<\\/a> is a popular payment provider and available in many countries. \\n    \",\"group\":\"\",\"filename\":\"tco\"}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10247, 0, 'System - Google Maps', 'plugin', 'plugin_googlemap3', 'system', 0, 1, 1, 0, '{\"name\":\"System - Google Maps\",\"type\":\"plugin\",\"creationDate\":\"July 2014\",\"author\":\"Mike Reumer\",\"copyright\":\"(C) 2014 Reumer\",\"authorEmail\":\"tech@reumer.net\",\"authorUrl\":\"tech.reumer.net\",\"version\":\"3.3\",\"description\":\"PLUGIN_GOOGLE_MAP3_INSTALLATION\",\"group\":\"\",\"filename\":\"plugin_googlemap3\"}', '{\"debug\":\"0\",\"plugincode\":\"mosmap\",\"brackets\":\"{\",\"Google_API_version\":\"3\",\"visualrefresh\":\"0\",\"signedin\":\"0\",\"show\":\"1\",\"mapclass\":\"\",\"mapprint\":\"icon\",\"mapcss\":\"\\/* For img in the map remove borders, shadow, no margin and no max-width\\r\\n*\\/\\r\\n.map img, .svPanel img {\\r\\n    border: 0px;\\r\\n    box-shadow: none;\\r\\n    margin: 0px !important;\\r\\n    padding: 0px !important;\\r\\n    max-width: none !important;\\r\\n    background: none !important;\\r\\n}\\r\\n\\r\\n\\/* Make sure the directions are below the map\\r\\n*\\/\\r\\n.directions {\\r\\n    clear: left;\\r\\n}\\r\\n\\r\\n.adp-directions {\\r\\n    width: 100%;\\r\\n}\\r\\n\\r\\n\\/* Solve problems in chrome with the show of the direction steps in full width\\r\\n*\\/\\r\\n.adp-placemark {\\r\\n    width : 100%;\\r\\n}\\r\\n\\r\\n\\/* Padding for image overlay\\r\\n*\\/\\r\\n.controlDiv {\\r\\n    padding : 5px;\\r\\n}\\r\\n\",\"loadmootools\":\"1\",\"timeinterval\":\"500\",\"Google_API_key\":\"AIzaSyBQft4vTUGW75YPU6c0xOMwLKhxCEJDPwg\",\"Google_Multi_API_key\":\"\",\"urlsetting\":\"http_host\",\"googlewebsite\":\"maps.google.com\",\"styledmap\":\"\",\"align\":\"center\",\"langtype\":\"site\",\"lang\":\"\",\"width\":\"100%\",\"height\":\"400\",\"effect\":\"none\",\"lat\":\"52.075581\",\"lon\":\"4.541513\",\"centerlat\":\"\",\"centerlon\":\"\",\"address\":\"\",\"geoloc\":\"0\",\"geocenter\":\"0\",\"controltype\":\"UI\",\"zoomType\":\"3D-large\",\"svcontrol\":\"1\",\"returncontrol\":\"1\",\"zoom\":\"10\",\"corzoom\":\"0\",\"minzoom\":\"0\",\"maxzoom\":\"19\",\"rotation\":\"1\",\"zoomnew\":\"0\",\"zoomWheel\":\"0\",\"keyboard\":\"0\",\"mapType\":\"Normal\",\"showmaptype\":\"1\",\"showNormalMaptype\":\"1\",\"showSatelliteMaptype\":\"1\",\"showHybridMaptype\":\"1\",\"showTerrainMaptype\":\"1\",\"showscale\":\"0\",\"overview\":\"0\",\"dragging\":\"1\",\"marker\":\"1\",\"icon\":\"\",\"iconwidth\":\"\",\"iconheight\":\"\",\"iconanchorx\":\"\",\"iconanchory\":\"\",\"iconshadow\":\"\",\"iconshadowwidth\":\"\",\"iconshadowheight\":\"\",\"iconimagemap\":\"\",\"traffic\":\"0\",\"transit\":\"0\",\"bicycle\":\"0\",\"panoramio\":\"0\",\"panominzoom\":\"none\",\"panomaxzoom\":\"none\",\"pano_userid\":\"\",\"pano_tag\":\"\",\"weather\":\"0\",\"weathercloud\":\"0\",\"weatherinfo\":\"1\",\"weathertempunit\":\"celsius\",\"weatherwindunit\":\"km\",\"dir\":\"0\",\"dirtype\":\"D\",\"formdirtype\":\"1\",\"avoidhighways\":\"0\",\"avoidtoll\":\"0\",\"diroptimize\":\"0\",\"diralternatives\":\"0\",\"showdir\":\"1\",\"animdir\":\"0\",\"animspeed\":\"1\",\"animautostart\":\"0\",\"animunit\":\"kilometers\",\"formspeed\":\"0\",\"formaddress\":\"0\",\"formdir\":\"0\",\"autocompl\":\"both\",\"langanim\":\"en-GB;The requested panorama could not be displayed|Could not generate a route for the current start and end addresses|Street View coverage is not available for this route|You have reached your destination|miles|miles|ft|kilometers|kilometer|meters|In|You will reach your destination|Stop|Drive|Press Drive to follow your route|Route|Speed|Fast|Medium|Slow\",\"txtdir\":\"Directions: \",\"txtgetdir\":\"Get Directions\",\"txtfrom\":\"From here\",\"txtto\":\"To here\",\"txtdiraddr\":\"Address: \",\"txt_driving\":\"\",\"txt_avhighways\":\"\",\"txt_avtoll\":\"\",\"txt_walking\":\"\",\"txt_bicycle\":\"\",\"txt_transit\":\"\",\"txt_optimize\":\"\",\"txt_alternatives\":\"\",\"inputsize\":\"25\",\"dirdefault\":\"0\",\"gotoaddr\":\"0\",\"gotoaddrzoom\":\"0\",\"gotoaddrtimeout\":\"5000\",\"txtaddr\":\"Address: ##\",\"erraddr\":\"Address ## not found!\",\"txtgotoaddr\":\"Goto\",\"clientgeotype\":\"google\",\"lightbox\":\"0\",\"txtlightbox\":\"Open lightbox\",\"lbxcaption\":\"\",\"lbxwidth\":\"500\",\"lbxheight\":\"700\",\"lbxcenterlat\":\"\",\"lbxcenterlon\":\"\",\"lbxzoom\":\"\",\"sv\":\"none\",\"svpano\":\"\",\"svwidth\":\"100%\",\"svheight\":\"300\",\"svyaw\":\"0\",\"svpitch\":\"0\",\"svzoom\":\"\",\"svautorotate\":\"0\",\"svaddress\":\"1\",\"kmlrenderer\":\"google\",\"kmlsidebar\":\"none\",\"kmlsbwidth\":\"200\",\"kmlfoldersopen\":\"0\",\"kmlhide\":\"0\",\"kmlscale\":\"0\",\"kmlopenmethod\":\"click\",\"kmlsbsort\":\"none\",\"kmllightbox\":\"0\",\"kmlmessshow\":\"0\",\"kmlclickablemarkers\":\"1\",\"kmlzoommarkers\":\"0\",\"kmlopendivmarkers\":\"\",\"kmlcontentlinkmarkers\":\"0\",\"kmllinkablemarkers\":\"0\",\"kmllinktarget\":\"_self\",\"kmllinkmethod\":\"dblclick\",\"kmlhighlite\":\"{ \'color\': \'#aaffff\', \'opacity\': 0.3,  \'textcolor\': \'#000000\' }\",\"kmlmarkerlabel\":\"100\",\"kmlmarkerlabelclass\":\"\",\"kmlpolylabel\":\"100\",\"kmlpolylabelclass\":\"\",\"proxy\":\"0\",\"txtsrchnrby\":\"Search nearby\",\"txtzoomhere\":\"Zoom Here\",\"txtaddrstart\":\"Start address:\",\"txtkmlgetdir\":\"Go\",\"txtback\":\"\\u00ab Back\",\"txtsearchnearby\":\"Search nearby: e.g. pizza\",\"txtsearch\":\"Go\",\"maxcluster\":\"\",\"clustericonurl\":\"\\/media\\/plugin_googlemap3\\/site\\/geoxmlv3\\/images\\/m\",\"gridsize\":\"\",\"minmarkerscluster\":\"\",\"maxlinesinfocluster\":\"\",\"clusterinfowindow\":\"click\",\"clusterzoom\":\"dblclick\",\"clustermarkerzoom\":\"16\",\"txtzoomin\":\"Zoom in to show more\",\"txtclustercount1\":\"...and\",\"txtclustercount2\":\"more\",\"tilelayer\":\"\",\"tilemethod\":\"\",\"tileopacity\":\"1\",\"tilebounds\":\"\",\"tileminzoom\":\"0\",\"tilemaxzoom\":\"19\",\"imageurl\":\"\",\"imageposition\":\"RIGHT_TOP\",\"imageindex\":\"1\",\"imagewidth\":\"\",\"imageheight\":\"\",\"twittername\":\"\",\"twittertweets\":\"15\",\"twittericon\":\"\\/media\\/plugin_googlemap3\\/site\\/Twitter\\/twitter_map_icon.png\",\"twitterline\":\"#ff0000ff\",\"twitterlinewidth\":\"4\",\"twitterstartloc\":\"0,0,0\",\"twitterconsumerkey\":\"\",\"twitterconsumersecret\":\"\",\"twitteraccesstoken\":\"\",\"twitteraccesstokensecret\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 46, 0),
(10248, 0, 'System - VirtueMart One Page Checkout', 'plugin', 'onepage_generic', 'system', 0, 1, 1, 0, '{\"name\":\"System - VirtueMart One Page Checkout\",\"type\":\"plugin\",\"creationDate\":\"Feb 2018\",\"author\":\"Claes Norin\",\"copyright\":\" Copyright (c) 2012, 2015 All Right Reserved, http:\\/\\/www.joomlapro.com.\",\"authorEmail\":\"info@joomlapro.com\",\"authorUrl\":\"http:\\/\\/www.joomlapro.com\\/\",\"version\":\"2.2.53\",\"description\":\"<html>\\n\\t\\t   <table class=\\\"table\\\"><tr><td><a href=\\\"http:\\/\\/joomlapro.com\\\" target=\\\"_blank\\\"><img src=\\\"http:\\/\\/joomlapro.com\\/images\\/logo1.png\\\"><\\/a><\\/td><td><h3>System - VirtueMart One Page Checkout downloaded from joomlapro.com.<\\/h3><hr>We have built quality Joomla extension since 2012. JoomlaPro is a company under joomlapro.com<\\/td><\\/tr>\\n\\t\\t   <tr>\\n\\t\\t   <td colspan=\\\"2\\\" style=\\\"text-align:right; padding:10px 0 0 0; border-bottom:0px none\\\">\\n\\t\\t   <a href=\\\"http:\\/\\/joomlapro.com\\/\\\" target=\\\"_blank\\\"><img src=\\\"http:\\/\\/joomlapro.com\\/images\\/logo2.png\\\"><\\/a>\\n\\t\\t   <\\/td>\\n\\t\\t   <\\/tr>\\n\\t\\t   <\\/table>\\n\\t     \",\"group\":\"\",\"filename\":\"onepage_generic\"}', '{\"download_key\":\"\",\"show_extraterms\":\"0\",\"popup_address\":\"1\",\"show_shiptoaddress_list\":\"1\",\"hide_oneshipment\":\"0\",\"hide_onepayment\":\"0\",\"list_allpayment\":\"1\",\"list_allshipment\":\"1\",\"hide_billto_btn\":\"0\",\"hide_shipto_btn\":\"0\",\"allow_html\":\"0\",\"show_onlyguest\":\"0\",\"buttoncolour\":\"\",\"button_primary\":\"\",\"button_danger\":\"\",\"form_danger\":\"\",\"activetab\":\"3\",\"auto_country\":\"0\",\"hide_countryfield\":\"0\",\"hide_statefield\":\"0\",\"check_terms\":\"1\",\"show_forgot\":\"1\",\"layout_width\":\"4\",\"notes_popup\":\"1\",\"terms_css\":\"0\",\"hide_coupon_amount\":\"0\",\"hide_coupon_tax_amount\":\"0\",\"hide_payment_amount\":\"0\",\"hide_shipment_amount\":\"0\",\"country_reload\":\"0\",\"ajax_zip\":\"0\",\"showzip_top\":\"0\",\"use_recaptcha\":\"0\",\"recaptchakey\":\"\",\"secretkey\":\"\",\"built_by\":\"1\"}', '', '', 0, '0000-00-00 00:00:00', 11, 0),
(10249, 0, 'AcyMailing JCE integration', 'plugin', 'jceacymailing', 'system', 0, 1, 1, 0, '{\"version\":\"5.8.0\",\"author\":\"Acyba\",\"creationDate\":\"ao\\u00fbt 2017\"}', '', '', '', 0, '0000-00-00 00:00:00', 39, 0),
(10250, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"https:\\/\\/www.joomshaper.com\",\"version\":\"3.6.1\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10251, 0, 'System - SP PageBuilder', 'plugin', 'sppagebuilder', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 19, 0),
(10252, 0, 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', 'system', 0, 1, 1, 0, '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.1\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10253, 0, 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.5\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10254, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2019 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10255, 0, 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10256, 0, 'mod_sppagebuilder_admin_menu', 'module', 'mod_sppagebuilder_admin_menu', '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_admin_menu\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.3\",\"description\":\"MOD_SPPAGEBUILDER_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_admin_menu\"}', '[]', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10257, 0, 'VM Framework Loader during Plugin Updates', 'plugin', 'vmLoaderPluginUpdate', 'system', 0, 1, 1, 0, '{\"name\":\"VM Framework Loader during Plugin Updates\",\"type\":\"plugin\",\"creationDate\":\"2017-08-06\",\"author\":\"Reinhold Kainhofer\",\"copyright\":\"Copyright (C) 2017 Reinhold Kainhofer.\",\"authorEmail\":\"office@open-tools.net\",\"authorUrl\":\"http:\\/\\/www.virtuemart.net\\/\",\"version\":\"1.0\",\"description\":\"Makes sure the VirtueMart framework is loaded during automatic plugin updates using Joomla\'s plugin updater.\",\"group\":\"\",\"filename\":\"vmLoaderPluginUpdate\"}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10258, 0, 'vmVendor', 'plugin', 'vmvendor', 'system', 0, 1, 1, 0, '{\"name\":\"vmVendor\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"velikorodnov\",\"copyright\":\"mad_velikorodnov\",\"authorEmail\":\"velikorodnov@velikorodnov.com\",\"authorUrl\":\"http:\\/\\/themeforest.net\\/user\\/mad_velikorodnov\",\"version\":\"1.0\",\"description\":\"\\n        <html>\\n          Dear customer. Activate your template please using purchase code. You can use one code for one copy. If you want to use your purchase code at another site, de-register current code and and activate it on another site. If you don\'t know where you can find Purchase code follow our instruction: <a target=\\\"_blank\\\" href=\\\"https:\\/\\/help.market.envato.com\\/hc\\/en-us\\/articles\\/202822600\\\">https:\\/\\/help.market.envato.com\\/hc\\/en-us\\/articles\\/202822600<\\/a>  \\nIf you can\'t de-register your code contact us via contact form on our profile page here <a target=\\\"_blank\\\" href=\\\"https:\\/\\/themeforest.net\\/user\\/monkeysan\\\">https:\\/\\/themeforest.net\\/user\\/monkeysan<\\/a><p>1. For activation copy your purchase code from themeforest and insert it to Purchase code verification field. If you inserted code right click Register code button and your code will be registered for your Domain<\\/p>\\n<p>2. For Deactivation your current code click  Deregister the code button and save the plugin<\\/p>\\n<p>3. For activation Trial version is available during 10 days insert 12345 and save the plugin<\\/p>\\n         \\n    \",\"group\":\"\",\"filename\":\"vmvendor\"}', '{\"data_trial\":\"27.08.2019\",\"download_key\":\"12345\",\"activate\":\"0\"}', '', '', 0, '0000-00-00 00:00:00', 7, 0);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(10259, 0, 'com_virtuemart - en-GB', 'file', 'com_virtuemart-en-GB', '', 0, 1, 0, 0, '{\"name\":\"com_virtuemart - en-GB\",\"type\":\"file\",\"creationDate\":\"03.11.2017\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004-2014 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"max|at|virtuemart.net\",\"authorUrl\":\"https:\\/\\/www.virtuemart.net\",\"version\":\"2017-11-03-09-18-36\",\"description\":\"\\n        This package was auto generated with CTransifex(https:\\/\\/compojoom.com). We\'ve grabbed the latest language files for our extension from transifex.com.\\n        Special thanks to OpenTranslators (http:\\/\\/opentranslators.org) for helping us with this translation!\\n    \",\"group\":\"\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10260, 0, 'plg_finder_sppagebuilder', 'plugin', 'sppagebuilder', 'finder', 0, 0, 1, 0, '{\"name\":\"plg_finder_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"March 2018\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2010 - 2019 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.6\",\"description\":\"PLG_FINDER_SP_PAGEBUILDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10261, 10263, 'PLG_SYSTEM_JCH_OPTIMIZE', 'plugin', 'jch_optimize', 'system', 0, 0, 1, 0, '{\"name\":\"PLG_SYSTEM_JCH_OPTIMIZE\",\"type\":\"plugin\",\"creationDate\":\"March 2019\",\"author\":\"Samuel Marshall\",\"copyright\":\"Copyright (C) 2017 Samuel Marshall. All rights reserved.\",\"authorEmail\":\"sdmarshall73@gmail.com\",\"authorUrl\":\"http:\\/\\/www.jch-optimize.net\",\"version\":\"5.4.2\",\"description\":\"JCH_OPTIMIZE_DESCRIPTION\",\"group\":\"\",\"filename\":\"jch_optimize\"}', '{\"combine_files_enable\":\"1\",\"html_minify_level\":\"0\",\"htaccess\":\"2\",\"try_catch\":\"1\",\"debug\":\"0\",\"log\":\"0\",\"css\":\"1\",\"javascript\":\"1\",\"gzip\":\"0\",\"css_minify\":\"0\",\"js_minify\":\"0\",\"html_minify\":\"0\",\"includeAllExtensions\":\"0\",\"pro_replaceImports\":\"0\",\"pro_phpAndExternal\":\"0\",\"pro_inlineStyle\":\"0\",\"pro_inlineScripts\":\"0\",\"pro_bottom_js\":\"0\",\"pro_loadAsynchronous\":\"0\",\"excludeCss\":\"\",\"excludeJs_peo\":\"\",\"excludeCssComponents\":\"\",\"excludeJsComponents_peo\":\"\",\"pro_excludeStyles\":\"\",\"pro_excludeScripts_peo\":\"\",\"pro_excludeAllStyles\":\"0\",\"pro_excludeAllScripts\":\"0\",\"excludeJs\":\"\",\"excludeJsComponents\":\"\",\"pro_excludeScripts\":\"\",\"csg_enable\":\"0\",\"csg_direction\":\"vertical\",\"csg_wrap_images\":\"0\",\"csg_exclude_images\":\"\",\"csg_include_images\":\"\",\"img_attributes_enable\":\"0\",\"pro_downloadid\":\"\",\"pro_cookielessdomain_enable\":\"0\",\"pro_cdn_scheme\":\"0\",\"pro_cookielessdomain\":\"\",\"pro_cookielessdomain_2\":\"\",\"pro_cookielessdomain_3\":\"\",\"pro_lazyload\":\"0\",\"pro_excludeLazyLoad\":\"\",\"pro_excludeLazyLoadFolders\":\"\",\"pro_excludeLazyLoadClass\":\"\",\"pro_lazyload_forceload\":\"0\",\"pro_optimizeCssDelivery_enable\":\"0\",\"pro_optimizeCssDelivery\":\"200\",\"pro_optimizeCssDelivery_loadFile\":\"0\",\"kraken_backup\":\"\"}', '', '', 0, '0000-00-00 00:00:00', 45, 0),
(10262, 10263, 'JCH Optimize', 'component', 'com_jch_optimize', '', 1, 1, 0, 0, '{\"name\":\"JCH Optimize\",\"type\":\"component\",\"creationDate\":\"March 2019\",\"author\":\"Samuel Marshall\",\"copyright\":\"(c) 2017 JCH Optimize All rights reserved\",\"authorEmail\":\"samuel@jch-optimize.net\",\"authorUrl\":\"https:\\/\\/www.jch-optimize.net\",\"version\":\"5.4.2\",\"description\":\"Provides Ajax support to the JCH Optimize plugin\",\"group\":\"\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10263, 0, 'JCH Optimize Package', 'package', 'pkg_jch_optimize', '', 0, 1, 1, 0, '{\"name\":\"JCH Optimize Package\",\"type\":\"package\",\"creationDate\":\"March 2019\",\"author\":\"Samuel Marshall\",\"copyright\":\"Copyright (c) 2017 Samuel Marshall\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"5.4.2\",\"description\":\"Package to install the JCH Optimize plugin with supporting component\",\"group\":\"\",\"filename\":\"pkg_jch_optimize\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10265, 0, 'sourcecoast', 'library', 'sourcecoast', '', 0, 0, 1, 0, '{\"name\":\"SourceCoast Extensions Library\",\"type\":\"library\",\"creationDate\":\"2013\\/09\\/23\",\"author\":\"SourceCoast | www.sourcecoast.com\",\"copyright\":\"Copyright (C) 2012-2013 SourceCoast. All rights reserved.\",\"authorEmail\":\"support@sourcecoast.com\",\"authorUrl\":\"http:\\/\\/www.sourcecoast.com\",\"version\":\"2.3.0\",\"description\":\"This library provides common functionality to the SourceCoast Social Extensions (JFBConnect, JLinked, etc)\",\"group\":\"\",\"filename\":\"sourcecoast\"}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, -1),
(10266, 0, 'VM Payment - eWay', 'plugin', 'eway', 'vmpayment', 0, 0, 1, 0, '{\"name\":\"VM Payment - eway\",\"type\":\"plugin\",\"creationDate\":\"August 02 2019\",\"author\":\"The VirtueMart Development Team\",\"copyright\":\"Copyright (C) 2004 - 2019 Virtuemart Team. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/virtuemart.net\",\"version\":\"3.5.0\",\"description\":\"<a href=\\\"https:\\/\\/www.eway.com.au\\/\\\" target=\\\"_blank\\\">eway<\\/a> \\n    \",\"group\":\"\",\"filename\":\"eway\"}', '', '', '', 0, '0000-00-00 00:00:00', 20, 0),
(10267, 0, 'VM Custom - iStraxx Download simple', 'plugin', 'istraxx_download_simple', 'vmcustom', 0, 1, 1, 0, '{\"name\":\"VM - Custom, Virtuemart Simple Download Plugin\",\"type\":\"plugin\",\"creationDate\":\"${PHING.RELDATE}\",\"author\":\"${PHING.AUTHOR}\",\"copyright\":\"${PHING.COPYRIGHT.EXTENSION}\",\"authorEmail\":\"\",\"authorUrl\":\"${PHING.AUTHORURL}\",\"version\":\"${PHING.VERSION}\",\"description\":\"\\n<b>${PHING.DESCRIPTION}<\\/b>\\n<br\\/><a target=\\\"_blank\\\" href=\\\"http:\\/\\/www.extensions.virtuemart.net\\\">Visit extensions.virtuemart.net for more extensions<\\/a>\\n<p><img src=\\\"..\\/plugins\\/${PHING.GROUP}\\/${PHING.FILENAME}\\/assets\\/images\\/vm-istraxx.png\\\" align=\\\"bottom\\\"\\/><\\/p>\\n\\n<br style=\\\"clear: both;\\\">\\n<br\\/>\\nFirst installation:\\n<a target=\\\"_blank\\\" href=\\\"index.php?option=com_virtuemart&view=custom&task=edit\\\">\\n  Click here to configure the new customfield using the custom field type plugin<\\/a>\\n<br\\/>\\nSee also:\\n<br\\/>\\n<a target=\\\"_blank\\\" href=\\\"https:\\/\\/extensions.virtuemart.net\\/all-tutorials\\\">\\n  Installation Guide<\\/a>\\n\\n\",\"group\":\"\",\"filename\":\"istraxx_download_simple\"}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0);

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE IF NOT EXISTS `#__fields` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `required` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE IF NOT EXISTS `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT 0,
  `category_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE IF NOT EXISTS `#__fields_groups` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE IF NOT EXISTS `#__fields_values` (
  `field_id` int(10) UNSIGNED NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__jcomments`;
CREATE TABLE IF NOT EXISTS `#__jcomments` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `thread_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `level` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `object_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `object_group` varchar(255) NOT NULL DEFAULT '',
  `object_params` text NOT NULL,
  `lang` varchar(255) NOT NULL DEFAULT '',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `homepage` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `comment` text NOT NULL,
  `ip` varchar(39) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `isgood` smallint(5) NOT NULL DEFAULT 0,
  `ispoor` smallint(5) NOT NULL DEFAULT 0,
  `published` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `deleted` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `subscribe` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `source` varchar(255) NOT NULL DEFAULT '',
  `source_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_userid` (`userid`),
  KEY `idx_source` (`source`),
  KEY `idx_email` (`email`),
  KEY `idx_lang` (`lang`),
  KEY `idx_subscribe` (`subscribe`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_object` (`object_id`,`object_group`,`published`,`date`),
  KEY `idx_path` (`path`,`level`),
  KEY `idx_thread` (`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_blacklist`;
CREATE TABLE IF NOT EXISTS `#__jcomments_blacklist` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) NOT NULL DEFAULT '',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `expire` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reason` tinytext NOT NULL,
  `notes` tinytext NOT NULL,
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_custom_bbcodes`;
CREATE TABLE IF NOT EXISTS `#__jcomments_custom_bbcodes` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `simple_pattern` varchar(255) NOT NULL DEFAULT '',
  `simple_replacement_html` text NOT NULL,
  `simple_replacement_text` text NOT NULL,
  `pattern` varchar(255) NOT NULL DEFAULT '',
  `replacement_html` text NOT NULL,
  `replacement_text` text NOT NULL,
  `button_acl` text NOT NULL,
  `button_open_tag` varchar(16) NOT NULL DEFAULT '',
  `button_close_tag` varchar(16) NOT NULL DEFAULT '',
  `button_title` varchar(255) NOT NULL DEFAULT '',
  `button_prompt` varchar(255) NOT NULL DEFAULT '',
  `button_image` varchar(255) NOT NULL DEFAULT '',
  `button_css` varchar(255) NOT NULL DEFAULT '',
  `button_enabled` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `ordering` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `published` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments_custom_bbcodes` (`id`, `name`, `simple_pattern`, `simple_replacement_html`, `simple_replacement_text`, `pattern`, `replacement_html`, `replacement_text`, `button_acl`, `button_open_tag`, `button_close_tag`, `button_title`, `button_prompt`, `button_image`, `button_css`, `button_enabled`, `ordering`, `published`, `checked_out`, `checked_out_time`) VALUES
(1, 'YouTube Video', '[youtube]http://www.youtube.com/watch?v={IDENTIFIER}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]http\\:\\/\\/www\\.youtube\\.com\\/watch\\?v\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,2,3,4,5,6,7,8', '[youtube]', '[/youtube]', 'YouTube Video', '', '', 'bbcode-youtube', 1, 1, 1, 0, '0000-00-00 00:00:00'),
(2, 'YouTube Video (short syntax)', '[youtube]{IDENTIFIER}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,2,3,4,5,6,7,8', '', '', '', '', '', '', 0, 2, 1, 0, '0000-00-00 00:00:00'),
(3, 'YouTube Video (full syntax)', '[youtube]http://www.youtube.com/watch?v={IDENTIFIER}{TEXT}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]http\\:\\/\\/www\\.youtube\\.com\\/watch\\?v\\=([A-Za-z0-9-_]+)([\\w0-9-\\+\\=\\!\\?\\(\\)\\[\\]\\{\\}\\&\\%\\*\\#\\.,_ ]+)\\[\\/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,2,3,4,5,6,7,8', '[youtube]', '[/youtube]', 'YouTube Video', '', '', '', 0, 3, 1, 0, '0000-00-00 00:00:00'),
(4, 'Google Video', '[google]http://video.google.com/videoplay?docid={IDENTIFIER}[/google]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId={IDENTIFIER}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid={IDENTIFIER}', '\\[google\\]http\\:\\/\\/video\\.google\\.com\\/videoplay\\?docid\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/google\\]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId=${1}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid=${1}', '1,2,3,4,5,6,7,8', '[google]', '[/google]', 'Google Video', '', '', 'bbcode-google', 1, 4, 1, 0, '0000-00-00 00:00:00'),
(5, 'Google Video (short syntax)', '[google]{IDENTIFIER}[/google]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId={IDENTIFIER}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid={IDENTIFIER}', '\\[google\\]([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/google\\]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId=${1}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid=${1}', '1,2,3,4,5,6,7,8', '', '', '', '', '', '', 0, 5, 1, 0, '0000-00-00 00:00:00'),
(6, 'Google Video (alternate syntax)', '[gv]http://video.google.com/videoplay?docid={IDENTIFIER}[/gv]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId={IDENTIFIER}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid={IDENTIFIER}', '\\[gv\\]http\\:\\/\\/video\\.google\\.com\\/videoplay\\?docid\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/gv\\]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId=${1}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid=${1}', '1,2,3,4,5,6,7,8', '', '', '', '', '', '', 0, 6, 1, 0, '0000-00-00 00:00:00'),
(7, 'Google Video (alternate syntax)', '[googlevideo]http://video.google.com/videoplay?docid={IDENTIFIER}[/googlevideo]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId={IDENTIFIER}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid={IDENTIFIER}', '\\[googlevideo\\]http\\:\\/\\/video\\.google\\.com\\/videoplay\\?docid\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/googlevideo\\]', '<embed style=\"width:425px; height:350px;\" id=\"VideoPlayback\" type=\"application/x-shockwave-flash\" src=\"http://video.google.com/googleplayer.swf?docId=${1}\" flashvars=\"\"></embed>', 'http://video.google.com/videoplay?docid=${1}', '1,2,3,4,5,6,7,8', '', '', '', '', '', '', 0, 7, 1, 0, '0000-00-00 00:00:00'),
(8, 'Facebook Video', '[fv]http://www.facebook.com/video/video.php?v={IDENTIFIER}[/fv]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/photo.php?v={IDENTIFIER}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v={IDENTIFIER}', '\\[fv\\]http\\:\\/\\/www\\.facebook\\.com\\/video\\/video\\.php\\?v\\=([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/fv\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/photo.php?v=${1}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v=${1}', '1,2,3,4,5,6,7,8', '[fv]', '[/fv]', 'Facebook Video', '', '', 'bbcode-facebook', 1, 8, 1, 0, '0000-00-00 00:00:00'),
(9, 'Facebook Video (short syntax)', '[fv]{IDENTIFIER}[/fv]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/photo.php?v={IDENTIFIER}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v={IDENTIFIER}', '\\[fv\\]([A-Za-z0-9-_]+)([A-Za-z0-9\\%\\&\\=\\#]*?)\\[\\/fv\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.facebook.com/photo.php?v=${1}\" frameborder=\"0\"></iframe>', 'http://www.facebook.com/photo.php?v=${1}', '1,2,3,4,5,6,7,8', '', '', '', '', '', '', 0, 9, 1, 0, '0000-00-00 00:00:00'),
(10, 'Wiki', '[wiki]{SIMPLETEXT}[/wiki]', '<a href=\"http://www.wikipedia.org/wiki/{SIMPLETEXT}\" title=\"{SIMPLETEXT}\" target=\"_blank\">{SIMPLETEXT}</a>', '{SIMPLETEXT}', '\\[wiki\\]([A-Za-z0-9\\-\\+\\.,_ ]+)\\[\\/wiki\\]', '<a href=\"http://www.wikipedia.org/wiki/${1}\" title=\"${1}\" target=\"_blank\">${1}</a>', '${1}', '1,2,3,4,5,6,7,8', '[wiki]', '[/wiki]', 'Wikipedia', '', '', 'bbcode-wiki', 1, 10, 1, 0, '0000-00-00 00:00:00'),
(11, 'YouTube Video (alternate syntax)', '[youtube]http://www.youtube.com/watch?feature=player_embedded&v={IDENTIFIER}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]http\\://www\\.youtube\\.com/watch\\?feature\\=player_embedded&v\\=([\\w0-9-_]+)\\[/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,9,6,7,2,3,4,5,8', '', '', '', '', '', '', 0, 100, 1, 0, '0000-00-00 00:00:00'),
(12, 'YouTube Video (alternate syntax)', '[youtube]http://youtu.be/{IDENTIFIER}[/youtube]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/{IDENTIFIER}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/{IDENTIFIER}', '\\[youtube\\]http\\://youtu\\.be/([\\w0-9-_]+)\\[/youtube\\]', '<iframe width=\"425\" height=\"350\" src=\"//www.youtube.com/embed/${1}?rel=0\" frameborder=\"0\" allowfullscreen></iframe>', 'http://youtu.be/${1}', '1,9,6,7,2,3,4,5,8', '', '', '', '', '', '', 0, 101, 1, 0, '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__jcomments_mailq`;
CREATE TABLE IF NOT EXISTS `#__jcomments_mailq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `created` datetime NOT NULL,
  `attempts` tinyint(1) NOT NULL DEFAULT 0,
  `priority` tinyint(1) NOT NULL DEFAULT 0,
  `session_id` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_priority` (`priority`),
  KEY `idx_attempts` (`attempts`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_objects`;
CREATE TABLE IF NOT EXISTS `#__jcomments_objects` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `object_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `object_group` varchar(255) NOT NULL DEFAULT '',
  `category_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `lang` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `link` text NOT NULL,
  `access` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `userid` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `expired` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_object` (`object_id`,`object_group`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_reports`;
CREATE TABLE IF NOT EXISTS `#__jcomments_reports` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `commentid` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `userid` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(39) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reason` tinytext NOT NULL,
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_settings`;
CREATE TABLE IF NOT EXISTS `#__jcomments_settings` (
  `component` varchar(50) NOT NULL DEFAULT '',
  `lang` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  PRIMARY KEY (`component`,`lang`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments_settings` (`component`, `lang`, `name`, `value`) VALUES
('', '', 'author_email', '2'),
('', '', 'author_homepage', '1'),
('', '', 'author_name', '2'),
('', '', 'autolinkurls', '6,7,2,3,4,5,8'),
('', '', 'autopublish', '1,6,7,2,3,4,5,8'),
('', '', 'badwords', ''),
('', '', 'can_ban', '7,8'),
('', '', 'can_comment', '1,6,7,2,3,4,5,8'),
('', '', 'can_delete', '6,7,8'),
('', '', 'can_delete_for_my_object', ''),
('', '', 'can_delete_own', '6,7,8'),
('', '', 'can_edit', '6,7,8'),
('', '', 'can_edit_for_my_object', ''),
('', '', 'can_edit_own', '6,7,2,3,4,5,8'),
('', '', 'can_publish', '6,7,5,8'),
('', '', 'can_publish_for_my_object', ''),
('', '', 'can_reply', '1,6,7,2,3,4,5,8'),
('', '', 'can_report', ''),
('', '', 'can_view_email', '6,7,8'),
('', '', 'can_view_homepage', '6,7,2,3,4,5,8'),
('', '', 'can_view_ip', '7,8'),
('', '', 'can_vote', '1,6,7,2,3,4,5,8'),
('', '', 'captcha_engine', 'kcaptcha'),
('', '', 'censor_replace_word', '[censored]'),
('', '', 'comments_list_order', 'DESC'),
('', '', 'comments_page_limit', '15'),
('', '', 'comments_pagination', 'both'),
('', '', 'comments_per_page', '10'),
('', '', 'comments_tree_order', '0'),
('', '', 'comment_maxlength', '1000'),
('', '', 'comment_minlength', '0'),
('', '', 'comment_title', '0'),
('', '', 'delete_mode', '0'),
('', '', 'display_author', 'name'),
('', '', 'emailprotection', '1'),
('', '', 'enable_autocensor', '1'),
('', '', 'enable_bbcode_b', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_code', ''),
('', '', 'enable_bbcode_hide', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_i', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_img', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_list', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_quote', '1,6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_s', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_u', '6,7,2,3,4,5,8'),
('', '', 'enable_bbcode_url', '6,7,2,3,4,5,8'),
('', '', 'enable_blacklist', '0'),
('', '', 'enable_captcha', '1'),
('', '', 'enable_categories', ''),
('', '', 'enable_comment_length_check', '1,2'),
('', '', 'enable_comment_maxlength_check', ''),
('', '', 'enable_custom_bbcode', '0'),
('', '', 'enable_geshi', '0'),
('', '', 'enable_gravatar', ''),
('', '', 'enable_mambots', '1'),
('', '', 'enable_nested_quotes', '1'),
('', '', 'enable_notification', '0'),
('', '', 'enable_plugins', '1'),
('', '', 'enable_quick_moderation', '0'),
('', '', 'enable_reports', '1'),
('', '', 'enable_rss', '1'),
('', '', 'enable_smilies', '0'),
('', '', 'enable_subscribe', '1,6,7,2,3,4,5,8'),
('', '', 'enable_username_check', '1'),
('', '', 'enable_voting', '1'),
('', '', 'feed_limit', '100'),
('', '', 'floodprotection', '1,2,3,4'),
('', '', 'flood_time', '30'),
('', '', 'forbidden_names', 'administrator,moderator'),
('', '', 'form_position', '0'),
('', '', 'form_show', '1'),
('', '', 'link_maxlength', '30'),
('', '', 'load_cached_comments', '1'),
('', '', 'max_comments_per_object', '0'),
('', '', 'merge_time', '0'),
('', '', 'message_banned', ''),
('', '', 'message_locked', 'Comments are now closed for this entry'),
('', '', 'message_policy_post', ''),
('', '', 'message_policy_whocancomment', 'You have no rights to post comments'),
('', '', 'notification_email', ''),
('', '', 'notification_type', '1,2'),
('', '', 'reports_before_unpublish', '0'),
('', '', 'reports_per_comment', '0'),
('', '', 'report_reason_required', '1'),
('', '', 'show_commentlength', '1'),
('', '', 'show_policy', '1,2'),
('', '', 'smilies', ':D	laugh.gif\n:lol:	lol.gif\n:-)	smile.gif\n;-)	wink.gif\n8)	cool.gif\n:-|	normal.gif\n:-*	whistling.gif\n:oops:	redface.gif\n:sad:	sad.gif\n:cry:	cry.gif\n:o	surprised.gif\n:-?	confused.gif\n:-x	sick.gif\n:eek:	shocked.gif\n:zzz	sleeping.gif\n:P	tongue.gif\n:roll:	rolleyes.gif\n:sigh:	unsure.gif'),
('', '', 'smilies_path', '/components/com_jcomments/images/smilies/'),
('', '', 'template', 'default'),
('', '', 'template_view', 'list'),
('', '', 'username_maxlength', '20'),
('', '', 'word_maxlength', '15'),
('', 'en-GB', 'author_email', '2'),
('', 'en-GB', 'author_homepage', '1'),
('', 'en-GB', 'author_name', '2'),
('', 'en-GB', 'autolinkurls', '6,7,2,3,4,5,8'),
('', 'en-GB', 'autopublish', '6,7,2,3,4,5,8'),
('', 'en-GB', 'badwords', ''),
('', 'en-GB', 'can_ban', '7,8'),
('', 'en-GB', 'can_comment', '1,6,7,2,3,4,5,8'),
('', 'en-GB', 'can_delete', '6,7,8'),
('', 'en-GB', 'can_delete_for_my_object', ''),
('', 'en-GB', 'can_delete_own', '6,7,8'),
('', 'en-GB', 'can_edit', '6,7,8'),
('', 'en-GB', 'can_edit_for_my_object', ''),
('', 'en-GB', 'can_edit_own', '6,7,2,3,4,5,8'),
('', 'en-GB', 'can_publish', '6,7,5,8'),
('', 'en-GB', 'can_publish_for_my_object', ''),
('', 'en-GB', 'can_reply', '1,6,7,2,3,4,5,8'),
('', 'en-GB', 'can_report', ''),
('', 'en-GB', 'can_view_email', '6,7,8'),
('', 'en-GB', 'can_view_homepage', '6,7,2,3,4,5,8'),
('', 'en-GB', 'can_view_ip', '7,8'),
('', 'en-GB', 'can_vote', '1,6,7,2,3,4,5,8'),
('', 'en-GB', 'captcha_engine', 'kcaptcha'),
('', 'en-GB', 'censor_replace_word', '[censored]'),
('', 'en-GB', 'comments_list_order', 'DESC'),
('', 'en-GB', 'comments_page_limit', '15'),
('', 'en-GB', 'comments_pagination', 'both'),
('', 'en-GB', 'comments_per_page', '10'),
('', 'en-GB', 'comments_tree_order', '0'),
('', 'en-GB', 'comment_maxlength', '1000'),
('', 'en-GB', 'comment_minlength', '0'),
('', 'en-GB', 'comment_title', '0'),
('', 'en-GB', 'delete_mode', '0'),
('', 'en-GB', 'display_author', 'name'),
('', 'en-GB', 'emailprotection', '1'),
('', 'en-GB', 'enable_autocensor', '1'),
('', 'en-GB', 'enable_bbcode_b', '6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_bbcode_code', ''),
('', 'en-GB', 'enable_bbcode_hide', '6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_bbcode_i', '6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_bbcode_img', '6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_bbcode_list', '6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_bbcode_quote', '1,6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_bbcode_s', '6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_bbcode_u', '6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_bbcode_url', '6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_blacklist', '0'),
('', 'en-GB', 'enable_captcha', '1'),
('', 'en-GB', 'enable_categories', ''),
('', 'en-GB', 'enable_comment_length_check', '1,2'),
('', 'en-GB', 'enable_comment_maxlength_check', ''),
('', 'en-GB', 'enable_custom_bbcode', '0'),
('', 'en-GB', 'enable_geshi', '0'),
('', 'en-GB', 'enable_gravatar', ''),
('', 'en-GB', 'enable_mambots', '1'),
('', 'en-GB', 'enable_nested_quotes', '1'),
('', 'en-GB', 'enable_notification', '0'),
('', 'en-GB', 'enable_quick_moderation', '0'),
('', 'en-GB', 'enable_reports', '0'),
('', 'en-GB', 'enable_rss', '1'),
('', 'en-GB', 'enable_smilies', '0'),
('', 'en-GB', 'enable_subscribe', '1,6,7,2,3,4,5,8'),
('', 'en-GB', 'enable_username_check', '1'),
('', 'en-GB', 'enable_voting', '1'),
('', 'en-GB', 'feed_limit', '100'),
('', 'en-GB', 'floodprotection', '1,2,3,4'),
('', 'en-GB', 'flood_time', '30'),
('', 'en-GB', 'forbidden_names', 'administrator,moderator'),
('', 'en-GB', 'form_position', '0'),
('', 'en-GB', 'form_show', '1'),
('', 'en-GB', 'link_maxlength', '30'),
('', 'en-GB', 'load_cached_comments', '0'),
('', 'en-GB', 'max_comments_per_object', '0'),
('', 'en-GB', 'merge_time', '0'),
('', 'en-GB', 'message_banned', ''),
('', 'en-GB', 'message_locked', 'Comments are now closed for this entry'),
('', 'en-GB', 'message_policy_post', ''),
('', 'en-GB', 'message_policy_whocancomment', 'You have no rights to post comments'),
('', 'en-GB', 'notification_email', ''),
('', 'en-GB', 'notification_type', '1,2'),
('', 'en-GB', 'reports_before_unpublish', '0'),
('', 'en-GB', 'reports_per_comment', '0'),
('', 'en-GB', 'report_reason_required', '1'),
('', 'en-GB', 'show_commentlength', '1'),
('', 'en-GB', 'show_policy', '1,2'),
('', 'en-GB', 'smilies', ':D	laugh.gif\n:lol:	lol.gif\n:-)	smile.gif\n;-)	wink.gif\n8)	cool.gif\n:-|	normal.gif\n:-*	whistling.gif\n:oops:	redface.gif\n:sad:	sad.gif\n:cry:	cry.gif\n:o	surprised.gif\n:-?	confused.gif\n:-x	sick.gif\n:eek:	shocked.gif\n:zzz	sleeping.gif\n:P	tongue.gif\n:roll:	rolleyes.gif\n:sigh:	unsure.gif'),
('', 'en-GB', 'smilies_path', '/components/com_jcomments/images/smilies/'),
('', 'en-GB', 'template', 'default'),
('', 'en-GB', 'template_view', 'list'),
('', 'en-GB', 'username_maxlength', '20'),
('', 'en-GB', 'word_maxlength', '15');

DROP TABLE IF EXISTS `#__jcomments_smilies`;
CREATE TABLE IF NOT EXISTS `#__jcomments_smilies` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `code` varchar(39) NOT NULL DEFAULT '',
  `alias` varchar(39) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `ordering` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments_smilies` (`id`, `code`, `alias`, `image`, `name`, `published`, `ordering`, `checked_out`, `checked_out_time`) VALUES
(1, ':D', '', 'laugh.gif', 'Laugh', 1, 1, 0, '0000-00-00 00:00:00'),
(2, ':lol:', '', 'lol.gif', 'Lol', 1, 2, 0, '0000-00-00 00:00:00'),
(3, ':-)', '', 'smile.gif', 'Smile', 1, 3, 0, '0000-00-00 00:00:00'),
(4, ';-)', '', 'wink.gif', 'Wink', 1, 4, 0, '0000-00-00 00:00:00'),
(5, '8)', '', 'cool.gif', 'Cool', 1, 5, 0, '0000-00-00 00:00:00'),
(6, ':-|', '', 'normal.gif', 'Normal', 1, 6, 0, '0000-00-00 00:00:00'),
(7, ':-*', '', 'whistling.gif', 'Whistling', 1, 7, 0, '0000-00-00 00:00:00'),
(8, ':oops:', '', 'redface.gif', 'Redface', 1, 8, 0, '0000-00-00 00:00:00'),
(9, ':sad:', '', 'sad.gif', 'Sad', 1, 9, 0, '0000-00-00 00:00:00'),
(10, ':cry:', '', 'cry.gif', 'Cry', 1, 10, 0, '0000-00-00 00:00:00'),
(11, ':o', '', 'surprised.gif', 'Surprised', 1, 11, 0, '0000-00-00 00:00:00'),
(12, ':-?', '', 'confused.gif', 'Confused', 1, 12, 0, '0000-00-00 00:00:00'),
(13, ':-x', '', 'sick.gif', 'Sick', 1, 13, 0, '0000-00-00 00:00:00'),
(14, ':eek:', '', 'shocked.gif', 'Shocked', 1, 14, 0, '0000-00-00 00:00:00'),
(15, ':zzz', '', 'sleeping.gif', 'Sleeping', 1, 15, 0, '0000-00-00 00:00:00'),
(16, ':P', '', 'tongue.gif', 'Tongue', 1, 16, 0, '0000-00-00 00:00:00'),
(17, ':roll:', '', 'rolleyes.gif', 'Rolleyes', 1, 17, 0, '0000-00-00 00:00:00'),
(18, ':sigh:', '', 'unsure.gif', 'Unsure', 1, 18, 0, '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__jcomments_subscriptions`;
CREATE TABLE IF NOT EXISTS `#__jcomments_subscriptions` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `object_id` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `object_group` varchar(255) NOT NULL DEFAULT '',
  `lang` varchar(255) NOT NULL DEFAULT '',
  `userid` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `hash` varchar(255) NOT NULL DEFAULT '',
  `published` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `source` varchar(255) NOT NULL DEFAULT '',
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_object` (`object_id`,`object_group`),
  KEY `idx_lang` (`lang`),
  KEY `idx_source` (`source`),
  KEY `idx_hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__jcomments_version`;
CREATE TABLE IF NOT EXISTS `#__jcomments_version` (
  `version` varchar(16) NOT NULL DEFAULT '',
  `previous` varchar(16) NOT NULL DEFAULT '',
  `installed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__jcomments_version` (`version`, `previous`, `installed`, `updated`) VALUES
('2.3.0', '', '2013-05-21 10:45:49', '2013-12-14 18:25:43');

DROP TABLE IF EXISTS `#__jcomments_votes`;
CREATE TABLE IF NOT EXISTS `#__jcomments_votes` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `commentid` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `userid` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `ip` varchar(39) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `value` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_comment` (`commentid`,`userid`),
  KEY `idx_user` (`userid`,`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_attachments`;
CREATE TABLE IF NOT EXISTS `#__k2_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `itemID` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `titleAttribute` text NOT NULL,
  `hits` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `itemID` (`itemID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_categories`;
CREATE TABLE IF NOT EXISTS `#__k2_categories` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `parent` int(11) DEFAULT 0,
  `extraFieldsGroup` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `image` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT 0,
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category` (`published`,`access`,`trash`),
  KEY `parent` (`parent`),
  KEY `ordering` (`ordering`),
  KEY `published` (`published`),
  KEY `access` (`access`),
  KEY `trash` (`trash`),
  KEY `language` (`language`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_categories` (`id`, `name`, `alias`, `description`, `parent`, `extraFieldsGroup`, `published`, `access`, `ordering`, `image`, `params`, `trash`, `plugins`, `language`) VALUES
(4, 'Blog', 'blog', '', 0, 0, 1, 1, 2, '', '{\"inheritFrom\":\"0\",\"theme\":\"blog\",\"num_leading_items\":\"1\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"2\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"3\",\"num_secondary_columns\":\"3\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"0\",\"linksImgSize\":\"XLarge\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"order\",\"catPagination\":\"2\",\"catPaginationResults\":\"0\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"1\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"1\",\"catItemCategory\":\"1\",\"catItemTags\":\"0\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"0\",\"itemImageMainCredits\":\"0\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"0\",\"itemDateModified\":\"0\",\"itemHits\":\"0\",\"itemCategory\":\"1\",\"itemTags\":\"0\",\"itemAttachments\":\"0\",\"itemAttachmentsCounter\":\"0\",\"itemVideo\":\"0\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"0\",\"itemComments\":\"1\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"0\",\"itemAuthorImage\":\"0\",\"itemAuthorDescription\":\"0\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"0\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"0\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"0\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(6, 'Blank', 'blank', '', 0, 0, 1, 1, 1, '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"0\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(11, 'Sed pretium', 'sed-pretium-diam-sit-amet', '', 4, 0, 1, 1, 3, '', '{\"inheritFrom\":\"4\",\"theme\":\"blog\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"0\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"0\",\"itemHits\":\"0\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"0\",\"itemComments\":\"1\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(13, 'Etiam eu nisl', 'etiam-eu-nisl', '', 4, 0, 1, 1, 2, '', '{\"inheritFrom\":\"0\",\"theme\":\"blog\",\"num_leading_items\":\"0\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"6\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XLarge\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"0\",\"itemHits\":\"0\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(19, 'Mauris at ante', 'mauris-at-ante', '', 4, 0, 1, 1, 4, '', '{\"inheritFrom\":\"0\",\"theme\":\"blog\",\"num_leading_items\":\"0\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"9\",\"num_secondary_columns\":\"3\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XLarge\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"0\",\"itemHits\":\"0\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"0\",\"itemComments\":\"1\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"1\",\"itemRelatedImageSize\":\"Small\",\"itemRelatedIntrotext\":\"1\",\"itemRelatedFulltext\":\"1\",\"itemRelatedAuthor\":\"1\",\"itemRelatedMedia\":\"1\",\"itemRelatedImageGallery\":\"1\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(21, 'Curabitur consectetur', 'curabitur-consectetur', '', 4, 0, 1, 1, 1, '', '{\"inheritFrom\":\"0\",\"theme\":\"blog\",\"num_leading_items\":\"5\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"XLarge\",\"num_primary_items\":\"0\",\"num_primary_columns\":\"1\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"0\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"0\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XLarge\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"1\",\"catPaginationResults\":\"0\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"55\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"1\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"0\",\"itemHits\":\"0\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*'),
(23, 'System', 'system', '', 0, 0, 1, 1, 3, '', '{\"inheritFrom\":\"0\",\"theme\":\"\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"0\",\"catTitleItemCounter\":\"0\",\"catDescription\":\"0\",\"catImage\":\"0\",\"catFeedLink\":\"0\",\"catFeedIcon\":\"0\",\"subCategories\":\"0\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"0\",\"subCatTitleItemCounter\":\"0\",\"subCatDescription\":\"0\",\"subCatImage\":\"0\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"0\",\"catItemTitleLinked\":\"0\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"0\",\"catItemDateCreated\":\"0\",\"catItemRating\":\"0\",\"catItemImage\":\"0\",\"catItemIntroText\":\"0\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"0\",\"catItemTags\":\"0\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"0\",\"catItemCommentsAnchor\":\"0\",\"catItemK2Plugins\":\"0\",\"itemDateCreated\":\"0\",\"itemTitle\":\"0\",\"itemFeaturedNotice\":\"0\",\"itemAuthor\":\"0\",\"itemFontResizer\":\"0\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"0\",\"itemVideoAnchor\":\"0\",\"itemImageGalleryAnchor\":\"0\",\"itemCommentsAnchor\":\"0\",\"itemRating\":\"0\",\"itemImage\":\"0\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"0\",\"itemImageMainCredits\":\"0\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"0\",\"itemDateModified\":\"0\",\"itemHits\":\"0\",\"itemCategory\":\"0\",\"itemTags\":\"0\",\"itemAttachments\":\"0\",\"itemAttachmentsCounter\":\"0\",\"itemVideo\":\"0\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"0\",\"itemVideoCredits\":\"0\",\"itemImageGallery\":\"0\",\"itemNavigation\":\"0\",\"itemComments\":\"0\",\"itemTwitterButton\":\"0\",\"itemFacebookButton\":\"0\",\"itemGooglePlusOneButton\":\"0\",\"itemAuthorBlock\":\"0\",\"itemAuthorImage\":\"0\",\"itemAuthorDescription\":\"0\",\"itemAuthorURL\":\"0\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"0\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"0\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"0\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 1, '', '*'),
(27, '777', '777', '', 0, 0, 1, 1, 3, '', '{\"inheritFrom\":\"0\",\"theme\":\"blog\",\"num_leading_items\":\"2\",\"num_leading_columns\":\"1\",\"leadingImgSize\":\"Large\",\"num_primary_items\":\"4\",\"num_primary_columns\":\"2\",\"primaryImgSize\":\"Medium\",\"num_secondary_items\":\"4\",\"num_secondary_columns\":\"1\",\"secondaryImgSize\":\"Small\",\"num_links\":\"4\",\"num_links_columns\":\"1\",\"linksImgSize\":\"XSmall\",\"catCatalogMode\":\"0\",\"catFeaturedItems\":\"1\",\"catOrdering\":\"\",\"catPagination\":\"2\",\"catPaginationResults\":\"1\",\"catTitle\":\"1\",\"catTitleItemCounter\":\"1\",\"catDescription\":\"1\",\"catImage\":\"1\",\"catFeedLink\":\"1\",\"catFeedIcon\":\"1\",\"subCategories\":\"1\",\"subCatColumns\":\"2\",\"subCatOrdering\":\"\",\"subCatTitle\":\"1\",\"subCatTitleItemCounter\":\"1\",\"subCatDescription\":\"1\",\"subCatImage\":\"1\",\"itemImageXS\":\"\",\"itemImageS\":\"\",\"itemImageM\":\"\",\"itemImageL\":\"\",\"itemImageXL\":\"\",\"catItemTitle\":\"1\",\"catItemTitleLinked\":\"1\",\"catItemFeaturedNotice\":\"0\",\"catItemAuthor\":\"1\",\"catItemDateCreated\":\"1\",\"catItemRating\":\"0\",\"catItemImage\":\"1\",\"catItemIntroText\":\"1\",\"catItemIntroTextWordLimit\":\"\",\"catItemExtraFields\":\"0\",\"catItemHits\":\"0\",\"catItemCategory\":\"1\",\"catItemTags\":\"1\",\"catItemAttachments\":\"0\",\"catItemAttachmentsCounter\":\"0\",\"catItemVideo\":\"0\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"0\",\"catItemImageGallery\":\"0\",\"catItemDateModified\":\"0\",\"catItemReadMore\":\"1\",\"catItemCommentsAnchor\":\"1\",\"catItemK2Plugins\":\"1\",\"itemDateCreated\":\"1\",\"itemTitle\":\"1\",\"itemFeaturedNotice\":\"1\",\"itemAuthor\":\"1\",\"itemFontResizer\":\"1\",\"itemPrintButton\":\"1\",\"itemEmailButton\":\"1\",\"itemSocialButton\":\"1\",\"itemVideoAnchor\":\"1\",\"itemImageGalleryAnchor\":\"1\",\"itemCommentsAnchor\":\"1\",\"itemRating\":\"1\",\"itemImage\":\"1\",\"itemImgSize\":\"Large\",\"itemImageMainCaption\":\"1\",\"itemImageMainCredits\":\"1\",\"itemIntroText\":\"1\",\"itemFullText\":\"1\",\"itemExtraFields\":\"1\",\"itemDateModified\":\"1\",\"itemHits\":\"1\",\"itemCategory\":\"1\",\"itemTags\":\"1\",\"itemAttachments\":\"1\",\"itemAttachmentsCounter\":\"1\",\"itemVideo\":\"1\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"0\",\"itemVideoCaption\":\"1\",\"itemVideoCredits\":\"1\",\"itemImageGallery\":\"1\",\"itemNavigation\":\"1\",\"itemComments\":\"1\",\"itemTwitterButton\":\"1\",\"itemFacebookButton\":\"1\",\"itemGooglePlusOneButton\":\"1\",\"itemAuthorBlock\":\"1\",\"itemAuthorImage\":\"1\",\"itemAuthorDescription\":\"1\",\"itemAuthorURL\":\"1\",\"itemAuthorEmail\":\"0\",\"itemAuthorLatest\":\"1\",\"itemAuthorLatestLimit\":\"5\",\"itemRelated\":\"1\",\"itemRelatedLimit\":\"5\",\"itemRelatedTitle\":\"1\",\"itemRelatedCategory\":\"0\",\"itemRelatedImageSize\":\"0\",\"itemRelatedIntrotext\":\"0\",\"itemRelatedFulltext\":\"0\",\"itemRelatedAuthor\":\"0\",\"itemRelatedMedia\":\"0\",\"itemRelatedImageGallery\":\"0\",\"itemK2Plugins\":\"1\",\"catMetaDesc\":\"\",\"catMetaKey\":\"\",\"catMetaRobots\":\"\",\"catMetaAuthor\":\"\"}', 0, '', '*');

DROP TABLE IF EXISTS `#__k2_comments`;
CREATE TABLE IF NOT EXISTS `#__k2_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `itemID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `userName` varchar(255) NOT NULL,
  `commentDate` datetime NOT NULL,
  `commentText` text NOT NULL,
  `commentEmail` varchar(255) NOT NULL,
  `commentURL` varchar(255) NOT NULL,
  `published` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `itemID` (`itemID`),
  KEY `userID` (`userID`),
  KEY `published` (`published`),
  KEY `latestComments` (`published`,`commentDate`),
  KEY `countComments` (`itemID`,`published`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_extra_fields`;
CREATE TABLE IF NOT EXISTS `#__k2_extra_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `group` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `group` (`group`),
  KEY `published` (`published`),
  KEY `ordering` (`ordering`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_extra_fields_groups`;
CREATE TABLE IF NOT EXISTS `#__k2_extra_fields_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_items`;
CREATE TABLE IF NOT EXISTS `#__k2_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `catid` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT 0,
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `video` text DEFAULT NULL,
  `gallery` varchar(255) DEFAULT NULL,
  `extra_fields` text CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `extra_fields_search` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL,
  `checked_out` int(10) UNSIGNED NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `featured` smallint(6) NOT NULL DEFAULT 0,
  `featured_ordering` int(11) NOT NULL DEFAULT 0,
  `image_caption` text NOT NULL,
  `image_credits` varchar(255) NOT NULL,
  `video_caption` text NOT NULL,
  `video_credits` varchar(255) NOT NULL,
  `hits` int(10) UNSIGNED NOT NULL,
  `params` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `metakey` text NOT NULL,
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `item` (`published`,`publish_up`,`publish_down`,`trash`,`access`),
  KEY `catid` (`catid`),
  KEY `created_by` (`created_by`),
  KEY `ordering` (`ordering`),
  KEY `featured` (`featured`),
  KEY `featured_ordering` (`featured_ordering`),
  KEY `hits` (`hits`),
  KEY `created` (`created`),
  KEY `language` (`language`)
) ENGINE=MyISAM AUTO_INCREMENT=129 DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_items` (`id`, `title`, `alias`, `catid`, `published`, `introtext`, `fulltext`, `video`, `gallery`, `extra_fields`, `extra_fields_search`, `created`, `created_by`, `created_by_alias`, `checked_out`, `checked_out_time`, `modified`, `modified_by`, `publish_up`, `publish_down`, `trash`, `access`, `ordering`, `featured`, `featured_ordering`, `image_caption`, `image_credits`, `video_caption`, `video_credits`, `hits`, `params`, `metadesc`, `metadata`, `metakey`, `plugins`, `language`) VALUES
(123, 'Lorem hac habitasse platea dictumst. Ut elit nisi', 'in-hac-habitasse-platea-dictumst-ut-elit-nisi', 13, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', '<iframe width=\"560\" height=\"315\" src=\"http://www.youtube.com/embed/Qjnc0H8utks\" frameborder=\"0\" allowfullscreen></iframe>', NULL, '[]', '', '2013-05-18 19:31:26', 0, '', 0, '2014-01-28 18:34:00', '2013-07-02 20:51:27', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', 'What is Joomla? Learn about the Joomla! Application', '', 6, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(124, 'Magnum Phasellus ullamcorper blandit leo, id pharetra leo', 'phasellus-ullamcorper-blandit-leo-id-pharetra-leo', 19, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2013-05-18 19:45:24', 0, '', 0, '0000-00-00 00:00:00', '2013-07-02 20:51:07', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 5, 0, 0, '', '', '', '', 0, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(125, 'Ipsum Maecenas adipiscing, tortor ac iaculis blandit', 'maecenas-adipiscing-tortor-ac-iaculis-blandit', 19, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2013-05-18 19:45:24', 0, '', 0, '0000-00-00 00:00:00', '2013-07-02 20:50:56', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 0, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(126, 'Ullamcorper Phasellus ullamcorper blandit leo, id pharetra leo', 'phasellus-ullamcorper-blandit-leo-id-pharetra-leo', 19, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2013-05-18 20:08:34', 0, '', 0, '0000-00-00 00:00:00', '2013-07-02 20:50:53', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 1, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(127, 'Morbius venenatis accumsan turpis, in bibendum arcu', 'morbi-venenatis-accumsan-turpis-in-bibendum-arcu', 19, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2013-05-18 20:08:34', 0, '', 0, '0000-00-00 00:00:00', '2013-07-02 20:50:27', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 3, 0, 0, '', '', '', '', 7, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(128, 'Ut elit nisi, vehicula id suscipit id', 'ut-elit-nisi-vehicula-id-suscipit-id', 11, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', '<iframe width=\"560\" height=\"315\" src=\"http://www.youtube.com/embed/Qjnc0H8utks\" frameborder=\"0\" allowfullscreen></iframe>', NULL, '[]', '', '2013-05-19 08:09:03', 0, '', 0, '0000-00-00 00:00:00', '2013-07-06 19:15:32', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', 'What is Joomla? Learn about the Joomla! Application', '', 9, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"1\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(38, 'In hac habitasse platea dictumst. Ut elit nisi', 'in-hac-habitasse-platea-dictumst-ut-elit-nisi', 11, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', '<iframe width=\"660\" height=\"315\" src=\"http://www.youtube.com/embed/Qjnc0H8utks\" frameborder=\"0\" allowfullscreen></iframe>', NULL, '[]', '', '2012-01-18 08:36:20', 0, '', 0, '0000-00-00 00:00:00', '2013-07-02 20:54:28', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', 'What is Joomla? Learn about the Joomla! Application', '', 212, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"1\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(50, 'Integer faucibus hendrerit massa, ac tincidunt enim porta', 'integer-faucibus-hendrerit-massa-ac-tincidunt-enim-porta', 19, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-01-26 17:22:57', 0, '', 0, '0000-00-00 00:00:00', '2013-07-02 20:54:17', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 2, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(51, 'Morbi venenatis accumsan turpis, in bibendum arcu', 'morbi-venenatis-accumsan-turpis-in-bibendum-arcu', 13, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-01-26 17:22:57', 0, '', 0, '0000-00-00 00:00:00', '2013-07-02 20:54:15', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 62, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"0\",\"itemEmailButton\":\"0\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*');
INSERT INTO `#__k2_items` (`id`, `title`, `alias`, `catid`, `published`, `introtext`, `fulltext`, `video`, `gallery`, `extra_fields`, `extra_fields_search`, `created`, `created_by`, `created_by_alias`, `checked_out`, `checked_out_time`, `modified`, `modified_by`, `publish_up`, `publish_down`, `trash`, `access`, `ordering`, `featured`, `featured_ordering`, `image_caption`, `image_credits`, `video_caption`, `video_credits`, `hits`, `params`, `metadesc`, `metadata`, `metakey`, `plugins`, `language`) VALUES
(66, 'Donec euismod ultricies metus, ac tempus sem vulputate eget', 'donec-euismod-ultricies-metus-ac-tempus-sem-vulputate-eget', 19, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-04-23 07:17:13', 0, '', 0, '0000-00-00 00:00:00', '2013-07-02 20:53:44', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 6, 0, 0, '', '', '', '', 14, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(68, 'Maecenas adipiscing, tortor ac iaculis blandit', 'maecenas-adipiscing-tortor-ac-iaculis-blandit', 21, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-04-23 07:17:13', 0, '', 0, '2014-01-28 18:32:47', '2013-07-02 20:53:40', 0, '2012-01-18 08:36:20', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 140, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"1\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(69, 'Phasellus ullamcorper blandit leo, id pharetra leo', 'phasellus-ullamcorper-blandit-leo-id-pharetra-leo', 21, 1, '<p><strong>In hac habitasse platea dictumst.</strong> Ut elit nisi, vehicula id suscipit id, volutpat eget enim. Integer faucibus hendrerit massa, ac tincidunt enim porta at. Nulla ultricies laoreet enim, ac malesuada sem sodales sit amet. Praesent in molestie enim. Morbi venenatis accumsan turpis, in bibendum arcu iaculis eget. <a href=\"#\">Duis bibendum convallis </a>turpis eget congue. Donec euismod ultricies metus, ac tempus sem vulputate eget. Donec ut rutrum magna.</p>\r\n', '\r\n<p><strong>Maecenas adipiscing, tortor </strong>ac iaculis blandit, eros est porta nulla, sit amet lobortis sem quam sed ipsum. <a href=\"#\">Curabitur bibendum urna ligula</a>, a ornare lectus. In et urna arcu, id tincidunt arcu. Pellentesque faucibus augue a nibh fringilla eget gravida augue iaculis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula malesuada facilisis. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque tellus augue, cursus et tincidunt et, lacinia ut eros. Aliquam hendrerit varius felis a condimentum.</p>\r\n<p><strong>In hac habitasse platea dictumst.</strong> Donec eu elit orci. Duis diam mauris, dignissim a consequat eget, tincidunt eget mauris. Integer vehicula, odio sit amet elementum mattis, felis sem tincidunt tellus, quis vehicula est urna ac odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus vel augue <a href=\"#\">ultrices arcu dictum ultrices</a>. Sed cursus laoreet odio auctor volutpat. Suspendisse pulvinar eros ut massa facilisis fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Etiam auctor nulla id erat euismod luctus. Nunc ligula orci, feugiat sit amet sagittis vel, faucibus et urna.</p>\r\n<p><strong>Cras aliquam felis quis ipsum pellentesque ultrices.</strong> Vivamus sed urna sed lorem blandit interdum sit amet sed nibh. Pellentesque dictum rhoncus velit, sit amet condimentum mauris varius vitae. Integer volutpat velit vel urna gravida nec malesuada sapien convallis. Proin euismod laoreet sem. Phasellus ullamcorper blandit leo, id pharetra leo tempus et. Curabitur interdum velit non diam malesuada ultrices nec at ligula. Praesent pellentesque lacus sed arcu cursus eu consectetur magna adipiscing. Duis id turpis quam. Quisque ullamcorper condimentum urna quis cursus. <a href=\"#\">Aliquam scelerisque</a> odio ac purus euismod auctor. Maecenas nisi mi, elementum ut dapibus at, egestas eget ipsum. Integer quis arcu vitae elit cursus posuere vitae quis purus. Quisque nibh justo, egestas eget feugiat sit amet, mollis in elit.</p>', NULL, NULL, '[]', '', '2012-04-23 07:17:13', 0, '', 0, '2014-01-28 18:32:35', '2013-07-02 20:51:29', 0, '2012-01-18 08:36:00', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 140, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"XLarge\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*'),
(70, '404 Page Not Found', '404-page-not-found', 23, 1, '<div class=\"img404\"><img src=\"images/404page.png\" border=\"0\" alt=\"404 Page not found\" /></div>\r\n<div class=\"text404\">\r\n<h1><strong>Sorry!</strong></h1>\r\n<h2>404 Page Not Found</h2>\r\n<p>The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</p>\r\n<p>Please try using our search box below to look for information on the internet</p>\r\n{loadposition error404}</div>', '', NULL, NULL, '[]', '', '2012-05-31 11:37:17', 0, '', 0, '0000-00-00 00:00:00', '2013-05-16 19:55:35', 0, '2012-05-31 11:37:17', '0000-00-00 00:00:00', 1, 1, 1, 0, 0, '', '', '', '', 588, '{\"catItemTitle\":\"\",\"catItemTitleLinked\":\"\",\"catItemFeaturedNotice\":\"\",\"catItemAuthor\":\"\",\"catItemDateCreated\":\"\",\"catItemRating\":\"\",\"catItemImage\":\"\",\"catItemIntroText\":\"\",\"catItemExtraFields\":\"\",\"catItemHits\":\"\",\"catItemCategory\":\"\",\"catItemTags\":\"\",\"catItemAttachments\":\"\",\"catItemAttachmentsCounter\":\"\",\"catItemVideo\":\"\",\"catItemVideoWidth\":\"\",\"catItemVideoHeight\":\"\",\"catItemAudioWidth\":\"\",\"catItemAudioHeight\":\"\",\"catItemVideoAutoPlay\":\"\",\"catItemImageGallery\":\"\",\"catItemDateModified\":\"\",\"catItemReadMore\":\"\",\"catItemCommentsAnchor\":\"\",\"catItemK2Plugins\":\"\",\"itemDateCreated\":\"\",\"itemTitle\":\"\",\"itemFeaturedNotice\":\"\",\"itemAuthor\":\"\",\"itemFontResizer\":\"\",\"itemPrintButton\":\"\",\"itemEmailButton\":\"\",\"itemSocialButton\":\"\",\"itemVideoAnchor\":\"\",\"itemImageGalleryAnchor\":\"\",\"itemCommentsAnchor\":\"\",\"itemRating\":\"\",\"itemImage\":\"\",\"itemImgSize\":\"\",\"itemImageMainCaption\":\"\",\"itemImageMainCredits\":\"\",\"itemIntroText\":\"\",\"itemFullText\":\"\",\"itemExtraFields\":\"\",\"itemDateModified\":\"\",\"itemHits\":\"\",\"itemCategory\":\"\",\"itemTags\":\"\",\"itemAttachments\":\"\",\"itemAttachmentsCounter\":\"\",\"itemVideo\":\"\",\"itemVideoWidth\":\"\",\"itemVideoHeight\":\"\",\"itemAudioWidth\":\"\",\"itemAudioHeight\":\"\",\"itemVideoAutoPlay\":\"\",\"itemVideoCaption\":\"\",\"itemVideoCredits\":\"\",\"itemImageGallery\":\"\",\"itemNavigation\":\"\",\"itemComments\":\"\",\"itemTwitterButton\":\"\",\"itemFacebookButton\":\"\",\"itemGooglePlusOneButton\":\"\",\"itemAuthorBlock\":\"\",\"itemAuthorImage\":\"\",\"itemAuthorDescription\":\"\",\"itemAuthorURL\":\"\",\"itemAuthorEmail\":\"\",\"itemAuthorLatest\":\"\",\"itemAuthorLatestLimit\":\"\",\"itemRelated\":\"\",\"itemRelatedLimit\":\"\",\"itemRelatedTitle\":\"\",\"itemRelatedCategory\":\"\",\"itemRelatedImageSize\":\"\",\"itemRelatedIntrotext\":\"\",\"itemRelatedFulltext\":\"\",\"itemRelatedAuthor\":\"\",\"itemRelatedMedia\":\"\",\"itemRelatedImageGallery\":\"\",\"itemK2Plugins\":\"\"}', '', 'robots=\nauthor=', '', '', '*');

DROP TABLE IF EXISTS `#__k2_log`;
CREATE TABLE IF NOT EXISTS `#__k2_log` (
  `status` int(11) NOT NULL,
  `response` text NOT NULL,
  `timestamp` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_rating`;
CREATE TABLE IF NOT EXISTS `#__k2_rating` (
  `itemID` int(11) NOT NULL DEFAULT 0,
  `rating_sum` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `rating_count` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`itemID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_tags`;
CREATE TABLE IF NOT EXISTS `#__k2_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `published` (`published`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_tags_xref`;
CREATE TABLE IF NOT EXISTS `#__k2_tags_xref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tagID` int(11) NOT NULL,
  `itemID` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tagID` (`tagID`),
  KEY `itemID` (`itemID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_users`;
CREATE TABLE IF NOT EXISTS `#__k2_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userID` int(11) NOT NULL,
  `userName` varchar(255) DEFAULT NULL,
  `gender` enum('m','f') NOT NULL DEFAULT 'm',
  `description` text NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `group` int(11) NOT NULL DEFAULT 0,
  `plugins` text NOT NULL,
  `ip` varchar(15) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userID` (`userID`),
  KEY `group` (`group`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_users` (`id`, `userID`, `userName`, `gender`, `description`, `image`, `url`, `group`, `plugins`, `ip`, `hostname`, `notes`) VALUES
(51, 639, 'Super User', 'm', '', NULL, NULL, 1, '', '127.0.0.1', 'doctor', '');

DROP TABLE IF EXISTS `#__k2_user_groups`;
CREATE TABLE IF NOT EXISTS `#__k2_user_groups` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `permissions` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `#__k2_user_groups` (`id`, `name`, `permissions`) VALUES
(1, 'Registered', '{\"comment\":\"1\",\"frontEdit\":\"0\",\"add\":\"0\",\"editOwn\":\"0\",\"editAll\":\"0\",\"publish\":\"0\",\"inheritance\":0,\"categories\":\"all\"}'),
(2, 'Site Owner', '{\"comment\":\"1\",\"frontEdit\":\"1\",\"add\":\"1\",\"editOwn\":\"1\",\"editAll\":\"1\",\"publish\":\"1\",\"inheritance\":1,\"categories\":\"all\"}'),
(4, 'Admin', '{\"comment\":\"1\",\"frontEdit\":\"1\",\"add\":\"1\",\"editOwn\":\"1\",\"editAll\":\"1\",\"publish\":\"1\",\"editPublished\":\"1\",\"inheritance\":\"1\",\"categories\":\"all\"}');

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE IF NOT EXISTS `#__languages` (
  `lang_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lang_code` char(7) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `title` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT 0,
  `access` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__languages` (`lang_id`, `asset_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 0, 'en-GB', 'English (UK)', 'English', 'en', 'en', '', '', '', '', 1, 1, 1),
(2, 0, 'it-IT', 'Italian (IT) ', 'Italian', 'it', 'it', '', '', '', '', 1, 1, 0),
(3, 0, 'fr-FR', 'French (FR) ', 'French', 'fr', 'fr', '', '', '', '', 1, 1, 0),
(4, 0, 'de-DE', 'German (DE) ', 'German', 'de', 'de', '', '', '', '', 1, 1, 0),
(5, 0, 'ru-RU', 'Russian (RU)', 'Russian', 'ru', 'ru', '', '', '', '', 1, 1, 0),
(6, 0, 'he-IL', 'Hebrew', 'Hebrew', 'he', 'he_il', '', '', '', '', 1, 1, 0);

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE IF NOT EXISTS `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'The published state of the menu link.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT 1 COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'The relative level in the tree.',
  `component_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'The click behaviour of the link.',
  `access` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `params` mediumtext COLLATE utf8_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `home` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=InnoDB AUTO_INCREMENT=1566 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 295, 0, '*', 0),
(2, 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 1, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 77, 86, 0, '*', 1),
(3, 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 78, 79, 0, '*', 1),
(4, 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 1, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 80, 81, 0, '*', 1),
(5, 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 82, 83, 0, '*', 1),
(6, 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 1, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 84, 85, 0, '*', 1),
(7, 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 121, 126, 0, '*', 1),
(8, 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 1, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 122, 123, 0, '*', 1),
(9, 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 1, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 124, 125, 0, '*', 1),
(10, 'main', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 1, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 127, 130, 0, '*', 1),
(11, 'main', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 1, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 128, 129, 0, '*', 1),
(13, 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 131, 136, 0, '*', 1),
(14, 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 1, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 132, 133, 0, '*', 1),
(15, 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 1, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 134, 135, 0, '*', 1),
(16, 'main', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 1, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 143, 144, 0, '*', 1),
(17, 'main', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 1, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 141, 142, 0, '*', 1),
(21, 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 1, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 137, 138, 0, '*', 1),
(22, 'main', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 0, 'class:joomlaupdate', 0, '', 139, 140, 0, '*', 1),
(435, 'mainmenu', 'Home', 'homepage', '', 'homepage', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"num_leading_articles\":\"1\",\"num_intro_articles\":\"3\",\"num_columns\":\"3\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 19, 20, 1, '*', 0),
(502, 'main-menu-en', 'Home', 'homepage', '', 'homepage', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 145, 146, 1, 'en-GB', 0),
(503, 'menu-principal-fr', 'Home', 'homepage', '', 'homepage', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 147, 148, 1, 'fr-FR', 0),
(504, 'menu-principale-it', 'Home', 'homepage', '', 'homepage', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 149, 150, 1, 'it-IT', 0),
(505, 'hauptmenue-de', 'Home', 'homepage', '', 'homepage', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 151, 152, 1, 'de-DE', 0),
(506, 'nav-menu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"\",\"num_intro_articles\":\"\",\"num_columns\":\"\",\"num_links\":\"\",\"multi_column_order\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"mega_showtitle\":\"1\",\"mega_desc\":\"\",\"mega_cols\":\"1\",\"mega_group\":\"0\",\"mega_width\":\"\",\"mega_colw\":\"\",\"mega_colxw\":\"\",\"mega_class\":\"\",\"mega_subcontent\":\"0\",\"mega_subcontent_mod_modules\":\"0\",\"mega_subcontent_pos_positions\":\"0\"}', 3, 14, 0, '*', 0),
(507, 'nav-menu', 'Right Sidebar', 'home-with-right-sidebar', '', 'home/home-with-right-sidebar', 'index.php?option=com_content&view=featured', 'component', 1, 506, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 124, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home With Right Sidebar\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 4, 5, 0, '*', 0),
(508, 'top-menu', 'My Account', 'my-account', 'my-account', 'my-account', 'index.php?option=com_virtuemart&view=user&layout=edit', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"My Account\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 155, 156, 0, '*', 0),
(509, 'top-menu', 'Orders list', 'orders-list', 'Orders list', 'orders-list', 'index.php?option=com_virtuemart&view=orders&layout=list', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Orders list\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 157, 158, 0, '*', 0),
(510, 'top-menu', 'Wishlist', 'wishlist', 'Wishlist', 'wishlist', 'index.php?option=com_wishlists&view=wishlists', 'component', 1, 1, 1, 10170, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Wishlist\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 159, 160, 0, '*', 0),
(511, 'top-menu', 'Checkout', 'checkout', 'Checkout', 'checkout', 'index.php?option=com_virtuemart&view=cart', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Checkout\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 163, 164, 0, '*', 0),
(512, 'the-service', 'My account', 'myaccount', 'maccount', 'myaccount', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"aliasoptions\":\"508\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', 165, 166, 0, '*', 0),
(513, 'the-service', 'Order history', 'order-history', 'Order history', 'order-history', 'index.php?option=com_virtuemart&view=orders&layout=list', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Order history\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 167, 168, 0, '*', 0),
(514, 'the-service', 'Vendor contact', 'vendor-contact', 'Vendor contact', 'vendor-contact', 'index.php?option=com_virtuemart&view=vendor&layout=contact&virtuemart_vendor_id=1', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Vendor contact\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 169, 170, 0, '*', 0),
(515, 'the-service', 'Shop page', 'front-page', 'Front page', 'front-page', 'index.php?option=com_virtuemart&view=virtuemart', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Shop page\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 171, 172, 0, '*', 0),
(516, 'the-service', 'Virtuemart categories', 'virtuemart-categories', 'Virtuemart categories', 'virtuemart-categories', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=0', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Virtuemart categories\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"categories\"}', 173, 174, 0, '*', 0),
(517, 'information', 'About us', 'about-us', 'About us', 'about-us', 'index.php?option=com_virtuemart&view=vendor&layout=details&virtuemart_vendor_id=1', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"About us\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 175, 176, 0, '*', 0),
(518, 'information', 'New collection', 'new-collection', 'New collection', 'new-collection', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=0', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"New collection\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 177, 178, 0, '*', 0),
(519, 'information', 'Best sellers		', 'best-sellers', 'Best sellers', 'best-sellers', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=0', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Best sellers\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 179, 180, 0, '*', 0),
(520, 'information', 'Manufacturers', 'manufacturers', 'Manufacturers', 'manufacturers', 'index.php?option=com_virtuemart&view=manufacturer', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Manufacturers\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 181, 182, 0, '*', 0),
(521, 'information', 'Privacy policy', 'privacy-policy', 'Privacy policy', 'privacy-policy', 'index.php?option=com_k2&view=item&layout=item&id=127', 'component', 1, 1, 1, 10039, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Privacy policy\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 183, 184, 0, '*', 0),
(522, 'information', 'Terms & Condition', 'terms-condition', 'Terms & Condition', 'terms-condition', 'index.php?option=com_virtuemart&view=vendor&layout=tos&virtuemart_vendor_id=1', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Terms & Condition\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 185, 186, 0, '*', 0),
(523, 'nav-menu', 'Left Sidebar', 'home-with-left-sidebar', '', 'home/home-with-left-sidebar', 'index.php?option=com_content&view=featured', 'component', 1, 506, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 125, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home With Left Sidebar\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 6, 7, 0, '*', 0),
(524, 'nav-menu', 'Full width', 'home-full-width', '', 'home/home-full-width', 'index.php?option=com_content&view=featured', 'component', 1, 506, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home Full Width\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 8, 9, 0, '*', 0),
(525, 'nav-menu', 'Sliders', 'sliders', '', 'sliders', '', 'separator', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 124, '{\"menu_image\":\"\",\"menu_text\":1}', 21, 24, 0, '*', 0),
(526, 'nav-menu', 'Revolutions slider', 'revolutions-slider', '', 'sliders/revolutions-slider', 'index.php?option=com_content&view=featured', 'component', 1, 525, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 124, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Revolutions slider\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 22, 23, 0, '*', 0),
(528, 'nav-menu', 'Women', 'women', 'Women', 'women', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=1', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Women\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 25, 72, 0, '*', 0),
(529, 'nav-menu', 'Men', 'men', 'Men', 'men', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=2', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Men\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 87, 100, 0, '*', 0),
(561, 'nav-menu', 'Blog', 'blog', 'Blog', 'blog', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=4', 'component', 1, 1, 1, 10039, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"categories\":[\"4\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Blog\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 101, 108, 0, '*', 0),
(562, 'nav-menu', 'Categories (1)', 'categories-1', 'Categories (1)', 'blog/categories-1', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=21', 'component', 1, 561, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"categories\":[\"21\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Categories (1)\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 102, 103, 0, '*', 0),
(563, 'nav-menu', 'Categories (2)', 'categories-2', 'Categories2', 'blog/categories-2', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=13', 'component', 1, 561, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"categories\":[\"13\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Categories (2)\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 104, 105, 0, '*', 0),
(564, 'nav-menu', 'Categories (3)', 'categories-3', 'Categories-3', 'blog/categories-3', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=19', 'component', 1, 561, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"categories\":[\"19\"],\"singleCatOrdering\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Categories (3)\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 106, 107, 0, '*', 0),
(565, 'nav-menu', 'Contacts', 'contacts', 'Contacts', 'contacts', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"presentation_style\":\"plain\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"0\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Contact Us\",\"show_page_heading\":0,\"page_heading\":\"Contact Us\",\"pageclass_sfx\":\"Contact\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 117, 120, 0, '*', 0),
(567, 'search-param', 'Search', 'vm-search', 'vm-search', 'vm-search', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=0', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"VM-search\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"search\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 187, 188, 0, '*', 0),
(570, 'nav-menu', 'Shop', 'shop', 'Shop', 'shop', 'index.php?option=com_virtuemart&view=virtuemart', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Shop\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 109, 116, 0, '*', 0),
(576, 'system-menu', 'Edit User Profile', 'edit-user-profile', 'Edit User Profile', 'edit-user-profile', 'index.php?option=com_users&view=profile&layout=edit', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Edit User Profile\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 17, 18, 0, '*', 0),
(577, 'system-menu', 'Login Form', 'login-form', 'Login Form', 'login-form', 'index.php?option=com_users&view=login', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"login_redirect_url\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"logout_redirect_url\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Login Form\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 1, 2, 0, '*', 0),
(578, 'system-menu', 'User Profile', 'user-profile', 'User Profile', 'user-profile', 'index.php?option=com_users&view=profile', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"User Profile\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 15, 16, 0, '*', 0),
(579, 'system-menu', 'Registration Form', 'registration-form', 'Registration Form', 'registration-form', 'index.php?option=com_users&view=registration', 'component', 1, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Registration Form\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 189, 190, 0, '*', 0),
(580, 'system-menu', 'Compare Products', 'compare-products', 'Compare Products', 'compare-products', 'index.php?option=com_comparelist&view=comparelist', 'component', 1, 1, 1, 10168, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Compare Products\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 191, 192, 0, '*', 0),
(613, 'information', 'Edit User Profile2', 'edit-user-profile2', '', 'edit-user-profile2', 'index.php?option=com_users&view=profile&layout=edit', 'component', 0, 1, 1, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Edit User Profile\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 193, 194, 0, '*', 0),
(618, 'nav-menu', 'Template Blue', 'template-blue', '', 'shop/template-blue', 'index.php?option=com_content&view=featured', 'component', 1, 570, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 128, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Template Blue\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 110, 111, 0, '*', 0),
(619, 'nav-menu', 'Template Green', 'template-green', '', 'shop/template-green', 'index.php?option=com_content&view=featured', 'component', 1, 570, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 129, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Template Green\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 112, 113, 0, '*', 0),
(620, 'nav-menu', 'Template Orange', 'template-orange', '', 'shop/template-orange', 'index.php?option=com_content&view=featured', 'component', 1, 570, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 130, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Template Orange\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 114, 115, 0, '*', 0),
(624, 'nav-menu', 'Home products izotop', 'products-izotop', '', 'home/products-izotop', 'index.php?option=com_content&view=featured', 'component', 1, 506, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Products izotop\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 10, 11, 0, '*', 0),
(634, 'nav-menu', 'Home products tabs', 'products-tabs', '', 'home/products-tabs', 'index.php?option=com_content&view=featured', 'component', 1, 506, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 136, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Products tabs\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 12, 13, 0, '*', 0),
(639, 'system-menu', 'Tags-search', 'tags-search', 'Tags-search', 'tags-search', 'index.php?option=com_cooltags&view=productslist', 'component', 1, 1, 1, 10242, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Tags-search\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 195, 196, 0, '*', 0),
(640, 'ru', 'Home', 'homepage', '', 'homepage', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 197, 198, 1, 'ru-RU', 0),
(643, 'system-menu', 'store', 'store', '', 'store', 'index.php?option=com_virtuemart&view=virtuemart', 'component', 0, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Store\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 199, 200, 0, '*', 0),
(647, 'nav-menu', 'Sitemaps', 'sitemaps', '', 'contacts/sitemaps', 'index.php?option=com_xmap&view=html&id=0', 'component', 1, 565, 2, 10149, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"include_css\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Sitemaps\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 118, 119, 0, '*', 0),
(648, 'virtuemart-categories', 'Categories', 'categories', '', 'categories', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=0', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Categories\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"categories\"}', 201, 202, 0, '*', 0),
(649, 'the-service', 'Search Results', 'search-results', 'search-results', 'search-results', 'index.php?option=com_search&view=search&searchword=', 'component', 1, 1, 1, 19, 0, '2013-09-13 15:03:50', 0, 1, '', 0, '{\"search_areas\":\"\",\"show_date\":\"\",\"searchphrase\":\"0\",\"ordering\":\"newest\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Search Results\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 203, 204, 0, '*', 0),
(694, 'top-menu', 'Wishlist_it', 'wishlist-it', 'Wishlist', 'wishlist-it', 'index.php?option=com_wishlists&view=wishlists', 'component', 1, 1, 1, 10170, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Wishlist\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 161, 162, 0, 'it-IT', 0),
(853, 'main', 'COM_JCOMMENTS_COMMENTS', 'com-jcomments-comments', '', 'com-jcomments/com-jcomments-comments', 'index.php?option=com_jcomments&view=comments', 'component', 1, 852, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-comments', 0, '', 206, 207, 0, '', 1),
(854, 'main', 'COM_JCOMMENTS_SETTINGS', 'com-jcomments-settings', '', 'com-jcomments/com-jcomments-settings', 'index.php?option=com_jcomments&view=settings', 'component', 1, 852, 2, 10072, 0, '0000-00-00 00:00:00', 0, 1, 'class:jcomments-settings', 0, '', 208, 209, 0, '', 1),
(873, 'main', 'COM_XMAP_TITLE', 'com-xmap-title', '', 'com-xmap-title', 'index.php?option=com_xmap', 'component', 1, 1, 1, 10149, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_xmap/images/xmap-favicon.png', 0, '', 205, 206, 0, '', 1),
(875, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 1, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 73, 74, 0, '', 1),
(876, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 1, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 75, 76, 0, '*', 1),
(887, 'main', 'COM_AKEEBA', 'com-akeeba', '', 'com-akeeba', 'index.php?option=com_akeeba', 'component', 1, 1, 1, 10159, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_akeeba/icons/akeeba-16.png', 0, '', 207, 208, 0, '', 1),
(1002, 'nav-menu', 'Dresses', 'dresses', '', 'women/dresses', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=4', 'component', 1, 528, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Dresses\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 26, 41, 0, '*', 0),
(1003, 'nav-menu', 'Evening Dresses', 'evening-dresses', '', 'women/dresses/evening-dresses', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=7', 'component', 1, 1002, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Evening Dresses\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 27, 28, 0, '*', 0),
(1004, 'nav-menu', 'Casual Dresses', 'casual-dresses', '', 'women/dresses/casual-dresses', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=8', 'component', 1, 1002, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Casual Dresses\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 29, 30, 0, '*', 0),
(1005, 'nav-menu', 'Party Dresses', 'party-dresses', '', 'women/dresses/party-dresses', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=9', 'component', 1, 1002, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Party Dresses\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 31, 32, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1006, 'nav-menu', 'Maxi Dresses', 'maxi-dresses', '', 'women/dresses/maxi-dresses', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=10', 'component', 1, 1002, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Maxi Dresses\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 33, 34, 0, '*', 0),
(1007, 'nav-menu', 'Midi Dresses', 'midi-dresses', '', 'women/dresses/midi-dresses', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=11', 'component', 1, 1002, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Midi Dresses\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 35, 36, 0, '*', 0),
(1008, 'nav-menu', 'Strapless Dresses', 'strapless-dresses', '', 'women/dresses/strapless-dresses', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=12', 'component', 1, 1002, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Strapless Dresses\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 37, 38, 0, '*', 0),
(1009, 'nav-menu', 'Day Dresses', 'day-dresses', '', 'women/dresses/day-dresses', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=13', 'component', 1, 1002, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Day Dresses\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 39, 40, 0, '*', 0),
(1010, 'nav-menu', 'Accessories', 'women-accessories', '', 'women/women-accessories', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=5', 'component', 1, 528, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Accessories\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 42, 57, 0, '*', 0),
(1011, 'nav-menu', 'Bags and Purces', 'bags-and-purces', '', 'women/women-accessories/bags-and-purces', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=14', 'component', 1, 1010, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Bags and Purces\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 43, 44, 0, '*', 0),
(1012, 'nav-menu', 'Belts', 'belts', '', 'women/women-accessories/belts', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=15', 'component', 1, 1010, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Belts\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 45, 46, 0, '*', 0),
(1013, 'nav-menu', 'Scarves', 'scarves', '', 'women/women-accessories/scarves', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=16', 'component', 1, 1010, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Scarves\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 47, 48, 0, '*', 0),
(1014, 'nav-menu', 'Gloves', 'gloves', '', 'women/women-accessories/gloves', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=17', 'component', 1, 1010, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Gloves\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 49, 50, 0, '*', 0),
(1015, 'nav-menu', 'Jewellery', 'jewellery', '', 'women/women-accessories/jewellery', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=18', 'component', 1, 1010, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Jewellery\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 51, 52, 0, '*', 0),
(1016, 'nav-menu', 'Sunglasses', 'sunglasses', '', 'women/women-accessories/sunglasses', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=19', 'component', 1, 1010, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Sunglasses\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 53, 54, 0, '*', 0),
(1017, 'nav-menu', 'Hair Accessories', 'hair-accessories', '', 'women/women-accessories/hair-accessories', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=20', 'component', 1, 1010, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Hair Accessories\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 55, 56, 0, '*', 0),
(1018, 'nav-menu', 'Tops', 'tops', '', 'women/tops', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=6', 'component', 1, 528, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Tops\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 58, 71, 0, '*', 0),
(1019, 'nav-menu', 'Evening Tops', 'evening-tops', '', 'women/tops/evening-tops', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=21', 'component', 1, 1018, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Evening Tops\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 59, 60, 0, '*', 0),
(1020, 'nav-menu', 'Long Sleeved', 'long-sleeved', '', 'women/tops/long-sleeved', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=22', 'component', 1, 1018, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Long Sleeved\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 61, 62, 0, '*', 0),
(1021, 'nav-menu', 'Short Sleeved', 'short-sleeved', '', 'women/tops/short-sleeved', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=23', 'component', 1, 1018, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Short Sleeved\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 63, 64, 0, '*', 0),
(1022, 'nav-menu', 'Sleeveless', 'sleeveless', '', 'women/tops/sleeveless', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=24', 'component', 1, 1018, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Sleeveless\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 65, 66, 0, '*', 0),
(1023, 'nav-menu', 'Tanks', 'tanks', '', 'women/tops/tanks', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=25', 'component', 1, 1018, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Tanks\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 67, 68, 0, '*', 0),
(1024, 'nav-menu', 'Tunics', 'tunics', '', 'women/tops/tunics', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=26', 'component', 1, 1018, 3, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Tunics\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 69, 70, 0, '*', 0),
(1025, 'nav-menu', 'Accessories', 'men-accessories', '', 'men/men-accessories', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=27', 'component', 1, 529, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Accessories\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 88, 89, 0, '*', 0),
(1026, 'nav-menu', 'Blazers', 'blazers', '', 'men/blazers', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=28', 'component', 1, 529, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Blazers\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 90, 91, 0, '*', 0),
(1027, 'nav-menu', 'Hoodies', 'hoodies', '', 'men/hoodies', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=29', 'component', 1, 529, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Hoodies\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 92, 93, 0, '*', 0),
(1028, 'nav-menu', 'Jeans', 'jeans', '', 'men/jeans', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=30', 'component', 1, 529, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Jeans\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 94, 95, 0, '*', 0),
(1029, 'nav-menu', 'Shirts', 'shirts', '', 'men/shirts', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=31', 'component', 1, 529, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Shirts\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 96, 97, 0, '*', 0),
(1030, 'nav-menu', 'Shoes', 'shoes', '', 'men/shoes', 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=32', 'component', 1, 529, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Shoes\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0,\"categorylayout\":\"0\"}', 98, 99, 0, '*', 0),
(1060, 'main-menu-he', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 127, '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"0\",\"num_columns\":\"0\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_vote\":\"\",\"show_readmore\":\"1\",\"show_readmore_title\":\"\",\"show_icons\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"0\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Home\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', 153, 154, 1, 'he-IL', 0),
(1101, 'main', 'COM_COOLTAGS', 'com-cooltags', '', 'com-cooltags', 'index.php?option=com_cooltags', 'component', 1, 1, 1, 10242, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_cooltags/assets/images/s_com_cooltags.png', 0, '', 209, 212, 0, '', 1),
(1102, 'main', 'COM_COOLTAGS_LEGACYSWITCH', 'com-cooltags-legacyswitch', '', 'com-cooltags/com-cooltags-legacyswitch', 'index.php?option=com_cooltags&view=legacyswitch', 'component', 1, 1101, 2, 10242, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 210, 211, 0, '', 1),
(1280, 'main', 'com_weblinks', 'com-weblinks', '', 'com-weblinks', 'index.php?option=com_weblinks', 'component', 1, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 1, 'class:weblinks', 0, '{}', 213, 218, 0, '', 1),
(1281, 'main', 'com_weblinks_links', 'com-weblinks-links', '', 'com-weblinks/com-weblinks-links', 'index.php?option=com_weblinks', 'component', 1, 1280, 2, 21, 0, '0000-00-00 00:00:00', 0, 1, 'class:weblinks', 0, '{}', 214, 215, 0, '', 1),
(1282, 'main', 'com_weblinks_categories', 'com-weblinks-categories', '', 'com-weblinks/com-weblinks-categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', 1, 1280, 2, 21, 0, '0000-00-00 00:00:00', 0, 1, 'class:weblinks-cat', 0, '{}', 216, 217, 0, '', 1),
(1341, 'main', 'com_associations', 'multilingual-associations', '', 'multilingual-associations', 'index.php?option=com_associations', 'component', 1, 1, 1, 34, 0, '0000-00-00 00:00:00', 0, 1, 'class:associations', 0, '{}', 219, 220, 0, '*', 1),
(1511, 'main', 'COM_K2', 'com-k2', '', 'com-k2', 'index.php?option=com_k2', 'component', 1, 1, 1, 10039, 0, '0000-00-00 00:00:00', 0, 1, '../media/k2/assets/images/backend/k2_logo_16x16.png', 0, '{}', 221, 242, 0, '', 1),
(1512, 'main', 'K2_ITEMS', 'k2-items', '', 'com-k2/k2-items', 'index.php?option=com_k2&view=items', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 222, 223, 0, '', 1),
(1513, 'main', 'K2_CATEGORIES', 'k2-categories', '', 'com-k2/k2-categories', 'index.php?option=com_k2&view=categories', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 224, 225, 0, '', 1),
(1514, 'main', 'K2_TAGS', 'k2-tags', '', 'com-k2/k2-tags', 'index.php?option=com_k2&view=tags', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 226, 227, 0, '', 1),
(1515, 'main', 'K2_COMMENTS', 'k2-comments', '', 'com-k2/k2-comments', 'index.php?option=com_k2&view=comments', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 228, 229, 0, '', 1),
(1516, 'main', 'K2_USERS', 'k2-users', '', 'com-k2/k2-users', 'index.php?option=com_k2&view=users', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 230, 231, 0, '', 1),
(1517, 'main', 'K2_USER_GROUPS', 'k2-user-groups', '', 'com-k2/k2-user-groups', 'index.php?option=com_k2&view=usergroups', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 232, 233, 0, '', 1),
(1518, 'main', 'K2_EXTRA_FIELDS', 'k2-extra-fields', '', 'com-k2/k2-extra-fields', 'index.php?option=com_k2&view=extrafields', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 234, 235, 0, '', 1),
(1519, 'main', 'K2_EXTRA_FIELD_GROUPS', 'k2-extra-field-groups', '', 'com-k2/k2-extra-field-groups', 'index.php?option=com_k2&view=extrafieldsgroups', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 236, 237, 0, '', 1),
(1520, 'main', 'K2_MEDIA_MANAGER', 'k2-media-manager', '', 'com-k2/k2-media-manager', 'index.php?option=com_k2&view=media', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 238, 239, 0, '', 1),
(1521, 'main', 'K2_INFORMATION', 'k2-information', '', 'com-k2/k2-information', 'index.php?option=com_k2&view=info', 'component', 1, 1511, 2, 10039, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 240, 241, 0, '', 1),
(1522, 'main', 'AcyMailing', 'acymailing', '', 'acymailing', 'index.php?option=com_acymailing', 'component', 1, 1, 1, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acymailing.png', 0, '{}', 243, 258, 0, '', 1),
(1523, 'main', 'Users', 'users', '', 'acymailing/users', 'index.php?option=com_acymailing&ctrl=subscriber', 'component', 1, 1522, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-users.png', 0, '{}', 244, 245, 0, '', 1),
(1524, 'main', 'Lists', 'lists', '', 'acymailing/lists', 'index.php?option=com_acymailing&ctrl=list', 'component', 1, 1522, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acylist.png', 0, '{}', 246, 247, 0, '', 1),
(1525, 'main', 'Newsletters', 'newsletters', '', 'acymailing/newsletters', 'index.php?option=com_acymailing&ctrl=newsletter', 'component', 1, 1522, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-newsletter.png', 0, '{}', 248, 249, 0, '', 1),
(1526, 'main', 'Templates', 'templates', '', 'acymailing/templates', 'index.php?option=com_acymailing&ctrl=template', 'component', 1, 1522, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acytemplate.png', 0, '{}', 250, 251, 0, '', 1),
(1527, 'main', 'Queue', 'queue', '', 'acymailing/queue', 'index.php?option=com_acymailing&ctrl=queue', 'component', 1, 1522, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-process.png', 0, '{}', 252, 253, 0, '', 1),
(1528, 'main', 'Statistics', 'statistics', '', 'acymailing/statistics', 'index.php?option=com_acymailing&ctrl=stats', 'component', 1, 1522, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-stats.png', 0, '{}', 254, 255, 0, '', 1),
(1529, 'main', 'Configuration', 'configuration', '', 'acymailing/configuration', 'index.php?option=com_acymailing&ctrl=cpanel', 'component', 1, 1522, 2, 10204, 0, '0000-00-00 00:00:00', 0, 1, '../media/com_acymailing/images/icons/icon-16-acyconfig.png', 0, '{}', 256, 257, 0, '', 1),
(1548, 'main', 'COM_UNITEREVOLUTION2', 'com-uniterevolution2', '', 'com-uniterevolution2', 'index.php?option=com_uniterevolution2', 'component', 1, 1, 1, 10186, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_uniterevolution2/images/icon-16-revolution.png', 0, '{}', 259, 260, 0, '', 1),
(1549, 'main', 'COM_SPPAGEBUILDER', 'com-sppagebuilder', '', 'com-sppagebuilder', 'index.php?option=com_sppagebuilder', 'component', 1, 1, 1, 10250, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 261, 262, 0, '', 1),
(1550, 'main', 'TCPDF', 'tcpdf', '', 'tcpdf', 'index.php?option=com_tcpdf', 'component', 1, 1, 1, 10241, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 263, 264, 0, '', 1),
(1551, 'main', 'COM_VIRTUEMART', 'com-virtuemart', '', 'com-virtuemart', 'index.php?option=com_virtuemart', 'component', 1, 1, 1, 10181, 0, '0000-00-00 00:00:00', 0, 1, '../components/com_virtuemart/assets/images/vmgeneral/menu_icon.png', 0, '{}', 265, 292, 0, '', 1),
(1552, 'main', 'COM_VIRTUEMART_CONTROL_PANEL', 'com-virtuemart-control-panel', '', 'com-virtuemart/com-virtuemart-control-panel', 'index.php?option=com_virtuemart&view=virtuemart', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-report.png', 0, '{}', 266, 267, 0, '', 1),
(1553, 'main', 'COM_VIRTUEMART_MENU_CATEGORIES', 'com-virtuemart-menu-categories', '', 'com-virtuemart/com-virtuemart-menu-categories', 'index.php?option=com_virtuemart&view=category', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-categories.png', 0, '{}', 268, 269, 0, '', 1),
(1554, 'main', 'COM_VIRTUEMART_MENU_PRODUCTS', 'com-virtuemart-menu-products', '', 'com-virtuemart/com-virtuemart-menu-products', 'index.php?option=com_virtuemart&view=product', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-products.png', 0, '{}', 270, 271, 0, '', 1),
(1555, 'main', 'COM_VIRTUEMART_MENU_CUSTOMS', 'com-virtuemart-menu-customs', '', 'com-virtuemart/com-virtuemart-menu-customs', 'index.php?option=com_virtuemart&view=custom', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-document_move.png', 0, '{}', 272, 273, 0, '', 1),
(1556, 'main', 'COM_VIRTUEMART_MENU_ORDERS', 'com-virtuemart-menu-orders', '', 'com-virtuemart/com-virtuemart-menu-orders', 'index.php?option=com_virtuemart&view=orders', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-orders.png', 0, '{}', 274, 275, 0, '', 1),
(1557, 'main', 'COM_VIRTUEMART_MENU_REPORT', 'com-virtuemart-menu-report', '', 'com-virtuemart/com-virtuemart-menu-report', 'index.php?option=com_virtuemart&view=report', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-report.png', 0, '{}', 276, 277, 0, '', 1),
(1558, 'main', 'COM_VIRTUEMART_MENU_USERS', 'com-virtuemart-menu-users', '', 'com-virtuemart/com-virtuemart-menu-users', 'index.php?option=com_virtuemart&view=user', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shoppers.png', 0, '{}', 278, 279, 0, '', 1),
(1559, 'main', 'COM_VIRTUEMART_MENU_MANUFACTURERS', 'com-virtuemart-menu-manufacturers', '', 'com-virtuemart/com-virtuemart-menu-manufacturers', 'index.php?option=com_virtuemart&view=manufacturer', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-manufacturers.png', 0, '{}', 280, 281, 0, '', 1),
(1560, 'main', 'COM_VIRTUEMART_MENU_STORE', 'com-virtuemart-menu-store', '', 'com-virtuemart/com-virtuemart-menu-store', 'index.php?option=com_virtuemart&view=user&task=editshop', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shop.png', 0, '{}', 282, 283, 0, '', 1),
(1561, 'main', 'COM_VIRTUEMART_MENU_MEDIAFILES', 'com-virtuemart-menu-mediafiles', '', 'com-virtuemart/com-virtuemart-menu-mediafiles', 'index.php?option=com_virtuemart&view=media', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-media.png', 0, '{}', 284, 285, 0, '', 1),
(1562, 'main', 'COM_VIRTUEMART_MENU_SHIPMENTMETHODS', 'com-virtuemart-menu-shipmentmethods', '', 'com-virtuemart/com-virtuemart-menu-shipmentmethods', 'index.php?option=com_virtuemart&view=shipmentmethod', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-shipmentmethods.png', 0, '{}', 286, 287, 0, '', 1),
(1563, 'main', 'COM_VIRTUEMART_MENU_PAYMENTMETHODS', 'com-virtuemart-menu-paymentmethods', '', 'com-virtuemart/com-virtuemart-menu-paymentmethods', 'index.php?option=com_virtuemart&view=paymentmethod', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-paymentmethods.png', 0, '{}', 288, 289, 0, '', 1),
(1564, 'main', 'COM_VIRTUEMART_MENU_CONFIGURATION', 'com-virtuemart-menu-configuration', '', 'com-virtuemart/com-virtuemart-menu-configuration', 'index.php?option=com_virtuemart&view=config', 'component', 1, 1551, 2, 10181, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_virtuemart/assets/images/icon_16/menu-icon16-config.png', 0, '{}', 290, 291, 0, '', 1),
(1565, 'main', 'VirtueMart AIO', 'virtuemart-aio', '', 'virtuemart-aio', 'index.php?option=com_virtuemart_allinone', 'component', 1, 1, 1, 10129, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '{}', 293, 294, 0, '', 1);

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `menutype` varchar(24) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__menu_types` (`id`, `asset_id`, `menutype`, `title`, `description`, `client_id`) VALUES
(6, 0, 'mainmenu', 'Main Menu', 'Simple Home Menu', 0),
(8, 0, 'main-menu-en', 'Main menu-en', 'Main menu-en', 0),
(9, 0, 'hauptmenue-de', 'Hauptmenü-de', 'Hauptmenü-de', 0),
(10, 0, 'menu-principal-fr', 'Menu principal-fr', 'Menu principal-fr', 0),
(11, 0, 'menu-principale-it', 'Menu principale-it', 'Menu principale-it', 0),
(12, 0, 'nav-menu', 'Nav_menu', 'Nav_menu', 0),
(13, 0, 'top-menu', 'Top_menu', 'top_menu', 0),
(14, 0, 'the-service', 'The Service', 'The Service', 0),
(15, 0, 'information', 'Information', 'Information', 0),
(16, 0, 'search-param', 'search _param', 'search _param', 0),
(17, 0, 'system-menu', 'System menu', 'System menu', 0),
(18, 0, 'ru', 'Главное меню-ru', 'Главное меню-ru', 0),
(19, 0, 'virtuemart-categories', 'Virtuemart categories', 'Virtuemart categories', 0),
(20, 0, 'main-menu-he', 'Main menu He', 'Main menu He', 0);

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE IF NOT EXISTS `#__messages` (
  `message_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `user_id_to` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `folder_id` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `priority` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `cfg_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE IF NOT EXISTS `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `position` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `module` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `showtitle` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `params` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(2, 0, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 0, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(4, 0, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(8, 0, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 0, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 0, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', 1, '*'),
(12, 0, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', 1, '*'),
(13, 0, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 0, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 0, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(79, 0, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(86, 0, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}', 1, '*'),
(93, 0, 'Language:', '', '', 1, 'user-3', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_languages', 1, 1, '{\"header_text\":\"\",\"footer_text\":\"\",\"dropdown\":\"0\",\"image\":\"1\",\"inline\":\"1\",\"show_active\":\"1\",\"full_name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_switcher\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', 0, '*'),
(98, 0, 'Curency:', '', '', 1, 'user-4', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_currencies', 1, 1, '{\"text_before\":\"\",\"product_currency\":\"\",\"cache\":\"1\",\"moduleclass_sfx\":\"_curency\",\"class_sfx\":\"\"}', 0, '*'),
(99, 0, 'YJ Pop Login', '', '', 1, 'user-1', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_yj_pop_login', 1, 0, '{\"cache\":\"0\",\"moduleclass_sfx\":\"_login\",\"pretext\":\"<span>Welcome visitor can you<\\/span>\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\"}', 0, '*'),
(100, 0, 'Top menu', '', '', 1, 'user-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"top-menu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_topmenu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', 0, '*'),
(101, 0, 'Call Phone', '', '<p>Call Use Tol Free <span>(123)-456-7890</span></p>', 1, 'user-8', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_phone\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', 0, '*'),
(107, 0, 'Footer', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_footer', 1, 0, '{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', 0, '*'),
(110, 87, 'Banners', '', '', 1, 'position-1', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{\"target\":\"1\",\"count\":2,\"cid\":\"0\",\"catid\":[\"3\"],\"tag_search\":\"0\",\"ordering\":\"0\",\"header_text\":\"\",\"footer_text\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_banner1\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(111, 93, 'Best Sales', '', '', 1, 'user-15', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"default\",\"product_group\":\"topten\",\"max_items\":\"6\",\"products_per_row\":\"1\",\"display_style\":\"div\",\"display_izotop\":\"0\",\"enable_tolltips\":\"0\",\"row_xOffset\":\"50\",\"row_yOffset\":\"-150\",\"show_img\":\"1\",\"show_category\":\"0\",\"show_title\":\"1\",\"show_ratings\":\"1\",\"show_desc\":\"0\",\"row_desc\":\"40\",\"show_det\":\"0\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"1\",\"moduleclass_sfx\":\"_new\",\"class_sfx\":\"_feat\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(112, 94, 'New collection', '', '', 1, 'user-16', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"default\",\"product_group\":\"latest\",\"max_items\":\"12\",\"products_per_row\":\"2\",\"display_style\":\"list\",\"display_izotop\":\"0\",\"enable_tolltips\":\"0\",\"row_xOffset\":\"50\",\"row_yOffset\":\"-150\",\"show_img\":\"1\",\"show_category\":\"0\",\"show_title\":\"1\",\"show_ratings\":\"1\",\"show_desc\":\"0\",\"row_desc\":\"40\",\"show_det\":\"0\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"1\",\"moduleclass_sfx\":\"_new\",\"class_sfx\":\"_new\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(113, 81, 'Random products', '', '', 1, 'parallax-bot', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"default\",\"product_group\":\"random\",\"max_items\":\"6\",\"products_per_row\":\"1\",\"display_style\":\"list\",\"display_izotop\":\"0\",\"enable_tolltips\":\"0\",\"row_xOffset\":\"50\",\"row_yOffset\":\"-150\",\"show_img\":\"1\",\"show_category\":\"0\",\"show_title\":\"1\",\"show_ratings\":\"1\",\"show_desc\":\"0\",\"row_desc\":\"40\",\"show_det\":\"0\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"1\",\"moduleclass_sfx\":\"_new\",\"class_sfx\":\"_random\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(114, 83, 'Product Brands', '', '', 1, 'user-18', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_manufacturer', 1, 1, '{\"show\":\"image\",\"display_style\":\"list\",\"manufacturers_per_row\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"cache\":\"1\",\"moduleclass_sfx\":\"_new brand\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(115, 0, 'The Service', '', '', 1, 'footer-1', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"the-service\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_footmenu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', 0, '*'),
(116, 0, 'Information', '', '', 1, 'footer-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{\"menutype\":\"information\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_footmenu2\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', 0, '*'),
(118, 98, 'Join Us on Facebook', '', '', 1, 'footer-4', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_itpfblikebox', 1, 1, '{\"page_title\":\"facebook\",\"page_link\":\"https:\\/\\/www.facebook.com\\/facebook\",\"width\":\"280\",\"height\":\"280\",\"show_facepile\":\"1\",\"show_posts\":\"0\",\"hide_cover\":\"0\",\"app_id\":\"facebooks\",\"load_js\":\"1\",\"include_root_div\":\"1\",\"dynamic_locale\":\"1\",\"locale\":\"en_US\",\"moduleclass_sfx\":\"faceboock\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(119, 108, 'Newsletter', '', '', 1, 'footer-5', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_acymailing', 1, 1, '{\"effect\":\"normal\",\"lists\":\"None\",\"hiddenlists\":\"All\",\"displaymode\":\"vertical\",\"listschecked\":\"All\",\"checkmode\":\"0\",\"dropdown\":\"0\",\"overlay\":\"0\",\"link\":\"1\",\"listposition\":\"before\",\"customfields\":\"email\",\"nametext\":\"\",\"emailtext\":\"\",\"fieldsize\":\"95%\",\"displayfields\":\"0\",\"introtext\":\"Sign up to our newsletter and get exclusive deals you wont find anywhere else straight to your inbox!\",\"finaltext\":\"\",\"showsubscribe\":\"1\",\"subscribetext\":\"\",\"subscribetextreg\":\"\",\"showunsubscribe\":\"0\",\"unsubscribetext\":\"\",\"redirectmode\":\"3\",\"redirectlink\":\"\",\"redirectlinkunsub\":\"\",\"showterms\":\"0\",\"showtermspopup\":\"0\",\"termscontent\":\"0\",\"mootoolsintro\":\"\",\"mootoolsbutton\":\"\",\"boxwidth\":\"250\",\"boxheight\":\"200\",\"moduleclass_sfx\":\"_newsletter\",\"textalign\":\"none\",\"loggedin\":\"1\",\"cache\":\"0\",\"cache_time\":\"15\",\"includejs\":\"header\",\"itemid\":\"\",\"loadmootools\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(121, 0, 'Social Media Icon Links', '', '', 1, 'social', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_socialmedialinks', 1, 0, '{\"theme\":\"default\",\"size\":\"size2\",\"align\":\"center\",\"margin\":\"3px\",\"text\":\"Follow us on\",\"rsstext\":\"RSS Feed\",\"target\":\"_blank\",\"robots\":\"0\",\"credits\":\"0\",\"ic1\":\"\",\"url1\":\"\",\"ic2\":\"facebook.png\",\"url2\":\"https:\\/\\/www.facebook.com\\/\",\"ic3\":\"twitter.png\",\"url3\":\"https:\\/\\/www.twitter.com\\/\",\"ic4\":\"google.png\",\"url4\":\"https:\\/\\/www.google.com\\/\",\"ic5\":\"linkedin.png\",\"url5\":\"http:\\/\\/www.linkedin.com\",\"ic6\":\"pinterest.png\",\"url6\":\"http:\\/\\/pinterest.com\",\"ic7\":\"vimeo.png\",\"url7\":\"http:\\/\\/vimeo.com\",\"ic8\":\"youtube.png\",\"url8\":\"http:\\/\\/www.youtube.com\",\"ic9\":\"flickr.png\",\"url9\":\"http:\\/\\/www.flickr.com\\/\",\"ic10\":\"\",\"url10\":\"\",\"ic11\":\"\",\"url11\":\"\",\"ic12\":\"\",\"url12\":\"\",\"ic13\":\"\",\"url13\":\"\",\"ic14\":\"\",\"url14\":\"\",\"ic15\":\"\",\"url15\":\"\",\"ic16\":\"\",\"url16\":\"\",\"ic17\":\"\",\"url17\":\"\",\"ic18\":\"\",\"url18\":\"\",\"ic19\":\"\",\"url19\":\"\",\"ic20\":\"\",\"url20\":\"\",\"ic21\":\"\",\"url21\":\"\",\"ic22\":\"\",\"url22\":\"\",\"ic23\":\"\",\"url23\":\"\",\"ic24\":\"\",\"url24\":\"\",\"ic25\":\"\",\"url25\":\"\",\"ic26\":\"\",\"url26\":\"\",\"ic27\":\"\",\"url27\":\"\",\"ic28\":\"\",\"url28\":\"\",\"ic29\":\"\",\"url29\":\"\",\"ic30\":\"\",\"url30\":\"\",\"moduleclass_sfx\":\"\"}', 0, '*'),
(123, 90, 'Categories', '', '', 5, 'sidebar-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_category', 1, 1, '{\"Parent_Category_id\":\"0\",\"layout\":\"default\",\"cache\":\"0\",\"enable_tolltips\":\"1\",\"row_xOffset\":\"100\",\"row_yOffset\":\"50\",\"moduleclass_sfx\":\" category\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(124, 86, 'Breadcrumbs', '', '', 1, 'bread', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 1, '{\"showHere\":\"0\",\"showHome\":\"1\",\"homeText\":\"Home\",\"showLast\":\"1\",\"separator\":\">\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_bread\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(125, 92, 'Sidebar_banner', '', '', 7, 'sidebar-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_banners', 1, 0, '{\"target\":\"1\",\"count\":1,\"cid\":\"0\",\"catid\":[\"13\"],\"tag_search\":\"0\",\"ordering\":\"0\",\"header_text\":\"\",\"footer_text\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\" sidebar_banner\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(126, 91, 'Bestsellers', '', '', 6, 'sidebar-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"listbestsellers\",\"product_group\":\"topten\",\"max_items\":\"4\",\"products_per_row\":\"1\",\"display_style\":\"div\",\"display_izotop\":\"0\",\"enable_tolltips\":\"0\",\"row_xOffset\":\"50\",\"row_yOffset\":\"-150\",\"show_img\":\"1\",\"show_category\":\"0\",\"show_title\":\"1\",\"show_ratings\":\"1\",\"show_desc\":\"0\",\"row_desc\":\"40\",\"show_det\":\"0\",\"show_price\":\"1\",\"show_addtocart\":\"0\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"1\",\"moduleclass_sfx\":\" best\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(140, 0, 'K2 Quick Icons (admin)', '', '', 0, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_quickicons', 1, 1, '', 1, '*'),
(141, 0, 'K2 Stats (admin)', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_stats', 1, 1, '', 1, '*'),
(143, 76, 'JGMap - A Google Map Module', '', '', 1, 'content', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_JGMap', 1, 1, '{\"width\":\"400\",\"height\":\"260\",\"mapType\":\"HYBRID\",\"smallmap\":\"1\",\"navControls\":\"1\",\"static\":\"0\",\"lat\":\"42.668199613343376\",\"lng\":\"-76.29986773431301\",\"zoom\":\"7\",\"marker\":\"1\",\"marker_lat\":\"42.67896501780408\",\"marker_lng\":\"-75.84435819573054\",\"marker_title\":\"\",\"moduleclass_sfx\":\"_map\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(151, 0, 'Virtuemart serch', '', '', 1, 'user-11', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_search', 1, 0, '{\"width\":\"20\",\"text\":\"Type text and hit enter\",\"filter_category\":\"0\",\"button\":\"1\",\"button_pos\":\"right\",\"imagebutton\":\"0\",\"button_text\":\"\",\"moduleclass_sfx\":\"_search\",\"cache\":\"1\",\"cache_time\":\"900\"}', 0, '*'),
(152, 0, 'Cart', '', '', 1, 'user-12', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_cart', 1, 0, '{\"moduleclass_sfx\":\"_cart\",\"enable_cache\":\"0\",\"cache_time\":\"30\",\"show_product_list\":\"1\",\"limitcount\":\"6\",\"width\":\"60px\",\"height\":\"60px\",\"widthdropdown\":\"460\",\"show_scrollbar\":\"1\",\"height_scrollbar\":\"199\"}', 0, '*'),
(153, 100, 'Display All Products', '', '', 1, 'user-15', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_vm2_products', 1, 1, '{\"feat\":\"1\",\"layout_feat\":\"layout2\",\"featTitle\":\"Featured Products\",\"max_items_feat\":\"8\",\"products_per_row_feat\":\"4\",\"stock_feat\":\"0\",\"show_img_feat\":\"1\",\"show_title_feat\":\"1\",\"show_desc_feat\":\"0\",\"row_desc_feat\":\"40\",\"show_cat_feat\":\"0\",\"show_rating_feat\":\"1\",\"show_price_feat\":\"1\",\"show_details_feat\":\"0\",\"show_addcart_feat\":\"1\",\"headerText_feat\":\"\",\"footerText_feat\":\"\",\"class_sfx_feat\":\"feat\",\"new\":\"1\",\"layout_new\":\"layout\",\"newTitle\":\"New Products\",\"max_items_new\":\"4\",\"products_per_row_new\":\"4\",\"stock_new\":\"0\",\"show_img_new\":\"1\",\"show_title_new\":\"1\",\"show_desc_new\":\"0\",\"row_desc_new\":\"40\",\"show_cat_new\":\"0\",\"show_rating_new\":\"1\",\"show_price_new\":\"1\",\"show_details_new\":\"0\",\"show_addcart_new\":\"1\",\"headerText_new\":\"\",\"footerText_new\":\"\",\"class_sfx_new\":\"new\",\"hit\":\"1\",\"layout_hit\":\"layout2\",\"hitTitle\":\"Hit Products\",\"max_items_hit\":\"4\",\"products_per_row_hit\":\"4\",\"stock_hit\":\"0\",\"show_img_hit\":\"1\",\"show_title_hit\":\"1\",\"show_desc_hit\":\"0\",\"row_desc_hit\":\"40\",\"show_cat_hit\":\"0\",\"show_rating_hit\":\"1\",\"show_price_hit\":\"1\",\"show_details_hit\":\"0\",\"show_addcart_hit\":\"1\",\"headerText_hit\":\"\",\"footerText_hit\":\"\",\"class_sfx_hit\":\"hit\",\"disc\":\"1\",\"layout_disc\":\"layout\",\"discTitle\":\"Special Products\",\"max_items_disc\":\"8\",\"products_per_row_disc\":\"4\",\"stock_disc\":\"0\",\"show_img_disc\":\"1\",\"show_title_disc\":\"1\",\"show_desc_disc\":\"0\",\"row_desc_disc\":\"40\",\"show_cat_disc\":\"0\",\"show_rating_disc\":\"1\",\"show_price_disc\":\"1\",\"show_details_disc\":\"0\",\"show_addcart_disc\":\"1\",\"headerText_disc\":\"\",\"footerText_disc\":\"\",\"class_sfx_disc\":\"disc\",\"rand\":\"1\",\"layout_rand\":\"layout2\",\"randTitle\":\"Random Products\",\"max_items_random\":\"8\",\"products_per_row_random\":\"4\",\"stock_rand\":\"0\",\"show_img_rand\":\"1\",\"show_title_rand\":\"1\",\"show_desc_rand\":\"0\",\"row_desc_rand\":\"40\",\"show_cat_rand\":\"0\",\"show_rating_rand\":\"1\",\"show_price_rand\":\"1\",\"show_details_rand\":\"0\",\"show_addcart_rand\":\"1\",\"headerText_rand\":\"\",\"footerText_rand\":\"\",\"class_sfx_rand\":\"random\",\"rank\":\"0\",\"layout_rank\":\"layout2\",\"rankTitle\":\"Rated Products\",\"max_items_rank\":\"4\",\"products_per_row_rank\":\"4\",\"show_img_rank\":\"1\",\"show_title_rank\":\"1\",\"show_desc_rank\":\"0\",\"row_desc_rank\":\"40\",\"show_cat_rank\":\"0\",\"show_rating_rank\":\"1\",\"show_price_rank\":\"1\",\"show_details_rank\":\"0\",\"show_addcart_rank\":\"1\",\"headerText_rank\":\"\",\"footerText_rank\":\"\",\"class_sfx_rank\":\"rating\",\"cache\":\"0\",\"moduleclass_sfx\":\"_vm2products\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(154, 73, 'Display our products', '', '', 1, 'user-15', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"izotop\",\"product_group\":\"random\",\"max_items\":\"12\",\"products_per_row\":\"4\",\"display_style\":\"list\",\"display_izotop\":\"1\",\"enable_tolltips\":\"0\",\"row_xOffset\":\"50\",\"row_yOffset\":\"-150\",\"show_img\":\"1\",\"show_category\":\"0\",\"show_title\":\"1\",\"show_ratings\":\"1\",\"show_desc\":\"0\",\"row_desc\":\"40\",\"show_det\":\"0\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"1\",\"moduleclass_sfx\":\"_izotopall\",\"class_sfx\":\"_izotop\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(155, 0, 'Featured Products (2)', '', '', 1, 'user-15', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"default\",\"product_group\":\"featured\",\"max_items\":\"6\",\"products_per_row\":\"1\",\"display_style\":\"div\",\"display_izotop\":\"0\",\"enable_tolltips\":\"0\",\"row_xOffset\":\"50\",\"row_yOffset\":\"-150\",\"show_img\":\"1\",\"show_category\":\"0\",\"show_title\":\"1\",\"show_ratings\":\"1\",\"show_desc\":\"0\",\"row_desc\":\"40\",\"show_det\":\"0\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"1\",\"moduleclass_sfx\":\"_new\",\"class_sfx\":\"_feat\"}', 0, '*'),
(156, 0, 'New collection (2)', '', '', 1, 'user-16', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"default\",\"product_group\":\"latest\",\"max_items\":\"6\",\"products_per_row\":\"1\",\"display_style\":\"div\",\"display_izotop\":\"0\",\"enable_tolltips\":\"0\",\"row_xOffset\":\"50\",\"row_yOffset\":\"-150\",\"show_img\":\"1\",\"show_category\":\"0\",\"show_title\":\"1\",\"show_ratings\":\"1\",\"show_desc\":\"0\",\"row_desc\":\"40\",\"show_det\":\"0\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"1\",\"moduleclass_sfx\":\"_new\",\"class_sfx\":\"_new\"}', 0, '*'),
(157, 0, 'Random products (2)', '', '', 1, 'user-17', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_product', 1, 1, '{\"layout\":\"izotop\",\"product_group\":\"random\",\"max_items\":\"8\",\"products_per_row\":\"4\",\"display_style\":\"div\",\"display_izotop\":\"0\",\"enable_tolltips\":\"0\",\"row_xOffset\":\"50\",\"row_yOffset\":\"-150\",\"show_img\":\"1\",\"show_category\":\"0\",\"show_title\":\"1\",\"show_ratings\":\"1\",\"show_desc\":\"0\",\"row_desc\":\"40\",\"show_det\":\"0\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"filter_category\":\"0\",\"virtuemart_category_id\":\"0\",\"cache\":\"1\",\"moduleclass_sfx\":\"_random\",\"class_sfx\":\"_izotop\"}', 0, '*'),
(158, 0, 'Deals of the day!', '', '', 1, 'content', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_countdown', 1, 1, '{\"sale_text\":\"\",\"product_id\":\"1,2,3,4,5,6\",\"show_price\":\"1\",\"show_addtocart\":\"1\",\"cache\":\"0\",\"moduleclass_sfx\":\"\",\"class_sfx\":\"\"}', 0, '*'),
(162, 0, 'Virtuemart categories', '', '', 1, 'user-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"virtuemart-categories\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_topmenu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', 0, '*'),
(163, 0, 'System menu', '', '', 1, 'user-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{\"menutype\":\"system-menu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"_topmenu\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', 0, '*'),
(164, 99, 'News From Twitter', '', '', 1, 'footer-3', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', -2, 'mod_jmod_tweetdisplay', 1, 1, '{\"consumer_key\":\"9JH7de9na8JnUjSADwpG0fJ65\",\"consumer_secret\":\"uamiAj41b46Razt38TJVgGKzBOIwOl07Pn8W53296uvReVni9N\",\"access_token\":\"308471286-eKRNX77anFKPKxUWbX0wRAT95GWgjnaGko5YGBpM\",\"access_secret\":\"VtRgip39ajULJ9R5oIiclxsG9Pu3F38kz3PLHeGM4fbRp\",\"type\":\"1\",\"username\":\"fanfbmltemplate\",\"query\":\"\",\"title\":\"\",\"link_title\":\"1\",\"count\":\"2\",\"width\":\"\",\"height\":\"\",\"header\":\"0\",\"twitter_icon\":\"0\",\"display_name\":\"1\",\"avatars\":\"0\",\"timestamps\":\"1\",\"reply\":\"1\",\"retweet\":\"1\",\"favorite\":\"1\",\"show_link\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"twitter\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(166, 88, 'Compare products', '', '', 2, 'sidebar-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_comparelist', 1, 1, '{\"moduleclass_sfx\":\"_compare\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(167, 89, 'Wishlist Products', '', '', 3, 'sidebar-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_wishlist', 1, 1, '{\"moduleclass_sfx\":\"_wishlists\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(169, 84, 'Newsletter popup', '', '', 1, 'footer-5', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_acymailing', 1, 0, '{\"effect\":\"normal\",\"lists\":\"None\",\"hiddenlists\":\"All\",\"displaymode\":\"vertical\",\"listschecked\":\"All\",\"checkmode\":\"0\",\"dropdown\":\"0\",\"overlay\":\"0\",\"link\":\"1\",\"listposition\":\"before\",\"customfields\":\"email,name\",\"nametext\":\"\",\"emailtext\":\"\",\"fieldsize\":\"100%\",\"displayfields\":\"0\",\"introtext\":\"<h2>Subscribe Now to <span>Get 20% Off<\\/span>\\r\\non Any Product!<\\/h2>\\r\\n<div class=\\\"wrap-border\\\">\\r\\n<img src=\\\"modules\\/mod_acymailing\\/assets\\/images\\/subscribe_banner.jpg\\\" alt=\\\"\\\" \\/>\\r\\n<div class=\\\"fleft\\\">\\r\\n<P \\/>Aliquam dapibus tincidunt metus. Praesent justo dolor, lobortis quis, lobortis dignissim, pulvinar ac, lorem. <\\/p>\\r\\n<P \\/>Vestibulum sed ante. Donec sagittis euismod purus. Sed ut perspiciatis unde omnis iste natus error sit.<\\/p>\\r\\n<\\/div>\\r\\n<\\/div>\",\"finaltext\":\"\",\"showsubscribe\":\"1\",\"subscribetext\":\"\",\"subscribetextreg\":\"\",\"showunsubscribe\":\"0\",\"unsubscribetext\":\"\",\"redirectmode\":\"3\",\"redirectlink\":\"\",\"redirectlinkunsub\":\"\",\"showterms\":\"0\",\"showtermspopup\":\"1\",\"termscontent\":\"0\",\"mootoolsintro\":\"\",\"mootoolsbutton\":\"\",\"boxwidth\":\"250\",\"boxheight\":\"200\",\"moduleclass_sfx\":\"_newsletter\",\"textalign\":\"none\",\"loggedin\":\"1\",\"cache\":\"0\",\"cache_time\":\"15\",\"includejs\":\"header\",\"itemid\":\"\",\"loadmootools\":\"0\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(170, 0, 'JS Cookie Alert', '', '', 1, 'cookies', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_js_cookie_alert', 1, 0, '{\"js_alert_jquery\":\"2\",\"js_cwbuttoncolor\":\"red\",\"js_cwmessage\":\"Please note this website requires cookies in order to function correctly, they do not store any specific information about you personally.\",\"js_cwbubbletitle\":\"Cookie Laws within the EU\",\"js_cwbubblemessage\":\"On 26th May 2012, new laws came into force in the EU that affect most web sites. If cookies are used in a site, the Privacy and Electronic Communications (EC Directive) (Amendment) Regulations 2011 (UK Government Regulations) asks that the website user must give consent to the use and placing of the cookies.\",\"js_cwagree\":\"Accept Cookies\",\"js_cwmoreinfo\":\"Read more...\"}', 0, '*'),
(171, 69, 'Unite Revolution Slider 2', '', '', 1, 'user-10', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_unite_revolution2', 1, 0, '{\"sliderid\":\"1\",\"include_jquery\":\"false\",\"js_load_type\":\"body\",\"no_conflict_mode\":\"false\",\"moduleclass_sfx\":\"_rev\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(172, 0, 'VM - Administrator Module', '', '', 5, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_vmmenu', 3, 1, '', 1, '*'),
(174, 74, 'Megamenu Categories', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_jux_vm_megamenu', 1, 1, '{\"hozorver\":\"vertical\",\"horizontal_submenu_direction\":\"down\",\"vertical_submenu_direction\":\"lefttoright\",\"navigation_animation\":\"zoom\",\"n_navigation_animation\":\"fading\",\"animation_duration\":\"400\",\"animation_delay\":\"100\",\"show_num_items\":\"0\",\"show_items\":\"0\",\"load_font_awesome\":\"0\",\"mega_config\":\"{\\\"item-1\\\":{\\\"sub\\\":{\\\"width\\\":\\\"800px\\\",\\\"rows\\\":[[{\\\"item\\\":4,\\\"display\\\":1,\\\"width\\\":4},{\\\"item\\\":5,\\\"display\\\":1,\\\"width\\\":4},{\\\"item\\\":6,\\\"display\\\":1,\\\"width\\\":4}],[{\\\"position\\\":116,\\\"display\\\":1,\\\"width\\\":4},{\\\"position\\\":110,\\\"display\\\":1,\\\"width\\\":8}]]},\\\"type\\\":\\\"category\\\",\\\"display\\\":1,\\\"alignsub\\\":\\\"left\\\"},\\\"item-4\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":7,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"display\\\":1,\\\"type\\\":\\\"category\\\",\\\"group\\\":1},\\\"item-7\\\":{\\\"display\\\":1,\\\"type\\\":\\\"category\\\"},\\\"item-8\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-9\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-10\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-11\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-12\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-13\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-5\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":14,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"display\\\":1,\\\"type\\\":\\\"category\\\",\\\"group\\\":1},\\\"item-14\\\":{\\\"display\\\":1,\\\"type\\\":\\\"category\\\"},\\\"item-15\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-16\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-17\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-18\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-19\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-20\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-6\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":21,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"display\\\":1,\\\"type\\\":\\\"category\\\",\\\"group\\\":1},\\\"item-21\\\":{\\\"display\\\":1,\\\"type\\\":\\\"category\\\"},\\\"item-22\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-23\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-24\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-25\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-26\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-2\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":27,\\\"display\\\":1,\\\"width\\\":12}]]},\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-27\\\":{\\\"display\\\":1,\\\"type\\\":\\\"category\\\"},\\\"item-28\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-29\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-30\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-31\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-32\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1},\\\"item-3\\\":{\\\"type\\\":\\\"category\\\",\\\"display\\\":1}}\",\"mega_order\":\"[]\",\"nav_style\":\"flat\",\"fl_color\":\"#ffffff\",\"gradient\":\"\",\"gradient_type\":\"linear\",\"gs_color_1\":\"#484848\",\"gs_color_2\":\"#393939\",\"ge_color_1\":\"#212121\",\"ge_color_2\":\"#131313\",\"nav_border\":\"{\\\"nav_border_style\\\":\\\"none\\\"}\",\"nav_padding\":\"{}\",\"nav_margin\":\"{}\",\"nav_corner\":\"{}\",\"dd_bacground_color\":\"#fffff\",\"dd_border\":\"{\\\"dd_border_style\\\":\\\"none\\\"}\",\"dd_padding\":\"{}\",\"dd_margin\":\"{}\",\"dd_corner\":\"{}\",\"dd_shadow\":\"{\\\"dd_shadow_inset\\\":\\\"0\\\"}\",\"titem_hover_bacground_color\":\"#fffff\",\"titem_border\":\"{\\\"titem_border_style\\\":\\\"none\\\"}\",\"titem_padding\":\"{}\",\"titem_margin\":\"{}\",\"titem_text_color\":\"#333333\",\"titem_text_hover_color\":\"#0088cc\",\"ditem_hover_bacground_color\":\"#fffff\",\"ditem_border\":\"{\\\"ditem_border_style\\\":\\\"none\\\"}\",\"ditem_padding\":\"{}\",\"ditem_margin\":\"{}\",\"ditem_text_color\":\"#333333\",\"ditem_text_hover_color\":\"#0088cc\",\"juxtime\":\"1413828147\",\"custom_css\":\"\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(175, 75, 'Responsive color google map', '', '', 1, 'content', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', -2, 'mod_profil_responsive_map', 1, 1, '{\"profilResponsiveMapTemplates\":\"default\",\"profilResponsiveMapGeoCoordinates\":[\"40.8516701\",\"-93.2599318\",\"\",\"0\",\"modules\\/mod_profil_responsive_map\\/tmpl\\/default\\/images\\/marker-24-red.png\"],\"profilResponsiveMapColor\":\"#123456\",\"profilResponsiveMapContrast\":\"1.58\",\"profilResponsiveMapSaturation\":\"0\",\"profilResponsiveMapLightness\":\"0\",\"profilResponsiveMapZoom\":\"7\",\"profilResponsivePanControl\":\"1\",\"profilResponsiveZoomControl\":\"1\",\"profilResponsiveMapTypeControl\":\"1\",\"profilResponsiveScaleControl\":\"1\",\"profilResponsiveStreetViewControl\":\"1\",\"profilResponsiveScrollwheel\":\"1\",\"profilResponsiveFullscreen\":\"0\",\"profilResponsiveVisibility\":\"0\",\"profilResponsiveDescription\":\"\",\"profilResponsiveBikemap\":\"0\",\"profilResponsiveWeathermap\":\"0\",\"profilResponsiveWeathermapTemperatureunit\":\"0\",\"profilResponsiveCloudmap\":\"0\",\"profilResponsiveTrafficmap\":\"0\",\"moduleclass_sfx\":\"_map\",\"cache\":\"1\",\"cache_time\":\"900\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(176, 77, 'Module Parallax', '', '', 1, 'parallax-top', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_parallax', 1, 0, '{\"selector\":\"#parallax-top\",\"backgroundratio\":\"0.2\",\"horizontalOffset\":\"0\",\"verticalOffset\":\"20\",\"mod_image\":\"images\\/Parallax\\/slide1.jpg\",\"moduleclass_sfx\":\"parallax-top\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(177, 78, 'Display All Products', '', '', 1, 'parallax-top', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_vm2_products', 1, 1, '{\"feat\":\"1\",\"layout_feat\":\"layout2\",\"featTitle\":\"Featured Products\",\"max_items_feat\":\"4\",\"products_per_row_feat\":\"4\",\"stock_feat\":\"0\",\"show_img_feat\":\"1\",\"show_title_feat\":\"1\",\"show_desc_feat\":\"0\",\"row_desc_feat\":\"40\",\"show_cat_feat\":\"0\",\"show_rating_feat\":\"1\",\"show_price_feat\":\"1\",\"show_details_feat\":\"0\",\"show_addcart_feat\":\"1\",\"headerText_feat\":\"\",\"footerText_feat\":\"\",\"class_sfx_feat\":\"feat\",\"new\":\"1\",\"layout_new\":\"layout\",\"newTitle\":\"New Products\",\"max_items_new\":\"4\",\"products_per_row_new\":\"4\",\"stock_new\":\"0\",\"show_img_new\":\"1\",\"show_title_new\":\"1\",\"show_desc_new\":\"0\",\"row_desc_new\":\"40\",\"show_cat_new\":\"0\",\"show_rating_new\":\"1\",\"show_price_new\":\"1\",\"show_details_new\":\"0\",\"show_addcart_new\":\"1\",\"headerText_new\":\"\",\"footerText_new\":\"\",\"class_sfx_new\":\"new\",\"hit\":\"1\",\"layout_hit\":\"layout2\",\"hitTitle\":\"Hit Products\",\"max_items_hit\":\"4\",\"products_per_row_hit\":\"4\",\"stock_hit\":\"0\",\"show_img_hit\":\"1\",\"show_title_hit\":\"1\",\"show_desc_hit\":\"0\",\"row_desc_hit\":\"40\",\"show_cat_hit\":\"0\",\"show_rating_hit\":\"1\",\"show_price_hit\":\"1\",\"show_details_hit\":\"0\",\"show_addcart_hit\":\"1\",\"headerText_hit\":\"\",\"footerText_hit\":\"\",\"class_sfx_hit\":\"hit\",\"disc\":\"1\",\"layout_disc\":\"layout\",\"discTitle\":\"Special Products\",\"max_items_disc\":\"4\",\"products_per_row_disc\":\"4\",\"stock_disc\":\"0\",\"show_img_disc\":\"1\",\"show_title_disc\":\"1\",\"show_desc_disc\":\"0\",\"row_desc_disc\":\"40\",\"show_cat_disc\":\"0\",\"show_rating_disc\":\"1\",\"show_price_disc\":\"1\",\"show_details_disc\":\"0\",\"show_addcart_disc\":\"1\",\"headerText_disc\":\"\",\"footerText_disc\":\"\",\"class_sfx_disc\":\"disc\",\"rand\":\"1\",\"layout_rand\":\"layout2\",\"randTitle\":\"Random Products\",\"max_items_random\":\"4\",\"products_per_row_random\":\"4\",\"stock_rand\":\"0\",\"show_img_rand\":\"1\",\"show_title_rand\":\"1\",\"show_desc_rand\":\"0\",\"row_desc_rand\":\"40\",\"show_cat_rand\":\"0\",\"show_rating_rand\":\"1\",\"show_price_rand\":\"1\",\"show_details_rand\":\"0\",\"show_addcart_rand\":\"1\",\"headerText_rand\":\"\",\"footerText_rand\":\"\",\"class_sfx_rand\":\"random\",\"rank\":\"1\",\"layout_rank\":\"layout2\",\"rankTitle\":\"Rated Products\",\"max_items_rank\":\"4\",\"products_per_row_rank\":\"4\",\"show_img_rank\":\"1\",\"show_title_rank\":\"1\",\"show_desc_rank\":\"0\",\"row_desc_rank\":\"40\",\"show_cat_rank\":\"0\",\"show_rating_rank\":\"1\",\"show_price_rank\":\"1\",\"show_details_rank\":\"0\",\"show_addcart_rank\":\"1\",\"headerText_rank\":\"\",\"footerText_rank\":\"\",\"class_sfx_rank\":\"rating\",\"cache\":\"0\",\"moduleclass_sfx\":\"_vm2products\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(178, 79, 'Module Parallax', '', '', 1, 'parallax-bot', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_parallax', 1, 0, '{\"selector\":\"#parallax-bot\",\"backgroundratio\":\"0.3\",\"horizontalOffset\":\"0\",\"verticalOffset\":\"20\",\"mod_image\":\"images\\/Parallax\\/slide5.jpg\",\"moduleclass_sfx\":\"parallax-bot\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(179, 80, 'Module Parallax', '', '', 1, 'parallax-top', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', -2, 'mod_parallax', 1, 0, '{\"selector\":\"#parallax-top\",\"backgroundratio\":\"0.2\",\"horizontalOffset\":\"0\",\"verticalOffset\":\"20\",\"mod_image\":\"images\\/Parallax\\/slide1.jpg\",\"moduleclass_sfx\":\"parallax-top\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(180, 82, 'Product Brands', '', '', 1, 'navhelper', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_manufacturer', 1, 1, '{\"show\":\"image\",\"display_style\":\"list\",\"manufacturers_per_row\":\"1\",\"headerText\":\"\",\"footerText\":\"\",\"cache\":\"1\",\"moduleclass_sfx\":\"_new brand\",\"class_sfx\":\"\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(181, 85, 'Filter', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_virtuemart_param_filter', 1, 1, '{\"layout\":\"default\",\"method\":\"get\",\"limit\":\"10\",\"Parent_Category_id\":[\"25\"],\"parent_auto\":\"1\",\"stock\":\"1\",\"children\":\"-1\",\"show_all_count\":\"1\",\"mod_ajax\":\"1\",\"count_show\":\"1\",\"count_zero_show\":\"disable\",\"mod_ajax_div\":\"#prodlist-box\",\"loader_img\":\"aload-black_on_white\",\"mcf_prepend_text\":\"\",\"mcf_append_text\":\"\",\"mcf_reinit_start\":\"\",\"mcf_reinit_mod\":\"\",\"mcf_reinit_body\":\"jQuery(document).ready(function () {\\r\\n\\r\\n\\tjQuery(\'.orderlistcontainer\').hover(\\r\\n\\t\\tfunction() { \\r\\n\\t\\tjQuery(this).find(\'.orderlist\').has(\'div\').stop().show();\\r\\n\\t\\tjQuery(this).find(\'.activeOrder\').addClass(\'hover\');\\r\\n\\t\\t},\\r\\n\\t\\tfunction() { \\r\\n\\t\\tjQuery(this).find(\'.orderlist\').has(\'div\').stop().hide();\\r\\n\\t\\tjQuery(this).find(\'.activeOrder\').removeClass(\'hover\');\\r\\n\\t\\t}\\r\\n\\t)\\r\\n\\tjQuery(\'.orderlistcontainer .orderlist\').each(function(){\\r\\njQuery(this).parent().find(\'.activeOrder\').addClass(\'block\');             \\t})\\r\\nVirtuemart.product(jQuery(\\\"form.product\\\"));\\r\\n  jQuery(\\\"form.js-recalculate\\\").each(function(){\\r\\n    if (jQuery(this).find(\\\".product-fields\\\").length) {\\r\\n      var id= jQuery(this).find(\'input[name=\\\"virtuemart_product_id[]\\\"]\').val();\\r\\n      Virtuemart.setproducttype(jQuery(this),id);\\r\\n\\r\\n    }\\r\\n  });\\r\\njQuery(\'.navigation_grid .hasTooltip , #product_list.grid .hasTooltips, #product_list.grid .hasTooltip\').tooltip();\\r\\n\\t jQuery(\'.Results select\').styler();\\r\\n        \\r\\n\\tvar cc = jQuery.cookie(\'list_grid\');\\r\\n\\tif (cc == \'g\') {\\r\\n\\t\\tjQuery(\'#product_list\').addClass(\'list\');\\r\\n\\t\\tjQuery(\'#product_list\').removeClass(\'grid\');\\r\\n\\t\\tjQuery(\'.Cgrid\').removeClass(\'active\');\\r\\n\\t\\tjQuery(\'.Clist\').addClass(\'active\');\\r\\n\\t} else {\\r\\n\\t\\tjQuery(\'#product_list\').addClass(\'grid\');\\r\\n\\t\\tjQuery(\'#product_list\').removeClass(\'list\');\\r\\n\\t\\tjQuery(\'.Clist\').removeClass(\'active\');\\r\\n\\t\\tjQuery(\'.Cgrid\').addClass(\'active\');\\t\\t\\r\\n\\t}\\r\\n\\tjQuery(\'.Cgrid\').click(function() {\\r\\n\\t\\tjQuery(\'.Cgrid\').addClass(\'active\');\\r\\n\\t\\tjQuery(\'.Clist\').removeClass(\'active\');\\r\\n\\t\\tjQuery(\'#product_list\').fadeOut(300, function() {\\r\\n\\t\\t\\tjQuery(this).addClass(\'grid\').removeClass(\'list\').fadeIn(300);\\r\\n\\t\\t});\\r\\n\\t\\tjQuery.cookie(\'list_grid\', \'1\' , { expires: 7, path: vmSiteurl });\\r\\n\\t\\treturn false;\\r\\n\\t});\\r\\n\\tjQuery(\'.Clist\').click(function() {\\r\\n\\t\\tjQuery(\'.Clist\').addClass(\'active\');\\r\\n\\t\\tjQuery(\'.Cgrid\').removeClass(\'active\');\\t\\t\\t\\t\\t\\t  \\r\\n\\t\\tjQuery(\'#product_list\').fadeOut(300, function() {\\r\\n\\t\\t\\tjQuery(this).removeClass(\'grid\').addClass(\'list\').fadeIn(300);\\r\\n\\t\\t});\\r\\n\\t\\tjQuery.cookie(\'list_grid\',\'g\', { expires: 7, path: vmSiteurl });\\r\\n\\t\\treturn false;\\r\\n\\t});\\r\\n\\r\\njQuery(\\\"#product_list .vmproduct li\\\").each(function(indx, element){\\r\\nvar my_product_id = jQuery(this).find(\\\".quick_ids\\\").val();\\r\\n\\r\\njQuery(this).append(\\\"<div class=\'quick_btn\' onClick =\'quick_btn(\\\"+my_product_id+\\\")\'><i class=\'icon-eye-open\'><\\/i>\\\"+show_quicktext+\\\"<\\/div>\\\");\\r\\njQuery(this).find(\\\".quick_id\\\").remove();\\r\\n});\\r\\n});\\r\\n \\r\\n\\r\\n\",\"mcf_mod_uniq_display\":\"1\",\"mcf_mod_uniq_result\":\"1\",\"view_assign\":[\"category\",\"virtuemart\"],\"category_assign\":[\"1\",\"4\",\"5\",\"6\",\"2\",\"27\",\"28\",\"29\",\"30\",\"31\",\"32\",\"3\"],\"categories_show\":\"0\",\"in_active_category\":\"0\",\"active_category_id\":\"\",\"mcf_subcategories\":\"0\",\"mcf_only_subcategories\":\"0\",\"categories_heading\":\"\",\"categories_select_heading\":\"Choose category\",\"categories_layout\":\"checkbox\",\"manufacturers_show\":\"1\",\"manufacturers_heading\":\"Manufacturers\",\"manufacturers_select_heading\":\"Choose manufacturer\",\"mcf_body\":\"Z3ppbmZsYXRl;dZJra9swFIb\\/ypnwik0Tx4GtbL5kBNrRFQod65etKUaxj2OtsmR08eaW\\/vdJTsYgZF8E5\\/K859WRdlxuKYegNR2fBT1VtCs1UlW1Jat1BkEtKyjg5jOtjFRjmu7QXMrKdihMGLn6MeKamdZoQk\\/OV8flCM7OTkBvCpgv4ROchiAFYTn30\\/iu7KrGO7rjdsfENfIe1WRrnwjJ0FVWG9mRGZmEiLfpoPIJRwf+1FKUNVayxvCv3mGkjuarQ2MGwJrwH1ZAV78Pt1TjxbsSxUTvnmtsODUYEk6\\/Xi5JrO1WG\\/XfNi9Bbkl8c7e+vy6\\/fbm\\/iskViaJolsyWF1FM1vgjmRLRC7wi1\\/gCgel655oqRUe\\/8EaqMGBFkgUsLz668\\/zcNTuvh60f7+4hYI9RNMk8PDqhkw0ZvJ58SU9l+8\\/hIpLXbABtRo7FhjRSmLlmz5h+SN5mG7L6Li20dECgIKRw\\/4UN7tI1DKg0kwJ+taxqoWa653TUYHswEpYJ7CeCQm250TGsDySM0iroZG05QosKU8gptAobN701pk8Xi27E3yZGuyFgqHKfwJXKLafiyRm6Ha+mYr6gq3zhvK9ITDbCHTkTvTVgxt7fpGV1jcJJCNr52D86E8y4zEC59all4oKF46dd+HUpNFYJMMpi9gc=;Y3JlYXRlX2Z1bmN0aW9u\",\"mcf_mod\":\"bxaisiexi6xi4xi_xdieicixoidxe\",\"manufacturers_layout\":\"checkbox\",\"price_show\":\"1\",\"price_heading\":\"Price\",\"price_discount\":\"2\",\"price_mcur\":\"1\",\"price_layout\":\"slider_double\",\"price_select_heading\":\"Choose Price\",\"customfields_show\":\"1\",\"customfields_select_heading\":\"Choose some options\",\"customfields_layout\":\"auto\",\"itemid\":\"\",\"moduleclass_sfx\":\"_param\",\"class_sfx\":\"\",\"mcf_jqueryui\":\"1\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(182, 96, 'Cooltags Cloud', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_cooltags_cloud', 1, 1, '{\"min_font\":\"14\",\"max_font\":\"14\",\"limit\":\"14\",\"catfilter\":\"0\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(183, 101, 'Google Map', '', '<p>{mosmap}</p>', 1, 'content', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}', 0, '*'),
(184, 105, 'SP Page Builder', '', '', 0, '', 0, '0000-00-00 00:00:00', '2019-08-17 20:01:05', '0000-00-00 00:00:00', -2, 'mod_sppagebuilder', 1, 1, '', 0, '*'),
(185, 106, 'SP Page Builder', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_icons', 1, 1, '', 1, '*'),
(186, 107, 'SP Page Builder Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_sppagebuilder_admin_menu', 1, 1, '', 1, '*');

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT 0,
  `menuid` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(16, 205),
(16, 435),
(17, 0),
(18, 0),
(19, -463),
(19, -462),
(19, -433),
(19, -432),
(19, -431),
(19, -430),
(19, -429),
(19, -427),
(19, -400),
(19, -399),
(19, -296),
(19, -244),
(19, -243),
(19, -242),
(19, -234),
(20, 0),
(22, 231),
(22, 234),
(22, 238),
(22, 242),
(22, 243),
(22, 244),
(22, 296),
(22, 399),
(22, 400),
(23, -463),
(23, -462),
(23, -433),
(23, -432),
(23, -431),
(23, -430),
(23, -429),
(23, -427),
(23, -400),
(23, -399),
(23, -296),
(23, -244),
(23, -243),
(23, -242),
(23, -238),
(23, -234),
(25, 294),
(26, -463),
(26, -462),
(26, -433),
(26, -432),
(26, -431),
(26, -430),
(26, -429),
(26, -427),
(26, -400),
(26, -399),
(26, -296),
(26, -244),
(26, -243),
(26, -242),
(26, -238),
(26, -234),
(27, 325),
(28, 310),
(29, 302),
(30, 410),
(31, 309),
(32, 309),
(33, 307),
(34, 326),
(35, 306),
(36, 304),
(37, 311),
(38, 300),
(39, 301),
(40, 313),
(41, 324),
(44, 312),
(45, 303),
(47, 231),
(47, 234),
(47, 242),
(47, 243),
(47, 244),
(47, 296),
(47, 399),
(47, 400),
(48, 418),
(49, 417),
(52, 416),
(56, 305),
(57, 238),
(57, 427),
(57, 429),
(57, 430),
(57, 431),
(57, 432),
(57, 433),
(57, 462),
(57, 463),
(58, 427),
(58, 429),
(58, 430),
(58, 431),
(58, 432),
(58, 433),
(58, 462),
(58, 463),
(61, 443),
(62, 231),
(62, 234),
(62, 242),
(62, 243),
(62, 244),
(62, 296),
(62, 399),
(62, 400),
(63, 0),
(64, 0),
(65, 427),
(65, 429),
(65, 430),
(65, 431),
(65, 432),
(65, 433),
(65, 462),
(65, 463),
(68, 243),
(69, 459),
(70, 285),
(70, 316),
(71, 285),
(71, 316),
(72, 285),
(72, 316),
(73, 285),
(73, 316),
(74, 285),
(74, 316),
(75, 285),
(75, 316),
(76, 285),
(76, 316),
(77, 0),
(78, 0),
(79, 0),
(84, 467),
(86, 0),
(88, 0),
(89, 0),
(90, 0),
(91, 0),
(92, 0),
(93, 0),
(98, 0),
(99, 0),
(100, 0),
(101, 0),
(107, 0),
(110, 435),
(110, 502),
(110, 503),
(110, 504),
(110, 505),
(110, 506),
(110, 507),
(110, 523),
(110, 524),
(110, 525),
(110, 526),
(110, 624),
(110, 634),
(110, 640),
(110, 1060),
(111, 435),
(111, 502),
(111, 503),
(111, 504),
(111, 505),
(111, 506),
(111, 507),
(111, 523),
(111, 524),
(111, 525),
(111, 526),
(111, 618),
(111, 619),
(111, 620),
(111, 640),
(111, 1060),
(112, 435),
(112, 502),
(112, 503),
(112, 504),
(112, 505),
(112, 506),
(112, 507),
(112, 523),
(112, 524),
(112, 525),
(112, 526),
(112, 618),
(112, 619),
(112, 620),
(112, 1060),
(113, 435),
(113, 502),
(113, 503),
(113, 504),
(113, 505),
(113, 506),
(113, 507),
(113, 523),
(113, 524),
(113, 525),
(113, 526),
(113, 618),
(113, 619),
(113, 620),
(113, 640),
(113, 1060),
(114, 507),
(114, 523),
(114, 524),
(114, 525),
(114, 526),
(114, 618),
(114, 619),
(114, 620),
(114, 624),
(114, 634),
(115, 0),
(116, 0),
(118, 0),
(119, 0),
(121, 0),
(123, 435),
(123, 502),
(123, 503),
(123, 504),
(123, 505),
(123, 506),
(123, 507),
(123, 508),
(123, 509),
(123, 510),
(123, 511),
(123, 513),
(123, 514),
(123, 516),
(123, 517),
(123, 518),
(123, 519),
(123, 520),
(123, 521),
(123, 522),
(123, 523),
(123, 524),
(123, 526),
(123, 528),
(123, 529),
(123, 561),
(123, 562),
(123, 563),
(123, 564),
(123, 565),
(123, 567),
(123, 570),
(123, 618),
(123, 619),
(123, 620),
(123, 639),
(123, 640),
(123, 648),
(123, 1002),
(123, 1003),
(123, 1004),
(123, 1005),
(123, 1006),
(123, 1007),
(123, 1008),
(123, 1009),
(123, 1010),
(123, 1011),
(123, 1012),
(123, 1013),
(123, 1014),
(123, 1015),
(123, 1016),
(123, 1017),
(123, 1018),
(123, 1019),
(123, 1020),
(123, 1021),
(123, 1022),
(123, 1023),
(123, 1024),
(123, 1025),
(123, 1026),
(123, 1027),
(123, 1028),
(123, 1029),
(123, 1030),
(123, 1060),
(124, 435),
(124, 502),
(124, 503),
(124, 504),
(124, 505),
(124, 506),
(124, 507),
(124, 508),
(124, 509),
(124, 510),
(124, 511),
(124, 512),
(124, 513),
(124, 514),
(124, 515),
(124, 516),
(124, 517),
(124, 518),
(124, 519),
(124, 520),
(124, 521),
(124, 522),
(124, 523),
(124, 524),
(124, 525),
(124, 526),
(124, 528),
(124, 529),
(124, 561),
(124, 562),
(124, 563),
(124, 564),
(124, 565),
(124, 567),
(124, 570),
(124, 576),
(124, 577),
(124, 578),
(124, 579),
(124, 580),
(124, 613),
(124, 618),
(124, 619),
(124, 620),
(124, 624),
(124, 634),
(124, 639),
(124, 640),
(124, 643),
(124, 647),
(124, 648),
(124, 649),
(124, 1060),
(125, 435),
(125, 502),
(125, 503),
(125, 504),
(125, 505),
(125, 506),
(125, 507),
(125, 508),
(125, 509),
(125, 510),
(125, 511),
(125, 512),
(125, 513),
(125, 514),
(125, 515),
(125, 516),
(125, 517),
(125, 518),
(125, 519),
(125, 520),
(125, 521),
(125, 522),
(125, 523),
(125, 524),
(125, 525),
(125, 526),
(125, 528),
(125, 529),
(125, 561),
(125, 562),
(125, 563),
(125, 564),
(125, 565),
(125, 567),
(125, 570),
(125, 618),
(125, 619),
(125, 620),
(125, 639),
(125, 640),
(125, 647),
(125, 649),
(125, 1060),
(126, 435),
(126, 502),
(126, 503),
(126, 504),
(126, 505),
(126, 506),
(126, 507),
(126, 508),
(126, 509),
(126, 510),
(126, 511),
(126, 513),
(126, 514),
(126, 515),
(126, 516),
(126, 517),
(126, 518),
(126, 519),
(126, 520),
(126, 521),
(126, 522),
(126, 523),
(126, 524),
(126, 526),
(126, 528),
(126, 529),
(126, 561),
(126, 562),
(126, 563),
(126, 564),
(126, 565),
(126, 567),
(126, 570),
(126, 618),
(126, 619),
(126, 620),
(126, 639),
(126, 640),
(126, 647),
(126, 649),
(126, 1060),
(143, 565),
(151, 0),
(152, 0),
(153, 634),
(154, 624),
(158, 528),
(164, 0),
(166, 507),
(166, 508),
(166, 509),
(166, 510),
(166, 511),
(166, 512),
(166, 513),
(166, 514),
(166, 515),
(166, 516),
(166, 517),
(166, 518),
(166, 519),
(166, 520),
(166, 521),
(166, 522),
(166, 523),
(166, 524),
(166, 525),
(166, 526),
(166, 528),
(166, 529),
(166, 561),
(166, 562),
(166, 563),
(166, 564),
(166, 565),
(166, 567),
(166, 570),
(166, 576),
(166, 577),
(166, 578),
(166, 579),
(166, 613),
(166, 618),
(166, 619),
(166, 620),
(166, 624),
(166, 634),
(166, 639),
(166, 640),
(166, 643),
(166, 647),
(166, 648),
(166, 649),
(166, 1002),
(166, 1003),
(166, 1004),
(166, 1005),
(166, 1006),
(166, 1007),
(166, 1008),
(166, 1009),
(166, 1010),
(166, 1011),
(166, 1012),
(166, 1013),
(166, 1014),
(166, 1015),
(166, 1016),
(166, 1017),
(166, 1018),
(166, 1019),
(166, 1020),
(166, 1021),
(166, 1022),
(166, 1023),
(166, 1024),
(166, 1025),
(166, 1026),
(166, 1027),
(166, 1028),
(166, 1029),
(166, 1030),
(167, 507),
(167, 508),
(167, 509),
(167, 511),
(167, 512),
(167, 513),
(167, 514),
(167, 515),
(167, 516),
(167, 517),
(167, 518),
(167, 519),
(167, 520),
(167, 521),
(167, 522),
(167, 523),
(167, 524),
(167, 525),
(167, 526),
(167, 528),
(167, 529),
(167, 561),
(167, 562),
(167, 563),
(167, 564),
(167, 565),
(167, 567),
(167, 570),
(167, 576),
(167, 577),
(167, 578),
(167, 579),
(167, 613),
(167, 618),
(167, 619),
(167, 620),
(167, 624),
(167, 634),
(167, 639),
(167, 640),
(167, 643),
(167, 647),
(167, 648),
(167, 649),
(167, 1002),
(167, 1003),
(167, 1004),
(167, 1005),
(167, 1006),
(167, 1007),
(167, 1008),
(167, 1009),
(167, 1010),
(167, 1011),
(167, 1012),
(167, 1013),
(167, 1014),
(167, 1015),
(167, 1016),
(167, 1017),
(167, 1018),
(167, 1019),
(167, 1020),
(167, 1021),
(167, 1022),
(167, 1023),
(167, 1024),
(167, 1025),
(167, 1026),
(167, 1027),
(167, 1028),
(167, 1029),
(167, 1030),
(169, 435),
(169, 502),
(169, 503),
(169, 504),
(169, 505),
(169, 506),
(169, 507),
(169, 523),
(169, 524),
(169, 624),
(169, 634),
(169, 640),
(169, 1060),
(170, 0),
(171, 435),
(171, 502),
(171, 503),
(171, 504),
(171, 505),
(171, 506),
(171, 507),
(171, 523),
(171, 524),
(171, 526),
(171, 624),
(171, 634),
(171, 640),
(171, 1060),
(172, 0),
(174, 523),
(175, 565),
(176, 435),
(176, 502),
(176, 503),
(176, 504),
(176, 505),
(176, 506),
(176, 640),
(176, 1060),
(177, 435),
(177, 502),
(177, 503),
(177, 504),
(177, 505),
(177, 506),
(177, 640),
(177, 1060),
(178, 435),
(178, 502),
(178, 503),
(178, 504),
(178, 505),
(178, 506),
(178, 640),
(178, 1060),
(179, 435),
(179, 502),
(179, 503),
(179, 504),
(179, 505),
(179, 506),
(179, 640),
(180, 435),
(180, 502),
(180, 503),
(180, 504),
(180, 505),
(180, 506),
(180, 640),
(180, 1060),
(181, 515),
(181, 516),
(181, 528),
(181, 529),
(181, 567),
(181, 570),
(181, 643),
(181, 648),
(181, 649),
(181, 1002),
(181, 1010),
(181, 1018),
(181, 1025),
(181, 1026),
(181, 1027),
(181, 1028),
(181, 1029),
(181, 1030),
(182, 435),
(182, 502),
(182, 503),
(182, 504),
(182, 505),
(182, 506),
(182, 507),
(182, 508),
(182, 509),
(182, 511),
(182, 512),
(182, 513),
(182, 514),
(182, 515),
(182, 516),
(182, 517),
(182, 518),
(182, 519),
(182, 520),
(182, 521),
(182, 522),
(182, 523),
(182, 524),
(182, 525),
(182, 526),
(182, 528),
(182, 529),
(182, 567),
(182, 570),
(182, 576),
(182, 577),
(182, 578),
(182, 579),
(182, 613),
(182, 618),
(182, 619),
(182, 620),
(182, 624),
(182, 634),
(182, 640),
(182, 643),
(182, 648),
(182, 649),
(182, 1002),
(182, 1003),
(182, 1004),
(182, 1005),
(182, 1006),
(182, 1007),
(182, 1008),
(182, 1009),
(182, 1010),
(182, 1011),
(182, 1012),
(182, 1013),
(182, 1014),
(182, 1015),
(182, 1016),
(182, 1017),
(182, 1018),
(182, 1019),
(182, 1020),
(182, 1021),
(182, 1022),
(182, 1023),
(182, 1024),
(182, 1025),
(182, 1026),
(182, 1027),
(182, 1028),
(182, 1029),
(182, 1030),
(182, 1060),
(183, 565),
(185, 0),
(186, 0);

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT 0,
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `numarticles` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `cache_time` int(10) UNSIGNED NOT NULL DEFAULT 3600,
  `checked_out` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rtl` tinyint(4) NOT NULL DEFAULT 0,
  `access` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `metakey` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `hits` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `images` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE IF NOT EXISTS `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE IF NOT EXISTS `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT 700 COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT 1,
  `type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT 1,
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', 1, 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', 1),
(4, 10159, 'AKEEBA_POSTSETUP_LBL_CONFWIZ', 'AKEEBA_POSTSETUP_DESC_CONFWIZ', 'AKEEBA_POSTSETUP_BTN_RUN_CONFWIZ', 'com_akeeba', 1, 'action', 'admin://components/com_akeeba/helpers/postinstall.php', 'com_akeeba_postinstall_confwiz_action', 'admin://components/com_akeeba/helpers/postinstall.php', 'com_akeeba_postinstall_confwiz_condition', '4.0.0', 1),
(5, 10159, 'AKEEBA_POSTSETUP_LBL_ANGIEUPGRADE', 'AKEEBA_POSTSETUP_DESC_ANGIEUPGRADE', 'AKEEBA_POSTSETUP_BTN_ANGIEUPGRADE', 'com_akeeba', 1, 'action', 'admin://components/com_akeeba/helpers/postinstall.php', 'com_akeeba_postinstall_angie_action', 'admin://components/com_akeeba/helpers/postinstall.php', 'com_akeeba_postinstall_angie_condition', '4.0.0', 1),
(6, 10159, 'AKEEBA_POSTSETUP_LBL_ACCEPTLICENSE', 'AKEEBA_POSTSETUP_DESC_ACCEPTLICENSE', 'AKEEBA_POSTSETUP_BTN_I_CONFIRM_THIS', 'com_akeeba', 1, 'message', '', '', '', '', '4.0.0', 1),
(7, 10159, 'AKEEBA_POSTSETUP_LBL_ACCEPTSUPPORT', 'AKEEBA_POSTSETUP_DESC_ACCEPTSUPPORT', 'AKEEBA_POSTSETUP_BTN_I_CONFIRM_THIS', 'com_akeeba', 1, 'message', '', '', '', '', '4.0.0', 1),
(8, 10159, 'AKEEBA_POSTSETUP_LBL_ACCEPTBACKUPTEST', 'AKEEBA_POSTSETUP_DESC_ACCEPTBACKUPTEST', 'AKEEBA_POSTSETUP_BTN_I_CONFIRM_THIS', 'com_akeeba', 1, 'message', '', '', '', '', '4.0.0', 1),
(9, 700, 'COM_CPANEL_MSG_HTACCESS_TITLE', 'COM_CPANEL_MSG_HTACCESS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/htaccess.php', 'admin_postinstall_htaccess_condition', '3.4.0', 1),
(10, 700, 'COM_CPANEL_MSG_ROBOTS_TITLE', 'COM_CPANEL_MSG_ROBOTS_BODY', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.3.0', 1),
(11, 700, 'COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE', 'COM_CPANEL_MSG_LANGUAGEACCESS340_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/languageaccess340.php', 'admin_postinstall_languageaccess340_condition', '3.4.1', 1),
(12, 700, 'COM_CPANEL_MSG_STATS_COLLECTION_TITLE', 'COM_CPANEL_MSG_STATS_COLLECTION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/statscollection.php', 'admin_postinstall_statscollection_condition', '3.5.0', 1),
(13, 700, 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY', 'PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION', 'plg_system_updatenotification', 1, 'action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_action', 'site://plugins/system/updatenotification/postinstall/updatecachetime.php', 'updatecachetime_postinstall_condition', '3.6.3', 1),
(14, 700, 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE', 'COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/joomla40checks.php', 'admin_postinstall_joomla40checks_condition', '3.7.0', 1),
(15, 700, 'TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE', 'TPL_HATHOR_MESSAGE_POSTINSTALL_BODY', 'TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION', 'tpl_hathor', 1, 'action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_action', 'admin://templates/hathor/postinstall/hathormessage.php', 'hathormessage_postinstall_condition', '3.7.0', 1),
(16, 700, 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_TITLE', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_BODY', 'PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_ACTION', 'plg_captcha_recaptcha', 1, 'action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_action', 'site://plugins/captcha/recaptcha/postinstall/actions.php', 'recaptcha_postinstall_condition', '3.8.6', 1),
(17, 700, 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_TITLE', 'COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/updatedefaultsettings.php', 'admin_postinstall_updatedefaultsettings_condition', '3.8.8', 1),
(18, 700, 'COM_ACTIONLOGS_POSTINSTALL_TITLE', 'COM_ACTIONLOGS_POSTINSTALL_BODY', '', 'com_actionlogs', 1, 'message', '', '', '', '', '3.9.0', 1),
(19, 700, 'COM_PRIVACY_POSTINSTALL_TITLE', 'COM_PRIVACY_POSTINSTALL_BODY', '', 'com_privacy', 1, 'message', '', '', '', '', '3.9.0', 1),
(20, 700, 'COM_CPANEL_MSG_ADDNOSNIFF_TITLE', 'COM_CPANEL_MSG_ADDNOSNIFF_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/addnosniff.php', 'admin_postinstall_addnosniff_condition', '3.9.3', 1);

DROP TABLE IF EXISTS `#__privacy_consents`;
CREATE TABLE IF NOT EXISTS `#__privacy_consents` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `state` int(10) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT 0,
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__privacy_requests`;
CREATE TABLE IF NOT EXISTS `#__privacy_requests` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `request_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `#__redirect_links`;
CREATE TABLE IF NOT EXISTS `#__redirect_links` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) COLLATE utf8_unicode_ci NOT NULL,
  `new_url` varchar(2048) COLLATE utf8_unicode_ci DEFAULT NULL,
  `referer` varchar(2048) COLLATE utf8_unicode_ci NOT NULL,
  `comment` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `header` smallint(3) NOT NULL DEFAULT 301,
  PRIMARY KEY (`id`),
  KEY `idx_link_modifed` (`modified_date`),
  KEY `idx_old_url` (`old_url`(100))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__redirect_links` (`id`, `old_url`, `new_url`, `referer`, `comment`, `hits`, `published`, `created_date`, `modified_date`, `header`) VALUES
(1, 'http://localhost/reviver/theme_4_6_1/index.php/en/adminiistrator', NULL, '', '', 1, 0, '2019-08-17 20:01:05', '0000-00-00 00:00:00', 301),
(2, 'http://localhost/reviver/theme_4_6_1/index.php/en/administrator', NULL, '', '', 1, 0, '2019-08-17 20:01:05', '0000-00-00 00:00:00', 301),
(3, 'http://localhost/reviver/theme_4_6_1/index.php/en/administrator/components/com_sppagebuilder/assets/js/engine.js.map', NULL, '', '', 1, 0, '2019-08-17 20:01:05', '0000-00-00 00:00:00', 301),
(4, 'http://localhost/reviver/reviver_theme4_7/index.php/en/plugins/system/t3/base/js/jquery.ckie.js', NULL, 'http://localhost/reviver/reviver_theme4_7/administrator/index.php?option=com_templates&view=style&layout=edit&id=137', '', 3, 0, '2019-08-17 20:05:01', '0000-00-00 00:00:00', 301);

DROP TABLE IF EXISTS `#__revslider_css`;
CREATE TABLE IF NOT EXISTS `#__revslider_css` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` text DEFAULT NULL,
  `hover` text DEFAULT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=utf8;

INSERT INTO `#__revslider_css` (`id`, `handle`, `settings`, `hover`, `params`) VALUES
(1, '.tp-caption.medium_grey', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-family\":\"Arial\",\"padding\":\"2px 4px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"background-color\":\"#888\",\"white-space\":\"nowrap\"}'),
(2, '.tp-caption.small_text', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"14px\",\"line-height\":\"20px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(3, '.tp-caption.medium_text', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(4, '.tp-caption.large_text', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"40px\",\"line-height\":\"40px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(5, '.tp-caption.very_large_text', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"font-weight\":\"700\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\",\"letter-spacing\":\"-2px\"}'),
(6, '.tp-caption.very_big_white', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"800\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\",\"padding\":\"0px 4px\",\"padding-top\":\"1px\",\"background-color\":\"#000\"}'),
(7, '.tp-caption.very_big_black', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#000\",\"text-shadow\":\"none\",\"font-weight\":\"700\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\",\"padding\":\"0px 4px\",\"padding-top\":\"1px\",\"background-color\":\"#fff\"}'),
(8, '.tp-caption.modern_medium_fat', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#000\",\"text-shadow\":\"none\",\"font-weight\":\"800\",\"font-size\":\"24px\",\"line-height\":\"20px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(9, '.tp-caption.modern_medium_fat_white', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"800\",\"font-size\":\"24px\",\"line-height\":\"20px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(10, '.tp-caption.modern_medium_light', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#000\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"24px\",\"line-height\":\"20px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(11, '.tp-caption.modern_big_bluebg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"800\",\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"padding\":\"3px 10px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"background-color\":\"#4e5b6c\",\"letter-spacing\":\"0\"}'),
(12, '.tp-caption.modern_big_redbg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"padding\":\"3px 10px\",\"padding-top\":\"1px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"background-color\":\"#de543e\",\"letter-spacing\":\"0\"}'),
(13, '.tp-caption.modern_small_text_dark', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#555\",\"text-shadow\":\"none\",\"font-size\":\"14px\",\"line-height\":\"22px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"white-space\":\"nowrap\"}'),
(14, '.tp-caption.thinheadline_dark', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"rgba(0,0,0,0.85)\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"transparent\"}'),
(15, '.tp-caption.thintext_dark', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"rgba(0,0,0,0.85)\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"16px\",\"line-height\":\"26px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"transparent\"}'),
(16, '.tp-caption.largeblackbg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#000\",\"padding\":\"0px 20px\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\",\"border-radius\":\"0px\"}'),
(17, '.tp-caption.largepinkbg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#db4360\",\"padding\":\"0px 20px\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\",\"border-radius\":\"0px\"}'),
(18, '.tp-caption.largewhitebg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#000\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#fff\",\"padding\":\"0px 20px\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\",\"border-radius\":\"0px\"}'),
(19, '.tp-caption.largegreenbg', NULL, NULL, '{\"position\":\"absolute\",\"color\":\"#fff\",\"text-shadow\":\"none\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#67ae73\",\"padding\":\"0px 20px\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\",\"border-radius\":\"0px\"}'),
(20, '.tp-caption.excerpt', NULL, NULL, '{\"font-size\":\"36px\",\"line-height\":\"36px\",\"font-weight\":\"700\",\"font-family\":\"Arial\",\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"rgba(0, 0, 0, 1)\",\"text-shadow\":\"none\",\"margin\":\"0px\",\"letter-spacing\":\"-1.5px\",\"padding\":\"1px 4px 0px 4px\",\"white-space\":\"normal !important\",\"height\":\"auto\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 255, 255)\",\"border-style\":\"none\"}'),
(21, '.tp-caption.large_bold_grey', NULL, NULL, '{\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(102, 102, 102)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"text-shadow\":\"none\",\"margin\":\"0px\",\"padding\":\"1px 4px 0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(22, '.tp-caption.medium_thin_grey', NULL, NULL, '{\"font-size\":\"34px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(102, 102, 102)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"1px 4px 0px\",\"text-shadow\":\"none\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(23, '.tp-caption.small_thin_grey', NULL, NULL, '{\"font-size\":\"18px\",\"line-height\":\"26px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(117, 117, 117)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"1px 4px 0px\",\"text-shadow\":\"none\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(24, '.tp-caption.lightgrey_divider', NULL, NULL, '{\"text-decoration\":\"none\",\"background-color\":\"rgba(235, 235, 235, 1)\",\"width\":\"370px\",\"height\":\"3px\",\"background-position\":\"initial initial\",\"background-repeat\":\"initial initial\",\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}'),
(25, '.tp-caption.large_bold_darkblue', NULL, NULL, '{\"font-size\":\"58px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(52, 73, 94)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(26, '.tp-caption.medium_bg_darkblue', NULL, NULL, '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(52, 73, 94)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(27, '.tp-caption.medium_bold_red', NULL, NULL, '{\"font-size\":\"24px\",\"line-height\":\"30px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(227, 58, 12)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(28, '.tp-caption.medium_light_red', NULL, NULL, '{\"font-size\":\"21px\",\"line-height\":\"26px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(227, 58, 12)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(29, '.tp-caption.medium_bg_red', NULL, NULL, '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(227, 58, 12)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(30, '.tp-caption.medium_bold_orange', NULL, NULL, '{\"font-size\":\"24px\",\"line-height\":\"30px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(243, 156, 18)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(31, '.tp-caption.medium_bg_orange', NULL, NULL, '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(243, 156, 18)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(32, '.tp-caption.large_bold_white', NULL, NULL, '{\"font-size\":\"58px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(33, '.tp-caption.medium_light_white', NULL, NULL, '{\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(34, '.tp-caption.mediumlarge_light_white', NULL, NULL, '{\"font-size\":\"34px\",\"line-height\":\"40px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(35, '.tp-caption.mediumlarge_light_white_center', NULL, NULL, '{\"font-size\":\"34px\",\"line-height\":\"40px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px 0px 0px 0px\",\"text-align\":\"center\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(36, '.tp-caption.medium_bg_asbestos', NULL, NULL, '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(127, 140, 141)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(37, '.tp-caption.medium_light_black', NULL, NULL, '{\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(0, 0, 0)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(38, '.tp-caption.large_bold_black', NULL, NULL, '{\"font-size\":\"58px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(0, 0, 0)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(39, '.tp-caption.mediumlarge_light_darkblue', NULL, NULL, '{\"font-size\":\"34px\",\"line-height\":\"40px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(52, 73, 94)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(40, '.tp-caption.small_light_white', NULL, NULL, '{\"font-size\":\"17px\",\"line-height\":\"28px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(41, '.tp-caption.roundedimage', NULL, NULL, '{\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}'),
(42, '.tp-caption.large_bg_black', NULL, NULL, '{\"font-size\":\"40px\",\"line-height\":\"40px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(0, 0, 0)\",\"padding\":\"10px 20px 15px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(43, '.tp-caption.mediumwhitebg', NULL, NULL, '{\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(0, 0, 0)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(255, 255, 255)\",\"padding\":\"5px 15px 10px\",\"text-shadow\":\"none\",\"border-width\":\"0px\",\"border-color\":\"rgb(0, 0, 0)\",\"border-style\":\"none\"}');

DROP TABLE IF EXISTS `#__revslider_layer_animations`;
CREATE TABLE IF NOT EXISTS `#__revslider_layer_animations` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__revslider_settings`;
CREATE TABLE IF NOT EXISTS `#__revslider_settings` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `general` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__revslider_sliders`;
CREATE TABLE IF NOT EXISTS `#__revslider_sliders` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__revslider_sliders` (`id`, `title`, `alias`, `params`) VALUES
(1, 'Slider_1', 'rev_slider', '{\"title\":\"Slider_1\",\"alias\":\"rev_slider\",\"shortcode\":\"[rev_slider rev_slider]\",\"source_type\":\"gallery\",\"post_types\":\"post\",\"post_category\":\"\",\"post_sortby\":\"ID\",\"posts_sort_direction\":\"DESC\",\"max_slider_posts\":\"30\",\"excerpt_limit\":\"55\",\"slider_template_id\":\"\",\"posts_list\":\"\",\"slider_type\":\"fullwidth\",\"fullscreen_offset_container\":\"\",\"fullscreen_min_height\":\"\",\"full_screen_align_force\":\"off\",\"auto_height\":\"off\",\"force_full_width\":\"on\",\"width\":\"1170\",\"height\":\"590\",\"responsitive_w1\":\"940\",\"responsitive_sw1\":\"770\",\"responsitive_w2\":\"780\",\"responsitive_sw2\":\"500\",\"responsitive_w3\":\"510\",\"responsitive_sw3\":\"310\",\"responsitive_w4\":\"0\",\"responsitive_sw4\":\"0\",\"responsitive_w5\":\"0\",\"responsitive_sw5\":\"0\",\"responsitive_w6\":\"0\",\"responsitive_sw6\":\"0\",\"delay\":\"10000\",\"shuffle\":\"off\",\"lazy_load\":\"off\",\"stop_slider\":\"on\",\"stop_after_loops\":0,\"stop_at_slide\":2,\"load_googlefont\":\"false\",\"google_font\":[\"<link href=\'http:\\/\\/fonts.googleapis.com\\/css?family=PT+Sans+Narrow:400,700\' rel=\'stylesheet\' type=\'text\\/css\'>\"],\"position\":\"center\",\"margin_top\":0,\"margin_bottom\":0,\"margin_left\":0,\"margin_right\":0,\"shadow_type\":\"0\",\"show_timerbar\":\"bottom\",\"padding\":0,\"background_color\":\"#E9E9E9\",\"background_dotted_overlay\":\"none\",\"show_background_image\":\"false\",\"background_image\":\"\",\"bg_fit\":\"cover\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"use_spinner\":\"3\",\"spinner_color\":\"#000000\",\"touchenabled\":\"on\",\"stop_on_hover\":\"on\",\"navigaion_type\":\"thumb\",\"navigation_arrows\":\"nexttobullets\",\"navigation_style\":\"navbar\",\"navigaion_always_on\":\"true\",\"hide_thumbs\":200,\"navigaion_align_hor\":\"center\",\"navigaion_align_vert\":\"bottom\",\"navigaion_offset_hor\":\"0\",\"navigaion_offset_vert\":20,\"leftarrow_align_hor\":\"left\",\"leftarrow_align_vert\":\"center\",\"leftarrow_offset_hor\":20,\"leftarrow_offset_vert\":0,\"rightarrow_align_hor\":\"right\",\"rightarrow_align_vert\":\"center\",\"rightarrow_offset_hor\":20,\"rightarrow_offset_vert\":0,\"thumb_width\":100,\"thumb_height\":50,\"thumb_amount\":5,\"hide_slider_under\":0,\"hide_defined_layers_under\":0,\"hide_all_layers_under\":0,\"hide_thumbs_on_mobile\":\"on\",\"hide_thumbs_under_resolution\":0,\"loop_slide\":\"loop\",\"start_with_slide\":\"1\",\"first_transition_type\":\"fade\",\"first_transition_duration\":300,\"first_transition_slot_amount\":7,\"reset_transitions\":\"\",\"reset_transition_duration\":0,\"0\":\"Execute settings on all slides\",\"template\":\"false\"}');

DROP TABLE IF EXISTS `#__revslider_slides`;
CREATE TABLE IF NOT EXISTS `#__revslider_slides` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `slide_order` int(11) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `#__revslider_slides` (`id`, `slider_id`, `slide_order`, `params`, `layers`) VALUES
(1, 1, 1, '{\"background_type\":\"external\",\"image\":\"http:\\/\\/inthe7heaven.com\\/reviver\\/images\\/gallery\\/slide1.jpg\",\"title\":\"Slide1\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":300,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"http:\\/\\/velikorodnov.com\\/themeforest\\/reviver\\/slider\\/Fgallery\\/thumbs\\/slide1.jpg\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"http:\\/\\/velikorodnov.com\\/themeforest\\/reviver\\/slider\\/Fgallery\\/slide1.jpg\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"30000\",\"kb_easing\":\"Linear.easeNone\",\"0\":\"Remove\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\"}', '[{\"text\":\"<div class=\\\"box_cption\\\"><div class=\\\"title\\\">Attractive & Powerful<\\/div><\\/div>\",\"type\":\"text\",\"left\":-50,\"top\":84,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":500,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"0\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":29500,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true},{\"text\":\"<div class=\\\"box_cption\\\"><div class=\\\"title2\\\">VirtueMart Theme<\\/div><\\/div>\",\"type\":\"text\",\"left\":-50,\"top\":146,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":800,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"1\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":29200,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true},{\"text\":\"<div class=\\\"box_cption\\\"><div class=\\\"desc\\\">Aenean nec eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia curae. Suspendisse sollicitudin velit sed leo. Ut pharetra augue nec augue.<\\/div><\\/div>\",\"type\":\"text\",\"left\":-50,\"top\":213,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":1100,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"2\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":28900,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true},{\"text\":\"<div class=\\\"box_cption\\\"><div class=\\\"box_price\\\"> <span>$40.00<\\/span> <a href=\\\"index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=1\\\" class=\\\"button\\\">Buy Now<\\/a> <\\/div><\\/div>\",\"type\":\"text\",\"left\":-50,\"top\":330,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":1400,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"3\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":28600,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true}]'),
(2, 1, 2, '{\"background_type\":\"external\",\"image\":\"http:\\/\\/inthe7heaven.com\\/reviver\\/images\\/gallery\\/slide2.jpg\",\"title\":\"Slide2\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":300,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"http:\\/\\/velikorodnov.com\\/themeforest\\/reviver\\/slider\\/Fgallery\\/thumbs\\/slide2.jpg\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"http:\\/\\/velikorodnov.com\\/themeforest\\/reviver\\/slider\\/Fgallery\\/slide2.jpg\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"30000\",\"kb_easing\":\"Linear.easeNone\",\"0\":\"Remove\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\"}', '[{\"text\":\"<div class=\\\"box_cption slide_2\\\"> <div class=\\\"title2\\\">Fully-Functional Admin Panel<\\/div> <\\/div>\",\"type\":\"text\",\"left\":10,\"top\":112,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"right\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":500,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"0\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":29500,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true},{\"text\":\"<div class=\\\"box_cption slide_2\\\"> <div class=\\\"desc\\\">Sed in lacus ut enim adipiscing aliquet. Nulla venenatis. In pede mi, aliquet sit amet, euismod in,auctor ut, ligula. Aliquam dapibus tincidunt metus. <\\/div>  <\\/div>\",\"type\":\"text\",\"left\":10,\"top\":222,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"right\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":800,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"1\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":29200,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true},{\"text\":\"<div class=\\\"box_cption slide_2\\\"> <div class=\\\"box_price\\\"><a href=\\\"index.php?ption=com_virtuemart&view=productdetails&virtuemart_product_id=2\\\" class=\\\"button\\\">View Collection<\\/a> <\\/div> <\\/div>\",\"type\":\"text\",\"left\":10,\"top\":325,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"right\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":1100,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"2\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":28900,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true}]'),
(3, 1, 3, '{\"background_type\":\"external\",\"title\":\"Slide3\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":300,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"http:\\/\\/velikorodnov.com\\/themeforest\\/reviver\\/slider\\/Fgallery\\/thumbs\\/slide3.jpg\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"http:\\/\\/velikorodnov.com\\/themeforest\\/reviver\\/slider\\/Fgallery\\/slide3.jpg\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"30000\",\"kb_easing\":\"Linear.easeNone\",\"image\":\"http:\\/\\/inthe7heaven.com\\/reviver\\/images\\/gallery\\/slide3.jpg\",\"0\":\"Remove\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\"}', '[{\"text\":\"<div class=\\\"box_cption slide_3\\\"> <div class=\\\"title2\\\">Extremely <span>Responsive<\\/span> Layout<\\/div>  <\\/div>\",\"type\":\"text\",\"left\":-60,\"top\":102,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":500,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"0\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":29500,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true},{\"text\":\"<div class=\\\"box_cption slide_3\\\"> <div class=\\\"desc\\\">Suspendisse sollicitudin velit sed leo. Ut pharetra augue nec augue. Nam elit agna, endrerit sit amet, tincidunt ac, viverra sed, nulla. Donec porta diam eu massa.<strong>Quisque diam lorem, interdum vitae.<\\/strong><\\/div> <\\/div>\",\"type\":\"text\",\"left\":-60,\"top\":282,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"left\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":800,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"1\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":29200,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true}]'),
(4, 1, 4, '{\"background_type\":\"external\",\"title\":\"Slide4\",\"state\":\"published\",\"date_from\":\"\",\"date_to\":\"\",\"slide_transition\":\"random\",\"0\":\"Remove\",\"slot_amount\":7,\"transition_rotation\":0,\"transition_duration\":300,\"delay\":\"\",\"enable_link\":\"false\",\"link_type\":\"regular\",\"link\":\"\",\"link_open_in\":\"same\",\"slide_link\":\"nothing\",\"link_pos\":\"front\",\"slide_thumb\":\"http:\\/\\/velikorodnov.com\\/themeforest\\/reviver\\/slider\\/Fgallery\\/thumbs\\/slide5.jpg\",\"image_id\":\"\",\"slide_bg_color\":\"#E7E7E7\",\"slide_bg_external\":\"http:\\/\\/velikorodnov.com\\/themeforest\\/reviver\\/slider\\/Fgallery\\/slide5.jpg\",\"bg_fit\":\"cover\",\"bg_fit_x\":\"100\",\"bg_fit_y\":\"100\",\"bg_repeat\":\"no-repeat\",\"bg_position\":\"center top\",\"bg_position_x\":\"0\",\"bg_position_y\":\"0\",\"kenburn_effect\":\"off\",\"kb_start_fit\":\"100\",\"kb_end_fit\":\"100\",\"bg_end_position\":\"center top\",\"kb_duration\":\"30000\",\"kb_easing\":\"Linear.easeNone\",\"image\":\"http:\\/\\/inthe7heaven.com\\/reviver\\/images\\/gallery\\/slide5.jpg\",\"save_performance\":\"off\",\"class_attr\":\"\",\"id_attr\":\"\",\"attr_attr\":\"\",\"data_attr\":\"\",\"bg_end_position_x\":\"0\",\"bg_end_position_y\":\"0\",\"0\":\"Remove\"}', '[{\"text\":\"<div class=\\\"box_cption slide_5 slide_2\\\"> <div class=\\\"title2\\\">A Ton of<\\/div> <div class=\\\"title\\\">Awesome Features<\\/div>  <\\/div>\",\"type\":\"text\",\"left\":10,\"top\":85,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"right\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":500,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"0\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":29500,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true},{\"text\":\"<div class=\\\"box_cption slide_5 slide_2\\\"> <div class=\\\"desc\\\">Aenean nec eros. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia curae. <\\/div> <\\/div>\",\"type\":\"text\",\"left\":10,\"top\":185,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"right\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"style\":\"\",\"time\":800,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":-1,\"height\":-1,\"serial\":\"1\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":29200,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true},{\"style\":\"\",\"text\":\"<div>Image 3<\\/div>\",\"type\":\"image\",\"image_url\":\"http:\\/\\/inthe7heaven.com\\/reviver\\/images\\/Iviewgallery\\/slide5_1.png\",\"left\":10,\"top\":270,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"right\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"time\":1100,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":0,\"height\":4,\"serial\":\"2\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":28900,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true},{\"style\":\"\",\"text\":\"Image 4\",\"type\":\"image\",\"image_url\":\"http:\\/\\/inthe7heaven.com\\/reviver\\/images\\/Iviewgallery\\/slide5_2.png\",\"left\":120,\"top\":270,\"animation\":\"tp-fade\",\"easing\":\"Power3.easeInOut\",\"split\":\"none\",\"endsplit\":\"none\",\"splitdelay\":\"10\",\"endsplitdelay\":\"10\",\"max_height\":\"auto\",\"max_width\":\"auto\",\"whitespace\":\"nowrap\",\"speed\":300,\"align_hor\":\"center\",\"align_vert\":\"top\",\"hiddenunder\":false,\"resizeme\":true,\"link\":\"\",\"link_open_in\":\"same\",\"link_slide\":\"nothing\",\"scrollunder_offset\":\"\",\"time\":1400,\"endtime\":\"\",\"endspeed\":300,\"endanimation\":\"auto\",\"endeasing\":\"nothing\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"width\":0,\"height\":4,\"serial\":\"3\",\"endTimeFinal\":29700,\"endSpeedFinal\":300,\"realEndTime\":30000,\"timeLast\":28600,\"alt\":\"\",\"scaleX\":\"\",\"scaleY\":\"\",\"scaleProportional\":false,\"attrID\":\"\",\"attrClasses\":\"\",\"attrTitle\":\"\",\"attrRel\":\"\",\"loop_animation\":\"none\",\"loop_easing\":\"Power3.easeInOut\",\"loop_speed\":\"2\",\"loop_startdeg\":\"-20\",\"loop_enddeg\":\"20\",\"loop_xorigin\":\"50\",\"loop_yorigin\":\"50\",\"loop_xstart\":\"0\",\"loop_xend\":\"0\",\"loop_ystart\":\"0\",\"loop_yend\":\"0\",\"loop_zoomstart\":\"1\",\"loop_zoomend\":\"1\",\"loop_angle\":\"0\",\"loop_radius\":\"10\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"parallax_level\":\"-\",\"static_start\":\"1\",\"static_end\":\"1\",\"endWithSlide\":true}]'),
(5, 1, 5, '{\"background_type\":\"trans\"}', '');

DROP TABLE IF EXISTS `#__revslider_static_slides`;
CREATE TABLE IF NOT EXISTS `#__revslider_static_slides` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE IF NOT EXISTS `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(21, '3.5.1'),
(700, '3.9.10-2019-07-09'),
(10250, '3.3-2018-06-28');

DROP TABLE IF EXISTS `#__spmedia`;
CREATE TABLE IF NOT EXISTS `#__spmedia` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `thumb` varchar(255) NOT NULL,
  `alt` varchar(255) NOT NULL,
  `caption` varchar(2048) NOT NULL,
  `description` mediumtext NOT NULL,
  `type` varchar(100) NOT NULL DEFAULT 'image',
  `extension` varchar(100) NOT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__sppagebuilder`;
CREATE TABLE IF NOT EXISTS `#__sppagebuilder` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `published` tinyint(3) NOT NULL DEFAULT 1,
  `catid` int(10) NOT NULL DEFAULT 0,
  `access` int(10) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT 0,
  `checked_out` int(10) NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL,
  `og_image` varchar(255) NOT NULL,
  `og_description` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `hits` bigint(20) NOT NULL DEFAULT 0,
  `css` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `#__sppagebuilder` (`id`, `title`, `text`, `extension`, `extension_view`, `view_id`, `active`, `published`, `catid`, `access`, `ordering`, `created_on`, `created_by`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `attribs`, `og_title`, `og_image`, `og_description`, `language`, `hits`, `css`) VALUES
(1, 'Home test', '[{\"id\":1542227599582,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1542227599579,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1542227800425,\"name\":\"accordion\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"panel-modern\",\"openitem\":\"\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"Accordion Title\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"},{\"title\":\"Accordion Title\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"},{\"title\":\"Accordion Title\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"},{\"title\":\"Accordion Title\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}],\"item_bg\":\"\",\"item_margin\":\"\",\"item_padding\":\"\",\"item_title_bg_color\":\"\",\"item_title_text_color\":\"\",\"item_title_fontsize\":\"\",\"item_title_lineheight\":\"\",\"item_title_letterspace\":\"0px\",\"item_title_padding\":\"\",\"icon_position\":\"\",\"icon_text_color\":\"\",\"icon_fontsize\":\"\",\"icon_margin\":\"\",\"item_content_padding\":\"\",\"active_title_bg_color\":\"\",\"active_title_text_color\":\"\",\"active_icon_rotate\":0,\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"0 0 20px 0\",\"xs\":\"0 0 10px 0\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\"}}]},{\"id\":1542227599580,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1542227800428,\"name\":\"articles_scroller\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"addon_style\":\"ticker\",\"resource\":\"article\",\"ordering\":\"latest\",\"image_bg\":0,\"slide_speed\":500,\"ticker_heading\":\"Breaking News\",\"ticker_heading_width\":\"\",\"ticker_heading_fontsize\":\"\",\"ticker_heading_font_weight\":\"\",\"show_shape\":1,\"heading_letter_spacing\":\"\",\"heading_shape\":\"arrow\",\"left_side_bg\":\"\",\"left_text_color\":\"\",\"overlap_date_text\":0,\"overlap_text_color\":\"\",\"overlap_text_font_size\":\"\",\"overlap_text_right\":\"\",\"content_bg\":\"\",\"right_title_font_size\":\"\",\"content_title_font_weight\":700,\"title_color\":\"\",\"intro_limit\":100,\"content_fontsize\":\"\",\"ticker_date_time\":0,\"ticker_date_hour\":0,\"text_color\":\"\",\"item_bottom_gap\":1,\"border_size\":0,\"border_color\":\"\",\"border_radius\":0,\"arrow_color\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"0 0 20px 0\",\"xs\":\"0 0 10px 0\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\"}}]},{\"id\":1542227599581,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1542227800431,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Feature Box\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-trophy\",\"icon_size\":{\"md\":36},\"icon_color\":\"#0080FE\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer adipiscing erat eget risus sollicitudin pellentesque et non erat. Maecenas nibh dolor, malesuada et bibendum a, sagittis accumsan ipsum.\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-center\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 30px 0\",\"sm\":\"0 0 20px 0\",\"xs\":\"0 0 10px 0\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}}]}]}]', 'com_sppagebuilder', 'page', 0, 0, 1, 0, 1, 0, '2018-11-14 20:33:34', 639, '2018-11-14 20:38:04', 639, 0, '0000-00-00 00:00:00', '[]', '', '', '', '*', 12, '');

DROP TABLE IF EXISTS `#__sppagebuilder_addons`;
CREATE TABLE IF NOT EXISTS `#__sppagebuilder_addons` (
  `id` int(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `code` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__sppagebuilder_integrations`;
CREATE TABLE IF NOT EXISTS `#__sppagebuilder_integrations` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `component` varchar(255) NOT NULL,
  `plugin` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__sppagebuilder_languages`;
CREATE TABLE IF NOT EXISTS `#__sppagebuilder_languages` (
  `id` int(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `lang_tag` varchar(255) NOT NULL DEFAULT '',
  `lang_key` varchar(100) DEFAULT NULL,
  `version` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__sppagebuilder_sections`;
CREATE TABLE IF NOT EXISTS `#__sppagebuilder_sections` (
  `id` int(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `section` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__tags`;
CREATE TABLE IF NOT EXISTS `#__tags` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `lft` int(11) NOT NULL DEFAULT 0,
  `rgt` int(11) NOT NULL DEFAULT 0,
  `level` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `path` varchar(400) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `checked_out` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `params` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8_unicode_ci NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `hits` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `language` char(7) COLLATE utf8_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__template_styles`;
CREATE TABLE IF NOT EXISTS `#__template_styles` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `home` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`) VALUES
(2, 'bluestork', 1, '0', 'Bluestork - Default', '{\"useRoundedCorners\":\"1\",\"showSiteName\":\"0\"}'),
(3, 'atomic', 0, '0', 'Atomic - Default', '{}'),
(4, 'beez_20', 0, '0', 'Beez2 - Default', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"logo\":\"images\\/joomla_black.gif\",\"sitetitle\":\"Joomla!\",\"sitedescription\":\"Open Source Content Management\",\"navposition\":\"left\",\"templatecolor\":\"personal\",\"html5\":\"0\"}'),
(5, 'hathor', 1, '0', 'Hathor - Default', '{\"showSiteName\":\"0\",\"colourChoice\":\"\",\"boldText\":\"0\"}'),
(6, 'beez5', 0, '0', 'Beez5 - Default', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"logo\":\"images\\/sampledata\\/fruitshop\\/fruits.gif\",\"sitetitle\":\"Joomla!\",\"sitedescription\":\"Open Source Content Management\",\"navposition\":\"left\",\"html5\":\"0\"}'),
(114, 'beez_20', 0, '0', 'Beez2 - Parks Site', '{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"logo\":\"\",\"sitetitle\":\"Australian Parks\",\"sitedescription\":\"Parks Sample Site\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}'),
(121, 't3_blank', 0, '1', 't3_blank - Default', '{\"animate\":\"0\",\"prodcartbtn\":\"1\",\"t3_template\":\"1\",\"devmode\":\"0\",\"themermode\":\"1\",\"responsive\":\"1\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"0\",\"minify_js\":\"0\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":null,\"link_titles\":null,\"theme\":\"\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"images\\/stories\\/logo.png\",\"enable_logoimage_sm\":\"0\",\"logoimage_sm\":\"\",\"mainlayout\":\"default\",\"sublayout\":\"\",\"navigation_trigger\":\"hover\",\"navigation_collapse_offcanvas\":\"1\",\"navigation_collapse_showsub\":\"1\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"zoom\",\"navigation_animation_duration\":\"400\",\"mm_type\":\"nav-menu\",\"mm_config\":\"{\\\"nav-menu\\\":{\\\"item-506\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":507,\\\"width\\\":12}]]}},\\\"item-525\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":526,\\\"width\\\":12}]]}},\\\"item-528\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1002,\\\"width\\\":3},{\\\"item\\\":1010,\\\"width\\\":3},{\\\"item\\\":1018,\\\"width\\\":3},{\\\"position\\\":\\\"125\\\",\\\"width\\\":3}]]},\\\"alignsub\\\":\\\"justify\\\"},\\\"item-1002\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1003,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1010\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1011,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1018\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1019,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-529\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1025,\\\"width\\\":12}]]}},\\\"item-561\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":562,\\\"width\\\":12}]]}},\\\"item-570\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":618,\\\"width\\\":12}]]}},\\\"item-565\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":647,\\\"width\\\":12}]]}}}}\",\"snippet_open_head\":null,\"snippet_close_head\":null,\"snippet_open_body\":null,\"snippet_close_body\":null,\"snippet_debug\":\"0\"}'),
(124, 't3_blank', 0, '0', 't3_blank - Home Right Sidebar', '{\"animate\":\"0\",\"prodcartbtn\":\"1\",\"t3_template\":\"1\",\"devmode\":\"0\",\"themermode\":\"1\",\"responsive\":\"1\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"0\",\"minify_js\":\"0\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":null,\"link_titles\":null,\"theme\":\"\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"\",\"enable_logoimage_sm\":\"0\",\"logoimage_sm\":\"\",\"mainlayout\":\"default-home2\",\"sublayout\":\"\",\"navigation_trigger\":\"hover\",\"navigation_collapse_offcanvas\":\"1\",\"navigation_collapse_showsub\":\"1\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"zoom\",\"navigation_animation_duration\":\"400\",\"mm_type\":\"nav-menu\",\"mm_config\":\"{\\\"nav-menu\\\":{\\\"item-506\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":507,\\\"width\\\":12}]]}},\\\"item-525\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":526,\\\"width\\\":12}]]}},\\\"item-528\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1002,\\\"width\\\":3},{\\\"item\\\":1010,\\\"width\\\":3},{\\\"item\\\":1018,\\\"width\\\":3},{\\\"position\\\":\\\"125\\\",\\\"width\\\":3}]]},\\\"alignsub\\\":\\\"justify\\\"},\\\"item-1002\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1003,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1010\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1011,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1018\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1019,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-529\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1025,\\\"width\\\":12}]]}},\\\"item-561\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":562,\\\"width\\\":12}]]}},\\\"item-570\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":618,\\\"width\\\":12}]]}},\\\"item-565\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":647,\\\"width\\\":12}]]}}}}\",\"snippet_open_head\":null,\"snippet_close_head\":null,\"snippet_open_body\":null,\"snippet_close_body\":null,\"snippet_debug\":\"0\"}'),
(125, 't3_blank', 0, '0', 't3_blank - Home Left Sidebar', '{\"animate\":\"0\",\"prodcartbtn\":\"1\",\"t3_template\":\"1\",\"devmode\":\"0\",\"themermode\":\"1\",\"responsive\":\"1\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"0\",\"minify_js\":\"0\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":null,\"link_titles\":null,\"theme\":\"\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"\",\"enable_logoimage_sm\":\"0\",\"logoimage_sm\":\"\",\"mainlayout\":\"default-home3\",\"sublayout\":\"\",\"navigation_trigger\":\"hover\",\"navigation_collapse_offcanvas\":\"1\",\"navigation_collapse_showsub\":\"1\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"zoom\",\"navigation_animation_duration\":\"400\",\"mm_type\":\"nav-menu\",\"mm_config\":\"{\\\"nav-menu\\\":{\\\"item-506\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":507,\\\"width\\\":12}]]}},\\\"item-525\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":526,\\\"width\\\":12}]]}},\\\"item-528\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1002,\\\"width\\\":3},{\\\"item\\\":1010,\\\"width\\\":3},{\\\"item\\\":1018,\\\"width\\\":3},{\\\"position\\\":\\\"125\\\",\\\"width\\\":3}]]},\\\"alignsub\\\":\\\"justify\\\"},\\\"item-1002\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1003,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1010\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1011,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1018\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1019,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-529\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1025,\\\"width\\\":12}]]}},\\\"item-561\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":562,\\\"width\\\":12}]]}},\\\"item-570\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":618,\\\"width\\\":12}]]}},\\\"item-565\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":647,\\\"width\\\":12}]]}}}}\",\"snippet_open_head\":null,\"snippet_close_head\":null,\"snippet_open_body\":null,\"snippet_close_body\":null,\"snippet_debug\":\"0\"}'),
(127, 't3_blank', 0, '0', 't3_blank - Home', '{\"animate\":\"0\",\"prodcartbtn\":\"1\",\"t3_template\":\"1\",\"devmode\":\"0\",\"themermode\":\"1\",\"responsive\":\"1\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"0\",\"minify_js\":\"0\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":null,\"link_titles\":null,\"theme\":\"\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"\",\"enable_logoimage_sm\":\"0\",\"logoimage_sm\":\"\",\"mainlayout\":\"default-home\",\"sublayout\":\"\",\"navigation_trigger\":\"hover\",\"navigation_collapse_offcanvas\":\"1\",\"navigation_collapse_showsub\":\"1\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"zoom\",\"navigation_animation_duration\":\"400\",\"mm_type\":\"nav-menu\",\"mm_config\":\"{\\\"nav-menu\\\":{\\\"item-506\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":507,\\\"width\\\":12}]]}},\\\"item-525\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":526,\\\"width\\\":12}]]}},\\\"item-528\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1002,\\\"width\\\":3},{\\\"item\\\":1010,\\\"width\\\":3},{\\\"item\\\":1018,\\\"width\\\":3},{\\\"position\\\":\\\"125\\\",\\\"width\\\":3}]]},\\\"alignsub\\\":\\\"justify\\\"},\\\"item-1002\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1003,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1010\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1011,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1018\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1019,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-529\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1025,\\\"width\\\":12}]]}},\\\"item-561\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":562,\\\"width\\\":12}]]}},\\\"item-570\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":618,\\\"width\\\":12}]]}},\\\"item-565\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":647,\\\"width\\\":12}]]}}}}\",\"snippet_open_head\":null,\"snippet_close_head\":null,\"snippet_open_body\":null,\"snippet_close_body\":null,\"snippet_debug\":\"0\"}'),
(128, 't3_blank', 0, '0', 't3_blank - Blue', '{\"t3_template\":\"1\",\"devmode\":\"0\",\"themermode\":\"1\",\"responsive\":\"1\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"0\",\"minify_js\":\"0\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":null,\"theme\":\"themeblue\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"images\\/stories\\/logo_blue.png\",\"mainlayout\":\"hom-boxed\",\"navigation_trigger\":\"hover\",\"navigation_collapse_offcanvas\":\"1\",\"navigation_collapse_showsub\":\"1\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"zoom\",\"navigation_animation_duration\":\"400\",\"mm_type\":\"nav-menu\",\"mm_config\":\"{\\\"nav-menu\\\":{\\\"item-506\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":507,\\\"width\\\":12}]]}},\\\"item-525\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":526,\\\"width\\\":12}]]}},\\\"item-528\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1002,\\\"width\\\":3},{\\\"item\\\":1010,\\\"width\\\":3},{\\\"item\\\":1018,\\\"width\\\":3},{\\\"position\\\":\\\"125\\\",\\\"width\\\":3}]]},\\\"alignsub\\\":\\\"justify\\\"},\\\"item-1002\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1003,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1010\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1011,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1018\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1019,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-529\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1025,\\\"width\\\":12}]]}},\\\"item-561\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":562,\\\"width\\\":12}]]}},\\\"item-570\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":618,\\\"width\\\":12}]]}},\\\"item-565\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":647,\\\"width\\\":12}]]}}}}\",\"snippet_open_head\":null,\"snippet_close_head\":null,\"snippet_open_body\":null,\"snippet_close_body\":null,\"snippet_debug\":\"0\",\"mm_config_needupdate\":\"\",\"link_titles\":null,\"animate\":\"0\",\"prodcartbtn\":\"1\"}'),
(129, 't3_blank', 0, '0', 't3_blank - Green', '{\"t3_template\":\"1\",\"devmode\":\"0\",\"themermode\":\"1\",\"responsive\":\"1\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"0\",\"minify_js\":\"0\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":null,\"theme\":\"themagreen\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"images\\/stories\\/logo_green.png\",\"mainlayout\":\"default-home\",\"navigation_trigger\":\"hover\",\"navigation_collapse_offcanvas\":\"1\",\"navigation_collapse_showsub\":\"1\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"zoom\",\"navigation_animation_duration\":\"400\",\"mm_type\":\"nav-menu\",\"mm_config\":\"{\\\"nav-menu\\\":{\\\"item-506\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":507,\\\"width\\\":12}]]}},\\\"item-525\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":526,\\\"width\\\":12}]]}},\\\"item-528\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1002,\\\"width\\\":3},{\\\"item\\\":1010,\\\"width\\\":3},{\\\"item\\\":1018,\\\"width\\\":3},{\\\"position\\\":\\\"125\\\",\\\"width\\\":3}]]},\\\"alignsub\\\":\\\"justify\\\"},\\\"item-1002\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1003,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1010\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1011,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1018\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1019,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-529\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1025,\\\"width\\\":12}]]}},\\\"item-561\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":562,\\\"width\\\":12}]]}},\\\"item-570\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":618,\\\"width\\\":12}]]}},\\\"item-565\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":647,\\\"width\\\":12}]]}}}}\",\"snippet_open_head\":null,\"snippet_close_head\":null,\"snippet_open_body\":null,\"snippet_close_body\":null,\"snippet_debug\":\"0\",\"mm_config_needupdate\":\"\",\"link_titles\":null,\"animate\":\"0\",\"prodcartbtn\":\"1\"}'),
(130, 't3_blank', 0, '0', 't3_blank - Orange', '{\"t3_template\":\"1\",\"devmode\":\"0\",\"themermode\":\"1\",\"responsive\":\"1\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"0\",\"minify_js\":\"0\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":null,\"theme\":\"themaorange\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"images\\/stories\\/logo_orange.png\",\"mainlayout\":\"default-home\",\"navigation_trigger\":\"hover\",\"navigation_collapse_offcanvas\":\"1\",\"navigation_collapse_showsub\":\"1\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"zoom\",\"navigation_animation_duration\":\"400\",\"mm_type\":\"nav-menu\",\"mm_config\":\"{\\\"nav-menu\\\":{\\\"item-506\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":507,\\\"width\\\":12}]]}},\\\"item-525\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":526,\\\"width\\\":12}]]}},\\\"item-528\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1002,\\\"width\\\":3},{\\\"item\\\":1010,\\\"width\\\":3},{\\\"item\\\":1018,\\\"width\\\":3},{\\\"position\\\":\\\"125\\\",\\\"width\\\":3}]]},\\\"alignsub\\\":\\\"justify\\\"},\\\"item-1002\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1003,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1010\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1011,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1018\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1019,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-529\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1025,\\\"width\\\":12}]]}},\\\"item-561\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":562,\\\"width\\\":12}]]}},\\\"item-570\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":618,\\\"width\\\":12}]]}},\\\"item-565\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":647,\\\"width\\\":12}]]}}}}\",\"snippet_open_head\":null,\"snippet_close_head\":null,\"snippet_open_body\":null,\"snippet_close_body\":null,\"snippet_debug\":\"0\",\"mm_config_needupdate\":\"\",\"link_titles\":null,\"animate\":\"0\",\"prodcartbtn\":\"1\"}'),
(131, 't3_blank', 0, '0', 't3_blank - boxed', '{\"animate\":\"0\",\"prodcartbtn\":\"1\",\"t3_template\":\"1\",\"devmode\":\"0\",\"themermode\":\"1\",\"responsive\":\"1\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"0\",\"minify_js\":\"0\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":null,\"link_titles\":null,\"theme\":\"\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"\",\"enable_logoimage_sm\":\"0\",\"logoimage_sm\":\"\",\"mainlayout\":\"boxed-default\",\"sublayout\":\"\",\"navigation_trigger\":\"hover\",\"navigation_collapse_offcanvas\":\"1\",\"navigation_collapse_showsub\":\"1\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"zoom\",\"navigation_animation_duration\":\"400\",\"mm_type\":\"nav-menu\",\"mm_config\":\"{\\\"nav-menu\\\":{\\\"item-506\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":507,\\\"width\\\":12}]]}},\\\"item-525\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":526,\\\"width\\\":12}]]}},\\\"item-528\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1002,\\\"width\\\":3},{\\\"item\\\":1010,\\\"width\\\":3},{\\\"item\\\":1018,\\\"width\\\":3},{\\\"position\\\":\\\"125\\\",\\\"width\\\":3}]]},\\\"alignsub\\\":\\\"justify\\\"},\\\"item-1002\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1003,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1010\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1011,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1018\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1019,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-529\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1025,\\\"width\\\":12}]]}},\\\"item-561\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":562,\\\"width\\\":12}]]}},\\\"item-570\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":618,\\\"width\\\":12}]]}},\\\"item-565\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":647,\\\"width\\\":12}]]}}}}\",\"snippet_open_head\":null,\"snippet_close_head\":null,\"snippet_open_body\":null,\"snippet_close_body\":null,\"snippet_debug\":\"0\"}'),
(132, 't3_blank', 0, '0', 't3_blank - Boxed Default', '{\"animate\":\"0\",\"prodcartbtn\":\"1\",\"t3_template\":\"1\",\"devmode\":\"0\",\"themermode\":\"1\",\"responsive\":\"1\",\"build_rtl\":\"0\",\"t3-assets\":\"t3-assets\",\"t3-rmvlogo\":\"1\",\"minify\":\"0\",\"minify_js\":\"0\",\"minify_js_tool\":\"jsmin\",\"minify_exclude\":null,\"link_titles\":null,\"theme\":\"\",\"logotype\":\"image\",\"sitename\":\"\",\"slogan\":\"\",\"logoimage\":\"images\\/stories\\/logo.png\",\"enable_logoimage_sm\":\"0\",\"logoimage_sm\":\"\",\"mainlayout\":\"boxed-default\",\"sublayout\":\"\",\"navigation_trigger\":\"hover\",\"navigation_collapse_offcanvas\":\"1\",\"navigation_collapse_showsub\":\"1\",\"navigation_type\":\"megamenu\",\"navigation_animation\":\"zoom\",\"navigation_animation_duration\":\"400\",\"mm_type\":\"nav-menu\",\"mm_config\":\"{\\\"nav-menu\\\":{\\\"item-506\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":507,\\\"width\\\":12}]]}},\\\"item-525\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":526,\\\"width\\\":12}]]}},\\\"item-528\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1002,\\\"width\\\":3},{\\\"item\\\":1010,\\\"width\\\":3},{\\\"item\\\":1018,\\\"width\\\":3},{\\\"position\\\":\\\"125\\\",\\\"width\\\":3}]]},\\\"alignsub\\\":\\\"justify\\\"},\\\"item-1002\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1003,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1010\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1011,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-1018\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1019,\\\"width\\\":12}]]},\\\"group\\\":1},\\\"item-529\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":1025,\\\"width\\\":12}]]}},\\\"item-561\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":562,\\\"width\\\":12}]]}},\\\"item-570\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":618,\\\"width\\\":12}]]}},\\\"item-565\\\":{\\\"sub\\\":{\\\"rows\\\":[[{\\\"item\\\":647,\\\"width\\\":12}]]}}}}\",\"snippet_open_head\":null,\"snippet_close_head\":null,\"snippet_open_body\":null,\"snippet_close_body\":null,\"snippet_debug\":\"0\"}'),
(133, 'protostar', 0, '0', 'protostar - Default', '{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}'),
(134, 'isis', 1, '1', 'isis - Default', '{\"templateColor\":\"\",\"logoFile\":\"\"}'),
(135, 'beez3', 0, '0', 'beez3 - Default', '{\"wrapperSmall\":53,\"wrapperLarge\":72,\"logo\":\"\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"bootstrap\":\"\",\"templatecolor\":\"nature\",\"headerImage\":\"\",\"backgroundcolor\":\"#eee\"}');

DROP TABLE IF EXISTS `#__ucm_base`;
CREATE TABLE IF NOT EXISTS `#__ucm_base` (
  `ucm_id` int(10) UNSIGNED NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__ucm_content`;
CREATE TABLE IF NOT EXISTS `#__ucm_content` (
  `core_content_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT 0,
  `core_checked_out_time` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_checked_out_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `core_access` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `core_params` text COLLATE utf8_unicode_ci NOT NULL,
  `core_featured` tinyint(4) UNSIGNED NOT NULL DEFAULT 0,
  `core_metadata` varchar(2048) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `core_created_by_alias` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_content_item_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'ID from the individual type table',
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8_unicode_ci NOT NULL,
  `core_urls` text COLLATE utf8_unicode_ci NOT NULL,
  `core_hits` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `core_version` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `core_ordering` int(11) NOT NULL DEFAULT 0,
  `core_metakey` text COLLATE utf8_unicode_ci NOT NULL,
  `core_metadesc` text COLLATE utf8_unicode_ci NOT NULL,
  `core_catid` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `core_xreference` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_language` (`core_language`),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_content_type` (`core_type_alias`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Contains core content data in name spaced fields';

DROP TABLE IF EXISTS `#__ucm_history`;
CREATE TABLE IF NOT EXISTS `#__ucm_history` (
  `version_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `ucm_item_id` int(10) UNSIGNED NOT NULL,
  `ucm_type_id` int(10) UNSIGNED NOT NULL,
  `version_note` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `character_count` int(10) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

DROP TABLE IF EXISTS `#__updates`;
CREATE TABLE IF NOT EXISTS `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `extension_id` int(11) DEFAULT 0,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `description` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT 0,
  `version` varchar(32) COLLATE utf8_unicode_ci DEFAULT '',
  `data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `detailsurl` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `infourl` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `extra_query` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Available Updates';

INSERT INTO `#__updates` (`update_id`, `update_site_id`, `extension_id`, `name`, `description`, `element`, `type`, `folder`, `client_id`, `version`, `data`, `detailsurl`, `infourl`, `extra_query`) VALUES
(2, 1, 0, 'Joomla', '', 'joomla', 'file', '', 0, '3.9.11', '', 'https://update.joomla.org/core/sts/extension_sts.xml', '', ''),
(3, 1, 0, 'Joomla', '', 'joomla', 'file', '', 0, '3.9.11', '', 'https://update.joomla.org/core/sts/extension_sts.xml', '', ''),
(4, 88, 0, 'VirtueMart - Shipment, by Weight, country, zip,... ', 'VirtueMart - Shipment, Shipment, by Weight, country, zip,... ', 'standard', 'plugin', 'vmshipment', 0, '3.4.0', '', 'http://virtuemart.net/releases/vm3/plg_vmshipment_weight_countries_update.xml', 'https://docs.virtuemart.net/tutorials/installation-migration-upgrade/226-update-single-plugin-delivered-by-aio.html', '');

DROP TABLE IF EXISTS `#__update_sites`;
CREATE TABLE IF NOT EXISTS `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8_unicode_ci DEFAULT '',
  `location` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  `extra_query` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Update Sites';

INSERT INTO `#__update_sites` (`update_site_id`, `name`, `type`, `location`, `enabled`, `last_check_timestamp`, `extra_query`) VALUES
(1, '', 'collection', 'https://update.joomla.org/core/list.xml', 1, 1566224958, ''),
(3, '', 'collection', 'http://update.joomlart.com/service/tracking/list.xml', 0, 0, ''),
(4, 'VirtueMart Update Site', 'extension', 'http://virtuemart.net/releases/vm3/virtuemart_update.xml', 0, 0, ''),
(11, 'VirtueMart plg_vmpayment_paybox Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_paybox_update.xml', 0, 0, ''),
(13, 'VirtueMart plg_vmpayment_moneybookers Update Site', 'extension', 'http://virtuemart.net/releases/vm2/plg_vmpayment_moneybookers_update.xml', 0, 0, ''),
(14, 'VirtueMart plg_vmpayment_moneybookers_acc Update Site', 'extension', 'http://virtuemart.net/releases/vm2/plg_vmpayment_moneybookers_acc_update.xml', 0, 0, ''),
(15, 'VirtueMart plg_vmpayment_moneybookers_did Update Site', 'extension', 'http://virtuemart.net/releases/vm2/plg_vmpayment_moneybookers_did_update.xml', 0, 0, ''),
(16, 'VirtueMart plg_vmpayment_moneybookers_idl Update Site', 'extension', 'http://virtuemart.net/releases/vm2/plg_vmpayment_moneybookers_idl_update.xml', 0, 0, ''),
(17, 'VirtueMart plg_vmpayment_moneybookers_gir Update Site', 'extension', 'http://virtuemart.net/releases/vm2/plg_vmpayment_moneybookers_gir_update.xml', 0, 0, ''),
(18, 'VirtueMart plg_vmpayment_moneybookers_sft Update Site', 'extension', 'http://virtuemart.net/releases/vm2/plg_vmpayment_moneybookers_sft_update.xml', 0, 0, ''),
(19, 'VirtueMart plg_vmpayment_moneybookers_pwy Update Site', 'extension', 'http://virtuemart.net/releases/vm2/plg_vmpayment_moneybookers_pwy_update.xml', 0, 0, ''),
(20, 'VirtueMart plg_vmpayment_moneybookers_obt Update Site', 'extension', 'http://virtuemart.net/releases/vm2/plg_vmpayment_moneybookers_obt_update.xml', 0, 0, ''),
(21, 'VirtueMart plg_vmpayment_moneybookers_wlt Update Site', 'extension', 'http://virtuemart.net/releases/vm2/plg_vmpayment_moneybookers_wlt_update.xml', 0, 0, ''),
(25, 'VirtueMart plg_vmcustom_textinput Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmcustom_textinput_update.xml', 0, 0, ''),
(27, 'VirtueMart plg_vmcalculation_avalara Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmcalculation_avalara_update.xml', 0, 0, ''),
(29, 'VirtueMart mod_virtuemart_currencies Update Site', 'extension', 'http://virtuemart.net/releases/vm3/mod_virtuemart_currencies_update.xml', 0, 0, ''),
(30, 'VirtueMart mod_virtuemart_search Update Site', 'extension', 'http://virtuemart.net/releases/vm3/mod_virtuemart_search_update.xml', 0, 0, ''),
(31, 'VirtueMart AIO Update Site', 'extension', 'http://virtuemart.net/releases/vm2/virtuemart_aio_update.xml', 0, 0, ''),
(32, 'VirtueMart3 Update Site', 'extension', 'http://virtuemart.net/releases/vm3/virtuemart_update.xml', 0, 0, ''),
(35, 'VirtueMart3 AIO Update Site', 'extension', 'http://virtuemart.net/releases/vm3/virtuemart_aio_update.xml', 0, 0, ''),
(38, 'Xmap Update Site', 'extension', 'https://raw.github.com/guilleva/Xmap/master/xmap-update.xml', 0, 0, ''),
(40, 'Joomla! Update Component Update Site', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', 0, 0, ''),
(41, '', 'collection', 'http://update.joomla.org/jed/list.xml', 0, 0, ''),
(44, 'VirtueMart3 MOD_VMENU Update Site', 'extension', 'http://virtuemart.net/releases/vm3/mod_vmmenu_update.xml', 0, 0, ''),
(45, 'VirtueMart plg_vmpayment_klickandpay Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_klikandpay_update.xml', 0, 0, ''),
(47, 'Weblinks Update Site', 'extension', 'https://raw.githubusercontent.com/joomla-extensions/weblinks/master/manifest.xml', 0, 0, ''),
(51, 'TCPDF Update Site', 'extension', 'http://virtuemart.net/releases/TCPDF/tcpdf.xml', 1, 1566224959, ''),
(56, 'Plugin Googlemap Update Site', 'extension', 'https://raw.githubusercontent.com/jmosmap/plugin_googlemaps/master/update/extension.xml', 1, 1566224959, NULL),
(58, 'VMOnepage Update Site', 'extension', 'http://vmonepage.com/releases/vmonepage_update.xml', 0, 0, ''),
(60, 'VM Framework Loader during Plugin Updates', 'extension', 'http://virtuemart.net/releases/vm3/plg_system_vmLoaderPluginUpdate_update.xml', 0, 0, ''),
(61, 'VirtueMart3 mod_virtuemart_product Update Site', 'extension', 'http://virtuemart.net/releases/vm3/mod_virtuemart_product_update.xml', 0, 0, ''),
(62, 'VirtueMart3 mod_virtuemart_manufacturer Update Site', 'extension', 'http://virtuemart.net/releases/vm3/mod_virtuemart_manufacturer_update.xml', 0, 0, ''),
(63, 'VirtueMart3 mod_virtuemart_cart Update Site', 'extension', 'http://virtuemart.net/releases/vm3/mod_virtuemart_cart_update.xml', 0, 0, ''),
(64, 'VirtueMart3 mod_virtuemart_category Update Site', 'extension', 'http://virtuemart.net/releases/vm3/mod_virtuemart_category_update.xml', 0, 0, ''),
(65, 'Unite Slider', 'extension', 'http://unitecms.net/update/unite-slider.xml', 0, 0, ''),
(66, 'VirtueMart One Page Checkout', 'extension', 'http://joomlaprox.com/index.php?option=com_rdsubs&view=updater&cat=4&type=3&format=xml', 0, 0, ''),
(67, 'VirtueMart One Page Checkout', 'extension', 'http://joomlapro.com/index.php?option=com_rdsubs&view=updater&cat=4&type=3&format=xml', 0, 0, ''),
(69, 'JCH Optimize Updates', 'extension', 'https://www.jch-optimize.net/index.php?option=com_ars&view=update&task=stream&format=xml&id=2&file=extension.xml', 1, 1566224961, ''),
(73, '', 'extension', 'http://update.joomlart.com/service/tracking/j16/plg_system_t3.xml', 1, 1566224961, ''),
(74, 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro.xml', 1, 1566224961, ''),
(75, 'VirtueMart plg_vmpayment_standard Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_standard_update.xml', 1, 1566224961, ''),
(76, 'VirtueMart plg_vmpayment_paypal Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_paypal_update.xml', 1, 1566224962, ''),
(77, 'VirtueMart plg_vmpayment_sofort Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_sofort_update.xml', 1, 1566224962, ''),
(78, 'VirtueMart3 plg_vmpayment_skrill Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_skrill_update.xml', 1, 1566224962, ''),
(79, 'VirtueMart plg_vmpayment_klarna Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_klarna_update.xml', 1, 1566224963, ''),
(80, 'VirtueMart plg_vmpayment_klarnacheckout Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_klarnacheckout_update.xml', 1, 1566224963, ''),
(81, 'VirtueMart plg_vmpayment_heidelpay Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_heidelpay_update.xml', 1, 1566224963, ''),
(82, 'VirtueMart3 plg_vmpayment_tco Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_tco_update.xml', 1, 1566224963, ''),
(83, 'VirtueMart plg_vmpayment_eway Update Site', 'extension', '\n            http://virtuemart.net/releases/vm3/plg_vmpayment_eway_update.xml', 1, 1566224965, ''),
(84, 'VirtueMart plg_vmpayment_realex_hpp_api Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_realex_hpp_api_update.xml', 1, 1566224966, ''),
(85, 'VirtueMart plg_vmuserfield_realex_hpp_api Update Site', 'extension', '\n            http://virtuemart.net/releases/vm3/plg_vmuserfield_realex_hpp_api_update.xml', 1, 1566224966, ''),
(86, 'VirtueMart plg_vmpayment_authorizenet Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_authorisenet_update.xml', 1, 1566224966, ''),
(87, 'VirtueMart plg_vmpayment_sofort_ideal Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmpayment_sofort_ideal_update.xml', 1, 1566224967, ''),
(88, 'VirtueMart3 plg_vmshipment_weight_countries Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmshipment_weight_countries_update.xml', 1, 1566224967, ''),
(89, 'VirtueMart3 plg_vmcustom_specification Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_vmcustom_specification_update.xml', 1, 1566224967, ''),
(90, 'VirtueMart, ${PHING.COMPANY} - ${PHING.NAME.EXTSHORT} - Update Site', 'extension', 'http://extensions.virtuemart.net/releases/${PHING.COMPANY}/${PHING.COMPANY}_${PHING.PKG.PREFIX}${PHING.VMVERSION}_${PHING.NAME.EXTSHORT}.xml', 1, 1566224968, ''),
(91, 'VirtueMart3 plg_search_virtuemart Update Site', 'extension', 'http://virtuemart.net/releases/vm3/plg_search_virtuemart_update.xml', 1, 1566224968, ''),
(92, 'JCH Optimize Updates', 'extension', 'https://www.jch-optimize.net/index.php?option=com_ars&view=update&task=stream&format=xml&id=5&file=extension.xml', 1, 1566224969, ''),
(93, 'jQuery Easy auto updater', 'extension', 'https://updates.simplifyyourweb.com/free/jqueryeasy/jqueryeasy-v2-update.xml', 1, 1566224969, '');

DROP TABLE IF EXISTS `#__update_sites_extensions`;
CREATE TABLE IF NOT EXISTS `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Links extensions to update sites';

INSERT INTO `#__update_sites_extensions` (`update_site_id`, `extension_id`) VALUES
(1, 700),
(1, 10000),
(3, 10000),
(4, 10181),
(11, 10193),
(13, 10180),
(14, 10016),
(15, 10017),
(16, 10018),
(17, 10019),
(18, 10020),
(19, 10021),
(20, 10022),
(21, 10023),
(25, 10028),
(27, 10031),
(29, 10033),
(30, 10035),
(31, 10129),
(32, 10181),
(35, 10129),
(38, 10149),
(40, 28),
(41, 700),
(44, 10187),
(45, 10230),
(47, 801),
(51, 10241),
(56, 10247),
(58, 10248),
(60, 10257),
(61, 10034),
(62, 10036),
(63, 10130),
(64, 10038),
(65, 10186),
(66, 10248),
(67, 10248),
(69, 10261),
(73, 10000),
(74, 10250),
(75, 10012),
(76, 10013),
(77, 10158),
(78, 10199),
(79, 10025),
(80, 10167),
(81, 10026),
(82, 10246),
(83, 10266),
(84, 10196),
(85, 10197),
(86, 10024),
(87, 10163),
(88, 10027),
(89, 10029),
(90, 10267),
(91, 10032),
(92, 10262),
(93, 10096);

DROP TABLE IF EXISTS `#__utf8_conversion`;
CREATE TABLE IF NOT EXISTS `#__utf8_conversion` (
  `converted` tinyint(4) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__utf8_conversion` (`converted`) VALUES
(2);

DROP TABLE IF EXISTS `#__viewlevels`;
CREATE TABLE IF NOT EXISTS `#__viewlevels` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) COLLATE utf8_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `#__viewlevels` (`id`, `title`, `ordering`, `rules`) VALUES
(1, 'Public', 0, '[1]'),
(2, 'Registered', 1, '[6,2,8]'),
(3, 'Special', 2, '[6,3,8]'),
(4, 'Customer Access Level (Example)', 3, '[6,3,12]');

DROP TABLE IF EXISTS `#__virtuemart_adminmenuentries`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_adminmenuentries` (
  `id` tinyint(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `module_id` tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'THE ID OF THE VM MODULE, THIS ITEM IS ASSIGNED TO',
  `parent_id` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `name` char(64) NOT NULL DEFAULT '0',
  `link` char(64) NOT NULL DEFAULT '0',
  `depends` char(64) NOT NULL DEFAULT '' COMMENT 'Names of the Parameters, this Item depends on',
  `icon_class` char(96) DEFAULT NULL,
  `ordering` int(1) NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `tooltip` char(128) DEFAULT NULL,
  `view` char(32) DEFAULT NULL,
  `task` char(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `published` (`published`),
  KEY `ordering` (`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COMMENT='Administration Menu Items';

INSERT INTO `#__virtuemart_adminmenuentries` (`id`, `module_id`, `parent_id`, `name`, `link`, `depends`, `icon_class`, `ordering`, `published`, `tooltip`, `view`, `task`) VALUES
(1, 1, 0, 'COM_VIRTUEMART_CATEGORY_S', '', '', 'vmicon vmicon-16-folder_camera', 1, 1, '', 'category', ''),
(2, 1, 0, 'COM_VIRTUEMART_PRODUCT_S', '', '', 'vmicon vmicon-16-camera', 2, 1, '', 'product', ''),
(3, 1, 0, 'COM_VIRTUEMART_PRODUCT_CUSTOM_FIELD_S', '', '', 'vmicon vmicon-16-document_move', 5, 1, '', 'custom', ''),
(4, 1, 0, 'COM_VIRTUEMART_PRODUCT_INVENTORY', '', '', 'vmicon vmicon-16-price_watch', 7, 1, '', 'inventory', ''),
(5, 1, 0, 'COM_VIRTUEMART_CALC_S', '', '', 'vmicon vmicon-16-calculator', 8, 1, '', 'calc', ''),
(6, 1, 0, 'COM_VIRTUEMART_REVIEW_RATE_S', '', '', 'vmicon vmicon-16-comments', 9, 1, '', 'ratings', ''),
(7, 2, 0, 'COM_VIRTUEMART_ORDER_S', '', '', 'vmicon vmicon-16-page_white_stack', 1, 1, '', 'orders', ''),
(8, 2, 0, 'COM_VIRTUEMART_COUPON_S', '', '', 'vmicon vmicon-16-shopping', 10, 1, '', 'coupon', ''),
(9, 2, 0, 'COM_VIRTUEMART_REPORT', '', '', 'vmicon vmicon-16-chart_bar', 3, 1, '', 'report', ''),
(10, 2, 0, 'COM_VIRTUEMART_USER_S', '', '', 'vmicon vmicon-16-user', 4, 1, '', 'user', ''),
(11, 2, 0, 'COM_VIRTUEMART_SHOPPERGROUP_S', '', '', 'vmicon vmicon-16-user-group', 5, 1, '', 'shoppergroup', ''),
(12, 3, 0, 'COM_VIRTUEMART_MANUFACTURER_S', '', '', 'vmicon vmicon-16-wrench_orange', 1, 1, '', 'manufacturer', ''),
(13, 3, 0, 'COM_VIRTUEMART_MANUFACTURER_CATEGORY_S', '', '', 'vmicon vmicon-16-folder_wrench', 2, 1, '', 'manufacturercategories', ''),
(14, 4, 0, 'COM_VIRTUEMART_STORE', '', '', 'vmicon vmicon-16-reseller_account_template', 1, 1, '', 'user', 'editshop'),
(15, 4, 0, 'COM_VIRTUEMART_MEDIA_S', '', '', 'vmicon vmicon-16-pictures', 2, 1, '', 'media', ''),
(16, 4, 0, 'COM_VIRTUEMART_SHIPMENTMETHOD_S', '', '', 'vmicon vmicon-16-lorry', 3, 1, '', 'shipmentmethod', ''),
(17, 4, 0, 'COM_VIRTUEMART_PAYMENTMETHOD_S', '', '', 'vmicon vmicon-16-creditcards', 4, 1, '', 'paymentmethod', ''),
(18, 5, 0, 'COM_VIRTUEMART_CONFIGURATION', '', '', 'vmicon vmicon-16-config', 1, 1, '', 'config', ''),
(19, 5, 0, 'COM_VIRTUEMART_USERFIELD_S', '', '', 'vmicon vmicon-16-participation_rate', 2, 1, '', 'userfields', ''),
(20, 5, 0, 'COM_VIRTUEMART_ORDERSTATUS_S', '', '', 'vmicon vmicon-16-document_editing', 3, 1, '', 'orderstatus', ''),
(21, 5, 0, 'COM_VIRTUEMART_CURRENCY_S', '', '', 'vmicon vmicon-16-coins', 5, 1, '', 'currency', ''),
(22, 5, 0, 'COM_VIRTUEMART_COUNTRY_S', '', '', 'vmicon vmicon-16-globe', 6, 1, '', 'country', ''),
(23, 11, 0, 'COM_VIRTUEMART_MIGRATION_UPDATE', '', '', 'vmicon vmicon-16-installer_box', 0, 1, '', 'updatesmigration', ''),
(24, 11, 0, 'COM_VIRTUEMART_ABOUT', '', '', 'vmicon vmicon-16-info', 10, 1, '', 'about', ''),
(25, 11, 0, 'COM_VIRTUEMART_HELP_TOPICS', 'http://docs.virtuemart.net/', '', 'vmicon vmicon-16-help', 5, 1, '', '', ''),
(26, 11, 0, 'COM_VIRTUEMART_COMMUNITY_FORUM', 'http://forum.virtuemart.net/', '', 'vmicon vmicon-16-reseller_programm', 7, 1, '', '', ''),
(27, 11, 0, 'COM_VIRTUEMART_STATISTIC_SUMMARY', '', '', 'vmicon vmicon-16-info', 1, 1, '', 'virtuemart', ''),
(28, 77, 0, 'COM_VIRTUEMART_USER_GROUP_S', '', '', 'vmicon vmicon-16-user', 2, 1, '', 'usergroups', ''),
(29, 11, 0, 'COM_VIRTUEMART_LOG', '', '', 'vmicon vmicon-16-info', 2, 1, '', 'log', ''),
(30, 11, 0, 'COM_VIRTUEMART_SUPPORT', '', '', 'vmicon vmicon-16-help', 3, 1, '', 'support', '');

DROP TABLE IF EXISTS `#__virtuemart_calcs`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_calcs` (
  `virtuemart_calc_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT 'BELONGS TO VENDOR',
  `calc_jplugin_id` int(1) NOT NULL DEFAULT 0,
  `calc_name` varchar(64) NOT NULL DEFAULT '' COMMENT 'NAME OF THE RULE',
  `calc_descr` varchar(128) NOT NULL DEFAULT '' COMMENT 'DESCRIPTION',
  `calc_kind` varchar(16) NOT NULL DEFAULT '' COMMENT 'DISCOUNT/TAX/MARGIN/COMMISSION',
  `calc_value_mathop` varchar(8) NOT NULL DEFAULT '' COMMENT 'THE MATHEMATICAL OPERATION LIKE (+,-,+%,-%)',
  `calc_value` decimal(10,4) NOT NULL DEFAULT 0.0000 COMMENT 'The Amount',
  `calc_currency` smallint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'Currency of the Rule',
  `calc_shopper_published` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Visible for Shoppers',
  `calc_vendor_published` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Visible for Vendors',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Startdate if nothing is set = permanent',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Enddate if nothing is set = permanent',
  `for_override` tinyint(1) NOT NULL DEFAULT 0,
  `calc_params` varchar(15359) NOT NULL DEFAULT '',
  `ordering` int(1) NOT NULL DEFAULT 0,
  `shared` tinyint(1) NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_calc_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `published` (`published`),
  KEY `calc_kind` (`calc_kind`),
  KEY `shared` (`shared`),
  KEY `publish_up` (`publish_up`),
  KEY `publish_down` (`publish_down`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_calcs` (`virtuemart_calc_id`, `virtuemart_vendor_id`, `calc_jplugin_id`, `calc_name`, `calc_descr`, `calc_kind`, `calc_value_mathop`, `calc_value`, `calc_currency`, `calc_shopper_published`, `calc_vendor_published`, `publish_up`, `publish_down`, `for_override`, `calc_params`, `ordering`, `shared`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 1, 0, 'Tax 21%', 'A simple tax for all products regardless the category', 'VatTax', '+%', '21.0000', 47, 0, 0, '2010-02-21 00:00:00', '0000-00-00 00:00:00', 0, 'activated=\"0\"|company_code=\"\"|account=\"\"|license=\"\"|committ=\"0\"|only_cart=\"1\"|dev=\"0\"|avatax_virtuemart_country_id=0|avatax_virtuemart_state_id=0|accrual=\"0\"|prevCheckoutAddInv=\"1\"|', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-09-15 10:36:27', 0, '0000-00-00 00:00:00', 0),
(2, 1, 0, 'Discount for all Hand Tools', 'Discount for all Hand Tools 2 euro', 'DATax', '-', '30.0000', 47, 0, 0, '2010-02-21 00:00:00', '0000-00-00 00:00:00', 0, 'activated=\"0\"|company_code=\"\"|account=\"\"|license=\"\"|committ=\"0\"|only_cart=\"1\"|dev=\"0\"|avatax_virtuemart_country_id=0|avatax_virtuemart_state_id=0|accrual=\"0\"|prevCheckoutAddInv=\"1\"|', 1, 0, 0, '0000-00-00 00:00:00', 0, '2013-09-02 18:31:26', 0, '0000-00-00 00:00:00', 0),
(3, 1, 0, 'Duty for Powertools', 'Ah tax that only effects a certain category, Power Tools, and Shoppergroup', 'Tax', '+%', '20.0000', 47, 0, 0, '2010-02-21 00:00:00', '0000-00-00 00:00:00', 0, 'activated=\"0\"|company_code=\"\"|account=\"\"|license=\"\"|committ=\"0\"|only_cart=\"1\"|dev=\"0\"|avatax_virtuemart_country_id=0|avatax_virtuemart_state_id=0|accrual=\"0\"|prevCheckoutAddInv=\"1\"|', 0, 0, 0, '0000-00-00 00:00:00', 0, '2013-09-02 18:31:20', 0, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_calc_categories`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_calc_categories` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_calc_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `virtuemart_calc_id` (`virtuemart_calc_id`,`virtuemart_category_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__virtuemart_calc_countries`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_calc_countries` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_calc_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_country_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `virtuemart_calc_id` (`virtuemart_calc_id`,`virtuemart_country_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__virtuemart_calc_manufacturers`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_calc_manufacturers` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_calc_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `virtuemart_calc_id` (`virtuemart_calc_id`,`virtuemart_manufacturer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__virtuemart_calc_shoppergroups`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_calc_shoppergroups` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_calc_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_shoppergroup_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `virtuemart_calc_id` (`virtuemart_calc_id`,`virtuemart_shoppergroup_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__virtuemart_calc_states`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_calc_states` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_calc_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_state_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `virtuemart_calc_id` (`virtuemart_calc_id`,`virtuemart_state_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__virtuemart_carts`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_carts` (
  `virtuemart_cart_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_user_id` int(1) UNSIGNED NOT NULL,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL,
  `cartData` varbinary(50000) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_cart_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `virtuemart_user_id` (`virtuemart_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to store the cart';

DROP TABLE IF EXISTS `#__virtuemart_categories`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_categories` (
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT 'BELONGS TO VENDOR',
  `category_template` varchar(128) DEFAULT NULL,
  `category_layout` varchar(64) DEFAULT NULL,
  `category_product_layout` varchar(64) DEFAULT NULL,
  `products_per_row` varchar(1) NOT NULL DEFAULT '',
  `limit_list_step` varchar(32) DEFAULT NULL,
  `limit_list_start` smallint(1) UNSIGNED DEFAULT NULL,
  `limit_list_max` smallint(1) UNSIGNED DEFAULT NULL,
  `limit_list_initial` smallint(1) UNSIGNED DEFAULT NULL,
  `hits` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `cat_params` varchar(15359) NOT NULL DEFAULT '',
  `metarobot` varchar(40) NOT NULL DEFAULT '',
  `metaauthor` varchar(64) NOT NULL DEFAULT '',
  `ordering` int(1) NOT NULL DEFAULT 0,
  `shared` tinyint(1) NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_category_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `published` (`published`),
  KEY `shared` (`shared`),
  KEY `ordering` (`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COMMENT='Product Categories are stored here';

INSERT INTO `#__virtuemart_categories` (`virtuemart_category_id`, `virtuemart_vendor_id`, `category_template`, `category_layout`, `category_product_layout`, `products_per_row`, `limit_list_step`, `limit_list_start`, `limit_list_max`, `limit_list_initial`, `hits`, `cat_params`, `metarobot`, `metaauthor`, `ordering`, `shared`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 1, 0, 1, '0000-00-00 00:00:00', 0, '2016-03-31 19:23:58', 0, '0000-00-00 00:00:00', 0),
(2, 1, '0', 'layout2', '0', '1', '', 6, 0, 0, 0, '', '', '', 2, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:04', 0, '0000-00-00 00:00:00', 0),
(3, 1, '0', 'loadmoregrid', '0', '1', '', 6, 0, 0, 0, '', '', '', 3, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:06', 0, '0000-00-00 00:00:00', 0),
(4, 1, '0', '0', '0', '1', '', 0, 0, 0, 0, '', '', '', 1, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:33', 0, '0000-00-00 00:00:00', 0),
(5, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 2, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:46', 0, '0000-00-00 00:00:00', 0),
(6, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 3, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:16', 0, '0000-00-00 00:00:00', 0),
(7, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 1, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:58', 0, '0000-00-00 00:00:00', 0),
(8, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 2, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:34:10', 0, '0000-00-00 00:00:00', 0),
(9, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 3, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:37', 0, '0000-00-00 00:00:00', 0),
(10, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 4, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:54', 0, '0000-00-00 00:00:00', 0),
(11, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 5, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:41', 0, '0000-00-00 00:00:00', 0),
(12, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 6, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:33', 0, '0000-00-00 00:00:00', 0),
(13, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 7, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:34:04', 0, '0000-00-00 00:00:00', 0),
(14, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 1, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:35:36', 0, '0000-00-00 00:00:00', 0),
(15, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 2, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:35:31', 0, '0000-00-00 00:00:00', 0),
(16, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 3, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:53', 0, '0000-00-00 00:00:00', 0),
(17, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 4, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:35:27', 0, '0000-00-00 00:00:00', 0),
(18, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 5, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:56', 0, '0000-00-00 00:00:00', 0),
(19, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 6, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:50', 0, '0000-00-00 00:00:00', 0),
(20, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 7, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:01', 0, '0000-00-00 00:00:00', 0),
(21, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 1, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:31', 0, '0000-00-00 00:00:00', 0),
(22, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 2, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:27', 0, '0000-00-00 00:00:00', 0),
(23, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 3, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:22', 0, '0000-00-00 00:00:00', 0),
(24, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 4, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:27', 0, '0000-00-00 00:00:00', 0),
(25, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 5, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:22', 0, '0000-00-00 00:00:00', 0),
(26, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 6, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:21', 0, '0000-00-00 00:00:00', 0),
(27, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 1, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:36:08', 0, '0000-00-00 00:00:00', 0),
(28, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 2, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:36:04', 0, '0000-00-00 00:00:00', 0),
(29, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 3, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:19', 0, '0000-00-00 00:00:00', 0),
(30, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 4, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:16', 0, '0000-00-00 00:00:00', 0),
(31, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 5, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:13', 0, '0000-00-00 00:00:00', 0),
(32, 1, '0', '0', '0', '1', '', 6, 0, 0, 0, '', '', '', 6, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:09', 0, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_categories_de_de`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_categories_de_de` (
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL,
  `category_name` varchar(180) NOT NULL DEFAULT '',
  `category_description` varchar(19000) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_categories_de_de` (`virtuemart_category_id`, `category_name`, `category_description`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Women', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc suscipit, tortor quis aliquam luctus, eros lorem ornare lectus, vitae tincidunt est leo ac lectus.</p>', '', '', '', 'women'),
(2, 'Men', '<p>Vivamus ante lorem, eleifend nec interdum non, ullamcorper et arcu. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>', '', '', '', 'men'),
(3, 'Kids', '<p>Praesent erat magna, suscipit a iaculis eu, pretium eu ipsum. Sed diam risus, ultricies eget dapibus sed, imperdiet id felis. Nulla dapibus, orci ut.</p>', '', '', '', 'kids'),
(6, 'Tops', '<p>Vestibulum faucibus pellentesque metus, nec convallis mauris congue sed. Fusce id neque eu tellus luctus adipiscing.</p>', '', '', '', 'tops'),
(4, 'Dresses', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'dresses'),
(5, 'Accessories', '<p>Sed sapien sapien, vulputate ac varius vitae, rutrum ultrices odio. Morbi vel tortor enim. Praesent lobortis gravida pretium.</p>', '', '', '', 'women-accessories');

DROP TABLE IF EXISTS `#__virtuemart_categories_en_gb`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_categories_en_gb` (
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL,
  `category_name` varchar(180) NOT NULL DEFAULT '',
  `category_description` varchar(19000) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_categories_en_gb` (`virtuemart_category_id`, `category_name`, `category_description`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Women', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc suscipit, tortor quis aliquam luctus, eros lorem ornare lectus, vitae tincidunt est leo ac lectus.</p>', '', '', '', 'women'),
(2, 'Men', '<p>Vivamus ante lorem, eleifend nec interdum non, ullamcorper et arcu. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>', '', '', '', 'men'),
(3, 'Kids', '<p>Praesent erat magna, suscipit a iaculis eu, pretium eu ipsum. Sed diam risus, ultricies eget dapibus sed, imperdiet id felis. Nulla dapibus, orci ut.</p>', '', '', '', 'kids'),
(4, 'Dresses', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'dresses'),
(5, 'Accessories', '<p>Sed sapien sapien, vulputate ac varius vitae, rutrum ultrices odio. Morbi vel tortor enim. Praesent lobortis gravida pretium.</p>', '', '', '', 'women-accessories'),
(6, 'Tops', '<p>Vestibulum faucibus pellentesque metus, nec convallis mauris congue sed. Fusce id neque eu tellus luctus adipiscing.</p>', '', '', '', 'tops'),
(7, 'Evening Dresses', '<p>Proin lobortis eleifend elit, at lacinia libero suscipit sed. Aliquam fringilla euismod risus ac bibendum. Sed sit amet sem varius ante feugiat lacinia.</p>', '', '', '', 'evening-dresses'),
(8, 'Casual Dresses', '<p>Ut vitae neque vel lacus volutpat pulvinar. Cras quis odio vitae tellus blandit fringilla. Fusce mattis diam massa.</p>', '', '', '', 'casual-dresses'),
(9, 'Party Dresses', '<p>Ut mi erat, consectetur in scelerisque vitae, sollicitudin eu augue. Vivamus molestie ornare neque a placerat.</p>', '', '', '', 'party-dresses'),
(10, 'Maxi Dresses', '<p>Sed in dui et mauris ullamcorper sagittis. Morbi tristique tellus eget turpis blandit bibendum. Aliquam ultricies neque quis eros congue eget.</p>', '', '', '', 'maxi-dresses'),
(11, 'Midi Dresses', '<p>Proin viverra, urna nec auctor pulvinar, turpis dui sagittis nulla, non commodo lacus est vitae nunc. Quisque ullamcorper sapien quis ipsum eleifend.</p>', '', '', '', 'midi-dresses'),
(12, 'Strapless Dresses', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'strapless-dresses'),
(13, 'Day Dresses', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'day-dresses'),
(14, 'Bags and Purces', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'bags-and-purces'),
(15, 'Belts', '<p>Ut vitae neque vel lacus volutpat pulvinar. Cras quis odio vitae tellus blandit fringilla. Fusce mattis diam massa.</p>', '', '', '', 'belts'),
(16, 'Scarves', '<p>Ut mi erat, consectetur in scelerisque vitae, sollicitudin eu augue. Vivamus molestie ornare neque a placerat.</p>', '', '', '', 'scarves'),
(17, 'Gloves', '<p>Sed in dui et mauris ullamcorper sagittis. Morbi tristique tellus eget turpis blandit bibendum. Aliquam ultricies neque quis eros congue eget.</p>', '', '', '', 'gloves'),
(18, 'Jewellery', '<p>Proin viverra, urna nec auctor pulvinar, turpis dui sagittis nulla, non commodo lacus est vitae nunc. Quisque ullamcorper sapien quis ipsum eleifend.</p>', '', '', '', 'jewellery'),
(19, 'Sunglasses', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'sunglasses'),
(20, 'Hair Accessories', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'hair-accessories'),
(21, 'Evening Tops', '<p>Ut vitae neque vel lacus volutpat pulvinar. Cras quis odio vitae tellus blandit fringilla. Fusce mattis diam massa.</p>', '', '', '', 'evening-tops'),
(22, 'Long Sleeved', '<p>Ut mi erat, consectetur in scelerisque vitae, sollicitudin eu augue. Vivamus molestie ornare neque a placerat.</p>', '', '', '', 'long-sleeved'),
(23, 'Short Sleeved', '<p>Sed in dui et mauris ullamcorper sagittis. Morbi tristique tellus eget turpis blandit bibendum. Aliquam ultricies neque quis eros congue eget.</p>', '', '', '', 'short-sleeved'),
(24, 'Sleeveless', '<p>Proin viverra, urna nec auctor pulvinar, turpis dui sagittis nulla, non commodo lacus est vitae nunc. Quisque ullamcorper sapien quis ipsum eleifend.</p>', '', '', '', 'sleeveless'),
(25, 'Tanks', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'tanks'),
(26, 'Tunics', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'tunics'),
(27, 'Accessories', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'men-accessories'),
(28, 'Blazers', '<p>Ut vitae neque vel lacus volutpat pulvinar. Cras quis odio vitae tellus blandit fringilla. Fusce mattis diam massa.</p>', '', '', '', 'blazers'),
(29, 'Hoodies', '<p>Ut mi erat, consectetur in scelerisque vitae, sollicitudin eu augue. Vivamus molestie ornare neque a placerat.</p>', '', '', '', 'hoodies'),
(30, 'Jeans', '<p>Sed in dui et mauris ullamcorper sagittis. Morbi tristique tellus eget turpis blandit bibendum. Aliquam ultricies neque quis eros congue eget.</p>', '', '', '', 'jeans'),
(31, 'Shirts', '<p>Proin viverra, urna nec auctor pulvinar, turpis dui sagittis nulla, non commodo lacus est vitae nunc. Quisque ullamcorper sapien quis ipsum eleifend.</p>', '', '', '', 'shirts'),
(32, 'Shoes', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'shoes'),
(33, 'Underwear', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'Underwear');

DROP TABLE IF EXISTS `#__virtuemart_categories_es_es`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_categories_es_es` (
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL,
  `category_name` char(180) NOT NULL DEFAULT '',
  `category_description` varchar(20000) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` char(255) NOT NULL DEFAULT '',
  `slug` char(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__virtuemart_categories_fr_fr`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_categories_fr_fr` (
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL,
  `category_name` varchar(180) NOT NULL DEFAULT '',
  `category_description` varchar(19000) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_categories_fr_fr` (`virtuemart_category_id`, `category_name`, `category_description`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Women', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc suscipit, tortor quis aliquam luctus, eros lorem ornare lectus, vitae tincidunt est leo ac lectus.</p>', '', '', '', 'women'),
(2, 'Men', '<p>Vivamus ante lorem, eleifend nec interdum non, ullamcorper et arcu. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>', '', '', '', 'men'),
(3, 'Kids', '<p>Praesent erat magna, suscipit a iaculis eu, pretium eu ipsum. Sed diam risus, ultricies eget dapibus sed, imperdiet id felis. Nulla dapibus, orci ut.</p>', '', '', '', 'kids'),
(6, 'Tops', '<p>Vestibulum faucibus pellentesque metus, nec convallis mauris congue sed. Fusce id neque eu tellus luctus adipiscing.</p>', '', '', '', 'tops'),
(4, 'Dresses', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'dresses'),
(5, 'Accessories', '<p>Sed sapien sapien, vulputate ac varius vitae, rutrum ultrices odio. Morbi vel tortor enim. Praesent lobortis gravida pretium.</p>', '', '', '', 'women-accessories');

DROP TABLE IF EXISTS `#__virtuemart_categories_he_il`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_categories_he_il` (
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL,
  `category_name` varchar(180) NOT NULL DEFAULT '',
  `category_description` varchar(19000) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_categories_he_il` (`virtuemart_category_id`, `category_name`, `category_description`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(5, 'Accessories', '<p>Sed sapien sapien, vulputate ac varius vitae, rutrum ultrices odio. Morbi vel tortor enim. Praesent lobortis gravida pretium.</p>', '', '', '', 'women-accessories'),
(19, 'Sunglasses', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'sunglasses'),
(32, 'Shoes', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'shoes');

DROP TABLE IF EXISTS `#__virtuemart_categories_it_it`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_categories_it_it` (
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL,
  `category_name` varchar(180) NOT NULL DEFAULT '',
  `category_description` varchar(19000) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_categories_it_it` (`virtuemart_category_id`, `category_name`, `category_description`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Women', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc suscipit, tortor quis aliquam luctus, eros lorem ornare lectus, vitae tincidunt est leo ac lectus.</p>', '', '', '', 'women'),
(2, 'Men', '<p>Vivamus ante lorem, eleifend nec interdum non, ullamcorper et arcu. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>', '', '', '', 'men'),
(3, 'Kids', '<p>Praesent erat magna, suscipit a iaculis eu, pretium eu ipsum. Sed diam risus, ultricies eget dapibus sed, imperdiet id felis. Nulla dapibus, orci ut.</p>', '', '', '', 'kids'),
(6, 'Tops', '<p>Vestibulum faucibus pellentesque metus, nec convallis mauris congue sed. Fusce id neque eu tellus luctus adipiscing.</p>', '', '', '', 'tops'),
(4, 'Dresses', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'dresses'),
(5, 'Accessories', '<p>Sed sapien sapien, vulputate ac varius vitae, rutrum ultrices odio. Morbi vel tortor enim. Praesent lobortis gravida pretium.</p>', '', '', '', 'women-accessories');

DROP TABLE IF EXISTS `#__virtuemart_categories_ru_ru`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_categories_ru_ru` (
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL,
  `category_name` varchar(180) NOT NULL DEFAULT '',
  `category_description` varchar(19000) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_categories_ru_ru` (`virtuemart_category_id`, `category_name`, `category_description`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Women', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc suscipit, tortor quis aliquam luctus, eros lorem ornare lectus, vitae tincidunt est leo ac lectus.</p>', '', '', '', 'women'),
(6, 'Tops', '<p>Vestibulum faucibus pellentesque metus, nec convallis mauris congue sed. Fusce id neque eu tellus luctus adipiscing.</p>', '', '', '', 'tops'),
(4, 'Dresses', '<p>Donec ultricies tincidunt nisi eget tempor. Fusce condimentum ullamcorper nisl et condimentum. Quisque nec lectus ipsum.</p>', '', '', '', 'dresses'),
(5, 'Accessories', '<p>Sed sapien sapien, vulputate ac varius vitae, rutrum ultrices odio. Morbi vel tortor enim. Praesent lobortis gravida pretium.</p>', '', '', '', 'women-accessories'),
(2, 'Men', '<p>Vivamus ante lorem, eleifend nec interdum non, ullamcorper et arcu. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>', '', '', '', 'men'),
(3, 'Kids', '<p>Praesent erat magna, suscipit a iaculis eu, pretium eu ipsum. Sed diam risus, ultricies eget dapibus sed, imperdiet id felis. Nulla dapibus, orci ut.</p>', '', '', '', 'kids');

DROP TABLE IF EXISTS `#__virtuemart_category_categories`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_category_categories` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `category_child_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `ordering` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `category_parent_id` (`category_parent_id`,`category_child_id`),
  KEY `category_child_id` (`category_child_id`),
  KEY `ordering` (`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COMMENT='Category child-parent relation list';

INSERT INTO `#__virtuemart_category_categories` (`id`, `category_parent_id`, `category_child_id`, `ordering`) VALUES
(1, 0, 1, 1),
(2, 0, 2, 2),
(3, 0, 3, 3),
(4, 1, 4, 1),
(5, 1, 5, 2),
(6, 1, 6, 3),
(7, 4, 7, 1),
(8, 4, 8, 2),
(9, 4, 9, 3),
(10, 4, 10, 4),
(11, 4, 11, 5),
(12, 4, 12, 6),
(13, 4, 13, 7),
(14, 5, 14, 1),
(15, 5, 15, 2),
(16, 5, 16, 3),
(17, 5, 17, 4),
(18, 5, 18, 5),
(19, 5, 19, 6),
(20, 5, 20, 7),
(21, 6, 21, 1),
(22, 6, 22, 2),
(23, 6, 23, 3),
(24, 6, 24, 4),
(25, 6, 25, 5),
(26, 6, 26, 6),
(27, 2, 27, 1),
(28, 2, 28, 2),
(29, 2, 29, 3),
(30, 2, 30, 4),
(31, 2, 31, 5),
(32, 2, 32, 6);

DROP TABLE IF EXISTS `#__virtuemart_category_medias`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_category_medias` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_category_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_media_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `ordering` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `virtuemart_category_id` (`virtuemart_category_id`,`virtuemart_media_id`),
  KEY `ordering` (`virtuemart_category_id`,`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_category_medias` (`id`, `virtuemart_category_id`, `virtuemart_media_id`, `ordering`) VALUES
(1, 1, 2000, 1),
(2, 2, 2001, 1),
(3, 3, 2002, 1),
(4, 4, 2003, 1),
(5, 5, 2004, 1),
(6, 6, 2005, 1),
(7, 7, 2006, 1),
(8, 8, 2007, 1),
(9, 9, 2008, 1),
(10, 10, 2009, 1),
(11, 11, 2010, 1),
(12, 12, 2011, 1),
(13, 13, 2012, 1),
(14, 14, 2013, 1),
(15, 15, 2014, 1),
(16, 16, 2015, 1),
(17, 17, 2016, 1),
(18, 18, 2017, 1),
(19, 19, 2018, 1),
(20, 20, 2019, 1),
(21, 21, 2020, 1),
(22, 22, 2021, 1),
(23, 23, 2022, 1),
(24, 24, 2023, 1),
(25, 25, 2024, 1),
(26, 26, 2025, 1),
(27, 27, 2026, 1),
(28, 28, 2027, 1),
(29, 29, 2028, 1),
(30, 30, 2029, 1),
(31, 31, 2030, 1),
(32, 32, 2031, 1);

DROP TABLE IF EXISTS `#__virtuemart_configs`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_configs` (
  `virtuemart_config_id` tinyint(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `config` text DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_config_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Holds configuration settings';

INSERT INTO `#__virtuemart_configs` (`virtuemart_config_id`, `config`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 'shop_is_offline=\"0\"|offline_message=\"Our Shop is currently down for maintenance. Please check back again soon.\"|use_as_catalog=\"0\"|currency_converter_module=\"convertECB.php\"|order_mail_html=\"1\"|useSSL=\"0\"|dangeroustools=0|debug_enable=\"none\"|google_jquery=\"0\"|multix=\"none\"|usefancy=\"1\"|jchosen=\"1\"|pdf_button_enable=\"1\"|show_emailfriend=\"0\"|show_printicon=\"0\"|show_out_of_stock_products=\"1\"|coupons_enable=\"1\"|show_uncat_child_products=\"0\"|coupons_default_expire=\"1,D\"|weight_unit_default=\"KG\"|lwh_unit_default=\"M\"|list_limit=\"20\"|showReviewFor=\"all\"|reviewMode=\"registered\"|showRatingFor=\"all\"|ratingMode=\"registered\"|reviews_autopublish=\"1\"|reviews_minimum_comment_length=\"100\"|reviews_maximum_comment_length=\"2000\"|vmtemplate=\"\"|categorytemplate=\"\"|showCategory=\"1\"|categorylayout=\"default\"|categories_per_row=\"1\"|productlayout=\"\"|products_per_row=\"1\"|vmlayout=\"default\"|show_store_desc=\"0\"|show_categories=\"1\"|homepage_categories_per_row=\"3\"|homepage_products_per_row=\"3\"|show_featured=\"1\"|featured_products_rows=\"1\"|show_topTen=\"1\"|topTen_products_rows=\"1\"|show_recent=\"1\"|recent_products_rows=\"1\"|show_latest=\"1\"|latest_products_rows=\"1\"|assets_general_path=\"components\\/com_virtuemart\\/assets\\/\"|media_category_path=\"images\\/stories\\/virtuemart\\/category\\/\"|media_product_path=\"images\\/stories\\/virtuemart\\/product\\/\"|media_manufacturer_path=\"images\\/stories\\/virtuemart\\/manufacturer\\/\"|media_vendor_path=\"images\\/stories\\/virtuemart\\/vendor\\/\"|forSale_path_thumb=\"images\\/stories\\/virtuemart\\/forSale\\/resized\\/\"|img_resize_enable=\"1\"|img_width=\"280\"|img_height=\"280\"|no_image_set=\"noimage.gif\"|no_image_found=\"warning.png\"|browse_orderby_field=\"product_name\"|browse_orderby_fields=[\"product_name\",\"`p`.product_sku\",\"category_name\",\"category_description\",\"mf_name\",\"`p`.virtuemart_product_id\"]|browse_search_fields=[\"product_name\",\"`p`.product_sku\",\"category_name\",\"category_description\",\"mf_name\"]|roundindig=\"1\"|show_prices=\"1\"|price_show_packaging_pricelabel=\"0\"|show_tax=\"1\"|basePrice=\"0\"|basePriceText=\"0\"|basePriceRounding=\"-1\"|variantModification=\"0\"|variantModificationText=\"0\"|variantModificationRounding=\"-1\"|basePriceVariant=\"1\"|basePriceVariantText=\"0\"|basePriceVariantRounding=\"-1\"|basePriceWithTax=\"1\"|basePriceWithTaxText=\"0\"|basePriceWithTaxRounding=\"-1\"|discountedPriceWithoutTax=\"1\"|discountedPriceWithoutTaxText=\"0\"|discountedPriceWithoutTaxRounding=\"-1\"|salesPriceWithDiscount=\"0\"|salesPriceWithDiscountText=\"0\"|salesPriceWithDiscountRounding=\"-1\"|salesPrice=\"1\"|salesPriceText=\"0\"|salesPriceRounding=\"-1\"|priceWithoutTax=\"0\"|priceWithoutTaxText=\"0\"|priceWithoutTaxRounding=\"-1\"|discountAmount=\"1\"|discountAmountText=\"0\"|discountAmountRounding=\"-1\"|taxAmount=\"1\"|taxAmountText=\"0\"|taxAmountRounding=\"-1\"|addtocart_popup=\"1\"|check_stock=\"0\"|automatic_payment=\"1\"|automatic_shipment=\"1\"|agree_to_tos_onorder=\"1\"|oncheckout_show_legal_info=\"1\"|oncheckout_show_register=\"1\"|oncheckout_show_steps=\"0\"|oncheckout_show_register_text=\"COM_VIRTUEMART_ONCHECKOUT_DEFAULT_TEXT_REGISTER\"|inv_os=[\"C\"]|email_os_s=[\"U\",\"C\",\"X\",\"R\",\"S\"]|email_os_v=[\"U\",\"C\",\"X\",\"R\"]|seo_disabled=\"0\"|seo_translate=\"0\"|seo_use_id=\"0\"|enable_content_plugin=\"1\"|reg_captcha=\"0\"|handle_404=\"1\"|member_access_number=\"\"|enableEnglish=\"1\"|vmDefLang=\"\"|active_languages=[\"de-DE\",\"en-GB\",\"fr-FR\",\"he-IL\",\"it-IT\",\"ru-RU\"]|prodOnlyWLang=\"0\"|vm_lfbs=\"\"|debug_enable_methods=\"0\"|vmdev=\"none\"|revproxvar=\"\"|multixcart=\"0\"|useVendorEmail=\"1\"|invoiceInUserLang=\"0\"|debug_mail=\"0\"|addVendorEmail=\"\"|email_sf_s=[\"email\"]|attach=\"\"|attach_os=[\"U\",\"C\",\"X\",\"R\"]|norm_units=\"KG,100G,M,SM,CUBM,L,100ML,P\"|pdf_icon=\"0\"|recommend_unauth=\"1\"|ask_captcha=\"1\"|ask_question=\"1\"|asks_minimum_comment_length=\"50\"|asks_maximum_comment_length=\"2000\"|cp_rm=[\"C\"]|product_navigation=\"1\"|display_stock=\"1\"|show_pcustoms=\"1\"|show_subcat_products=\"0\"|show_uncat_parent_products=\"0\"|show_unpub_cat_products=\"1\"|cat_productdetails=\"0\"|latest_products_days=\"7000\"|latest_products_orderBy=\"modified_on\"|lstockmail=\"1\"|stockhandle_products=\"0\"|stockhandle=\"disableadd\"|rised_availability=\"\"|image=\"\"|rr_os=[\"C\"]|showcategory_desc=\"1\"|showsearch=\"1\"|showcategory=\"0\"|showproducts=\"1\"|omitLoaded=\"1\"|show_manufacturers=\"1\"|manufacturer_per_row=\"1\"|featured=\"1\"|featured_rows=\"1\"|omitLoaded_featured=\"1\"|discontinued=\"0\"|discontinued_rows=\"1\"|omitLoaded_discontinued=\"1\"|topten=\"1\"|topten_rows=\"1\"|omitLoaded_topten=\"1\"|recent=\"1\"|recent_rows=\"1\"|omitLoaded_recent=\"1\"|latest=\"1\"|latest_rows=\"1\"|omitLoaded_latest=\"1\"|cartlayout=\"default\"|productsublayout=\"\"|legacylayouts=\"1\"|add_img_main=\"0\"|img_width_full=\"\"|img_height_full=\"\"|forSale_path=\"D:\\\\wamp\\\\www\\\\vmfiles\\\\\"|mediaLimit=\"20\"|llimit_init_BE=\"50\"|pagseq=\"50,79,102,140\"|llimit_init_FE=\"6\"|pagseq_1=\"6,9,12,100\"|pagseq_2=\"6,9,12,100\"|pagseq_3=\"6,9,12,100\"|pagseq_4=\"6,9,12,100\"|pagseq_5=\"6,9,12,100\"|css=\"0\"|jquery=\"1\"|jprice=\"1\"|jsite=\"1\"|jdynupdate=\"1\"|askprice=\"1\"|rappenrundung=\"0\"|cVarswT=\"1\"|price_orderby=\"DESC\"|discountedPriceWithoutTaxTt=\"0\"|discountedPriceWithoutTaxTtText=\"0\"|discountedPriceWithoutTaxTtRounding=\"-1\"|priceWithoutTaxTt=\"0\"|priceWithoutTaxTtText=\"0\"|priceWithoutTaxTtRounding=\"-1\"|taxAmountTt=\"0\"|taxAmountTtText=\"0\"|taxAmountTtRounding=\"-1\"|salesPriceTt=\"0\"|salesPriceTtText=\"0\"|salesPriceTtRounding=\"-1\"|discountAmountTt=\"0\"|discountAmountTtText=\"0\"|discountAmountTtRounding=\"-1\"|unitPrice=\"0\"|unitPriceText=\"0\"|unitPriceRounding=\"2\"|popup_rel=\"0\"|oncheckout_opc=\"0\"|oncheckout_ajax=\"0\"|set_automatic_shipment=\"1\"|set_automatic_payment=\"1\"|oncheckout_only_registered=\"0\"|oncheckout_show_images=\"1\"|oncheckout_change_shopper=\"1\"|del_date_type=\"m\"|prd_brws_orderby_dir=\"ASC\"|browse_cat_orderby_field=\"c.ordering,category_name\"|cat_brws_orderby_dir=\"ASC\"|feed_latest_published=\"1\"|feed_latest_nb=\"5\"|feed_topten_published=\"1\"|feed_topten_nb=\"5\"|feed_featured_published=\"1\"|feed_featured_nb=\"5\"|feed_home_show_images=\"1\"|feed_home_show_prices=\"1\"|feed_home_show_description=\"1\"|feed_home_description_type=\"product_s_desc\"|feed_home_max_text_length=\"500\"|feed_cat_published=\"1\"|feed_cat_show_images=\"1\"|feed_cat_show_prices=\"1\"|feed_cat_show_description=\"1\"|feed_cat_description_type=\"product_s_desc\"|feed_cat_max_text_length=\"500\"|use_seo_suffix=\"1\"|seo_sufix=\"-detail\"|seo_full=\"1\"|router_by_menu=\"0\"|sef_for_cart_links=\"1\"|task=\"save\"|option=\"com_virtuemart\"|view=\"config\"|54c12f809f58c16f555e6642bfcf9c3a=\"1\"|sctime=1566211234.410982|vmlang=\"en_gb\"', '0000-00-00 00:00:00', 0, '2019-08-19 10:40:36', 131, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_countries`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_countries` (
  `virtuemart_country_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_worldzone_id` tinyint(1) NOT NULL DEFAULT 1,
  `country_name` varchar(64) DEFAULT NULL,
  `country_3_code` char(3) DEFAULT NULL,
  `country_2_code` char(2) DEFAULT NULL,
  `ordering` int(1) NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_country_id`),
  KEY `country_3_code` (`country_3_code`),
  KEY `country_2_code` (`country_2_code`),
  KEY `country_name` (`country_name`),
  KEY `ordering` (`ordering`),
  KEY `published` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=249 DEFAULT CHARSET=utf8 COMMENT='Country records';

INSERT INTO `#__virtuemart_countries` (`virtuemart_country_id`, `virtuemart_worldzone_id`, `country_name`, `country_3_code`, `country_2_code`, `ordering`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 1, 'Afghanistan', 'AFG', 'AF', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(2, 1, 'Albania', 'ALB', 'AL', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(3, 1, 'Algeria', 'DZA', 'DZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(4, 1, 'American Samoa', 'ASM', 'AS', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(5, 1, 'Andorra', 'AND', 'AD', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(6, 1, 'Angola', 'AGO', 'AO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(7, 1, 'Anguilla', 'AIA', 'AI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(8, 1, 'Antarctica', 'ATA', 'AQ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(9, 1, 'Antigua and Barbuda', 'ATG', 'AG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(10, 1, 'Argentina', 'ARG', 'AR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(11, 1, 'Armenia', 'ARM', 'AM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(12, 1, 'Aruba', 'ABW', 'AW', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(13, 1, 'Australia', 'AUS', 'AU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(14, 1, 'Austria', 'AUT', 'AT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(15, 1, 'Azerbaijan', 'AZE', 'AZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(16, 1, 'Bahamas', 'BHS', 'BS', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(17, 1, 'Bahrain', 'BHR', 'BH', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(18, 1, 'Bangladesh', 'BGD', 'BD', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(19, 1, 'Barbados', 'BRB', 'BB', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(20, 1, 'Belarus', 'BLR', 'BY', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(21, 1, 'Belgium', 'BEL', 'BE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(22, 1, 'Belize', 'BLZ', 'BZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(23, 1, 'Benin', 'BEN', 'BJ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(24, 1, 'Bermuda', 'BMU', 'BM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(25, 1, 'Bhutan', 'BTN', 'BT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(26, 1, 'Bolivia', 'BOL', 'BO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(27, 1, 'Bosnia and Herzegowina', 'BIH', 'BA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(28, 1, 'Botswana', 'BWA', 'BW', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(29, 1, 'Bouvet Island', 'BVT', 'BV', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(30, 1, 'Brazil', 'BRA', 'BR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(31, 1, 'British Indian Ocean Territory', 'IOT', 'IO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(32, 1, 'Brunei Darussalam', 'BRN', 'BN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(33, 1, 'Bulgaria', 'BGR', 'BG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(34, 1, 'Burkina Faso', 'BFA', 'BF', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(35, 1, 'Burundi', 'BDI', 'BI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(36, 1, 'Cambodia', 'KHM', 'KH', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(37, 1, 'Cameroon', 'CMR', 'CM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(38, 1, 'Canada', 'CAN', 'CA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(39, 1, 'Cape Verde', 'CPV', 'CV', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(40, 1, 'Cayman Islands', 'CYM', 'KY', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(41, 1, 'Central African Republic', 'CAF', 'CF', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(42, 1, 'Chad', 'TCD', 'TD', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(43, 1, 'Chile', 'CHL', 'CL', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(44, 1, 'China', 'CHN', 'CN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(45, 1, 'Christmas Island', 'CXR', 'CX', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(46, 1, 'Cocos (Keeling) Islands', 'CCK', 'CC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(47, 1, 'Colombia', 'COL', 'CO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(48, 1, 'Comoros', 'COM', 'KM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(49, 1, 'Congo', 'COG', 'CG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(50, 1, 'Cook Islands', 'COK', 'CK', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(51, 1, 'Costa Rica', 'CRI', 'CR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(52, 1, 'Cote D\'Ivoire', 'CIV', 'CI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(53, 1, 'Croatia', 'HRV', 'HR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(54, 1, 'Cuba', 'CUB', 'CU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(55, 1, 'Cyprus', 'CYP', 'CY', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(56, 1, 'Czech Republic', 'CZE', 'CZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(57, 1, 'Denmark', 'DNK', 'DK', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(58, 1, 'Djibouti', 'DJI', 'DJ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(59, 1, 'Dominica', 'DMA', 'DM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(60, 1, 'Dominican Republic', 'DOM', 'DO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(61, 1, 'East Timor', 'TMP', 'TP', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(62, 1, 'Ecuador', 'ECU', 'EC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(63, 1, 'Egypt', 'EGY', 'EG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(64, 1, 'El Salvador', 'SLV', 'SV', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(65, 1, 'Equatorial Guinea', 'GNQ', 'GQ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(66, 1, 'Eritrea', 'ERI', 'ER', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(67, 1, 'Estonia', 'EST', 'EE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(68, 1, 'Ethiopia', 'ETH', 'ET', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(69, 1, 'Falkland Islands (Malvinas)', 'FLK', 'FK', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(70, 1, 'Faroe Islands', 'FRO', 'FO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(71, 1, 'Fiji', 'FJI', 'FJ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(72, 1, 'Finland', 'FIN', 'FI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(73, 1, 'France', 'FRA', 'FR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(75, 1, 'French Guiana', 'GUF', 'GF', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(76, 1, 'French Polynesia', 'PYF', 'PF', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(77, 1, 'French Southern Territories', 'ATF', 'TF', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(78, 1, 'Gabon', 'GAB', 'GA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(79, 1, 'Gambia', 'GMB', 'GM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(80, 1, 'Georgia', 'GEO', 'GE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(81, 1, 'Germany', 'DEU', 'DE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(82, 1, 'Ghana', 'GHA', 'GH', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(83, 1, 'Gibraltar', 'GIB', 'GI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(84, 1, 'Greece', 'GRC', 'GR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(85, 1, 'Greenland', 'GRL', 'GL', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(86, 1, 'Grenada', 'GRD', 'GD', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(87, 1, 'Guadeloupe', 'GLP', 'GP', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(88, 1, 'Guam', 'GUM', 'GU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(89, 1, 'Guatemala', 'GTM', 'GT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(90, 1, 'Guinea', 'GIN', 'GN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(91, 1, 'Guinea-bissau', 'GNB', 'GW', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(92, 1, 'Guyana', 'GUY', 'GY', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(93, 1, 'Haiti', 'HTI', 'HT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(94, 1, 'Heard and Mc Donald Islands', 'HMD', 'HM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(95, 1, 'Honduras', 'HND', 'HN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(96, 1, 'Hong Kong', 'HKG', 'HK', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(97, 1, 'Hungary', 'HUN', 'HU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(98, 1, 'Iceland', 'ISL', 'IS', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(99, 1, 'India', 'IND', 'IN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(100, 1, 'Indonesia', 'IDN', 'ID', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(101, 1, 'Iran (Islamic Republic of)', 'IRN', 'IR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(102, 1, 'Iraq', 'IRQ', 'IQ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(103, 1, 'Ireland', 'IRL', 'IE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(104, 1, 'Israel', 'ISR', 'IL', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(105, 1, 'Italy', 'ITA', 'IT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(106, 1, 'Jamaica', 'JAM', 'JM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(107, 1, 'Japan', 'JPN', 'JP', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(108, 1, 'Jordan', 'JOR', 'JO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(109, 1, 'Kazakhstan', 'KAZ', 'KZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(110, 1, 'Kenya', 'KEN', 'KE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(111, 1, 'Kiribati', 'KIR', 'KI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(112, 1, 'Korea, Democratic People\'s Republic of', 'PRK', 'KP', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(113, 1, 'Korea, Republic of', 'KOR', 'KR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(114, 1, 'Kuwait', 'KWT', 'KW', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(115, 1, 'Kyrgyzstan', 'KGZ', 'KG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(116, 1, 'Lao People\'s Democratic Republic', 'LAO', 'LA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(117, 1, 'Latvia', 'LVA', 'LV', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(118, 1, 'Lebanon', 'LBN', 'LB', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(119, 1, 'Lesotho', 'LSO', 'LS', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(120, 1, 'Liberia', 'LBR', 'LR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(121, 1, 'Libyan Arab Jamahiriya', 'LBY', 'LY', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(122, 1, 'Liechtenstein', 'LIE', 'LI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(123, 1, 'Lithuania', 'LTU', 'LT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(124, 1, 'Luxembourg', 'LUX', 'LU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(125, 1, 'Macau', 'MAC', 'MO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(126, 1, 'Macedonia, The Former Yugoslav Republic of', 'MKD', 'MK', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(127, 1, 'Madagascar', 'MDG', 'MG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(128, 1, 'Malawi', 'MWI', 'MW', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(129, 1, 'Malaysia', 'MYS', 'MY', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(130, 1, 'Maldives', 'MDV', 'MV', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(131, 1, 'Mali', 'MLI', 'ML', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(132, 1, 'Malta', 'MLT', 'MT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(133, 1, 'Marshall Islands', 'MHL', 'MH', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(134, 1, 'Martinique', 'MTQ', 'MQ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(135, 1, 'Mauritania', 'MRT', 'MR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(136, 1, 'Mauritius', 'MUS', 'MU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(137, 1, 'Mayotte', 'MYT', 'YT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(138, 1, 'Mexico', 'MEX', 'MX', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(139, 1, 'Micronesia, Federated States of', 'FSM', 'FM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(140, 1, 'Moldova, Republic of', 'MDA', 'MD', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(141, 1, 'Monaco', 'MCO', 'MC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(142, 1, 'Mongolia', 'MNG', 'MN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(143, 1, 'Montserrat', 'MSR', 'MS', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(144, 1, 'Morocco', 'MAR', 'MA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(145, 1, 'Mozambique', 'MOZ', 'MZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(146, 1, 'Myanmar', 'MMR', 'MM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(147, 1, 'Namibia', 'NAM', 'NA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(148, 1, 'Nauru', 'NRU', 'NR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(149, 1, 'Nepal', 'NPL', 'NP', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(150, 1, 'Netherlands', 'NLD', 'NL', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(151, 1, 'Netherlands Antilles', 'ANT', 'AN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(152, 1, 'New Caledonia', 'NCL', 'NC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(153, 1, 'New Zealand', 'NZL', 'NZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(154, 1, 'Nicaragua', 'NIC', 'NI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(155, 1, 'Niger', 'NER', 'NE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(156, 1, 'Nigeria', 'NGA', 'NG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(157, 1, 'Niue', 'NIU', 'NU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(158, 1, 'Norfolk Island', 'NFK', 'NF', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(159, 1, 'Northern Mariana Islands', 'MNP', 'MP', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(160, 1, 'Norway', 'NOR', 'NO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(161, 1, 'Oman', 'OMN', 'OM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(162, 1, 'Pakistan', 'PAK', 'PK', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(163, 1, 'Palau', 'PLW', 'PW', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(164, 1, 'Panama', 'PAN', 'PA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(165, 1, 'Papua New Guinea', 'PNG', 'PG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(166, 1, 'Paraguay', 'PRY', 'PY', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(167, 1, 'Peru', 'PER', 'PE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(168, 1, 'Philippines', 'PHL', 'PH', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(169, 1, 'Pitcairn', 'PCN', 'PN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(170, 1, 'Poland', 'POL', 'PL', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(171, 1, 'Portugal', 'PRT', 'PT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(172, 1, 'Puerto Rico', 'PRI', 'PR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(173, 1, 'Qatar', 'QAT', 'QA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(174, 1, 'Reunion', 'REU', 'RE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(175, 1, 'Romania', 'ROM', 'RO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(176, 1, 'Russian Federation', 'RUS', 'RU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(177, 1, 'Rwanda', 'RWA', 'RW', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(178, 1, 'Saint Kitts and Nevis', 'KNA', 'KN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(179, 1, 'Saint Lucia', 'LCA', 'LC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(180, 1, 'Saint Vincent and the Grenadines', 'VCT', 'VC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(181, 1, 'Samoa', 'WSM', 'WS', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(182, 1, 'San Marino', 'SMR', 'SM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(183, 1, 'Sao Tome and Principe', 'STP', 'ST', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(184, 1, 'Saudi Arabia', 'SAU', 'SA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(185, 1, 'Senegal', 'SEN', 'SN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(186, 1, 'Seychelles', 'SYC', 'SC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(187, 1, 'Sierra Leone', 'SLE', 'SL', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(188, 1, 'Singapore', 'SGP', 'SG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(189, 1, 'Slovakia', 'SVK', 'SK', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(190, 1, 'Slovenia', 'SVN', 'SI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(191, 1, 'Solomon Islands', 'SLB', 'SB', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(192, 1, 'Somalia', 'SOM', 'SO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(193, 1, 'South Africa', 'ZAF', 'ZA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(194, 1, 'South Georgia and the South Sandwich Islands', 'SGS', 'GS', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(195, 1, 'Spain', 'ESP', 'ES', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(196, 1, 'Sri Lanka', 'LKA', 'LK', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(197, 1, 'St. Helena', 'SHN', 'SH', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(198, 1, 'St. Pierre and Miquelon', 'SPM', 'PM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(199, 1, 'Sudan', 'SDN', 'SD', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(200, 1, 'Suriname', 'SUR', 'SR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(201, 1, 'Svalbard and Jan Mayen Islands', 'SJM', 'SJ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(202, 1, 'Swaziland', 'SWZ', 'SZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(203, 1, 'Sweden', 'SWE', 'SE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(204, 1, 'Switzerland', 'CHE', 'CH', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(205, 1, 'Syrian Arab Republic', 'SYR', 'SY', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(206, 1, 'Taiwan', 'TWN', 'TW', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(207, 1, 'Tajikistan', 'TJK', 'TJ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(208, 1, 'Tanzania, United Republic of', 'TZA', 'TZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(209, 1, 'Thailand', 'THA', 'TH', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(210, 1, 'Togo', 'TGO', 'TG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(211, 1, 'Tokelau', 'TKL', 'TK', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(212, 1, 'Tonga', 'TON', 'TO', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(213, 1, 'Trinidad and Tobago', 'TTO', 'TT', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(214, 1, 'Tunisia', 'TUN', 'TN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(215, 1, 'Turkey', 'TUR', 'TR', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(216, 1, 'Turkmenistan', 'TKM', 'TM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(217, 1, 'Turks and Caicos Islands', 'TCA', 'TC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(218, 1, 'Tuvalu', 'TUV', 'TV', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(219, 1, 'Uganda', 'UGA', 'UG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(220, 1, 'Ukraine', 'UKR', 'UA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(221, 1, 'United Arab Emirates', 'ARE', 'AE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(222, 1, 'United Kingdom', 'GBR', 'GB', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(223, 1, 'United States', 'USA', 'US', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(224, 1, 'United States Minor Outlying Islands', 'UMI', 'UM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(225, 1, 'Uruguay', 'URY', 'UY', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(226, 1, 'Uzbekistan', 'UZB', 'UZ', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(227, 1, 'Vanuatu', 'VUT', 'VU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(228, 1, 'Vatican City State (Holy See)', 'VAT', 'VA', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(229, 1, 'Venezuela', 'VEN', 'VE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(230, 1, 'Viet Nam', 'VNM', 'VN', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(231, 1, 'Virgin Islands (British)', 'VGB', 'VG', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(232, 1, 'Virgin Islands (U.S.)', 'VIR', 'VI', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(233, 1, 'Wallis and Futuna Islands', 'WLF', 'WF', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(234, 1, 'Western Sahara', 'ESH', 'EH', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(235, 1, 'Yemen', 'YEM', 'YE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(237, 1, 'The Democratic Republic of Congo', 'DRC', 'DC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(238, 1, 'Zambia', 'ZMB', 'ZM', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(239, 1, 'Zimbabwe', 'ZWE', 'ZW', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(240, 1, 'East Timor', 'XET', 'XE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(241, 1, 'Jersey', 'JEY', 'JE', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(242, 1, 'St. Barthelemy', 'XSB', 'XB', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(243, 1, 'St. Eustatius', 'XSE', 'XU', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(244, 1, 'Canary Islands', 'XCA', 'XC', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(245, 1, 'Serbia', 'SRB', 'RS', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(246, 1, 'Sint Maarten (French Antilles)', 'MAF', 'MF', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(247, 1, 'Sint Maarten (Netherlands Antilles)', 'SXM', 'SX', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(248, 1, 'Palestinian Territory, occupied', 'PSE', 'PS', 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_coupons`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_coupons` (
  `virtuemart_coupon_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL,
  `coupon_code` varchar(32) NOT NULL DEFAULT '',
  `coupon_used` varchar(200) NOT NULL DEFAULT '',
  `percent_or_total` enum('percent','total') NOT NULL DEFAULT 'percent',
  `coupon_type` enum('gift','permanent') NOT NULL DEFAULT 'gift',
  `coupon_value` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `coupon_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `coupon_expiry_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `coupon_value_valid` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_coupon_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `coupon_code` (`coupon_code`),
  KEY `coupon_type` (`coupon_type`),
  KEY `published` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Used to store coupon codes';

INSERT INTO `#__virtuemart_coupons` (`virtuemart_coupon_id`, `virtuemart_vendor_id`, `coupon_code`, `coupon_used`, `percent_or_total`, `coupon_type`, `coupon_value`, `coupon_start_date`, `coupon_expiry_date`, `coupon_value_valid`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 0, 'serg', '0', 'percent', 'permanent', '10.00000', '2014-05-07 00:00:00', '2014-05-17 18:06:29', '1.00000', 1, '2014-05-16 18:06:59', 0, '2014-05-16 18:06:59', 0, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_currencies`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_currencies` (
  `virtuemart_currency_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1,
  `currency_name` varchar(64) DEFAULT NULL,
  `currency_code_2` char(2) DEFAULT NULL,
  `currency_code_3` char(3) DEFAULT NULL,
  `currency_numeric_code` int(4) DEFAULT NULL,
  `currency_exchange_rate` decimal(12,5) DEFAULT NULL,
  `currency_symbol` varchar(8) DEFAULT NULL,
  `currency_decimal_place` varchar(8) DEFAULT NULL,
  `currency_decimal_symbol` varchar(8) DEFAULT NULL,
  `currency_thousands` varchar(8) DEFAULT NULL,
  `currency_positive_style` varchar(64) DEFAULT NULL,
  `currency_negative_style` varchar(64) DEFAULT NULL,
  `ordering` int(1) NOT NULL DEFAULT 0,
  `shared` tinyint(1) NOT NULL DEFAULT 1,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_currency_id`),
  UNIQUE KEY `currency_code_3` (`currency_code_3`),
  KEY `ordering` (`ordering`),
  KEY `currency_name` (`currency_name`),
  KEY `published` (`published`),
  KEY `shared` (`shared`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `currency_numeric_code` (`currency_numeric_code`)
) ENGINE=MyISAM AUTO_INCREMENT=202 DEFAULT CHARSET=utf8 COMMENT='Used to store currencies';

INSERT INTO `#__virtuemart_currencies` (`virtuemart_currency_id`, `virtuemart_vendor_id`, `currency_name`, `currency_code_2`, `currency_code_3`, `currency_numeric_code`, `currency_exchange_rate`, `currency_symbol`, `currency_decimal_place`, `currency_decimal_symbol`, `currency_thousands`, `currency_positive_style`, `currency_negative_style`, `ordering`, `shared`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(2, 1, 'United Arab Emirates dirham', '', 'AED', 784, '0.00000', 'د.إ', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(4, 1, 'Albanian lek', '', 'ALL', 8, '0.00000', 'Lek', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(5, 1, 'Netherlands Antillean gulden', '', 'ANG', 532, '0.00000', 'ƒ', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(7, 1, 'Argentine peso', '', 'ARS', 32, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(9, 1, 'Australian dollar', '', 'AUD', 36, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(10, 1, 'Aruban florin', '', 'AWG', 533, '0.00000', 'ƒ', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(11, 1, 'Barbadian dollar', '', 'BBD', 52, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(12, 1, 'Bangladeshi taka', '', 'BDT', 50, '0.00000', '৳', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(15, 1, 'Bahraini dinar', '', 'BHD', 48, '0.00000', 'ب.د', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(16, 1, 'Burundian franc', '', 'BIF', 108, '0.00000', 'Fr', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(17, 1, 'Bermudian dollar', '', 'BMD', 60, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(18, 1, 'Brunei dollar', '', 'BND', 96, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(19, 1, 'Bolivian boliviano', '', 'BOB', 68, '0.00000', '$b', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(20, 1, 'Brazilian real', '', 'BRL', 986, '0.00000', 'R$', '2', '.', ',', '{symbol} {number}', '{symbol} {sign}{number}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(21, 1, 'Bahamian dollar', '', 'BSD', 44, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(22, 1, 'Bhutanese ngultrum', '', 'BTN', 64, '0.00000', 'BTN', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(24, 1, 'Botswana pula', '', 'BWP', 72, '0.00000', 'P', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(25, 1, 'Belize dollar', '', 'BZD', 84, '0.00000', 'BZ$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(26, 1, 'CD', '', 'CAD', 124, '0.00000', '$', '2', '.', ',', '{symbol}{number}', '{symbol}{sign}{number}', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-03-14 20:31:44', 0, '0000-00-00 00:00:00', 0),
(27, 1, 'Swiss franc', '', 'CHF', 756, '0.00000', 'CHF', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(28, 1, 'Unidad de Fomento', '', 'CLF', 990, '0.00000', 'CLF', '0', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(29, 1, 'Chilean peso', '', 'CLP', 152, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(30, 1, 'Chinese renminbi yuan', '', 'CNY', 156, '0.00000', '元', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(31, 1, 'Colombian peso', '', 'COP', 170, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(32, 1, 'Costa Rican colón', '', 'CRC', 188, '0.00000', '₡', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(33, 1, 'Czech koruna', '', 'CZK', 203, '0.00000', 'Kč', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(34, 1, 'Cuban peso', '', 'CUP', 192, '0.00000', '₱', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(35, 1, 'Cape Verdean escudo', '', 'CVE', 132, '0.00000', '$', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(40, 1, 'Danish krone', '', 'DKK', 208, '0.00000', 'kr', '2', '.', ',', '{symbol}{number}', '{symbol}{sign}{number}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(41, 1, 'Dominican peso', '', 'DOP', 214, '0.00000', 'RD$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(42, 1, 'Algerian dinar', '', 'DZD', 12, '0.00000', 'د.ج', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(44, 1, 'Egyptian pound', '', 'EGP', 818, '0.00000', '£', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(46, 1, 'Ethiopian birr', '', 'ETB', 230, '0.00000', 'ETB', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(47, 1, 'EUR', '', 'EUR', 978, '0.00000', '€', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-03-14 20:32:47', 0, '0000-00-00 00:00:00', 0),
(49, 1, 'Fijian dollar', '', 'FJD', 242, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(50, 1, 'Falkland pound', '', 'FKP', 238, '0.00000', '£', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(52, 1, 'BRP', '', 'GBP', 826, '0.00000', '£', '2', '.', ',', '{symbol}{number}', '{symbol}{sign}{number}', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-03-14 20:32:08', 0, '0000-00-00 00:00:00', 0),
(54, 1, 'Gibraltar pound', '', 'GIP', 292, '0.00000', '£', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(55, 1, 'Gambian dalasi', '', 'GMD', 270, '0.00000', 'D', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(56, 1, 'Guinean franc', '', 'GNF', 324, '0.00000', 'Fr', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(58, 1, 'Guatemalan quetzal', '', 'GTQ', 320, '0.00000', 'Q', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(60, 1, 'Guyanese dollar', '', 'GYD', 328, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(61, 1, 'Hong Kong dollar', '', 'HKD', 344, '0.00000', '元', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(62, 1, 'Honduran lempira', '', 'HNL', 340, '0.00000', 'L', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(63, 1, 'Haitian gourde', '', 'HTG', 332, '0.00000', 'G', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(64, 1, 'Hungarian forint', '', 'HUF', 348, '0.00000', 'Ft', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(65, 1, 'Indonesian rupiah', '', 'IDR', 360, '0.00000', 'Rp', '0', '', '', '{symbol}{number}', '{symbol}{sign}{number}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(67, 1, 'Israeli new sheqel', '', 'ILS', 376, '0.00000', '₪', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(68, 1, 'Indian rupee', '', 'INR', 356, '0.00000', '₨', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(69, 1, 'Iraqi dinar', '', 'IQD', 368, '0.00000', 'ع.د', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(70, 1, 'Iranian rial', '', 'IRR', 364, '0.00000', '﷼', '2', ',', '', '{number} {symbol}', '{sign}{number}{symb0l}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(73, 1, 'Jamaican dollar', '', 'JMD', 388, '0.00000', 'J$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(74, 1, 'Jordanian dinar', '', 'JOD', 400, '0.00000', 'د.ا', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(75, 1, 'Japanese yen', '', 'JPY', 392, '0.00000', '¥', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(76, 1, 'Kenyan shilling', '', 'KES', 404, '0.00000', 'Sh', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(77, 1, 'Cambodian riel', '', 'KHR', 116, '0.00000', '៛', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(78, 1, 'Comorian franc', '', 'KMF', 174, '0.00000', 'Fr', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(79, 1, 'North Korean won', '', 'KPW', 408, '0.00000', '₩', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(80, 1, 'South Korean won', '', 'KRW', 410, '0.00000', '₩', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(81, 1, 'Kuwaiti dinar', '', 'KWD', 414, '0.00000', 'د.ك', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(82, 1, 'Cayman Islands dollar', '', 'KYD', 136, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(83, 1, 'Lao kip', '', 'LAK', 418, '0.00000', '₭', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(84, 1, 'Lebanese pound', '', 'LBP', 422, '0.00000', '£', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(85, 1, 'Sri Lankan rupee', '', 'LKR', 144, '0.00000', '₨', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(86, 1, 'Liberian dollar', '', 'LRD', 430, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(87, 1, 'Lesotho loti', '', 'LSL', 426, '0.00000', 'L', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(89, 1, 'Libyan dinar', '', 'LYD', 434, '0.00000', 'ل.د', '3', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(90, 1, 'Moroccan dirham', '', 'MAD', 504, '0.00000', 'د.م.', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(92, 1, 'Mongolian tögrög', '', 'MNT', 496, '0.00000', '₮', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(93, 1, 'Macanese pataca', '', 'MOP', 446, '0.00000', 'P', '1', ',', '', '{symbol}{number}', '{symbol}{sign}{number}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(94, 1, 'Mauritanian ouguiya', '', 'MRO', 478, '0.00000', 'UM', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(96, 1, 'Mauritian rupee', '', 'MUR', 480, '0.00000', '₨', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(97, 1, 'Maldivian rufiyaa', '', 'MVR', 462, '0.00000', 'ރ.', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(98, 1, 'Malawian kwacha', '', 'MWK', 454, '0.00000', 'MK', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(100, 1, 'Malaysian ringgit', '', 'MYR', 458, '0.00000', 'RM', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(102, 1, 'Nigerian naira', '', 'NGN', 566, '0.00000', '₦', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(105, 1, 'Norwegian krone', '', 'NOK', 578, '0.00000', 'kr', '2', ',', '', '{symbol}{number}', '{symbol}{sign}{number}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(106, 1, 'Nepalese rupee', '', 'NPR', 524, '0.00000', '₨', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(107, 1, 'New Zealand dollar', '', 'NZD', 554, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(108, 1, 'Omani rial', '', 'OMR', 512, '0.00000', '﷼', '3', '.', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(109, 1, 'Panamanian balboa', '', 'PAB', 590, '0.00000', 'B/.', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(110, 1, 'Peruvian nuevo sol', '', 'PEN', 604, '0.00000', 'S/.', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(111, 1, 'Papua New Guinean kina', '', 'PGK', 598, '0.00000', 'K', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(112, 1, 'Philippine peso', '', 'PHP', 608, '0.00000', '₱', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(113, 1, 'Pakistani rupee', '', 'PKR', 586, '0.00000', '₨', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(114, 1, 'Polish Złoty', '', 'PLN', 985, '0.00000', 'zł', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(116, 1, 'Paraguayan guaraní', '', 'PYG', 600, '0.00000', '₲', '0', '', '.', '{symbol} {number}', '{symbol} {sign}{number}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(117, 1, 'Qatari riyal', '', 'QAR', 634, '0.00000', '﷼', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(118, 1, 'Romanian leu', '', 'RON', 946, '0.00000', 'lei', '2', ',', '.', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(119, 1, 'Rwandan franc', '', 'RWF', 646, '0.00000', 'Fr', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(120, 1, 'Saudi riyal', '', 'SAR', 682, '0.00000', '﷼', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(121, 1, 'Solomon Islands dollar', '', 'SBD', 90, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(122, 1, 'Seychellois rupee', '', 'SCR', 690, '0.00000', '₨', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(124, 1, 'Swedish krona', '', 'SEK', 752, '0.00000', 'kr', '2', ',', '.', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(125, 1, 'Singapore dollar', '', 'SGD', 702, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(126, 1, 'Saint Helenian pound', '', 'SHP', 654, '0.00000', '£', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(127, 1, 'Sierra Leonean leone', '', 'SLL', 694, '0.00000', 'Le', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(128, 1, 'Somali shilling', '', 'SOS', 706, '0.00000', 'S', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(130, 1, 'São Tomé and Príncipe dobra', '', 'STD', 678, '0.00000', 'Db', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(131, 1, 'Russian ruble', '', 'RUB', 643, '0.00000', 'руб', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(132, 1, 'Salvadoran colón', '', 'SVC', 222, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(133, 1, 'Syrian pound', '', 'SYP', 760, '0.00000', '£', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(134, 1, 'Swazi lilangeni', '', 'SZL', 748, '0.00000', 'L', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(135, 1, 'Thai baht', '', 'THB', 764, '0.00000', '฿', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(136, 1, 'Tunisian dinar', '', 'TND', 788, '0.00000', 'د.ت', '3', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(137, 1, 'Tongan paʻanga', '', 'TOP', 776, '0.00000', 'T$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(139, 1, 'Turkish new lira', '', 'TRY', 949, '0.00000', 'YTL', '2', ',', '.', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(140, 1, 'Trinidad and Tobago dollar', '', 'TTD', 780, '0.00000', 'TT$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(141, 1, 'New Taiwan dollar', '', 'TWD', 901, '0.00000', 'NT$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(142, 1, 'Tanzanian shilling', '', 'TZS', 834, '0.00000', 'Sh', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(144, 1, 'USD', '', 'USD', 840, '0.00000', '$', '2', '.', ',', '{symbol}{number}', '{symbol}{sign}{number}', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-03-14 20:33:21', 0, '0000-00-00 00:00:00', 0),
(147, 1, 'Vietnamese Dong', '', 'VND', 704, '0.00000', '₫', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(148, 1, 'Vanuatu vatu', '', 'VUV', 548, '0.00000', 'Vt', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(149, 1, 'Samoan tala', '', 'WST', 882, '0.00000', 'T', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(151, 1, 'Yemeni rial', '', 'YER', 886, '0.00000', '﷼', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(152, 1, 'Serbian dinar', '', 'RSD', 941, '0.00000', 'Дин.', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(153, 1, 'South African rand', '', 'ZAR', 710, '0.00000', 'R', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(154, 1, 'Zambian kwacha', '', 'ZMK', 894, '0.00000', 'ZK', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(156, 1, 'Zimbabwean dollar', '', 'ZWD', 932, '0.00000', 'Z$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(158, 1, 'Armenian dram', '', 'AMD', 51, '0.00000', 'դր.', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(159, 1, 'Myanmar kyat', '', 'MMK', 104, '0.00000', 'K', '2', ',', '', '{number} {symbol}', '{symbol} {sign}{number}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(160, 1, 'Croatian kuna', '', 'HRK', 191, '0.00000', 'kn', '2', ',', '.', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(161, 1, 'Eritrean nakfa', '', 'ERN', 232, '0.00000', 'Nfk', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(162, 1, 'Djiboutian franc', '', 'DJF', 262, '0.00000', 'Fr', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(163, 1, 'Icelandic króna', '', 'ISK', 352, '0.00000', 'kr', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(164, 1, 'Kazakhstani tenge', '', 'KZT', 398, '0.00000', 'лв', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(165, 1, 'Kyrgyzstani som', '', 'KGS', 417, '0.00000', 'лв', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(166, 1, 'Latvian lats', '', 'LVL', 428, '0.00000', 'Ls', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(167, 1, 'Lithuanian litas', '', 'LTL', 440, '0.00000', 'Lt', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(168, 1, 'Mexican peso', '', 'MXN', 484, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(169, 1, 'Moldovan leu', '', 'MDL', 498, '0.00000', 'L', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(170, 1, 'Namibian dollar', '', 'NAD', 516, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(171, 1, 'Nicaraguan córdoba', '', 'NIO', 558, '0.00000', 'C$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(172, 1, 'Ugandan shilling', '', 'UGX', 800, '0.00000', 'Sh', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(173, 1, 'Macedonian denar', '', 'MKD', 807, '0.00000', 'ден', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(174, 1, 'Uruguayan peso', '', 'UYU', 858, '0.00000', '$', '0', '', '', '{symbol}number}', '{symbol}{sign}{number}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(175, 1, 'Uzbekistani som', '', 'UZS', 860, '0.00000', 'лв', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(176, 1, 'Azerbaijani manat', '', 'AZN', 934, '0.00000', 'ман', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(177, 1, 'Ghanaian cedi', '', 'GHS', 936, '0.00000', '₵', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(178, 1, 'Venezuelan bolívar', '', 'VEF', 937, '0.00000', 'Bs', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(179, 1, 'Sudanese pound', '', 'SDG', 938, '0.00000', '£', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(180, 1, 'Uruguay Peso', '', 'UYI', 940, '0.00000', 'UYI', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(181, 1, 'Mozambican metical', '', 'MZN', 943, '0.00000', 'MT', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(182, 1, 'WIR Euro', '', 'CHE', 947, '0.00000', '€', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(183, 1, 'WIR Franc', '', 'CHW', 948, '0.00000', 'CHW', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(184, 1, 'Central African CFA franc', '', 'XAF', 950, '0.00000', 'Fr', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(185, 1, 'East Caribbean dollar', '', 'XCD', 951, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(186, 1, 'West African CFA franc', '', 'XOF', 952, '0.00000', 'Fr', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(187, 1, 'CFP franc', '', 'XPF', 953, '0.00000', 'Fr', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(188, 1, 'Surinamese dollar', '', 'SRD', 968, '0.00000', '$', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(189, 1, 'Malagasy ariary', '', 'MGA', 969, '0.00000', 'MGA', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(190, 1, 'Unidad de Valor Real', '', 'COU', 970, '0.00000', 'COU', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(191, 1, 'Afghan afghani', '', 'AFN', 971, '0.00000', '؋', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(192, 1, 'Tajikistani somoni', '', 'TJS', 972, '0.00000', 'ЅМ', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(193, 1, 'Angolan kwanza', '', 'AOA', 973, '0.00000', 'Kz', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(194, 1, 'Belarusian ruble', '', 'BYR', 974, '0.00000', 'p.', '0', '', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(195, 1, 'Bulgarian lev', '', 'BGN', 975, '0.00000', 'лв', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(196, 1, 'Congolese franc', '', 'CDF', 976, '0.00000', 'Fr', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(197, 1, 'Bosnia and Herzegovina convert', '', 'BAM', 977, '0.00000', 'KM', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(198, 1, 'Mexican Unid', '', 'MXV', 979, '0.00000', 'MXV', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(199, 1, 'Ukrainian hryvnia', '', 'UAH', 980, '0.00000', '₴', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(200, 1, 'Georgian lari', '', 'GEL', 981, '0.00000', 'ლ', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(201, 1, 'Mvdol', '', 'BOV', 984, '0.00000', 'BOV', '2', ',', '', '{number} {symbol}', '{sign}{number} {symbol}', 0, 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_customs`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_customs` (
  `virtuemart_custom_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `show_title` tinyint(1) NOT NULL DEFAULT 1,
  `custom_tip` varchar(255) NOT NULL DEFAULT '' COMMENT 'TIP',
  `custom_value` varchar(4095) DEFAULT NULL COMMENT 'DEFAULT VALUE',
  `custom_desc` varchar(4095) DEFAULT NULL COMMENT 'DESCRIPTION OR UNIT',
  `custom_parent_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1,
  `custom_jplugin_id` int(1) NOT NULL DEFAULT 0,
  `custom_element` varchar(50) NOT NULL DEFAULT '',
  `admin_only` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1:Display in admin only',
  `custom_title` varchar(255) NOT NULL DEFAULT '' COMMENT 'FIELD TITLE',
  `field_type` varchar(2) NOT NULL DEFAULT '0' COMMENT 'S:STRING,I:INT,P:PARENT, B:BOOL,D:DATE,T:TIME,H:HIDDEN',
  `is_list` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'list of values',
  `is_hidden` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1:hidden',
  `is_cart_attribute` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Add attributes to cart',
  `is_input` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Add input to cart',
  `searchable` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Available as search filter',
  `layout_pos` varchar(24) DEFAULT NULL COMMENT 'LAYOUT POSITION',
  `custom_params` text NOT NULL,
  `shared` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'VALID FOR ALL VENDORS?',
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `ordering` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_custom_id`),
  KEY `custom_parent_id` (`custom_parent_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `custom_element` (`custom_element`),
  KEY `field_type` (`field_type`),
  KEY `is_cart_attribute` (`is_cart_attribute`),
  KEY `is_input` (`is_input`),
  KEY `shared` (`shared`),
  KEY `published` (`published`),
  KEY `ordering` (`ordering`),
  KEY `searchable` (`searchable`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 COMMENT='custom fields definition';

INSERT INTO `#__virtuemart_customs` (`virtuemart_custom_id`, `show_title`, `custom_tip`, `custom_value`, `custom_desc`, `custom_parent_id`, `virtuemart_vendor_id`, `custom_jplugin_id`, `custom_element`, `admin_only`, `custom_title`, `field_type`, `is_list`, `is_hidden`, `is_cart_attribute`, `is_input`, `searchable`, `layout_pos`, `custom_params`, `shared`, `published`, `created_on`, `created_by`, `ordering`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 1, 'COM_VIRTUEMART_RELATED_PRODUCTS_TIP', '', 'COM_VIRTUEMART_RELATED_PRODUCTS_DESC', 0, 1, 0, '', 0, 'COM_VIRTUEMART_RELATED_PRODUCTS', 'R', 0, 0, 0, 0, 0, 'related_products', '', 0, 1, '2011-05-25 21:52:43', 62, 0, '2011-05-25 21:52:43', 62, '0000-00-00 00:00:00', 0),
(2, 1, 'COM_VIRTUEMART_RELATED_CATEGORIES_TIP', NULL, 'COM_VIRTUEMART_RELATED_CATEGORIES_DESC', 0, 1, 0, '', 0, 'COM_VIRTUEMART_RELATED_CATEGORIES', 'Z', 0, 0, 0, 0, 0, 'related_categories', '', 0, 1, '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(7, 1, 'Give a media ID as defaut', '1', 'Add a photo', 0, 1, 0, '0', 0, 'Photo:', 'M', 0, 0, 1, 0, 0, '', '0', 0, 1, '0000-00-00 00:00:00', 0, 0, '2013-04-16 20:26:25', 0, '0000-00-00 00:00:00', 0),
(9, 1, 'Select the chain size', '30', '', 0, 1, 0, '0', 0, 'Size:', 'S', 0, 0, 1, 1, 0, 'addtocart', '0', 0, 1, '0000-00-00 00:00:00', 0, 0, '2013-04-16 20:01:47', 0, '0000-00-00 00:00:00', 0),
(13, 1, '', 'radiobutton', 'Be important on your construction site, buy a red one', 0, 1, 0, '0', 0, 'Radiobutton:', 'S', 0, 0, 1, 0, 0, '', '0', 0, 1, '0000-00-00 00:00:00', 0, 0, '2013-04-16 20:11:06', 0, '0000-00-00 00:00:00', 0),
(21, 1, 'Select the color', 'Select the color', '', 0, 1, 0, '0', 0, 'Color:', 'S', 0, 0, 1, 1, 0, 'addtocart', '0', 0, 1, '0000-00-00 00:00:00', 0, 0, '2013-04-16 20:01:56', 0, '0000-00-00 00:00:00', 0),
(25, 1, '', '', '', 0, 1, 0, '0', 0, 'Specification by example:', 'G', 0, 0, 0, 0, 0, 'filter', '0', 0, 1, '0000-00-00 00:00:00', 0, 0, '2013-05-23 04:42:09', 0, '0000-00-00 00:00:00', 0),
(32, 1, '', '', '', 0, 1, 0, '0', 0, 'Specification default by example:', 'G', 0, 0, 0, 0, 0, '', '0', 0, 1, '2013-10-10 17:53:56', 0, 0, '2013-10-10 17:55:41', 0, '0000-00-00 00:00:00', 0),
(49, 1, '', 'cooltags', '', 0, 1, 10244, 'cooltags', 0, 'Tags', 'E', 0, 0, 0, 0, 0, 'tags', 'product_tags=\"\"|', 0, 1, '2015-05-10 17:49:10', 918, 0, '2015-05-10 17:49:10', 918, '0000-00-00 00:00:00', 0),
(40, 1, '', 'youtube', '', 0, 1, 10226, 'youtube', 0, 'Youtube Video', 'E', 0, 0, 0, 0, 0, 'video', '', 0, 1, '2014-10-13 21:13:42', 0, 0, '2014-10-13 21:26:40', 0, '0000-00-00 00:00:00', 0),
(39, 1, '', 'textinput', '', 0, 1, 10028, 'textinput', 0, 'input', 'E', 0, 0, 0, 1, 0, 'addtocart', 'custom_size=\"10\"|custom_price_by_letter=\"1\"|', 0, 1, '2014-10-13 20:45:44', 0, 0, '2014-10-13 20:45:44', 0, '0000-00-00 00:00:00', 0),
(41, 1, '', 'Lorem ipsum dolor', 'test', 0, 1, 0, '', 0, 'Test', 'Y', 0, 0, 0, 0, 0, 'custom', '', 0, 1, '2014-12-04 17:54:01', 0, 0, '2015-02-03 19:17:01', 304, '0000-00-00 00:00:00', 0),
(43, 1, '', 'param', '', 25, 1, 10231, 'param', 0, 'Option Test : type_1', 'E', 0, 0, 0, 0, 0, 'filter', 'n=\"Option Test : type_1\"|s=\"1\"|ft=\"text\"|t=\"checkbox\"|m=\"OR\"|af=\"0\"|av=\"\"|ld=\"\"|z=\"default\"|', 0, 1, '2015-02-04 18:36:29', 304, 0, '2015-02-04 18:57:39', 304, '0000-00-00 00:00:00', 0),
(44, 1, '', 'param', '', 25, 1, 10231, 'param', 0, 'Option Test : type_2', 'E', 0, 0, 0, 0, 0, 'filter', 'n=\"Type_2\"|s=\"1\"|ft=\"text\"|t=\"radio\"|m=\"OR\"|af=\"0\"|av=\"\"|ld=\"\"|z=\"default\"|', 0, 1, '2015-02-04 18:37:47', 304, 0, '2015-02-04 18:44:54', 304, '0000-00-00 00:00:00', 0),
(45, 1, '', 'param', '', 25, 1, 10231, 'param', 0, 'Option Test : type_3', 'E', 0, 0, 0, 0, 0, 'Option Test : type_3', 'n=\"Type_3\"|s=\"1\"|ft=\"int\"|t=\"slider_double\"|m=\"OR\"|af=\"0\"|av=\"\"|ld=\"\"|z=\"default\"|', 0, 1, '2015-02-04 18:39:24', 304, 0, '2015-02-04 18:45:18', 304, '0000-00-00 00:00:00', 0),
(46, 1, '', 'param', '', 25, 1, 10231, 'param', 0, 'Option Test : type_4', 'E', 0, 0, 0, 0, 0, 'filter', 'n=\"Type_4\"|s=\"1\"|ft=\"text\"|t=\"checkbox-colors\"|m=\"OR\"|af=\"0\"|av=\"\"|ld=\"\"|z=\"default\"|', 0, 1, '2015-02-04 18:41:26', 304, 0, '2015-02-04 18:45:31', 304, '0000-00-00 00:00:00', 0),
(47, 1, '', '', '', 0, 1, 0, '', 0, 'Generic child variant', 'A', 0, 0, 1, 0, 0, 'addtocart', 'withParent=\"1\"|parentOrderable=\"1\"|wPrice=\"1\"|', 0, 1, '2015-02-16 14:41:48', 567, 0, '2015-02-16 14:42:02', 567, '0000-00-00 00:00:00', 0),
(48, 1, '', '', '', 0, 1, 0, '', 0, 'Child Variant', 'C', 0, 0, 1, 0, 0, 'addtocart', 'selectoptions=\"1\"|clabels=\"1\"|options=\"1\"|', 0, 1, '2015-02-16 14:42:26', 567, 0, '2015-02-16 14:42:38', 567, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_invoices`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_invoices` (
  `virtuemart_invoice_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `invoice_number` varchar(64) DEFAULT NULL,
  `order_status` char(2) DEFAULT NULL,
  `xhtml` text DEFAULT NULL,
  `o_hash` varchar(33) DEFAULT NULL,
  `inv_hash` varchar(33) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_invoice_id`),
  UNIQUE KEY `invoice_number` (`invoice_number`,`virtuemart_vendor_id`),
  KEY `virtuemart_order_id` (`virtuemart_order_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='custom fields definition';

DROP TABLE IF EXISTS `#__virtuemart_manufacturercategories`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturercategories` (
  `virtuemart_manufacturercategories_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_manufacturercategories_id`),
  KEY `published` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Manufacturers are assigned to these categories';

INSERT INTO `#__virtuemart_manufacturercategories` (`virtuemart_manufacturercategories_id`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:34:45', 179, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_manufacturercategories_de_de`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturercategories_de_de` (
  `virtuemart_manufacturercategories_id` int(1) UNSIGNED NOT NULL,
  `mf_category_name` varchar(180) NOT NULL DEFAULT '',
  `mf_category_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturercategories_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturercategories_de_de` (`virtuemart_manufacturercategories_id`, `mf_category_name`, `mf_category_desc`, `slug`) VALUES
(1, '-default-', 'This is the default manufacturer category', 'default');

DROP TABLE IF EXISTS `#__virtuemart_manufacturercategories_en_gb`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturercategories_en_gb` (
  `virtuemart_manufacturercategories_id` int(1) UNSIGNED NOT NULL,
  `mf_category_name` varchar(180) NOT NULL DEFAULT '',
  `mf_category_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturercategories_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturercategories_en_gb` (`virtuemart_manufacturercategories_id`, `mf_category_name`, `mf_category_desc`, `slug`) VALUES
(1, '-default-', 'This is the default manufacturer category', '-default-');

DROP TABLE IF EXISTS `#__virtuemart_manufacturercategories_es_es`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturercategories_es_es` (
  `virtuemart_manufacturercategories_id` int(1) UNSIGNED NOT NULL,
  `mf_category_name` char(180) NOT NULL DEFAULT '',
  `mf_category_desc` varchar(20000) NOT NULL DEFAULT '',
  `slug` char(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturercategories_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__virtuemart_manufacturercategories_fr_fr`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturercategories_fr_fr` (
  `virtuemart_manufacturercategories_id` int(1) UNSIGNED NOT NULL,
  `mf_category_name` varchar(180) NOT NULL DEFAULT '',
  `mf_category_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturercategories_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturercategories_fr_fr` (`virtuemart_manufacturercategories_id`, `mf_category_name`, `mf_category_desc`, `slug`) VALUES
(1, '-default-', 'This is the default manufacturer category', 'default');

DROP TABLE IF EXISTS `#__virtuemart_manufacturercategories_he_il`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturercategories_he_il` (
  `virtuemart_manufacturercategories_id` int(1) UNSIGNED NOT NULL,
  `mf_category_name` varchar(180) NOT NULL DEFAULT '',
  `mf_category_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturercategories_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturercategories_he_il` (`virtuemart_manufacturercategories_id`, `mf_category_name`, `mf_category_desc`, `slug`) VALUES
(1, '-default-', 'This is the default manufacturer category', 'default');

DROP TABLE IF EXISTS `#__virtuemart_manufacturercategories_it_it`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturercategories_it_it` (
  `virtuemart_manufacturercategories_id` int(1) UNSIGNED NOT NULL,
  `mf_category_name` varchar(180) NOT NULL DEFAULT '',
  `mf_category_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturercategories_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturercategories_it_it` (`virtuemart_manufacturercategories_id`, `mf_category_name`, `mf_category_desc`, `slug`) VALUES
(1, '-default-', 'This is the default manufacturer category', 'default');

DROP TABLE IF EXISTS `#__virtuemart_manufacturercategories_ru_ru`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturercategories_ru_ru` (
  `virtuemart_manufacturercategories_id` int(1) UNSIGNED NOT NULL,
  `mf_category_name` varchar(180) NOT NULL DEFAULT '',
  `mf_category_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturercategories_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturercategories_ru_ru` (`virtuemart_manufacturercategories_id`, `mf_category_name`, `mf_category_desc`, `slug`) VALUES
(1, '-default-', 'This is the default manufacturer category', 'default');

DROP TABLE IF EXISTS `#__virtuemart_manufacturers`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturers` (
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_manufacturercategories_id` int(1) DEFAULT NULL,
  `metarobot` varchar(400) DEFAULT NULL,
  `metaauthor` varchar(400) DEFAULT NULL,
  `hits` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_manufacturer_id`),
  UNIQUE KEY `virtuemart_manufacturercategories_id` (`virtuemart_manufacturer_id`,`virtuemart_manufacturercategories_id`),
  KEY `published` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='Manufacturers are those who deliver products';

INSERT INTO `#__virtuemart_manufacturers` (`virtuemart_manufacturer_id`, `virtuemart_manufacturercategories_id`, `metarobot`, `metaauthor`, `hits`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 1, NULL, NULL, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:34:02', 179, '0000-00-00 00:00:00', 0),
(2, 1, NULL, NULL, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:34:05', 179, '0000-00-00 00:00:00', 0),
(3, 1, NULL, NULL, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:39', 179, '0000-00-00 00:00:00', 0),
(4, 1, NULL, NULL, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:34', 179, '0000-00-00 00:00:00', 0),
(5, 1, NULL, NULL, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:31', 179, '0000-00-00 00:00:00', 0),
(6, 1, NULL, NULL, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:27', 179, '0000-00-00 00:00:00', 0),
(7, 1, NULL, NULL, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:24', 179, '0000-00-00 00:00:00', 0),
(8, 1, NULL, NULL, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:20', 179, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_manufacturers_de_de`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturers_de_de` (
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL,
  `mf_name` varchar(180) NOT NULL DEFAULT '',
  `mf_email` varchar(255) NOT NULL DEFAULT '',
  `mf_desc` varchar(19000) NOT NULL DEFAULT '',
  `mf_url` varchar(255) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturer_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturers_de_de` (`virtuemart_manufacturer_id`, `mf_name`, `mf_email`, `mf_desc`, `mf_url`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Manufacturer-1', ' Manufacturer-1@example.org', '<p>An example for a manufacturer-1</p>', 'http://www.example.org', '', '', '', 'brand-example-1'),
(2, 'Manufacturer-2', ' Manufacturer-2@example.org', '<p>An example for a manufacturer-2</p>', 'http://www.brand-example.org', '', '', '', 'brand-example-2'),
(3, 'Manufacturer-3', ' Manufacturer-3@example.org', '<p>An example for a manufacturer-3</p>', 'http://www.lorem.org', '', '', '', 'brand-example-3'),
(4, 'Manufacturer-4', ' Manufacturer-4@example.org', '<p>An example for a manufacturer-4</p>', 'http://www.ipsum.org', '', '', '', 'brand-example-4'),
(5, 'Manufacturer-5', ' Manufacturer-5@example.org', '<p>An example for a manufacturer-5</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-5'),
(6, 'Manufacturer-6', ' Manufacturer-6@example.org', '<p>An example for a manufacturer-6</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-6'),
(7, 'Manufacturer-7', ' Manufacturer-7@example.org', '<p>An example for a manufacturer-7</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-7'),
(8, 'Manufacturer-8', ' Manufacturer-8@example.org', '<p>An example for a manufacturer-8</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-8');

DROP TABLE IF EXISTS `#__virtuemart_manufacturers_en_gb`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturers_en_gb` (
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL,
  `mf_name` varchar(180) NOT NULL DEFAULT '',
  `mf_email` varchar(255) NOT NULL DEFAULT '',
  `mf_desc` varchar(19000) NOT NULL DEFAULT '',
  `mf_url` varchar(255) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturer_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturers_en_gb` (`virtuemart_manufacturer_id`, `mf_name`, `mf_email`, `mf_desc`, `mf_url`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Manufacturer-1', ' Manufacturer-1@example.org', '<p>An example for a manufacturer-1</p>', 'http://www.example.org', '', '', '', 'brand-example-1'),
(2, 'Manufacturer-2', ' Manufacturer-2@example.org', '<p>An example for a manufacturer-2</p>', 'http://www.brand-example.org', '', '', '', 'brand-example-2'),
(3, 'Manufacturer-3', ' Manufacturer-3@example.org', 'An example for a manufacturer-3', 'http://www.lorem.org', '', '', '', 'brand-example-3'),
(4, 'Manufacturer-4', ' Manufacturer-4@example.org', 'An example for a manufacturer-4', 'http://www.ipsum.org', '', '', '', 'brand-example-4'),
(5, 'Manufacturer-5', ' Manufacturer-5@example.org', 'An example for a manufacturer-5', 'http://www.dolorem.org', '', '', '', 'brand-example-5'),
(6, 'Manufacturer-6', ' Manufacturer-6@example.org', 'An example for a manufacturer-6', 'http://www.dolorem.org', '', '', '', 'brand-example-6'),
(7, 'Manufacturer-7', ' Manufacturer-7@example.org', 'An example for a manufacturer-7', 'http://www.dolorem.org', '', '', '', 'brand-example-7'),
(8, 'Manufacturer-8', ' Manufacturer-8@example.org', '<p>An example for a manufacturer-8</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-8');

DROP TABLE IF EXISTS `#__virtuemart_manufacturers_es_es`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturers_es_es` (
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL,
  `mf_name` char(180) NOT NULL DEFAULT '',
  `mf_email` char(255) NOT NULL DEFAULT '',
  `mf_desc` varchar(20000) NOT NULL DEFAULT '',
  `mf_url` char(255) NOT NULL DEFAULT '',
  `slug` char(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturer_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__virtuemart_manufacturers_fr_fr`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturers_fr_fr` (
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL,
  `mf_name` varchar(180) NOT NULL DEFAULT '',
  `mf_email` varchar(255) NOT NULL DEFAULT '',
  `mf_desc` varchar(19000) NOT NULL DEFAULT '',
  `mf_url` varchar(255) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturer_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturers_fr_fr` (`virtuemart_manufacturer_id`, `mf_name`, `mf_email`, `mf_desc`, `mf_url`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Manufacturer-1', ' Manufacturer-1@example.org', '<p>An example for a manufacturer-1</p>', 'http://www.example.org', '', '', '', 'brand-example-1'),
(2, 'Manufacturer-2', ' Manufacturer-2@example.org', '<p>An example for a manufacturer-2</p>', 'http://www.brand-example.org', '', '', '', 'brand-example-2'),
(3, 'Manufacturer-3', ' Manufacturer-3@example.org', '<p>An example for a manufacturer-3</p>', 'http://www.lorem.org', '', '', '', 'brand-example-3'),
(4, 'Manufacturer-4', ' Manufacturer-4@example.org', '<p>An example for a manufacturer-4</p>', 'http://www.ipsum.org', '', '', '', 'brand-example-4'),
(5, 'Manufacturer-5', ' Manufacturer-5@example.org', '<p>An example for a manufacturer-5</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-5'),
(6, 'Manufacturer-6', ' Manufacturer-6@example.org', '<p>An example for a manufacturer-6</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-6'),
(7, 'Manufacturer-7', ' Manufacturer-7@example.org', '<p>An example for a manufacturer-7</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-7'),
(8, 'Manufacturer-8', ' Manufacturer-8@example.org', '<p>An example for a manufacturer-8</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-8');

DROP TABLE IF EXISTS `#__virtuemart_manufacturers_he_il`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturers_he_il` (
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL,
  `mf_name` varchar(180) NOT NULL DEFAULT '',
  `mf_email` varchar(255) NOT NULL DEFAULT '',
  `mf_desc` varchar(19000) NOT NULL DEFAULT '',
  `mf_url` varchar(255) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturer_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturers_he_il` (`virtuemart_manufacturer_id`, `mf_name`, `mf_email`, `mf_desc`, `mf_url`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Manufacturer-1', ' Manufacturer-1@example.org', '<p>An example for a manufacturer-1</p>', 'http://www.example.org', '', '', '', 'brand-example-1'),
(2, 'Manufacturer-2', ' Manufacturer-2@example.org', '<p>An example for a manufacturer-2</p>', 'http://www.brand-example.org', '', '', '', 'brand-example-2'),
(8, 'Manufacturer-8', ' Manufacturer-8@example.org', '<p>An example for a manufacturer-8</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-8'),
(7, 'Manufacturer-7', ' Manufacturer-7@example.org', 'An example for a manufacturer-7', 'http://www.dolorem.org', '', '', '', 'brand-example-7'),
(6, 'Manufacturer-6', ' Manufacturer-6@example.org', 'An example for a manufacturer-6', 'http://www.dolorem.org', '', '', '', 'brand-example-6'),
(5, 'Manufacturer-5', ' Manufacturer-5@example.org', 'An example for a manufacturer-5', 'http://www.dolorem.org', '', '', '', 'brand-example-5'),
(4, 'Manufacturer-4', ' Manufacturer-4@example.org', 'An example for a manufacturer-4', 'http://www.ipsum.org', '', '', '', 'brand-example-4'),
(3, 'Manufacturer-3', ' Manufacturer-3@example.org', 'An example for a manufacturer-3', 'http://www.lorem.org', '', '', '', 'brand-example-3');

DROP TABLE IF EXISTS `#__virtuemart_manufacturers_it_it`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturers_it_it` (
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL,
  `mf_name` varchar(180) NOT NULL DEFAULT '',
  `mf_email` varchar(255) NOT NULL DEFAULT '',
  `mf_desc` varchar(19000) NOT NULL DEFAULT '',
  `mf_url` varchar(255) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturer_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturers_it_it` (`virtuemart_manufacturer_id`, `mf_name`, `mf_email`, `mf_desc`, `mf_url`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Manufacturer-1', ' Manufacturer-1@example.org', '<p>An example for a manufacturer-1</p>', 'http://www.example.org', '', '', '', 'brand-example-1'),
(2, 'Manufacturer-2', ' Manufacturer-2@example.org', '<p>An example for a manufacturer-2</p>', 'http://www.brand-example.org', '', '', '', 'brand-example-2'),
(3, 'Manufacturer-3', ' Manufacturer-3@example.org', '<p>An example for a manufacturer-3</p>', 'http://www.lorem.org', '', '', '', 'brand-example-3'),
(4, 'Manufacturer-4', ' Manufacturer-4@example.org', '<p>An example for a manufacturer-4</p>', 'http://www.ipsum.org', '', '', '', 'brand-example-4'),
(5, 'Manufacturer-5', ' Manufacturer-5@example.org', '<p>An example for a manufacturer-5</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-5'),
(6, 'Manufacturer-6', ' Manufacturer-6@example.org', '<p>An example for a manufacturer-6</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-6'),
(7, 'Manufacturer-7', ' Manufacturer-7@example.org', '<p>An example for a manufacturer-7</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-7'),
(8, 'Manufacturer-8', ' Manufacturer-8@example.org', '<p>An example for a manufacturer-8</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-8');

DROP TABLE IF EXISTS `#__virtuemart_manufacturers_ru_ru`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturers_ru_ru` (
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL,
  `mf_name` varchar(180) NOT NULL DEFAULT '',
  `mf_email` varchar(255) NOT NULL DEFAULT '',
  `mf_desc` varchar(19000) NOT NULL DEFAULT '',
  `mf_url` varchar(255) NOT NULL DEFAULT '',
  `metadesc` varchar(400) NOT NULL DEFAULT '',
  `metakey` varchar(400) NOT NULL DEFAULT '',
  `customtitle` varchar(255) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_manufacturer_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturers_ru_ru` (`virtuemart_manufacturer_id`, `mf_name`, `mf_email`, `mf_desc`, `mf_url`, `metadesc`, `metakey`, `customtitle`, `slug`) VALUES
(1, 'Manufacturer-1', ' Manufacturer-1@example.org', '<p>An example for a manufacturer-1</p>', 'http://www.example.org', '', '', '', 'brand-example-1'),
(2, 'Manufacturer-2', ' Manufacturer-2@example.org', '<p>An example for a manufacturer-2</p>', 'http://www.brand-example.org', '', '', '', 'brand-example-2'),
(3, 'Manufacturer-3', ' Manufacturer-3@example.org', '<p>An example for a manufacturer-3</p>', 'http://www.lorem.org', '', '', '', 'brand-example-3'),
(4, 'Manufacturer-4', ' Manufacturer-4@example.org', '<p>An example for a manufacturer-4</p>', 'http://www.ipsum.org', '', '', '', 'brand-example-4'),
(5, 'Manufacturer-5', ' Manufacturer-5@example.org', '<p>An example for a manufacturer-5</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-5'),
(6, 'Manufacturer-6', ' Manufacturer-6@example.org', '<p>An example for a manufacturer-6</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-6'),
(7, 'Manufacturer-7', ' Manufacturer-7@example.org', '<p>An example for a manufacturer-7</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-7'),
(8, 'Manufacturer-8', ' Manufacturer-8@example.org', '<p>An example for a manufacturer-8</p>', 'http://www.dolorem.org', '', '', '', 'brand-example-8');

DROP TABLE IF EXISTS `#__virtuemart_manufacturer_medias`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_manufacturer_medias` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_manufacturer_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_media_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `ordering` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `virtuemart_manufacturer_id` (`virtuemart_manufacturer_id`,`virtuemart_media_id`),
  KEY `ordering` (`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_manufacturer_medias` (`id`, `virtuemart_manufacturer_id`, `virtuemart_media_id`, `ordering`) VALUES
(1, 1, 1, 1),
(2, 2, 2, 1),
(3, 3, 3, 1),
(4, 4, 4, 1),
(5, 5, 5, 1),
(6, 6, 6, 1),
(7, 7, 7, 1),
(8, 8, 8, 1);

DROP TABLE IF EXISTS `#__virtuemart_medias`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_medias` (
  `virtuemart_media_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1,
  `file_title` varchar(126) NOT NULL DEFAULT '',
  `file_description` varchar(254) NOT NULL DEFAULT '',
  `file_meta` varchar(254) NOT NULL DEFAULT '',
  `file_class` varchar(64) NOT NULL DEFAULT '',
  `file_mimetype` varchar(64) NOT NULL DEFAULT '',
  `file_type` varchar(32) NOT NULL DEFAULT '',
  `file_url` varchar(900) NOT NULL DEFAULT '',
  `file_url_thumb` varchar(900) NOT NULL DEFAULT '',
  `file_is_product_image` tinyint(1) NOT NULL DEFAULT 0,
  `file_is_downloadable` tinyint(1) NOT NULL DEFAULT 0,
  `file_is_forSale` tinyint(1) NOT NULL DEFAULT 0,
  `file_params` varchar(12287) NOT NULL DEFAULT '',
  `file_lang` varchar(500) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `shared` tinyint(1) NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_media_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `published` (`published`),
  KEY `file_type` (`file_type`),
  KEY `shared` (`shared`)
) ENGINE=MyISAM AUTO_INCREMENT=2054 DEFAULT CHARSET=utf8 COMMENT='Additional Images and Files which are assigned to products';

INSERT INTO `#__virtuemart_medias` (`virtuemart_media_id`, `virtuemart_vendor_id`, `file_title`, `file_description`, `file_meta`, `file_class`, `file_mimetype`, `file_type`, `file_url`, `file_url_thumb`, `file_is_product_image`, `file_is_downloadable`, `file_is_forSale`, `file_params`, `file_lang`, `ordering`, `shared`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 1, 'brand01.png', 'brand01', '', '', 'image/png', 'manufacturer', 'images/stories/virtuemart/manufacturer/brand01.png', 'images/stories/virtuemart/manufacturer/resized/brand01_resized.png', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:34:02', 0, '0000-00-00 00:00:00', 0),
(2, 1, 'brand02.png', 'brand02', '', '', 'image/png', 'manufacturer', 'images/stories/virtuemart/manufacturer/brand02.png', 'images/stories/virtuemart/manufacturer/resized/brand02_resized.png', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:34:05', 0, '0000-00-00 00:00:00', 0),
(3, 1, 'brand03.png', 'brand03', '', '', 'image/png', 'manufacturer', 'images/stories/virtuemart/manufacturer/brand03.png', 'images/stories/virtuemart/manufacturer/resized/brand03_resized.png', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:39', 0, '0000-00-00 00:00:00', 0),
(4, 1, 'brand04.png', 'brand04', '', '', 'image/png', 'manufacturer', 'images/stories/virtuemart/manufacturer/brand04.png', 'images/stories/virtuemart/manufacturer/resized/brand04_resized.png', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:34', 0, '0000-00-00 00:00:00', 0),
(5, 1, 'brand05.png', 'brand05', '', '', 'image/png', 'manufacturer', 'images/stories/virtuemart/manufacturer/brand05.png', 'images/stories/virtuemart/manufacturer/resized/brand05_resized.png', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:31', 0, '0000-00-00 00:00:00', 0),
(6, 1, 'brand06.png', 'brand06', '', '', 'image/png', 'manufacturer', 'images/stories/virtuemart/manufacturer/brand06.png', 'images/stories/virtuemart/manufacturer/resized/brand06_resized.png', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:27', 0, '0000-00-00 00:00:00', 0),
(7, 1, 'brand07.png', 'brand07', '', '', 'image/png', 'manufacturer', 'images/stories/virtuemart/manufacturer/brand07.png', 'images/stories/virtuemart/manufacturer/resized/brand07_resized.png', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:24', 0, '0000-00-00 00:00:00', 0),
(8, 1, 'brand08.png', 'brand08', '', '', 'image/png', 'manufacturer', 'images/stories/virtuemart/manufacturer/brand08.png', 'images/stories/virtuemart/manufacturer/resized/brand08_resized.png', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:43:20', 0, '0000-00-00 00:00:00', 0),
(100, 1, 'product01.jpg', 'product01', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product01.jpg', 'images/stories/virtuemart/product/resized/product01_resized.jpg', 0, 0, 0, '', '', 0, 0, 0, '0000-00-00 00:00:00', 0, '2014-01-26 14:46:55', 0, '0000-00-00 00:00:00', 0),
(101, 1, 'product02.jpg', 'product02', 'product02', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product02.jpg', '', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2018-10-13 15:47:09', 0, '0000-00-00 00:00:00', 0),
(102, 1, 'product03.jpg', 'product03', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product03.jpg', 'images/stories/virtuemart/product/resized/product03_280x280.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2018-10-13 18:37:05', 0, '0000-00-00 00:00:00', 0),
(103, 1, 'product04.jpg', 'product04', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product04.jpg', 'images/stories/virtuemart/product/resized/product04_280x280.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-12-08 20:02:09', 0, '0000-00-00 00:00:00', 0),
(104, 1, 'product05.jpg', 'product05', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product05.jpg', 'images/stories/virtuemart/product/resized/product05_280x280.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2018-10-13 15:53:18', 0, '0000-00-00 00:00:00', 0),
(105, 1, 'product06.jpg', 'product06', 'Lorem ipsum dolor', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product06.jpg', 'images/stories/virtuemart/product/resized/product06_280x280.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2018-10-13 15:54:18', 0, '0000-00-00 00:00:00', 0),
(106, 1, 'product07.jpg', 'product07', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product07.jpg', 'images/stories/virtuemart/product/resized/product07_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-05-10 17:51:21', 0, '0000-00-00 00:00:00', 0),
(107, 1, 'product08.jpg', 'product08', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product08.jpg', 'images/stories/virtuemart/product/resized/product08_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-05-10 17:51:48', 0, '0000-00-00 00:00:00', 0),
(108, 1, 'product09.jpg', 'product09', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product09.jpg', 'images/stories/virtuemart/product/resized/product09_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-23 11:06:52', 0, '0000-00-00 00:00:00', 0),
(109, 1, 'product10.jpg', 'product10', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product10.jpg', 'images/stories/virtuemart/product/resized/product10_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-23 11:07:06', 0, '0000-00-00 00:00:00', 0),
(110, 1, 'product11.jpg', 'product11', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product11.jpg', 'images/stories/virtuemart/product/resized/product11_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-23 11:07:25', 0, '0000-00-00 00:00:00', 0),
(111, 1, 'product12.jpg', 'product12', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product12.jpg', 'images/stories/virtuemart/product/resized/product12_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-23 11:07:39', 0, '0000-00-00 00:00:00', 0),
(112, 1, 'product13.jpg', 'product13', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product13.jpg', 'images/stories/virtuemart/product/resized/product13_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:32:37', 0, '0000-00-00 00:00:00', 0),
(113, 1, 'product14.jpg', 'product14', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product14.jpg', 'images/stories/virtuemart/product/resized/product14_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2015-03-12 17:32:40', 0, '0000-00-00 00:00:00', 0),
(114, 1, 'product15.jpg', 'product15', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product15.jpg', 'images/stories/virtuemart/product/resized/product15_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:32:43', 0, '0000-00-00 00:00:00', 0),
(115, 1, 'product16.jpg', 'product16', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product16.jpg', 'images/stories/virtuemart/product/resized/product16_280x280.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2018-10-13 15:47:00', 0, '0000-00-00 00:00:00', 0),
(116, 1, 'product17.jpg', 'product17', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product17.jpg', 'images/stories/virtuemart/product/resized/product17_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2013-09-02 18:36:44', 0, '0000-00-00 00:00:00', 0),
(117, 1, 'product18.jpg', 'product18', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product18.jpg', 'images/stories/virtuemart/product/resized/product18_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:32:54', 0, '0000-00-00 00:00:00', 0),
(118, 1, 'product19.jpg', 'product19', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product19.jpg', 'images/stories/virtuemart/product/resized/product19_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2015-03-12 17:32:57', 0, '0000-00-00 00:00:00', 0),
(119, 1, 'product20.jpg', 'product20', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product20.jpg', 'images/stories/virtuemart/product/resized/product20_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-09-02 18:36:56', 0, '0000-00-00 00:00:00', 0),
(120, 1, 'product21.jpg', 'product21', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product21.jpg', 'images/stories/virtuemart/product/resized/product21_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-09-02 18:36:59', 0, '0000-00-00 00:00:00', 0),
(121, 1, 'product22.jpg', 'product22', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product22.jpg', 'images/stories/virtuemart/product/resized/product22_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2014-01-26 22:11:56', 0, '0000-00-00 00:00:00', 0),
(122, 1, 'product23.jpg', 'product23', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product23.jpg', 'images/stories/virtuemart/product/resized/product23_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-23 11:09:38', 0, '0000-00-00 00:00:00', 0),
(123, 1, 'product24.jpg', 'product24', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product24.jpg', 'images/stories/virtuemart/product/resized/product24_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2014-01-26 15:53:57', 0, '0000-00-00 00:00:00', 0),
(124, 1, 'product25.jpg', 'product25', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product25.jpg', 'images/stories/virtuemart/product/resized/product25_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2013-09-02 18:38:23', 0, '0000-00-00 00:00:00', 0),
(125, 1, 'product26.jpg', 'product26', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product26.jpg', 'images/stories/virtuemart/product/resized/product26_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2013-09-02 18:38:26', 0, '0000-00-00 00:00:00', 0),
(126, 1, 'product27.jpg', 'product27', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product27.jpg', 'images/stories/virtuemart/product/resized/product27_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-09-02 18:38:29', 0, '0000-00-00 00:00:00', 0),
(127, 1, 'product28.jpg', 'product28', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product28.jpg', 'images/stories/virtuemart/product/resized/product28_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2013-09-02 18:38:32', 0, '0000-00-00 00:00:00', 0),
(128, 1, 'product29.jpg', 'product29', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product29.jpg', 'images/stories/virtuemart/product/resized/product29_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2013-09-02 18:38:35', 0, '0000-00-00 00:00:00', 0),
(129, 1, 'product30.jpg', 'product30', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product30.jpg', 'images/stories/virtuemart/product/resized/product30_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2014-10-13 21:50:54', 0, '0000-00-00 00:00:00', 0),
(130, 1, 'product31.jpg', 'product31', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product31.jpg', 'images/stories/virtuemart/product/resized/product31_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2014-01-26 22:11:50', 0, '0000-00-00 00:00:00', 0),
(131, 1, 'product32.jpg', 'product32', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product32.jpg', 'images/stories/virtuemart/product/resized/product32_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2014-01-26 21:16:41', 0, '0000-00-00 00:00:00', 0),
(132, 1, 'product33.jpg', 'product33', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product33.jpg', 'images/stories/virtuemart/product/resized/product33_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2018-07-25 17:04:33', 0, '0000-00-00 00:00:00', 0),
(133, 1, 'product34.jpg', 'product34', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product34.jpg', 'images/stories/virtuemart/product/resized/product34_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-09-02 18:38:53', 0, '0000-00-00 00:00:00', 0),
(134, 1, 'product35.jpg', 'product35', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product35.jpg', 'images/stories/virtuemart/product/resized/product35_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2014-01-26 22:11:44', 0, '0000-00-00 00:00:00', 0),
(135, 1, 'product36.jpg', 'product36', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product36.jpg', 'images/stories/virtuemart/product/resized/product36_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-09-29 10:18:54', 0, '0000-00-00 00:00:00', 0),
(1000, 1, 'product02_thumb01.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_01/product02_thumb01.jpg', 'images/stories/virtuemart/product/resized/thumb_01/product02_thumb01_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1001, 1, 'product03_thumb01.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_01/product03_thumb01.jpg', 'images/stories/virtuemart/product/resized/thumb_01/product03_thumb01_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1002, 1, 'product04_thumb01.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_01/product04_thumb01.jpg', 'images/stories/virtuemart/product/resized/thumb_01/product04_thumb01_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1003, 1, 'product05_thumb01.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_01/product05_thumb01.jpg', 'images/stories/virtuemart/product/resized/thumb_01/product05_thumb01_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1004, 1, 'product06_thumb01.jpg', '', 'Magnum ipsum dolor', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/thumb_01/product06_thumb01.jpg', 'images/stories/virtuemart/product/resized/thumb_01/product06_thumb01_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2014-05-15 10:49:47', 0, '0000-00-00 00:00:00', 0),
(1005, 1, 'product07_thumb01.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_01/product07_thumb01.jpg', 'images/stories/virtuemart/product/resized/thumb_01/product07_thumb01_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1006, 1, 'product08_thumb01.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_01/product08_thumb01.jpg', 'images/stories/virtuemart/product/resized/thumb_01/product08_thumb01_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1007, 1, 'product09_thumb01.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_01/product09_thumb01.jpg', 'images/stories/virtuemart/product/resized/thumb_01/product09_thumb01_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1008, 1, 'product03_thumb02.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_02/product03_thumb02.jpg', 'images/stories/virtuemart/product/resized/thumb_02/product03_thumb02_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1009, 1, 'product04_thumb02.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_02/product04_thumb02.jpg', 'images/stories/virtuemart/product/resized/thumb_02/product04_thumb02_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1010, 1, 'product05_thumb02.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_02/product05_thumb02.jpg', 'images/stories/virtuemart/product/resized/thumb_02/product05_thumb02_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1011, 1, 'product06_thumb02.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_02/product06_thumb02.jpg', 'images/stories/virtuemart/product/resized/thumb_02/product06_thumb02_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1012, 1, 'product07_thumb02.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_02/product07_thumb02.jpg', 'images/stories/virtuemart/product/resized/thumb_02/product07_thumb02_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1013, 1, 'product08_thumb02.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_02/product08_thumb02.jpg', 'images/stories/virtuemart/product/resized/thumb_02/product08_thumb02_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1014, 1, 'product09_thumb02.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_02/product09_thumb02.jpg', 'images/stories/virtuemart/product/resized/thumb_02/product09_thumb02_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1015, 1, 'product04_thumb03.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_03/product04_thumb03.jpg', 'images/stories/virtuemart/product/resized/thumb_03/product04_thumb03_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1016, 1, 'product05_thumb03.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_03/product05_thumb03.jpg', 'images/stories/virtuemart/product/resized/thumb_03/product05_thumb03_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1017, 1, 'product06_thumb03.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_03/product06_thumb03.jpg', 'images/stories/virtuemart/product/resized/thumb_03/product06_thumb03_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1018, 1, 'product05_thumb04.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_04/product05_thumb04.jpg', 'images/stories/virtuemart/product/resized/thumb_04/product05_thumb04_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1019, 1, 'product06_thumb04.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_04/product06_thumb04.jpg', 'images/stories/virtuemart/product/resized/thumb_04/product06_thumb04_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1020, 1, 'product05_thumb05.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_05/product05_thumb05.jpg', 'images/stories/virtuemart/product/resized/thumb_05/product05_thumb05_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1021, 1, 'product06_thumb05.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_05/product06_thumb05.jpg', 'images/stories/virtuemart/product/resized/thumb_05/product06_thumb05_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(1022, 1, 'product06_thumb06.jpg', '', '', '', 'image/jpg', 'product', 'images/stories/virtuemart/product/thumb_06/product06_thumb06.jpg', 'images/stories/virtuemart/product/resized/thumb_06/product06_thumb06_resized.jpg', 1, 0, 0, '', '', 0, 0, 1, '2012-01-10 15:32:01', 0, '2012-01-10 15:32:01', 0, '0000-00-00 00:00:00', 0),
(2000, 1, 'category01.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat01.jpg', '', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2016-03-31 19:23:58', 196, '0000-00-00 00:00:00', 0),
(2048, 1, '1449856864297.png', '', '', '', 'image/png', 'product', 'images/stories/virtuemart/product/1449856864297.png', '', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(2001, 1, 'category02.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat02.jpg', 'images/stories/virtuemart/category/resized/cat02_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:04', 0, '0000-00-00 00:00:00', 0),
(2002, 1, 'category03.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat03.jpg', 'images/stories/virtuemart/category/resized/cat03_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:06', 0, '0000-00-00 00:00:00', 0),
(2003, 1, 'category04.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat04.jpg', 'images/stories/virtuemart/category/resized/cat04_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:33', 0, '0000-00-00 00:00:00', 0),
(2004, 1, 'category05.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat05.jpg', 'images/stories/virtuemart/category/resized/cat05_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:46', 0, '0000-00-00 00:00:00', 0),
(2005, 1, 'category06.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat06.jpg', 'images/stories/virtuemart/category/resized/cat06_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:16', 0, '0000-00-00 00:00:00', 0),
(2006, 1, 'category07.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat07.jpg', 'images/stories/virtuemart/category/resized/cat07_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:58', 0, '0000-00-00 00:00:00', 0),
(2007, 1, 'categoryt08.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat08.jpg', 'images/stories/virtuemart/category/resized/cat08_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:34:10', 0, '0000-00-00 00:00:00', 0),
(2008, 1, 'category09.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat09.jpg', 'images/stories/virtuemart/category/resized/cat09_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:37', 0, '0000-00-00 00:00:00', 0),
(2009, 1, 'category10.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat10.jpg', 'images/stories/virtuemart/category/resized/cat10_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:54', 0, '0000-00-00 00:00:00', 0),
(2010, 1, 'category11.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat11.jpg', 'images/stories/virtuemart/category/resized/cat11_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:41', 0, '0000-00-00 00:00:00', 0),
(2011, 1, 'category12.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat12.jpg', 'images/stories/virtuemart/category/resized/cat12_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:33', 0, '0000-00-00 00:00:00', 0),
(2012, 1, 'category13.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat13.jpg', 'images/stories/virtuemart/category/resized/cat13_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:34:04', 0, '0000-00-00 00:00:00', 0),
(2013, 1, 'category14.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat14.jpg', 'images/stories/virtuemart/category/resized/cat14_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:35:36', 0, '0000-00-00 00:00:00', 0),
(2014, 1, 'category15.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat15.jpg', 'images/stories/virtuemart/category/resized/cat15_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:35:31', 0, '0000-00-00 00:00:00', 0),
(2015, 1, 'category16.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat16.jpg', 'images/stories/virtuemart/category/resized/cat16_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:53', 0, '0000-00-00 00:00:00', 0),
(2016, 1, 'category17.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat17.jpg', 'images/stories/virtuemart/category/resized/cat17_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:35:27', 0, '0000-00-00 00:00:00', 0),
(2017, 1, 'category18.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat18.jpg', 'images/stories/virtuemart/category/resized/cat18_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:56', 0, '0000-00-00 00:00:00', 0),
(2018, 1, 'categoryt19.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat19.jpg', 'images/stories/virtuemart/category/resized/cat19_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:50', 0, '0000-00-00 00:00:00', 0),
(2019, 1, 'category20.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat20.jpg', 'images/stories/virtuemart/category/resized/cat20_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:01', 0, '0000-00-00 00:00:00', 0),
(2020, 1, 'category21.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat21.jpg', 'images/stories/virtuemart/category/resized/cat21_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:31', 0, '0000-00-00 00:00:00', 0),
(2021, 1, 'category22.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat22.jpg', 'images/stories/virtuemart/category/resized/cat22_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:27', 0, '0000-00-00 00:00:00', 0),
(2022, 1, 'category23.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat23.jpg', 'images/stories/virtuemart/category/resized/cat23_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:33:22', 0, '0000-00-00 00:00:00', 0),
(2023, 1, 'category24.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat24.jpg', 'images/stories/virtuemart/category/resized/cat24_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:27', 0, '0000-00-00 00:00:00', 0),
(2024, 1, 'category25.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat25.jpg', 'images/stories/virtuemart/category/resized/cat25_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:22', 0, '0000-00-00 00:00:00', 0),
(2025, 1, 'category26.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat26.jpg', 'images/stories/virtuemart/category/resized/cat26_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:29:21', 0, '0000-00-00 00:00:00', 0),
(2026, 1, 'category27.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat27.jpg', 'images/stories/virtuemart/category/resized/cat27_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:36:08', 0, '0000-00-00 00:00:00', 0),
(2027, 1, 'category28.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat28.jpg', 'images/stories/virtuemart/category/resized/cat28_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-10 07:36:04', 0, '0000-00-00 00:00:00', 0),
(2028, 1, 'category29.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat29.jpg', 'images/stories/virtuemart/category/resized/cat29_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:19', 0, '0000-00-00 00:00:00', 0),
(2029, 1, 'categoryt30.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat30.jpg', 'images/stories/virtuemart/category/resized/cat30_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:16', 0, '0000-00-00 00:00:00', 0),
(2030, 1, 'category31.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat31.jpg', 'images/stories/virtuemart/category/resized/cat13_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:13', 0, '0000-00-00 00:00:00', 0),
(2031, 1, 'category32.jpg', '', '', '', 'image/jpeg', 'category', 'images/stories/virtuemart/category/cat32.jpg', 'images/stories/virtuemart/category/resized/cat32_resized.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:30:09', 0, '0000-00-00 00:00:00', 0),
(2032, 1, 'washupito6.gif', '', '', '', 'image/gif', 'vendor', 'images/stories/virtuemart/vendor/washupito6.gif', 'images/stories/virtuemart/vendor/resized/washupito6_280x280.gif', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '2013-08-06 20:19:43', 0, '0000-00-00 00:00:00', 0),
(2033, 1, 'vendor6.gif', '', '', '', 'image/gif', 'vendor', 'images/stories/virtuemart/vendor/vendor6.gif', '', 0, 0, 0, '', '', 0, 0, 1, '2013-08-21 19:58:55', 0, '2013-08-23 11:12:38', 0, '0000-00-00 00:00:00', 0),
(2034, 1, 'product0995.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product0995.jpg', '', 0, 0, 0, '', '', 0, 0, 1, '2013-09-01 14:21:58', 0, '2015-03-12 17:32:13', 0, '0000-00-00 00:00:00', 0),
(2035, 1, 'product1064.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product1064.jpg', '', 0, 0, 0, '', '', 0, 0, 1, '2013-09-01 14:22:32', 0, '2015-03-12 17:32:26', 0, '0000-00-00 00:00:00', 0),
(2036, 1, 'product1167.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product1167.jpg', '', 0, 0, 0, '', '', 0, 0, 1, '2013-09-01 14:22:50', 0, '2015-03-12 17:32:29', 0, '0000-00-00 00:00:00', 0),
(2037, 1, 'product1219.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product1219.jpg', '', 0, 0, 0, '', '', 0, 0, 1, '2013-09-01 14:23:09', 0, '2015-03-12 17:32:34', 0, '0000-00-00 00:00:00', 0),
(2038, 1, 'product2368.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/product2368.jpg', '', 0, 0, 0, '', '', 0, 0, 1, '2013-09-01 14:23:40', 0, '2014-01-26 22:11:53', 0, '0000-00-00 00:00:00', 0),
(2039, 1, 'vendor1.gif', '', '', '', 'image/gif', 'vendor', 'images/stories/virtuemart/vendor/vendor1.gif', '', 0, 0, 0, '', '', 0, 0, 1, '2013-09-02 18:19:12', 0, '2015-10-21 18:42:43', 0, '0000-00-00 00:00:00', 0),
(2040, 1, 'product2882.jpg', '', '', '', '', 'product', 'images/stories/virtuemart/product/product2882.jpg', '', 1, 0, 0, '', '', 0, 0, 1, '2013-09-15 14:04:13', 0, '2013-09-15 14:04:13', 0, '0000-00-00 00:00:00', 0),
(2041, 1, 'product1848.jpg', '', '', '', '', 'product', 'images/stories/virtuemart/product/product1848.jpg', '', 1, 0, 0, '', '', 0, 0, 1, '2013-09-15 14:04:13', 0, '2013-09-15 14:04:13', 0, '0000-00-00 00:00:00', 0),
(2042, 1, 'product2475.jpg', '', '', '', '', 'product', 'images/stories/virtuemart/product/product2475.jpg', '', 1, 0, 0, '', '', 0, 0, 1, '2013-09-15 14:04:13', 0, '2013-09-15 14:04:13', 0, '0000-00-00 00:00:00', 0),
(2043, 1, 'product3357.jpg', '', '', '', '', 'product', 'images/stories/virtuemart/product/product3357.jpg', '', 1, 0, 0, '', '', 0, 0, 1, '2013-09-15 14:04:13', 0, '2013-09-15 14:04:13', 0, '0000-00-00 00:00:00', 0),
(2044, 1, 'product3524.jpg', '', '', '', '', 'product', 'images/stories/virtuemart/product/product3524.jpg', '', 1, 0, 0, '', '', 0, 0, 1, '2013-09-15 14:04:13', 0, '2013-09-15 14:04:13', 0, '0000-00-00 00:00:00', 0),
(2045, 1, 'product3611.jpg', '', '', '', '', 'product', 'images/stories/virtuemart/product/product3611.jpg', '', 1, 0, 0, '', '', 0, 0, 1, '2013-09-15 14:04:13', 0, '2013-09-15 14:04:13', 0, '0000-00-00 00:00:00', 0),
(2046, 1, 'Копия product 01.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/Копия product 01.jpg', 'images/stories/virtuemart/product/resized/Копия product 01_280x280.jpg', 0, 0, 0, '', 'de-DE,en-GB,fr-FR,he-IL,it-IT,ru-RU', 0, 0, 1, '2015-12-04 20:24:55', 0, '2015-12-11 18:01:13', 0, '0000-00-00 00:00:00', 0),
(2047, 1, '1449260763406.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/1449260763406.jpg', 'images/stories/virtuemart/product/resized/1449260763406_280x280.jpg', 0, 0, 0, '', 'de-DE,en-GB,fr-FR,he-IL,it-IT,ru-RU', 0, 0, 1, '0000-00-00 00:00:00', 0, '2015-12-04 20:30:52', 0, '0000-00-00 00:00:00', 0),
(2049, 1, 'Копия product 01.jpg_product', '', '', '', 'image/png', 'product', 'images/stories/virtuemart/product/6788339014.png', '', 0, 0, 0, '', 'de-DE,en-GB,fr-FR,he-IL,it-IT,ru-RU', 0, 0, 1, '2015-12-11 18:01:25', 0, '2016-01-24 18:03:52', 0, '0000-00-00 00:00:00', 0),
(2050, 1, '1453658643782.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/1453658643782.jpg', 'images/stories/virtuemart/product/resized/1453658643782.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(2051, 1, '1453658643760.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/1453658643760.jpg', 'images/stories/virtuemart/product/resized/1453658643760.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(2052, 1, '1453658643429.jpg', '', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/1453658643429.jpg', 'images/stories/virtuemart/product/resized/1453658643429.jpg', 0, 0, 0, '', '', 0, 0, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(2053, 1, 'product27.jpg_product', 'product27', '', '', 'image/jpeg', 'product', 'images/stories/virtuemart/product/1.jpg', '', 0, 0, 0, '', '', 0, 0, 1, '2017-07-31 19:42:06', 977, '2017-07-31 19:57:41', 977, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_migration_oldtonew_ids`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_migration_oldtonew_ids` (
  `attributes` longblob DEFAULT NULL,
  `relatedproducts` longblob DEFAULT NULL,
  `id` smallint(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `cats` longblob DEFAULT NULL,
  `catsxref` blob DEFAULT NULL,
  `manus` longblob DEFAULT NULL,
  `mfcats` blob DEFAULT NULL,
  `shoppergroups` longblob DEFAULT NULL,
  `products` longblob DEFAULT NULL,
  `products_start` int(1) DEFAULT NULL,
  `orderstates` blob DEFAULT NULL,
  `orders` longblob DEFAULT NULL,
  `orders_start` int(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='xref table for vm1 ids to vm2 ids';

INSERT INTO `#__virtuemart_migration_oldtonew_ids` (`attributes`, `relatedproducts`, `id`, `cats`, `catsxref`, `manus`, `mfcats`, `shoppergroups`, `products`, `products_start`, `orderstates`, `orders`, `orders_start`) VALUES
(NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

DROP TABLE IF EXISTS `#__virtuemart_modules`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_modules` (
  `module_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `module_name` char(255) DEFAULT NULL,
  `module_description` varchar(15359) DEFAULT NULL,
  `module_perms` char(255) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `is_admin` enum('0','1') NOT NULL DEFAULT '0',
  `ordering` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`module_id`),
  KEY `module_name` (`module_name`),
  KEY `ordering` (`ordering`),
  KEY `published` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='VirtueMart Core Modules, not: Joomla modules';

INSERT INTO `#__virtuemart_modules` (`module_id`, `module_name`, `module_description`, `module_perms`, `published`, `is_admin`, `ordering`) VALUES
(1, 'product', 'Here you can administer your online catalog of products.  Categories , Products (view=product), Attributes  ,Product Types      Product Files (view=media), Inventory  , Calculation Rules ,Customer Reviews  ', 'storeadmin,admin', 1, '1', 1),
(2, 'order', 'View Order and Update Order Status:    Orders , Coupons , Revenue Report ,Shopper , Shopper Groups ', 'admin,storeadmin', 1, '1', 2),
(3, 'manufacturer', 'Manage the manufacturers of products in your store.', 'storeadmin,admin', 1, '1', 3),
(4, 'store', 'Store Configuration: Store Information, Payment Methods , Shipment, Shipment Rates', 'storeadmin,admin', 1, '1', 4),
(5, 'configuration', 'Configuration: shop configuration , currencies (view=currency), Credit Card List, Countries, userfields, order status  ', 'admin,storeadmin', 1, '1', 5),
(6, 'msgs', 'This module is unprotected an used for displaying system messages to users.  We need to have an area that does not require authorization when things go wrong.', 'none', 0, '0', 99),
(7, 'shop', 'This is the Washupito store module.  This is the demo store included with the VirtueMart distribution.', 'none', 1, '0', 99),
(8, 'store', 'Store Configuration: Store Information, Payment Methods , Shipment, Shipment Rates', 'storeadmin,admin', 1, '1', 4),
(9, 'account', 'This module allows shoppers to update their account information and view previously placed orders.', 'shopper,storeadmin,admin,demo', 1, '0', 99),
(10, 'checkout', '', 'none', 0, '0', 99),
(11, 'tools', 'Tools', 'admin', 1, '1', 8),
(13, 'zone', 'This is the zone-shipment module. Here you can manage your shipment costs according to Zones.', 'admin,storeadmin', 0, '1', 11);

DROP TABLE IF EXISTS `#__virtuemart_orders`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_orders` (
  `order_billTax` varchar(400) DEFAULT NULL,
  `virtuemart_order_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_user_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `order_number` varchar(64) DEFAULT NULL,
  `customer_number` varchar(32) DEFAULT NULL,
  `order_pass` varchar(34) DEFAULT NULL,
  `order_create_invoice_pass` varchar(32) DEFAULT NULL,
  `invoice_locked` tinyint(1) NOT NULL DEFAULT 0,
  `order_total` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `order_salesPrice` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `order_billTaxAmount` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `order_billDiscountAmount` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `order_discountAmount` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `order_subtotal` decimal(15,5) DEFAULT NULL,
  `order_tax` decimal(12,5) DEFAULT NULL,
  `order_shipment` decimal(12,5) DEFAULT NULL,
  `order_shipment_tax` decimal(10,5) DEFAULT NULL,
  `order_payment` decimal(12,2) DEFAULT NULL,
  `order_payment_tax` decimal(10,5) DEFAULT NULL,
  `coupon_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `coupon_code` varchar(32) DEFAULT NULL,
  `order_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `order_currency` smallint(1) DEFAULT NULL,
  `order_status` char(1) DEFAULT NULL,
  `user_currency_id` smallint(1) DEFAULT NULL,
  `user_currency_rate` decimal(12,6) NOT NULL DEFAULT 1.000000,
  `user_shoppergroups` varchar(30) DEFAULT NULL,
  `payment_currency_id` smallint(1) DEFAULT NULL,
  `payment_currency_rate` decimal(12,6) NOT NULL DEFAULT 1.000000,
  `virtuemart_paymentmethod_id` int(1) UNSIGNED DEFAULT NULL,
  `virtuemart_shipmentmethod_id` int(1) UNSIGNED DEFAULT NULL,
  `oc_note` varchar(20000) NOT NULL DEFAULT '' COMMENT 'old customer notes',
  `delivery_date` varchar(200) DEFAULT NULL,
  `order_language` varchar(7) DEFAULT NULL,
  `ip_address` char(15) NOT NULL DEFAULT '',
  `STsameAsBT` tinyint(1) NOT NULL DEFAULT 0,
  `paid` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `paid_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `o_hash` varchar(33) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_order_id`),
  KEY `virtuemart_user_id` (`virtuemart_user_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `order_number` (`order_number`),
  KEY `virtuemart_paymentmethod_id` (`virtuemart_paymentmethod_id`),
  KEY `virtuemart_shipmentmethod_id` (`virtuemart_shipmentmethod_id`),
  KEY `created_on` (`created_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Used to store all orders';

DROP TABLE IF EXISTS `#__virtuemart_orderstates`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_orderstates` (
  `virtuemart_orderstate_id` tinyint(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1,
  `order_status_code` char(1) NOT NULL DEFAULT '',
  `order_status_name` varchar(64) DEFAULT NULL,
  `order_status_color` varchar(64) DEFAULT NULL,
  `order_status_description` varchar(15359) DEFAULT NULL,
  `order_stock_handle` char(1) NOT NULL DEFAULT 'A',
  `ordering` int(1) NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_orderstate_id`),
  KEY `ordering` (`ordering`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `published` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='All available order statuses';

INSERT INTO `#__virtuemart_orderstates` (`virtuemart_orderstate_id`, `virtuemart_vendor_id`, `order_status_code`, `order_status_name`, `order_status_color`, `order_status_description`, `order_stock_handle`, `ordering`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 1, 'P', 'COM_VIRTUEMART_ORDER_STATUS_PENDING', NULL, '', 'R', 1, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(2, 1, 'U', 'COM_VIRTUEMART_ORDER_STATUS_CONFIRMED_BY_SHOPPER', NULL, '', 'R', 2, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(3, 1, 'C', 'COM_VIRTUEMART_ORDER_STATUS_CONFIRMED', NULL, '', 'R', 3, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(4, 1, 'X', 'COM_VIRTUEMART_ORDER_STATUS_CANCELLED', NULL, '', 'A', 4, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(5, 1, 'R', 'COM_VIRTUEMART_ORDER_STATUS_REFUNDED', NULL, '', 'A', 5, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(6, 1, 'S', 'COM_VIRTUEMART_ORDER_STATUS_SHIPPED', NULL, '', 'O', 6, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(7, 1, 'F', 'COM_VIRTUEMART_ORDER_STATUS_COMPLETED', NULL, '', 'R', 7, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0),
(8, 1, 'D', 'COM_VIRTUEMART_ORDER_STATUS_DENIED', NULL, '', 'A', 8, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_order_calc_rules`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_order_calc_rules` (
  `virtuemart_order_calc_rule_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_calc_id` int(1) UNSIGNED DEFAULT NULL,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1,
  `virtuemart_order_item_id` int(1) DEFAULT NULL,
  `calc_rule_name` varchar(64) NOT NULL DEFAULT '' COMMENT 'NAME OF THE RULE',
  `calc_kind` varchar(16) NOT NULL DEFAULT '' COMMENT 'DISCOUNT/TAX/MARGIN/COMMISSION',
  `calc_mathop` varchar(16) NOT NULL DEFAULT '' COMMENT 'DISCOUNT/TAX/MARGIN/COMMISSION',
  `calc_result` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `calc_amount` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `calc_value` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `calc_currency` int(1) DEFAULT NULL,
  `calc_params` varchar(15359) NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_order_calc_rule_id`),
  KEY `virtuemart_calc_id` (`virtuemart_calc_id`),
  KEY `virtuemart_order_id` (`virtuemart_order_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=176 DEFAULT CHARSET=utf8 COMMENT='Stores all calculation rules which are part of an order';

DROP TABLE IF EXISTS `#__virtuemart_order_histories`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_order_histories` (
  `virtuemart_order_history_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `order_status_code` char(1) NOT NULL DEFAULT '0',
  `customer_notified` tinyint(1) NOT NULL DEFAULT 0,
  `comments` varchar(15359) DEFAULT NULL,
  `paid` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `o_hash` varchar(33) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_order_history_id`),
  KEY `virtuemart_order_id` (`virtuemart_order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all actions and changes that occur to an order';

DROP TABLE IF EXISTS `#__virtuemart_order_items`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_order_items` (
  `virtuemart_order_item_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1,
  `virtuemart_product_id` int(1) DEFAULT NULL,
  `order_item_sku` varchar(255) NOT NULL DEFAULT '',
  `delivery_date` varchar(200) DEFAULT NULL,
  `paid` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `oi_hash` varchar(33) DEFAULT NULL,
  `product_discountedPriceWithoutTax` decimal(15,5) DEFAULT NULL,
  `product_priceWithoutTax` decimal(15,5) DEFAULT NULL,
  `order_item_name` varchar(4096) NOT NULL DEFAULT '',
  `product_quantity` int(1) DEFAULT NULL,
  `product_item_price` decimal(15,5) DEFAULT NULL,
  `product_tax` decimal(15,5) DEFAULT NULL,
  `product_basePriceWithTax` decimal(15,5) DEFAULT NULL,
  `product_final_price` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `product_subtotal_discount` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `product_subtotal_with_tax` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `order_item_currency` int(1) DEFAULT NULL,
  `order_status` char(1) DEFAULT NULL,
  `product_attribute` mediumtext DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_order_item_id`),
  KEY `virtuemart_product_id` (`virtuemart_product_id`),
  KEY `virtuemart_order_id` (`virtuemart_order_id`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `order_status` (`order_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all items (products) which are part of an order';

DROP TABLE IF EXISTS `#__virtuemart_order_item_histories`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_order_item_histories` (
  `virtuemart_order_item_history_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_item_id` int(1) UNSIGNED NOT NULL,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1,
  `virtuemart_product_id` int(1) DEFAULT NULL,
  `action` varchar(255) NOT NULL DEFAULT '',
  `order_item_sku` varchar(255) NOT NULL DEFAULT '',
  `order_item_name` varchar(4096) NOT NULL DEFAULT '',
  `product_quantity` int(1) DEFAULT NULL,
  `product_item_price` decimal(15,5) DEFAULT NULL,
  `product_priceWithoutTax` decimal(15,5) DEFAULT NULL,
  `product_tax` decimal(15,5) DEFAULT NULL,
  `product_basePriceWithTax` decimal(15,5) DEFAULT NULL,
  `product_discountedPriceWithoutTax` decimal(15,5) DEFAULT NULL,
  `product_final_price` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `product_subtotal_discount` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `product_subtotal_with_tax` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `order_item_currency` int(1) DEFAULT NULL,
  `order_status` char(1) DEFAULT NULL,
  `product_attribute` mediumtext DEFAULT NULL,
  `delivery_date` varchar(200) DEFAULT NULL,
  `paid` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `oi_hash` varchar(33) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_order_item_history_id`),
  KEY `virtuemart_order_id` (`virtuemart_order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores all actions and changes that occur to an order item only';

DROP TABLE IF EXISTS `#__virtuemart_order_userinfos`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_order_userinfos` (
  `virtuemart_order_userinfo_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_user_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `address_type` char(2) DEFAULT NULL,
  `address_type_name` char(32) DEFAULT NULL,
  `company` char(64) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `last_name` char(48) DEFAULT NULL,
  `first_name` char(48) DEFAULT NULL,
  `middle_name` varchar(255) DEFAULT NULL,
  `phone_1` char(32) DEFAULT NULL,
  `phone_2` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `address_1` char(64) NOT NULL DEFAULT '',
  `address_2` varchar(255) DEFAULT NULL,
  `city` char(64) NOT NULL DEFAULT '',
  `virtuemart_state_id` smallint(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_country_id` smallint(1) UNSIGNED NOT NULL DEFAULT 0,
  `zip` char(16) NOT NULL DEFAULT '',
  `email` char(128) DEFAULT NULL,
  `agreed` tinyint(1) NOT NULL DEFAULT 0,
  `tos` tinyint(1) NOT NULL DEFAULT 0,
  `customer_note` varchar(2500) NOT NULL DEFAULT '',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  `opc_vat` varchar(255) DEFAULT NULL,
  `opc_vat_info` varchar(255) DEFAULT NULL,
  `data` date DEFAULT NULL,
  PRIMARY KEY (`virtuemart_order_userinfo_id`),
  KEY `virtuemart_order_id` (`virtuemart_order_id`),
  KEY `virtuemart_user_id` (`virtuemart_user_id`,`address_type`),
  KEY `address_type` (`address_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the BillTo and ShipTo Information at order time';

DROP TABLE IF EXISTS `#__virtuemart_paymentmethods`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_paymentmethods` (
  `virtuemart_paymentmethod_id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_vendor_id` int(1) UNSIGNED NOT NULL DEFAULT 1,
  `payment_jplugin_id` int(1) NOT NULL DEFAULT 0,
  `payment_element` varchar(50) NOT NULL DEFAULT '',
  `payment_params` text DEFAULT NULL,
  `slug` char(255) NOT NULL DEFAULT '',
  `currency_id` int(1) UNSIGNED DEFAULT NULL,
  `shared` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'valide for all vendors?',
  `ordering` int(1) NOT NULL DEFAULT 0,
  `published` tinyint(1) NOT NULL DEFAULT 1,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(1) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(1) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`virtuemart_paymentmethod_id`),
  KEY `payment_jplugin_id` (`payment_jplugin_id`),
  KEY `ordering` (`ordering`),
  KEY `virtuemart_vendor_id` (`virtuemart_vendor_id`),
  KEY `payment_element` (`payment_element`,`virtuemart_vendor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='The payment methods of your store';

INSERT INTO `#__virtuemart_paymentmethods` (`virtuemart_paymentmethod_id`, `virtuemart_vendor_id`, `payment_jplugin_id`, `payment_element`, `payment_params`, `slug`, `currency_id`, `shared`, `ordering`, `published`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
(1, 1, 10012, 'standard', 'payment_currency=\"0\"|status_pending=\"U\"|send_invoice_on_order_null=\"1\"|payment_logos=\"\"|payment_info=\"lorem ipsum dolor\"|countries=\"\"|min_amount=\"\"|max_amount=\"\"|cost_per_transaction=\"\"|cost_percent_total=\"5\"|tax_id=\"1\"|', '', NULL, 0, 1, 1, '0000-00-00 00:00:00', 0, '2015-03-12 17:37:16', 179, '0000-00-00 00:00:00', 0),
(3, 1, 10024, 'authorizenet', 'hostname=\"https:\\/\\/secure.authorize.net\\/gateway\\/transact.dll\"|login_id=\"\"|transaction_key=\"\"|secure_post=\"0\"|sandbox=\"0\"|sandbox_hostname=\"https:\\/\\/test.authorize.net\\/gateway\\/transact.dll\"|sandbox_login_id=\"\"|sandbox_transaction_key=\"\"|xtype=\"AUTH_CAPTURE\"|creditcards=\"\"|payment_approved_status=\"C\"|payment_declined_status=\"X\"|payment_held_status=\"P\"|payment_logos=\"\"|cvv_images=\"\"|countries=\"\"|min_amount=\"\"|max_amount=\"\"|cost_per_transaction=\"\"|cost_percent_total=\"\"|tax_id=\"0\"|debug=\"0\"|log=\"0\"|', '', NULL, 0, 2, 1, '2013-11-05 19:04:04', 0, '2015-03-12 17:37:12', 179, '0000-00-00 00:00:00', 0);

DROP TABLE IF EXISTS `#__virtuemart_paymentmethods_de_de`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_paymentmethods_de_de` (
  `virtuemart_paymentmethod_id` int(1) UNSIGNED NOT NULL,
  `payment_name` varchar(180) NOT NULL DEFAULT '',
  `payment_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_paymentmethod_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_paymentmethods_de_de` (`virtuemart_paymentmethod_id`, `payment_name`, `payment_desc`, `slug`) VALUES
(1, 'Payment Method', 'Payment Method', 'payment-method');

DROP TABLE IF EXISTS `#__virtuemart_paymentmethods_en_gb`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_paymentmethods_en_gb` (
  `virtuemart_paymentmethod_id` int(1) UNSIGNED NOT NULL,
  `payment_name` varchar(180) NOT NULL DEFAULT '',
  `payment_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_paymentmethod_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_paymentmethods_en_gb` (`virtuemart_paymentmethod_id`, `payment_name`, `payment_desc`, `slug`) VALUES
(1, 'Payment Method', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p>', 'payment-method'),
(3, 'Payment Name 2', 'Payment Description', 'payment-name-2');

DROP TABLE IF EXISTS `#__virtuemart_paymentmethods_es_es`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_paymentmethods_es_es` (
  `virtuemart_paymentmethod_id` int(1) UNSIGNED NOT NULL,
  `payment_name` char(180) NOT NULL DEFAULT '',
  `payment_desc` varchar(20000) NOT NULL DEFAULT '',
  `slug` char(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_paymentmethod_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__virtuemart_paymentmethods_fr_fr`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_paymentmethods_fr_fr` (
  `virtuemart_paymentmethod_id` int(1) UNSIGNED NOT NULL,
  `payment_name` varchar(180) NOT NULL DEFAULT '',
  `payment_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_paymentmethod_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_paymentmethods_fr_fr` (`virtuemart_paymentmethod_id`, `payment_name`, `payment_desc`, `slug`) VALUES
(1, 'Payment Method', 'Payment Method', 'payment-method');

DROP TABLE IF EXISTS `#__virtuemart_paymentmethods_he_il`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_paymentmethods_he_il` (
  `virtuemart_paymentmethod_id` int(1) UNSIGNED NOT NULL,
  `payment_name` varchar(180) NOT NULL DEFAULT '',
  `payment_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_paymentmethod_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_paymentmethods_he_il` (`virtuemart_paymentmethod_id`, `payment_name`, `payment_desc`, `slug`) VALUES
(1, 'Payment Method', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p>', 'payment-method');

DROP TABLE IF EXISTS `#__virtuemart_paymentmethods_it_it`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_paymentmethods_it_it` (
  `virtuemart_paymentmethod_id` int(1) UNSIGNED NOT NULL,
  `payment_name` varchar(180) NOT NULL DEFAULT '',
  `payment_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_paymentmethod_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_paymentmethods_it_it` (`virtuemart_paymentmethod_id`, `payment_name`, `payment_desc`, `slug`) VALUES
(1, 'Payment Method', 'Payment Method', 'payment-method');

DROP TABLE IF EXISTS `#__virtuemart_paymentmethods_ru_ru`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_paymentmethods_ru_ru` (
  `virtuemart_paymentmethod_id` int(1) UNSIGNED NOT NULL,
  `payment_name` varchar(180) NOT NULL DEFAULT '',
  `payment_desc` varchar(19000) NOT NULL DEFAULT '',
  `slug` varchar(192) NOT NULL DEFAULT '',
  PRIMARY KEY (`virtuemart_paymentmethod_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `#__virtuemart_paymentmethods_ru_ru` (`virtuemart_paymentmethod_id`, `payment_name`, `payment_desc`, `slug`) VALUES
(1, 'Payment Method', 'Payment Method', 'payment-method');

DROP TABLE IF EXISTS `#__virtuemart_paymentmethod_shoppergroups`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_paymentmethod_shoppergroups` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_paymentmethod_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  `virtuemart_shoppergroup_id` int(1) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `virtuemart_paymentmethod_id` (`virtuemart_paymentmethod_id`,`virtuemart_shoppergroup_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='xref table for paymentmethods to shoppergroup';

INSERT INTO `#__virtuemart_paymentmethod_shoppergroups` (`id`, `virtuemart_paymentmethod_id`, `virtuemart_shoppergroup_id`) VALUES
(5, 2, 1),
(6, 2, 2),
(7, 2, 3),
(8, 2, 4),
(9, 3, 1),
(10, 3, 2),
(11, 3, 3),
(12, 3, 4),
(13, 1, 1),
(14, 1, 2),
(15, 1, 3),
(16, 1, 4);

DROP TABLE IF EXISTS `#__virtuemart_payment_plg_authorizenet`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_payment_plg_authorizenet` (
  `payment_order_total` decimal(15,5) NOT NULL,
  `payment_currency` smallint(1) DEFAULT NULL,
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `order_number` char(64) DEFAULT NULL,
  `virtuemart_paymentmethod_id` mediumint(1) UNSIGNED DEFAULT NULL,
  `payment_name` varchar(5000) DEFAULT NULL,
  `return_context` char(255) DEFAULT NULL,
  `cost_per_transaction` decimal(10,2) DEFAULT NULL,
  `cost_percent_total` char(10) DEFAULT NULL,
  `tax_id` smallint(1) DEFAULT NULL,
  `authorizenet_response_authorization_code` char(10) DEFAULT NULL,
  `authorizenet_response_transaction_id` char(128) DEFAULT NULL,
  `authorizenet_response_response_code` char(128) DEFAULT NULL,
  `authorizenet_response_response_subcode` char(13) DEFAULT NULL,
  `authorizenet_response_response_reason_code` decimal(10,2) DEFAULT NULL,
  `authorizenet_response_response_reason_text` text DEFAULT NULL,
  `authorizenet_response_transaction_type` char(50) DEFAULT NULL,
  `authorizenet_response_account_number` char(4) DEFAULT NULL,
  `authorizenet_response_card_type` char(128) DEFAULT NULL,
  `authorizenet_response_card_code_response` char(5) DEFAULT NULL,
  `authorizenet_response_cavv_response` char(1) DEFAULT NULL,
  `authorizeresponse_raw` text DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Payment AuthorizeNet Table';

DROP TABLE IF EXISTS `#__virtuemart_payment_plg_heidelpay`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_payment_plg_heidelpay` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `order_number` char(64) DEFAULT NULL,
  `virtuemart_paymentmethod_id` mediumint(1) UNSIGNED DEFAULT NULL,
  `unique_id` varchar(48) DEFAULT NULL,
  `short_id` varchar(14) DEFAULT NULL,
  `payment_code` varchar(32) DEFAULT NULL,
  `comment` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `payment_methode` char(2) DEFAULT NULL,
  `payment_type` char(2) DEFAULT NULL,
  `transaction_mode` char(18) DEFAULT NULL,
  `payment_name` char(50) DEFAULT NULL,
  `processing_result` char(3) DEFAULT NULL,
  `secret_hash` char(50) DEFAULT NULL,
  `response_ip` char(20) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Payment Heidelpay';

DROP TABLE IF EXISTS `#__virtuemart_payment_plg_moneybookers_acc`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_payment_plg_moneybookers_acc` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `order_number` char(64) DEFAULT NULL,
  `virtuemart_paymentmethod_id` mediumint(1) UNSIGNED DEFAULT NULL,
  `payment_name` varchar(5000) DEFAULT NULL,
  `payment_order_total` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `payment_currency` char(3) DEFAULT NULL,
  `cost_per_transaction` decimal(10,2) DEFAULT NULL,
  `cost_percent_total` decimal(10,2) DEFAULT NULL,
  `tax_id` smallint(1) DEFAULT NULL,
  `user_session` varchar(255) DEFAULT NULL,
  `mb_pay_to_email` varchar(50) DEFAULT NULL,
  `mb_pay_from_email` varchar(50) DEFAULT NULL,
  `mb_merchant_id` int(10) UNSIGNED DEFAULT NULL,
  `mb_transaction_id` varchar(15) DEFAULT NULL,
  `mb_rec_payment_id` int(10) UNSIGNED DEFAULT NULL,
  `mb_rec_payment_type` varchar(16) DEFAULT NULL,
  `mb_amount` decimal(19,2) DEFAULT NULL,
  `mb_currency` char(3) DEFAULT NULL,
  `mb_status` tinyint(1) DEFAULT NULL,
  `mb_md5sig` char(32) DEFAULT NULL,
  `mb_sha2sig` char(64) DEFAULT NULL,
  `mbresponse_raw` varchar(512) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Payment Moneybookers Table';

DROP TABLE IF EXISTS `#__virtuemart_payment_plg_paypal`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_payment_plg_paypal` (
  `paypal_method` varchar(200) DEFAULT NULL,
  `paypal_fullresponse` text DEFAULT NULL,
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `order_number` char(64) DEFAULT NULL,
  `virtuemart_paymentmethod_id` mediumint(1) UNSIGNED DEFAULT NULL,
  `payment_name` varchar(5000) DEFAULT NULL,
  `payment_order_total` decimal(15,5) NOT NULL,
  `payment_currency` smallint(1) DEFAULT NULL,
  `email_currency` smallint(1) DEFAULT NULL,
  `cost_per_transaction` decimal(10,2) DEFAULT NULL,
  `cost_percent_total` decimal(10,2) DEFAULT NULL,
  `tax_id` smallint(1) DEFAULT NULL,
  `paypal_custom` varchar(255) DEFAULT NULL,
  `paypal_response_mc_gross` decimal(10,2) DEFAULT NULL,
  `paypal_response_mc_currency` char(10) DEFAULT NULL,
  `paypal_response_invoice` char(32) DEFAULT NULL,
  `paypal_response_protection_eligibility` char(128) DEFAULT NULL,
  `paypal_response_payer_id` char(13) DEFAULT NULL,
  `paypal_response_tax` decimal(10,2) DEFAULT NULL,
  `paypal_response_payment_date` char(28) DEFAULT NULL,
  `paypal_response_payment_status` char(50) DEFAULT NULL,
  `paypal_response_pending_reason` char(50) DEFAULT NULL,
  `paypal_response_mc_fee` decimal(10,2) DEFAULT NULL,
  `paypal_response_payer_email` char(128) DEFAULT NULL,
  `paypal_response_last_name` char(64) DEFAULT NULL,
  `paypal_response_first_name` char(64) DEFAULT NULL,
  `paypal_response_business` char(128) DEFAULT NULL,
  `paypal_response_receiver_email` char(128) DEFAULT NULL,
  `paypal_response_transaction_subject` char(128) DEFAULT NULL,
  `paypal_response_residence_country` char(2) DEFAULT NULL,
  `paypal_response_txn_id` char(32) DEFAULT NULL,
  `paypal_response_txn_type` char(32) DEFAULT NULL,
  `paypal_response_parent_txn_id` char(32) DEFAULT NULL,
  `paypal_response_case_creation_date` char(32) DEFAULT NULL,
  `paypal_response_case_id` char(32) DEFAULT NULL,
  `paypal_response_case_type` char(32) DEFAULT NULL,
  `paypal_response_reason_code` char(32) DEFAULT NULL,
  `paypalresponse_raw` varchar(512) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Payment Paypal Table';

DROP TABLE IF EXISTS `#__virtuemart_payment_plg_payzen`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_payment_plg_payzen` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `order_number` char(64) DEFAULT NULL,
  `virtuemart_paymentmethod_id` mediumint(1) UNSIGNED DEFAULT NULL,
  `payment_name` varchar(5000) DEFAULT NULL,
  `payment_order_total` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `payment_currency` char(3) DEFAULT NULL,
  `cost_per_transaction` decimal(10,2) DEFAULT NULL,
  `cost_percent_total` decimal(10,2) DEFAULT NULL,
  `tax_id` smallint(1) DEFAULT NULL,
  `payzen_custom` varchar(255) DEFAULT NULL,
  `payzen_response_payment_amount` char(15) DEFAULT NULL,
  `payzen_response_auth_number` char(10) DEFAULT NULL,
  `payzen_response_payment_currency` char(3) DEFAULT NULL,
  `payzen_response_payment_mean` char(255) DEFAULT NULL,
  `payzen_response_payment_date` char(20) DEFAULT NULL,
  `payzen_response_payment_status` char(3) DEFAULT NULL,
  `payzen_response_payment_message` char(255) DEFAULT NULL,
  `payzen_response_card_number` char(50) DEFAULT NULL,
  `payzen_response_trans_id` char(6) DEFAULT NULL,
  `payzen_response_expiry_month` char(2) DEFAULT NULL,
  `payzen_response_expiry_year` char(4) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Payment payzen Table';

DROP TABLE IF EXISTS `#__virtuemart_payment_plg_standard`;
CREATE TABLE IF NOT EXISTS `#__virtuemart_payment_plg_standard` (
  `email_currency` char(3) DEFAULT NULL,
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `virtuemart_order_id` int(1) UNSIGNED DEFAULT NULL,
  `order_number` char(64) DEFAULT NULL,
  `virtuemart_paymentmethod_id` mediumint(1) UNSIGNED DEFAULT NULL,
  `payment_name` varchar(5000) DEFAULT NULL,
  `payment_order_total` decimal(15,5) NOT NULL DEFAULT 0.00000,
  `payment_currency` char(3) DEFAULT NULL,
  `cost_per_transaction` decimal(10,2) DEFAULT NULL,
  `cost_min_transaction` decimal(10,2) DEFAULT NULL,
  `cost_percent_total` decimal(10,2) DEFAULT NULL,
  `tax_id` smallint(1) DEFAULT NULL,
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT 0,
  `modified_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL DEFAULT 0,
  `locked_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `locked_by` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8 COMMENT='Payment Standard Table';

INSERT INTO `#__virtuemart_payment_plg_standard` (`email_currency`, `id`, `virtuemart_order_id`, `order_number`, `virtuemart_paymentmethod_id`, `payment_name`, `payment_order_total`, `payment_currency`, `cost_per_transaction`, `cost_min_transaction`, `cost_percent_total`, `tax_id`, `created_on`, `created_by`, `modified_on`, `modified_by`, `locked_on`, `locked_by`) VALUES
('144', 17, 3, '368004', 1, '<span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\">Payment Method</span><br />', '2625.00000', 'USD', '0.00', NULL, '0.00', 1, '2013-10-15 20:19:44', 0, '2013-10-15 20:19:44', 0, '0000-00-00 00:00:00', 0),
('144', 18, 4, 'ee8905', 1, '<span class=\"vmCartPaymentLogo\" ><img align=\"middle\" src=\"http://localhost/T3Fremework_ver_1_9/images/stories/virtuemart/payment/payment_method.png\"  alt=\"payment_method\" /></span>  <span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p></span><br />lorem ipsum dolor', '263.90000', 'USD', '0.00', NULL, '5.00', 1, '2013-10-23 20:08:23', 0, '2013-10-23 20:08:23', 0, '0000-00-00 00:00:00', 0),
('144', 19, 5, 'd4d306', 1, '<span class=\"vmCartPaymentLogo\" ><img align=\"middle\" src=\"http://localhost/T3Fremework_ver_1_9/images/stories/virtuemart/payment/payment_method.png\"  alt=\"payment_method\" /></span>  <span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p></span><br />lorem ipsum dolor', '420.11000', 'USD', '0.00', NULL, '5.00', 1, '2013-11-10 19:54:30', 0, '2013-11-10 19:54:30', 0, '0000-00-00 00:00:00', 0),
('144', 20, 6, '301007', 1, '<span class=\"vmCartPaymentLogo\" ><img align=\"middle\" src=\"http://localhost/T3Fremework_ver_1_9/images/stories/virtuemart/payment/payment_method.png\"  alt=\"payment_method\" /></span>  <span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p></span><br />lorem ipsum dolor', '297.83000', 'USD', '0.00', NULL, '5.00', 1, '2013-11-10 20:04:49', 431, '2013-11-10 20:04:49', 431, '0000-00-00 00:00:00', 0),
('144', 21, 7, '951e08', 1, '<span class=\"vmCartPaymentLogo\" ><img align=\"middle\" src=\"http://localhost/T3Fremework_ver_1_9/images/stories/virtuemart/payment/payment_method.png\"  alt=\"payment_method\" /></span>  <span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p></span><br />lorem ipsum dolor', '196.78000', 'USD', '0.00', NULL, '5.00', 1, '2013-11-13 19:03:05', 0, '2013-11-13 19:03:05', 0, '0000-00-00 00:00:00', 0),
('144', 22, 9, '1457010', 1, '<span class=\"vmCartPaymentLogo\" ><img align=\"middle\" src=\"http://localhost/T3Fremework_ver_1_9/images/stories/virtuemart/payment/payment_method.png\"  alt=\"payment_method\" /></span>  <span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p></span><br />lorem ipsum dolor', '167.32000', 'USD', '0.00', NULL, '5.00', 1, '2013-11-13 19:07:15', 0, '2013-11-13 19:07:15', 0, '0000-00-00 00:00:00', 0),
('144', 23, 10, 'f397011', 1, '<span class=\"vmCartPaymentLogo\" ><img align=\"middle\" src=\"http://localhost/T3Fremework_ver_1_9/images/stories/virtuemart/payment/payment_method.png\"  alt=\"payment_method\" /></span>  <span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p></span><br />lorem ipsum dolor', '303.15000', 'USD', '0.00', NULL, '5.00', 1, '2013-11-13 19:11:43', 0, '2013-11-13 19:11:43', 0, '0000-00-00 00:00:00', 0),
('144', 25, 3, '076704', 1, '<span class=\"vmCartPaymentLogo\" ><img align=\"middle\" src=\"http://localhost/T3Fremework_ver_2_2/images/stories/virtuemart/payment/payment_method.png\"  alt=\"payment_method\" /></span>  <span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p></span><br />lorem ipsum dolor', '167.32000', 'USD', '0.00', NULL, '5.00', 1, '2013-12-23 20:26:53', 0, '2013-12-23 20:26:53', 0, '0000-00-00 00:00:00', 0),
('144', 26, 3, '472103', 1, '<span class=\"vmCartPaymentLogo\" ><img align=\"middle\" src=\"http://localhost/T3Fremework_ver_2_8/images/stories/virtuemart/payment/payment_method.png\"  alt=\"payment_method\" /></span>  <span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p></span><br />lorem ipsum dolor', '141.58000', 'USD', '0.00', NULL, '5.00', 1, '2014-08-25 14:06:49', 0, '2014-08-25 14:06:49', 0, '0000-00-00 00:00:00', 0),
('144', 27, 4, 'a18304', 1, '<span class=\"vmCartPaymentLogo\" ><img align=\"middle\" src=\"http://localhost/T3Fremework_ver_2_8/images/stories/virtuemart/payment/payment_method.png\"  alt=\"payment_method\" /></span>  <span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam aliquet massa et dictum gravida. Suspendisse iaculis neque eu arcu mollis eleifend.</p></span><br />lorem ipsum dolor', '101.05000', 'USD', '0.00', NULL, '5.00', 1, '2014-08-25 15:33:55', 0, '2014-08-25 15:33:55', 0, '0000-00-00 00:00:00', 0),
('144', 28, 5, '570d03', 1, '<span class=\"vmpayment_name\">Payment Method</span><span class=\"vmpayment_description\"><p>Lorem ipsum dolor sit amet, consectetur 