/*
 * Decompiled with CFR 0.152.
 */
package com.uisrael.entity;

import jakarta.annotation.Nonnull;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import lombok.Generated;

@Entity
@Table(name="tbl_inversion")
public class Calculadora {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private int id;
    @NotBlank(message="* El campo nombre no puede estar vac\u00edo.")
    @Pattern(regexp="^[a-zA-Z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1\u00fc\u00dc\\s]+$", message="* El campo nombre solo puede contener letras y espacios.")
    private @NotBlank(message="* El campo nombre no puede estar vac\u00edo.") @Pattern(regexp="^[a-zA-Z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00f1\u00d1\u00fc\u00dc\\s]+$", message="* El campo nombre solo puede contener letras y espacios.") String nombres;
    @NotBlank(message="* La c\u00e9dula no puede estar vac\u00eda.")
    @Pattern(regexp="^[0-9]{10}$", message="* La campo c\u00e9dula debe contener exactamente 10 d\u00edgitos num\u00e9ricos.")
    private @NotBlank(message="* La c\u00e9dula no puede estar vac\u00eda.") @Pattern(regexp="^[0-9]{10}$", message="* La campo c\u00e9dula debe contener exactamente 10 d\u00edgitos num\u00e9ricos.") String cedula;
    @NotBlank(message="* El campoe mail no puede estar vac\u00edo.")
    @Email(message="* Por favor, ingresa un formato de correo electr\u00f3nico v\u00e1lido.")
    private @NotBlank(message="* El campoe mail no puede estar vac\u00edo.") @Email(message="* Por favor, ingresa un formato de correo electr\u00f3nico v\u00e1lido.") String email;
    @NotBlank(message="* El campo celular no puede estar vac\u00edo.")
    @Pattern(regexp="^[0-9]{10}$", message="* El campo celular debe contener exactamente 10 d\u00edgitos num\u00e9ricos.")
    private @NotBlank(message="* El campo celular no puede estar vac\u00edo.") @Pattern(regexp="^[0-9]{10}$", message="* El campo celular debe contener exactamente 10 d\u00edgitos num\u00e9ricos.") String celular;
    @Min(value=100L, message="* El campo capital inicial debe ser igual o mayor a 100 USD.")
    private @Min(value=100L, message="* El campo capital inicial debe ser igual o mayor a 100 USD.") double capital;
    @Nonnull
    private int periodo;
    @Min(value=1L, message="* El campo tiempo debe ser igual o mayor a 1 a\u00f1o.")
    private @Min(value=1L, message="* El campo tiempo debe ser igual o mayor a 1 a\u00f1o.") int tiempo;
    @Nonnull
    private double tasa;
    @Nonnull
    private double monto;
    @Nonnull
    private double interes;
    @Nonnull
    private String categoria;

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getNombres() {
        return this.nombres;
    }

    @Generated
    public String getCedula() {
        return this.cedula;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getCelular() {
        return this.celular;
    }

    @Generated
    public double getCapital() {
        return this.capital;
    }

    @Nonnull
    @Generated
    public int getPeriodo() {
        return this.periodo;
    }

    @Generated
    public int getTiempo() {
        return this.tiempo;
    }

    @Nonnull
    @Generated
    public double getTasa() {
        return this.tasa;
    }

    @Nonnull
    @Generated
    public double getMonto() {
        return this.monto;
    }

    @Nonnull
    @Generated
    public double getInteres() {
        return this.interes;
    }

    @Nonnull
    @Generated
    public String getCategoria() {
        return this.categoria;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setNombres(String nombres) {
        this.nombres = nombres;
    }

    @Generated
    public void setCedula(String cedula) {
        this.cedula = cedula;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setCelular(String celular) {
        this.celular = celular;
    }

    @Generated
    public void setCapital(double capital) {
        this.capital = capital;
    }

    @Generated
    public void setPeriodo(@Nonnull int periodo) {
        this.periodo = periodo;
    }

    @Generated
    public void setTiempo(int tiempo) {
        this.tiempo = tiempo;
    }

    @Generated
    public void setTasa(@Nonnull double tasa) {
        this.tasa = tasa;
    }

    @Generated
    public void setMonto(@Nonnull double monto) {
        this.monto = monto;
    }

    @Generated
    public void setInteres(@Nonnull double interes) {
        this.interes = interes;
    }

    @Generated
    public void setCategoria(@Nonnull String categoria) {
        if (categoria == null) {
            throw new NullPointerException("categoria is marked non-null but is null");
        }
        this.categoria = categoria;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Calculadora)) {
            return false;
        }
        Calculadora other = (Calculadora)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Double.compare(this.getCapital(), other.getCapital()) != 0) {
            return false;
        }
        if (this.getPeriodo() != other.getPeriodo()) {
            return false;
        }
        if (this.getTiempo() != other.getTiempo()) {
            return false;
        }
        if (Double.compare(this.getTasa(), other.getTasa()) != 0) {
            return false;
        }
        if (Double.compare(this.getMonto(), other.getMonto()) != 0) {
            return false;
        }
        if (Double.compare(this.getInteres(), other.getInteres()) != 0) {
            return false;
        }
        String this$nombres = this.getNombres();
        String other$nombres = other.getNombres();
        if (this$nombres == null ? other$nombres != null : !this$nombres.equals(other$nombres)) {
            return false;
        }
        String this$cedula = this.getCedula();
        String other$cedula = other.getCedula();
        if (this$cedula == null ? other$cedula != null : !this$cedula.equals(other$cedula)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$celular = this.getCelular();
        String other$celular = other.getCelular();
        if (this$celular == null ? other$celular != null : !this$celular.equals(other$celular)) {
            return false;
        }
        String this$categoria = this.getCategoria();
        String other$categoria = other.getCategoria();
        return !(this$categoria == null ? other$categoria != null : !this$categoria.equals(other$categoria));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Calculadora;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        long $capital = Double.doubleToLongBits(this.getCapital());
        result = result * 59 + (int)($capital >>> 32 ^ $capital);
        result = result * 59 + this.getPeriodo();
        result = result * 59 + this.getTiempo();
        long $tasa = Double.doubleToLongBits(this.getTasa());
        result = result * 59 + (int)($tasa >>> 32 ^ $tasa);
        long $monto = Double.doubleToLongBits(this.getMonto());
        result = result * 59 + (int)($monto >>> 32 ^ $monto);
        long $interes = Double.doubleToLongBits(this.getInteres());
        result = result * 59 + (int)($interes >>> 32 ^ $interes);
        String $nombres = this.getNombres();
        result = result * 59 + ($nombres == null ? 43 : $nombres.hashCode());
        String $cedula = this.getCedula();
        result = result * 59 + ($cedula == null ? 43 : $cedula.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $celular = this.getCelular();
        result = result * 59 + ($celular == null ? 43 : $celular.hashCode());
        String $categoria = this.getCategoria();
        result = result * 59 + ($categoria == null ? 43 : $categoria.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Calculadora(id=" + this.getId() + ", nombres=" + this.getNombres() + ", cedula=" + this.getCedula() + ", email=" + this.getEmail() + ", celular=" + this.getCelular() + ", capital=" + this.getCapital() + ", periodo=" + this.getPeriodo() + ", tiempo=" + this.getTiempo() + ", tasa=" + this.getTasa() + ", monto=" + this.getMonto() + ", interes=" + this.getInteres() + ", categoria=" + this.getCategoria() + ")";
    }

    @Generated
    public Calculadora(int id, String nombres, String cedula, String email, String celular, double capital, @Nonnull int periodo, int tiempo, @Nonnull double tasa, @Nonnull double monto, @Nonnull double interes, @Nonnull String categoria) {
        if (categoria == null) {
            throw new NullPointerException("categoria is marked non-null but is null");
        }
        this.id = id;
        this.nombres = nombres;
        this.cedula = cedula;
        this.email = email;
        this.celular = celular;
        this.capital = capital;
        this.periodo = periodo;
        this.tiempo = tiempo;
        this.tasa = tasa;
        this.monto = monto;
        this.interes = interes;
        this.categoria = categoria;
    }

    @Generated
    public Calculadora() {
    }
}

